{* Copyright (C) 2002 Free Software Foundation, Inc.
 * Copyright (C) 1995-2002 Walter Koch
 *
 * This file is part of Filespy.
 *
 * Filespy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Filespy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *}


UNIT FS_UTIL;
{$I filespy.inc}


INTERFACE
USES FS_DEF;

PROCEDURE FindFirstSort(sPath: STRING; Attr: Word; var srtHdl: T_SortHandle);
PROCEDURE FindNextSort(var srtHdl: T_SortHandle);
 FUNCTION IsASCII ( VAR buf; offset,n : longint): LongInt;
 FUNCTION GetSensefullTextOffset( p : POINTER; size : longint):Longint;
 FUNCTION fnReadX(VAR hdl:t_File;off : Longint; chStop : CHAR) : STRING;
 FUNCTION fnReadN( VAR hdl:t_File; off, n : Longint) : STRING;
 FUNCTION fnReadLine(VAR hdl:t_File; off : Longint; nMax: WORD) : STRING;
 FUNCTION NRead( VAR hdl:t_File; off : Longint; VAR Buf; len : WORD):longint;
 FUNCTION fnReadByte(VAR hdl:t_File; off: longint) : WORD;
 Function fnReadChar(VAR hdl:t_File; off : Longint) : CHAR;
 Function fnReadWord( VAR hdl:t_File;off : Longint) : WORD;
 Function fnReadWordLE( VAR hdl:t_File;off : Longint) : WORD;
 Function fnReadDWord( VAR hdl:t_File;off: Longint) : longint;
PROCEDURE FindPrevBOL ( VAR pw : Pointer; maxlen : WORD );
 FUNCTION SucheStringinFile(VAR hdl:t_File;
                               startOff,maxSuchLen:LongInt;
                               sMuster:STRING ):LongInt;
 FUNCTION TestForShortDesc(VAR hdl:t_File) : BOOLEAN;
 FUNCTION SearchCopyRight(VAR hdl:t_File):BOOLEAN;
 FUNCTION FileFindOffset ( VAR hdl : T_FILE; offset,caMaxN : Longint;
           {$IFDEF Ver70} CONST {$ENDIF}  sPattern : String ) : longint;
 FUNCTION FileFind ( VAR hdl : T_FILE; caMaxSize : Longint;
           {$IFDEF Ver70} CONST {$ENDIF}  sPattern : String ) : longint;
 FUNCTION IsDirectory(sPath:STRING):BOOLEAN;


{--------------------------------------------------------------------------}
IMPLEMENTATION

USES Fs_DIV,DOS,portpas;


FUNCTION IsASCII ( VAR buf; offset,n : longint): LongInt;
 {Kehrt mit -1 zurck, wenn es reiner ASCII Text ist, ansonten offset, wo FremdText anfngt}
  VAR i : Longint;
      p : ^char;
BEGIN
  isASCII := -1;
  pointer(p) := @buf;
  IncPn(pointer(p),offset);
  i := 1;
  WHILE i<= n DO
    BEGIN
    IF (p^ < ' ') OR (p^ > 'z' ) THEN BEGIN isASCII := i; i:=n; END;
    IncP1(pointer(p)); Inc(i);
    END;
END;


FUNCTION GetSensefullTextOffset( p : POINTER; size : longint):Longint;
{* Sucht in einem Puffer den Anfang eines Sinnvollen Textes *}
  VAR c : CHAR;
      i : Longint;
      fEnd : BOOLEAN;
BEGIN
  GetSensefullTextOffset := 0;
  IF NOT opt.fVerbose THEN Exit;
  i := 0; fEnd := FALSE;
  REPEAT
    c := char(p^);
    IF  ((c>='A') AND (c<='Z'))
     OR ((c>='a') AND (c<='z')) THEN fEnd := TRUE;
    IncP1(p);
    Inc(i);
  UNTIL fEnd OR (i>size);
  IF fEnd THEN GetSensefullTextOffset := i-1;
END;


FUNCTION fnReadX(VAR hdl:t_File;off : Longint; chStop : CHAR) : STRING;
{* Liest solange bis Stopzeichen auftaucht oder der String voll ist*}
  VAR c : CHAR;
      s : STRING;
BEGIN
  Seek(hdl.hExe,off);
  s := '';
  BlockRead(hdl.hExe, c, 1);
  WHILE (c<>chStop) AND (Length(s)<=254) DO
    BEGIN
    s := s+c;
    DoKeyTest;
    BlockRead(hdl.hExe, c, 1);
    END;
  fnReadX := s;
  IF length(s)=255 THEN fnReadX := '';
END;


FUNCTION fnReadN( VAR hdl:t_File; off, n : Longint) : STRING;
  VAR s : STRING;
BEGIN
  Seek(hdl.hExe,off);
  IF n>255 THEN n:=255;
  SetLength(s,n);
  BlockRead(hdl.hExe, s[1], n);
  fnReadN := s;
END;

FUNCTION fnReadLine(VAR hdl:t_File; off : Longint; nMax: WORD) : STRING;
  VAR c : CHAR;
      s : STRING;
BEGIN
  Seek(hdl.hExe,off);
  s := '';
  BlockRead(hdl.hExe, c, sizeof(c));
  WHILE (c<>#0) AND (c<>#13) AND (length(s)<nMax) DO
    BEGIN
    s := s+c;
    BlockRead(hdl.hExe, c, sizeof(c));
    END;
  fnReadLine := s;
END;

FUNCTION NRead( VAR hdl:t_File; off : Longint; VAR Buf; len : WORD):longint;
  VAR Res : Integer;
BEGIN
  Seek(hdl.hExe,off);
  BlockReadWrapper(hdl.hExe, Buf, len, res);
  DoKeyTest;
  IF res=0 THEN InOutRes := 100;
  NRead := res;
END;

FUNCTION fnReadByte(VAR hdl:t_File; off: longint) : WORD;
  VAR b : BYTE;
BEGIN
  Seek(hdl.hExe,off);
  BlockRead(hdl.hExe, b, sizeof(b));
  fnReadByte := b;
END;

Function fnReadChar(VAR hdl:t_File; off : Longint) : CHAR;
  VAR c : Char;
BEGIN
  Seek(hdl.hExe,off);
  BlockRead(hdl.hExe, c, sizeof(c));
  fnReadChar := c;
END;

Function fnReadWord( VAR hdl:t_File;off : Longint) : WORD;
  VAR w : Word;
BEGIN
  Seek(hdl.hExe,off);
  BlockRead(hdl.hExe, w, sizeof(w));
  fnReadWord := w;
END;

Function fnReadWordLE( VAR hdl:t_File;off : Longint) : WORD;
  {* Little Endian - Lesen von file  kw 19.10.98 *}
  VAR w : Word;
BEGIN
  Seek(hdl.hExe,off);
  BlockRead(hdl.hExe, w, sizeof(w));
  fnReadWordLE := Swap(w);
END;


{$I-}
Function fnReadDWord( VAR hdl:t_File;off: Longint) : longint;
  VAR l : Longint;
BEGIN
  Seek(hdl.hExe, off);
  BlockRead(hdl.hExe, l, sizeof(l));
  IF InOutRes>0 THEN l := 0;
  fnReadDWord := l;
END;


FUNCTION FileFindOffset ( VAR hdl : T_FILE; offset,caMaxN : Longint;
           {$IFDEF Ver70} CONST {$ENDIF}  sPattern : String ) : longint;
{* Suche im (offenen) File hdl.hExe ab Offset in den ersten camaxn Bytes nach sPattern
 * Gibt den Offset (0,1,2,3....) zurck wenn gefunden. Sonst -1
 *}
  CONST BuffSize=4096;
  VAR pBuf : Pointer;
      i, validsize,
      resoff : Longint;
BEGIN
  GetMem(pBuf, BuffSize);
  IF offSet < 0 THEN offset := 0;
  IF offSet > hdl.sr.size THEN offset := hdl.sr.size;
  i := offset; resoff := -1;
  caMaxN := Min(hdl.sr.size,caMaxN+offset);
  WHILE (i<=caMaxN) AND (resoff<0) DO
    BEGIN
    FillChar(pBuf^,BuffSize,#0);
    validsize := NRead(hdl, i, pBuf^,BuffSize);
    resoff := MemFind ( pbuf^, validsize, sPattern );
    IF resoff<0 THEN Inc(i,BuffSize-length(sPattern));
    END;
  FreeMem(pBuf, BuffSize);
  IF resoff <0 THEN FILEFindOffset := -1
               ELSE FileFindOffset := resoff+i;
END;

FUNCTION FileFind ( VAR hdl : T_FILE; caMaxSize : Longint;
           {$IFDEF Ver70} CONST {$ENDIF}  sPattern : String ) : longint;
{* Sucht ab FileAnfang, -1 zurck wenn nicht gefinden *}
BEGIN
  FileFind := FileFindOffset ( hdl, 0,caMaxSize, sPattern  );
END;


{---------------------------------------------------------------------------}

PROCEDURE FindPrevBOL ( VAR pw : Pointer; maxlen : WORD );
{- sucht im Speicher ab pw^ rckwrts nach dem Anfang eines Strings, Maximal
 - aber maxLen Bytes zurck
 -}
  VAR i : Longint;
BEGIN
  i := maxLen;
  WHILE i>0 DO
    BEGIN
    IF (char(pw^) = '$') OR
       (Char(pw^) <' ') OR (Char(pw^)>'z')
      THEN i := -1
      ELSE BEGIN
           Dec(i);
           DecP1(pw)
           END;
    END;
  IF i = 0 THEN pw := NiL;
END;


FUNCTION SucheStringinFile(VAR hdl:t_File;
                               startOff,
                               maxSuchLen:LongInt;
                               sMuster:STRING ):LongInt;
  CONST buffSize=5000;
  VAR p{,pw} : Pointer;
      n : INTEGER;
      k, offC : Longint;
      {s : STRING;}
BEGIN
  SucheStringInFile := -1;
  IF startOff<0 THEN startOff := 0;
  Seek(hdl.hExe, startOff);
  GetMem (p,buffsize);
  offC := -1;
  n := 1;
  WHILE (filepos(hdl.hExe) < startOff+maxSuchLen) AND (offC=-1) AND (n>0) DO
    BEGIN
    k := FilePos(hdl.hExe);
    BlockReadWrapper(hdl.hExe, p^, buffSize,n);
    IF IOResult <> 0 THEN;;;;
    offC := MemFind ( p^, n, sMuster);
    IF offC > -1 THEN
      BEGIN {- Muster gefunden! -}
      SucheStringinFile := k+offC;
      END;
    IF n=buffsize THEN Seek(hdl.hExe,filepos(hdl.hExe)-length(sMuster)-1);
    END;
  FreeMem (p,buffsize);
END;




FUNCTION SearchCopyRight(VAR hdl:t_File):BOOLEAN;
{* ... setzt hdl.res.sZitat *}
  CONST buffSize=5000;
  VAR p,pw,pww : Pointer;
      n : INTEGER;
      maxSuchoff,
      k, offC : Longint;
      s : STRING;
BEGIN
  SearchCopyRight := FALSE;
  Seek(hdl.hExe,0);
  GetMem (p,buffsize);
  maxSuchoff := Min(300000,hdl.sr.size);
  offC := -1; n := -1;
  s := '';
  WHILE (filepos(hdl.hExe) < maxSuchOff) AND (offC=-1) AND (n<>0) DO
    BEGIN
    k := filepos(hdl.hExe);
    BlockReadWrapper(hdl.hExe, p^, buffSize,n);
    IF IOResult <> 0 THEN ;
    offC := MemFind ( p^, n, 'opyright');
    IF offC > -1 THEN
      BEGIN
      pw := AddP (p,offc);
      {$IFDEF VP} {pw := Ptr(Longint(p)+offC);}
      {$ELSE}     {pw := Ptr(Seg(p^),ofs(p^)+offC);}
      {$ENDIF}
      FindPrevBOL (pw, offc);
      IF pw <> Nil THEN
        BEGIN {- pw zeigt auf Anfang-1 des Copyrightsatzes -}
        SearchCopyRight := true;
        pww := pw;
        DecP1(pww);
{$R-}   FindprevBOL (pww, 500 {ofs(pww^)} ); {Satz davor suchen}
{$R+}   IF pww <> Nil THEN
          BEGIN {pw zeigt auf Anfang-1 des Satzes vor dem Copyrightsatz}
          IncP1(pww);
          s := s + fnShortIt(
                 GetMemASCIICtrlNString( pww, Min(BuffSize-offC-1,200) )
          ,0) + '  ';
          END;
        IF pww <> pw THEN
          BEGIN
          IncP1(pw);
          s := s + fnShortIt(
                 GetMemASCIICtrlNString( pw, Min(BuffSize-offC-1,200) )
          ,0);
          END;
        END;
      END;
    IF n= buffsize THEN Seek(hdl.hExe,filepos(hdl.hExe)-20);
    END;
  IF s <> '' THEN hdl.res.sZitat := fnShortIt(s,0);
  FreeMem (p,buffsize);
END;


FUNCTION TestForShortDesc(VAR hdl:t_File) : BOOLEAN;
{- Teste, ob die ersten Paar Bytes 'nen anstndigen Ascii-Text beinhalten, der
 - mit ^Z oder 00 aufhrt und nicht zu lang ist
 -}
  CONST MAXBUF = 80+10;
  VAR buf : ARRAY [1..MAXBuf] OF CHAR;
      n : LongInt;
      OFFSet, {i,} max : WORD;
BEGIN
  TestForShortDesc := FALSE;
  IF hdl.sr.size<sizeof(buf) THEN max := hdl.sr.size
                             ELSE max := sizeof(buf);
  offset := 0;
  FillChar(buf, sizeof(buf), #0);

  IF NRead(hdl, 0, buf, max)=0 THEN;
  REPEAT
    Inc(offset);
    n := IsASCII ( buf[offset],  0, max);
  UNTIL (offSet>10) OR (n>=8);
  IF n=-1 THEN
    BEGIN {* Anscheinend ziemlich langer Text am Anfang ohne CR oder ^z *}
    n := MemFind ( buf[offset], 63, '(c)' );
    IF n=-1 THEN n := MemFind ( buf[offset], 63, '(C' );
    IF n=-1 THEN n := MemFind ( buf[offset], 63, 'copyr' );
    IF n=-1 THEN n := 40;
    END;

  IF (n>=8) AND (n<=79)  THEN
    IF MemFind ( buf[4+offset], 63, ' ' ) >=0 THEN{Ein Leerzeichen sollte drin sein}
      BEGIN

      {IF fMitTextBinaer THEN Write(' Binr ');}
      hdl.res.sZitat := fnShortIt(GetASCIIN( hdl,offset-1,n-1 ),0);
      TestForShortDesc := TRUE;
      END;
END;

{============================================================================}
{$IFOPT r+} {$DEFINE rplus} {$ENDIF} {$R-}
PROCEDURE FindNextSort(var srtHdl: T_SortHandle);
BEGIN
  DosError := 18;
  IF srtHdl.papsr = nil THEN Exit;
  DosError := 0;
  IF srtHdl.iApSR <= srtHdl.nFiles THEN
    BEGIN
    srtHdl.dosSR.size := srthdl.papsr^[srthdl.iapsr]^.size;
    srtHdl.dosSR.name := srthdl.papsr^[srthdl.iapsr]^.name;
    Inc(srtHdl.iApSR);
    END;
  IF srtHdl.iApSR > srtHdl.nFiles THEN
    BEGIN {* Falls nFiles = 0 oder alle Files gelesen *}
    FreeMem (srtHdl.pMemAll, srthdl.memsize);
    FreeMem (srtHdl.papsr,   srtHdl.sizepapsr);
    srtHdl.papsr := nil; {- Kennzeichen! -}
    END;
END;

FUNCTION SortIt( VAR a,b : T_SortRec ) : BOOLEAN;
BEGIN
  SortIt := true;
  IF a.ext>b.ext THEN Exit;
  IF a.ext=b.ext THEN SortIt := a.name>b.name
                 ELSE SortIt := false;
END;


PROCEDURE FindFirstSort(sPath: STRING; Attr: Word; var srtHdl: T_SortHandle);
VAR   D     : DirStr;
      N     : NameStr;
      E     : ExtStr;
      i, j  : LongInt;
      pSortRec : tp_SortRec;
BEGIN
  DosError := 0;
  srtHdl.nFiles := 0;
{* FindFirst(sPath, ANYFILE AND NOT DIRECTORY AND NOT VolumeID, srtHdl.dossr );}
  FindFirst(sPath, attr, srtHdl.dossr );
  WHILE DOSError = 0 DO
    BEGIN  {$I-}
    Inc(srtHdl.nFiles);
    FindNext( srtHdl.dossr );
    END; {While}
  IF srtHdl.nFiles=0 THEN Exit; {* DOSERROR ist noch auf 18... *}

  srthdl.memsize := (srtHdl.nFiles+10)*sizeof(pSortRec^);
  GetMem (srtHdl.pMemAll, srthdl.memsize );

  srtHdl.sizepapsr:= (srtHdl.nFiles+10)*sizeof(tp_SortRec);
  GetMem (srtHdl.papsr,srtHdl.sizepapsr);

  DosError := 0;
{  FindFirst(sPath, ANYFILE AND NOT DIRECTORY AND NOT VolumeID , srtHdl.dossr ); }
  FillChar (srtHdl.dossr,sizeof(srtHdl.dossr),#0); {* Fr FPC *}
  FindFirst(sPath, Attr , srtHdl.dossr );

  pSortRec := srtHdl.pMemAll;
  i := 0;
  WHILE DOSError = 0 DO
    BEGIN  {$I-}
    Inc(i);
    pSortRec^.name := srtHdl.dossr.name;
    FSplit(FExpand(srtHdl.dossr.name),d,n,e);
    pSortRec^.ext  := e;
    pSortRec^.size := srtHdl.dossr.size;
    srtHdl.papsr^[i] := pSortRec;
    IncPn( pointer(pSortRec), sizeof(pSortRec^) );
    {$IFDEF VP}
{      Inc(longint(pSortRec),sizeof(pSortRec^) ); }
    {$ELSE}
{      Inc( Word(pSortRec),sizeof(pSortRec^) ); }
    {$ENDIF}
    FindNext( srtHdl.dossr );
    END; {While}
  srtHdl.nFiles := i;
  IF opt.fVerbose THEN { $TODO: nicht toll oder viel schneller...}
    FOR i := 1 TO srtHdl.nFiles-1 DO
      FOR j := i+1 TO srtHdl.nFiles DO
        IF SortIt(srtHdl.papsr^[i]^,srtHdl.papsr^[j]^) THEN
          BEGIN
          pSortRec          := srtHdl.papsr^[i];
          srtHdl.papsr^[i]  := srtHdl.papsr^[j];
          srtHdl.papsr^[j]  := pSortRec;
          END;

  srthdl.iApSR := 1;
  FindNextSort(srtHdl);  {ersten holen}
END;
{$IFDEF rplus}  {$R+} {$UNDEF rplus} {$ENDIF}

FUNCTION HasWildCard(sPath:STRING):BOOLEAN;
  VAR i : WORD;
BEGIN
  HasWildCard := true;
  FOR i := 1 TO length(sPath) DO
    BEGIN
    IF (sPath[i]='*') OR (sPath[i]='?') THEN Exit;
    END;
  HasWildCard := False;
END;

FUNCTION IsDirectory(sPath:STRING):BOOLEAN;
  VAR  srDir : T_Suchrec;
BEGIN
  IsDirectory := false;
  {- Bei Existenz von WildCards ist es per meiner Definition keine Directory -}
  IF HasWildCard(sPath) tHEN Exit;
  DosError := 0;
  IF sPath[length(sPath)]= '/' THEN Delete(sPath,length(sPath),1);
  IF sPath[length(sPath)]= '\' THEN Delete(sPath,length(sPath),1);
  FindFirst(sPath, DIRECTORY, srDir );
  IsDirectory := (DOSError = 0) AND ((srDir.Attr aND DIRECTORY) <>0);
END;


END.