{* Copyright (C) 2002 Free Software Foundation, Inc.
 * Copyright (C) 1995-2002 Walter Koch
 *
 * This file is part of Filespy.
 *
 * Filespy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Filespy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *}


UNIT FS_Spy;

{$I filespy.inc}

INTERFACE

USES DOS, fs_div, fs_def,
  {$IFDEF PMVersion} WinCRT {$ELSE} CRT {$ENDIF}
  {$IFDEF BP2}
    ,DOSCalls  {Hiermit wird ein Ctrl-C-Handler fr OS/2 installiert}
    ,BSESub
  {$ENDIF}
;
Procedure WriteDirSize( sDirName : T_strpchar; VAR nDateien:Longint);
PROCEDURE SpyOneFile( CONST D:DirStr;   CONST N:NameStr;
                      CONST E:ExtStr;   CONST parasr:SearchRec);


CONST lastNlength : Integer = 0;
      sameNlength : Integer = 0;


{--------------------------------------------------------------------------}

IMPLEMENTATION
USES portpas,FS_Opt,
     FS_Util;


TYPE c = Record
          CASE word OF
             20 : ( b20: array[1..20] OF char;);
            111 : ( w : Record w0,w2,w4,w6,w8,w10 : WORD; END;);
            112 : ( w2: Record d0 : WORD; b5: array[1..5] OF char;  END;);
            113 : ( fl : Record l0:Longint; b4,b5: Byte; w6,w8,w10,w12,w14,w16 : WORD; END;);
            120 : ( b120: array[1..120] OF char;);
            END;


{========================Packerkram=========================================}

CONST CharTrennPackerZeile =  {$IFDEF OS2}'#'
                               {$ELSE}    ':'
                              {$ENDIF};

FUNCTION MakeTmpDir:STRING;
  CONST MAXNR = 999;
  VAR i : WORD;
      sEnv,
      sTmpDir,
      sOrgDir : STRING;
BEGIN  {$I-}
  MakeTmpDir := '';
  GetDir(0,sOrgDir);
  senv := GetEnv('TMP');
  IF senv = '' THEN sEnv := GetEnv('TEMP');
  IF sEnv = '' THEN sEnv := cDefaultRoot;
  FOR i := 1 TO MaxNr DO
    BEGIN
    sTmpDir := sEnv+cPATHSEP+'$FILESPY.'+fnStr(i);
    ChDir(sTmpDir); {* Test, ob schon vorhanden *}
    IF IOResult <> 0 THEN Break;
    END;
  ChDir(sOrgDir);
  IF i >= MaxNR+1 THEN Exit;
  MKDir(sTmpDir);
  IF CheckIOResultNil('md'+sTmpDir) <> 0 THEN Exit;
  MakeTmpDir := sTmpDir;
END;


CONST sMyExePath : STRING = '';

FUNCTION HolePackerZeile(const substr : STrING):STRING;
  VAR sThisDir: STRING;
      sEnv: PathStr;
      sPath : DirStr; s2 : NameStr; s3: ExtStr;
      f : TEXT;
BEGIN  {$I-}
  HolePackerZeile := '';
  IF sMyExePath='' THEN sMyExePath := ParamStr(0);
  sEnv := sMyExePath;
  GetDir(0,sThisDir); {* Damit FExpand funktioniert, mu man ins OriginalDir! *}
  {$IFnDEF os2}
    ChDir(sOrgStartDir);
    sEnv := FExpand(sEnv);
    ChDir(sThisDir);
  {$ENDIF}
  FSplit(sEnv, sPath,s2,s3);
  sPath := sPath + 'filespy.cfg';
  Assign(f, sPath);
  Reset(f);
  IF CheckIOResultNil('Configuration:'+sPath)<>0 THEN Exit;

  WHILE TRUE DO
    BEGIN
    {Write('.');}
    s2 := '';
    ReadLn(f,s2);
    IF (IOresult > 0) OR EOF(F) THEN
      BEGIN
      Break;
      END;
    IF (Copy(s2,1,1) <> ';') AND
       (Pos( fnUpper(substr), fnUpper(s2) )> 0) THEN
      BEGIN {* Gefunden *}
      HolePackerZeile := s2;
      Break;
      END;
    END;
  Close(f);
END;


PROCEDURE DelRekursivAktDir;
  VAR DirInfo : SearchRec;
      f       : FILE;
      sOrgDir : STRING;
BEGIN
  GetDir(0,sOrgDir);
{  WriteLn('--------------- Deleting ',sOrgDir,'...'); }
  FindFirst(cWildCardAll, cANYFILE AND NOT cVOLUMEID, DirInfo);
  WHILE DosError = 0 DO
    BEGIN
    IF ((DirInfo.attr AND cDirectory) <> 0)
       AND (DirInfo.name<>'..') AND (DirInfo.name<>'.') THEN
      BEGIN {* Es ist ein Verzeichniss.. *}
      ChDir(DirInfo.Name);
      IF IoResult = 0 THEN DelRekursivAktDir;
      ChDir(sOrgDir);
      IF CheckIOResultNil('ChDir:'+sOrgDir) = 0 THEN RmDir(DirInfo.Name);
      IF CheckIOResultNil('RmDir:'+DirInfo.name)<>0 THEN;;;;
      END;
    IF ((DirInfo.attr AND cDirectory) = 0) THEN
      BEGIN
      Assign(f,DirInfo.Name);
      Erase(f);
      IF CheckIOResultNil('Rm:'+DirInfo.name)<>0 THEN;;;;
      END;
    FindNext(DirInfo);
    END;
END;


PROCEDURE DoEntpack( VAR hdl:t_File; sPacker : STRING);
  VAR  sEXE,sArg,sTmp,
       sTmpDir, sOrgDir : STRING;
       ipos             : WORD;
BEGIN
  IF NOT opt.fExtract THEN Exit;
  GetDir(0,sOrgDir);
  sTmpDir := MakeTmpDir;
  IF sTmpDir='' THEN Exit; {* geht nicht! *}
  sTmp := HolePackerZeile(sPacker+CharTrennPackerZeile);
  WHILE F_Replace ('%a',sOrgDir+cPathSep+hdl.sr.name, sTmp) DO;;;;
  WHILE F_Replace ('%t',sTmpDir+cPathSep+hdl.sr.name, sTmp) DO;;;;

  iPos := Pos('!',sTmp);
  IF iPos = 0
   THEN BEGIN
        {$IFDEF english}
         WriteLn(' -- Error in FILESPY.CFG - Line for ',sPacker+CharTrennPackerZeile,'! is missing ',sTmp);
        {$else}
         WriteLn(' -- Fehler in FILESPY.CFG - Zeile fr ',sPacker+CharTrennPackerZeile,'! fehlt ',sTmp);
         {$ENDIF}
        END
   ELSE BEGIN
        sExe := Copy(sTmp,1,ipos-1);
        sArg := Copy(sTmp,ipos+1,255);

        iPos := Pos(CharTrennPackerZeile,sExe);
        Delete (sExe,1,iPos);

        ChDir(sTmpDir);
        IF CheckIOResult(hdl,'ChDir:'+sTmpDir)<>0 THEN;;;;
        DOSError:=0;
        Close(hdl.hexe);

        WriteLn;
        {$IFDEF english}
        WriteLn(' ------- Extracting with ',     sExe,' into ',sTmpDir,' ... ----');
        {$else}
        WriteLn(' ----- Es wird ausgepackt mit ',sExe,' nach ',sTmpDir,' ... ----');
        {$ENDIF}
        Flush(output); {* Damit auch alles schn in der Reihenfolge bleibt *}
        {swapVectors;}
        Exec(sExe, sArg);
        {swapVectors;}
        Flush(output);
        {$IFDEF english}
          WriteLn(' ----------- Extracted -------------------');
        {$else}
          WriteLn(' ----------- Ausgepackt! -----------------');
        {$ENDIF}
        ChDir(sOrgDir);
        IF CheckIOResult(hdl,'ChDir:'+sOrgDir)<>0 THEN;;;;
        Reset(hdl.hexe);
        IF CheckIOResult(hdl,'Reseting:'+hdl.sr.name)<>0 THEN;;;;
        IF DosError = 0
          THEN BEGIN
               Chdir(sTmpDir);
               IF CheckIoResult(hdl,sTmpDir) <> 0 THEN Exit;
               DoManyDir(sTmpDir+cPathSep+cWildCardAll,hdl.d+hdl.sr.name);
               END
          ELSE BEGIN
               WriteLn(' -- Exec.-Error:',DosError,' ',sExe, sArg);
               END;
        END;

  IF NOT opt.fBehalteAusgepackteDirs THEN
    BEGIN {+ Lsche TmpDir +}
    {$IFDEF english}
      WriteLn(' ----------- Deleting temp. files in ',sTmpDir,' -----------------');
    {$else}
      WriteLn(' ----------- Lschen temp.Dateien in ',sTmpDir,'... ---------------');
    {$ENDIF}
    Chdir(sTmpDir);
    IF IOResult<>0 THEN Exit;
    DelRekursivAktDir;
    ChDir('..');
    IF CheckIOResultNil('cd..:'+sTmpDir) = 0 THEN
      BEGIN
      RmDir(sTmpDir);
      IF CheckIOResultNil('RmDir:'+sTmpDir)<>0 THEN;;;;
      END;
    END;
  ChDir(sOrgDir);
  {$IFDEF english}
  Write(' ----------- Back in ',sOrgDir,'-----');
  {$else}
  Write(' ---------- Zurck in ',sOrgDir,'-----');
  {$ENDIF}
  IF CheckIOResultNil(sOrgDir)<>0 THEN Exit;
END;

{----------------------------------------------------------------}

PROCEDURE PrintArcZeile(CONST sFileName : STRING; compSize,orgSize:LongInt);
BEGIN
  IF PosOrEmpty(sIntoArc,fnUpper(sFileName)) > 0 THEN
    BEGIN
    WriteLn;
    IF compsize>=0 THEN Write(fnFormStrUsing(compSize,13))
                   ELSE Write(' ':13);
    Write(' / ');
    IF orgsize>=0 THEN Write(fnFormStrUsing(orgSize, 13),'   ')
                  ELSE Write(' ':16);
    IF (orgSize>0) AND (compSize>0)
                  THEN Write((100*(Compsize) / (orgSize)):5:1,'%   ')
                  ELSE Write(' ':9);
    Write(sFileName);
    END;
END;

PROCEDURE PrintArcSummary(nFiles,sumComp,sumUnComp:LongInt);
  VAR sDateien : STRING;
BEGIN
  Inc(nArchiv);
  Inc(nTotalFilesInArchive,nFiles);
  IF nFiles=1 THEN Inc(nEinfachArchive);
  Inc(nTotalByteComp,sumComp);
  Inc(nTotalByteUnComp,sumUnComp);
  {$IFDEF english}
   IF nFiles = 1 THEN sDateien :=  '  1 File    '
                 ELSE sDateien := fnFormStrUsing(nFiles,3)+' Files   ';
  {$ELSE}
   IF nFiles = 1 THEN sDateien :=  '  1 Datei   '
                 ELSE sDateien := fnFormStrUsing(nFiles,3)+' Dateien ';
  {$ENDIF}
  IF opt.fIntoArc THEN
    BEGIN
    WriteLn;
    Write('    ---------------------------------------------------');
    END;
  IF sumUnComp > 0
    THEN BEGIN
         IF opt.fIntoArc
           THEN PrintArcZeile(sDateien,  sumComp,sumUnComp)
           ELSE BEGIN
                Write( sDateien );
                IF sumComp > 0 THEN
                   BEGIN
                   Write( (100*sumComp/sumUnComp):5:1,'% ');
                   Write( {$IFDEF english}  'Sizes: ',
                          {$else}           'Gre: ',
                          {$ENDIF}
                         fnFormStr(sumComp),' / ',fnFormStr(sumUnComp) );
                   END;
                END;
         END
    ELSE Write (sDateien);
END;


FUNCTION DoZiP (VAR hdl:t_File; offset : Longint; CONST sAdd : STRING) : BOOLEAN;
 TYPE T_ZipLocalfileheader= RECORD
        signature                : LongInt {(0x04034b50)};
        versionneededMSB         : BYTE;
        versionneededLSB         : BYTE;
        general_purpose_bit_flag : WORD ;
        compression_method       : WORD;
        last_mod_time            : WORD;
        last_mod_date            : WORD;
        crc32                    : LongInt;
        compressed_size          : LongInt;
        uncompressed_size        : LongInt;
        filename_length          : WORD;
        extra_field_length       : WORD;
        { filename : ARRAY [1..filename_length] OF Char;  }
{       file_comment_length      : WORD;
        disk_number_start        : WORD;
        internal_file_attributes : WORD;
        external_file_attributes : Longint;
        relative_offset_of_local_header : Longint;   }
      END;
  VAR header : T_ZipLocalfileheader;
      nFiles,
      sumComp,
      sumUncomp : Longint;
      sFileName : STRING;
BEGIN
  DoZip := FALSE;
  FillChar(header,sizeof(header),#0);
  IF NRead(hdl, offset, header, SizeOf(header)) =0 THEN ;
  IF header.signature <> $04034B50 THEN
    BEGIN
    Exit;
    END;
  DoZip := True;
  Write(csArchiv,' - Zip -',sAdd);
  IF offset<>0 THEN  Write(' SFX -');
  IF NOT opt.fverbose THEN Exit;
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  REPEAT
    FillChar(header,sizeof(header),#0);
    IF NRead(hdl, offset, header, SizeOf(header)) =0 THEN ;
    IF header.signature=$04034b50 THEN
      BEGIN
      Inc(nFiles);
      Inc(sumComp,header.compressed_size);
      Inc(sumUnComp,header.uncompressed_size);
      IF opt.fIntoArc AND (header.filename_length < 255) THEN
        BEGIN
        IF NRead(hdl, offset+sizeof(header), sFileName[1], header.filename_length)=0 THEN ;
        SetLength(sFileName, header.filename_length);
        PrintArcZeile(sFileName,header.compressed_size,header.uncompressed_size);
        END;
      offSet := offset + sizeof(header)
             + header.filename_length+header.extra_field_length
             + header.compressed_size;
      END;
  UNTIL (header.signature <> $04034b50) OR (offSet>=hdl.sr.size);

  IF sumComp+sizeof(header) > hdl.sr.size
    THEN Write(' Fehlerhaftes ZIP-File/Error in ZIP')
    ELSE BEGIN
         PrintArcSummary(nFiles,sumComp,sumUnComp);
         IF opt.fSchwatz THEN Write(' need Vers.',header.versionneededMSB,header.versionneededLSB);
         hdl.res.sMIMEType := 'application/zip';
         DoEntpack(hdl,'zip');
         END
END;


FUNCTION DoArc (VAR hdl:t_File; offset : Longint) : BOOLEAN;
{* [ [archive-mark + header_version + file header + file data]...] +
 * archive-mark + end-of-arc-mark
 *}
 TYPE T_ArcHeader= RECORD
        sig,
        version : BYTE;
        filename   : ARRAY [1..13] of CHAR;  {* file name */ AsciiZ }
        sizeComp   : Longint;  {* size of compressed file }
        date       : WORD;     {* file date *}
        time       : WORD;     {* file time *}
        crc        : WORD;     {* cyclic redundancy check *}
        sizeUncomp : Longint;  {* size of uncompressed file *}
      END;

  VAR header : T_ArcHeader;
      nFiles,
      sumComp,
      sumUncomp : Longint;
      sFileName : STRING;
      fEnde : BOOLEAN;
      setVersion : Set of Byte;
BEGIN
  DOArc := False;
  offset := 0;
  FillChar(header,sizeof(header),#0);
  IF NRead(hdl, offset, header, SizeOf(header)) =0 THEN ;;
  IF     (header.version <> 8)
     AND (header.version <> 9)
     OR  (CheckIOResult(hdl,'') <> 0)
    THEN Exit;

  DoArc := True;
  Write(csArchiv,' - ARC -');
{ IF offset<>0 THEN  Write(' SFX -'); }
  IF not opt.fverbose THEN Exit;
  setVersion := [];
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  REPEAT
    FillChar(header,sizeof(header),#0);
    IF NRead(hdl, offset, header, SizeOf(header)) =0 THEN ;
    fEnde := (CheckIOResult(hdl,'') <> 0) OR (header.version=0);
    IF NOT fEnde THEN
      BEGIN
      Inc(nFiles);
      Inc(sumComp,header.sizeComp);
      Inc(sumUnComp,header.sizeUncomp);
      IF opt.fIntoArc THEN
        BEGIN
        sFileName := GetMemASCIICtrlNString( @header.filename, sizeof(header.filename));
        PrintArcZeile(sFileName,header.sizeComp,header.sizeuncomp);
        END;
      {$IFDEF fpk}
      setVersion := setVersion + [header.version];
      {$ELSE}
      Include(setVersion, header.version);
      {$ENDIF}
      offSet := offset + sizeof(header)+header.sizeComp;
      END;
  UNTIL fEnde OR (offSet>=hdl.sr.size);

  PrintArcSummary(nFiles,sumComp,sumUnComp);
 {     Write('  Versionen ');  }
 {     Write(setVersion); }
 {     header.version,')');  }
  DoEntpack(hdl,'arc');
END;



PROCEDURE DoGnuZiP (VAR hdl:t_File; offset : Longint; totalfilesize:longint) ;
 TYPE T_GZipHeader= RECORD
            magic : word;{0x1f, 0x8b (\037 \213)}
            compression_method:BYTE; { (0..7 reserved, 8 = deflate)}
            flags: BYTE; { bit 0 set: file probably ascii text
                           bit 1 set: continuation of multi-part gzip file
                           bit 2 set: extra field present
                           bit 3 set: original file name present
                           bit 4 set: file comment present
                           bit 5 set: file is encrypted
                           bit 6,7:   reserved }
            modtime: longint; {Unix format}
            extra_flags:BYTE; { (depend on compression method) }
            os : BYTE; {operating system on which compression took place}
            {option part_number : WORD;  (second part=1)
            optional extra_field_length:WORD;
            ? bytes  optional extra field
            ? bytes  optional original file name, zero terminated
            ? bytes  optional file comment, zero terminated
            12 bytes optional encryption header
            ? bytes  compressed data
            4 bytes  crc32
            4 bytes  uncompressed input size modulo 2^32
            }
      END;
  VAR header : T_GZipHeader;
      nFiles,
      sumComp,
      sumUncomp : Longint;
      sName : STRING;
BEGIN
  IF NRead(hdl, offset, header, SizeOf(header)) =0 THEN ;
  IF header.Magic = $9d1f  THEN
    BEGIN
    Write(csArchiv,' - GZip - (alt) ');
    END;
  IF header.Magic <> $8b1f THEN Exit;
  Write(csArchiv,' - GZip - ');

  IF not opt.fverbose THEN Exit;
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  sName := '';

  Inc(offSet,SizeOf(header));
  IF (header.flags and 2) <> 0 THEN Inc(offSet,2);  {optional Partnummer}
  IF (header.flags and 4) <> 0 THEN
    BEGIN {optionales Extra-feld}
    Inc(offset,2+fnReadWord( hdl,offset));
    END;
  IF (header.flags and  8) <> 0 THEN sName := GetASCIIZ( hdl,offset );
  IF (header.flags and  8) <> 0 THEN SkipASCIIZ(hdl,offset); {filename}
  IF (header.flags and 16) <> 0 THEN SkipASCIIZ(hdl,offset); {filecomment}
  IF (header.flags and 32) <> 0 THEN Inc(offset,12); {encrypted}

  Inc(nFiles);
  Inc(sumComp,hdl.sr.size);
  Inc(sumUnComp,  fnReadDWord(hdl,totalfilesize-4) );

  IF opt.fIntoArc THEN
    BEGIN
    PrintArcZeile(sName,sumComp,sumUnComp);
    IF (header.flags and 32) <> 0 THEN Write(' encrypted');
    END;

  PrintArcSummary(nFiles,sumComp,sumUnComp);
  hdl.res.sMIMEType := 'application/x-gzip';
  hdl.res.sDefExt := 'gz';
  DoEntpack(hdl,'gzip');
END;



PROCEDURE DoARJ ( var hdl:t_File; offset : Longint );
  TYPE T_ArjMain = RECORD
         ID : WORD; {0x60 0xEA}
         basic_header_size : WORD; {(from 'first_hdr_size' thru 'comment' below)
                 = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
                 = 0 if end of archive
                 maximum header size is 2600 }

         first_hdr_size : BYTE; {(size up to and including 'extra data')}
         archiver_version_number,
         minimum_archiver_version_to_extract : BYTE;
         host_OS : BYTE; {   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
                             (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
                             (9 = VAX VMS)      }
         arj_flags : BYTE; {
                     (0x01 = NOT USED)
                     (0x02 = OLD_SECURED_FLAG)
                     (0x04 = VOLUME_FLAG)  indicates presence of succeeding
                                           volume
                     (0x08 = NOT USED)
                     (0x10 = PATHSYM_FLAG) indicates archive name translated
                                           ("\" changed to "/")
                     (0x20 = BACKUP_FLAG) indicates backup type archive
                     (0x40 = SECURED_FLAG) }
         security_version, {(2 = current)}
         file_type,          {(must equal 2)}
         reserved : BYTE;
         date_time_original_archive_was_created,
         date_time_when_archive_was_last_modified : LongInt;
         archive_size : LongInt; {(currently used only for secured archives)}
         security_envelope_file_position : LongInt;
         filespec_position_in_filename : WORD;
         length_security_envelope_data  : WORD;
         END;
  T_ArjLocal = RECORD
                id : WORD; {0x60 0xEA}
                basic_header_size : WORD;  { maximum header size is 2600 }
                first_hdr_size : BYTE;
                archiver_version : BYTE;
                minimum_archiver_to_extract : BYTE;
                host_OS : BYTE ; {(0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
                     (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
                     (9 = VAX VMS) }
                flags : BYTE; {(0x01 = GARBLED_FLAG) indicates passworded file
                     (0x02 = NOT USED)
                     (0x04 = VOLUME_FLAG)  indicates continued file to next
                                           volume (file is split)
                     (0x08 = EXTFILE_FLAG) indicates file starting position
                                           field (for split files)
                     (0x10 = PATHSYM_FLAG) indicates filename translated
                                           ("\" changed to "/")
                     (0x20 = BACKUP_FLAG)  indicates file marked as backup }
                method    : BYTE; {(0 = stored, 1 = compressed most ... 4 compressed fastest) }
                file_type : BYTE; {(0 = binary,    1 = 7-bit text)
                                   (3 = directory, 4 = volume label) }
                reserved : BYTE;
                datetime_modified : Longint;
                compressed_size,
                original_size, {this will be different for text mode compression}
                original_file_CRC : Longint;
                filespec_position_in_filename : WORD;
                file_access_mode,
                host_data : WORD;
              END;
  CONST os : ARRAY [1..9] OF String[8]=( 'PRIMOS', 'UNIX', 'AMIGA', 'MAC-OS',
                                          'OS/2' , 'APPLE GS', 'ATARI ST',
                                          'NEXT', 'VAX VMS');
  VAR head : T_ArjMain;
      loc : t_ArjLocal;
      sFileName:STRING;
      firstextheadersize : WORD;
      nFiles,
      sumComp,
      sumUncomp : Longint;
      i         : Longint;
      fBrauchtVorgFile : BOOLEAN;
      osset : SET OF {0..15}Byte;
BEGIN
  Write( csArchiv,' - ARJ -');
  IF offset<>0 THEN Write(' SFX -');
  IF not opt.fverbose THEN Exit;
  osset := [];
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  IF NRead(hdl, offset, head, sizeof(head) ) =0 THEN ;
  offset := offset + 4+head.basic_header_size+4;
  fBrauchtVorgFile := FALSE;
  loc.compressed_size := 0; {Trick}
  REPEAT
    firstextheadersize := fnReadWord(hdl,offset);
    Inc(offSet,2+loc.compressed_size);
    IF firstextheadersize <> 0 THEN Inc(offSet,firstextheadersize+4);

    loc.basic_header_size := 0;
    IF offset+sizeof(loc) < hdl.sr.size THEN
      BEGIN
      IF NRead(hdl, offset, loc, sizeof(loc) ) =0 THEN;;;
      IF (loc.id = 60000) AND
         (loc.basic_header_size<=2600) AND
         (loc.basic_header_size >0) THEN
        BEGIN
        IF (loc.flags AND 8) <> 0 THEN fBrauchtVorgFile := TRUE
                                  ELSE Inc(nFiles); {! Wir zhlen wirklich nur komplette Dateien}
        IF opt.fIntoArc THEN
          BEGIN
          sFileName := GetASCIIZ(hdl, offset+sizeof(loc));
          PrintArcZeile(sFileName,loc.compressed_size,loc.original_size);
          END;

        Inc(sumComp,   loc.compressed_size);
        Inc(sumUnComp, loc.original_size);
        Inc(offset, 4+loc.basic_header_size+4);
        {$IFDEF fpk}
        osSet := osSet + [loc.host_os];
        {$ELSE}
        Include(osset,loc.host_os);
        {$ENDIF}
        END;
      END;
  UNTIL {offset+sizeof(loc) >= hdl.sr.size} loc.basic_header_size = 0;
  PrintArcSummary(nFiles,sumComp,sumUnComp);

  IF (head.arj_flags AND 4) <> 0  {hat Nachfolge Archive}
   THEN IF fBrauchtVorgFile
          THEN Write (' x. von n ')
          ELSE Write (' 1. von n ')
   ELSE IF fBrauchtVorgFile
          THEN Write (' n. von n ');

  FOR i := 1 To 9 DO
    IF i IN osset THEN
      Write (os[i]);

  DoEntpack(hdl,'arj');
END;


FUNCTION DoZoo (var hdl:t_File): BOOLEAN;
 TYPE T_ZooHeader= RECORD
        signature                : LongInt {(0xfdc4a7dc)};
        dataStart,negDataStart   : Longint;
     END;
 TYPE T_ZooFileHeader= RECORD
        signature       : LongInt {(0xfdc4a7dc)};
        dirtype         : BYTE;   {* type of directory entry.  always 1 for now *}
        packing_method  : BYTE;   {/* 0 = no packing, 1 = normal LZW */}
        next : Longint;           {* pos'n of next directory entry *}
        offset : Longint;         {* position of this file *}
        date,         {* DOS format ate *}
        time : WORD ;         {* DOS format time *}
        file_crc : WORD ;     {* CRC of this file *}
        org_size,
        size_now : Longint;
        major_ver,
        minor_ver,            {* minimum version needed to extract *}
        deleted,              {* will be 1 if deleted, 0 if not *}
        struc : BYTE;       {* file structure if any *}
        comment : Longint;  {* points to comment;  zero if none *}
        cmt_size : WORD;  {             /* length of comment, 0 if none */}
        fname:array [1..100] OF Char; { /* filename - Lnge 100 ist geraten!}
{   int var_dir_len;           /* length of variable part of dir entry */
   uchar tz;                   /* timezone where file was archived */
   unsigned int dir_crc;      /* CRC of directory entry */
   /* fields for variable part of directory entry follow */
   uchar namlen;               /* length of long filename */
   uchar dirlen;               /* length of directory name */
   char lfname[LFNAMESIZE];   /* long filename */
   char dirname[PATHSIZE];    /* directory name */
   unsigned int system_id;    /* Filesystem ID */
        unsigned long fattr;                    /* File attributes -- 24 bits */
        unsigned int vflag;                     /* version flag bits -- one byte in archive */
        unsigned int version_no;        /* file version number if any */
}
     END;
  VAR buf : ARRAY [1..100] OF Char;
      header : T_ZooHeader;
      fileheader : T_ZooFileHeader;
      sFileName : STRING;
      nFiles,
      offSet,
      sumComp,
      sumUncomp : Longint;
BEGIN
  DoZoo := FALSE;
  {* Testen ob wirklich ein ZOO Archiv *}
  IF NRead(hdl, 0,buf,sizeof(buf)) =0 THEN ;
  offset := MemFind ( buf, sizeof(buf), #$DC#$a7#$c4#$fd);
  IF offset >= 0 THEN
    BEGIN
    DoZoo := TRUE;
    Write(csArchiv,' - ZOO -');
    IF not opt.fverbose THEN Exit;
    IF NRead(hdl, offSet,header,sizeof(header)) =0 THEN ;;;
    {zusatzplausi  dataStart+negDataStart==0 }
    nFiles := 0;
    sumComp := 0;
    sumUncomp := 0;
    offset := header.datastart;
    REPEAT
      fileheader.signature := 0;
      IF NRead(hdl, offset, fileheader, sizeof(fileheader)) =0 THEN ;
      IF (IOResult<>0) OR (fileheader.signature <> $fdc4a7dc) OR (fileheader.next=0)
        THEN offset := 0
        ELSE BEGIN
             IF opt.fIntoArc THEN
               BEGIN
               sFileName := GetMemUniCodeCtrlNString
                                 ( @fileheader.fname[1], 100, false );

               PrintArcZeile(sFileName,fileheader.size_now,fileheader.org_size);
               END;
             Inc(nFiles);
             Inc(sumComp,fileheader.size_now);
             Inc(sumUnComp,fileheader.org_size);
             offset := fileheader.next;
             END;
    UNTIL offset = 0;
    PrintArcSummary(nFiles,sumComp,sumUnComp);
    Write(fnGetASCII26or13(hdl,3));

    DoEntpack(hdl,'zoo');
    END;
END;


FUNCTION DoLHArc(var hdl:t_File;offset : Longint) : BOOLEAN;
 TYPE T_lhaFileHeader= RECORD
        HeadSiz, HeadChk :  BYTE;
        HeadID1: ARRAY[1..3] OF CHAR;
        HeadID2: ARRAY[4..5] OF CHAR;
        PacSiz, OrgSiz : Longint;
        Ftime : Longint{?};
        Attr  : WORD;
        {uchar Fname[MAXPATH]; Der Dateiname schliesst sich hier direjt an!}
     END;
  VAR header : T_lhaFileHeader;
      nFiles,
      sumComp,
      sumUncomp : Longint;
      sFileName : STRING;
BEGIN
  DoLHArc := FALSE;
  IF NRead(hdl, offset,header,sizeof(header)) =0 THEN ;
  IF Eq(header.headID1, '-lh') THEN
    BEGIN
    DoLHArc := TRUE;
    Write(csArchiv,' - LHA',IfString ( offset <> 0, ',SFX' ),'(',header.HeadID2[4],') - ');
    IF not opt.fverbose THEN Exit;
    nFiles := 0;
    sumComp := 0;
    sumUncomp := 0;
    REPEAT
      fillchar(header, sizeof(header), #0);
      IF NRead(hdl, offset, header, sizeof(header))  =0 THEN ;
      IF (IOResult<> 0) OR (NOT Eq(header.headID1,'-lh'))
        THEN offset := 0
        ELSE BEGIN
             IF opt.fIntoArc THEN
               BEGIN
               sFileName := fnGetPasStr(hdl, offset + sizeof(header) );
               PrintArcZeile(sFileName,header.pacsiz,header.orgsiz);
               END;
             Inc(nFiles);
             Inc(sumComp,header.pacsiz);
             Inc(sumUnComp,header.orgsiz);
             offset := offset+2+header.headsiz+header.pacsiz;
             END;
    UNTIL offset = 0;
    PrintArcSummary(nFiles,sumComp,sumUnComp);
    DoEntpack(hdl,'lha');
    END;
END;



PROCEDURE DoBundle(var hdl:t_File);
 TYPE T_Header= RECORD
          ids           : ARRAY[0..3] OF BYTE;
          unknown       : Array[4..$0f] OF BYTE;
          orgsize       : Longint;
          offNextHeader : Longint;
          unknown2      : Array[$18..$26] OF CHAR;
{* eigentlich
 *        lenFilename   : WORD;
 *        Filename      : Array[1..50] of CHAR;
 *}       lenFileNameLo : BYTE;
          sFileName     : STRING[50];
          END;
  VAR header : T_Header;
      sEntpacker : STRING;
      coff,
      nFiles,
      sumComp,
      sumUncomp : Longint;
BEGIN
  Write(csArchiv,' - OS/2 Bundle - ');
  IF not opt.fverbose THEN Exit;
  coff := 0;
  nFiles := 0;
  {sumComp := 0;}
  sumUncomp := 0;
  IF opt.fIntoArc THEN WriteLn;
  sEntpacker := 'bundle';
  REPEAT
    IF NRead(hdl, coff,header,sizeof(header)) =0 THEN;;;;
    IF Eq(header.unknown2, 'FTCOMP')
        THEN BEGIN sEntPacker := 'bundle2'; byte(header.Sfilename[0]) := header.lenFileNameLo END
        ELSE header.sFileName := ' ?(unbek.Variante)';
    IF opt.fIntoArc THEN PrintArcZeile(header.sFileName,  0, header.orgSize);
    coff := header.offNextHeader;
    {Inc(sumComp,fileheader.size_now);}
    Inc(sumUnComp,header.orgsize);
    Inc(nFiles);
  UNTIL (header.offNextHeader=0) OR (IORESULT<>0);
  sumcomp := hdl.sr.size-nFiles*sizeof(header);

  PrintArcSummary(nFiles,sumComp,sumUnComp);
  DoEntpack(hdl,sEntpacker);
END;

PROCEDURE DoInstallShield2 (VAR hdl:t_File);
 TYPE T_FileHeader= RECORD
        u1 : Longint;
        b1 : BYTE;
        offsNext : Longint;
        PacSiz:WORD; OrgSiz : Longint;
        sFileName : String;
        {uchar Fname[MAXPATH]; Der Dateiname schliesst sich hier direjt an!}
     END;
  VAR header : T_FileHeader;
      nFiles,    offset,
      sumComp,
      sumUncomp : Longint;
      {sFileName : STRING;}
BEGIN
  Write(csArchiv,' - InstallShield (Ver.2) - ');
  IF not opt.fverbose THEN Exit;
  offSet := 13;
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  REPEAT
    Fillchar(header, sizeof(header), #0);
    IF NRead(hdl, offset, header, sizeof(header))  =0 THEN ;
    header.pacsiz := 0;
    header.orgsiz := 0;
    IF opt.fIntoArc THEN
      BEGIN
      PrintArcZeile(header.sFileName, header.pacsiz, header.orgsiz);
      END;
    Inc(nFiles);
    Inc(sumComp,header.pacsiz);
    Inc(sumUnComp,header.orgsiz);
    offset := header.offsnext;
  UNTIL offset = 0;
  PrintArcSummary(nFiles,sumComp,sumUnComp);
  DoEntpack(hdl,'is');
END;


PROCEDURE DoInstallShield (VAR hdl:t_File);
 TYPE T_ArcHeader= RECORD
            _u1 : Array [0..$0B] of Byte;
            nFiles : WORD;
            _u2 : Array [10..$28] OF Byte;
            offsetFileDir : Longint;
            END;
 TYPE T_FileHeader= RECORD
          _unknown      : Array[1..34] OF BYTE;
          offNextHeader : Longint;
          _unknown2     : Array[1..2] OF BYTE;
{          sFileName     : STRING;  pascalstring
          orgsize       : Longint;
          unknown2      : Array[$18..$26] OF BYTE;
          lenFileNameHi : BYTE; }
          END;
  VAR header : T_FileHeader;
      sFileName : STRING;
      fEnde: BOOLEAN;
      coff,
      nFiles,
      sumComp,
      sumUncomp : Longint;
     { i,
      buf : ARRAY [1..16] OF CHAR;}
BEGIN
  Write(csArchiv,' - InstallShield (Ver.3) - ');
  IF not opt.fverbose THEN Exit;
  cOff := fnReadDWord( hdl, $0029); {* Adresse des Fileverzeichnisses im Archiv *}

  nFiles := 0;
  sumComp := -1;
  sumUncomp := hdl.sr.size;

  REPEAT
    fEnde := NRead(hdl, coff, header,sizeof(header)) < sizeof(header);
    IF NOT fEnde THEN
      BEGIN
      IF opt.fIntoArc THEN
        BEGIN
        sFileName := fnGetPasStr(hdl, coff+sizeof(t_FileHeader));
        PrintArcZeile(sFileName,-1,-1{header.pacsiz,header.orgsiz});
        END;
      Inc(nFiles);
   {   Inc(sumComp,header.pacsiz);
      Inc(sumUnComp,header.orgsiz); }
      Inc(coff, header.offnextheader );
      END;
  UNTIL (header.offNextHeader=0) OR (fEnde);

  PrintArcSummary(nFiles,-1{,sumComp},sumUnComp);
  DoEntpack(hdl,'instshield');
END;


PROCEDURE DoMSCompress(var hdl:t_File; startoffset:Longint);
 TYPE T_HeaderMSCF = RECORD
          id     :ARRAY[0..3] OF CHAR; {'MSCF'}
          unknown1 :Longint;
          compSize :Longint;
          unknown2 :Longint;
          ofsDir : LongInt; { Offset Directory (vom Fileanfang) }
          unknown3 :ARRAY [$14..$1b] OF BYTE;
          anzDat :WORD;
          END;
      T_HeaderMSCFFile = RECORD
          orglen    : LongInt;
          orglenSum : LongInt;
          w1,w2 : WORD;
          l : LongInt;
          {filename : ASCIIZ;}
          END;

      T_HeaderARCV= RECORD
          id       : ARRAY[0..3] OF CHAR; {'ARCV'}
          unknown1 : Longint;
          unknown2 : Longint;
          namelen  : byte;
         END;
      T_Header2ARCV= RECORD
          OrgSize  : Longint;
          compSize : Longint;
          END;
      T_HeaderSZ= RECORD
          id     :ARRAY[1..4] OF CHAR; {'SZ..'}
          unknown :Longint;
          OrgSize :Longint;
          methode : BYTE; {??? mglich...}
          data    : ARRAY [1..1] OF BYTE;
          END;
     T_HeaderSZDD= RECORD
          id     :ARRAY[1..4] OF CHAR; {'SZDD'}
          unknown : ARRAY [1..6] OF BYTE;
          OrgSize :Longint;
          END;
     T_HeaderKW  = RECORD
          id     :ARRAY[1..4] OF CHAR; {'KWAJ'}
          unknown : ARRAY [5..14] OF BYTE;
          END;
  VAR buf : ARRAY [1..sizeof(T_HeaderMSCF)] OF CHAR;
      mscf : T_HeaderMSCF absolute buf;
      arcv : T_HeaderARCV absolute buf;
      SZDD : T_HeaderSZDD absolute buf;
      SZ   : T_HeaderSZ   absolute buf;
      KW   : T_Headerkw   absolute buf;
      arcv2 : T_Header2ARCV;
      fileHead : T_HeaderMSCFFile;
      nFiles,
      cOff,
      sumComp,
      sumUncomp : Longint;
      i : Longint;
      sEntpack,  s : STRING;
BEGIN
  IF NRead(hdl, startOffset,buf,sizeof(buf))=0 THEN ;

  sEntpack := 'xxxx';
  nFiles := 1;
  IF Eq(MSCF.id ,'MSCF') THEN
    BEGIN
    cOff := MSCF.ofsdir+startoffset;
    IF cOff > hdl.sr.size THEN Exit;
    Write(csArchiv,' - MS-Cabinet ');
    IF startoffset<>0 THEN Write('SFX - ');
    sumUnComp := 0;
    IF not opt.fverbose THEN Exit;

    FOR i := 1 TO MSCF.anzdat DO
       IF NRead( hdl, cOff, fileHead, sizeof(fileHead) ) > 0 THEN
         BEGIN
         cOff := GetAndSkipASCIIZ(hdl, cOff+sizeof(fileHead), s);
         Inc(sumUnComp,filehead.orglen);
         IF opt.fIntoArc THEN
           IF PosOrEmpty(sIntoArc,fnUpper(s)) > 0 THEN
             BEGIN
             PrintArcZeile(s{FileName},-1{pacsiz},filehead.orglen{orgsiz});
             END;
         END;
    sumComp := hdl.sr.size-cOff;
    PrintArcSummary(mscf.anzdat,sumComp,sumUnComp);
    DoEntpack(hdl,'mscf');
    Exit;
    END
  ELSE IF Eq(ARCV.id, 'ARCV') THEN
    BEGIN
    Write(csArchiv,' - ARCV ');
    IF NRead(hdl, $0c+1+fnReadByte(hdl,$0c), arcv2,sizeof(arcv2))=0 THEN ;
    sumComp := arcv2.compSize;
    sumUncomp := arcv2.orgsize;
    END
  ELSE IF Eq(SZDD.id , 'SZDD') THEN
    BEGIN
    Write(csArchiv,' - MS Expand(sz) ');
    sumComp := hdl.sr.size-sizeof(t_headerszdd);
    sumUncomp := SZDD.orgsize;
    sEntpack := 'szdd';
    END
  ELSE IF Eq(SZ.id , 'SZ'#$20#$88) THEN
    BEGIN
    Write(csArchiv,' - MS Expand(SZ) ');
    sumComp := hdl.sr.size-sizeof(t_HeaderSZ);
    sumUncomp := SZ.orgsize;
    END
  ELSE IF Eq(KW.id ,'KWAJ') THEN
    BEGIN
    Write(csArchiv,' - MS Expand(KW) ');
    FOR i := 5 TO Min(20,sizeof(buf)) DO Write(' ',fnByteHex(byte(buf[i])));
    Exit;
    END
  ELSE BEGIN {* Unbekanntes Format *}
    FOR i := 1 TO Min(16,sizeof(buf)) DO Write(' ',fnByteHex(byte(buf[i])));
    Exit;
    END;
  PrintArcSummary(nFiles,sumComp,sumUnComp);
  DoEntpack(hdl,sEntpack);
END;

    CONST cRAR = #$52#$61#$72#$21#$1a#$07#$00;
FUNCTION DoRAR(VAR hdl:t_File;offset:Longint) : BOOLEAN;
 TYPE T_BlockHeader= RECORD
         CRC : WORD; {CRC of total block or block part}
         TYP : Byte; {Block type}
         FLAGS : WORD; {Block flags}
         HEAD_SIZE : WORD; {Block size}
         ADD_SIZE : LongInt; {Optional field - added block size}
        END;
 TYPE T_FileHeader= RECORD
         CRC : WORD; {CRC of total block or block part}
         TYP : Byte; {Block type}
         FLAGS : WORD; {Block flags}
         HEAD_SIZE : WORD; {Block size}
         PackSize,
         UnpSize : LongInt;
         Host_OS : Byte;
         filecrc,ftime : Longint;
         unp_Ver,method: BYte;
         namesize : WORD;
         Attr : Longint;
         {filename}
        END;
  VAR header : T_BlockHeader;
      FHead : T_FileHeader;
      sFileName : STRING;
      fEnde: BOOLEAN;
      coff,
      BlockSize,
      nFiles,
      sumComp,
      sumUncomp : Longint;
BEGIN
  DORAR := False;
  Write(csArchiv,' - RAR - ');  {1.x?}
  IF offset<>0 THEN
    BEGIN
    {* Testen, ob es ein SFX ist *}
    offset := FileFind(hdl, $5000, cRAR );
    IF offset < 0 THEN Exit; {* War wohl keiner ... *}
    Write(' SFX - ');
    END;
  IF not opt.fverbose THEN Exit;

  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  cOff := offset;

  REPEAT
    fEnde := ( NRead(hdl, coff, header,sizeof(header)) < sizeof(header) ) ;
    IF Not fEnde THEN
      BEGIN
      blocksize := header.head_size;
      IF (header.flags AND $8000)>0 THEN Inc(blocksize,header.add_Size);

      IF header.typ=$74 THEN
        BEGIN {FileHeaderBlock}
        fEnde := NRead(hdl, coff, fhead,sizeof(fhead)) < sizeof(fhead);
        IF opt.fIntoArc THEN
          BEGIN
          sFilename := GetASCIIN(hdl, coff+sizeof(fhead), fhead.namesize);
          PrintArcZeile(sFileName,fhead.packsize,fhead.unpsize);
          Write('  need RAR ',fhead.unp_Ver/10:0:2{,'  Host:'});
          {IF fHead.host_os=0 THEN Write('DOS');
          IF fHead.host_os=1 THEN Write('OS/2');}
          END;
        Inc(nFiles);
        Inc(sumComp,fhead.packsize);
        Inc(sumUnComp,fhead.unpsize);
        END;
      Inc(coff, blocksize);
      END;
  UNTIL (cOff>=hdl.sr.size) OR fEnde;

  PrintArcSummary(nFiles,sumComp,sumUnComp);
  DoEntpack(hdl,'RAR');
  DORAR := true;
END;




PROCEDURE DoArch {!<arch>} ( var hdl:t_File;offset : Longint );
  TYPE T_ArchMain=Record
         acName      : Array[0..15]OF CHAR;
         acCreatetime: Array[0..11]OF CHAR;
         acUserID    : Array[0..5] OF CHAR;
         acGroupID   : Array[0..5] OF CHAR;
         acMode      : Array[0..7] OF CHAR;
         acSize      : Array[0..9] OF CHAR;
         acEoH       : Array[0..1] OF CHAR;
       END;
  VAR head      : T_ArchMain;
      sTmp,
      sFileName : STRING;
      nFiles,
      sumComp,
      sumUncomp,
      size      : Longint;
      iErr      : {$IFDEF VP} LongInt{$ELSE} Integer {$ENDIF};
BEGIN
  Write( csArchiv,' - ',csDEVEL,' Library (COFF) -');
  IF not opt.fverbose THEN Exit;
  nFiles := 0;
  sumComp := 0;
  sumUncomp := 0;
  REPEAT
    IF odd(offset) THEN Inc(offSet);
    IF NRead(hdl, offset, head, sizeof(head) ) = 0 THEN;;;
    IF InOutRes = 0 THEN
      BEGIN
      Inc(nFiles);
      sTmp := F_TrimLR(ArrChar2Str(head.acSize, sizeof(head.acSize) )) ;
      Val(sTmp, size, iErr);
      IF opt.fIntoArc THEN
        BEGIN
        sFileName := head.acName;
        PrintArcZeile(sFileName, size, size);
        END;
      Inc(sumComp,   size);
      Inc(sumUnComp, size);
      Inc(offset, sizeof(T_ArchMain) + size );
      END;
  {* IOResult muss zuerst stehen, sonst wird wg $B- InOutRes nicht geNullt! *}
  UNTIL (IOResult <> 0) OR (offset >= hdl.sr.size);
  PrintArcSummary(nFiles,sumComp,sumUnComp);
END;



FUNCTION TarTest(VAR hdl:t_File): BOOLEAN;
  CONST Blocksize = 512;
  TYPE T_TAR = RECORD
                CASE WORD OF
                 0 : (buf:ARRAY [0..160] OF CHAR);
                 1 : (struc : RECORD
                       name : ARRAY [1..100] OF CHAR;
                       mode : ARRAY [1..8] OF CHAR;  { ___777_ z.B.   _=Space }
                       uid  : ARRAY [1..8] OF CHAR;  { _______ z.B.   _=Space }
                       gid  : ARRAY [1..8] OF CHAR;  { _______ z.B.   _=Space }
                      size  : ARRAY [1..12] OF CHAR;  { als OCTAL-ASCIIZahl }
                     mTime  : ARRAY [1..12] OF CHAR;  { als OCTAL-ASCIIZah?)}
                    chksum  : ARRAY [1..12] OF CHAR;
                   linkflag:Char;
                   {weitere}
                   END);
             END;
  VAR off,lUncomp,lComp{*,i*} : Longint;
      sFileName : String;
      buf : T_Tar;
      nFiles,
      sumComp,
      sumUncomp : Longint;
BEGIN
  TarTest := FALSE;
  IF NRead( hdl, 0, buf, sizeof(buf)) < sizeof(buf) THEN Exit;
  IF CheckIOResult(hdl,'') <> 0 THEN Exit;
  IF EQ( Buf.buf[96], #0#0#0#0) THEN
    BEGIN
    IF Str2Oct( @buf.struc.mode, sizeof(buf.struc.mode)-1 ) = -1 THEN Exit;
    IF Str2Oct( @buf.struc.size, sizeof(buf.struc.size)-1 ) = -1 THEN Exit;

    tartest := true;
    nFiles := 0;
    sumComp := 0;
    sumUncomp := 0;
    off := 0;
    Write(csArchiv,' - TAr -');
    IF not opt.fverbose THEN Exit;

    WHILE off < hdl.sr.size DO
      BEGIN
      IF NRead( hdl, off, buf, sizeof(buf)) < sizeof(buf) THEN Break;
      lUncomp := Str2Oct( @buf.struc.size, sizeof(buf.struc.size) );
      IF lUncomp<0 THEN Break;
      IF luncomp= 0 THEN {Verzeichniss} lComp := Blocksize
                    ELSE lComp := Blocksize*(2+lUncomp DIV BLOCKSIZE);
      IF opt.fIntoArc THEN
        BEGIN
        sFileName := GetMemASCIICtrlNString( @buf.struc.name, sizeof(buf.struc.name));
        PrintArcZeile(sFileName, lcomp,lUncomp);
        END;
      Inc(nFiles);
      Inc(sumComp,   lComp);
      Inc(sumUnComp, lUnComp);
      Inc(off,lComp);
      END;
    PrintArcSummary(nFiles,sumComp,sumUnComp);
    hdl.res.sMIMEType := 'application/x-tar';
    DoEntpack(hdl,'tar');
    END;
END;


{------------------------------------------------------------------------}

FUNCTION FileDescSuche(VAR hdl:T_File; start,len:Longint;
                            fUniCode: BOOLEAN):BOOLEAN;
      CONST sVer :    ARRAY[FALSE..TRUE] OF STRING[12] = ('VERSION_INFO',   'V'#0'E'#0'R'#0'S'#0);
            sFileDes: ARRAY[FALSE..TRUE] OF STRING[16] = ('FileDescription','F'#0'i'#0'l'#0'e'#0'D'#0'e'#0's'#0'c'#0);
            sFileVer: ARRAY[FALSE..TRUE] OF STRING[16] = ('FileVersion',    'F'#0'i'#0'l'#0'e'#0'V'#0'e'#0'r'#0's'#0);
            sProdName:ARRAY[FALSE..TRUE] OF STRING[22] = ('ProductName','P'#0'r'#0'o'#0'd'#0'u'#0'c'#0't'#0'N'#0'a'#0'm'#0'e');
      VAR offVers,
          offString : LongInt;
          s : STRING;
BEGIN
    FileDescSuche:= FALSE;
    IF NOT opt.fVerbose THEN Exit;
    offVers := SucheStringinFile(hdl,start,len, sVer[fUniCode]);
    IF offVers >= 0 THEN
      BEGIN
      offString := SucheStringinFile(hdl,offVers,1500,sFileDes[fUniCode]);
      IF offString=-1 THEN
         offString := SucheStringinFile(hdl,offVers,1500,sProdName[fUniCode]);
      s := GetASCIICtrlN(hdl,offString+16+18*Ord(fUniCode),100,100,TRUE,fUniCode);
      AddStrSep(hdl.res.sZitat,' / ', fnShortIt(s,0));
      FileDescSuche:= TRUE;

      offString := SucheStringinFile(hdl,offvers,1500, sFileVer[fUniCode]);
{*      IF offString=-1 THEN
 *         offString := SucheStringinFile(hdl,offvers,1500, sFileVer[fUniCode]);
 *}
      IF offString >= 0 THEN
        BEGIN
        s := GetASCIICtrlN(hdl,offString+12+14*Ord(fUniCode),100,100,TRUE,fUniCode);
        hdl.res.sVers := fnShortIt(s,0);
        END;
      END;
    END;


PROCEDURE DoLE(VAR hdl:t_File;offNE:LongInt);
{* Linear Executable, OS/2 1.x? Windows? }
  VAR  offNameTbl : LongInt;
BEGIN
  offNameTbl := fnReadDWord(hdl,offNE+$88);
  IF offNameTbl <> 0 THEN
    BEGIN
    hdl.res.sZitat := fnGetPasStr(hdl,offNameTbl);
    END;

   IF NOT FileDescSuche(hdl, hdl.sr.size-50000,50000,FALSE) THEN
   IF NOT FileDescSuche(hdl,                 0,20000,FALSE) THEN
   IF NOT FileDescSuche(hdl,                 0,hdl.sr.size,FALSE) THEN
   ;;;;
  IF hdl.res.sDesc = '' THEN hdl.res.sDesc := 'OS/2 1.x / Windows VxD (LE)';
  IF hdl.res.sZitat = '' THEN IF SearchCopyRight(hdl) THEN;;;;
  IF opt.fSchwatz THEN hdl.res.sSchwatz := '(Linear Executable)';
END;


PROCEDURE DoLX(var hdl:t_File; offNe:LongInt);
{* OS/2 2.x Executable *}
  TYPE T_LX = RECORD
          ID : WORD;
          byteEndian,
          wordEndian : BYTE;
          FormatLevel : Longint;
          Cpu,OS : WORD;
        END;
  VAR offNameTbl : LongInt;
      len, mflags : Longint;
      header : T_LX;
      s : STRING;
BEGIN
  s := '';
  IF NRead(hdl, offNe, header, sizeof(header) ) =0 THEN ;
  Case Header.OS OF
      1 : AddStr(s,'OS/2');
      2 : AddStr(s,'Windows');
      3 : AddStr(s,'DOS 4 (oder hher)');
     {3 : Write(' Windows 386'); }
      ELSE AddStr(s,'OS?'+FnStr(Header.os));
    END;

  Case Header.cpu OF
      1 : AddStr(s,' i286');
      2 : AddStr(s,' i386');
      3 : AddStr(s,' i486');
      ELSE AddStr(s,' CPU?'+FnStr(header.cpu));
    END;

  offNameTbl := fnReadDWord(hdl,offNE+$88);  {88}
  len := fnReadDWord(hdl,offNE+$8c);
  IF (offNameTbl <> 0) AND (len<>0) THEN AddStr(hdl.res.sZitat, fnShortIt(fnGetPasStr(hdl, offNameTbl),0) );
  IF hdl.res.sZitat='' THEN IF SearchCopyRight(hdl) THEN;;;;

  mflags := fnReadDWord(hdl,offNE+$10);
  IF (mFlags AND $00010000) <> 0 THEN AddStr(s,', prot.mode library module');
  IF (mFlags AND $00020000) <> 0 THEN AddStr(s,', OS/2 GerteTreiber/DeviceDriver');
  IF opt.fSchwatz THEN AddStr(s,' (LX)');

  hdl.res.sDesc := s;
END;


PROCEDURE DoPE(var hdl:t_File; offPE:longint);
  VAR fDescFound : BOOLEAN;

  Type DD = Longint;
       DW = WORD;
       DB = BYTE;
       t_PE = Record
               sign                   : DD;
               cpu,obj                : DW;
               TimeDateStamp,
               Reserved1,
               Reserved2              : DD;
               HdrSize,Flags          : DW;
               Reserved               : DW;
               LMajor,LMinor          : DB;
               Res1,res2,
               res3,entrypointRVA,
               res4,res5,
               imageBase,objectalign,
               fileAlign              : DD;
               OSMajor,  OSMinor,
               UserMajor,UserMinor,
               SubMajor, SubMinor     : Dw;
               Res6,ImageSize,
               Headersze,FileCheckSum : DD;
               SubSystem,dllFlags     : DW;
               StackReserveSize,StackCommitSize,
               HeapReserveSize,HeapCommitSize : DD;
               res7,interestingRVASizes,
               exportTBlRVA,   totExportDataSize,
               importTBlRVA,   totImportDataSize,
               resTBlRVA,      totResDataSize,
               excTBlRVA,      totExcDataSize,
               SecTBlRVA,      totESecataSize,
               fixTBlRVA,      totFixDataSize,
               debTBlRVA,      totDebDirs,
               imgDescRVA,     totDescSize,
               machineSpecRVA, machineSpecSize,
               ThreadLocalStorRVA, totTLSSize : DD;
               END;
      t_ResDir = RECORD
            RESOURCE_FLAGS : DD       ;
            TIME_DATE_STAMP : DD;
            MAJOR_VERSION,
            MINOR_VERSION : DW;
            nNAME_ENTRY,
            nID_ENTRY :DW;
            RESOURCE_DIR_ENTRIES : DD;
           END;
      t_obj = ARRAY [1..8] of Char;
  VAR pe         : T_PE;
      obj :   T_obj;
      ResDir : T_ResDir;
      segmentName: ARRAY[1..8] OF CHAR;
      s          : STRING;
      offMSCF,
      offRes,
      w,{ descsize,}
      offNameTbl, l : LongInt;
BEGIN
  fDescFound := FALSE;

  Seek(hdl.hExe,offpe);
  BlockRead( hdl.hExe, pe, sizeof(pe));

  Case pe.Subsystem of
     {0000:s:= 'unbekanntes Subsystem';}
     0001:s:= 'Win32 Gen';
     0002:s:= 'Win32';
     0003:s:= 'Win32 Console';
     0005:s:= 'WinNT OS/2';
     0007:s:= 'WinNT Posix';
     ELSE s := 'unknown subsystem (pe.subsys='+fnStr(pe.subsystem)+')';
     END;
  AddStr(hdl.res.sDesc,s);

  IF pe.imgDescRVA <> 0 THEN
    BEGIN {* IMAGE DESCRIPTION RVA *}
    offNameTbl := fnReadDWord(hdl, pe.imgDescRVA);
    AddStr(hdl.res.sZitat,fnShortIt( GetASCIIN(hdl, offNameTbl, pe.totDescSize ),0));
    fDescFound := TRUE;
    END;

 {* IF pe.resTblRVA <> 0 THEN
    BEGIN *} {* IMAGE DESCRIPTION RVA *}
 {* offRes := fnReadDWord(hdl, pe.imgDescRVA);
    Seek( hdl.hExe, offRes );
    BlockRead( hdl.hExe, resDir, sizeof(ResDir) );
    BlockRead( hdl.hExe, l, sizeof(l) );
    BlockRead( hdl.hExe, l, sizeof(l) );
    Seek( hdl.hExe, l );
    BlockRead( hdl.hExe, obj, sizeof(obj) );
    END;
 *}

  {* Durchsuche Objectkatalog *}
  FOR w := 0 TO pe.obj-1 DO
    BEGIN
    Seek( hdl.hExe,offpE+$F8+w*40 );
    BlockRead( hdl.hExe, segmentName, sizeof(segmentName) );
    IF StrEq ( @segmentName, '.rdata', 6)  {OR
       StrEq ( @segmentName, '.data', 5)} THEN
      BEGIN
      offNameTbl := fnReadDWord(hdl,offPE+$f8+w*40+8+8+4);
      GetStrASCIIz(hdl,offNameTbl,s);
      IF (s<>'') AND (IsASCII ( s[1],0,8)  = -1) THEN
        BEGIN
        AddStr(hdl.res.sZitat,FnShortIt(s,0));
        fDescFound := TRUE;
        END;
      END;
    END;

  {* $TODO: Nicht sehr flott und findet auch nicht alles: *}
  IF NOT fDescFound THEN
   IF NOT FileDescSuche(hdl, hdl.sr.size-50000,50000,TRUE) THEN
    IF NOT FileDescSuche(hdl, 0,20000,TRUE) THEN
     IF NOT FileDescSuche(hdl, hdl.sr.size-50000,50000,FALSE) THEN
      IF NOT FileDescSuche(hdl, 0,20000,FALSE) THEN
       IF NOT FileDescSuche(hdl, 0,hdl.sr.size,TRUE) THEN
        IF NOT FileDescSuche(hdl, 0,hdl.sr.size,FALSE) THEN;;;;

  IF (Pos('Cabinet Self-Extractor', hdl.res.sZitat) > 0) OR
     (Pos('.CAB', hdl.res.sZitat) > 0) THEN
    BEGIN
    {* Suche MSCF Kennung *}
    offMSCF := SucheStringinFile(hdl, $10000, $10000, 'MSCF'#0#0{#0#0});
    IF offMSCF >= 0 THEN DoMSCompress(hdl,offMSCF);
    END;

  s := '';
  CASE pe.cpu OF
    0 : s:= 'unbekannt';
    $14c : s := 'i386';
    $14D : s := 'i486';
    $14e : s := 'i586';
    $14f : s := 'i686'; {* Mal geraten ... *}
    $162 : s := 'MIPS Mark I';
    $163 : s := 'MIPS Mark II';
    $166 : s := 'MIPS Mark III';
    $184 : s := 'Alpha';
    $1F0 : s := 'PowerPC';
    ELSE s := '(unknown cpu, id:'+fnWordHex(pe.cpu)+')';  {not implement.}
    END;
  AddStr(hdl.res.sDesc,' '+s{,' (PE)'});

  IF opt.fSchwatz THEN
    BEGIN
    AddStr(hdl.res.sSchwatz,
           'Req.Vers: OS:'+FnStr(pe.OSMajor  )+'.'+FnStr(pe.OSMinor)+
                   ' Usr:'+FnStr(pe.UserMajor)+'.'+FnStr(pe.UserMinor)+
                   ' Sub:'+FnStr(pe.SubMajor )+'.'+FnStr(pe.SubMinor) );
    END;

{ DLLFLAGS =
     0001:s:= 'h __Per-Process Library Initialization.
     0002:s:= 'h __Per-Process Library Termination.
     0004:s:= 'h __Per-Thread Library Initialization.
     0008:s:= 'h _ _Per-Thread Library Termination.
     Write('  Descr.Off.:',pe.imgDescRVA);
}
END;


PROCEDURE DoNE(var hdl:t_File;{$IFDEF Ver70} CONST {$ENDIF}  offNE:LONGINT);
  TYPE T_new_exe = RECORD            { New .EXE header }
{00h}    ne_magic:         word     ; { Magic number NE_MAGIC 0x454E }
{02h}    ne_ver:           byte     ; { Version number of the linker}
{03h}    ne_rev:           byte     ; { Revision number of the linker }
{04h}    ne_enttab:        word     ; { Offset of Entry Table }
{06h}    ne_cbenttab:      word     ; { Number of bytes in Entry Table }
{08h}    ne_crc:           longint  ; { Checksum of whole file }
{0bh}    ne_flags:         word     ; { Flag word }
{0dh}    ne_autodata:      word     ; { Automatic data segment number }
         ne_heap:          word     ; { Initial heap allocation }
         ne_stack:         word     ; { Initial stack allocation }
         ne_csip:          longint  ; { Initial CS:IP setting }
         ne_sssp:          longint  ; { Initial SS:SP setting }
         ne_cseg:          word     ; { Count of file segments }
         ne_cmod:          word     ; { Entries in Module Reference Table }
         ne_cbnrestab:     word     ; { Size of non-resident name table }
{22h}    ne_segtab:        word     ; { Offset of Segment Table }
{24h}    ne_rsrctab:       word     ; { Offset of Resource Table }
{26h}    ne_restab:        word     ; { Offset of resident name table }
{28h}    ne_modtab:        word     ; { Offset of Module Reference Table }
{2ah}    ne_imptab:        word     ; { Offset of Imported Names Table }
{2ch}    ne_nrestab:       longint  ; { Offset of Non-resident Names Table }
{30h}    ne_cmovent:       word     ; { Count of movable entries }
{32h}    ne_align:         word     ; { Segment alignment shift count }
{34h}    ne_cres:          word     ; { Count of resource entries }
{36h}    ne_exetyp:        byte     ; { Target operating system }
{37h}    ne_flagsothers :  byte     ; { Other .EXE flags }
{38h}    ne_res : array [1..8] OF char     ; { Pad structure to 64 bytes }
       END;

      {T_ResTable =
         WORD     rscAlignShift;
         TYPEINFO rscTypes[array 1..<until rscEndTypes=0>] OF T_TypEInfo];
         WORD     rscEndTypes;
         BYTE     rscResourceNames[];
         BYTE     rscEndNames;}
       t_TYPEINFO = RECORD
                     rtTypeID : WORD;
                     rtResourceCount:WORD;
                     rtReserved : Longint;
                     NAMEINFO  : Byte{Eigentlich: ARRAY [1..rtResourceCount] OF rtNameInfo[]};
                    END;
       t_NAMEINFO = RECORD
                      rnOffset:WORD;
                      rnLength:WORD;
                      rnFlags:WORD;
                      rnID:WORD;
                      rnHandle:WORD;
                      rnUsage:WORD;
                      END;

  T_vs_FixedFileInfo = record
    dwSignature: Longint;               { e.g. $feef04bd }
    dwStrucVersion: Longint;            { e.g. $00000042 = "0.42" }

    dwFileVersion2: Word;           { e.g. $00030075 = "3.75" }
    dwFileVersion1: Word;           { e.g. $00030075 = "3.75" }
    dwFileVersion4: Word;           { e.g. $00000031 = "0.31" }
    dwFileVersion3: Word;           { e.g. $00000031 = "0.31" }

    dwProductVersionMS: Longint;        { e.g. $00030010 = "3.10" }
    dwProductVersionLS: Longint;        { e.g. $00000031 = "0.31" }
    dwFileFlagsMask: Longint;           { = $3F for version "0.42" }
    dwFileFlags: Longint;               { e.g. vff_Debug | vff_Prerelease }
    dwFileOS: Longint;                  { e.g. vos_DOS_Windows16 }
    dwFileType: Longint;                { e.g. vft_DRIVER }
    dwFileSubtype: Longint;             { e.g. vft2_DRV_Keyboard }
    dwFileDateMS: Longint;              { e.g. 0 }
    dwFileDateLS: Longint;              { e.g. 0 }
  end;

  Var offRscTbl, offvers,    offModTbl,
      offImpTbl, offNameTbl, offRNmTbl,
      tmp : longint;
      nameInfo : T_nameInfo;
      typeInfo : T_typeInfo;
      FileInfo : T_vs_FixedFileInfo;
      wF1, w, i, alignment,
      lokSize, nModTbl,
      blSize, wOtherExeFlags : WORD;
      {bLen : BYTE;}
      sName : STRING;
      bOS : BYTE;
BEGIN
  bOS :=            fnReadByte(hdl,offNE+$36);
  offNameTbl :=     fnReadDWord(hdl,offNE+$2c);
  offRscTbl :=      fnReadWord(hdl,offNE+$24) + offNe;
  wOtherExeFlags := fnReadWord(hdl,offNE+$37);

  IF opt.fModuleList THEN
    BEGIN
    offRNmTbl := fnReadWord(hdl,offNE+$26) + offNe;
    AddStr( hdl.res.sAdd, 'ModuleName: '+fnGetPasStr(hdl,offRNmTbl) + ', Req:') ;

    nModTbl   := fnReadWord(hdl,offNE+$1e);
    offModTbl := fnReadWord(hdl,offNE+$28) + offNe;
    offImpTbl := fnReadWord(hdl,offNE+$2a) + offNe;
    FOR i := 1 TO nModTbl DO
      BEGIN
      tmp := fnReadWord(hdl,offModTbl+2*i-2);
      AddStr( hdl.res.sAdd, ' '+fnGetPasStr(hdl,offImpTbl+tmp) );
      END;
    END;

  wF1 := fnReadWord(hdl,offNE+$0c);
  CASE bOS OF
    1 : AddStr(hdl.res.sDesc,'OS/2');
    2 : BEGIN
        w := fnReadWord(hdl,offNE+$3e);
        AddStr(hdl.res.sDesc,'Win '+FnStr(hi(w))+'.'+FnStr(lo(w)) );
        END;
    3 : AddStr(hdl.res.sDesc,'DOS 4.0');  { z.B. ORACLE (3) }
    4 : AddStr(hdl.res.sDesc,'Windows 386');
    5 : AddStr(hdl.res.sDesc,'DOS DPMI?(5)');
   64 : AddStr(hdl.res.sDesc,'DOS (Zortech Extender)'); {64:Zortech c++ 3.0 Dos Xtender? }
   ELSE AddStr(hdl.res.sDesc,'OS?:'+FnStr(bOS) );
  END; {CASE}
  { IF (wF1 AND 8)=8 THEN Write(' prot.'); }
  IF (wF1 AND $0800)<>0 THEN AddStr(hdl.res.sDesc,' & DOS');   {=Family Appl.}
  AddStr(hdl.res.sZitat, fnShortIt(fnGetPasStr( hdl,offNameTbl ),0) );
  IF (wOtherExeFlags AND 1)<>0 THEN AddStr(hdl.res.sDesc,{$IFDEF english} ' long filename'
                                                           {$ELSE}          ' lange Datein.'
                                                           {$ENDIF});
  IF (wF1 AND $0010)<>0 THEN AddStr(hdl.res.sDesc,' i86 req.');
  IF (wF1 AND $0020)<>0 THEN AddStr(hdl.res.sDesc,' i286 req.');
  IF (wF1 AND $0040)<>0 THEN AddStr(hdl.res.sDesc,' i386 req.');
  IF (wF1 AND $0080)<>0 THEN AddStr(hdl.res.sDesc,' 80x87 req.');

  CASE fnReadbyte(hdl,offNE+$0d) OF
      2 : AddStr(hdl.res.sDesc,  {$IFDEF english}' Textmode'
                                          {$else}' Textmodus'  {$ENDIF});
      3 : AddStr(hdl.res.sDesc,' GUI');
    128 : AddStr(hdl.res.sDesc,{$IFDEF english}' driver'
                                        {$else}' Treiber'  {$ENDIF});
    131 : ;
    ELSE  AddStr(hdl.res.sDesc,' Flag:'+FnByteHex( fnReadByte(hdl,offNE+$0d)) );
   END;

{
  IF (wF1 AND $0100)<>0 THEN Write(' Nicht PM-kompatibel');
  IF (wF1 AND $0200)<>0 THEN Write(' PM-kompatibel');
}
  {ResourceTable}
  IF NRead(hdl, offRscTbl, alignment, sizeof(alignment)) =0 THEN ;
  IF Alignment = 4 THEN
    BEGIN
    Inc(offRscTbl,2); {zeigt nun auf den erstem TypeInfo Eintrag}
    REPEAT
      IF NRead(hdl, offRscTbl, w, sizeof(w))  =0 THEN ;
      IF (w<>0) AND (w<>$FFFF) THEN
       IF NRead(hdl,   offRscTbl, typeInfo, sizeof(typeInfo)) = 0
        THEN w:=0
        ELSE BEGIN
        {  Write(typeinfo.rtTypeID AND 255,' - '); }
        Inc(offRscTbl,8);
        FOR i := 1 TO Min(100,typeInfo.rtResourceCount) DO
          BEGIN
          IF NRead(hdl, offRscTbl, nameInfo, sizeof(nameInfo)) =0 THEN ;
          IF CheckIOResult(hdl,hdl.sr.name) <> 0 THEN Break;
          Inc(offRscTbl,sizeof(nameInfo));
          IF (typeinfo.rtTypeID AND 255)=16 THEN
            BEGIN
            offvers := longint(nameinfo.rnOffset)*16;
            blSize  := fnReadWord(hdl,offVers); {Gesamte Blockgre }
            lokSize := fnReadWord(hdl,offVers+2);
            sName   := GetASCIIZ(hdl,offVers+4);
            Inc(offVers,4+length(sName)+1);
            IF sName = 'VS_VERSION_INFO' THEN
              BEGIN
              IF NRead(hdl, offVers, fileInfo, sizeof(fileInfo)) =0 THEN ;
              hdl.res.sVers :=
               FnStr(fileInfo.dwFileVersion1)+'.'+
               FnStr(fileInfo.dwFileVersion2)+'.'+
               FnStr(fileInfo.dwFileVersion3)+'.'+
               FnStr(fileInfo.dwFileVersion4);
              END;
          {$IFDEF asdasdasd}
             adad          Inc(offVers,lokSize);
            blSize:= fnReadWord(offVers); {Gesamte Blockgre }
            lokSize :=  fnReadWord(offVers+2);
            sName := GetASCIIZ(offVers+4);
            IF sName = 'StringFileInfo' THEN
              BEGIN
              END;
           {$ENDIF}
            END;
          END;
        END;
    UNTIL (w=0) OR (w=$FFFF);
    Inc(offRscTbl,2); {zeigt nun auf den erstem ResourceName Eintrag}
    {  REPEAT
      NRead(hdl, offRscTbl, blen, sizeof(blen));
      NRead(hdl, offRscTbl, sName[0], blen+1);
      Inc(offRscTbl,blen+1);
      Write(' ',sName);
    UNTIL sName=''; }
    END;

  {* Winzip *}
  IF SucheStringinFile(hdl, $0, 300,'self' ) > 0 THEN
    BEGIN
    tmp := SucheStringinFile(hdl, 0, $5000,'PK'#3#4 );
    IF tmp > 0 THEN
       IF DoZip(hdl,tmp,'Win') THEN Exit;
    END;

  IF NOT FileDescSuche(hdl, hdl.sr.size-50000,50000,FALSE) THEN
  IF NOT FileDescSuche(hdl,                 0,20000,FALSE) THEN
  IF NOT FileDescSuche(hdl,                 0,hdl.sr.size,FALSE) THEN
  ;;;;
END;


PROCEDURE DoW3(var hdl:t_File;OffNE:longint; CONST sTyp : STRING);
{* offenbar ein EXE, der viele EXE enthlt (Widows 3) *}
  VAR offHeader : LongInt;
      Kennung : ARRAY [1..2] OF CHAR;
      i,nEntries : WORD;
      offCur : Longint;
BEGIN
  IF sTyp = 'W4' THEN
    BEGIN
    AddStr(hdl.res.sDesc,
    {$IFDEF english}
            'Multiple EXE-File - Win98 - Contains more file)');
    {$else} 'Multiple EXE-File - Win98 - Enthlt weitere Dateien');
    {$ENDIF}
    Exit;
    END;
  nEntries := fnReadWord(hdl,offNE+$04);
  AddStr(hdl.res.sDesc,
  {$IFDEF english}
          'Multiple EXE-File - Contains '+FnStr(nEntries)+ ' other files (use -a to see)');
  {$else} 'Multiple EXE-File - Enthlt '+FnStr(nEntries)+ ' weitere Dateien (-a fr Inhalt)');
  {$ENDIF}

  IF opt.fIntoArc THEN
    BEGIN
    offCur := offNE+$10;
    FOR i := 1 TO nEntries DO
      BEGIN
      Write(GetASCIIN(hdl,offCur,8),'    ');
      offHeader := fnReadDWord(hdl,offCur+$08);
      {* Headerkennung lesen *}
      IF NRead(hdl, offHeader, Kennung, 2) =0 THEN ;
      Write(' (',Kennung,') - File ist enthalten in ',hdl.sr.name);
      {Das geht leider nicht, es kommt nur Mist raus: IF Kennung = 'LE' THEN DoLE(offHeader);}
      WriteLn;
      Inc(offCur,$10);
      END;
    END;
END;


PROCEDURE DoMZHeader(var hdl:t_File);
TYPE T_MZ_hdr = RECORD                 { DOS 1, 2, 3 .EXE header }
{0x000}      e_magic:        word    ;    { Magic number }
{0x002}      e_cblp:         word    ;    { Bytes on last page of file }
{0x004}      e_cp:           word    ;    { Pages in file }
{0x006}      e_crlc:         word    ;    { n Relocations }
{0x008}      e_cparhdr:      word    ;    { Size of header in paragraphs }
{0x00a}      e_minalloc:     word    ;    { Minimum extra paragraphs needed }
{0x00c}      e_maxalloc:     word    ;    { Maximum extra paragraphs needed }
{0x00e}      e_ss:           word    ;    { Initial (relative) SS value }
{0x010}      e_sp:           word    ;    { Initial SP value }
{0x012}      e_csum:         word    ;    { Checksum ber gesamte Datei }
{0x014}      e_ip:           word    ;    { Initial IP value }
{0x016}      e_cs:           word    ;    { Initial (relative) CS value }
{0x018}      e_lfarlc:       word    ;    { File address of relocation table }
{0x01a}      e_ovno:         word    ;    { Overlay number }
{0x01c}      e_res : ARRAY [1..4] OF WORD;  { Reserved words }
{0x024}      e_oemid:        word    ;    { OEM identifier (for e_oeminfo) }
{0x026}      e_oeminfo:      word    ;    { OEM information: e_oemid specific }
{0x028}      e_res2:ARRAY [1..10] OF word;  { Reserved words }
{0x03c}      e_lfanew:       longint ;    { File address of new exe header }
            END;
  Type T_Caster = Array[1..sizeof(T_MZ_hdr)] OF BYTE;
  VAR lenSpezHeader   : LongInt;
      arjrecsize,
      nReloc,w,
      offRelocTbl : WORD;
      buf         : ARRAY [1..10] OF BYTE;
      allbuf      : ARRAY [0..255] OF BYTE;
      offID       : Longint;
      vHeader     : T_MZ_hdr;
      s,s2        : STRING;
      fLadeGr     : BOOLEAN;
BEGIN
  s := '';
  fLadeGr := false;
  IF NRead (hdl, 0, vheader, sizeof(vHeader)) =0 THEN ;
  lenSpezHeader := 16*longint(vHeader.e_cparhdr);
  IF lenSpezHeader > 255 THEN lenSpezHeader := 255;
  offRelocTbl := vheader.e_lfarlc;
  nReloc := vheader.e_crlc;

  IF (offRelocTbl=$1e) THEN
    BEGIN
    IF NRead(hdl, $32,buf,sizeof(buf))=0 THEN ;;;;
    IF StrEq(@buf, 'PKWARE Inc.',10) THEN
      BEGIN
      hdl.res.art := cArchiv;
      offId := FileFind(hdl, $4000, 'PK'#$03#$04 );
      IF offId = -1 THEN BEGIN
                         hdl.res.sDesc := 'PKZip - Selfextract - defekt/corrupted?';
                         END
                    ELSE BEGIN
                         IF DoZip(hdl,offId,'') THEN;;;
                         END;
      Exit;
      END;
    END;

  IF StrEq( @vheader.e_res, 'RSFX', 4) THEN
    IF DoRAR(hdl,2) THEN Exit;

  IF (offRelocTbl=$1c) THEN
    BEGIN
    IF StrEq( @vheader.e_res, 'RJSX', 4)
      THEN BEGIN
           {* (1) find the ARJ header id bytes 0x60, 0xEA *}
           offId := FileFind(hdl, $A000, #$60#$EA );
           IF offId <> -1 THEN
             BEGIN
             {* (2) read the next two bytes as the header record size in bytes, *}
             IF NREAD(hdl,offid+2, arjrecsize, 2)=0 THEN ;;;;;
             {* (3) if the record size is greater than 2600, go back to the header
              * id file position, increment the file position, and go back to
              * step (1),*}
             IF arjrecsize > 2600
               THEN {*$TODO jp back *}
               ELSE BEGIN
                    {* (4) read the header record based upon the previous byte count,
                     * (5) calculate the 32 bit CRC of the header record data,
                     * (6) read the next four bytes as the actual header record CRC,
                     * (7) if the actual CRC does not equal the calculated CRC, go back
                     *     to the header id file position, increment the file position,
                     *     and go back to step (1). *}
                    DoArj(hdl,offid);
                    Exit;
                    END;
             hdl.res.art := cArchiv;
             hdl.res.sDesc := 'ARJ - SFX, defekt/corrupted? ';
             END;
           END
        ELSE IF (nReloc=0) AND StrEQ( @vheader.e_OEMid, 'LHA''s',5)
             THEN BEGIN
                  offId := FileFind(hdl, $2000, '-lh' );
                  IF offId <> -1 THEN
                    IF NOT DoLharc(hdl,offId-2) THEN offId := -1 ;
                  IF offId = -1 THEN
                    BEGIN
                    hdl.res.art := cArchiv;
                    hdl.res.sDesc :='LhArc - SFX - defekt/corrupted? - '+GetASCIIN(hdl, $24, 15 );
                    END;
                  Exit;
                  END;
    END;
  {---- ENDE SFX ---}

  hdl.res.art := cEXEC;

  IF offRelocTbl<=$3f THEN
    BEGIN
    fLadeGr := True;
    AddStr(s,'DOS');
    hdl.res.sDefExt := 'EXE';
    END;

  IF (offRelocTbl=$52) AND (NRead (hdl,lenSpezHeader, allbuf, sizeof(allBuf)) > 100) THEN
    BEGIN
    {($EB,$7E,$0,$0,$43,$C0,$42,$0,$30,$A,$43,$4F,$4E,$20,$20,$20,$20,$20,
    $43,$6F,$70,$79,$72,$69,$67,$68,$74,$28,$43,$29,$31,$39,$39,$32,$2C,
    $31,$39,$39,$33,$20,$4E,$6F,$76,$65,$6C,$6C,$2C,$49,$6E,$63,$2E,$28,
    $45,$44,$43,$29,$ 7,$1F,$5F,$5E,$5D,$5A,$59,$5B,$58}
    s2 := '';
    IF Eq(allbuf[9], #$3B#$06#$02#$00#$73#$1A#$2D#$20#$00#$FA#$8E#$D0#$FB#$2D#$25#$00#$8E) THEN s2 := 'PKLite 1.12';
    IF Eq(allbuf[9], #$3B#$06#$02#$00#$73#$1A#$2D#$20#$00#$FA#$8E#$D0#$FB#$2D#$19#$00#$8E) THEN s2 := 'PKLite 1.13';
    IF Eq(allbuf[9], #$3B#$06#$02#$00#$72#$1B#$B4#$09#$BA#$18#$01#$CD#$21#$CD#$20#$4E#$6F) THEN
      BEGIN
      IF DoZip(hdl,$3d9a,'') {pkzipsfx 2.04g} THEN fLadeGr := false
                                              ELSE s2 := 'PKLite 1.15';
      END;
    IF Eq(allbuf[9], #$3B#$06#$02#$00#$72#$1D#$B4#$09#$BA#$1A#$01#$CD#$21#$B4#$4C#$CD#$21#$4E#$6F ) THEN s2 := 'PKLite 1.20';
    IF Eq(allbuf[0], #$EB#$7E#$00#$00 ) THEN s2 := 'PKLite';
    IF s2 > '' THEN
      BEGIN
      AddStr(s,'DOS -'+csgepackt+' '+s2);
      hdl.res.sDefExt := 'EXE';
      END;
    END;

  IF (offRelocTbl=$1c) THEN
    IF NRead (hdl,lenSpezHeader, allbuf, sizeof(allBuf)) > 100 THEN
      BEGIN{FC 06 1E 0E 8C C8 01 06 35 01 BA 16 12 03 C2 8B D8
            FC 06 1E 0E 8C C8 01 06 35 01 BA D9 05 03 C2 8B D8}
      IF Eq( allbuf[0], #$FC#$06#$1E#$0E#$8C#$C8#$01#$06#$35#$01#$BA )
        THEN AddStr(s,' -'+csgepackt+' (<= Diet 1.20)');
{      F9 9C EB 09  35 8A 0A 00 CD 21 55  F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA
       F9 9C EB 09  89 16 0A 00 B4 30 55  F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA
 }    IF Eq( allbuf[11], #$F8#$9C#$06#$1E#$57#$56#$52#$51#$53#$50#$0E#$FC#$8C#$C8#$BA )
        THEN AddStr(s,' -'+csgepackt+' (Diet 1.45f)');
      END;

  IF (offRelocTbl=$1c) AND StrEq( @vheader.e_res,'LZ91',4) THEN AddStr(s,' -'+csgepackt+' (LZ91)');



{  IF Eq( T_caster(vHeader)[29],'diet') THEN Write (' - gepackt (DIET)'); }

  IF offRelocTbl>$3f {* muss mindestens $3c sein um NE, PE oder so zu haben!}
    THEN BEGIN
         offID := fnReadDWord(hdl,$3c);
         IF (offID>0) AND (offID<hdl.sr.size)
           THEN BEGIN
                w := fnReadWord(hdl,offID);
                IF       (w = ORD('N')+256*ORD('E')) THEN DoNE(hdl,offID)
                ELSE IF  (w = ORD('L')+256*ORD('E')) THEN DoLE(hdl,offID)
                ELSE IF  (w = ORD('L')+256*ORD('X')) THEN DoLX(hdl,offID)
                ELSE IF  (w = ORD('P')+256*ORD('E')) THEN DoPE(hdl,offID)
                ELSE IF  (w = ORD('W')+256*ORD('3')) THEN DoW3(hdl,offID,'W3')
                ELSE IF  (w = ORD('W')+256*ORD('4')) THEN DoW3(hdl,offID,'W4')
                ELSE IF  (w = ORD('P')+256*ORD('L'))
                      OR (w = ORD('P')+256*ORD('3')) THEN
                       BEGIN
                       AddStr(s,{$IFDEF english}'uses PharLap TNT DOS-Extender'
                                {$ELSE}         'verwendet PharLap TNT DOS-Extender'
                                {$ENDIF}
                       );
                       END
                ELSE AddStr(s,{$IFDEF english}'unknown EXE-type; HeaderID: '
                              {$ELSE}         'Unbekannter EXE-Typ; Kennung: '
                              {$ENDIF}  + char(lo(w))+char(hi(w)) );
                END
           ELSE BEGIN
                fLadeGr := true;
                END;
         END;

  IF opt.fSchwatz THEN
    IF (offRelocTbl >= $28) AND (vHeader.e_oemid <> 0) THEN
      IF (vheader.e_oemId=$4320)AND(vheader.e_oemInfo=$706f)
        THEN  {pklite}
        ELSE AddStr(s,' - OEM:'+fnWordHex(vheader.e_oemId)+
                            '.'+fnWordHex(vheader.e_oemInfo));

{  IF (offRelocTbl>=$1b) AND (vHeader.e_ovno>0) THEN
     Write (' Overlay ',vHeader.e_ovno);  Dies wird offenbar nie richtig genutzt  }
  IF fLadeGr THEN AddStr(s,{$IFDEF english} ' - Min.Loadsize:'
                           {$ELSE}          ' - Min.Ladegre:' {$ENDIF}
                       + fnFormStr(
                       (512*longint(vheader.e_cp)+vheader.e_cblp)
                       + 16*longint(vheader.e_minalloc)
                       - offRelocTbl
                       - 4*nReloc)) ;

  AddStr( hdl.res.sDesc, s);
  IF (hdl.res.sDesc='') OR opt.fSucheCopyRight THEN IF SearchCopyRight(hdl) THEN;;;
END;


PROCEDURE DoELF(var hdl:t_File);
TYPE T_ELFHdr = RECORD
{0x000}      e_magic : Array [1..4] OF Char; { 7f,ELF }
{0x004}      f32bit,                      { Ist es 32bit?}
{0x005}      lsbmsb  : byte            ;    { lsb,msb reihenfolge 1/2}
             unknown : ARRAY [6..15] OF Char;
{0x010}      filetyp : Word;
{0x012}      machine : Word;
{0x014}      version : Word;
            END;
  VAR s       : STRING;
      vHeader : T_ELFhdr;
BEGIN
  IF NRead (hdl, 0, vheader, sizeof(vHeader)) =0 THEN ;
  Write (csEXEC,' - ELF (Unix)');

  CASE vHeader.machine of
     0 : s := 'unknown machine';
     $0100,$0001 : s := 'WE32100';
     $0200,$0002 : s := 'SPARC';
     $0300,$0003 : s := 'i386';
     $0400,$0004 : s := 'M68000';
     $0500,$0005 : s := 'M88000';
     ELSE s := '('+fnStr(vHeader.machine)+')';
   END;
  Write(' cpu:',s);

  Case vHeader.filetyp OF
        0 : s := 'unknown type';
        $0100,$0001 : s := 'relocatable' ;
        $0200,$0002 : s := 'executable'  ;
        $0300,$0003 : s := 'dynamic lib' ;
        $0400,$0004 : s := 'core file'   ;
        ELSE  s := '('+fnStr(vHeader.fileTyp)+')';
    END;
  Write(', ',s);

  IF opt.fSucheCopyRight THEN IF SearchCopyRight(hdl) THEN;;;
END;


{----------------------Projammierung---------------------------------------}

FUNCTION DoObj (var hdl:t_File): BOOLEAN; {ct 4/92, s.284}
  CONST ID_THEADER = $80;
        ID_COMMENT = $88;
  TYPE T_ObjRecord = RECORD
                       id : Byte;
                       Len : WORD;
                       data : ARRAY [1..50{len-1}] OF BYTE;
                       {prfsumme:BYTE}
                       END;
  VAR r : T_ObjRecord;
      sum,off,
      i : Longint;
      c : CHAR;
BEGIN
  DoObj := FALSE;
  off:= 0;
  REPEAT
    IF NRead(hdl, off, r, sizeof(r))=0 THEN ;;;;;
    IF off=0 THEN
      BEGIN
      IF r.id <> ID_THEADER THEN Exit;
      IF r.len > 1000 THEN Exit; {* wg. Maxis.cim *}
      {* Prfsumme *}
      sum := 0;
      FOR i := 0 TO r.len+2 DO
        BEGIN
        IF NRead(hdl,  i, c, sizeof(c))=0 THEN ;;;;;
        sum := sum+ord(c)
        END;
      IF sum MOD 256 <> 0 THEN Exit;
      DoObj := TRUE;
      hdl.res.art         := cDevel;
      hdl.res.sDesc      := 'Object-File';
      hdl.res.sZitat      := fnGetPasStr(hdl,3);
      hdl.res.sDefExt := 'OBJ';
      END;
    IF opt.fSchwatz AND (r.id=ID_Comment) THEN
        hdl.res.sSchwatz := fnGetWordPasStr(hdl,off+1);
    off := off+r.len+3;
  UNTIL off>50;  { $TODO }
END;

{-------------------------Bildchers----------------------------------------}

PROCEDURE DoPCX(VAR hdl:t_File);
type T_pcxhead = RECORD
     bManID:BYTE;     {  Manufactures ID number}
     bHver:BYTE;      {* Version number:
                       * 0 = Version 2.5 of PC Paintbrush
                       * 2 = Version 2.8 w/palette information
                       * 3 = Version 2.8 w/o palette information
                       * 4 = PC Paintbrush for Windows (Plus for Windows
                       *                                uses Ver 5)
                       * 5 = Version 3.0 and > of PC Paintbrush and PC
                       * Paintbrush +, includes Publisher's Paintbrush.
                       * Includes 24-bit .PCX files       }
    bEncod : BYTE;     {  1 if the file is run-length encoded}
    bBitPix: BYTE;    {  Number of bits/pixel/bitplane       }
    iX1 : INteger;          {  Bitmap dimensions                   }
    iY1 : INteger;
    iX2 : INteger;
    iY2 : INteger;
    iHres : INteger;  {  Horizontal resolution of display the bitmap was}
                      {  created on.                                     }
    iVres : INteger;  {  Vertical resolution of display the bitmap was   }
                      {  created on.                                      }
    abPal : Array [1..48] OF BYTE;  {  Color table}
    bVmode : BYTE;     {  Not used.}
    bNplanes : BYTE;   {  Number of bit planes}
    iBytesPerBitPlane:Integer;  {  Bytes per bit plane}
    abFill: Array [1..60]OF BYTE; {  Unused space}
    END;
  VAR h : T_PcxHead;
      s : String;
BEGIN
  IF NRead(hdl, 0, h, sizeof(h))=0 THEN ;;;;;

  s := '';
  CASE h.bHver OF
     0 : s:='PC 2.5';
     2 : s:='PC 2.8 (mit Palette)';
     3 : s:='PC 2.8 (ohne Palette)';
     4 : s:='for Windows';
   { 4 : AddStr(s,' 3.0 (oder spter) / +');}
     END;

  s := 'Paintbrush ' + s;
  IF h.bEncod=1 THEN AddStr(s,' RLE');

  hdl.res.art := cGRAFIK;
  hdl.res.sDefExt := 'PCX';
  hdl.res.sDesc := s;
  hdl.res.bitpix := h.bbitPix;
  hdl.res.nx := h.ix2;
  hdl.res.ny := h.iy2;
  hdl.res.sSchwatz := ' P'+fnStr(h.bNplanes)+
                      ' B'+fnStr(h.iBytesPerBitPlane)+
                      ' Herst.:'+fnStr(h.bManID)  ;
END;


FUNCTION DoBMP(VAR hdl:t_File;offset:longint) : BOOLEAN;
  VAR bp : WORD;
      s  : STRING;
BEGIN
{  DoBMP := FALSE; }
 {bp2:= fnReadByte(hdl,offset+2);}
  bp := fnReadWord(hdl,offset+28);
  DoBMp := TRUE;
  s := 'Bitmap  ';
  IF (bp<100) AND (bp>0) THEN
    BEGIN
    hdl.res.bitpix := bp;
    hdl.res.nx := fnReadDWord(hdl,offset+18);
    hdl.res.ny := fnReadDWord(hdl,offset+22);
    {fnReadDWord(2),' Byt.,'}
    IF fnReadDWord(hdl,offset+30)=0
      THEN AddStr(s,'unkompr.')
      ELSE AddStr(s,'Kompr.:'+fnStr(fnReadDWord(hdl,offset+30))  );
    END;
  hdl.res.art := cGRAFIK;
  hdl.res.sDefExt := 'BMP/DIB';
  hdl.res.sDesc := s;
END;


FUNCTION TargaTest(VAR hdl:t_File) : BOOLEAN;  {ct 11/95 S.384}
  TYPE T_TAGA = RECORD
         lenImageID,
         ColorMapTyp,
         TargaImagTyoe : BYTE;
         ColorMapoffset,
         ColorMapLen      : WORD;
         ColorMapEntrySize : BYTE;
         xNull,yNull,
         xSize,ySize,
         Farbaufloesung : WORD;
         ImageDescriptor : BYTE;
         END;
  VAR buf : T_TAGA;
BEGIN
  TargaTest := False;
  IF NRead(hdl,0, buf, sizeof(buf)) < sizeOf(buf) THEN Exit;
  IF     (buf.ColorMapTyp > 1) THEN Exit;
  IF NOT (buf.ColorMapEntrySize in [16,24,32]) THEN Exit;
  IF buf.Farbaufloesung > 255 THEN Exit;
  IF NOT (buf.Farbaufloesung    in [1,8,24]  ) THEN Exit;

  hdl.res.art := cGRAFIK;
  hdl.res.sDefExt := 'TGA';
  hdl.res.sDesc := 'Targa';
  hdl.res.bitpix := buf.Farbaufloesung;
  hdl.res.nx := buf.xSize;
  hdl.res.ny := buf.ySize;
  TargaTest := true;
END;




PROCEDURE DoWinHlp(VAR hdl:t_File);
    var NumRead,NumWritten : WORD;
        obStart,
        lz,l,i,obLen : Longint;
        s : String;
        fCompr, fMVB, fGid,
        fAnmerkungen, fNormHelp,
        fZuviel,
        fEnd : BOOLEAN;
        nEintraege : WORD;
        buf : Array [1..1024] OF Byte;
        f : File;
BEGIN
  fCompr := FALSE;
  fMVB := FALSE;fAnmerkungen:= FALSE; fNormHelp := FALSE;
  nEintraege := 0; fZuviel := FALSE; fGID := FALSE;
{
lz := FnReadDword(4);
FOR i:=lz TO lz+15 DO Write(' ',fnByteHex(fnReadByte(i)));
Writeln;
}
  lz := FnReadDword(hdl,4)+$37;  fEnd := FALSE;
  REPEAT
{    if NRead( hdl, lz,  Buf, sizeof(buf) )=0 then;}
    s :=fnReadx(hdl, lz, #0 );
    IF s = '' THEN Inc(lz,21)
    ELSE IF s='|SYSTEM'
      THEN BEGIN
           lz := FnReadDword(hdl,lz+Length(s)+1);
           fEnd := TRUE;
           END
      ELSE BEGIN
 {         IF pos('119',s) > 0 THEN
             s := s; }
           IF s='|Phrases' THEN fCompr := TRUE
           ELSE IF s='|CONTEXT' THEN fNormHelp := TRUE
           ELSE IF s='|CATALOG' THEN fMVB := TRUE
           ELSE IF s='@LINK' THEN fAnmerkungen := TRUE
           ELSE IF s='|Pete' THEN fGID := TRUE
           ELSE BEGIN
                Inc(nEintraege);
                IF NOT opt.fSchwatz AND NOT opt.fChunks AND (nEintraege>50) THEN
                  BEGIN
                  fEND:= TRUE;
                  fZuviel := TRUE;
                  END;
                END;
           IF opt.fChunks THEN
             BEGIN {* Ausfhrlich *}
             WriteLn;
             Write ('  ',s);
             FOR i:= length(s) TO 13 DO Write(' ');
             l := FnReadDword(hdl,lz+Length(s)+1);
             oblen := FnReadDword(hdl,l);
             obStart := l + 9;
             {Test auf Bitmap}
             IF (FnReadWord(hdl,obstart)=Word(ord('B')+256*Ord('M')))
               AND DoBmp(hdl,obStart)
                THEN BEGIN
                     END
                ELSE BEGIN
                     Write(l:9,'@  ',
                           FnReadDword(hdl,l),  '@  ',
                           FnReadDword(hdl,l+4),'@  '  );
                     FOR i:=l+8 TO l+15 DO Write(' ',fnByteHex(fnReadByte(hdl,i)));
                     END;
             IF sGenerateDir <> '' THEN
               BEGIN
               IF s[1]='|' THEN Delete(s,1,1);
               Assign(f,sGenerateDir+s);
               Rewrite(f,1);
               i := obStart;
               repeat
                 IF i+sizeof(buf)<obstart+oblen THEN NumRead := sizeof(buf)
                                                ELSE NumRead := obstart+oblen-i;
                 NumRead:=NRead( hdl, i,  Buf, NumRead );
                 i := i + NumRead;
                 BlockWriteWrapper(F, Buf, NumRead, NumWritten);
               until (i>obStart+oblen-1) or (NumWritten <> NumRead);
               Close(f);
               END;
             END;
           lz := lz+Length(s)+5;
           END;
  UNTIL fEnd OR (IOResult>0) {OR (s='')};
  IF opt.fChunks THEN WriteLn;
  IF      fMVB      THEN Write(' Daten - MM-Viewer Book (MVB)')
  ELSE IF fGID      THEN Write(csHilfe,' - Windows - Suchindex')
  ELSE IF fNormHelp THEN Write(csHilfe,' - Windows')
  ELSE                   Write(csHilfe,' - Windows '{(unbek.Variante mit',
                                 ifString(fZuviel,' mehr als' ),
                                 nEintraege,' Eintrgen)'});
  IF fAnmerkungen THEN Write(csHilfe,' - Windows mit ',nEintraege-1,' Anmerkungen zu ',CopyTill(hdl.sr.name,'.'),'.HLP');

  IF fEnd THEN
    BEGIN
    Write(' "',fnShortIt( FNReadX(hdl,lz+$19,#0),80 ),'"');
    END;
  IF fCompr THEN Write(' kompr.');
END;



PROCEDURE DoVoc(VAR hdl:t_File);
  TYPE T_VocHead = RECORD { ct 1/93, S.213 }
                     ID : ARRAY [1..20] OF CHAR; { "Creative Voice File"1a }
                     lenHead : WORD;
                     versionMin,
                     versionMaj : BYTE;
                     CodedVers : WORD;
                     END;
       T_VocBlockHead = RECORD
                          id : BYTE;
                          len : ARRAY [1..3] OF Byte;
                          END;
  VAR VocHead : T_VocHead;
      blHEad : T_VocBlockHead;
      nSam,
      blSize : Longint;
      offs : Longint;
      b : byte;
BEGIN
  IF NRead( hdl, 0 , vocHead, sizeOf (VocHead))=0 THEN ;;;;;
  Write(csSound,' Voice File (SB), Vers.',
         vocHead.versionMaj,'.',vocHead.versionMaj,' - ');
  offs := sizeof(T_VocHead);
  nSam := 0;
  REPEAT
    IF NRead(hdl, offs, blHead, sizeof(blHead) )=0 THEN ;;;;;
    blSize := Longint(blHead.len[2])*256 + LongInt(blHead.len[3]) * 65536 + sizeof(blHead);
    IF blHead.id = 1 THEN Inc(nSam, blSize-2);
    IF blHead.id = 3 THEN Inc(nSam, fnReadWord(hdl, offs+5));
    IF blHead.id = 5 THEN Write(' mit Kommentar');
    IF blHead.id = 6 THEN Write(' mit Wdh.');
    IF blHead.ID > 8
      THEN BEGIN
           IF IOResult = 0 THEN;;;;
           Write(' Fehler in Block!');
           b := 0;
           END
      ELSE BEGIN
           Inc(offs, Longint(blHead.len[1]) + blSize);
           b := 254;
           IF NRead(hdl, offs, b, 1 )=0 THEN ;;;;;
           END;
  UNTIL (IOResult <> 0) OR (b=0);
  IF nSam > 0 THEN Write(' ',fnFormStr(nSam),' Samp.');
END;


FUNCTION DoZero(VAR hdl:t_File) : BOOLEAN;
  VAR resType : WORD;
      fFound : BOOLEAN;
      n{,i}      : WORD;
      x,y,nFarben{,b} : byte;
BEGIN
  DoZero := TRUE;
  fFound := FALSE;
  IF fnReadByte(hdl,$1) = 0 THEN
    BEGIN
    resType := fnReadWord(hdl,2);
    x := fnReadByte(hdl,6);
    y := fnReadByte(hdl,7);
    nFarben := fnReadByte(hdl,8);
    IF (x>0) AND (y>0) AND (nFarben in [0..16,32,64,128]) THEN
      BEGIN
      n := fnReadWord(hdl,4);
      CASE resType OF
        1 : IF nFarben > 0 THEN
              BEGIN
              hdl.res.art := cGRAFIK;
              hdl.res.sDesc := 'Icon-Windows';
              hdl.res.nx := x;
              hdl.res.ny := y;
              hdl.res.nFarben := nFarben;
              hdl.res.nStueck := n;
              fFound := true;
              END;
        2 : BEGIN
            hdl.res.art := cGRAFIK;
            hdl.res.sDesc := 'MouseCursor-Windows';
            hdl.res.nx := x;
            hdl.res.ny := y;
            hdl.res.nStueck := n;
            fFound := TRUE;
            END;
        END{case}
      END;
    END;
  IF IOResult=0 THEN;;; {- weglesen -}

  IF NOT fFound AND (fnReadByte(hdl,$64)=0) AND (hdl.sr.size=545) THEN
    BEGIN
    hdl.res.art := cDATEN;
    hdl.res.sDesc :='Programm-Info-File, Win 3.x ';
    hdl.res.sZitat := fnShortIt(GetASCIIN(hdl, 2,30),0);
    hdl.res.sDefExt := 'PIF';
    fFound := TRUE;
    END;
  IF IOResult=0 THEN;;; {- weglesen -}

  IF NOT fFound AND (fnReadByte(hdl,$20)=$80)
     AND (hdl.sr.size >=967) AND (hdl.sr.size <1111) THEN
    BEGIN
    hdl.res.art := cDATEN;
    hdl.res.sDesc :='Programm-Info-File, Win32';
    hdl.res.sZitat := fnShortIt(GetASCIIN(hdl, 2,28),0)+'","'+
                      fnShortIt(GetASCIIZ(hdl, $24),0);
    hdl.res.sDefExt := 'PIF';
    fFound := TRUE;
    END;
  IF IOResult=0 THEN;;; {- weglesen -}
  DoZero := fFound;
END;



PROCEDURE DoRIFF(VAR hdl:t_File;fIntel:BOOLEAN);
  {* RIFF haben folgendes Format: *}
  TYPE T_FourCC = ARRAY [1..4] OF CHAR;
       T_RiffChunk= Record
                     ID : T_FourCC;
                     size : Longint;
                     data : RECORD
                            CASE BYTE OF
                             0 : (plain : {Array [1..size] OF} BYTE;);
                             1 : (listtype : T_FourCC;)
                            END;
                     END;
      T_waveformat_tag = RECORD {* u.a. ct 1/93 S.215 *}
                           wFormatTag,
                           nChannels : WORD;
                           nSamplesPerSec,
                           nAvgBytesPerSec : LongInt;
                           nBlockAlign : WORD;
                           nBit : BYTE;
                         END;
      T_MainAVIHeader = RECORD { s.ct 11/94 S.330 }
                          dwMicroSecPerFrame,   { frame display rate (or 0L)}
                          dwMaxBytesPerSec,     { max. transfer rate       }
                          dwPaddingGranularity, { pad to multiples of this}
                                                { size; normally 2K.     }
                          dwFlags,              { the ever-present flags}
                          dwTotalFrames,        { # frames in file}
                          dwInitialFrames,
                          dwStreams,
                          dwSuggestedBufferSize,
                          dwWidth, dwHeight : LongInt;
                          dwReserved : ARRAY [1..4] OF Longint;
                        END;
      T_Strh = RECORD { s.ct 11/94 S.330 }
                art : t_FourCC;
                codec : t_FourCC;
               END;

  VAR {*wType,*} i,iChunk : WORD;
      lenTotal   : Longint;
      buf : ARRAY [1..4] OF CHAR;
      chunk : T_RiffChunk;
      fileFourCC,
      currListFourCC : T_FourCC;
      hAVI : T_MainAVIHeader;
      strh : t_Strh;
      offset :Longint;
      wavefmt : T_waveformat_tag;
      nIcon, nChunk, nList,
      nByteJunk : Longint;
CONST nMainChunk = 10;
      csMainChunk : ARRAY [1..nMainChunk] OF RECORD
                                               id : Array[1..4] OF CHAR;
                                               sDesc : STRING[43];
                                             END = (
     (id:'WAVE'; sDesc:csSound +' - WAVE-Format'), {* ct 1/93, S.215 *}
     (id:'ACON'; sDesc:csGrafic+' - Icon, animiert'),  {* Besseres Wort als animiert? *}
     (id:'CDR4'; sDesc:csGrafic+' - COREL!Draw Vers.4'),
     (id:'CDR '; sDesc:csGrafic+' - COREL!Draw Vers.3'),
     (id:'show'; sDesc:csGrafic+' - COREL!Show'),
     (id:'AVI '; sDesc:csGrafic+' - Video, (AVI)'), {Audio Video Interleaved}
     (id:'cmov'; sDesc:csGrafic+' - Animation - COREL!Move'),
     (id:'actr'; sDesc:csGrafic+' - Animation - COREL!Move-Bibliothek'),
     (id:'RMMP'; sDesc:csGrafic+' - Video - Multimedia-Movie'         ),
     (id:'RMID'; sDesc:csSound +' - MIDI verpackt in RIFF'  )
     );
     CONST cWAVE=1;cACON=2;cCDR4=3;cCDR=4;cAVI=5;
           cCMOV=6;cACTR=7;cRMNP=8;cRMID=9;
BEGIN
  lenTotal := fnReadDWord(hdl,4);
  IF NOT fIntel THEN SwapLong(lenTotal);

  IF NRead(hdl, 8, buf, sizeof(buf))=0 THEN ;;;;;
  Move(buf,fileFourCC[1],4);
  {* Suche nach bekannten RIFF - Haupttypen *}
  iChunk := 0;i := 1;
  WHILE (iChunk=0) AND (i<= nMainChunk) DO
    BEGIN
    IF StrEQ( @buf, csMainChunk[i].id, 4 ) THEN iChunk := i;
    Inc(i);
    END;
  IF iChunk = 0
    THEN IF StrEQ( @buf, 'CDR',  3 )
           THEN Write( csGrafic,' - COREL!Draw Vers.1 oder 2' )
           ELSE BEGIN
                IF fIntel THEN Write(csData,' - RIFF - ',buf)
                          ELSE Write(csData,' - RIFX - ',buf);
                IF NOT opt.fverbose THEN Exit; {* Kann sonst zu lange dauern *}
                END
    ELSE Write( csMainChunk[iChunk].sDesc );

  {* Und nun loopen wir ber die Chunks *}
  nByteJunk := 0; nIcon := 0; nChunk := 0; nList := 0;
  currListFourCC := '    ';
  offset := 12;
  WHILE OffSet<lenTotal DO
    BEGIN
    Inc(nChunk);
    IF NRead(hdl, offset, chunk, sizeof(chunk))=0 THEN ;;;;;
    IF NOT fIntel THEN SwapLong(chunk.size);
    IF Eq(chunk.id,'LIST')
      THEN BEGIN
           Inc(nList);
           currListFourCC := chunk.data.listtype;
           IF opt.fChunks THEN WriteLn('    LIST - typ: ', chunk.data.listtype,
                                          '  Gre: ',chunk.size);
           IF NOT Eq(chunk.data.listtype,'movi') {* dieser Ausschluss m8 das Durchsuchen von AVI schneller *}
             THEN Inc(offset,4+4+4) {Liste durchsuchen}
             ELSE Inc(offSet,4+chunk.size+4); {Liste berlesen}
           END
      ELSE BEGIN
           IF opt.fChunks THEN WriteLn('    Chunk: ', chunk.id,'  Gre: ',chunk.size);
           IF (Eq(chunk.id,'INAM') OR Eq(chunk.id,'ICMT') OR Eq(chunk.id,'IKEY')OR ( Eq(chunk.id,'ISBJ') AND opt.fSchwatz ))
              AND opt.fVerbose THEN
               BEGIN
               Write(' "',GetASCIICtrlN( hdl,offset+8, chunk.size, 255, FALSE{kein CR bernemen},FALSE{ASCII}),'"');
               END
           ELSE IF Eq(chunk.id,'ISFT') AND opt.fVerbose THEN
               BEGIN
               Write(' Erstellt mit "',GetASCIICtrlN( hdl,offset+8, chunk.size, 255,
                                                     FALSE{kein CR bernemen},FALSE{ASCII}),'"');
               END
           ELSE IF (iChunk=cWAVE) AND Eq(chunk.id,'fmt ') THEN
               BEGIN {* u.a. ct 1/93 S.215 *}
               IF NRead(hdl, offset+8, wavefmt, sizeof(wavefmt))=0 THEN ;;;;;
               IF opt.fVerbose THEN
                 BEGIN
                 IF wavefmt.wFormatTag = 1 THEN Write(' PCM')
                                           ELSE Write(' F:',wavefmt.wFormatTag) ;
                 IF      wavefmt.nChannels = 2 THEN Write(' Stereo')
                 ELSE IF wavefmt.nChannels = 1 THEN Write(' Mono')
                 ELSE                               Write(' Kanle:',wavefmt.nChannels);
                 Write(
                 {$IFDEF english} ' Samplerate:' {$else}' Abtastr.:' {$ENDIF}
                       ,wavefmt.nAvgBytesPerSec,'-',wavefmt.nBit,' Bit');
                 END;
               END
           ELSE IF (iChunk=cWAVE) AND Eq(chunk.id,'data') THEN
             BEGIN
             IF wavefmt.nAvgBytesPerSec<>0 THEN BEGIN Write(
                  {$IFDEF english}' Length:'  {$else}' Dauer:'  {$ENDIF}
                  ,(chunk.size / wavefmt.nAvgBytesPerSec):1:2,'s'
               );
               spielDauer := spielDauer + (chunk.size / wavefmt.nAvgBytesPerSec);
               END;
             END
           ELSE IF (iChunk=cACON) AND Eq(chunk.id,'icon') THEN Inc(nIcon)

           ELSE IF (Eq(currListFourCC,'hdrl')) AND (Eq(chunk.id,'avih')) THEN
             BEGIN
             IF NRead(hdl,  offset+8, hAVI, sizeof(hAVI) )=0 THEN ;;;;;
             Write(', ',
                   hAVI.dwWidth,'*',hAVI.dwHeight,',',
                   hAVI.dwTotalFrames:4,' ',csBilder,',',
                   (hAVI.dwTotalFrames*hAVI.dwMicroSecPerFrame) DIV 1000000:4,'s,',
                   hAVI.dwMaxBytesPerSec DIV 1024:4,' kB/s');
             END
           ELSE IF (Eq(chunk.id,'strh')) AND (Eq(fileFourCC,'AVI ')) THEN
             BEGIN
             IF NRead(hdl, offset+8, strh, sizeof(strh))=0 THEN ;;;;;
             IF Eq(strh.art,'vids') THEN
               BEGIN
               IF      Eq(strh.codec, 'cvid') THEN Write(' CinePack')
               ELSE IF Eq(strh.codec, 'rt21') THEN Write(' Indeo 2.1')
               ELSE IF Eq(strh.codec, 'iv31') THEN Write(' Indeo 3.1')
               ELSE IF Eq(strh.codec, 'yvu9') THEN Write(' Indeo Raw')
               ELSE IF Eq(strh.codec, 'msvc') THEN Write(' MS Video1')
               ELSE IF Eq(strh.codec, 'mrle') THEN Write(' MS RLE')
               ELSE IF Eq(strh.codec, 'JPEG') THEN Write(' JPEG')
               ELSE IF Eq(strh.codec, 'MJPG') THEN Write(' Motion-JPEG')
               ELSE IF Eq(strh.codec, 'ULTI') THEN Write(' IBM UltiMotion')
               ELSE  Write(' CoDec: ',strh.codec);
               END;
             END

           ELSE IF Eq(chunk.id,'JUNK') THEN Inc(nByteJunk,chunk.size);
           Inc(offset,chunk.size+4+4);
           IF odd(offset) THEN Inc(offSet); {align WORD}
           END;
    END;
  IF opt.fSchwatz THEN Write(' ',nChunk,' Teile, ',nList,' Listen');
  IF nIcon > 0 THEN Write(' ',nIcon, ' Icon');
  IF opt.fSchwatz AND (nByteJunk > 0) THEN Write(' Verschwendet: ',fnFormStr(nByteJunk), ' Byte (JUNK)');
END;



PROCEDURE DoIFF(VAR hdl:t_File);
  TYPE T_iffChunk= Record
                     ID : ARRAY [1..4] OF CHAR;
                     size : Longint;
                     data : RECORD
                            CASE BYTE OF
                             0 : (plain : {Array [1..size] OF} BYTE;);
                             1 : (listtype : ARRAY [1..4] OF CHAR;)
                            END;
                     END;
      cast = ARRAY [1..sizeof(longint)] OF BYTE;
  VAR buf : T_iffChunk;
      b,i : BYTE;
      offset : Longint;
BEGIN
  Offset := 0;
  IF NRead(hdl, offset, buf, sizeof(buf))=0 THEN ;;;;;
  FOR i := 1 TO 2 DO
    BEGIN
    b := cast(buf.size)[i];
    cast(buf.size)[i] := cast(buf.size)[5-i];
    cast(buf.size)[5-i] := b;
    END;
  hdl.res.art := cGRAFIK;
  IF      Eq(buf.data.listtype,'ILBM') THEN hdl.res.sDesc := 'IFF'
  ELSE IF Eq(buf.data.listtype,'AIFF') THEN BEGIN
                                          hdl.res.art := cKRACH;
                                          hdl.res.sDefExt := 'AIF';
                                          hdl.res.sDesc := 'Audio Interchange Format';
                                          END
  ELSE IF Eq(buf.data.listtype,'PBM ') THEN hdl.res.sDesc := 'DeLuxePaint'
  ELSE IF Eq(buf.data.listtype,'SCDH') THEN BEGIN
                                          hdl.res.art := cDATEN;
                                          hdl.res.sDesc := csSpiel+' SimCity 2000-Stadt';
                                          END
  ELSE BEGIN
       hdl.res.art := cDATEN;
       Move(buf.data.listtype,hdl.res.sDesc[1], sizeof(buf.data.listtype) );
       setLength(hdl.res.sDesc, sizeof(buf.data.listtype) );
       hdl.res.sDesc := 'IFF Datei - unbekannter Untertyp ' + hdl.res.sDesc;
       END;

  Offset := 12;
  REPEAT
    IF NRead(hdl, offset, buf, sizeof(buf))=0 THEN ;;;;;
    FOR i := 1 TO 2 DO
      BEGIN {* Umsetzen Nach Intel's little Endian *}
      b := cast(buf.size)[i];
      cast(buf.size)[i] := cast(buf.size)[5-i];
      cast(buf.size)[5-i] := b;
      END;
    IF opt.fChunks THEN Write(buf.Id,' ');
    IF      Eq(buf.id,'CNAM') THEN AddStr(hdl.res.sZitat, fnGetPasStr(hdl,offset+8) )
    ELSE IF Eq(buf.id,'SCEN') THEN AddStr(hdl.res.sDesc,' (Szenario)');
    Inc(offset,8 + buf.size);
  UNTIL offset+sizeof(buf)>=hdl.sr.size;
END;


PROCEDURE DoMidi(VAR hdl:t_File);
{* MIDI ->ct 7/93,S.234   (Nicht besonders gut erklrt...)
 *      -> Soundblaster Profibuch
 *}
  VAR mtrkhead : RECORD id : ARRAY[1..4] OF CHAR; len:longint; END;
      meta : RECORD zero,ff,id,len : BYTE; END;
    offNextMtrk, offset,  long : Longint;
BEGIN
  IF NRead(hdl, 4, long, sizeof(long))=0 THEN ;;;;;
  SwapLong(long);
  offset := long+8;
  REPEAT
    IF NRead(hdl, offset, mtrkhead, sizeof(mtrkhead))=0 THEN ;;;;;
    IF IORESULT>0 THEN Break;
    SwapLong(mtrkhead.len);
    IF Eq(mtrkhead.id , 'MTrk') THEN
      BEGIN
      offNextMtrk := offset + mtrkhead.len + sizeof(mtrkhead);
      Inc(offset,sizeof(mtrkhead));
      REPEAT
        IF NRead(hdl, offset, meta, sizeof(meta))=0 THEN ;;;;;
        IF IORESULT>0 THEN Break;
        IF (meta.ff=$FF) AND ((meta.id=3) OR (meta.id=6)) THEN
           AddStr(hdl.res.sZitat,' '+fnGetPasStr(hdl,offset+sizeof(meta)-1));
        Inc(offset,meta.len+sizeof(meta));
      UNTIL (offset >= offNextMtrk) OR (meta.ff<>$ff);
      offset := offNextMtrk;
      END;
  UNTIL NOT Eq(mtrkhead.id ,'MTrk');

  hdl.res.Art := cKRACH;
  hdl.res.sDesc := 'MIDI';
  hdl.res.sdefExt := 'MID';
END;



PROCEDURE DoWordOrWrite(VAR hdl:t_File);  {* ct 5/91 S.[Datei] *}
CONST cABSATZ=1;
      cFUSSNOTE=2;
      cBEREICHSFORMATE=3;
      cBEREICHSTABELLE=4;
      cUMBRUECHE=5;
      cINFOS=6;
TYPE T_WordHeader = RECORD  {* ct 5/91, s.326 *}
        id : Longint;
        reserved : ARRAY [1..10] OF Byte;
        offs1Char : Longint;
        bl : Array[1..6] OF WORD;
        szDFV : Array [1..66] OF CHAR; {* $1E *}
        maybeFlagsQuestionMark : WORD;                   {* $60 }
        szPrinter : Array [1..8] OF CHAR; {* $62 *}
        usedBlocks : WORD;
        END;
VAR h : T_WordHEader;
    offSet : longint;
    w,i: WORD;
BEGIN
  IF NRead(hdl, 0, h, SizeOf(h))=0 THEN ;;;;;
  IF h.maybeFlagsQuestionMark = 0
    THEN BEGIN
         hdl.res.art := cTEXT;
         hdl.res.sDesc := 'Word fr DOS';
         hdl.res.sDefExt := 'TXT';
         offset := $80*longint(h.bl[cINFOS]);
         FOR i := 0 TO 0{8} DO
           BEGIN
           w := fnReadWord(hdl,offset+2*i);
           IF w<1000 THEN hdl.res.sZitat := GetASCIICtrlN(hdl, w+offset, 250, 250, false, false);
           END;
         END
    ELSE BEGIN
         hdl.res.art := cTEXT;
         hdl.res.sDesc := 'Windows Write';
         hdl.res.sDefExt := 'WRI';
         hdl.res.sZitat := GetASCIICtrlN(hdl, $80, 250, 250, TRUE{Ignore CRLF TAB}, false);
         END;
END;


PROCEDURE DoKleinWeichVerbundDatei(VAR hdl:t_File);
  TYPE T_FormatID = ARRAY [1..16] OF BYTE;
  VAR resoff : Longint;
   head : Record
       id : longint;
       versionLo,VersionHi : BYTE;
       os : WORD;
       xyzID : T_FormatID;
       nSection : Longint;
       formatID : T_FormatID;
       offFirstSection : Longint;
       {erste Section folgt meistens hier}
       END;
   sect : RECORD
       lenSection,
       nSectionEntries : LongInt;
       {erster eintrag}
       END;
   entr : RECORD
       datentyp, offset : LongInt;
       end;
   data : RECORD
           typ, len : LongInt;
          end;
  {* buf : Array [1..50] of BYTE; *}
  cOff, sectStart,
  iSect,iEntr : Longint;
CONST formatIDSummaryID : T_FormatID=(
        $E0,$85,$9F,$F2,$F9,$4F,$68,$10,$AB,$91,$8,$0,$2B,$27,$B3,$D9
        );
BEGIN
  resoff := FileFind( hdl, 10000, #$01#$00#$fe#$ff);
  IF resoff > 0 THEN Write(csData,' - ',fnShortIt(GetAsciiZ(hdl,resoff+$20),0));

  resoff := FileFind( hdl, $1000, #$fe#$ff#$00#$00);
  IF resoff > 0 THEN
    BEGIN
    IF NRead(hdl, resoff, head, sizeof(head))=0 THEN ;;;;;
    IF MemEq ( @head.formatID, @formatIDSummaryID, sizeof(formatIDSummaryID) )  THEN
      BEGIN
      coff := resoff+head.offFirstSection;
      FOR iSect := 1 TO head.nSection DO
        BEGIN
        sectStart := cOff;
        IF NRead(hdl, cOff, sect, sizeof(sect) )=0 THEN ;;;;;
        IF opt.fChunks THEN Writeln( iSect:4,'. o',sectStart,'  l',sect.lenSection,'  n ',sect.nSectionEntries);
        cOff := cOff + sizeof(sect);
        FOR iEntr := 1 TO sect.nSectionEntries DO
          BEGIN
          IF NRead(hdl, cOff, entr, sizeof(entr) )=0 THEN ;;;;;
          IF IOResult <>0 THEN Exit;
          IF NRead(hdl, sectStart+entr.offset, data, sizeof(data) )=0 THEN ;;;;;
          IF IOResult <>0 THEN Exit;
{IF NRead(hdl, sectStart+entr.offset+sizeof(data), buf, sizeof(buf) )=0 THEN ;;;;;}
          IF opt.fChunks THEN
            BEGIN
            Writeln('   ed',fnLongHex(entr.datentyp),
                      '  t',fnLongHex(data.typ),
                      '  l',fnLongHex(data.len),
                      ' - ',fnShortIt(
                fnReadN( hdl, sectStart+entr.offset+sizeof(data),25),0)
            );
            END;
          IF (entr.datentyp = 2) OR (entr.datentyp = 4) THEN
            IF data.typ = $1e THEN
              BEGIN
              Write(' - "',fnShortIt(
                fnReadN( hdl, sectStart+entr.offset+sizeof(data),data.len)
                ,0), '"'
              );
              END;
          cOff := cOff + sizeof(entr);
          END;
        END;
      Exit;
      END;
    END;
    Write(' Daten - M$ - Compound document');
END;


{==========================================================================}

PROCEDURE SetzeZitat(VAR hdl:t_File; offset:longint; funicode:Boolean);
  CONST MAXBUF = 600;
  VAR buf : ARRAY [1..MAXBuf] OF CHAR;
      lenS, max : Longint;
      sOut : STRING;
BEGIN
  lenS := length(hdl.res.sDesc);
  IF ((nZeilenBreite-26) > lenS) AND (hdl.res.sZitat='') THEN
    BEGIN {* Inhalt drucken *}
    IF hdl.sr.size<sizeof(buf) THEN max := hdl.sr.size
                               ELSE max := sizeof(buf);
    FillChar(buf, sizeof(buf), #0);
    IF NRead(hdl, offSet, buf, max)=0 THEN ;;;;;
    sOut := GetASCIICtrlN( hdl,offset + GetSensefullTextOffset( @buf, max ),
                           max, 80, TRUE{auch CR bernemen},fUnicode);
    sOut := fnShortIt (sOut,0);
    IF hdl.res.sZitat = '' THEN hdl.res.sZitat := Copy(sOut, 1,nZeilenBreite-26-lenS);
    END;
END;

FUNCTION LanguageTest(VAR hdl:t_File) : STRING;
{* Sprache eines Textfiles bestimmen *}
  CONST MAXBUF = 600;
  VAR buf : ARRAY [1..MAXBuf] OF CHAR;
      sResLang : STRING;
      max : LongInt;
      i : WORD;
BEGIN
  {* Besser: verwendeten Zeichensatz analysieren();  *}
  sResLang := '';
  max := Min(hdl.sr.size,sizeof(buf));
  FOR i := 1 TO 5 DO  {  $TODO, variabel machen }
    IF (sResLang='') THEN
      BEGIN
      DoKeyTest;
      IF (i > 1)  AND ( hdl.sr.size>(i+1)*max ) THEN
        BEGIN {* nachlesen *}
        FillChar(buf, sizeof(buf), #0);
        IF NRead(hdl, i*(max-1), buf, max)=0 THEN ;;;;;
        END;

      {$IFnDEF FPK} {$B-} {$ENDIF}
      IF      (MemFind ( buf, sizeof(buf), ' et '  ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' une ' ) >= 0) THEN sResLang := {$IFDEF english}'french '{$ELSE}'frz.'{$ENDIF}
      ELSE IF (MemFind ( buf, sizeof(buf), ' het ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' op '  ) >= 0) THEN sResLang := {$IFDEF english}'dutch '{$ELSE}'niedl.'{$ENDIF}
      ELSE IF  MemFind ( buf, sizeof(buf), ' il '  ) >= 0  THEN sResLang := {$IFDEF english}'itali.'{$ELSE}'ital.'{$ENDIF}
      ELSE IF (MemFind ( buf, sizeof(buf), ' y '   ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' o '   ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' las ' ) >= 0) THEN sResLang := 'span. '
      ELSE IF (MemFind ( buf, sizeof(buf), ' att ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' och ' ) >= 0) THEN sResLang := {$IFDEF english}'swed.'{$ELSE}'schwed.'{$ENDIF}
      ELSE IF (MemFind ( buf, sizeof(buf), ' af ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' og ' ) >= 0) THEN sResLang := {$IFDEF english}'danish '{$ELSE}'dn.'{$ENDIF}
      ELSE IF (MemFind ( buf, sizeof(buf), ' der ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' und ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' von ' ) >= 0) THEN sResLang := {$IFDEF english}'german '{$ELSE}'dt.'{$ENDIF}
      ELSE IF (MemFind ( buf, sizeof(buf), ' the ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' and ' ) >= 0) OR
              (MemFind ( buf, sizeof(buf), ' by '  ) >= 0) THEN sResLang := 'engl.'
{      ELSE IF nUmlaut>1 THEN sResLang :=  ' dt.'};
      END;
  LanguageTest := sResLang;
END;



FUNCTION TextTest(VAR hdl:t_File) : BOOLEAN;
  {* kehrt mit TRUE zurck, wenn es ein ASCII-Text ist *}
  CONST MAXBUF = 600;
  VAR buf : ARRAY [1..MAXBuf] OF CHAR;
      i, max : WORD;
      nUmlaut, nBin,
      nCR,nLF,
      n7bit,n8bit : Longint;
      fCPP,
      fTab, fBS,
      fBELL,fFF : BOOLEAN;
      sResLang,
      sProp,
      sInhalt : STRING;
      cLast : char;
      lenCurWort, nReaded,
      nWorte, nWordstar :longint;
      isUTF : BOOLEAN;
BEGIN
  TextTest := FALSE;

  n7bit := 0; n8bit := 0;  nUmlaut := 0;   nCR := 0;    nLF := 0;
  nBin := 0;   fTab := FALSE;
  nWorte := 0;
  fBELL := FALSE;  fFF := FALSE;  fBS := FALSE;

  max := Min(hdl.sr.size,sizeof(buf));

  {*Statistik*}
  FillChar(buf, sizeof(buf), #0);
  nReaded :=NRead(hdl, 0, buf, max);
  isUTF := (nReaded >= 2) and (buf[1]=#$FF) AND (buf[2]=#$FE);
  IF isUTF THEN
    BEGIN
    max := Min(hdl.sr.size,sizeof(buf));
    nReaded := NRead(hdl, 2, buf, max);
    nReaded := nReaded DIV 2;
    FOR i := 1 TO nReaded DO
      buf[i] := buf[i*2-1];
    END;

  cLast := ' '; nWordstar := 0; nBin := 0; lenCurWort:=0;
  FOR i := 1 to nReaded DO
    BEGIN
    CASE buf[i] OF
      #32..#127  : Inc(n7bit);
      '','','','','','','' : Inc(nUmlaut);  {muss vor 128..255 stehen...}
      #13 :        Inc(nCR);
      #10 :        Inc(nLF);
      #09 :        fTab := TRUE;
      #12 :        fFF := TRUE;
      #07 :        fBell := TRUE;
      #08 :        fBS  := TRUE;
      #$1b,^Z : ;
      ELSE       IF buf[i]>=#128 THEN Inc(n8bit)
                                 ELSE Inc(nBin);
      END;
    IF (buf[i]<>' ') THEN Inc(lenCurWort);
    IF (buf[i]=' ') AND (cLast<>' ') THEN
      BEGIN
      IF lenCurWort>2 THEN Inc(nWorte);
      lenCurWort:=0;
      END;
    IF (buf[i]=' ') AND (cLast>#127) THEN Inc(nWordstar);
    cLast := buf[i];
    END;

  IF (nWordstar>0)        AND (nWorte>0) AND
     (2*nWordstar>nWorte) AND (nWordstar<=nWorte) AND
     (n8Bit+nBin < max DIV 3) THEN
    BEGIN
    hdl.res.art := cTEXT;
    hdl.res.sDesc := 'Wordstar';
    TextTest := true;
    Exit;
    END;

  IF nBin>0 THEN Exit;

  {* Wortsuche *}
  sInhalt := '';
  FOR i := 1 TO 5 DO  {  $TODO, variabel machen }
    BEGIN
    IF (sInhalt='') THEN
      BEGIN
      DoKeyTest;
      IF (i > 1)  AND ( hdl.sr.size>(i+1)*max ) THEN
        BEGIN {nachlesen}
        FillChar(buf, sizeof(buf), #0);
        IF NRead(hdl, i*(max-1), buf, max)=0 THEN ;;;;;
        END;

      IF (MemFind ( buf, sizeof(buf), '<HTML>'   ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '<html>'   ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '</TITLE>' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '</title>' ) >= 0) THEN
             BEGIN
             sInhalt := 'HTML ';
             hdl.res.sDefExt:= 'htm';
             hdl.res.sMIMEType := 'text/html';

             hdl.res.sZitat := MemFindString( buf, sizeOf(buf), '<TITLE>', '</TITLE>');
             IF hdl.res.sZitat = '' THEN hdl.res.sZitat := MemFindString( buf, sizeOf(buf), '<title>', '</title>');
             IF hdl.res.sZitat = '' THEN hdl.res.sZitat := MemFindString( buf, sizeOf(buf), '<Title>', '</Title>');
             END

      ELSE IF (MemFind ( buf, sizeof(buf), 'echo ' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), 'ECHO ' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '%1 '   ) >= 0)
           OR (MemFind ( buf, sizeof(buf), ' %1'   ) >= 0) THEN sInhalt := 'Batch'

      ELSE IF MemFind ( buf, sizeof(buf), 'findfont ' ) >= 0 THEN sInhalt := 'PostScript'
      ELSE IF MemFind ( buf, sizeof(buf), 'subclass:' ) >= 0 THEN sInhalt := 'Smalltalk'

      ELSE IF (MemFind ( buf, sizeof(buf), '{$'    ) >= 0)
           OR (MemFind ( buf, sizeof(buf), 'Unit ' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), 'UNIT ' ) >= 0) THEN sInhalt := 'Pascal(Turbo)'

      ELSE IF (MemFind(buf, sizeof(buf), 'package' ) >= 0)
          AND (MemFind(buf, sizeof(buf), 'use'     ) >= 0)
          AND (MemFind(buf, sizeof(buf), 'function') >= 0) THEN sInhalt := 'ADA'

      ELSE IF Ord(MemFind ( buf, sizeof(buf), ' ptr'  ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ' equ ' ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ' dup ' ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ' db '  ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ' dw '  ) >= 0) > 1 THEN sInhalt := 'Assembler'

      ELSE IF ((MemFind(buf, sizeof(buf), 'document.' ) >= 0)
          AND (MemFind(buf, sizeof(buf), 'this.') >= 0))
          OR (MemFind(buf, sizeof(buf), 'new A') >= 0)   THEN
             BEGIN
             sInhalt := 'JavaScript';
             hdl.res.sDefExt:= 'js';
             END



      ELSE IF (MemFind ( buf, sizeof(buf), '\documentclass' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '\def\'     ) >= 0)
           OR (MemFind ( buf, sizeof(buf), '\begin{'   ) >= 0) THEN
             BEGIN
             sInhalt := 'TeX';
             hdl.res.sZitat := MemFindString( buf, sizeOf(buf), '\title{', '}');
             hdl.res.sDefExt:= 'TEX';
             END

      ELSE IF (MemFind ( buf, sizeof(buf), ' DIVISION' ) >= 0)
           OR (MemFind ( buf, sizeof(buf), ' PIC '     ) >= 0) THEN sInhalt := 'COBOL'

      ELSE IF MemFind ( buf, sizeof(buf), ' go_7+. '  ) >= 0 THEN sInhalt := '7plus:'+fnReadX(hdl,19,' ')

      ELSE IF Ord(MemFind ( buf, sizeof(buf), ':print' ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ':?'     ) >= 0)
            + Ord(MemFind ( buf, sizeof(buf), ':PRINT' ) >= 0) > 1 THEN sInhalt := 'BASIC'


      ELSE IF (MemFind (buf, sizeof(buf),'import java.') >= 0) THEN sInhalt :='Java-Source (.java)'
      ELSE IF (MemFind (buf, sizeof(buf), '/*') >= 0) THEN
        IF (MemFind (buf, sizeof(buf), 'void') >= 0) THEN
          BEGIN
          fCPP := MemFind ( buf, sizeof(buf), '::' ) >= 0;
          IF fCPP THEN sInhalt := 'C++' ELSE sInhalt := 'C';
          END


{     ELSE IF MemFind ( buf, sizeof(buf), '$('        ) >= 0 THEN sInhalt := 'makefile' }
      ELSE IF MemFind ( buf, sizeof(buf), #27'['      ) >= 0 THEN sInhalt := 'ANSI-Grafik-Sequenzen '
      ELSE IF MemFind ( buf, sizeof(buf), ':userdoc.' ) >= 0 THEN sInhalt := 'Hilfe f.OS/2 (IPF)'

      ELSE IF (MemFind (buf, sizeof(buf), #27')s') >= 0)
           OR (MemFind (buf, sizeof(buf), #27'(s') >= 0) THEN sInhalt := 'DruckDatei fr HP-Drucker (PCL)'

      ELSE IF ((MemFind ( buf, sizeof(buf),'NAME '  ) >= 0) AND
              (MemFind ( buf, sizeof(buf),'DATA ') >= 0))
           OR (MemFind ( buf, sizeof(buf),'EXPORTS ') >= 0) THEN sInhalt :='Modul-Definit.(DEF)'

      ELSE IF (MemFind ( buf, sizeof(buf),'Publics by Value'  ) >= 0) OR
              (MemFind ( buf, sizeof(buf),'Length Name ') >= 0) THEN sInhalt :='Linker Mapping (MAP)'

      ELSE IF (MemFind ( buf, sizeof(buf),'Subject:' ) >= 0) AND
              (MemFind ( buf, sizeof(buf),'From:') >= 0) THEN
             BEGIN
             hdl.res.sZitat := MemFindString( buf, sizeOf(buf), 'Subject:', #10)
                             + ' - '
                             + MemFindString( buf, sizeOf(buf), 'From:', #10);
             IF (MemFind ( buf, sizeof(buf),'Newsgroups:' ) >= 0)
               THEN BEGIN
                    sInhalt:='NetNews (NNTP) ';
                    AddStr(hdl.res.sZitat, ' - '+ MemFindString( buf, sizeOf(buf), 'Newsgroups:', #10));
                    END
               ELSE sInhalt:='eMail (SMTP) ';
             END;
      END;
    END; {for}

    {* Sprache bestimmen *}
    sResLang := LanguageTest(hdl);

{------------}

    sProp := '';
    IF opt.fSchwatz THEN
      BEGIN
      IF n8Bit>0
        THEN {AddStr(sProp,' 8 Bit')}
        ELSE IF n7Bit>0 THEN AddStr(sProp,' 7bit')
                        ELSE AddStr(sProp,{$IFDEF english}' CtrlChar'{$else}' Steuerz.'{$ENDIF});
      {IF nUmlaut>0  THEN AddStr(sProp,' Umlaute');}
      IF fTab                THEN AddStr(sProp,' Tab.');
      IF (nLF>0) AND (nCR=0) THEN AddStr(sProp,' Unix');
      IF (nLF=0) AND (nCR=0) THEN AddStr(sProp,{$IFDEF english}' one line only'{$else}' einzige Zeile'  {$ENDIF});
      IF fBELL               THEN AddStr(sProp,{$IFDEF english}' Bell'{$else}' Klingel'  {$ENDIF});
      IF fFF                 THEN AddStr(sProp,{$IFDEF english}' FormFeed'{$else}' Seitenvors.'{$ENDIF});
      IF fBS                 THEN AddStr(sProp,' Backspace');
      END;
    IF isUTF THEN AddStr(sInhalt,' UTF');

    hdl.res.art := cTEXT;
    hdl.res.sDesc := sInhalt+' '+sResLang+sProp;
    IF hdl.res.sMIMEType = '' THEN
      BEGIN
      hdl.res.sMIMEType := 'text/plain';
      IF isUTF THEN hdl.res.sMIMEType := 'text/plain; charset=UNICODE-1-1';
      END;

    SetzeZitat(hdl,0,isUTF);

    TextTest := true;
END;



FUNCTION DoXML (VAR hdl:t_File ; VAR buf; bufsize:longint) : BOOLEAN;
BEGIN
   DoXML := false;
   IF      EqStringIC(buf, '<?xml'    ) THEN hdl.res.sDesc := 'XML'
   ELSE IF EqStringIC(buf, '<schema ' ) THEN hdl.res.sDesc := 'XML-Schema'
   ELSE Exit;

   hdl.res.sMIMEType := 'application/xml';
   hdl.res.art := cTEXT;

   {* Jetzt suchen wi<r mal ein paar spezielle Varianten *}
   IF (MemFind ( buf, bufsize, '<svg' ) >= 0) THEN
      BEGIN
      hdl.res.sMIMEType := 'image/svg+xml';
      hdl.res.art := cGRAFIK;
      hdl.res.sDesc := 'SVG'
      END;

   DoXML := true;
END;



FUNCTION Is80x86Code (VAR hdl:t_File; ip : LongInt ) : BOOLEAN;
{* Teste, ob im File ausfhrbarer Code fr Intels 86er Familie drin ist *}
  CONST nReq = 6;
  TYPE cast = RECORD case Word OF
                0 : (a : ARRAY [1..6] OF BYTE);
                1 : (d : BYTE; w : WORD;    a1 : ARRAY [1..3] OF BYTE);
                2 : (d2: BYTE; i : Integer; a2 : ARRAY [1..3] OF BYTE);
                END;
  VAR x : ARRAY [1..6] OF BYTE;
      zip,
      n    : longint;
      fJmp,
      fDOS, fOldDos,
      fEND : BOOLEAN;
BEGIN
  Is80X86Code := FALSE;
  fEND := FALSE;  fDOS := FALSE; fJmp := FALSE; fOldDOS := FALSE;
  n := 0;
  REPEAT
    Inc (n);
    IF NRead(hdl, ip, x,sizeof(x) )=0 THEN ;;;;;
    {* Fr alle Files/Stellen die z.B. mit  anfangen ...}
    IF (x[1]=x[2]) AND (x[2]=x[3]) AND(x[3]=x[4]) AND(x[4]=x[5]) THEN Exit;
     IF IOResult <> 0 THEN fEnd := TRUE
      ELSE BEGIN
      CASE x[1] OF
        $06,  {PUSH ES}         $0E,  {PUSH CS}
        $07,  {POP S}
        $1E,  {PUSH DS}
        $58,  {pop ax}          $48,  {Dec dx}
        $FA,$FB, {CLI/STI}      $FC,  {CLD}
        $50 : {push ax} Inc(ip);

        $2c,  {SUB AL,xx}
        $31,$33, { XOR .... }   $3B,  {CMP reg,reg }
        $72,  {JB xx;}
        $73,  {JNB xx;}         $74,  {Je xx;}
        $75,  {JNE xx;}         $8c,  {Mov ?X,?S}
        $86,  {XCHG}            $8E,  {mov ss,dx...}
        $B0,  {MOV AL,xx}       $B4,  {MOV AH,xx}
        $B2 : {MOV dl,xx} Inc(ip,2);

        $CD : BEGIN {INT xx}
              IF x[2] = $21 THEN BEGIN
                                 fDOS := TRUE;
                                 fEnd := TRUE; { Es knnte ja AX=$4c sein..}
                                 END;
              IF x[2] = $20 THEN BEGIN
                                 fOldDOS := TRUE;
                                 fEnd := TRUE; { Es ist das Programmende }
                                 END;
              Inc(ip,2);
              END;

        $2d,  {SUB ....}
        $3d,  {CMP AX,xx yy}
        $A1,  {MOV AX,[xx yy]}
        $B8,  {MOV AX,xx yy}
        $BB,  {MOV BX,xx yy}
        $B9,  {MOV CX,xx yy}
        $BA,  {MOV DX,xx yy}
        $Be,  {MOV SI,xx yy}
        $Bf,  {MOV DI,xx yy}
        $BC:  {Mov SP,xx yy} Inc(ip,3);

        $2e: BEGIN
             IF {cast(x).w} ((x[2] SHL 8) + x[3]) = $8916
                THEN Inc(ip,5) {* 2e 89 16 xx yy  MOV CS:[xxyy],DS *}
                ELSE Inc(ip,3);
             END;
        $0b : CASE x[2] OF
                $C0 : Inc(ip,2);  {OR AX,AX}
                ELSE fEND := TRUE;
              END;
        $8b : CASE x[2] OF
                $fb : Inc(ip,2);  {MOV DI,BX}
                ELSE fEND := TRUE;
              END;

        $E8 : BEGIN {CALL xx yy}
              zip := ip;
              ip := ip+{cast(x).w}((x[3] SHL 8) + x[2])+3; {* Kein fJmp:=TRUE! *}
              IF ip > hdl.sr.size THEN ip := zip + 3;
              END;
        $EB : {JR  NEAr}   BEGIN ip := x[2]+2; fJmp := TRUE; END;
        $E9 : {JMP NEAr}   BEGIN ip := {cast(x).w}((x[3] SHL 8) + x[2])+3; fJmp := TRUE; END;
        ELSE fEND := TRUE;
        END {case};
        END;
  UNTIL (n>=nREQ+30) OR fEND;
  IF (n>=nReq) OR fJMP OR fDOS THEN
    BEGIN
    hdl.res.art := cEXEC;
    hdl.res.sDefExt := 'COM';
    IF      fOldDOS THEN hdl.res.sDesc := 'DOS ('+FnStr(n)+') (ltere/older Version)'
    ELSE IF fDOS    THEN hdl.res.sDesc := 'DOS ('+FnStr(n)+')'
                    ELSE BEGIN
                         hdl.res.sDesc := 'i80x86 ('+FnStr(n)+')';
                         hdl.res.sDefExt := '';
                         END;
    {NRead(hdl, ip,x,sizeof(x));Write(x[1]:4,x[2]:4,x[3]:4);}
    Is80X86Code := TRUE;
    END;
END;



FUNCTION COMTest(VAR hdl:t_File): BOOLEAN;
  VAR l : Longint;
      ff : BOOLEAN;
BEGIN
  COMTest := FALSE;
  l := fnReadDWORD(hdl,2);
  IF IOResult <> 0 THEN Exit;

  ff := Is80X86Code(hdl,0);
  IF TestForShortDesc(hdl)
    THEN BEGIN
         ff := true
         END
    ELSE BEGIN
         IF SearchCopyRight(hdl) THEN ff := true;
         END;
  COMtest := ff;
END;



FUNCTION DBaseTest(VAR hdl:t_File) : BOOLEAN;
  TYPE T_DBASE3 = RECORD  {* s.a. ct 12/89, S.184 allerdings nicht ganz korrejt *}
          id,   jahr,
          monat, day   : BYTE;
          AnzahlSaetze : LongInt;
          headersize,
          satzlen      : WORD;
        END;
  VAR H : T_DBASE3;
BEGIN
  DbaseTest := FALSE;
  IF NRead(hdl, 0, h, sizeof(h))=0 THEN ;;;;;
  {* Plausi: Zusammenhang Header, Satz und Filegrsse *}
  IF (h.AnzahlSaetze >= 0) AND (h.AnzahlSaetze <1000000) AND (h.satzlen<10000) THEN
    IF abs(hdl.sr.size - (h.headersize+h.anzahlSaetze*h.satzlen)) <=130 THEN
      IF (h.Monat in [1..12]) AND (h.day in [1..31]) THEN
       BEGIN
       DbaseTest := TRUE;
       Write(csDatabase,' - dBase,',h.anzahlSaetze:5,
               ' Stze  ',h.satzlen,' Byte, vom '
               ,h.day,'.',h.monat,'.',h.jahr)
       END;
END;


FUNCTION PGPTest(VAR hdl:t_File) : BOOLEAN;
  TYPE T_PGP = RECORD
                 ctb : BYTE;
                 data : ARRAY [1..20] OF BYTE;
                END;
  VAR H : T_PGP;
      typ : BYTE;
      s2,s : STRING;
      fSpecial,
      fEnde : BOOLEAN;
      version,algo,lenlen, nDurchlauf : integer;
      off : word;
      cOff,len : LongInt;
BEGIN
  pgpTest := FALSE;
  cOff := 0; nDurchlauf :=0;
  fEnde := false;
  REPEAT
    Inc(nDurchlauf);
    s := ''; version := 0; algo := 0; len := 0; off := 1;
    fSpecial := false;

    IF NRead(hdl, cOff, h, sizeof(h))=0 THEN ;;;;;
    IF IOresult>0 THEN fEnde := true;
    typ    := (h.ctb SHR 2) AND 15;
    lenlen := h.ctb AND 3;
    IF lenlen = 0 THEN BEGIN len := h.data[1];               off:=2; END;
    IF lenlen = 1 THEN BEGIN len := 256*h.data[1]+h.data[2]; off:=3; END;
    IF lenlen = 2 THEN BEGIN len := 256*(256*h.data[1]+h.data[2])+256*h.data[3]+h.data[4]; off:=5; END;
    IF lenlen = 3 THEN BEGIN len := 0; off:= 1 END;

    IF (typ=8) AND (h.data[off]=1)
      THEN BEGIN
           s := 'compressed data (maybe text signature)';
           version := -1;
           algo := -1;
           fSpecial := True;
           END
      ELSE IF (typ=1) THEN
             BEGIN
             s := 'public key encrypted';
             version := h.data[off];
             algo := h.data[off+9];
             END
      ELSE IF (typ=2) THEN
             BEGIN
             s := 'secret-key-encrypted (signature)';
             version := h.data[off];
             algo := h.data[off+15];
             END
      ELSE IF (typ=5) THEN
             BEGIN {secret key certificate}
             s := 'secret key cert., maybe "secring.pgp"';
             version := h.data[off];
             algo := h.data[off+7];
             END
      ELSE IF (typ=6) THEN
             BEGIN {public key certificate}
             s := 'public key cert., maybe "pubring.pgp"';
             version := h.data[off];
             algo := h.data[off+7];
             END
      ELSE IF (typ=9) THEN
             BEGIN {conventional enncryptet packet, nur typ und len sind gltig!}
             s := 'conventional encryptet';
             version := -1;
             algo := -1;
             END
      ELSE IF (typ=11) THEN
           BEGIN
           s := 'raw literal plaintext data, with filename and mode';
           version := -1;
           algo := -1;
           END
      ELSE IF (typ=12) AND (lenlen=0) AND (coff>0) THEN
           BEGIN {kann nie als erstes in einem File stehen}
           s := 'keyring trust packet';
           version := -1;
           algo := -1;
           END
      ELSE IF (typ=13) AND (lenlen=0) THEN
           BEGIN        {User ID packet, associated with public or secret key}
           s := 'user ID';
           version := -1;
           algo := -1;
           END
              ;

    IF version <> -1 THEN
      IF NOT (version in [2,3]) THEN EXit;
    IF algo <> -1 THEN
      IF not( algo in [1] )THEN EXit;
    IF len > hdl.sr.size THEN Exit;
    coff := coff + off + len;

    IF s<>'' THEN
       BEGIN
       IF opt.fChunks THEN Writeln( s );
       IF nDurchlauf<2 THEN
         BEGIN
         IF      Version = -1 THEN s2 := 'PGP - ' +s
         ELSE IF Version = 2  THEN s2 := 'PGP 2.5 (or sooner) - ' +s
                              ELSE s2 := 'PGP 2.6 (or later) - '+s;
         END;
       IF (nDurchlauf >=2) or fSpecial THEN
         BEGIN
         hdl.res.art := cDATEN;
         hdl.res.sDesc := s2;
         fEnde := true;
         pgpTest := true;
         END;
       END;
    IF len=0 THEN fEnde := true;
    fEnde := fEnde OR (nDurchlauf>1) AND  NOT opt.fChunks;
  UNTIL fEnde ;
END;



FUNCTION DoTrueType (VAR hdl:t_File): BOOLEAN;
  TYPE T_TTHeader=RECORD
                    Version : Longint;
                    nTables,bla1,bla2,bla3 : WORD;
                   END;
  TYPE T_TTTable =RECORD
                    id : Array[1..4] OF Char;
                    chksum,
                    offset,
                    len : Longint;
                   END;
  TYPE T_HNameTable =RECORD
                    format,n,off : WORD;
                   END;
  TYPE T_RNameTable =RECORD
                    platform,
                    encoding,  {ansi,ascii....}
                    language,
                    nameID,
                    len,
                    offs : WORD;
                   END;
{* BTW: Alles ist in BigEndian, also Motoralos hiLo ...}
  Var H : T_TTHeader;
      t : T_TTTable;
      nh : T_HNameTable;
      nr : T_RNameTable;
      i,j : WORD;
BEGIN
  DoTrueType := FALSE;
  IF NRead(hdl, 0, h, sizeof(h))=0 THEN ;;;;;
  h.ntables := swap(h.ntables);
  IF h.nTables > 499 THEN Exit;
  FOR i := 1 TO   h.ntables DO
    BEGIN
    IF NRead(hdl, 12+(i-1)*sizeof(t), t, sizeof(t))=0 THEN ;;;;;
    SwapLong(t.Len); SwapLong(t.offset);
    IF Eq(t.id,'name') THEN
      BEGIN
      DoTrueType := TRUE;
      hdl.res.art := cZeichensatz;
      hdl.res.sDesc := 'TrueType';
      IF NRead(hdl, t.offset, nh, sizeof(nh))=0 THEN ;;;;;
      nh.n := Swap(nh.n);
      FOR j := 1 TO nh.n DO
        BEGIN
        IF NRead(hdl, t.offset+(j-1)*sizeof(nr)+sizeof(nh),nr,sizeof(nr))=0 THEN ;;;;;
        IF (swap(nr.nameid) IN [4,5]) AND (swap(nr.platform) in [2,1]) THEN
           BEGIN
           hdl.res.sZitat := hdl.res.sZitat +
                 fnShortIt(GetASCIIN(hdl,t.offset+swap(nh.off)+swap(nr.offs), swap(nr.len)),0);
           END;
        END;
      END;
    END;
END;


PROCEDURE DoClp(VAR hdl:t_File);
  TYPE t_CLPHeader= RECORD
                      id : WORD;
                      nFormate : WORD;
                      { t_Formate }
                      END;
       T_Format = RECORD
                     FormatID : WORD;
                     LenData : Longint;
                     offsData : Longint;
                     nameZ : ARRAY [0..78] OF CHAR;
                     END;
  VAR Header : T_ClpHeader;
      Form : T_Format;
      i    : WORD;
      o    : Longint;
BEGIN
  hdl.res.art    := cDaten;
  hdl.res.sDesc := 'Clipboard (CLP)';
  IF NRead (hdl, 0,header,sizeof(Header))=0 THEN ;;;;;
  o := sizeof(header);
  FOR i := 1 TO header.nFormate DO
    BEGIN
    IF NRead (hdl,o,form,sizeof(Form))=0 THEN ;;;;;
    Inc(o,sizeof(Form));
    AddStr(hdl.res.sZitat, GetAsciiZ( hdl,o-sizeof(form.namez)) +'('+FnStr(Form.lenData)+') ');
     {If format = oemtext then write ersten 20 Zeichen...}
    END;
END;

FUNCTION DoExcel(VAR hdl:t_File) : BOOLEAN;
  TYPE T_BOF = RECORD
        typ : WORD;
        len : WORD;
        version, docuType : WORD;
        END;
  VAR H : T_BOF;
BEGIN
  DoExcel := TRUE;
  IF NRead(hdl, 0, h, sizeof(h))=0 THEN ;;;;;
  Case h.typ OF
    $0409 : Write(csData,' - Excel 4');
    $0309 : Write(csData,' - Excel 3');
    $0009 : Write(csData,' - Excel 2 oder lter');
    ELSE BEGIN
         DoExcel := FALSE;
         Exit;
         END;
    END{case};
{  Write (' Vers.',h.Version);}
  Case h.docutype OF
    $10 : Write(' - Tabelle');
    $20 : Write(' - ',csGrafic);
    $40 : Write(' - Makro');
    $100: Write(' - Arbeitsmappe');
  END{case};
END;

{---------------------------------------------------------------------------}


Procedure WriteDirSize( sDirName : T_strpchar; VAR nDateien:Longint);
  VAR  srDir : T_Suchrec;
       pushDosError,
       nSubDir, nLocFiles, lFilesize : Longint;
BEGIN
  pushDosError := DosError;
  DosError := 0;
  nSubDir := 0;
  nLocFiles := 0;
  lFilesize := 0;
  IF sDirName[length(sDirName)] = cPathSep THEN setLength (sDirname, length(sDirName)-1);
  FindFirst(StrConCat(sDirName,cPathSep+cWildCardAll), cANYFILE AND NOT cVOLUMEID, srDir );
{writeln(sDirName);}
  IF CheckIOResultNil('FiFi') <> 0 THEN  Exit;
  WHILE DOSError = 0 DO
    BEGIN
{writeln(srDir.name,' ',srDir.attr,'   ***'); }
    IF      ((srDir.attr AND cDirectory) <> 0)
       AND  (srDir.name<>'..') AND  (srDir.name<>'.') THEN Inc(nSubDir)
    ELSE IF (srDir.attr AND (cDirectory OR cVolumeID)) = 0 THEN
      BEGIN
      Inc(nLocFiles);
      Inc(lFileSize,srDir.size);
      END;
    FindNext(srDir);
    END;
  {$IFDEF english}
    Write (' ',nLocFiles, ' File',IfString(nLocFiles<>1,'s'),' - ',
  {$else}
    Write (' ',nLocFiles, ' Datei',IfString(nLocFiles<>1,'en'),' - ',
  {$ENDIF}
                fnFormStr(lFileSize),' Byte');
    IF nSubDir>0 THEN write(' - ', fnFormStr(nSubDir), ' Subdirs.');
  WriteLn;
  Inc(nFile,nLocFiles);
  Inc(nTotalByte,lFileSize);
  DosError := pushDosError;
  nDateien := nLocFiles;
END;



PROCEDURE SpyOneFile( CONST D:DirStr;   CONST N:NameStr;
                      CONST E:ExtStr;   CONST parasr:SearchRec);
  VAR hdl : T_FILE;
      buf : ARRAY [1..120] OF CHAR;

  PROCEDURE DumpIt(von,bis:word);
    VAR i : WORD;
        s : String;
  BEGIN
    s := '';
    FOR i := von TO Min(bis,hdl.sr.size) DO
      AddStr(s, fnByteHex(byte(buf[i])) + ' ' );
    AddStr(s,  {$IFDEF english} ' Len:'
                        {$else} ' Lnge:'
                       {$ENDIF} +FnStr(hdl.sr.size));
    AddStr(hdl.res.sZitat, s);
  END;

  PROCEDURE SetResultGen(art : T_ART; CONST sDesc,sZitat,sExt:STRING);
  BEGIN
    IF art <> cNIL  THEN hdl.res.art := art;
    IF sDesc  <> '' THEN hdl.res.sDesc := sDesc;
    IF sZitat <> '' THEN hdl.res.sZitat := sZitat;
    IF sExt   <> '' THEN hdl.res.sDefExt := sExt;
  END;


  PROCEDURE SetResult(art : T_ART; CONST sDesc:STRING);
  BEGIN
    SetResultGen(art, sDesc, '', '');
  END;
  PROCEDURE SetResultAutoZitat(art : T_ART; CONST sDesc:STRING; offs: Longint);
  BEGIN
    SetzeZitat(hdl,offs,false);
    SetResultGen(art, sDesc, '', '');
  END;
  PROCEDURE SetResZit(art : T_ART; CONST s,sZitat:STRING);
  BEGIN
    SetResultGen(art, s, sZitat, '');
  END;

  FUNCTION RTF(const s:String):BOOLEAN;
    VAR lloc : longint;
  BEGIN
    rtf := false;
    lLoc := FileFind ( hdl, Min(5000,hdl.sr.size), s ) ;
    IF lLoc > 0 THEN
      BEGIN
      SetResultGen(cTEXT,
         'Rich Text Format',
         fnGetASCIIStopch(hdl, lloc+length(s), 50, '}', #10, #13, ^z ),
         {* GetASCIICtrlN(hdl,lLoc+8,50,50, False,false), *}
         'RTF' );
      RTF := true;
      END;
  END;


  VAR nToRead, nReaded,
      nLength, lLoc : LongInt;
      s,sTmp : STRING;
BEGIN
  hdl.sr := parasr;
  hdl.d  := d;
  FillChar(hdl.res,sizeof(hdl.res), #0);
  hdl.res.art := cNIL;
{  hdl.res.sDesc   := '';
  hdl.res.sZitat   := '';
  hdl.res.sDefExt := '';
  hdl.res.sSchwatz := '';
  hdl.res.sDim     := '';
  hdl.res.sAdd     := '';
  hdl.res.sFehler  := '';
  hdl.res.sVers    := ''; }

  IF (length(n)>8) OR (length(e)>4) {- lange Dateinamen -}
    THEN BEGIN
         Write(n,e);
         nlength := length(n)+length(e);
         END
    ELSE BEGIN
         Write(n,'':8-length(n), e,'':4-length(e));
         nlength := 12;
         END;
  IF nLength > lastNlength THEN BEGIN
                                lastNlength := nlength;
                                sameNlength := 0;
                                END
                           ELSE BEGIN
                                Inc(sameNlength);
                                IF sameNlength > 20 THEN
                                  BEGIN
                                  {* Lange genug eingerckt *}
                                  lastNlength := nlength;
                                  sameNlength := 0;
                                  END;
                                END;
  Write('':lastNlength-nlength+1);

  IF opt.fSize THEN Write(hdl.sr.size:9);

  IF hdl.sr.size = 0
    THEN BEGIN
         hdl.res.art := cFehler;
         hdl.res.sDesc :=
         {$IFDEF english} 'Filelen = 0, so no filetype exist';
                  {$else} 'Kein Typ feststellbar, da Dateilnge = 0';
         {$ENDIF}
         END
    ELSE BEGIN
         filemode := $40;
         Assign(hdl.hExe,hdl.sr.name);
         Reset(hdl.hExe,1);
         IF CheckIOResult(hdl,'Reset:'+d+hdl.sr.name) = 0 THEN
           BEGIN
           {$IFDEF BP2}
           hdl.sr.size := filesize(hdl.hExe);
           {$ENDIF}
           IF hdl.sr.size < sizeof(buf)
             THEN BEGIN
                  nToRead := hdl.sr.size;
                  FillChar(buf, sizeof(buf),#$FE);
                  END
             ELSE nToRead := sizeof(buf);
           nReaded := NRead(hdl, 0,buf,nToRead);

           IF opt.fDumpOnly THEN BEGIN Write('   ');DumpIt(1,16); END
           ELSE IF Eq(buf,'MZ') THEN DoMZHeader(hdl)
           ELSE IF Eq(buf,#$FF#$FF#$FF#$FF#$14#$00) THEN SetResult(cDATEN,'OS/2 - INI-Datei ')
           ELSE IF Eq(buf,#$FF#$FF#$FF#$FF) AND
                       (((fnReadWord(hdl,4) AND $1720) = 0) OR
                         (isAscii(buf,$a,8) = -1)) THEN
                  BEGIN
                  IF (c(buf).w.w4 AND $8000) <> 0
                    THEN SetResultGen(cExec,csDRIVER+' - DOS Char-Device-Driver','','SYS')
                    ELSE SetResultGen(cExec,csDRIVER+' - DOS Block-Device-Driver','','SYS');
                  IF (isAscii(buf,$a,8) = -1)
                    THEN hdl.res.sZitat := GetASCIIN( hdl,$a,8 )
                    ELSE IF NOT TestForShortDesc(hdl)
                              THEN IF SearchCopyRight(hdl) THEN ;;;;
                  END
           ELSE IF Eq(buf,#$F0#$0d) THEN SetResultGen(cDEVEL,'Library','','LIB')
           ELSE IF Eq(buf,#$0a#$05) OR
                   Eq(buf,#$0a#$03) THEN DoPCX(hdl)
           ELSE IF Eq(buf,'?_'#3  ) THEN DoWinHlp(hdl)
           ELSE IF Eq(buf,'ITSF'  ) THEN SetResult(cHilfe,'Windows 98 - HTML based')
           ELSE IF Eq(buf,'LN'    ) THEN SetResult(cHilfe,'QuickHelp, Microsoft')
           ELSE IF Eq(buf,'PK'#3#4) THEN BEGIN IF DoZip(hdl,0,'') THEN;;; END
           ELSE IF Eq(buf,'e]'    ) THEN DoInstallShield2(hdl)
           ELSE IF Eq(buf,'SZ'    ) THEN DoMSCompress(hdl,0)
           ELSE IF Eq(buf,'KWAJ'  ) THEN DoMSCompress(hdl,0)
           ELSE IF Eq(buf,'MSCF'  ) THEN DoMSCompress(hdl,0)
           ELSE IF Eq(buf,'ARCV'  ) THEN DoMSCompress(hdl,0)

           ELSE IF Eq(buf,#04'%!') OR Eq(buf,'%!') THEN
                  BEGIN
                  s := '';
                  lLoc := FileFind ( hdl, 1024, '%Title' );
                  IF lLoc >= 0 THEN s := fnGetASCII26or13(hdl,lLoc+8);
                  SetResultGen(cDATEN,'Postscript/EPS',s,'');
                  END

           ELSE IF Eq(buf,'pk'#8#8) OR Eq(buf,'PK'#8#8) THEN BEGIN
                       SetResultGen(cEXEC,csDRIVER+' - Borland-Graph.-Interf.',
                       fnGetASCII26or13(hdl,4),'BGI')
                       END
           ELSE IF Eq(buf,'FBGD'#8#8#8#8) THEN BEGIN
                       SetResultGen(cEXEC,csDRIVER+' - Borland-Graph.-Interf.(neu)',
                       fnGetASCII26or13(hdl,8),'BGI');
                       END

           ELSE IF Eq(buf,'IC2')    THEN SetResult(cGrafik,'Icon/Symbolleiste - Lotus')
           {$IFnDEF FPK} {$B-} {$ENDIF}
           ELSE IF Eq(buf,'BM') AND DoBMP(hdl,0) THEN
           ELSE IF Eq(buf,'BA' )    THEN SetResultGen(cGrafik,'Icon - OS/2 (BitMap-Array)','','')
           ELSE IF Eq(buf,'CI' )    THEN SetResultGen(cGrafik,'Icon - OS/2 (CI)','','')
           ELSE IF Eq(buf,'IC' )    THEN SetResultGen(cGrafik,'Icon - OS/2 (IC)','','')
           ELSE IF Eq(buf,'lp' )    THEN SetResultGen(cGrafik,'- Segmented Hotspot Graphic','','SHG')
           ELSE IF Eq(buf,'II*')    THEN SetResultGen(cGrafik,'Tagged Immage File','','TIF' )

           {  ELSE IF Eq(buf,#01#00   THEN Write(' Windows-Meta-File   WMF?') }
           ELSE IF Eq(buf,#$D7#$CD#$C6#$9a) THEN SetResultGen(cGrafik,'Aldus Placeble Metafile','','WMF')
           ELSE IF Eq(buf, #$60#$EA ) THEN DoArj(hdl,0)
           ELSE IF Eq(buf, 'REGEDIT') THEN SetResultGen(cDATEN,
                                                    'Windows 3.x - Registr.'+csDatei,
                                                     FnShortIt(GetASCIICtrlN(
                                                       hdl,9,hdl.sr.size, 251,TRUE{auch CR bernemen},FALSE{ASCII}),24),
                                                     'REG'
                                           )
           ELSE IF Eq(buf, 'CREG')    THEN SetResultGen(cDaten,
                                           {$IFDEF english}'Win32 - Systemdatabase (registry)'
                                                   {$else} 'Win32 - Systemdatenbank (registry)'
                                                   {$ENDIF} ,'','DAT'
                                           )
           ELSE IF Eq(buf, 'RIFF')  THEN DoRIFF(hdl,TRUE)
           ELSE IF Eq(buf, 'RIFX')  THEN DoRIFF(hdl,FALSE) {Motorola RIFF}
           ELSE IF Eq(buf, 'FORM')  THEN DoIFF(hdl)
           ELSE IF Eq(buf[2], 'PNG')THEN SetResult(cGrafik,'PNG')
           ELSE IF Eq(buf, 'GIF8') THEN
                  BEGIN
                  SetResultGen(cGRAFIK,'GIF-8'+buf[5]+'a','','GIF');
                  hdl.res.nx := byte(buf[7])+256*byte(buf[8]) ;
                  hdl.res.ny := byte(buf[9])+256*byte(buf[10]);
                  hdl.res.bitpix := byte(buf[11]) AND 7;
                  END
           ELSE IF Eq(buf, #$ff#$d8) AND Eq(buf[7], 'JFIF') THEN
                  BEGIN
                  SetResultGen(cGrafik,
                               'JPEG, Vers. '+fnStr(byte(buf[12]))+'.0'+fnStr(byte(buf[13])),
                               '','JPG');
                  hdl.res.nx := byte(buf[16])+256*byte(buf[15]) ;
                  hdl.res.ny := byte(buf[18])+256*byte(buf[17]);
                  END
           ELSE IF Eq(buf, 'AC1')     THEN SetResultGen(cGrafik,'AutoCAD-Zeichnung','','DWG')
           ELSE IF Eq(buf, 'PMCC')    THEN SetResultGen(cDATEN,'Windows-Progamm-Manager-Gruppe',
                                                       GetAsciiZ(hdl,fnReadWord(hdl,$16)),'GRP' )
           ELSE IF Eq(buf, '.snd'#0#0)THEN SetResultGen(cKrach,' au',GetAsciiZ(hdl,$18),'au')
           ELSE IF Eq(buf, #$4C#$00#$00#$00#$01#$14#$02#$00#$00) THEN
                    BEGIN
                    CASE buf[$19] of
                      #$00 : sTmp := {$IFDEF english}'special file'{$ELSE}'Spezial-Datei' {$ENDIF};
                      #$10 : sTmp := {$IFDEF english}'directory'{$ELSE}'Ordner'{$ENDIF};
                      { #$20 : sTmp := 'file';}
                      ELSE sTmp := {$IFDEF english}'file'{$ELSE}'Datei'{$ENDIF};
                      END;
                    SetResultGen(cDaten,
                     {$IFDEF english}'Win32 - Link to '+sTmp
                              {$else}'Win32 - Querverweis auf '+sTmp
                     {$ENDIF} ,'','LNK');
                    END
           ELSE IF Eq(buf, '{\rtf')  THEN
                    BEGIN
                    IF   NOT RTF( '{\subject' ) THEN
                      IF NOT RTF( '{\title' ) THEN
                      IF NOT RTF( '{\author' ) THEN;;;
                    Hdl.res.sVers := fnReadChar(hdl,5)+' '+fnUpper(GetASCIIN(hdl,7,5));
                    END
           ELSE IF Eq(buf, '%PDF-1.' )  THEN
                    BEGIN {* s. ct 5/96 S.316 *}
                    lLoc := FileFindOffset ( hdl, hdl.sr.size-5000, 5000, '/Title (' ) ;
                    IF lloc < 0 THEN lLoc := FileFindOffset ( hdl, 0, 5000, '/Title (' ) ;
                    IF lloc <0 then lloc := -10;
                    SetResultGen(cTEXT, 'Adobe Acrobat',
                        GetASCIICtrlN(hdl,lLoc+8,50,50, False,false),
                        'PDF');
                    END
           ELSE IF Eq(buf, #00#01#00#00) AND DoTrueType(hdl) THEN
           ELSE IF Eq(buf, #01#00#00#00) AND ( (hdl.sr.size>$406+4) AND (FnReadN(hdl,$406,4) = 'Rich')) THEN
                                                 SetResult(cDaten,'Datenbank - MS Access')
           ELSE IF Eq(buf, 'HSP')   THEN
                  BEGIN
                  hdl.res.art    := cHilfe;
                  hdl.res.sDesc := 'OS/2';
                  IF      buf[4] =  #1 THEN hdl.res.sDefExt := 'INF'
                  ELSE IF buf[4] =#$10 THEN hdl.res.sDefExt := 'HLP'
                                       ELSE hdl.res.sDefExt := '???';
                  hdl.res.sZitat := GetASCIIZ( hdl,$6b );
                  END

           ELSE IF Eq(buf, #$ff#$fb) THEN SetResult(cKrach,'mp3')
           ELSE IF Eq(buf, #$ff#$f3) THEN SetResult(cKrach,'mp3')
           ELSE IF Eq(buf, #$ff#$e3) THEN SetResult(cKrach,'mp3')
           ELSE IF Eq(buf, #$ff#$fa) THEN SetResult(cKrach,'mp3')
           ELSE IF Eq(buf, 'ID3'   ) THEN SetResult(cKrach,'mp3 - ID3 v2')


           ELSE IF Eq(buf, #$ff#$ff#$18)THEN SetResult(cGrafik,'GEM')
           ELSE IF Eq(buf, #$FF'MKMSG' )THEN SetResult(cDATEN,'OS/2 - (Fehler-) Meldungen')

           ELSE IF Eq(buf, #$FF'WPC'#$10#$00)THEN SetResult(cGrafik,'Wordperfect (WPG)')
           ELSE IF Eq(buf, #$FF'WPC'#$AA#$84)THEN SetResult(cText,'Wordperfect (WP5)')
           ELSE IF Eq(buf, #$FF'WPC'#$c8#$18)THEN SetResult(cText,'Wordperfect (WP)')
           ELSE IF Eq(buf, #$FF'WPC'       ) THEN
                 BEGIN
                 hdl.res.art    := cDaten;
                 hdl.res.sDefExt := 'WP?';
                 hdl.res.sDesc := {$IFDEF english}
                                    'Wordperfect stuff - ';
                                    {$else}
                                    'Kram von Wordperfect - ';
                                   {$ENDIF}
                 IF      Eq(buf[9],#$01#$01) THEN AddStr(hdl.res.sDesc,'Makro')
                 ELSE IF Eq(buf[9],#$01#$02) THEN AddStr(hdl.res.sDesc,'Help')
                 ELSE IF Eq(buf[9],#$01#$03) THEN AddStr(hdl.res.sDesc,'Keyboard definition')
                 ELSE IF Eq(buf[9],#$01#$0A) THEN AddStr(hdl.res.sDesc,'Dokument')
                 ELSE IF Eq(buf[9],#$01#$0B) THEN AddStr(hdl.res.sDesc,'Dictionary')
                 ELSE IF Eq(buf[9],#$01#$0C) THEN AddStr(hdl.res.sDesc,'Thesaurus')
                 ELSE IF Eq(buf[9],#$01#$0D) THEN AddStr(hdl.res.sDesc,'Block')
                 ELSE IF Eq(buf[9],#$01#$0E) THEN AddStr(hdl.res.sDesc,'Rectangular block')
                 ELSE IF Eq(buf[9],#$01#$0F) THEN AddStr(hdl.res.sDesc,'Column block')
                 ELSE IF Eq(buf[9],#$01#$10) THEN AddStr(hdl.res.sDesc,'printer resource file (PRS)')
                 ELSE IF Eq(buf[9],#$01#$11) THEN AddStr(hdl.res.sDesc,'Setup')
                 ELSE IF Eq(buf[9],#$01#$12) THEN AddStr(hdl.res.sDesc,'Prefix information')
                 ELSE IF Eq(buf[9],#$01#$13) THEN AddStr(hdl.res.sDesc,'printer resource (ALL)')
                 ELSE IF Eq(buf[9],#$01#$14) THEN AddStr(hdl.res.sDesc,'display resource (DRS)')
                 ELSE IF Eq(buf[9],#$01#$15) THEN AddStr(hdl.res.sDesc,'Overlay (WP.FIL)')
                 ELSE IF Eq(buf[9],#$01#$16) THEN AddStr(hdl.res.sDesc,'Graphics (WPG)')
                 ELSE IF Eq(buf[9],#$01#$17) THEN AddStr(hdl.res.sDesc,'hyphenation code module')
                 ELSE IF Eq(buf[9],#$01#$18) THEN AddStr(hdl.res.sDesc,'hyphenation data module')
                 ELSE IF Eq(buf[9],#$01#$19) THEN AddStr(hdl.res.sDesc,'macro resource (MRS)')
                 ELSE IF Eq(buf[9],#$01#$1A) THEN AddStr(hdl.res.sDesc,'graphics driver (WPD)')
                 ELSE IF Eq(buf[9],#$01#$1B) THEN AddStr(hdl.res.sDesc,'hyphenation lex module')
                 ;
                 END

           ELSE IF Eq(buf, #$32#$5e#$10#$10) THEN SetResult(cTEXT,'Envoy (Novell)')
           ELSE IF Eq(buf, #$D0#$cf#$11#$e0) THEN DoKleinWeichVerbundDatei(hdl)
           ELSE IF Eq(buf, 'ELF'      )THEN DoELF(hdl)
           ELSE IF Eq(buf, 'FBOV'      )THEN SetResult(cEXEC,'DOS EXE Overlay (Turbo Pascal) fbov')
           ELSE IF Eq(buf, 'TPOV'      )THEN SetResult(cEXEC,'DOS EXE Overlay (Borland) tpov')
           ELSE IF Eq(buf, 'TPUQ'      )THEN SetResultGen(cDEVEL,'Turbo Pascal Unit, Version 7',
                                                       fnShortIt(fnGetPasStr(hdl,$E5),255),'TPU')
           ELSE IF Eq(buf, 'TPU9'     ) THEN SetResultGen(cDEVEL,'Turbo Pascal Unit, Version 6',
                                                       fnGetPasStr(hdl,$E5) ,'TPU')
           ELSE IF Eq(buf, 'TPU6' )     THEN SetResultGen(cDEVEL,'Turbo Pascal Unit, Version 5.5',
                                                       fnGetPasStr(hdl,$c5) ,'TPU')
           ELSE IF Eq(buf, 'TPU0' )     THEN SetResultGen(cDEVEL,'Turbo Pascal Unit, Version 4',
                                                       fnGetPasStr(hdl,$c8) ,'TPU')
           ELSE IF Eq(buf, 'TPU'  )     THEN SetResult(cDEVEL,'Turbo Pascal Unit')
           ELSE IF Eq(buf, 'PPU013' )   THEN SetResultGen(cDEVEL,'FPC Pascal Unit, Version 0.9.5','' ,'PPU')
           ELSE IF Eq(buf, 'PPU'  )     THEN SetResult(cDEVEL,'FPC Pascal Unit')
           ELSE IF Eq(buf, 'TPS'  )     THEN SetResZit(cDEVEL,'Turbo Pascal Symbole',
                                                      fnShortIt(GetAsciiZ(hdl,$14),255))
           ELSE IF Eq(buf, 'PNCI' )     THEN SetResult(cDaten, {$IFDEF english} 'Norton stuff'
                                                               {$else}'Kram von Norton'
                                                               {$ENDIF}
                                             )
           ELSE IF Eq(buf, 'FBHF' )     THEN SetResult(cHilfe,'Turbo Vision ')
           ELSE IF Eq(buf, 'SHCC' )     THEN SetResult(cDaten,'Windows 3.x - System-Datenbank')
           ELSE IF Eq(c(buf).w2.b5,#0'JFO'#0) THEN SetResult(cGrafik,'ABC-Fludiagramm')
           ELSE IF Eq(buf, #$76#$17)    THEN SetResult(cDaten,'Windows-Macro-Recorder '+csDatei)

           ELSE IF Eq(buf, 'ZOO') AND DoZoo(hdl) THEN{}
           ELSE IF Eq(buf, #$1f#$8b )       THEN DoGnuZip(hdl,0,hdl.sr.size)
           ELSE IF Eq(buf, #$1f#$9d  )      THEN DoGnuZip(hdl,0,hdl.sr.size)
           ELSE IF Eq(buf, #$a5#$96{#$fd#$ff})THEN DoBundle(hdl)
           ELSE IF Eq(buf, 'Clay'        )  THEN SetResZit(cArchiv,
                                                   'Lotus Install. (CMZ)',
                                                   GetASCIICtrlN(hdl,$14,20,20,FALSE,FALSE)
                                                 )
           ELSE IF Eq(buf[3], '-lh' ) AND DoLHArc(hdl,0) THEN

           ELSE IF Eq(buf, #$0d#$0a'*** GP-SPY')THEN SetResult(cText,'Graphic-Packet Spy Mitschnitt')
           ELSE IF Eq(buf, #$ed#$de#$ad#$0b) THEN SetResult(cGrafik,'PowerPoint (PPT)')
           ELSE IF Eq(buf, #$fc#$04#$02#$00) THEN SetResult(cDEVEL,'Visual-Basic-Kram (.bas)')
           ELSE IF Eq(buf, #$ff#$cc        ) THEN SetResult(cDEVEL,'Visual-Basic-Kram (.FRM)')
           ELSE IF Eq(buf, #$23#$cc        ) THEN SetResult(cDEVEL,'Visual-Basic-Kram (.FRM)')
           ELSE IF Eq(buf, #$FF#$03        ) THEN SetResult(cDEVEL,'Resource File (RES)' )
           ELSE IF Eq(buf, #09  ) AND DoExcel(hdl) THEN
           ELSE IF (buf[1] = #26) AND DoArc(hdl,0) THEN
           ELSE IF Eq(buf, #$00#$0d     )    THEN BEGIN
                                                  SetResult(cDaten,csSPIEL+' SimCity Classic');
                                                  hdl.res.sZitat := GetAsciiZ(hdl,2);
                                                  END
           ELSE IF Eq(buf, '!<arch>'    )          THEN DoArch(hdl, 8)
           ELSE IF DoXML(hdl,buf,nReaded)          THEN

           ELSE IF EqJoker(buf, '#!?/bin/sh'  )    THEN SetResultAutoZitat(cEXEC,'Bourne-Shell-script',11)
           ELSE IF EqJoker(buf, '#!?/bin/bash')    THEN SetResultAutoZitat(cEXEC,'Bourne-Again-Shell-script',13)
           ELSE IF EqJoker(buf, '#!?/bin/csh' )    THEN SetResultAutoZitat(cEXEC,'C-Shell-script',12)
           ELSE IF EqJoker(buf, '#!?/bin/ksh' )    THEN SetResultAutoZitat(cEXEC,'Korn-Shell-script',12)
           ELSE IF EqJoker(buf, '#!?/bin/awk' )    THEN SetResultAutoZitat(cEXEC,'awk-script',12)
           ELSE IF EqJoker(buf, '#!?/bin/perl')    THEN SetResultAutoZitat(cEXEC,'Perl-script',13)
           ELSE IF EqJoker(buf, '#!?/usr/bin/perl')THEN SetResultAutoZitat(cEXEC,'Perl-script',18)

           ELSE IF Eq(buf, #$13#$5d#$65#$8c)       THEN DoInstallShield(hdl)
           ELSE IF Eq(buf, cRAR ) AND DoRAR(hdl,0) THEN
           ELSE IF Eq(buf, 'MThd'       )          THEN DoMidi(hdl)
           ELSE IF (c(buf).fl.b5= $AF) AND (c(buf).fl.b4 in [$11,$12])  THEN
                  BEGIN {ct 8/94 s.251}
                  hdl.res.art    := cGrafik;
                  hdl.res.sDesc :=' Video - Autodesk Animator ';
                  IF c(buf).fl.b4= $11 THEN AddStr(hdl.res.sDesc,'(FLI)');
                  IF c(buf).fl.b4= $12 THEN AddStr(hdl.res.sDesc,'(FLC)');
{$R-,Q-}
                  AddStr( hdl.res.sDesc,
                          FnStr(c(buf).fl.w8) + '*' + FnStr(c(buf).fl.w10) + ' '
                        + FnStr(POWERTWO[c(buf).fl.w12])           + ' Farb. '
                        + FnStr(c(buf).fl.w6*c(buf).fl.w16 div 70) + 's '
                        + FnStr(c(buf).fl.w6)                      + ' Frames'
                  );
                  spielDauer := spielDauer + c(buf).fl.w6*c(buf).fl.w16 div 70;
{$R+,Q+}
                  END
           ELSE IF Eq(buf, 'CTMF') THEN SetResult(cKRACH,'CMF (Soundblaster)')
           ELSE IF Eq(buf, 'Creative Voice File'#$1a) THEN DoVoc(hdl)
           ELSE IF Eq(buf, 'NetWare Loadable Mod') THEN
                  BEGIN
                  SetResult(cExec,'NetWare-Server');
                  hdl.res.sDefExt := 'NLM';
                  hdl.res.sZitat := fnGetPasStr( hdl,$82 );
                  END
           ELSE IF Eq(buf, #27'[')           THEN SetResult(cGrafik,'ANSI')
           ELSE IF Eq(buf, 'AH'  )           THEN SetResult(cGrafik,'Dr.Halo / Genius') {ct 12/92 s.234}
           ELSE IF Eq(buf,'1'#$BE)           THEN DoWordOrWrite(hdl)
           ELSE IF Eq(buf,'2'#$BE)           THEN SetResultGen(cText,'Write (Windows)','','WRI')
           ELSE IF Eq(buf,#$DB#$A5)          THEN
                  BEGIN
                  SetResult(cText,'Word f.Win. 2.0 ');
                  lLoc := fnReadDWord(hdl,$118);
                  IF lLoc <> 0 THEN
                    BEGIN
                    IF fnReadByte(hdl,lLoc+3) <> 0
                      THEN lLoc := lLoc+3+1+fnReadByte(hdl,lLoc+3)
                      ELSE Inc(lLoc,4);
                    hdl.res.sZitat := fnGetPasStr(hdl,lLoc);
                    hdl.res.sDefExt:= 'DOC';
                    END;
                  END
           ELSE IF Eq(buf,#$50#$c3)   THEN DoClp(hdl)
           ELSE IF Eq(buf,'[v'    )   THEN
                  BEGIN
                  SetResult(cText,'AmiPro f.Windows' );
                  lLoc := FileFind ( hdl, 1024, '[desc]'#$0d#$0a );
                  IF lLoc >= 0 THEN hdl.res.sZitat := fnGetASCII26or13(hdl,lLoc+9);
                  END
           ELSE IF Eq(buf[5], 'mdat') THEN SetResult(cVideo,'Quicktime (Apple) (?)' )

           ELSE IF Eq(buf, 'LX') THEN DoLx(hdl,0)
           ELSE IF (buf[1] = #$80) AND DoObj(hdl)   THEN
           ELSE IF Eq(buf, 'SWG2') THEN
                  BEGIN
                  s := GetASCIIZ(hdl, $153);
                  IF s = '' THEN s := GetASCIIZ(hdl, $d3);
                  SetResultGen(cTEXT,'Starwriter 2.0',s,'');
                  END
           ELSE IF Eq(buf, 'SVGD')                  THEN SetResult(cGRAFIK,'Stargraph(?)')
           ELSE IF Eq(buf, #0#0#4#0#92#114#111#108) THEN SetResultGen(cKRACH,'Soundblaster','','ROL')
           ELSE IF Eq(buf[7], #$3B#$C4#$73#$67#$8B#$C4#$2D#$44#$03)
                                                    THEN SetResultGen(cEXEC,'DOS -'+csgepackt+' PKLite 1.13','','COM')
           ELSE IF Eq(buf[7], #$3B#$C4#$73#$69#$8B#$C4#$2D#$44#$03)
                                                    THEN SetResultGen(cEXEC,'DOS -'+csgepackt+' PKLite 1.15','','COM')
           ELSE IF Eq(buf, #$CA#$FE#$BA#$BE{#$00#$03})
                                                    THEN BEGIN
                                                         SetResultGen(cEXEC, 'Java class','','class' );
                                                         hdl.res.sVers := fnStr( fnReadWordLE( hdl, 6) )
                                                                        + '.'
                                                                        + fnStr( fnReadWordLE( hdl, 4) );
                                                         END
           ELSE IF Eq(buf, #$DE#$12#$04#$95       )
                OR Eq(buf, #$95#$04#$12#$DE       ) THEN SetResultGen(cDATEN, 'GNU gettext Sprachdateien','','GMO' )
           ELSE IF Eq(buf, #$ed#$ab#$ee#$DB       ) THEN SetResultGen(cArchiv, 'RedHat-Linux-Package',
                                                                               fnShortIt(GetAsciiZ(hdl,$0a),70),'RPM')
           ELSE IF Eq(buf, #0#0#3#$f3#0#0#0#0     ) THEN SetResult(cEXEC, 'Commodore Amiga' )
           ELSE IF Eq(buf, #$e3#$10        )        THEN SetResultGen(cDATEN,'Resourcen fr Amiga','','INF' )
           ELSE IF Eq(buf, #$60#$1a         )       THEN SetResult(cEXEC,'Atari ST etc' )
           ELSE IF Eq(buf, #01#$fE{#$51#$47})       THEN SetResult(cText,'MS Works?')
           ELSE IF Eq(buf, #$02#$00#$00#$20  )      THEN SetResultGen(cHILFE,
                                                         'Windows - Index fr Volltextsuche','','FTS')
           ELSE IF Eq(buf, #$f7#$02#$01       )     THEN SetResultGen(cDATEN,'Text - TeX','','DVI')
           ELSE IF Eq(buf, 'FLIB'             )     THEN SetResult(cZEICHENSATZ,'TeX - fr Drucker')
           ELSE IF Eq(buf, 'ie'               )     THEN SetResult(cDATEN,' Kodierer - BS, Datei-Aufteiler (AFu) - Teil '+
                                                               fnStr(byte(buf[4]))+' von insg.'+fnStr(byte(buf[3])))
           {* c't 12/91 S.205    2/89 S.206 *}
           ELSE IF    Eq(buf, 'ps09') OR Eq(buf, 'PS09')
                   OR Eq(buf, 'ps24') OR Eq(buf, 'PS24')
                   OR Eq(buf, 'ls30') OR Eq(buf, 'LS30')
                           THEN SetResult(cZeichensatz,'Signum - Druckerfont (Atari ST) (ungetestet!)' )
           ELSE IF    Eq(buf, 'ES24') OR Eq(buf, 'es24')
                   OR Eq(buf, 'ESET') OR Eq(buf, 'eset')
                           THEN SetResult(cZeichensatz,'Signum - Editorfont (Atari ST) (ungetestet!)' )

{                ELSE IF Eq(buf, #0#0#2#0#4#4) OR THEN Write(' Daten - Works/1-2-3 (?)')
           ELSE IF Eq(buf, #0#0#2#0#6#4#6#0       ) THEN Write(' Daten - Kram von Lotus 1-2-3 (WK1)' )
}
           ELSE IF Eq(buf[3], #$00#$08#$01) THEN SetResult(cDaten,'Datenbank - Paradox fr Windows (?)')
           {$IFnDEF FPK} {$B-} {$ENDIF}
           ELSE IF (buf[1] = #0) AND DoZero(hdl) THEN
           ELSE IF buf[1] = '['  THEN SetResZit(cTEXT,'Init.',FnShortIt(GetASCIICtrlN(
                                       hdl,0,hdl.sr.size, 251,TRUE{auch CR bernemen},FALSE{ASCII}),51)
                                      ) {* $TODO:inderselbenZeile muss auch ein ] sein *}

           ELSE IF (buf[1] = #2)   AND DBaseTest(hdl) THEN
           ELSE IF (buf[1] = #3)   AND DBaseTest(hdl) THEN
           ELSE IF (buf[1] = #$83) AND DBaseTest(hdl) THEN
           ELSE IF (buf[1] = #$8b) AND DBaseTest(hdl) THEN
           ELSE IF (buf[1] = #$f5) AND DBaseTest(hdl) THEN

           ELSE IF Eq(buf, #$0b#$01#$64) THEN
                  BEGIN
                  hdl.res.art    := cExec;
                  hdl.res.sDesc := 'Linux Binaries (b)';
                  DumpIt(4,11);
                  END
           ELSE IF Eq(buf, #$07#$01#$64) THEN
                  BEGIN
                  hdl.res.art    := cExec;
                  hdl.res.sDesc := 'Linux Binaries (7)';
                  DumpIt(4,11);
                  END

           ELSE IF (buf[1]<>#0) AND (buf[99]=#0) AND TarTest(hdl) THEN {muss vor TextTest sein}

           ELSE IF TextTest(hdl) THEN

           ELSE IF COMTest(hdl) THEN
           ELSE IF (buf[1]>#$7f) AND PGPTest(hdl) THEN
           ELSE IF TargaTest(hdl) THEN
           ELSE IF (buf[3] = #2) AND (buf[4]=#0) AND (buf[6]=#0) THEN
                     SetResult(cDEVEL,'ext.Debug-Infos (SYM)')
           ELSE IF (nreaded >= 2) AND (buf[1] = #$ff) AND (buf[2]=#$fe) THEN
                     BEGIN
                     SetResult(cTEXT,'UTF-8')
                     END

           ELSE BEGIN {* Unbek.Dateiart *}
                Inc(nUnknownFiles);
                hdl.res.art := cFehler;
                hdl.res.sDesc :=  {$IFDEF english}'Unknown filetype:'
                                           {$ELSE}'Unbek.Dateiart:'
                                  {$ENDIF};
                DumpIt(1,9);
                IF opt.fSucheCopyRight THEN IF SearchCopyRight(hdl) THEN;;;
                END;
           Close(hdl.hExe);
           END;
         END;
  IF CheckIOResult(hdl,'')<> 0 THEN ;


  IF (hdl.res.art = cNIL) AND
     ( (hdl.res.sDesc <> '') OR (hdl.res.sZitat <> '') ) THEN
        hdl.res.art := cANDERE;
  IF hdl.res.sMIMEType = '' THEN
    BEGIN
    hdl.res.sMIMEType := 'application/octet-stream';
    END;

  IF opt.fMIMETypeOnly
    THEN BEGIN
         Write(' ',hdl.res.sMIMEType)
         END
    ELSE BEGIN
         IF hdl.res.art <> cNIL THEN
           BEGIN
           CASE hdl.res.art OF
             cDATEN : WRITE (csDATA,' -');
             cEXEC  : WRITE (csExec,' -');
             cDEVEL : WRITE (csDEVEL,' -');
             cKRACH : WRITE (csSound,' -');
             cGRAFIK: WRITE (csGrafic,' -');
             cArchiv: WRITE (csArchiv,' -');
             cTEXT  : WRITE (csText,' -');
             cZeichenSatz :
                      WRITE ({$IFDEF english}' font -'{$ELSE}' Zeichensatz -'{$ENDIF});
             cHilfe : WRITE ({$IFDEF english}' help -'{$ELSE}' Hilfe -'{$ENDIF});
             cVIDEO : WRITE ({$IFDEF english}' movie -'{$ELSE}' Filmchen -'{$ENDIF});
             cFehler: WRITE (' -');
             cANDERE: WRITE ({$IFDEF english}' binary -'{$ELSE}' Binr -'{$ENDIF});
             END; {case}
           END;

         s := F_TrimLR(hdl.res.sDesc);
         IF s                 <> '' THEN Write(' ',  s );
         IF hdl.res.nx         > 0  THEN Write(' ',  hdl.res.nx,'*',hdl.res.ny);
         IF hdl.res.bitPix     > 0  THEN Write(' ',  hdl.res.bitpix,' Bit/pix');
         IF hdl.res.nFarben    > 0  THEN Write('  ', hdl.res.nFarben,' Farben');
         IF hdl.res.nStueck    > 1  THEN Write('  ', hdl.res.nStueck,' Stck');
         IF hdl.res.sZitat    <> '' THEN Write(' "', fnShortIt(hdl.res.sZitat,0),'"');
         IF hdl.res.sVers     <> '' THEN Write(' Vers.',hdl.res.sVers);
         IF hdl.res.sDefExt   <> '' THEN Write(' (.',fnupper(hdl.res.sDefExt),')');
         IF opt.fSchwatz AND
          (hdl.res.sMIMEType <> '') THEN Write(' ',hdl.res.sMIMEType);
         IF hdl.res.sAdd      <> '' THEN Write(' / ',hdl.res.sAdd);
         IF opt.fSchwatz AND
           (hdl.res.sSchwatz <> '') THEN Write(' - ',hdl.res.sSchwatz);
         IF hdl.res.sFehler   <> '' THEN Write(' ---',hdl.res.sFehler);
         END;
  WriteLn;
END;


END.
