{* Copyright (C) 2002 Free Software Foundation, Inc.
 * Copyright (C) 1995-2002 Walter Koch
 *
 * This file is part of Filespy.
 *
 * Filespy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Filespy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *}


Unit fs_opt;
{* Auswertung Parameter, durchsuchen der Directorys  *}

{$I filespy.inc}

INTERFACE
Uses FS_Div,
     FS_Def;

PROCEDURE Main;
{ROCEDURE DoOneDir ( sPara : t_STRpchar; sTitel:STRING);}
PROCEDURE DoManyDir ( CONST sPara  : STRING;
                      CONST sTitel : STRING);

{-----------------------------------------------------------------------}

IMPLEMENTATION
USES DOS, portpas,
     FS_Spy,
     FS_Util,
    {$IFDEF PMVersion} WinCRT {$ELSE} CRT {$ENDIF}
    ;


PROCEDURE DoOneDir ( sPara : t_STRpchar; sTitel:STRING);
VAR D : DirStr;
    N : NameStr;
    E : ExtStr;
    sCurDir  : t_STRPChar;
    sr       : T_SortHandle;
    nDateien : LongInt;
    sFExpand_sPara : String;
    fDirAlreadyWritten : BOOLEAN;
BEGIN
  GetDir(0,sCurDir);
  IF CheckIOResultNil(sCurDir) <> 0 THEN Exit;
  DoKeyTest;
  IF Pos(sDirExclude,fnUpper(sCurDir)) > 0 THEN Exit; {* Gross/Kleinschreibung ignorieren *}

  sFExpand_sPara := FExpand(sPara);
  FSplit(sFExpand_sPara,d,n,e);
  fDirAlreadyWritten := sgLastDir = d; {* Hatten wir dieses Dir. schon? *}
  sgLastDir := d;

  {* Ausgabeverschnerer resetten *}
  lastNlength := 0;
  sameNlength := 0;

  IF NOT fDirAlreadyWritten THEN Inc(nDir);

  DosError := 0;
  FindFirstSort(sFExpand_sPara, cANYFILE AND NOT cDIRECTORY AND NOT cVolumeID , sr );
  IF CheckIOResultNil(sCurDir) <> 0 THEN Exit;
  WHILE DOSError = 0 DO
    BEGIN  {$I-}
    DoKeyTest;
    FSplit(strconcat(d,sr.dossr.name),d,n,e);
    IF Pos(sFileExclude,fnUpper(sr.dossr.name)) = 0 THEN
      BEGIN
      IF NOT fDirAlreadyWritten THEN
        BEGIN
        IF NOT opt.fPfad THEN
          BEGIN
          WriteLn;
          IF sTitel<>'' THEN AddChar(sTitel,' ');
          Write('*** ',sTitel,sCurDir,' ***');
          WriteDirSize(sCurDir,nDateien);
          END;
        fDirAlreadyWritten := TRUE;
        Inc(nDirFound);
        END;
      Inc(nFileFound);
      Inc(nTotalByteFound,sr.dossr.size);
      IF opt.fPfad THEN Write(sCurDir:40,cPATHSEP);
      SpyOneFile (d,n,e,sr.dossr);
      END;
    FindNextSort( sr );
    END; {While}
END;



PROCEDURE DoManyDir ( CONST sPara  : STRING;
                      CONST sTitel : STRING);
VAR srDir : T_SuchRec;
    sMask : String[15];
    sCurDir : STRING;
    D : DirStr;
    N : NameStr;
    E : ExtStr;
BEGIN
  FSplit(sPara,d,n,e);
  {* Zunchst alle Files in diesem Directory bearbeiten *}
  GetDir(0,sCurDir);
  IF CheckIoResultNil('GetDir') <> 0 THEN Exit;
  IF Pos(sDirExclude,sCurDir) > 0 THEN Exit;
  sMask := n+e;
  DoOneDir(sPara,sTitel);
  {* Und nun alle Directorys *}
  FindFirst(d+'*.*', DIRECTORY, srDir );
  WHILE DOSError = 0 DO
    BEGIN
    IF ((srdir.attr AND DIRECTORY) <> 0) AND
       (srDir.name<>'.') AND
       (srDir.name<>'..') {AND
       (Pos(sFileExclude,srDir.Name) = 0)} THEN
      BEGIN
      ChDir(srDir.name);
      IF CheckIoResultNil(srDir.name) = 0 THEN
        BEGIN
        DoManyDir ( sMask , sTitel);
        ChDir('..');
        IF CheckIoResultNil(srDir.name+'..') <> 0 THEN Exit;
        END;
      END;
    FindNext( srDir );
    END;
END;


VAR ExitSave : Pointer;

PROCEDURE MyExit; {$IFnDef FPK} FAR; {$ENDIF}
BEGIN
  IF CheckIOResultNil('Exit...') =0 THEN;;;;;;;;;;
  IF (ExitCode=255) OR (ExitCode=EXITCODE_CTRLC) THEN
    BEGIN
    WriteLn;
    Writeln('-------------------------------------------------------------------');
    WriteLn(
     {$IFDEF english} ' Cancled on user request'
              {$ELSE} ' Auf Benutzerwunsch hin abgebrochen'
     {$ENDIF});
    END;
  IF (ExitCode<>EXITCODE_WRONGPARA) AND (NOT fNOSUMMARAY) THEN
    BEGIN
{$IFDEF ENGLISH}
    Writeln('-------------------------------------------------------------------');
    Writeln(' ',nFile, ' file',IfString(nFile<>1,'s'),' with ',
                fnFormStr(nTotalByte),' bytes in ',
                fnFormStr(nDir), ' directory',IfString(nDir<>1,'s'),' found');
    Writeln(' ',nFileFound, ' file',IfString(nFileFound<>1,'s'),' with ',
                fnFormStr(nTotalByteFound),' bytes in ',
                fnFormStr(nDirFound), ' directory',IfString(nDirFound<>1,'s'),
                ' scanned');
{$ELSE}
    Writeln('-------------------------------------------------------------------');
    Writeln(' ',nFile, ' Datei',IfString(nFile<>1,'en'),' mit ',
                fnFormStr(nTotalByte),' Bytes in ',
                fnFormStr(nDir), ' Verzeichnis',IfString(nDir<>1,'se'),' in Erwgung gezogen');
    Writeln(' ',nFileFound, ' Datei',IfString(nFileFound<>1,'en'),' mit ',
                fnFormStr(nTotalByteFound),' Bytes in ',
                fnFormStr(nDirFound), ' Verzeichnis',IfString(nDirFound<>1,'sen'),
                ' untersucht');
{$ENDIF}
    IF spielDauer > 0 THEN
      Writeln ({$IFDEF english}' Movie/Sound-playtime ',spieldauer:1:0,' seconds'
                        {$ELSE}' Film/Krach-Spieldauer ',spieldauer:1:0,' Sekunden'
               {$ENDIF});
    IF nUnknownFiles > 0 THEN
      Writeln ({$IFDEF english}' There are ',nUnknownFiles,' unknown Files'
                        {$ELSE}' Davon ',    nUnknownFiles,' unbekannte Dateien'
               {$ENDIF});
    IF nTotalByteUnComp <> 0 THEN
      BEGIN   {$Q-}
      WriteLn(' ',nArchiv,{$IFDEF english}' Archive(s) - '{$ELSE}' Archiv(e) - '{$ENDIF},
              100*((nTotalByteComp)/nTotalByteUnComp):4:1,'% ',
              nTotalFilesInArchive,{$IFDEF english}' Files,'
                                            {$ELSE}' Dateien,'
                                   {$ENDIF},
              {$IFDEF english}' Sizes: '
                       {$ELSE}' Gre: '
              {$ENDIF},fnFormStr(nTotalByteComp),' / ',fnFormStr(nTotalByteUnComp) );
      IF nEinfachArchive > 0 THEN WriteLn(
                {$IFDEF english}'      and '
                         {$ELSE}'    davon '
                {$ENDIF},nEinfachArchive,
                {$IFDEF english}' Archive(s) with only one File.'
                         {$ELSE}' Archiv(e) mit nur einer Datei.'
                {$ENDIF} );
      WriteLn({$IFDEF english}' Total size: '
                       {$ELSE}' Insgesamt also '
              {$ENDIF},fnFormStr(nTotalByte-nTotalByteComp+nTotalByteUnComp),
                      {$IFDEF english}' Bytes (with expanded archives)'
                               {$ELSE}' Byte (wenn Archive expandiert)'
                      {$ENDIF});
      WriteLn;
      {$Q+}
      END;
    END;
  ChDir(sOrgStartDir);
  IF exitCode = 0 THEN IF nUnknownFiles>0 THEN ExitCode := EXITCODE_SOMEUNKNOWNFILE;
  Exitproc := ExitSave;
END;

PROCEDURE HilfeUndEnde(n:Word);
BEGIN
  IF n=0 THEN
    BEGIN
    WriteLn(csAdress);

{$IFDEF English}
    Writeln('Usage:  FILESPY { {options} <filename or wildcard> }');
    Writeln('Shows info about files and their type from their content');
    Writeln(' -s  Recurse down into all subdirectories (see -xd)');
    Writeln(' -b  do not show info, which are too timeconsuming (e.g. contents of archives)');
    Writeln(' -v  verbose output;         -r  searches a copyright note');
    Writeln(' -xd<str> do not spy into subdirs containing <str> as substring of the dirname');
    Writeln(' -xf<str> dto. for files');
    Writeln(' -p / -g  shows the complete path / the size of the file');
    Writeln(' -m shows Modulename and required DLLs');
    Writeln(' -a[<str>] show all files inside of archives (no archiver needed!) [shows');
    Writeln('    only file which contain the optional <str>]');
    Writeln(' -x Extract archives (ZIP, ARJ etc.) and spy at the expanded files (File');
    {$IFDEF OS2}
    Writeln('    FileSpy.cfg and the executable (unzip.exe, unarj.exe etc.) needed');
    {$ELSE}
    Writeln('    FileSpy.cfg and the executable (pkunzip.exe, arj.exe etc.) needed');
    {$ENDIF}
    Writeln('    This works with archives insides archives too');
    Writeln(' -xb same as x, but do not delete the extracted files after spieng them.');
{    Writeln(' -c  CHUNKID: for IFF,RIFF,HLP,OBJ-Files: Show allr Chunks/SysCat/Header');
    Writeln(' -d<Dir>  stores files (e.g. from *.HLP) to <DIR>');
}   Writeln(' -k Copyright and OpenPGP-key;  -o DebugMode (Dumponly)');
    Writeln;
    Writeln(' Example: FILESPY C:\*.*  -s C:\OS2\*.DLL -aFILE_ID d:\*.zip');
    Writeln('  looks for all files only into the rootdir. After this it tries to find files ');
    Writeln('  with the extension "DLL" in the dir. OS2 and all his subdirs.');
{    Writeln(' FILESPY -srxb d:\*.*     asuming D: is your CD-ROM-Drive, and your');
    Writeln('  harddisk is big enough to hold some GB :)');
}
{$ELSE}
    WriteLn('Aufruf:  FILESPY {-{optionen}} <wildcard> { {-{optionen}} <wildcard> }');
    Writeln('Ermittelt Infos ber jede Datei aus deren Inhalt');
    Writeln(' -s  Bewirkt Suche auch in Verzeichn. der nachstehenden WildCards');
    Writeln(' -b  Krzere Informationen zu Dateien (luft schneller)');
    Writeln(' -v  Ausfhrlichere Information             --mimetype  nur den MIME-Typ zeigen');
    Writeln(' -x  Packt Archive aus und untersucht sie;  -xb lscht temp. Ausgepacktes nicht');
    Writeln(' -xd<Str> Schliesst Verzeichn., deren Namen <str> enthlt von der Untersuch.aus');
    Writeln(' -xf<Str> dto. fr Dateien');
    Writeln(' -a[<Str>] Gibt Dateinamen in Archiven [die <Str> enthalten] aus');
    Writeln(' -p  Gibt den Namen komplett mit Pfad aus;  -g Gibt die Dateigrsse mit aus');
    Writeln(' -r  Suche Copyright Notiz (bei EXE und unbekannten)');
    Writeln(' -l  Bei Textdateien wird die Zeilenbreite auf 132 erhht');
    Writeln(' -m  zeigt Modulnamen und dafr bentigte DLLs');
    Writeln(' -k  OpenPGP-Key und Copyright ausgeben;    -o DumpOnly (zum Debuggen)');
{    Writeln(' -d<Dir>  Generiert Dateien (z.B. aus HLP) nach <DIR>');
    Writeln(' -c Fr IFF,RIFF,HLP,OBJ: Ausgabe aller Chunks/SysCat/Header');
}   Writeln;
    Writeln('Beispiel: FILESPY C:\*.*  -s C:\OS2\*.DLL -aFILE_ID d:\*.zip');
    Writeln('  sucht NUR im Hauptverzeichnis nach allen Dateien, ausserdem im Verzeichnis');
    WriteLn('  OS2 und allen Unterverzeichnissen nach DLLs. Anschliessend wird auf Platte');
    WriteLn('  D: in allen ZIP-Files nach Dateien gesucht die FILE_ID enthalten');
{$ENDIF}
    END;
  IF n=1 THEN
    BEGIN
{$IFDEF English}
    WriteLn(' This programm is licensed under the GPL');
{$ELSE}
    WriteLn(' Lizenz: GPL');
{$ENDIF}
    WriteLn;
    WriteLn('Typ  Bits/ID       Datum      Benutzer');
    WriteLn('ff  1024/18A85CC1 1995/08/29 Walter Koch <101473.1015@compuserve.com>');
    WriteLn('                              Walter Koch <dg9ep@db0iz.#nrw.deu.eu>');
    WriteLn;
    WriteLn('-----BEGIN PGP PUBLIC KEY BLOCK-----');
    WriteLn('Version: 2.6.3i');
    WriteLn;
    WriteLn('mQCNAzBDj1oAAAEEAMRfonhtEUldLpGh6gK+3Nc7UpLyNveqizQVXtvTG/fkCsOP');
    WriteLn('i20gOFeWohiLPX+Uks7wEkyWyLRuv4Lk8Nu3xoqaxSu3Gg0IPdbrkJGNlc9oOdus');
    WriteLn('LVEJ4a0xr9ZI72xB+x6ONtHCmlKcoaYw5q7VV3/pHQkdhfKMKjD37IMYqFzBAAUR');
    WriteLn('tChXYWx0ZXIgS29jaCA8MTAxNDczLjEwMTVAY29tcHVzZXJ2ZS5jb20+iQCVAwUQ');
    WriteLn('MWPDLTD37IMYqFzBAQEOGwQAmTaHGkshbhbyajjie6OpDR9x889KHBMfrbURk+uC');
    WriteLn('5JhbuSpzG1OsrJMAPIp+0FQohsy0OeLO9p8Nfb5Rt5VWq6EKM1wDv3KtgDPmJgaV');
    WriteLn('VZZ02HBWT3zKnx8Je18AUyAe27kaVYY9xyohG/stRR3Lkj8TW3tUUi60Z2I82Fnb');
    WriteLn('G460JVdhbHRlciBLb2NoIDxkZzllcEBkYjBpei4jbnJ3LmRldS5ldT6JAHUCBRAw');
    WriteLn('l3omHRn0wQyYV6UBAb+SAv0WF4s+cXWMldHRwhdHn2ezeMx2h/AIN2ct2Oop4vbo');
    WriteLn('EE11/Wc9DdVJCBeZgYlzpgXvHBE6vM6O2vJvA5lcimxQOdzsFLo/veVueJh8gdIg');
    WriteLn('MtGheUjOxrNDvFE5O3VHKhaJAFUDBRAwRibajFOab6uYTVkBAZgfAf0YhToJ6gUq');
    WriteLn('Zi5FLqp1HwXqfFEKqHMQP5okTRzsSqH9KQ8OjJxsxv6beue7UfbU+2D118cKW6jG');
    WriteLn('/suH14Jk+kkGiQCVAwUQMEYmZzD37IMYqFzBAQF7oQQAiRQR9c71aUlT41mqTyFh');
    WriteLn('muRaPzyVisdNfmymtmyKE5LN8X/xNVEx9CmsQaW5n26Vm27fvA2+kSriiZerO/9n');
    WriteLn('cnVgA8vYjhMWpie7f53c4qX4LWKxz0ZcZWEoEc6gv0kORT1e5GnjudoMqoVXuyy1');
    WriteLn('pJ7qozkHsvsrn8uYqkC9ULk=');
    WriteLn('=5bj6');
    WriteLn('-----END PGP PUBLIC KEY BLOCK-----');
    WriteLn;
   END;
  fNOSUMMARAY := True;
  Halt(0);
END;


PROCEDURE Main;
  PROCEDURE OptLongPara(sDashPara:STRING);
  BEGIN
    sDashPara := fnUpper(sDashPara);
    IF sDashPara = 'MIMETYPE' THEN opt.fMIMETypeOnly := true;
  END;

VAR sr  : T_Suchrec;
    D : DirStr;
    N : NameStr;
    E : ExtStr;
    nPara: Longint;
    j : BYTE;
    sPara,sDashPara : STRING;
BEGIN
  {$IFnDEF PMVersion}
  {$IFnDEF Linux}
     Assign(output,'');
     Rewrite(output);
     IF CheckIOResultNil('Assigning stdout failed') <> 0 THEN Exit;
  {$ENDIF}
  {$ENDIF}

  {$IFDEF PMVersion}
 { Select 14 x 6 System VIO font }
  FontAttr.lMaxBaselineExt := 14;
  FontAttr.lAveCharWidth := 6;
  {$ENDIF}

  CheckBreak := TRUE;

  WriteLn;
  WriteLn(csVERS);
  IF paramcount = 0 THEN HilfeUndEnde(0);
  GetDir(0,sOrgStartDir);
  ExitSave := exitProc;
  ExitProc := @MyExit;

  nFile := 0; nFileFound := 0; nUnknownFiles := 0;
  nDir := 0; nDirFound := 0; nTotalByte := 0;

  nTotalByteFound := 0;
  nTotalByteComp := 0;    nTotalByteUnComp := 0;
  nArchiv := 0; nEinfachArchive := 0;
  nTotalFilesInArchive := 0;
  spieldauer := 0;

  sgLastDir := cSGLASTDIR_LEER; {* unmglicher Wert *}

  nZeilenBreite := 80;
  fNOSUMMARAY := False;
  opt.fSubDir := FALSE; opt.fDumpOnly := FALSE;
  opt.fVerbose := TRUE; opt.fSchwatz := FALSE;
  opt.fSize:=FALSE; opt.fPfad := FALSE;
  opt.fModulelist := FALSE;
  opt.fMIMETypeOnly := false;
  opt.fExtract := FALSE; opt.fBehalteAusgepackteDirs := FALSE;
  sIntoArc:=''; opt.fIntoArc := false;
  sGenerateDir := '';
  opt.fChunks := FALSE; opt.fSucheCopyRight := FALSE;
  opt.fPager := False;
  sFileExclude:='';
  sDirExclude := '';
  WriteLn;
  FOR nPara := 1 TO paramcount DO
    BEGIN
    sPara := ParamStr(nPara);
    IF sPara[1] = '-'
        THEN FOR j:= 2 TO length(spara) DO
               BEGIN
               CASE upcase(sPara[j]) OF
                 '-' : BEGIN
                       sDashPara := Copy(sPara,j+1,255);
                       OptLongPara(sDashPara);
                       {...$TODO}
                       Break; {for j}
                       END;
                 'A' : BEGIN
                       opt.fIntoArc := true;
                       sIntoArc := FnUpper(Copy(sPara,j+1,255));
                       Break {FOR j}
                       END;
                 'B' : opt.fVerbose := FALSE;
                 'C' : opt.fChunks := TRUE;
                 'D' : BEGIN
                       sGenerateDir := FnUpper(Copy(sPara,j+1,255));
                       Break {for j}
                       END;
                 'G' : opt.fSize := TRUE;
                 'H','?' : HilfeUndEnde(0);
                 'K' : HilfeUndEnde(1);
                 'L' : nZeilenBreite := 132;
                 'M' : opt.fModulelist := true;
                 'O' : opt.fDumpOnly := TRUE;
                 'P' : opt.fPfad := TRUE;
                 'R' : opt.fSucheCopyRight := TRUE;
                 'S' : opt.fSubDir := TRUE;
                 'V' : opt.fSchwatz := TRUE;
                 'X' : IF Length(sPara)<=j
                         THEN opt.fExtract := TRUE
                         ELSE CASE upcase(sPara[j+1]) OF
                               'B' : BEGIN
                                     opt.fExtract := TRUE;
                                     opt.fBehalteAusgepackteDirs := TRUE;
                                     break{for j};
                                     END;
                               'D' : BEGIN
                                     sDirExclude := fnUpper(Copy(sPara,j+2,255));
                                     break; {for j}
                                     END;
                               'F' : BEGIN
                                     sFileExclude := fnUpper(Copy(sPara,j+2,255));
                                     break; {for j}
                                     END;
                              ELSE Break;
                              END; {CASE}
                 ELSE BEGIN
                      WriteLn(
                      {$IFDEF English}'Canceled: Unkonown or wrong parameter: '
                               {$ELSE}'Abgebrochen: Unbekannte(r) oder falsche(r) Parameter: '
                              {$ENDIF},
                              spara[j]);
                      Halt(EXITCODE_WRONGPARA);
                      END;
               END; {CASE}
             END {FOR j }
        ELSE BEGIN
             IF sPara='.' THEN sPara := cWildCardAll;
             IF (sPara[length(sPara)] = '\') THEN Delete(sPara, length(sPara), 1 );
             IF (sPara[length(sPara)] = '/') THEN Delete(sPara, length(sPara), 1 );
             IF IsDirectory(sPara) THEN sPara := sPara + cPATHSEP+{$IFDEF DOS} '*.*' {$ELSE} '*' {$ENDIF};
             IF opt.fSize THEN Dec(nZeilenBreite,5);
             IF sPara <> '' THEN
               BEGIN
               FSplit(sPara,d,n,e);
               IF (d[length(d)] = cPATHSEP) AND (Length(d)<>3) THEN Delete(d,length(d),1);
               {* Wenn nur Dirname }
               IF (n='') AND (e='') THEN BEGIN n := '*'; {$IFDEF DOSE} e := '.*' {$ENDIF} END;
               IF d<>'' THEN
                 BEGIN
                 ChDir(d);
                 IF CheckIOResultNil('chdir '+d) <> 0 THEN Exit;
                 END;

               {* VolumeID nur beim allerersten Mal ausgeben }
               IF sgLastDir = cSGLASTDIR_LEER THEN
                 BEGIN
                 DosError := 0;
                 FindFirst(FExpand(n+e), VolumeID, sr );
                 IF DosError = 0 THEN
                   BEGIN
                   WriteLn('-------------------------------------');
                   WriteLn('--- VolumeID:   ',sr.name);
                   WriteLn('-------------------------------------');
                   END;
                 END;

               IF opt.fSubDir THEN DoManyDir(n+e, '')
                              ELSE DoOneDir (n+e, '');
               END;
             END;
  END; {For}
END;


END.
