{* Copyright (C) 2002 Free Software Foundation, Inc.
 * Copyright (C) 1995-2002 Walter Koch
 *
 * This file is part of Filespy.
 *
 * Filespy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Filespy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *}

UNIT FS_div;

{$I filespy.inc}

INTERFACE

USES DOS, fs_def,
  {$IFDEF PMVersion} WinCRT {$ELSE} CRT {$ENDIF}
  {$IFDEF BP2}
    ,DOSCalls  {Hiermit wird ein Ctrl-C-Handler fr OS/2 installiert}
    ,BSESub
  {$ENDIF}
  {$IFDEF OS2}
    ,OS2BASE  {wg. KBD}
  {$ENDIF}
  {$IFDEF Speedos2}
    , BseSub
  {$ENDIF}
;


CONST EXITCODE_CTRLC=240;
      EXITCODE_WRONGPARA=239;
      EXITCODE_SOMEUNKNOWNFILE=1;

      POWERTWO : ARRAY [0..10] OF WORD = (1,2,4,8,16,32,64,128,256,512,1024);



 FUNCTION MemFindString( VAR buf; maxlen : longint; Const sVon,sBis:STRING):STRING;

 FUNCTION CheckIoResult(VAR hdl:T_File; CONST s:STRING) : Integer;
 FUNCTION CheckIoResultNil(CONST s:STRING) : Integer;

 FUNCTION DoWait : Char;
PROCEDURE DoKeyTest;

 FUNCTION StrConCat(s1 , s2  : T_StrPchar): T_StrPchar;
PROCEDURE SwapLong(VAR l : LongInt );
 FUNCTION IfString ( flag : BOOLEAN;  CONST s : STRING ) : STRING;
PROCEDURE AddStrSep(VAR s : STRING; CONST ssep : STRING; CONST sa : STRING );
PROCEDURE AddStr(VAR s : STRING; CONST sa : STRING );
PROCEDURE AddChar(VAR s : STRING; c : CHAR );

PROCEDURE BlockReadWrapper(var F: File; var Buf; Count: Word ;
                           var Result: Integer);
PROCEDURE BlockWriteWrapper(var f: File; var Buf; Count: Word;
                            var Result: Word);

 FUNCTION DescIOResult (n : Longint) : STRING;

 FUNCTION Eq( VAR a ; CONST s : STRING) : BOOLEAN;
 FUNCTION EqJoker( VAR a ; CONST s : STRING) : BOOLEAN;
 FUNCTION StrEq ( a : POINTER; CONST  s : STRING; len : Longint) : BOOLEAN;
 FUNCTION EqStringIC( VAR a ; CONST s : STRING) : BOOLEAN;
 FUNCTION MemEq ( a,b : POINTER; len : Word) : BOOLEAN;

 FUNCTION fnStr(l : Longint):string;
PROCEDURE Upper ( VAR s : STRING );
 FUNCTION FnUpper ( CONST s : STRING ) : STRING;

 FUNCTION ArrChar2Str( VAR ac; size:longint ):STRING;
 FUNCTION fnFormStr(l : Longint):string;
 FUNCTION fnFormStrUsing(l,len : Longint):string;
 FUNCTION PosOrEmpty(Substr: String; S: String): Byte;
 FUNCTION F_Replace (x,y : STRING; VAR s : STRING) : BOOLEAN;

 FUNCTION RemoveCopyRight ( s : STRING ) : STRING;
 FUNCTION CopyTill ( CONST s : STRING; C : CHAR ) : STRING;
 FUNCTION FnShortIt ( s : STRING; maxlen:Word ) : STRING;
 FUNCTION Max(a,b : Longint) : Longint;
 FUNCTION Min(a,b : Longint) : Longint;
 FUNCTION Str2Oct(p:pointer; len : Longint):Longint;
 FUNCTION fnByteHex (b:BYTE):STRING;
 FUNCTION fnWordHex (w:WORD):STRING;
 FUNCTION fnLongHex (w:LongInt):STRING;

 FUNCTION MemFind ( CONST Mem;
                          nMem : WORD;
                    CONST sPattern : String ) : longint;

 FUNCTION fnGetPasStr(VAR hdl:t_File; Offset : Longint ):STRING;
 FUNCTION fnGetWordPasStr(VAR hdl:t_File; Offset : Longint ):STRING;
 FUNCTION fnGetASCIIStopch(VAR hdl:t_File; offset : longint; maxlen:word; cs1,cs2,cs3,cs4:char):STRING;
 FUNCTION fnGetASCII26or13(VAR hdl:t_File; offset : longint):STRING;
 FUNCTION GetASCIIZ(VAR hdl:t_File; offset : longint) : STRING;
PROCEDURE GetStrASCIIZ(VAR hdl:t_File; offset : longint; VAR s : STRING);
 FUNCTION GetAndSkipASCIIZ(VAR hdl:t_File; offset : longint; VAR s : STRING) : LongInt;
PROCEDURE SkipASCIIZ(VAR hdl:t_File; VAR offset : longint);
 FUNCTION GetASCIIN(VAR hdl:t_File; offset, n : longint):STRING;
 FUNCTION GetASCIICtrlN(VAR hdl:t_File; offset,maxlen, n : longint; fIgnoreCRTAB,fUniCode:BOOLEAN):STRING;
 FUNCTION GetMemUniCodeCtrlNString( p : POINTER; n : longint; fUniCode:BOOLEAN ):STRING;
 FUNCTION GetMemASCIICtrlNString( p : POINTER; n : longint):STRING;

 FUNCTION F_TrimLR(s : STRING):STRING;



{$IFDEF OS2}VAR kbd : KBDINFO;{$ENDIF}
TYPE T_LedSwitchMode=(aus,an,toggle);

PROCEDURE ScrollLed(mode: T_LedSwitchMode);


{--------------------------------------------------------------------------}

IMPLEMENTATION
USES fs_opt,
     fs_spy,
     portpas;

FUNCTION MemFindString( VAR buf; maxlen : longint; Const sVon,sBis:STRING):STRING;
  VAR von,bis : longint;
      sRes : STRING;
      p : ^CHAR;
BEGIN
  sRes := '';
  von := MemFind ( buf, maxlen, sVon);
  IF von >= 0 THEN
    BEGIN
    pointer(p) := @buf;
    IncPn(pointer(p),von+length(sVon));
    bis := MemFind ( p^, maxlen-von+1, sBis);
    IF bis >= 0 THEN
      BEGIN
      Move( p^,       sRes[1], Min(255,bis));
      SetLength(sRes, Min(255,bis) );
      END
    END;
  MemFindString := fnShortIt(sRes,255);
END;




function StrConCat(s1 , s2  : T_StrPchar): T_StrPchar;
BEGIN
  StrConCat := s1+s2;
END;

PROCEDURE SwapLong(VAR l : LongInt );
  TYPE c=ARRAY [1..4] OF BYTE;
  VAR h : BYTE;
BEGIN
  h := c(l)[1];  c(l)[1] := c(l)[4]; c(l)[4] := h;
  h := c(l)[2];  c(l)[2] := c(l)[3]; c(l)[3] := h;
END;

FUNCTION IfString ( flag : BOOLEAN;  CONST s : STRING ) : STRING;
BEGIN
  IF flag THEN IfString := s
          ELSE IfString := '';
END;

PROCEDURE AddStr(VAR s : STRING; CONST sa : STRING );
BEGIN
  s := s + sa;
END;
PROCEDURE AddChar(VAR s : STRING; c : CHAR );
BEGIN
  s := s + c;
END;
PROCEDURE AddStrSep(VAR s : STRING; CONST ssep : STRING; CONST sa : STRING );
BEGIN
  IF s<> '' THEN s := s + ssep;
  s := s + sa;
END;

PROCEDURE BlockReadWrapper(var F: File; var Buf; Count: Word ;
                           var Result: Integer);
  {$IFDEF VP}
  VAR lRes : Longint;
  {$ENDIF}
BEGIN
  {$IFDEF VP}
    lRes := Result;
    BlockRead(F,Buf,Count, lRes);
    Result := lRes;
  {$ELSE}
    BlockRead(F,Buf,Count, Result);
  {$ENDIF}
END;
PROCEDURE BlockWriteWrapper(var f: File; var Buf; Count: Word;
                            var Result: Word);
  {$IFDEF VP}  VAR lRes : Longint;  {$ENDIF}
BEGIN
  {$IFDEF VP}
    lRes := Result;
    BlockWrite(F,Buf,Count, lRes);
    Result := lRes;
  {$ENDIF}
END;

{--------------------------------------------------------------------------}

FUNCTION DescIOResult (n : Longint) : STRING;
  VAR s : string;
BEGIN
  CASE n OF
      2 : DescIOResult := {$IFDEF english}'File not found'{$else}'Datei nicht gefunden'{$ENDIF};
    {$IFDEF english}{$else}
      3 : DescIOResult := {$IFDEF english}{$else}'Pfad nicht gefunden'{$ENDIF};
      4 : DescIOResult := {$IFDEF english}{$else}'Zu viele Dateien geffnet'{$ENDIF};
      5 : DescIOResult := {$IFDEF english}{$else}'Zugriff verweigert'{$ENDIF};
      6 : DescIOResult := {$IFDEF english}{$else}'Ungltiges Datei-Handle'{$ENDIF};
     12 : DescIOResult := {$IFDEF english}{$else}'Ungltiger Zugriffscode'{$ENDIF};
     15 : DescIOResult := {$IFDEF english}{$else}'Ungltiges Laufwerk'{$ENDIF};
     16 : DescIOResult := {$IFDEF english}{$else}'Aktuelles Verzeichnis kann nicht gelscht werden'{$ENDIF};
     17 : DescIOResult := {$IFDEF english}{$else}'Umbenennen ber Laufwerke hinweg nicht erlaubt'{$ENDIF};
     18 : DescIOResult := {$IFDEF english}{$else}'Keine weiteren Dateien'{$ENDIF};
    100 : DescIOResult := {$IFDEF english}{$else}'Lesefehler von Diskette/Platte'{$ENDIF};
    101 : DescIOResult := {$IFDEF english}{$else}'Schreibfehler auf Diskette/Platte'{$ENDIF};
    102 : DescIOResult := {$IFDEF english}{$else}'Dateivariable ist keiner Datei zugeordnet'{$ENDIF};
    103 : DescIOResult := {$IFDEF english}{$else}'Datei konnte nicht geffnet werden'{$ENDIF};
    104 : DescIOResult := {$IFDEF english}{$else}'Datei nicht fr Eingabe geffnet'{$ENDIF};
    105 : DescIOResult := {$IFDEF english}{$else}'Datei nicht fr Ausgabe geffnet'{$ENDIF};
    106 : DescIOResult := {$IFDEF english}{$else}'Ungltiges numerisches Format'{$ENDIF};
    150 : DescIOResult := {$IFDEF english}{$else}'Diskette ist schreibgeschtzt'{$ENDIF};
    151 : DescIOResult := {$IFDEF english}{$else}'Peripheriegert nicht bekannt/nicht angeschlossen'{$ENDIF};
    152 : DescIOResult := {$IFDEF english}{$else}'Laufwerk nicht bereit'{$ENDIF};
    154 : DescIOResult := {$IFDEF english}{$else}'CRC-Fehler in Daten'{$ENDIF};
    156 : DescIOResult := {$IFDEF english}{$else}'Seek-Fehler auf Diskette/Platte'{$ENDIF};
    157 : DescIOResult := {$IFDEF english}{$else}'Unbekanntes Sektorformat'{$ENDIF};
    158 : DescIOResult := {$IFDEF english}{$else}'Sektor nicht gefunden'{$ENDIF};
    159 : DescIOResult := {$IFDEF english}{$else}'Drucker hat kein Papier'{$ENDIF};
    160 : DescIOResult := {$IFDEF english}{$else}'Fehler beim Schreiben auf Peripheriegert'{$ENDIF};
    161 : DescIOResult := {$IFDEF english}{$else}'Fehler beim Lesen von einem Peripheriegert'{$ENDIF};
    162 : DescIOResult := {$IFDEF english}{$else}'Hardware-Fehler'{$ENDIF};
{$ENDIF}
    ELSE BEGIN
         Str(n,s);
         DescIOResult := {$IFDEF english}'(Nr.'{$else}'(No.'{$ENDIF}+s+')';
         END;
 END;
END;

FUNCTION CheckIoResult(VAR hdl:T_File; CONST s:STRING) : Integer;
  VAR tmp : Integer;
BEGIN
  tmp := IOResult;
  IF tmp <> 0 THEN
    BEGIN
    hdl.res.sFehler := {$IFDEF english}' Error: '
                                {$else}' Fehler: '
                               {$ENDIF}
                              +DescIOResult(tmp)+ ' ('+s+')';
    END;
  CheckIOResult := tmp;
END;
FUNCTION CheckIoResultNil(CONST s:STRING) : Integer;
  VAR tmp : Integer;
BEGIN
  tmp := IOResult;
  IF tmp <> 0 THEN
    BEGIN
    WriteLn({$IFDEF english}'Error: '
                     {$else}'Fehler: '
            {$ENDIF}        +DescIOResult(tmp)+ ' ('+s+')');
    END;
  CheckIOResultNil := tmp;
END;

FUNCTION Eq( VAR a ; CONST s : STRING) : BOOLEAN;
  VAR p : ^Char;
      i : WORD;
BEGIN
  eq := FALSE;
  p := pointer(@a);
  FOR i := 1 TO length(s) DO
    BEGIN
    IF s[i] <> char(p^) THEN Exit;
    Incp1(pointer(p));
    END;
  eq := TRUE;
END;

FUNCTION EqJoker( VAR a ; CONST s : STRING) : BOOLEAN;
{* Wie Eq, aber in s darf Joker ? vorkommen *}
  VAR p : ^Char;
      i : WORD;
      s2:STRING;
BEGIN
  EqJoker := FALSE;
  p := pointer(@a);
  FOR i := 1 TO length(s) DO
    BEGIN
    IF s[i] <> char(p^) THEN
      IF s[i] <> '?' THEN BEGIN
                          {Jetzt versuchen wir es mal ohne die Joker}
                          s2 := '';
                          FOR i := 1 TO length(s) DO
                            IF s[i] <> '?' THEN s2 := s2 + s[i];
                          eqJoker := Eq(a,s2);
                          Exit;
                          END;
    Incp1(pointer(p));
    END;
  eqJoker := TRUE;
END;

FUNCTION EqStringIC( VAR a ; CONST s : STRING) : BOOLEAN;
{* Wie EqString aber ignore case *}
  VAR p : ^Char;
      i : WORD;
      s2:STRING;
BEGIN
  EqStringIC := FALSE;
  p := pointer(@a);
  FOR i := 1 TO length(s) DO
    BEGIN
    IF fnupper(s[i]) <> fnupper(char(p^)) THEN Exit;
    Incp1(pointer(p));
    END;
  eqStringIC := TRUE;
END;



FUNCTION StrEq ( a : POINTER; CONST  s : STRING; len : Longint) : BOOLEAN;
  VAR i : Longint;
      b : POINTER;
BEGIN
  StrEq := FALSE;
  b := @s[1];
  i := 1;
  WHILE i <= len DO
    BEGIN
    IF byte(a^)<>byte(b^) THEN Exit;
    inc(i);
    Incp1(a);
    Incp1(b);
    END;
  StrEq := TRUE;
END;

FUNCTION MemEq ( a,b : POINTER; len : Word) : BOOLEAN;
{$IFDEF NoAsm}
  VAR i : Longint;
BEGIN
  MemEq := FALSE;
  i := 1;
  WHILE i <= len DO
    BEGIN
    IF byte(a^)<>byte(b^) THEN Exit;
    inc(i);
    IncP1(a);
    IncP1(b);
    END;
  MemEq := TRUE;
END;
{$ELSE}
AFUNCTION EqJoker( VAR a ; CONST s : STRING) : BOOLEAN;
{* Wie Eq, aber in s darf Joker ? vorkommen *}
  VAR p : ^Char;
      i : WORD;
      s2:STRING;
BEGIN
  EqJoker := FALSE;
  p := pointer(@a);
  FOR i := 1 TO length(s) DO
    BEGIN
    IF s[i] <> char(p^) THEN
      IF s[i] <> '?' THEN BEGIN
                          {Jetzt versuchen wir es mal ohne die Joker}
                          s2 := '';
                          FOR i := 1 TO length(s) DO
                            IF s[i] <> '?' THEN s2 := s2 + s[i];
                          eqJoker := Eq(a,s2);
                          Exit;
                          END;
    Incp1(pointer(p));
    END;
  eqJoker := TRUE;
END;
SSEMBLER;
  {* Vergleicht die Speicherbereiche auf die A und B zeigen. Lediglich die
   * Offsets werden erhht, also VORSICHT mit nicht normalisierten Zeigern
   * und grossen Lngen *}
ASM
{$IFDEF achjaVP}
             push   ds
             mov    cx, len
             mov    esi,[A]
             mov    edi,[B]
@@0:
             or     cx,cx        {* Lnge testen *}
             je     @@1            {* Schluss jetzt *}
             mov    al,[esi]
             cmp    al,[edi]     {* da gibts bestimt noch ein Abk.-Befehl fr *}
             je     @@2
             mov    al,00          {* MemEq := FALSE  schneller als xor al,al*}
             jmp    @@99           {* Exit }
@@2:
             inc    esi
             inc    edi
             dec    cx
             jmp    @@0
@@1:
             mov    al,01          {* MemEq := TRUE *}
@@99:
             pop ds
{$ELSE}
             push   ds
             mov    cx, len
             lds    si,A
             les    di,B
@@0:
             or     cx,cx        {* Lnge testen *}
             je     @@1            {* Schluss jetzt *}
             mov    al,ds:[si]
             cmp    al,es:[di]     {* da gibts bestimt noch ein Abk.-Befehl fr *}
             je     @@2
             mov    al,00          {* MemEq := FALSE  schneller als xor al,al*}
             jmp    @@99           {* Exit }
@@2:
             inc    si
             inc    di
             dec    cx
             jmp    @@0
@@1:
             mov    al,01          {* MemEq := TRUE *}
@@99:
             pop ds
{$ENDIF}
END;
{$ENDIF}



FUNCTION fnStr(l : Longint):string;
  VAR s : STRING;
BEGIN
  str(l,s);
  fnStr:=s;
END;


PROCEDURE Upper ( VAR s : STRING );
  VAR i : BYTE;
BEGIN
  FOR i := 1 TO Length (s) DO
    case s[i] of
      '' : s[i] := '';
      '' : s[i] := '';
      '' : s[i] := '';
      ELSE  s[i] := upcase (s[i]);
    END;
END;

FUNCTION FnUpper ( CONST s : STRING ) : STRING;
  VAR s2 : STRING;
BEGIN
  s2 := s;     {* Muss kopiert werden, ansonsten wrde s verndert werden! *}
  Upper(s2);
  FnUpper := s2;
END;


FUNCTION ArrChar2Str( VAR ac; size:longint ):STRING;
  VAR sRes : STRING;
BEGIN
  IF size > 255 THEN size := 255;
  Move( ac, sRes[1], size);
  SetLength(sRes,size);
  ArrChar2Str := sRes;
END;


FUNCTION fnFormStr(l : Longint):string;
  VAR s : STRING;
      fNeg : BOOLEAN;
      n : BYTE;
BEGIN
  s := ''; n := 0;
  IF l = 0 THEN s:='0,';
  fNeg := l<0;
  IF fNeg THEN l := -l;
  WHILE l <> 0 DO
    BEGIN
    IF (n MOD 3) = 0 THEN s := ','+ s;
    s := char(48+l MOD 10)+s;
    l := l DIV 10;
    Inc(n);
    END;
  IF fNeg THEN s := '-'+s;
  IF s <> '' THEN SetLength(s, Length(s)-1);
  fnFormStr:=s;
END;

FUNCTION fnFormStrUsing(l,len : Longint):string;
  VAR s : STRING;
BEGIN
  s := fnFormStr(l);
  WHILE length(s)<len DO s := ' '+s;
  fnFormStrUsing := s;
END;


Function PosOrEmpty(Substr: String; S: String): Byte;
Begin
  if subStr = '' THEN PosOrEmpty := 1
                 ELSE PosOrEmpty := Pos(Substr,s);
END;



FUNCTION F_Replace (x,y : STRING; VAR s : STRING) : BOOLEAN;
  VAR bPos : Byte;
BEGIN
  bPos := Pos ( x, s);
  F_Replace := bPos <> 0;
  IF bPos <> 0 THEN BEGIN
                    Delete ( s, bPos, Length(x) );
                    Insert ( y, s, bPos );
                    END;
END;

FUNCTION RemoveCopyRight ( s : STRING ) : STRING;
BEGIN
  WHILE F_Replace ('copyright', '', s) DO;
  WHILE F_Replace ('Copyright', '', s) DO;
  WHILE F_Replace ('(C)', '(c)', s) DO;
  WHILE F_Replace ('All Rights Reserved', '', s) DO;
  WHILE F_Replace ('All rights reserved', '', s) DO;
  WHILE F_Replace ('Microsoft', 'MS', s) DO;
  WHILE F_Replace ('MicroSoft', 'MS', s) DO;
  WHILE F_Replace ('roperty', 'rop.', s) DO;
  RemoveCopyRight := s;
END;

FUNCTION CopyTill ( CONST s : STRING; C : CHAR ) : STRING;
{- Gebe Kopie des String s zurck bis zu ersten Auftauchen von c -}
   VAR i : BYTE;
BEGIN
  i := Pos(c,s);
  IF i = 0 THEN i := 255;
  CopyTill := Copy(s,1,i-1);
END;



FUNCTION FnShortIt ( s : STRING; maxlen:Word ) : STRING;
  VAR i,n : WORD;
      c : CHAR;
BEGIN
 IF (maxlen<1) OR (maxlen>255) THEN maxLen := 255;
 {* Ersetze Steuerzeichen durch Leerzeichen *}

  FOR i := 1 TO Length(s) DO
    BEGIN
    CASE s[i] OF
      ' '..#127,
      '','','',
      '','','','' : ; {* Nichts tuen *}
      #223 : s[i] := '';
      #196 : s[i] := '';
      #228 : s[i] := '';
      #214 : s[i] := '';
      #246 : s[i] := '';
      #220 : s[i] := '';
      #252 : s[i] := '';   {* Windows-Zeichnesatz -> 437 *}
      ELSE s[i] := ' ';
     END;
    END;

  s := RemoveCopyRight(s);
  WHILE F_Replace ('Version', 'Ver.', s) DO;
  WHILE F_Replace ('. ', '.', s) DO;
  WHILE F_Replace ('; ', ';', s) DO;
  WHILE F_Replace (', ', ',', s) DO;
  WHILE F_Replace (') ', ')', s) DO;
  WHILE F_Replace ('- ', '-', s) DO;
  WHILE F_Replace (' -', '-', s) DO;

  {* Krze Ende von Leerzeichen *}
  WHILE (Length(s)>1) AND (s[length(s)]=' ') DO SetLength(s, Length(s)-1);

  {* Krze Anfang von Leerzeichen *}
  WHILE (Length(s)>1) AND (s[1]=' ') DO Delete(s,1,1);

  {* Entferne doppelte Leerzeichen = *}
  {- Entferne alle Zeichen (ausser Ziffern), die mehr als zweimal
   - hintereinander vorkommen. Erschlgt auch doppelte Leerzeichen.
   - rgerlich z.B. bei "C++ Runtime Lib", aber C++ ist eben ein
   - rgernis :)
   -}
  i:=0; c := ' '; n := 0;
  WHILE i<length(s) DO
    BEGIN
    Inc(i);
    IF s[i]=c
      THEN BEGIN
           Inc(n);
           IF   ( (n>1) AND (c in [' '..#$2f,#$3a..#$40]))
              OR( (n>2) AND ((c<'0') OR (c>'9'))         ) THEN
             BEGIN
             Delete (s,i,1);
             Dec(i);
             END;
           END
      ELSE BEGIN
           c := s[i];
           n := 1;
           END;
    END;

  FnShortIt := Copy(s,1,maxLen);
END;


FUNCTION Min(a,b : Longint) : Longint;
BEGIN
  IF a<b THEN Min := a
         ELSE Min := b;
END;
FUNCTION Max(a,b : Longint) : Longint;
BEGIN
  IF a>b THEN Max := a
         ELSE Max := b;
END;


FUNCTION Str2Oct(p:pointer; len : Longint):Longint;
{- gibt -1 zurck bei Fehler -}
  VAR i,res : Longint;
BEGIN
  Str2Oct := -1;
  res := 0;
  FOR i := 1 TO Len DO
    BEGIN
    CASE Char(p^) OF
     '0'..'7' : res := 8 * res + (byte(p^)-48);
     ' ' : ;
     ELSE Exit;
     END;
    Inc(Longint(p));
    END;
  Str2Oct := res;
END;

FUNCTION fnByteHex (b:BYTE):STRING;
  CONST cv : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
BEGIN
  fnByteHex := cv[b DIV 16]+cv[b MOD 16];
END;

FUNCTION fnWordHex (w:WORD):STRING;
BEGIN
  fnWordHex := fnByteHex(w DIV 256)+fnByteHex(w MOD 256);
END;

FUNCTION fnLongHex (w:LongInt):STRING;
BEGIN
  fnLongHex := '';
  IF w<0 THEN exit;
  fnLongHex := fnWordHex(w DIV 65536)+fnWordHex(w MOD 65536);
END;


FUNCTION MemFind ( CONST Mem;
                         nMem : WORD;
                   CONST sPattern : String ) : longint;
{* liefert -1 wenn sPattern nicht drin, sonst den offset (0..nMem) *}
  VAR i : WORD;
      nPattern : BYTE;
      pMem : POINTER;
  LABEL LBreak;
BEGIN
  MemFind := -1;
  nPattern := Length(sPattern);
  IF nPattern > nMem THEN Exit;
  pMem := @Mem;
  FOR i := 1 TO nMem-nPattern DO
    BEGIN
    IF MemEQ( pMem, @sPattern[1], nPattern ) THEN
      BEGIN
      MemFind := i-1;
      GOTO LBreak;
      END;
    Incp1(pMem);
    END;
  lBreak:
END;

{==========================================================================}


FUNCTION fnGetPasStr(VAR hdl:t_File; Offset : Longint ):STRING;
  VAR s : String;
      b : BYTE;
BEGIN
  Seek(hdl.hExe,offset);
  BlockRead(hdl.hExe, b, 1);
  BlockRead(hdl.hExe, s[1], b);
  SetLength(s,b);
  IF IoResult <> 0 THEN s:= '';
  fnGetPasStr := s;
END;

FUNCTION fnGetWordPasStr(VAR hdl:t_File; Offset : Longint ):STRING;
  VAR s : String;
      b : BYTE;
      d : WORD;
BEGIN
  Seek(hdl.hExe,offset);
  BlockRead(hdl.hExe, b, 1);
  BlockRead(hdl.hExe, d, 1);
  BlockRead(hdl.hExe, s[1], b);
  SetLength(s,b);
  IF IoResult <> 0 THEN s:= '';
  fnGetWordPasStr := s;
END;

FUNCTION fnGetASCIIStopch(VAR hdl:t_File; offset : longint; maxlen:word; cs1,cs2,cs3,cs4:char):STRING;
{* Holt String bis zum einem der csn-Zeichen (Stopcharachter)*}
  VAR c : CHAR;
      s : STRING;
      fEnde : BOOLEAN;
BEGIN
  s := '';
  IF IOResult=0 THEN;;;;;
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    fEnde := (c=cs1) OR (c=cs2) OR (c=cs3) OR (c=cs4) OR (length(s)>Maxlen);
    IF NOT fEnde THEN s := s+c;
  UNTIL (IOResult<>0) OR fEnde;
  fnGetASCIIStopch := s;
END;


FUNCTION fnGetASCII26or13(VAR hdl:t_File; offset : longint):STRING;
{* Erzeugt String bis zum ^Z oder CR oder LF (jo! es gibt auch UNIX...)*}
  VAR c : CHAR;
      s : STRING;
      fEnde : BOOLEAN;
BEGIN
  s := '';
  IF IOResult=0 THEN;;;;;
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    fEnde :=  (c=^z) OR (c=#10) OR (c=#13) OR (length(s)>100);
    IF NOT fEnde THEN s := s+c;
  UNTIL (IOResult<>0) OR fEnde;
  fnGetASCII26or13 := s;
END;

FUNCTION GetASCIIZ(VAR hdl:t_File; offset : longint) : STRING;
  VAR c : CHAR;
      s : STRING;
BEGIN
  s:= '';
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    IF c<>#0 THEN s := s + c;
  UNTIL (c=#0) or (LENGTH(s)=255);
  GetASCIIZ := s;
END;

PROCEDURE GetStrASCIIZ(VAR hdl:t_File; offset : longint; VAR s : STRING);
  VAR c : CHAR;
BEGIN
  s := '';
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    IF c<>#0 THEN s := s + c;
  UNTIL c=#0;
END;

FUNCTION GetAndSkipASCIIZ(VAR hdl:t_File; offset : longint; VAR s : STRING) : LongInt;
  VAR c : CHAR;
BEGIN
  s := '';
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    IF c<>#0 THEN s := s + c;
    Inc(offset);
  UNTIL c=#0;
  GetAndSkipASCIIZ := offset;
END;

PROCEDURE SkipASCIIZ(VAR hdl:t_File; VAR offset : longint);
  VAR c : CHAR;
BEGIN
  Seek(hdl.hExe,offset);
  REPEAT
    BlockRead(hdl.hExe, c, 1);
    Inc(offset);
  UNTIL c=#0;
END;

FUNCTION GetASCIIN(VAR hdl:t_File; offset, n : longint):STRING;
  VAR s : STRING;
BEGIN
  IF n>255 THEN n := 255;
  SetLength(s,n);
  Seek(hdl.hExe,offset);
  BlockRead(hdl.hExe, s[1], n);
  GetAsciiN:=S;
END;

FUNCTION GetASCIICtrlN(VAR hdl:t_File; offset,maxlen, n : longint; fIgnoreCRTAB,fUniCode:BOOLEAN):STRING;
{- Holt String bis zum nchsten Steuerzeichen, aber maximal nur *n* Zeichen
 - schreiben. Durchsucht werden maximal *maxlen* zeichen
 -}
 CONST BUFSIZE=100;
  VAR c,chDummy : CHAR;
      i : Longint;
      fPrinted,
      fWasSpace,
      fEnd : BOOLEAN;
      s : STRING;
      iBuf,nBuf : {$IFDEF VP} LongInt
       {$ELSE} {$IFDEF Win32} Integer
                      {$ELSE} WORD {$ENDIF} {$ENDIF} ;
      buf : ARRAY [1..bufsize] OF Char;

  Function Getc:char;
  BEGIN
    IF iBuf>nbuf THEN
      BEGIN
      BlockRead(hdl.hExe, buf, sizeof(buf),nBuf);
      IF nBuf=0 THEN InOutRes := 100;
      iBuf := 1;
      END;
    getc := buf[iBuf];
    Inc(iBuf);
  END;

BEGIN
  GetASCIICtrlN := '';
  IF offset <0 THEN Exit; {* Damit kann man das auch innerhalb von Para-Listen rufen *}
  s := '';
  i := 0; fEnd := FALSE;
  fPrinted := FALSE;
  fWasSpace := FALSE;
  Seek(hdl.hExe,offset);
  nBuf := 0;
  iBuf := bufsize+1; {Laden erzwingen}
  REPEAT
    c := getc;
    IF fUniCode THEN chDummy := getc;
    IF IOResult <> 0 THEN fEnd := TRUE;
    IF fPrinted OR (c<>' ') THEN
      BEGIN
      fPrinted := TRUE;
      IF (c>=' ') AND (i<=maxlen)
        THEN IF (c=' ') AND fWasSpace
               THEN {* doppelte Leerzeichen ignorieren *}
               ELSE Addchar(s,c)
        ELSE BEGIN
             fEnd :=  NOT ( ((c=#10)OR(c=#13)OR(c=#9)) AND fIgnoreCRTAB );
             c := ' ';
             AddChar(s,' ');
             END;
      fWasSpace := c=' ';
      END;
    Inc(i);
  UNTIL fEnd OR (length(s)>=n);
  GetASCIICtrlN:= s;
END;


FUNCTION GetMemUniCodeCtrlNString( p : POINTER; n : longint; fUniCode:BOOLEAN ):STRING;
{* Holt bis zum nchsten Steuerzeichen, aber maximal nur n Zeichen
 * Funktionier auch fr ASCIIZ
 *}
  VAR c : CHAR;
      i : Longint;
      fPrinted,
      fEnd : BOOLEAN;
      nCoded : WORD;
      pOrg : POINTER;
      nOrg : longint;
      s : STRING;
BEGIN
  pOrg := p; nOrg := n;
  i := 0; fEnd := FALSE; nCoded := 0;
  fPrinted := FALSE;
  s := '';
  REPEAT
    c := char(p^);
    Incp1(p);
    IF fUniCode THEN Incp1(p);
    IF fPrinted OR (c>' ') THEN
      BEGIN
      fPrinted := TRUE;
      IF (i>n)
        THEN fEnd := TRUE
        ELSE IF c>=' '
               THEN s := s+c
               ELSE IF (c=#0) AND (Length(s)=1) AND (NOT fUniCode)
                      THEN BEGIN {* UniCode? Ausprobieren! *}
                           s := GetMemUniCodeCtrlNString( pOrg,nOrg,true );
                           fEnd := True;
                           END
                      ELSE BEGIN
                           Inc(nCoded);
                           fEnd := (nCoded >5) OR (c=#0);
                           END;
      END;
    Inc(i);
  UNTIL fEnd;
  GetMemUniCodeCtrlNString := s;
END;

FUNCTION GetMemASCIICtrlNString( p : POINTER; n : longint):STRING;
{* Holt bis zum nchsten Steuerzeichen, aber maximal nur n Zeichen
 * Funktionier auch fr ASCIIZ
 *}
BEGIN
  GetMemASCIICtrlNString := GetMemUniCodeCtrlNString( p,n, false);
END;

{==========================================================================}

{Type
  KBDINFO = Record
    cb,                                  length in bytes of this structure
        Length, in bytes, of this data structure, including length.
        10        Only valid value.
    fsMask,                              bit mask of functions to be altered
     sysstate (USHORT)
        State as follows:

        Bit       Description
        15-9      Reserved, set to zero.
        8         Shift return is on.
        7         Length of the turn-around character (meaningful only if bit 6 is on).
        6         Turn-around character is modified.
        5         Interim character flags are modified.
        4         Shift state is modified.
        3         ASCII mode is on.
        2         Binary mode is on.
        1         Echo off.
        0         Echo on.
    chTurnAround,                        define TurnAround character
     turnchardef (USHORT)
        Definition of the turn-around character. In ASCII and extended-ASCII format, the
        turn-around character is defined as the carriage return.  In ASCII format only, the
        turn-around character is defined in the low-order byte.
    fsInterim,                           interim character flags
     intcharflag (USHORT)
        Interim character flags:

        Bit       Description
        15-8      NLS shift state.
        7         Interim character flag is on.
        6         Reserved, set to zero.
        5         Application requested immediate conversion.
        4-0       Reserved, set to zero.
    fsState: USHORT                      shift states
     shiftstate (USHORT)
        Shift state as follows:

        Bit       Description
        15        SysReq key down
        14        CapsLock key down
        13        NumLock key down
        12        ScrollLock key down
        11        Right Alt key down
        10        Right Ctrl key down
        9         Left Alt key down
        8         Left Ctrl key down
        7         Insert on
        6         CapsLock on
        5         NumLock on
        4         ScrollLock on
        3         Either Alt key down
        2         Either Ctrl key down
        1         Left Shift key down
        0         Right Shift key down.
    }


PROCEDURE ScrollLed(mode: T_LedSwitchMode);
  VAR {$IFDEF OS2}i,{$ENDIF}
      state : WORD;
BEGIN
END;


FUNCTION DoWait : Char;
{* Hlt die Ausfhrung an; die ScrollLED blinkt
 * Returns: Taste, mit der fortgesetzt wurde *}
BEGIN
  DoWait := ' ';
  ScrollLed(an);
  While (NOT KeyPressed) DO
    BEGIN
    {$IFnDEF PMVersion}  Delay(300);  {$ENDIF}
    ScrollLed(Toggle);
    END;
  IF Keypressed THEN DoWait := ReadKey;
  ScrollLed(aus);
END;


PROCEDURE DoKeyTestChar(c:Char);
BEGIN
  CASE c OF
     ' ': BEGIN
          c := DoWait;
          IF c <> ' ' THEN DoKeyTestChar(c);
          END;
     #27, ^C
        : Halt(EXITCODE_CTRLC);
  END;
END;

PROCEDURE DoKeyTest;
BEGIN
{$IFDEF OS2}
  IF DosSleep(0)=0 THEN;;;
{$ENDIF}
  IF KeyPressed THEN DoKeyTestChar(ReadKey);
END;



FUNCTION F_TrimLR(s : STRING):STRING;
BEGIN
  While (length(s)>0) AND (s[length(s)]<=' ') DO setLength(s,length(s)-1);
  While (length(s)>0) AND (s[1]<=' ') DO Delete(s,1,1);
  F_TrimLR := s;
END;


{==========================================================================}



END.
