{* Copyright (C) 2002 Free Software Foundation, Inc.
 * Copyright (C) 1995-2002 Walter Koch
 *
 * This file is part of Filespy.
 *
 * Filespy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Filespy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *}


UNIT FS_DEF;
{$I filespy.inc}

INTERFACE
USES DOS, portpas,
  {$IFDEF PMVersion} WinCRT {$ELSE} CRT {$ENDIF}
  {$IFDEF BP2}
    ,DOSCalls  {* Hiermit wird ein Ctrl-C-Handler fr OS/2 installiert *}
    ,BSESub
  {$ENDIF}
  {$IFDEF OS2}
    ,OS2BASE  {* wg. KBD *}
  {$ENDIF}
  {$IFDEF Speedos2}
    ,BseSub
  {$ENDIF}
;

CONST csVERS =
     '--- FileSpy '
   + '--- 21. Aug. 05 '
   + '--- ' + csPLATTFORM + ' '
   + '--- ' + {$IFDEF english } 'eng.' {$ELSE} 'dt.' {$ENDIF} + ' '
   + '--- (c) dg9ep --- ';
csAdress =
     '            --- http://www.u32.de/filespy.html ---';


{* Globales *}
VAR nZeilenBreite : WORD;
    spielDauer : REAL;
    nFileFound,
    nUnknownFiles,
    nArchiv,
    nEinfachArchive, { nArchiv-nEinfachArchiv= Archive mit mehr als 2 Dateien }
    nTotalFilesInArchive,
    nTotalByteUnComp,
    nTotalByteComp,
    nTotalByteFound : LongInt;
    sgLastDir, {* Zuletzt bearbeitete Dir *}
    sOrgStartDir : STRING;

    sIntoArc, sGenerateDir,
    sDirExclude,
    sFileExclude : STRING;
    fNOSUMMARAY : BOOLEAN;

    opt : RECORD
       fDumpOnly,
       fSubDir,
       fVerbose,
       fSchwatz,
       fIntoArc,
       fSucheCopyRight,
       fSize, fPfad,
       fModulelist,
       fExtract, fBehalteAusgepackteDirs,
       fMIMETypeOnly,
       fChunks,
       fPager : BOOLEAN;
    END;
CONST cSGLASTDIR_LEER=#0#0#1;

Type T_SuchRec ={$IFDEF Windows}  TSearchrec;
                {$ELSE}           SearchRec;
                {$ENDIF}
     t_strpchar =String;
CONST
  cReadOnly  = readonly;
  cHidden    = hidden;
  cSysFile   = sysfile;
  cVolumeID  = VolumeID;
  cDirectory = directory;
  cArchive   = Archive;
  cAnyFile   = AnyFile;

  TYPE T_SortRec= RECORD
        {* in name steht der komplette Name inkl. Extension drin. Unter DOS
          sind das nie mehr als 15 Zeichen ... }
           name : String{$IFDEF DOSE}[15]{$ENDIF};
           ext  : ExtStr;
           size : Longint;
         END;
    tp_SortRec = ^t_SortRec;
    tp_apSR=ARRAY [1..1] OF tp_SortRec;
    t_sortHandle = RECORD
       papSR    : ^tp_apSR;
       nFiles   : Longint;
       pMemall  : POINTER;
       memsize  : Longint;
       iApSr    : WORD;
       sizepapsr: Longint;
       dosSR    : T_SuchRec;
      END;


TYPE T_ART = (cNIL,cEXEC,cDEVEL,cKRACH,cGRAFIK,cDATEN,cTEXT,cVIDEO,
              cZeichenSatz,cHilfe,cArchiv,cFehler,cANDERE);
     T_file = RECORD
         hExe : FILE;
         sr   : T_Suchrec;
         D    : DirStr; {* Verzeichniss, wo der File liegt *}
         res : Record   {* Resultat *}
                 art : T_ART;
                 {unterart : Exe(Driver), Grafik(Icon,Bitmap ...}
                 sDesc ,   {* Die Beschreibung *}
                 sZitat,   {* Aus dem File selber *}
                 sVers,    {* Versions String *}
                 sDefExt,  {* Die normale Dateinamenerweiterung *}
                 sMimeType,{* Der Standard-MIME-Type (Content-Type: ) *}
                 sSchwatz, {* nur gefllt bei opt-fSchwatz *}
                 sAdd,     {* Ausgaben der Optionen -m, -c .... *}
                 sFehler
                  : String;
                 bitPix, nStueck, nx, ny, nFarben
                  : Longint; {* fr Grafik *}
               END;
       END;

 VAR nDir,nFile,nTotalByte,nDirFound : Longint;


CONST
  csTEXT    = {$IFDEF english} ' Text'       {$else} ' Text'      {$endif} ;
  csEXEC    = {$IFDEF english} ' Exec.'      {$else} ' Prog.'     {$endif} ;
  csDEVEL   = {$IFDEF english} ' Devel.'     {$else} ' Progr.'    {$endif} ;
  csDRIVER  = {$IFDEF english} ' Driver'     {$else} ' Treiber'   {$endif} ;
  csDATA    = {$IFDEF english} ' Data'       {$else} ' Daten'     {$endif} ;
  csDatabase= {$IFDEF english} ' Database'   {$else} ' Datenbank' {$endif} ;
  csArchiv  = {$IFDEF english} ' Archive'    {$else} ' Archiv'    {$endif} ;
  csSOUND   = {$IFDEF english} ' Sound'      {$else} ' Gerusch'  {$endif} ;
  csGRAFIC  = {$IFDEF english} ' Graphics'   {$else} ' Grafik'    {$endif} ;
  csGepackt = {$IFDEF english} ' compressed' {$else} ' gepackt'   {$endif} ;
  csHilfe   = {$IFDEF english} ' Help'       {$else} ' Hilfe'     {$endif} ;
  csBilder  = {$IFDEF english} 'Pictures'    {$else} 'Bilder'     {$endif} ;
  csSpiel   = {$IFDEF english} 'Game'        {$else} 'Spiel'      {$endif} ;
  csDatei   = {$IFDEF english} 'file'        {$else} 'datei'      {$endif} ;


IMPLEMENTATION


END.
