/*
 * Decompiled with CFR 0.152.
 */
package de.u32.filespy;

import de.u32.filespy.SpiedObject;
import de.u32.filespy.SpyInfos.Directory;
import de.u32.filespy.SpyInfos.SpyInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SpiedFile
extends SpiedObject {
    protected String filename = null;
    protected int[] buffer = null;

    public SpiedFile(String string) {
        this.filename = string;
    }

    public SpyInfo fillInfo() throws IOException {
        SpyInfo si = null;
        File f = new File(this.getFilename());
        if (f.isDirectory()) {
            si = new Directory();
        } else {
            this.readBuffer(1);
            si = super.fillInfo();
        }
        return si;
    }

    public void readBuffer(int nGrenze) throws IOException {
        this.buffer = new int[nGrenze];
        FileInputStream fis = new FileInputStream(this.getFilename());
        int c = 0;
        int lenInhalt = 0;
        while (lenInhalt < nGrenze & (c = fis.read()) != -1) {
            this.buffer[lenInhalt] = c;
            ++lenInhalt;
        }
        fis.close();
    }

    public int getWordBigEndian(long offset) throws IOException {
        this.readBuffer((int)offset + 2);
        return this.buffer[(int)offset] + 256 * this.buffer[(int)offset + 1];
    }

    public long getDWordBigEndian(long offset) throws IOException {
        this.readBuffer((int)offset + 4);
        return this.buffer[(int)offset] + 256 * this.buffer[(int)offset + 1] + 65536 * (this.buffer[(int)offset + 2] + 256 * this.buffer[(int)offset + 3]);
    }

    public String getString(long offset, int len) throws IOException {
        int c;
        FileInputStream fis = new FileInputStream(this.getFilename());
        StringBuffer buffer = new StringBuffer(len);
        fis.skip(offset);
        int lenInhalt = 0;
        while (lenInhalt < len & (c = fis.read()) != -1) {
            buffer.append((char)c);
            ++lenInhalt;
        }
        fis.close();
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String asciiz(long startoffset) {
        StringBuffer retString = new StringBuffer(10);
        try {
            FileInputStream fis = new FileInputStream(this.filename);
            char c = ' ';
            while (true) {
                char c2 = (char)fis.read();
                c = c2;
                if (c2 == '\u0001') {
                    fis.close();
                    return retString.toString();
                }
                retString.append(c);
            }
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
        }
        return retString.toString();
    }

    public boolean compare(int[] arr, int len) {
        try {
            this.readBuffer(len);
            int i = 0;
            while (i < len) {
                if (this.buffer[i] != arr[i]) {
                    return false;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean compare(String str) {
        try {
            int len = str.length();
            this.readBuffer(len);
            int i = 0;
            while (i < len) {
                if (this.buffer[i] != str.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

