;******************************************************************
;* Strukturdefinitionen Macro Service Channels und Register-Banks *
;******************************************************************
MS_SERV    struc
msc	   db	  ?			;Anzahl Bytes
sfrp	   db	  ?			;Special Funktion Register Pointer
schr	   db	  ?			;Search Character
	   db	  ?			;reserved
msp	   dw	  ?			;Offset Adresse
mss	   dw	  ?			;Segment Adresse
	   ends
sizeMS_SERV equ 8



           .DATA
V25_SEG     equ  0FF00h
;******************
;* Macro Channels *
;******************
ms0	   equ  0E00h  			;Channel 0   v24-1
ms1	   equ (0e00h+01*sizeMS_SERV)	;Channel 1   v24-1
ms2	   equ (0e00h+02*sizeMS_SERV)	;Channel 2   v24-0
ms3	   equ (0e00h+03*sizeMS_SERV)	;Channel 3
ms4	   equ (0e00h+04*sizeMS_SERV)	;Channel 4
ms5	   equ (0e00h+05*sizeMS_SERV)	;Channel 5   v24-0
ms6	   equ (0e00h+06*sizeMS_SERV)	;Channel 6
ms7	   equ (0e00h+07*sizeMS_SERV)	;Channel 7

;*****************************
;* Special Funktion Register *
;*****************************

prc	   equ  0FEBh			;Processor Control Register

seic0	   equ  0F6ch			;Serial Error Interrupt 1
sric0	   equ  0F6dh			;Serial Receive Interrupt 1
stic0	   equ  0F6eh			;Serial Transmit Interrupt 1
RxB0	   equ  0F60h			;Receive Buffer 1
TxB0	   equ  0F62h			;Transmit Buffer 1
srms0	   equ  0F65h			;Serial Receive Macro 1
stms0	   equ  0F66h			;Serial Transmit Macro 1
scm0	   equ  0F68h			;Serial Mode 1
scc0	   equ  0F69h			;Serial Control 1
brg0	   equ  0F6ah			;Serial Baud Rate 1


seic1	   equ  0F7ch			;Serial Error Interrupt 1
sric1	   equ  0F7dh			;Serial Receive Interrupt 1
stic1	   equ  0F7eh			;Serial Transmit Interrupt 1
RxB1	   equ  0F70h			;Receive Buffer 1
TxB1	   equ  0F72h			;Transmit Buffer 1
srms1	   equ  0F75h			;Serial Receive Macro 1
stms1	   equ  0F76h			;Serial Transmit Macro 1
scm1	   equ  0F78h			;Serial Mode 1
scc1	   equ  0F79h			;Serial Control 1
brg1	   equ  0F7ah			;Serial Baud Rate 1

;****************
;* neue Befehle *
;****************
fint	   macro			;Finish Interrupt Kommando
	   db	  0Fh,92h
	   endm

movspa	   macro
	   db	  0Fh,25h		;Move Stack Pointer after CT-Switch
	   endm

retrbi	   macro			;Register Bank Interrupt Return
	   db	  0Fh,91h
	   endm

;******************************
;* Interrupt Sperren / Setzen *
;******************************
_cli	   macro			    ;Interrupts temp. sperren
	   pushf
	   cli
	   endm

_sti	   macro			    ;Interrupts wieder zurck
	   popf
	   endm

;**************************************
;* Sperren und freigeben von IO/Ports *
;**************************************
portdis      macro
	     lahf			    ;Flags holen
	     and    ah,0FDh		    ;IBRK auf 0
	     sahf			    ;und wieder zurck
	     endm

portena      macro
	     lahf			    ;Flags holen
	     or     ah,002h		    ;IBRK auf 1
	     sahf			    ;und wieder zurck
	     endm

;*************************
;* allgemeine Konstanten *
;*************************
WD_MSK	  equ	 10h			    ;Watchdog Maske

;********************************
;* Register der Real Time Clock *
;********************************
clockb	  equ	 80h
sec1	  equ	 clockb
sec10	  equ	 clockb+1
min1	  equ	 clockb+2
min10	  equ	 clockb+3
hour1	  equ	 clockb+4
hour10	  equ	 clockb+5
day1	  equ	 clockb+6
day10	  equ	 clockb+7
mon1	  equ	 clockb+8
mon10	  equ	 clockb+9
year1	  equ	 clockb+10
year10	  equ	 clockb+11
week	  equ	 clockb+12
regd	  equ	 clockb+13
rege	  equ	 clockb+14
regf	  equ	 clockb+15

