;******************************************************************
;* Strukturdefinitionen Macro Service Channels und Register-Banks *
;******************************************************************
MS_SERV    struc
msc        db     ?                     ;Anzahl Bytes
sfrp       db     ?                     ;Special Funktion Register Pointer
schr       db     ?                     ;Search Character
           db     ?                     ;reserved
msp        dw     ?                     ;Offset Adresse
mss        dw     ?                     ;Segment Adresse
           ends

RB_SWITCH  struc
           dw     ?                     ;Reserved
pc_vektpr  dw     ?                     ;Einsprungadresse
reg_f      dw     ?                     ;Flags
pc_save    dw     ?                     ;alter IP Wert
ds_reg     dw     ?                     ;DS Register
ss_reg     dw     ?                     ;SS Register
cs_reg     dw     ?                     ;CS Register
es_reg     dw     ?                     ;ES Register
di_reg     dw     ?                     ;DI Register
si_reg     dw     ?                     ;SI Register
bp_reg     dw     ?                     ;BP Register
sp_reg     dw     ?                     ;SP Register
bx_reg     dw     ?                     ;BX Register
dx_reg     dw     ?                     ;DX Register
cx_reg     dw     ?                     ;CX Register
ax_reg     dw     ?                     ;AX Register
           ends

V25_SEG    equ    0FF00h                ;V25 internes Segment
;******************
;* Macro Channels *
;******************
ms0        equ    0E00h                 ;Channel 0
ms1        equ    0E08h                 ;Channel 1
ms2        equ    0E10h                 ;Channel 2
ms3        equ    0E18h                 ;Channel 3
ms4        equ    0E20h                 ;Channel 4
ms5        equ    0E28h                 ;Channel 5
ms6        equ    0E30h                 ;Channel 6
ms7        equ    0E38h                 ;Channel 7
bnk2       equ    0E40h                 ;Bank 2
bnk3       equ    0E60h                 ;Bank 3
bnk4       equ    0E80h                 ;Bank 4
bnk5       equ    0EA0h                 ;Bank 5
bnk6       equ    0EC0h                 ;Bank 6
bnk7       equ    0EE0h                 ;Bank 7

;*****************************
;* Special Funktion Register *
;*****************************
p0         equ    0F00h                 ;Port 0 Ein/Ausgabe
pm0        equ    0F01h                 ;Port 0 Modus Register
pmc0       equ    0F02h                 ;Port 0 Mode Control
p1         equ    0F08h                 ;Port 1 Ein/Ausgabe
pm1        equ    0F09h                 ;Port 1 Modus
pmc1       equ    0F0Ah                 ;Port 1 Mode Control
p2         equ    0F10h                 ;Port 2 Ein/Ausgabe
pm2        equ    0F11h                 ;Port 2 Modus
pmc2       equ    0F12h                 ;Port 2 Mode Control
pt         equ    0F38h                 ;Port T Eingang
pmt        equ    0F3Bh                 ;Port T Mode
intm       equ    0F40h                 ;external Interrupt Mode
ems0       equ    0F44h                 ;ext. Int Macro Control 0
ems1       equ    0F45h                 ;ext. Int Macro Control 1
ems2       equ    0F46h                 ;ext. Int Macro Control 2
exic0      equ    0F4Ch                 ;ext. Int Control Register 0
exic1      equ    0F4Dh                 ;ext. Int Control Register 1
exic2      equ    0F4Eh                 ;ext. Int Control Register 2
RxB0       equ    0F60h                 ;Receive Buffer 0
TxB0       equ    0F62h                 ;Transmit Buffer 0
srms0      equ    0F65h                 ;Serial Receive Macro 0
stms0      equ    0F66h                 ;Serial Transmit Macro 0
scm0       equ    0F68h                 ;Serial Mode 0
scc0       equ    0F69h                 ;Serial Control 0
brg0       equ    0F6Ah                 ;Serial Baud Rate 0
scs0       equ    0F6Bh                 ;Serial Status 0
seic0      equ    0F6Ch                 ;Serial Error Interrupt 0
sric0      equ    0F6Dh                 ;Serial Receive Interrupt 0
stic0      equ    0F6Eh                 ;Serial Transmit Interrupt 0
RxB1       equ    0F70h                 ;Receive Buffer 1
TxB1       equ    0F72h                 ;Transmit Buffer 1
srms1      equ    0F75h                 ;Serial Receive Macro 1
stms1      equ    0F76h                 ;Serial Transmit Macro 1
scm1       equ    0F78h                 ;Serial Mode 1
scc1       equ    0F79h                 ;Serial Control 1
brg1       equ    0F7Ah                 ;Serial Baud Rate 1
scs1       equ    0F7Bh                 ;Serial Status
seic1      equ    0F7Ch                 ;Serial Error Interrupt 1
sric1      equ    0F7Dh                 ;Serial Receive Interrupt 1
stic1      equ    0F7Eh                 ;Serial Transmit Interrupt 1
tm0        equ    0F80h                 ;Timer 0 Register
md0        equ    0F82h                 ;Modulo/Timer Register 0
tm1        equ    0F88h                 ;Timer 1 Register
md1        equ    0F8Ah                 ;Modulo/Timer Register 1
tmc0       equ    0F90h                 ;Timer Control 0
tmc1       equ    0F91h                 ;Timer Control 1
tmms0      equ    0F94h                 ;Timer Unit Macro 0
tmms1      equ    0F95h                 ;Timer Unit Macro 1
tmms2      equ    0F96h                 ;Timer Unit Macro 2
tmic0      equ    0F9Ch                 ;Timer Interrupt Control 0
tmic1      equ    0F9Dh                 ;Timer Interrupt Control 1
tmic2      equ    0F9Eh                 ;Timer Interrupt Control 2
dmac0      equ    0FA0h                 ;DMA 0 Control
dmam0      equ    0FA1h                 ;DMA 0 Mode
dmac1      equ    0FA2h                 ;DMA 1 Control
dmam1      equ    0FA3h                 ;DMA 1 Mode
dic0       equ    0FACh                 ;DMA 0 Interrupt Request
dic1       equ    0FADh                 ;DMA 1 Interrupt Request
sar0l      equ    0FC0h                 ;DMA 0 Source Low
sar0h      equ    0FC2h                 ;DMA 0 Source High
dar0l      equ    0FC4h                 ;DMA 0 Destination Low
dar0h      equ    0FC6h                 ;DMA 0 Destination High
TC0        equ    0FC8h                 ;DMA 0 Count
sar1l      equ    0FD0h                 ;DMA 1 Source Low
sar1h      equ    0FD2h                 ;DMA 1 Source High
dar1l      equ    0FD4h                 ;DMA 1 Destination Low
dar1h      equ    0FD6h                 ;DMA 1 Destination High
TC1        equ    0FD8h                 ;DMA 1 Count
stbc       equ    0FE0h                 ;Standby Register
rfm        equ    0FE1h                 ;Refresh Mode
wtc        equ    0FE8h                 ;Wait Control
flag       equ    0FEAh                 ;User Flag Register
prc        equ    0FEBh                 ;Processor Control Register
tbic       equ    0FECh                 ;Timer Base Interrupt Control
irqs       equ    0FEFh                 ;Interrupt Faktor Register

;****************
;* neue Befehle *
;****************
fint       macro                        ;Finish Interrupt Kommando
           db     0Fh,92h
           endm

movspa     macro
           db     0Fh,25h               ;Move Stack Pointer after CT-Switch
           endm

retrbi     macro                        ;Register Bank Interrupt Return
           db     0Fh,91h
           endm

;******************************
;* Interrupt Sperren / Setzen *
;******************************
_cli       macro                            ;Interrupts temp. sperren
           pushf
           cli
           endm

_sti       macro                            ;Interrupts wieder zurck
           popf
           endm

;**************************************
;* Sperren und freigeben von IO/Ports *
;**************************************
portdis      macro
             lahf                           ;Flags holen
             and    ah,0FDh                 ;IBRK auf 0
             sahf                           ;und wieder zurck
             endm

portena      macro
             lahf                           ;Flags holen
             or     ah,002h                 ;IBRK auf 1
             sahf                           ;und wieder zurck
             endm

;*************************
;* allgemeine Konstanten *
;*************************
WD_MSK    equ    10h                        ;Watchdog Maske

;********************************
;* Register der Real Time Clock *
;********************************
clockb    equ    80h
sec1      equ    clockb
sec10     equ    clockb+1
min1      equ    clockb+2
min10     equ    clockb+3
hour1     equ    clockb+4
hour10    equ    clockb+5
day1      equ    clockb+6
day10     equ    clockb+7
mon1      equ    clockb+8
mon10     equ    clockb+9
year1     equ    clockb+10
year10    equ    clockb+11
week      equ    clockb+12
regd      equ    clockb+13
rege      equ    clockb+14
regf      equ    clockb+15

