;*****************************************************
;* File zur Handhabung der V25-spezifischen Funktion *
;* implementierte Funktionen:			     *
;* Receive Port 0 Macro Service Channel 5 + 3	     *
;* Transmit Port 0 per Interupt                      *
;*****************************************************

 	   include cdefs.inc
	   include v25prt2.inc

;

;Die RX-Buffer mssen immer ein Vielfaches von 256 an Gre haben !!!
RX0_SIZE   equ	    3 * 256		    ;Gre RX-Buffer
TX0_SIZE   equ	    3 * 256		    ;Gre TX-Buffer

	   .data

rx0ptr	   dw	    ?			    ;Zeiger Eingangspuffer lesen
tx0ptr_i   dw	    ?			    ;Zeiger Ausgangspuffer ausgeben
tx0ptr_o   dw	    ?			    ;Zeiger Ausgangspuffer ausgeben
tx0_anz    dw	    ?			    ;Gesamtzahl zu sendender Zeichen
rx0_buff   db	    RX0_SIZE dup (?)        ;Eingangspuffer Kanal 0
tx0_buff   db	    TX0_SIZE dup (?)	    ;Ausgangspuffer Kanal 0

;

	   public  ishget0    ; gibt Anzahl der Zeichen im Rx-Buffer zurck
	   public  hgetc0     ; liest genau ein Zeichen as dem Rx-Puffer. Wenn
                              ; keins drin wird daruaf gewartet. Buffer wird dauernd
                              ; durch MacroService gefllt.

	   public  ishput0    ; gibt Platz im Tx-Buffer zurck
	   public  hputc0     ; hputc bergibt ein Byte in den Puffer. Keine Rcgabewerte

	   public  initseri0  ; serielle Schnittstelle Initialisieren
			      ; muss genau einmal aufgerufnen werden
                              ; Name gendert, 1.10.93 wg. neuem Parameter

;

	   .code
	   assume  cs:@code,ds:nothing
;
; ishput gibt TRUE zurck, wenn noch Platz im Tx-Buffer ist 
ishput0	   proc far
	   assume  ds:DATA
           mov     ax,TX0_SIZE              ;Gre des Puffers
	   sub	   ax,word ptr DATA:[tx0_anz] ;aktuellen Wert abziehen
           assume  es:nothing,ds:nothing
	   ret
ishput0	   endp
;
; hputc bergibt ein Byte in den Puffer. Keine Rckgabewerte 
hputc0	   proc    far
	   arg	   chr:byte		    ;Zeichen wird bergeben
	   mov	   ax,V25_SEG		    ;Segment V25-IO
	   mov	   es,ax		    ;setzen
	   assume  es:V25_SEG,ds:DATA
	   mov	   al,[chr]		    ;Zeichen holen
	   mov	   bx,word ptr DATA:[tx0ptr_i];Zeiger holen
	   mov	   byte ptr [bx],al	    ;und char ablegen
	   mov	   dx,bx		    ;merken
	   inc	   dx			    ;Zeiger + 1
	   cmp	   dx,offset DATA:tx0_buff + TX0_SIZE ;berlauf ?
	   jb	   @@no_txovr		    ;nein
	   mov	   dx,offset DATA:tx0_buff   ;wieder an Anfang
@@no_txovr:mov	   word ptr DATA:[tx0ptr_i],dx ;und Update
	   pushf			    ;Zustand retten
	   cli				    ;keine Interrupts
	   mov	   dx,word ptr DATA:[tx0_anz] ;Anzahl holen
	   inc	   dx			    ;+1
	   mov	   word ptr DATA:[tx0_anz],dx ;und update
	   dec	   dx			    ;erstes Zeichen ?
	   jnz	   @@not_first		    ;nein
	   ;hier angekommen ist es das erste Zeichen im Puffer, also Interupts anmachen
	   and	   byte ptr es:[STIC0],09Fh ;Int an,  MS aus
@@not_first:
	   popf 			    ;alter Zustand zurck
	   assume  es:nothing,ds:nothing
	   ret
hputc0	   endp
;
; wird von der Hardware aufgerufen, sobald RX-MacroService abgelaufen ist 
;
rx0int	   proc    far
	   sti				    ;sofort wieder zulassen
	   push    ds			    ;und Segmente
	   push    es			    ;auch
;           pusha                            ;alles fort
 push ax
	   mov	   ax,DATA		    ;DATA Wert
	   mov	   ds,ax		    ;setzen
	   mov	   ax,V25_SEG		    ;Segment V25-IO
	   mov	   es,ax		    ;setzen
	   assume  es:V25_SEG,ds:DATA

	   mov	   ax,word ptr es:[ms5.msp] ;aktuellen Offset holen
	   cmp	   ax,offset DATA:rx0_buff+RX0_SIZE ;Ende des Puffers ?
	   jb	   @@no_ovr		    ;nein
	   mov	   word ptr es:[ms5.msp],offset DATA:rx0_buff ;wieder auf Anfang
@@no_ovr:  mov	   byte ptr es:[ms5.msc],0  ;Count wieder auf 256 Byte setzen
	   or	   byte ptr es:[SRIC0],20h  ;MS wieder auf 1

           assume  es:nothing,ds:nothing
 pop ax
;           popa
	   pop	   es			    ;Segmente
	   pop	   ds			    ;zurck
	   cli				    ;keine Interrupts mehr (wg. fint)
	   fint 			    ;Fint Intruction
	   iret 			    ;Interrupt return
rx0int	   endp


; wird von der Hardware aufgerufen sobald TxB gesendet wurde 
tx0int	   proc    far
	   sti				    ;wieder zulassen (wurde durch IRQ gesperrt)
	   push    ax			    ;Arbeitsregister retten
	   push    bx
	   push    ds			    ;Segmente
	   push    es			    ;auch
	   mov	   ax,DATA		    ;DATA Wert
	   mov	   ds,ax		    ;setzen
	   mov	   ax,V25_SEG		    ;Segment V25-IO
	   mov	   es,ax		    ;setzen
	   assume  es:V25_SEG,ds:DATA
	   mov	   bx,word ptr DATA:[tx0ptr_o];Zeiger holen
	   mov	   al,byte ptr DATA:[bx]    ;Zeichen holen
	   mov	   byte ptr es:[TXB0],al    ;und ausgeben
	   inc	   bx			    ;nchster....
	   cmp	   bx,offset DATA:tx0_buff + TX0_SIZE ;Pufferende ?
	   jb	   @@no_ovr		    ;nein
	   mov	   bx,offset DATA:tx0_buff ;neu setzen
@@no_ovr:  mov	   word ptr DATA:[tx0ptr_o],bx;Zeiger setzen
	   dec	   word ptr DATA:[tx0_anz] ;Anzahl - 0
	   jnz	   @@ex 		    ;Ende
	   or	   byte ptr es:[STIC0],40h  ;Puffer ist leergesendet, Tx-Interupt sperren
	   assume  es:nothing,ds:nothing
@@ex:	   pop	   es			    ;Segmente
	   pop	   ds			    ;zurck
	   pop	   bx
	   pop	   ax			    ;Arbeitsregister
	   cli				    ;keine Interrupts mehr (?)
	   fint 			    ;Interrupt Ende
	   iret 			    ;Interrupt return
tx0int	   endp                             ;schwuppdiwupp - das wars...
;                                  
; Mu von Pascal aus mit der Baudrate als longint aufgerufen werden
; Es sind maximal 115200 Baud zulssig, aber noch nicht getestet.
initseri0  proc    far
           push    bp                       ;Standard Stack
           mov     bp,sp                    ;Entry
           mov     ax,V25_SEG               ;Segment V25-IO
           mov     es,ax                    ;setzen
           assume  es:V25_SEG,ds:DATA
	   or	   byte ptr es:[PRC],40h    ;RAM Enable-Bit ein
	   or	   byte ptr es:[SRIC0],40h  ;RX-Interrupts aus (maskieren)
	   mov	   byte ptr es:[SCM0],0C9h  ;Modus 8 Bit, keine Paritt
           ;* Vorteiler berechnen
           shr     word ptr [bp+8],1        ;Durch 2 High Word
           rcr     word ptr [bp+6],1        ;Low ebenfalls
           mov     dx,38                    ;High Word CPU-Clock
           mov     ax,9632                  ;Low Word CPU-Clock
           div     word ptr [bp+6]          ;Teilerfaktor bei Vorteiler 2
           shr     dx,1                     ;Rest teilen
           cmp     dx,word ptr [bp+6]       ;grer als Hlfte ?
           jb      @@no_half                ;nein
           inc     ax                       ;Faktor um eins korrigieren
@@no_half: mov     bl,00                    ;Vorteiler erstmal 0
@@chkvor:  or      ah,ah                    ;Vorteiler zu klein ?
           jz      @@vorend                 ;n ok
           shr     ax,1                     ;Teilerfaktor runter
           inc     bl                       ;Vorteiler rauf
           jmp     short @@chkvor           ;und weiter
@@vorend:  mov     byte ptr es:[SCC0],bl    ;Vorteiler setzen
           mov     byte ptr es:[BRG0],al    ;Hauptteiler setzen
                                            ; 9600 =  02/130
                                            ;19200 =  01/130
                                            ;38400 =  01/ 65
                                            ;76800 =  00/ 65
	   mov	   al,byte ptr es:[RXB0]    ;Dummy abholen (Rx-Register)
	   mov	   al,byte ptr es:[RXB0]    ;Dummy abholen (Rx-Register)
	   ;- Int 13d und Int 14d setzen
	   push    ds			    ;retten
	   mov	   ax,2500h + 13	    ;Interrupt 13 setzen (via DOS-SetIntVec)
					    ;fest im V25 verdrahtet fr V24-0-Rx
	   mov	   dx,cs		    ;cs nach
	   mov	   ds,dx		    ;ds
	   mov	   dx,offset rx0int	    ;Offset
           int	   21h			    ;ausfhren

	   mov	   ax,2500h + 14	    ;Interrupt 14 setzen (via DOS-SetIntVec)
					    ;fest im V25 verdrahtet fr V24-0-Tx
	   mov	   dx,cs		    ;cs nach
	   mov	   ds,dx		    ;ds
	   mov	   dx,offset tx0int	    ;Offset
           int	   21h			    ;ausfhren
	   pop	   ds			    ;alter Wert
	   ;* RX Init * MacroService,  Channel 5
     	   mov	   byte ptr es:[SRMS0],15h      ;Register to Memory, Normal mode, Channel 5
           ;;;;;;;;;.. mov	   byte ptr es:[SRMS0],95h      ;Register to Memory, ChSearch mode, Channel 5
           ;;;;;;;;;;;;mov	   byte ptr es:[ms5.schr],0c0h  ;Zu suchendes Zeichen: FEND
           mov	   byte ptr es:[ms5.msc],0      ;1 Bytes default Lnge
	   mov	   word ptr es:[ms5.mss],DATA   ;Segment setzen
	   mov	   word ptr es:[ms5.msp],offset DATA:rx0_buff ;auf Anfang
	   mov	   ax,offset RxB0	        ;Offset Rx-Register
	   mov	   byte ptr es:[ms5.sfrp],al    ;setzen

	   mov	   byte ptr es:[SEIC0],41h  ;Err.Reg.Int.Verbieten;Vect Interupt (Error reg);reg switchin, Prio 1 (lowest)
	   or	   byte ptr es:[SRIC0],20h  ;Macroservice anschalten (Rx)...
	   and	   byte ptr es:[SRIC0],0A7h ;und Enable Ints, Bank Switching an
	   mov	   word ptr DATA:[rx0ptr],offset DATA:rx0_buff

	   ;* TX Init,  ms5, aber noch nicht starten (is ja noch nix da)
	   or	   byte ptr es:[STIC0],40h    ;Tx-Interrupts aus
	   mov	   byte ptr es:[STMS0],03h    ;Memory to Register, ms3
	   mov	   ax,offset TxB0	      ;Offset Register
	   mov	   byte ptr es:[ms3.sfrp],al  ;setzen
	   mov	   word ptr es:[ms3.mss],DATA ;Segment setzen
	   mov	   word ptr es:[ms3.msp],offset DATA:tx0_buff; ms-ziel auf Anfang
	   mov	   byte ptr es:[ms3.msc],0    ;nix default
	   mov	   word ptr DATA:[tx0ptr_i],offset DATA:tx0_buff
	   mov	   word ptr DATA:[tx0ptr_o],offset DATA:tx0_buff
	   mov	   word ptr DATA:[tx0_anz],0  ;0 zu transferieren
	   assume  es:nothing,ds:nothing
           pop     bp                         ;Stack korrigieren
           ret     4                          ;Baudrate (longint) weg
initseri0  endp

;  ishget gibt Anzahl der Zeichen im Rx-Buffer zurck 
ishget0	   proc	   far
	   mov	   ax,V25_SEG		    ;Segment V25-IO
	   mov	   es,ax		    ;setzen
	   assume  es:V25_SEG,ds:DATA
	   or	   byte ptr es:[PRC],40h    ;RAM Enable ein
	   mov	   ax,word ptr es:[ms5.msp] ;aktuelle Macro Position
	   sub	   ax,word ptr DATA:[rx0ptr];Ausleseposition abziehen
	   jnc	   @@is_result		    ;>= 0 dann direkt Ergebnis
           neg     ax                       ;Komplement
           sub     ax,RX0_SIZE              ;Puffergre abziehen
           neg     ax                       ;nochmal Komplement
@@is_result:ret
	   assume  es:nothing,ds:nothing
ishget0	   endp

;  liest genau ein Zeichen as dem Rx-Puffer. Wenn keins drin wird darauf gewartet
hgetc0	   proc    far
	   assume ds:DATA
	   mov	   ax,V25_SEG		    ;Segment V25-IO
	   mov	   es,ax		    ;setzen
	   assume  es:V25_SEG,ds:DATA
	   or	   byte ptr es:[PRC],40h    ;RAM Enable ein
	   xor	   ax,ax		    ;kein Zeichen default
	   mov	   bx,word ptr DATA:[rx0ptr];Zeiger lesen
@@wait_get:cmp	   bx,word ptr es:[ms5.msp] ;gleich ?
	   je	   @@wait_get		    ;ja warten
	   mov	   al,byte ptr DATA:[bx]    ;Zeichen holen
	   mov	   ah,0 		    ;ah auf 0
	   inc	   bx			    ;ein Zeichen weiter
	   cmp	   bx,offset DATA:rx0_buff + RX0_SIZE ;Ende des Puffers ?
	   jb	   @@is_ok		    ;nein
	   mov	   bx,offset DATA:rx0_buff;Zeiger auf Pufferanfang
@@is_ok:   mov	   word ptr DATA:[rx0ptr],bx;setzen
	   ret
	   assume  es:nothing,ds:nothing
hgetc0	   endp
;

	   end
