{$I FD_INCL.PAS}
{$B-}
UNIT FD_TX;

INTERFACE

USES FD_Def;



CONST SOFORT  = TRUE;
      SPAETER = FALSE;

PROCEDURE SendPaket ( pM : TP_mBuf; pCB:TP_AXCB );
PROCEDURE TxQueue_mBuf_Chain ( pCB : TP_axcb; fWann : BOOLEAN;  pm : TP_mBuf); {* Hngt die Kette um *}
PROCEDURE TXCopy_mbufChain   ( pCB : TP_axcb; fWann : BOOLEAN;  pm : TP_mBuf); {* kopiert die Kette *}
PROCEDURE Tx_MemBlock        ( pCB : TP_axcb; fWann : BOOLEAN; pBlock : POINTER ; size : WORD);
PROCEDURE Tx_Info	     ( pCB : TP_axcb; fWann : BOOLEAN; {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
PROCEDURE Tx_InfoOneFrame    ( pCB : TP_axcb; fWann : BOOLEAN; {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
PROCEDURE Tx_TrimInfo        ( pCB : TP_axcb; fWann : BOOLEAN; sText : STRING);
PROCEDURE Tx_SysInfo	     ( pCB : TP_axcb; fWann : BOOLEAN; {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
PROCEDURE Tx_EOLSysInfo      ( pCB : TP_axcb; fWann : BOOLEAN; {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
PROCEDURE TX_Trigger         ( pCB : TP_AXCB);

     TYPE T_TXIMODUS = (cNURNEUE,cNORMAL) ;
 FUNCTION TryToTXIFrames (pCB : TP_axcb; modus : T_TXIMODUS ) : BYTE;
PROCEDURE TX_fromTXq     (pCB : TP_axcb; TXNr : BYTE; pollen : BOOLEAN);

PROCEDURE TX_UInfo ( pCB : TP_axcb; kmpf:T_KMPF; {$IFDEF ver70} CONST {$ENDIF} sText : STRING );
PROCEDURE TxUi     ( pInfo : POINTER; lenInfo : BYTE;
                     ifnr : t_ifNR; f,t,v : String; kmpf : T_kmpf; pid : BYTE);
PROCEDURE TxTestInfo ( ifnr : t_ifNR; f,t,v,infostr : String; kmpf : T_kmpf);
PROCEDURE TX_FRMR (pCB : TP_axcb; pmKaputt : TP_mBuf; bw,bx,by,bz : Byte);
PROCEDURE TX_Ctrl ( pCB       : TP_axcb;  {* Senden eines nicht ?I Blockes *}
		    frameTyp  : T_FrameTyp;
		    kmpf      : T_KMPF;
		    VAR Timer : T_Timer );

PROCEDURE TX_Ctrl_SABMHack
                    ( pCB       : TP_axcb;  {* Senden eines nicht ?I Blockes *}
		    frameTyp  : T_FrameTyp;
		    kmpf      : T_KMPF;
                    nr : WORD;
		    VAR Timer : T_Timer );


     TYPE T_VKM = (cV1,cKOM,cMEL);
PROCEDURE TX_Ctl (pCB : TP_axcb; vkm : T_VKM; ctl : Byte);  {* aussenden eines Blockes mit bel. CONTROLFELD *}
PROCEDURE RepaetRoutedPM ( pCB : TP_axcb; pm : TP_mBuf );


{}

IMPLEMENTATION


 USES {$IFDEF SCC} FD_TNC,
      {$ELSE}	   FD_CRT,
      {$ENDIF}
      FD_Div,
      FD_Error,
      FD_Pack,
      FD_Dump,   {* wg. Dump_AX25 *}
      FD_AXCB,   {* wg. CheckAxCB *}
      FD_Sysop,  {* TraceIt *}
      FD_Timer,
      FD_Task,
      FD_Subr,
      FD_mBuf,
      FD_Mem;
{$R+}


{}


PROCEDURE GruenerPunkt;
  VAR pDel,pZwisp : TP_mBuf;
BEGIN {* Lschen der zu Interuptzeit zu Abfall gewordener MBufs *}
  _DI;  {* Ers'ma ganze Kette umhngen, damit andere im Hintergrund weiter werkeln knnen *}
  pDel := lstDel.root;
  lstDel.Root := NiL;
  _EI;
  WHILE pDel <> Nil DO
    BEGIN
    pZwisp := pDel^.next;
    IF pDel^.discard THEN Del_MBuf (pDel)
		     ELSE Inc(count[cntErrDelQueue]); {* sollte nicht vorkoomem *}
    pDel := pZwisp;
    END;
END;


PROCEDURE SendPaket ( pM : TP_mBuf; pCB:TP_AXCB );
{* Schicke ein Paket ab; Highlevel-Funktion, die den Kram an die Treiber
 * verteilt.
 * pCB darf auch nil sein *}
  VAR pmDup: TP_mBuf;
      ifnr : T_ifnr;
      fEcho, fTrace : BOOLEAN;
BEGIN
  GruenerPunkt;
  pm^.Next := NiL;    {* sicher ist sicher *}
  ifnr := pm^.ifnr;
  _DI;  pm^.time := fasttick;  _EI;

  {* Bereits hier kopieren, ansonsten kopiert man einen *}
  {* Frame, der vieleich gerade TXt wird *}
  fEcho := (axifEcho>0) AND (pm^.ifnr <> axifecho) ;
  fTrace := TraceIt(pm);

  IF fEcho OR fTrace THEN pmDup := CopyMBuf(pm)
                     ELSE pmDup := NiL;

  IF (NOT axIFace[ifnr].valid ) OR (axIFace[ifNr].ptt_Mode = pttOFF)
    THEN BEGIN {* PTT ist gesperrt oder bind ungltig: Paket vernichten und nicht einreihen *}
	 _DI;
	 IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE;
	 _EI;
	 pm^.txed := TRANSMITTED; {* so tuen als ob, sonst haengt der Rest des Programmes *}
	 IF pm^.discard THEN Del_mBuf (pm);
	 END
    ELSE BEGIN {* Aussenden: An bind-Treiber weiterleiten *}
         {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
	 Inc( axIFace[Ifnr].nTxBrutto, pM^.inUse );
         {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
         {$IFDEf fddgdfggscc}
           {$IFDEF scc} Mause-Falle {$ENDIF}
                IF (Random(100)<22) THEN
	          BEGIN
	          Dump_ax25 (pm, fehler);
	          _DI;
	          IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE;
	          _EI;
	          pm^.txed := TRANSMITTED; {* so tuen als ob, sonst haengt der Rest des Programmes *}
	          IF pm^.discard THEN Del_mBuf (pm);
	          Exit;
	          END;
         {$ENDIF}
         {**das schlgt Hans vorher, aber ist wohl nicht mehr notwendig ************}
         {           if (not monimode.n) then
                       if ifnr <> 5 then Trace( cTraceTX, pm ); }
{*******************************************************}
{$IFDEF v24Life}
	 _DI;  pm^.time := fasttick;  _EI;
	 Dump_AX25 (pm,myTX);
{$ENDIF}
         IF CheckMBuf(pm)<>cAllOK THEN Exit;
         pm^.ifnr := axIFace[ifNr].devNrDn;
	 axIFace[ifNr].procTxPacket (pm);
	 END;

  IF fEcho
      THEN BEGIN
           pmDup^.ifnr := axifEcho;
           pmDup^.discard := true;
           SendPaket(pmdup, nil);
           END
      ELSE IF fTrace THEN
           Begin
           DoTrace( cTraceTX, pmDup, pCB );
           {*$TODO dup. brauchen wir nicht - wir knnten die Strings auch aus pm
            * zusammenstellen (dann aber voryfnTxPacket!!) *}
           Del_mBuf(pmDup);
           END;
END;

{}


PROCEDURE TxQueue_mBuf_chain ( pCB : TP_axcb;
			       fWann : BOOLEAN;
			       pm : TP_mBuf );
{* Einhngen einer mBuf-Kette (Start ab PM) in die TXqueue von pCB
 * Hier landet frher oder spter alles was der Digi senden soll
 *}
  VAR pmHilf : TP_mBuf;
BEGIN
  WatchDog;
  IF CheckMBuf(pm)<>cAllOK THEN Exit;{* Kann vorkommen bei circuits: Wenn IPaket leer ist *}
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;

  {* ggf. pm^.pData umwandeln (compress) *}
  IF pCB^.pid = PID_PACKES THEN
    BEGIN
    pm := Packesmbuf(pm);
    END;

  IF pCB^.TxBuf = Nil THEN pCB^.TxBuf := pm
	              ELSE pCB^.TxBufTail^.next := pm;
  pmHilf := pm; {* pm ist ungleich Nil - das wurde oben schon abgefangen *}
  REPEAT {* setze Tail neu und zhle gleichzeitig neue Lnge *}
    {* IF pmHilf^.pData=NiL THEN StoreStack('0','d');
     * IF pmHilf^.inUse=0 THEN StoreStack('0','e');
     *}
    IF pmHilf^.next=NiL THEN pCB^.TxBufTail := pmHilf;
    Inc ( pCB^.TxBufSize, pmHilf^.inUse );
    pmHilf := pmHilf^.next;
  UNTIL pmHilf = NiL;
  pCB^.fDoTxBuf := pCB^.fDoTxBuf OR fWann;
  TaskSwitch;
END;


PROCEDURE TX_Trigger (pCB : TP_AXCB);
  {* Anstossen der Sendung, fuer den Fall das wohl kein TX_Info mehr kommt *}
BEGIN
  pCB^.fDoTxBuf := true;
END;


PROCEDURE TXCopy_mbufChain ( pCB : TP_axcb; fWann : BOOLEAN; pm : TP_mBuf);
 {* Kopieren und anschliessendes Einhngen einer *}
 {* mBuf-Kette (p) in die TXqueue von pCB        *}
  VAR pmHilf,
      pmCopy,
      pmNeuStart,
      pmVorher : TP_mBuf;
BEGIN
  IF (pCB = NIL) OR (pm = NiL) THEN Exit;
  pmHilf := pm;
  pmVorher := Nil;  pmNeuStart := NiL;
  REPEAT
    pmCopy := CopyMBuf (pmHilf);
    pmCopy^.next := NiL;
    IF pmVorher <> NiL THEN pmVorher^.next := pmCopy
		       ELSE pmNeuStart := pmCopy;
    pmVorher := pmCopy;
    pmHilf := pmHilf^.next
  UNTIL pmHilf = NiL;
  TXQueue_mBuf_chain ( pCB, fWann, pmNeuStart );
END;


PROCEDURE Tx_MemBlock ( pCB : TP_axcb;	fWann : BOOLEAN;
                        pBlock : POINTER; size : WORD);
 {* Einreihen eines Blockes der Lnge SIZE *}
  VAR pm : TP_mBuf;
BEGIN
  IF pCB = NIL THEN Exit;
  IF size = 0 THEN BEGIN {* so spart man sich die entsprechende Abfrage beim Aufruf von TX_Block *}
                   StoreStack('1','a');
                   Exit;
                   END;
  pm := Get_MBuf ( size );
  Move ( pBlock^, pm^.pData^, size );
  TxQueue_mBuf_chain ( pCB, fWann, pm );
END;


PROCEDURE Tx_Info ( pCB : TP_axcb;  fWann : BOOLEAN;
                    {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
{* String in einen neuen mBuf kopieren    *}
{* und einreihen desselben in TxBuf-Kette *}
  VAR  pm : TP_mBuf;
BEGIN
  IF pCB = NIL THEN Exit; { s.z.B. PrintFlag }
  IF length(sText)=0 THEN Exit;
  pm := Get_MBuf ( length (sText) );
  pm^.nHeard := cANTIFRAGMENTFLAG; {HAckHack}
  Move ( sText[1], pm^.pData^, length (sText) );
  TxQueue_mBuf_chain ( pCB, fWann, pm );
END;

PROCEDURE Tx_InfoOneFrame ( pCB : TP_axcb; fWann : BOOLEAN;
                    {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
{* String in einen neuen mBuf kopieren    *}
{* und einreihen desselben in TxBuf-Kette. S landet in einem exklusivem Frame *}
  VAR  pm : TP_mBuf;
BEGIN
  IF pCB = NIL THEN Exit; { s.z.B. PrintFlag }
  IF length(sText)=0 THEN Exit;
  pm := Get_MBuf ( length (sText) );
  Move ( sText[1], pm^.pData^, length (sText) );
  TxQueue_mBuf_chain ( pCB, fWann, pm );
END;



PROCEDURE Tx_TrimInfo ( pCB : TP_axcb;  fWann : BOOLEAN; sText : STRING);
 {* Wie Tx_Info, aber rechtseitige Blanks vor einem EOL werden abgeschnitten *}
 {* Es muss allerdings mindestens EIN EOL am Ende dasein *}
BEGIN
  REolTrim( sText );
  Tx_Info (pCB, fWann, sText);
END;

PROCEDURE Tx_SysInfo ( pCB : TP_axcb;  fWann : BOOLEAN;
          {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
 {* Wie Tx_Info, aber es werden "*** " davorgeschrieben *}
BEGIN
  Tx_Info (pCB, fWann, '*** '+sText);
END;

PROCEDURE Tx_EOLSysInfo ( pCB : TP_axcb;  fWann : BOOLEAN;
          {$IFDEF ver70} CONST {$ENDIF} sText : STRING);
 {* Wie Tx_Info, aber es werden EOL+"*** " davorgeschrieben *}
BEGIN
  Tx_Info (pCB, fWann, EOL+'*** '+sText);
END;


{}

FUNCTION TryToTXIFrames ( pCB : TP_axcb; modus : T_TXIMODUS ) : BYTE;
{- Sende soviele Frames, wie mglich. Verschiebe wenn ntig die Infos aus
 - dem TXBuf(des pCBs) nach TXQ[].
 -}
  VAR  {i, len,}
       ctrlOfs	   : WORD;
       txnr	   : BYTE;
       framesTXed  : BYTE;
       pmDup	   : TP_mBuf;
       pHilf	   : POINTER;

     PROCEDURE Queue2Frame;
       VAR pmQuell,
           pmZwisp : TP_mBuf;
           pZiel  : POINTER;
           lInUse : longint;
     BEGIN {* Aus TxBuf was in den TXq schieben *}
       IF pCB^.TxBuf^.inUse=0   THEN StoreStack('0','f ' + hexAddrString(pCB^.TxBuf) );
       IF pCB^.TxBuf^.pData=NiL THEN StoreStack('0','g ' + hexAddrString(pCB^.TxBuf) );

       IF( (pCB^.pid <> PID_TEXT)  {* Frames nicht stopfen, wenn kein reines AX25 *}
        OR (pCB^.pPartnerCB<>NiL)  {* Nur bei QSOs mit der Infobox stopfen        *}
        OR (NOT useStopfen)        {* Oder gar nicht stopfen a.A.                 *}
         ) AND (pCB^.TxBuf^.nHeard <> cANTIFRAGMENTFLAG)
           AND (pCB^.TxBuf^.inUse<=MAXPACLEN) {* Wenn Paket zu gross ist: stopfen (kann durch Tx_MemBlock passieren) *}
 	     THEN lInUse := pCB^.TxBuf^.inUse  {* Nchstes Paket ist genauso gross wie Quell Paket *}
	     ELSE IF pCB^.TxBufSize>pCB^.paclen {* STOPF ES! *}
		    THEN lInUse := pCB^.paclen
		    ELSE lInUse := pCB^.TxBufSize;

       IF lInUse = 0 THEN
         BEGIN
         StoreStack( 'i', fStr(pCB^.paclen)+' '+fStr(pCB^.TxBuf^.inUse)+' '
                         +fStr(pCB^.TxBufSize) );
         {* Notnagel *}
         lInUse := 1;
         END;

       {* Wir singen jetzt alle: "Wo wo wo ist das WITH, wer hat das WITH geklaut..." *}
       {* $OPT noch besser  pmWrite := pCB^.txq[TXNr]; *}
       pCB^.txq[TXNr]:=Get_MBuf( CtrlOfs + 1 + lInUse ); {* Platz fr Header und Info *}
       pCB^.txq[TXNr]^.inUse := CtrlOfs + 1;
       pCB^.txq[TXNr]^.next := Nil; {* Debug *}

       Inc (pCB^.nUnbest);
       Inc (axIFace[pCB^.iface].nItxNetto);

       Dec (pCB^.TxBufSize, lInUse);
       IF pCB^.TxBufSize>30000 THEN StoreStack('B','2 '+fStr( pCB^.TxBufSize)+' '+FStr(linUse)+' '+FStr(pCB^.id) );
       Inc (brBytes, linUse);    {* Baudratenmessung *}
       Inc (axIFace[pCB^.iface].brChBytes, lInUse);  {* Was ich sende, trgt auch zur Kanal-Belastung bei *}

       pmQuell := pCB^.TxBuf;
       pZiel   := pCB^.txq[TXNr]^.pData;
       Inc ( Word (pZiel), ctrlOfs+1 ); {* Damit er an den Anfang des Info-Feldes zeigt *}
       WHILE (lInUse > 0) AND (pmQuell <> NiL) DO
	 BEGIN
	 IF pmQuell^.inUse <= lInUse
	   THEN BEGIN  {* mBuf vollstndig kopieren *}
		Move (pmQuell^.pData^, pZiel^, pmQuell^.inUse);
		Inc (Word(pZiel),           pmQuell^.inUse);
		Inc (pCB^.txq[TXNr]^.inUse, pmQuell^.inUse);
		Dec (lInUse,                pmQuell^.inUse);
		pmZwisp := pmQuell^.next;
		Del_mbuf (pmQuell);	{* Lschen des verwendeten TXQueues-Abschnitt *}
		pmQuell := pmZwisp;
		END
	   ELSE BEGIN  {* mBuf nur teilweise kopieren *}
		Move ( pmQuell^.pData^, pZiel^, lInUse);
		Inc (pCB^.txq[TXNr]^.inUse,  lInUse);
		DelMBufData (pmQuell, lInUse);
		lInUse := 0;
		END;
	 END; {* WHILE *}
       pCB^.TxBuf := pmQuell;
       IF pmQuell = Nil THEN pCB^.TxBufTail := NiL; {* Eigentlich berflssig *}
       {* jetzt stehen in "pCB^.txq[TXNr]^.pData^"                   *}
       {* "pCB^.txq[TXNr]^.inUse" Bytes (incl.Platz fr Ax25 Header) *}
     END; {* QUEUE2FRAMES *}

BEGIN
  TryToTXIFrames := 0;
  WatchDog;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit; {* Ungltiger pCB ? (auch Test auf Nil) *}

  {* Bevor ich sende, nuss vom anderen Final gekommen sein *}
  IF pCB^.fIvePolled THEN Exit;
  {* nur im Status CONNECTED ist ein Infotransfer moeglich und sinnvoll. *}
  IF pCB^.state <> CONNECTED THEN Exit;
  {* ja, wir hoeren auf das, was der Partner bittet, Auflsung durch tRNR *}
  IF pCB^.remoteBusy THEN Exit;

  {* Wenn man nur neue Frames versenden will/kann/darf, macht es
   * keinen Sinn das zu tun, solange noch Frames unbesttigt sind...
   * Diese Logik kam mir erst am 4.8.97 *}
  IF modus = cNURNEUE THEN
     IF pCB^.nUnbest > 0 THEN
       BEGIN
       {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
       Inc(Count[cntUnNew]);
       {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
       Exit;
       END;
  {****IF pCB^.nUnbest >= pCB^.maxFrame THEN Exit;****}

  {* Den wollen wir als erstes senden *}
  TXNr := (pCB^.lastack + 1) MOD 8;

  IF pCB^.txq[TXNr] = NiL
    THEN BEGIN {* Es liegen keine zu wiederholenden/unbesttigte Frames vor *}
	 IF pCB^.TxBufSize = 0 THEN
           BEGIN {* aktuell ist auch nix neues zu senden da - also was soll das? *}
           Exit;
           END;
	 END
    ELSE BEGIN {* wir wollen wiederholen *}
	 IF pCB^.txq[TXNr]^.txed = WAITING THEN
            BEGIN
	    {* Das nchste zu sendene I-Paket ist schon mal an SendPacket *}
	    {* bergeben worden, aber noch nicht (im Hintergrund) gesendet *}
	    {* worden. Wrden wir es (oder folgende) noch einmal bergeben *}
	    {* gbe es einen saftigen Systemabsturz, da dann der NextPointer *}
	    {* (auf das naechste zu sendene Paket der TX-Queue) fr die *}
	    {* Hintergrundroutine nicht mehr stimmt (Endlosschleife) *}
            Inc(count[cntIWait]);
            Exit;
            END;
	 END;

  framesTXed := 0;
  ctrlOfs := 7 * (2+pCB^.nDigi) + 1 ;
  StopTimer (pCB^.t1);

  WHILE     {* Es ist was zum Senden da - neu oder wiederholt... *}
            ( (pCB^.txq[TXNr] <> Nil) OR (pCB^.TxBufSize <> 0) )

        {* ... und auch MaxFrame ist noch nicht berschritten, *}
        {* es sei denn es ist ein Wiederholungssenden. Dann ist *}
        {* nUnbest ja evt.= Maxframe *}
        AND ( (pCB^.txq[TXNr] <> Nil) OR (pCB^.nUnbest < pCB^.maxFrame))

        {* und was oben gesagt wurde gilt fr weitere Frames natrlich auch *}
        AND ( (pCB^.txq[TXNr] = Nil) OR (pCB^.txq[TXNr]^.txed = TRANSMITTED) )

    DO	{* also drfen und sollen weitere Frames gefllt/gesendet werden *}
    BEGIN {* Frames suchen *}
    IF (pCB^.txq[TXNr] = Nil) AND (pCB^.TxBufSize <> 0) THEN
      BEGIN  {* neues Frame erzeugen *}
      Queue2Frame;
      {**IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;}
      IF CheckMBuf (pCB^.txq[TXNr]) <> cAllOK THEN Exit;
      {**IF NOT CheckMem (pCB^.txq[TXNr], sizeof(pCB^.txq[TXNr]^), cSTORE) THEN Exit;}
      END;

    {* so, und nun den Header basteln *}
    pHilf := pCB^.txq[TXNr]^.pData;

    {* Konstruiere Adresse *}
    Move ( pCB^.ToCall,   by1Array (pHilf^)[1], 7 );
    Move ( pCB^.FromCall, by1Array (pHilf^)[8], 7 );
    IF (pCB^.nDigi>0) THEN Move ( pCB^.Digi, by1Array (pHilf^)[15], pCB^.nDigi * 7 );

    {* Version ist bei DigiWare immer 2 *}
    by1Array (pHilf^)[07] := by1Array (pHilf^)[07] AND $7F;
    by1Array (pHilf^)[14] := by1Array (pHilf^)[14] AND $7F;

    {* I-Frames sind immer Kommandos *}
    by1Array (pHilf^)[7] := by1Array (pHilf^)[7] OR $80;

    {* Control *}    {* $OPT 1.Zeile streichen, 2 vereinfachen. *}
    by1Array (pHilf^)[ctrlOfs] := $00;  {* Info hier immer ohne Poll *}
    by1Array (pHilf^)[ctrlOfs] := (by1Array (pHilf^)[ctrlOfs] AND $f1) OR (TXNr	 SHL 1);
    by1Array (pHilf^)[ctrlOfs] := (by1Array (pHilf^)[ctrlOfs] AND $1f) OR (pCB^.nr SHL 5);

    {* PID *}
    by1Array (pHilf^)[ctrlOfs+1] := pCB^.PID;

    {* Vorbereiten der bergebe an SENDPACKET *}
    WITH pCB^.txq[TXNr]^ DO
      BEGIN
      ifnr    := pCB^.iface;
      ofsCtl  := ctrlOfs;
      discard := FALSE; {* werden evt. noch gebraucht - Lschen erst nach Bestigung *}
      txed    := WAITING;
      ptTimer := @pCB^.t1; {* Dieser Timer gehrt dazu *}
      END;

    IF (pCB^.redirectIfNr<>0) THEN
      BEGIN {* 1:1 Wiederholung auf nem annerem Interface *}
      pmDup := CopyMBuf(pCB^.txq[TXNr]);
      pmDup^.ifnr := pCB^.redirectIfnr;
      pmDup^.discard := TRUE;
      pmDup^.ptTimer := NiL;
      SendPaket(pmDup,pCB);
      {* kein Del_mBuf - das macht Sendpacket im Hintergrund *}
      END;

    {* Einrahmen, aber mu das sein ? Man kommt ja nur hierhin, wenn das *}
    {* Frame nicht (mehr) in der Level1-TXQ steht. Dann besteht doch     *}
    {* eigentlich nicht die Gefahr, das im Hintergrund (nmlich von      *}
    {* der Senderoutine) grade dieser Zeiger gendert wird...            *}
    _DI;
    {* Frames sind ja physikalisch noch nicht gesendet worden *}
    pCB^.t1.pbEnabled := pf_FOREVER_false;
    _EI;
    SendPaket ( pCB^.txq[TXNr], pCB);
    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
    Inc (framesTXed);
    {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
    TXNr := (TXNr+1) MOD 8;
  END; {* WHILE *}

  IF framesTXed > 0 THEN
    BEGIN
    StartTimerFast (pCB^.t1); {* Lasset uns FRACKen *}
    StopTimer (pCB^.t2);      {* I Frames enthalten ja eine implizite RX-Besttigung *}
    StopTimer (pCB^.t3);      {* t1 - luft ja *}
    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
    Inc (pCB^.wItx, framesTXed);
    Inc (axIFace[pCB^.iface].nItxBrutto, framesTXed);
    {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
    END;

  TryToTXIFrames := framesTXed;
END;



PROCEDURE TX_fromTXq (pCB : TP_axcb; TXNr : BYTE; pollen : BOOLEAN);
{* Ein bestimmtes, bereits gesendetes I-Paket nochmals senden.
 * Wird aufgerufen vom T1-I-Poller und bei Empfang eines REJ *}
  VAR i,
      ctrlOfs : WORD;
      pHilf   : POINTER;
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  IF CheckMBuf (pCB^.txq[TXNr]) <> cAllOK THEN Exit;

  IF pCB^.fivePolled THEN Exit;

  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  IF pCB^.txq[TXNr]^.txed = WAITING THEN
    BEGIN
     {* Das zu sendene I-Paket ist schon mal an SendPacket bergeben worden, *}
     {* aber noch nicht (im Hintergrund) gesendet worden. Wrden wir es      *}
     {* (oder folgende) noch einmal bergeben gbe es einen saftigen         *}
     {* Systemabsturz. wg. Endlosschleife in TXqueue. Das Paket wird wohl    *}
     {* dann irgendwann mal ausgesendet                                      *}
     Inc(Count[cntTXQW1]);
     Exit;
     END;
  {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}

  pHilf   := pCB^.txq[TXNr]^.pData;
  ctrlOfs := (7*pCB^.nDigi+15); {* 15,22,29... *}
  by1Array (pHilf^)[ctrlOfs] := (by1Array (pHilf^)[ctrlOfs] AND $1f) OR (pCB^.nr SHL 5);

  IF pollen
    THEN OrSelf (by1Array (pHilf^)[ctrlOfs], $10)
    ELSE AndSelf(by1Array (pHilf^)[ctrlOfs], byte(NOT $10) );

  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc (pCB^.wItx);
  Inc (axIFace[pCB^.iface].nItxBrutto);
  IF pollen THEN BEGIN
		 Inc (pCB^.wTxPolls);
                 pCB^.fIvePolled := true;
		 END;
  {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}

  WITH pCB^.txq[TXNr]^ DO
    BEGIN
    ifnr    := pCB^.iface;
    ofsCtl  := ctrlOfs;
    discard := FALSE; {* is ja nen I-Frame *}
    ptTimer := @pCB^.t1;
    txed    := WAITING;
    END;

  _DI;
  pCB^.t1.pbEnabled := pf_FOREVER_FALSE; {* Frames sind ja physikalisch noch nicht gesendet worden *}
  _EI;
  SendPaket ( pCB^.txq[TXNr], pCB );

  StartTimerFast (pCB^.t1); {* Lasset uns FRACKen *}
  StopTimer	 (pCB^.t2); {* I Frames enthalten eine implizite Empfangsbesttigung *}
  StopTimer	 (pCB^.t3); {* t1 - luft ja *}
END;

{}


PROCEDURE TX_Ctrl ( pCB       : TP_axcb;  {* Senden eines nicht ?I Blockes *}
		    frameTyp  : T_FrameTyp;
		    kmpf      : T_KMPF;
		    VAR Timer : T_Timer );
  VAR  len,
       ctrlOfs : WORD;
       ctrlByte: BYTE;
       pm      : TP_mBuf;
       p       : POINTER;
       wtmp : Word;
BEGIN
  IF pCB = NIL THEN Exit;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;

  IF frameTyp = RMR THEN
    IF pCB^.Busy OR busy THEN frameTyp := RNR
 			 ELSE frameTyp := RR;

  {* Konstruiere Header tocall,fromcall *}
{$IFDEF virtAdr}
  IF pCB^.fvirtAdr
    THEN BEGIN
         ctrlOfs := 8;
         pm := Get_MBuf (ctrlOfs);  {* Buffer bereitstellen *}
         p := pm^.pData;	     {* Hilfszeiger *}
         wtmp := (pCB^.virtAdr             SHL 2)
              OR (Ord((kmpf AND cKOMM)<>0) SHL 1)
              OR 1;  {* EoA *}
         by1Array(p^)[1] := Hi(wTmp);
         by1Array(p^)[2] := Lo(wTmp);
         END
    ELSE
{$ENDIF}
         BEGIN
         ctrlOfs := 7 * ( 2 + pCB^.nDigi ) + 1;
{$IFDEF virtAdr}
         IF (pCB^.VirtAdr > 0) AND (frametyp=UA)
           THEN BEGIN
                pCB^.fVirtAdr := true;
                pm := Get_MBuf (ctrlOfs+2);  {* Buffer bereitstellen *}
                END
           ELSE
{$ENDIF}
                pm := Get_MBuf (ctrlOfs);  {* Buffer bereitstellen *}
         p := pm^.pData;	     {* Hilfszeiger *}

         Move ( pCB^.ToCall,   by1Array(p^)[1], 7 );
         Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
         IF pCB^.nDigi > 0 THEN Move ( pCB^.Digi, by1Array(p^)[15], pCB^.nDigi * 7 );

         {* Kommando,Meldung und Version kodieren *}
         by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
         by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
         IF (kmpf AND cMELD) <> 0 THEN  by1Array(p^)[14] := by1Array(p^)[14] OR $80
                                  ELSE  by1Array(p^)[07] := by1Array(p^)[07] OR $80;
{$IFDEF virtAdr}
         IF pCB^.fvirtAdr THEN
           BEGIN {* Meine Qsonr hintendran hngen *}
           by1Array(p^)[ctrlofs+1] := Hi(pCB^.virtAdr);
           by1Array(p^)[ctrlofs+2] := Lo(pCB^.virtAdr);
           END;
{$ENDIF}
         END;

  {* Kontrollfeld *}
  ctrlByte := FrameCode[frameTyp];
  IF (kmpf AND cPFBIT) <> 0 THEN ORSelf( ctrlByte, $10 );
  by1Array(p^)[ctrlOfs] := ctrlByte;
  IF kmpf = cPOLL THEN
    BEGIN
    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
    Inc (pCB^.wTxPolls);
    Inc (axIFace[pCB^.iface].nTxSvPolls);
    {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
    pCB^.fIvePolled := true;
    END;

  pCB^.rnrSent := frameTyp=RNR;
  CASE frameTyp OF
    RR,
    RNR,
    REJ : BEGIN {* NR einORen *}
          CASE frameTyp OF
             {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
             RR    :  BEGIN Inc (pCB^.wRRtx);  Inc (axIFace[pCB^.iface].nRRtx); END;
             REJ   :  BEGIN Inc (pCB^.wREJtx); Inc (axIFace[pCB^.iface].nREJtx); END;
             RNR   :  BEGIN Inc (pCB^.wRNRtx); Inc (axIFace[pCB^.iface].nRNRtx); END;
             {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
             END;{case}
	  by1Array(p^)[ctrlOfs] := (by1Array(p^)[ctrlOfs] AND $1f) OR (pCB^.nr SHL 5);
	  END; {* rej,rr,rnr: *}
    END;{case}

  pm^.ifnr    := pCB^.iface;
  pm^.discard := TRUE;
  pm^.ofsCtl  := ctrlOfs;
  pm^.txed    := WAITING;
  pm^.ptTimer := @Timer;

  {* Einrahmen, denn das zugeh. I-Frame wird ja evt. gerade gesendet (kurzes
   * FRACK z.B.), dadurch wird vielleicht grade der Zeiger manipuliert.
   *}
  _DI;
  IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_FALSE; {* zugeh. Timer darf noch nicht laufen *}
  _EI;
  SendPaket ( pm, pCB );
END;

PROCEDURE TX_Ctrl_SABMHack
                    ( pCB       : TP_axcb;  {* Senden eines nicht ?I Blockes *}
		    frameTyp  : T_FrameTyp;
		    kmpf      : T_KMPF;
                    nr : WORD;
		    VAR Timer : T_Timer );
  VAR  len,
       ctrlOfs : WORD;
       pm      : TP_mBuf;
       p       : POINTER;
BEGIN
  IF pCB = NIL THEN Exit;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;

  IF frameTyp = RMR THEN
    IF pCB^.Busy OR busy THEN frameTyp := RNR
 			 ELSE frameTyp := RR;

  {* Konstruiere Header tocall,fromcall *}
  ctrlOfs := 7 * ( 2 + pCB^.nDigi ) + 1 ;

  pm := Get_MBuf (ctrlOfs+2);  {* Buffer bereitstellen *}
  p := pm^.pData;	     {* Hilfszeiger *}

  Move ( pCB^.ToCall,	by1Array(p^)[1], 7 );
  Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
  IF pCB^.nDigi > 0 THEN Move ( pCB^.Digi, by1Array(p^)[15], pCB^.nDigi * 7 );

  {* Kommando,Meldung und Version kodieren *}
  by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
  by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
  IF (kmpf AND cMELD) <> 0 THEN  by1Array(p^)[14] := by1Array(p^)[14] OR $80
                           ELSE  by1Array(p^)[07] := by1Array(p^)[07] OR $80;

  {* Kontrollfeld *}
  CASE frameTyp OF   {* $OPT*: Konstante Tabelle: x : ARRAY [RR..FRMR] OF BYTE;*}
     RR    :  by1Array(p^)[ctrlOfs] := $01;
     RNR   :  by1Array(p^)[ctrlOfs] := $05;
     REJ   :  by1Array(p^)[ctrlOfs] := $09;
     SABM  :  by1Array(p^)[ctrlOfs] := $2f;
     UA    :  by1Array(p^)[ctrlOfs] := $63;
     DISC  :  by1Array(p^)[ctrlOfs] := $43;
     DM    :  by1Array(p^)[ctrlOfs] := $0f;
     FRMR  :  by1Array(p^)[ctrlOfs] := $87;
     END;

  IF (kmpf AND cPFBIT) <> 0 THEN ORSelf( by1Array(p^)[ctrlOfs], $10 );
  IF kmpf = cPOLL THEN
    BEGIN
    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
    Inc (pCB^.wTxPolls);
    Inc (axIFace[pCB^.iface].nTxSvPolls);
    {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
    pCB^.fIvePolled := true;
    END;

  pCB^.rnrSent := frameTyp=RNR;
  CASE frameTyp OF
    RR,
    RNR,
    REJ : BEGIN {* NR einORen *}
          CASE frameTyp OF
             {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
             RR    :  BEGIN Inc (pCB^.wRRtx);  Inc (axIFace[pCB^.iface].nRRtx); END;
             REJ   :  BEGIN Inc (pCB^.wREJtx); Inc (axIFace[pCB^.iface].nREJtx); END;
             RNR   :  BEGIN Inc (pCB^.wRNRtx); Inc (axIFace[pCB^.iface].nRNRtx); END;
             {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
             END;{case}
	  by1Array(p^)[ctrlOfs] := (by1Array(p^)[ctrlOfs] AND $1f) OR (pCB^.nr SHL 5);
	  END; {* rej,rr,rnr: *}
    END;{case}

  by1Array(p^)[ctrlOfs+1] := lo(nr);
  by1Array(p^)[ctrlOfs+2] := hi(nr);


  pm^.ifnr    := pCB^.iface;
  pm^.discard := TRUE;
  pm^.ofsCtl  := ctrlOfs;
  pm^.txed    := WAITING;
  pm^.ptTimer := @Timer;

  {* Einrahmen, denn das zugeh. I-Frame wird ja evt. gerade gesendet (kurzes
   * FRACK z.B.), dadurch wird vielleicht grade der Zeiger manipuliert.
   *}
  _DI;
  IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_FALSE; {* zugeh. Timer darf noch nicht laufen *}
  _EI;
  SendPaket ( pm, pCB );
END;


PROCEDURE Tx_Ctl (pCB : TP_axcb;
    	          vkm : T_VKM;
                  ctl : Byte);
  {* Aussenden eines Blockes mit bel. CONTROLFELD *}
  VAR  ctrlOfs : WORD;
       pm      : TP_mBuf;
       p       : POINTER;
BEGIN
  IF pCB = Nil THEN Exit;

  {* Konstruiere Header tocall,fromcall *}
  ctrlOfs := (7*(2+pCB^.nDigi)+1);
  pm := Get_MBuf (ctrlOfs);
  p := pm^.pData;

  Move ( pCB^.ToCall,   by1Array(p^)[1], 7 );
  Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
  IF pCB^.nDigi>0 THEN Move ( pCB^.Digi, by1Array(p^)[15], 7*pCB^.nDigi );

  {* Kommando,Meldung und Version kodieren *}
  by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
  by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
  IF (vkm = cMEL)      THEN by1Array(p^)[14] := by1Array(p^)[14] OR $80
  ELSE IF (vkm = cKOM) THEN by1Array(p^)[07] := by1Array(p^)[07] OR $80;

  {* Control *}
  by1Array(p^)[ctrlOfs] := ctl;

  pm^.ifnr := pCB^.iface;
  pm^.discard := TRUE;
  pm^.ofsCtl := ctrlOfs;
  pm^.ptTimer := Nil;
  pm^.txed    := WAITING;

  SendPaket ( pm, pCB );
END;

{}

PROCEDURE TX_UInfo ( pCB : TP_axcb; kmpf:T_KMPF; {$IFDEF ver70} CONST {$ENDIF} sText : STRING );
 {* Senden eines UI Blockes *}
  VAR  p   : POINTER;
       pm  : TP_mBuf;
       len,
       ctrlOfs,
       i   : WORD;
BEGIN
  IF pCB = NIL THEN Exit;

  ctrlOfs := (7*(2+pCB^.nDigi)+1);
  pm := Get_MBuf (ctrlOfs+1+length(sText));
  p := pm^.pData;

{* Konstruiere Header tocall,fromcall *}
  Move ( pCB^.ToCall,	by1Array(p^)[1], 7 );
  Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
  IF pCB^.nDigi>0 THEN Move ( pCB^.Digi, by1Array(p^)[15], pCB^.nDigi * 7 );

{* Version *}
  by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
  by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
  IF (kmpf AND cMELD) <> 0 THEN  by1Array(p^)[14] := by1Array(p^)[14] OR $80
                           ELSE  by1Array(p^)[07] := by1Array(p^)[07] OR $80;
{* Control *}
  IF (kmpf AND cPFBIT) <> 0 THEN by1Array(p^)[ctrlOfs] := $13
	                    ELSE by1Array(p^)[ctrlOfs] := $03;  {* U.Info *}
{* PID *}
  by1Array(p^)[ctrlOfs+1] := pCB^.PID;

{* Text kopieren *}
  Move (sText[1], by1Array(p^)[ctrlOfs+2], length (sText) );

  pm^.ifnr    := pCB^.iface;
  pm^.discard := TRUE;	     {* kann weggeschmissen werden *}
  pm^.ofsCtl  := ctrlOfs;
  pm^.txed    := WAITING;
  pm^.ptTimer := Nil;
  SendPaket (pm, pCB);
END;


PROCEDURE TxUi ( pInfo : POINTER; lenInfo : BYTE;
                 ifnr : t_ifNR; f,t,v : String; kmpf : T_kmpf; pid : BYTE);
{* Einmaliges Ausstrahlen einer Bake *}
  VAR pCB : tp_axcb;
      s : STRING;
BEGIN
  IF lenInfo > 255 THEN lenInfo := 255;
  pCB := CreateAXCB (ifnr);
  IF pCB <> NiL THEN
    BEGIN
    Asc2axcb ( f,t,v, pCB );
    {* $OPT Autorouter ! *}
    pCB^.QSOType := qtBAKE;
    pCB^.iFace := ifnr;
    pCB^.pf := cMELD;
    pCB^.pid := PID;

    s[0] := char(lenInfo);
    MOVE( pInfo^, s[1], leninfo);

    Tx_UInfo ( pCB,  kmpf, s );
    Del_axcb ( pCB );
    END;
END;




{* Debug *}
  PROCEDURE Doit ( pCB : TP_axcb; kmpf:T_KMPF; sText : STRING );
   {* Senden eines I Blockes *}
    VAR  p   : POINTER;
         pm  : TP_mBuf;
         len,
         ctrlOfs,
         i   : WORD;
  BEGIN
    IF pCB = NIL THEN Exit;

    ctrlOfs := (7*(2+pCB^.nDigi)+1);
    pm := Get_MBuf (ctrlOfs+1+length(sText));
    p := pm^.pData;

  {* Konstruiere Header tocall,fromcall *}
    Move ( pCB^.ToCall,	by1Array(p^)[1], 7 );
    Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
    IF pCB^.nDigi>0 THEN Move ( pCB^.Digi, by1Array(p^)[15], pCB^.nDigi * 7 );

  {* Version *}
    by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
    by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
    IF (kmpf AND cMELD) <> 0 THEN  by1Array(p^)[14] := by1Array(p^)[14] OR $80
                             ELSE  by1Array(p^)[07] := by1Array(p^)[07] OR $80;
  {* Control *}
    IF (kmpf AND cPFBIT) <> 0 THEN by1Array(p^)[ctrlOfs] := $10
	                      ELSE by1Array(p^)[ctrlOfs] := $00;  {* U.Info *}
  {* PID *}
    by1Array(p^)[ctrlOfs+1] := pCB^.PID;

  {* Text kopieren *}
    Move (sText[1], by1Array(p^)[ctrlOfs+2], length (sText) );

    pm^.ifnr    := pCB^.iface;
    pm^.discard := TRUE;	     {* kann weggeschmissen werden *}
    pm^.ofsCtl := ctrlOfs;
    pm^.txed    := WAITING;
    pm^.ptTimer := Nil;
    SendPaket (pm, pCB);
  END;

PROCEDURE TxTestInfo ( ifnr : t_ifNR; f,t,v,infostr : String; kmpf : T_kmpf);
  VAR pCB : tp_axcb;
      i   : WORD;
      s   : String;
BEGIN
  pCB := CreateAXCB (ifnr);
  IF pCB <> NiL THEN
    BEGIN
    s := infostr;
    Asc2axcb ( f,t,v, pCB );
    pCB^.QSOType := qtBAKE;
    pCB^.iFace := ifnr;
    pCB^.pf := cMELD;
    Doit ( pCB,  kmpf, s );
    Del_axcb ( pCB );
    END;
END;



PROCEDURE RepaetRoutedPM ( pCB : TP_axcb; pm : TP_mBuf );
{* L2-Digipeaten eines Frames, das durch den Router lief. *}
{* Meistens UIs! Aber alle anderen sind auch mglich *}
  VAR  newOfsCtl,
       oldOfsCtl : BYTE;
       lenCopy   : WORD;
       pMTx	 : TP_mBuf;
       p,pq ,pa,pn : Pointer;
BEGIN
  IF pCB = NIL THEN Exit;
  IF (pCB^.iface<1) OR (pCB^.iface>7) THEN
    BEGIN
    StoreStack('r',FStr(pCB^.iface));
    Exit;
    END;
{* Kopieren des neuen Headers mit dem alten Ctrl-Feld und etwaigen PID und Text in einen neuen Bufer *}
  newOfsCtl := 14+7*pCB^.nDigi+1;
  oldOfsCtl := pm^.ofsCtl;
  lenCopy := pm^.inUse-oldOfsCtl+1; {* ctl wird mitkopiert *}
  pmTx := Get_MBuf(newOfsCtl+lenCopy-1);
  p := pmTx^.pData;
  Move ( pCB^.ToCall,	p^, 7 ); Inc (word(p),7);
  Move ( pCB^.FromCall, p^, 7 ); Inc (word(p),7);
  IF pCB^.nDigi>0 THEN
    BEGIN
    Move ( pCB^.Digi, p^, 7*pCB^.nDigi );
    Inc (word(p),7*pCB^.nDigi);
    END;

  {- Command/respone und reserved Flag mssen aus dem Original genommen werden *}
{  pa := IncP(pm^.pData,6);
  pn := Incp(pmTx^.pData,6);
  byte(pn^) := (byte(pa^) AND $1F) OR (byte(pn^) AND $E0);
  pa := IncP(pm^.pData,13);
  pn := Incp(pmTx^.pData,13);
  byte(pn^) := (byte(pa^) AND $1F) OR (byte(pn^) AND $E0); }


  pq := pm^.pData; Inc (word(pq),oldOfsCtl-1);
  Move ( pq^, p^, lenCopy ); {* Ctrlfeld, evt. PID und Info aus PM kopieren *}

  IF (pCB^.iface<1) OR (pCB^.iface>7) THEN BEGIN
                                           StoreStack('r',FStr(pCB^.iface));
                                           Exit;
                                           END;
  pmTx^.inUse	:= newOfsCtl+lenCopy-1;
  pmTx^.ifnr	:= pCB^.iface;
  pmTx^.discard := TRUE;       {* Nach Aussenden weggeschmeissen *}
  pmTx^.ofsCtl  := newOfsCtl;
  pmTx^.txed	:= WAITING;
  pmTx^.ptTimer := Nil;
  SendPaket (pmTx, pCB);
END;



PROCEDURE Tx_FRMR (pCB : TP_axcb; pmKaputt : TP_mBuf; bw,bx,by,bz : Byte);
  VAR  ctrlOfs : WORD;
       pm      : TP_mBuf;
       p       : Pointer;
BEGIN
  IF pCB = Nil THEN Exit;
  ctrlOfs := (7*(2+pCB^.nDigi)+1);
  pm := Get_MBuf (ctrlOfs+3);
  p := pm^.pData;

  {* Konstruiere Header tocall,fromcall *}
  Move ( pCB^.ToCall,	by1Array(p^)[1], 7 );
  Move ( pCB^.FromCall, by1Array(p^)[8], 7 );
  IF pCB^.nDigi>0 THEN Move ( pCB^.Digi, by1Array(p^)[15], pCB^.nDigi * 7 );

  {* Version *}
  by1Array(p^)[07] := by1Array(p^)[07] AND $7F;
  by1Array(p^)[14] := by1Array(p^)[14] AND $7F;
  {** IF pCB^.axVersion = 2 THEN **}
     by1Array(p^)[14] := by1Array(p^)[14] OR $80;

  {* Control *}
  IF (pCB^.pf AND cPFBIT) <>0 THEN by1Array(p^)[ctrlOfs] := $97   {* FRMRp *}
                              ELSE by1Array(p^)[ctrlOfs] := $87;  {* FRMR  *}

  {* FRMR haben kein PID *}
  IF pmKaputt = Nil THEN by1Array(p^)[ctrlOfs+1] := 0
		    ELSE by1Array(p^)[ctrlOfs+1] := by1Array(pmKaputt^.pdata^)[ctrlofs];
  by1Array(p^)[ctrlOfs+2] := (2*(pCB^.lastack+1) MOD 8) + ($20*pCB^.nr);
  IF (pCB^.pf AND cMELD)<>0  THEN Inc (by1Array(p^)[ctrlOfs+2], $10);
  by1Array(p^)[ctrlOfs+3] := bw+2*bx+4*by+8*bz;

  pm^.ifnr    := pCB^.iface;
  pm^.discard := TRUE;	     {* kann nach dem Senden weggeschmissen werden *}
  pm^.ofsCtl := ctrlOfs;
  pm^.ptTimer := Nil;
  pm^.txed    := WAITING;
  SendPaket (pm, pCB);
  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(count[cntTxFRMR]);
  {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
END;



END.

