UNIT FD_TNC;

 {* Gegenstck zu FD_CRT. Enthlt auf FALCon - Verhltnisse angepasste *}
 {* Routinen aus der Unit CRT. *}

{$I FD_INCL.PAS}

{$IFnDEF SCC}
      ! Wenn SCC aus ist, DARF diese Unit nicht eingebunden werden !
         ! Bitte kontolliert die USES IN den anderen Modulen !
{$ENDIF}



(*************************************************************************)
(* UNIT zur Ansteuerung des TNCs unter Turbo-Pascal                      *)
(* Die UNIT ersetzt ausserdem die Routinen der Units CRT und DOS. Diese  *)
(* beiden Units drfen auf keinen Fall mehr benutzt werden !!!!!!        *)
(* Zu dieser UNIT gehrt noch das FILE tncutils.obj                      *)
(*                                                                       *)
(* Autor: Werner Cornelius DG3DBI                                        *)
(*        Normannenstr. 22                                               *)
(*        D-4630 Bochum 1                                                *)
(* Nutzung nur fr Entwicklungszwecke des FALCONs im nichtgewerblichen   *)
(* und nichtkommerziellen Amateurfunkbereich erlaubt.                    *)
(*************************************************************************)

INTERFACE
  uses fd_def;
  {*****************************}
  {* V25+-Registerdefinitionen *}
  {*****************************}

CONST
   V25SEG = $FF00; {* Inhalt des IDB-Registers - Beim FALCon-Loader dort festgelegt *}
VAR
   EXIC0 : BYTE absolute V25SEG:$0F4c;
   EXIC1 : BYTE absolute V25SEG:$0F4d;
   P0  : BYTE absolute V25SEG:$0F00; {* Port0 R/W 8/1 (1-48)               *}
   P1  : BYTE absolute V25SEG:$0F08; {* Im FALCon: Nur lesen! *}
   P2  : BYTE absolute V25SEG:$0F10; {* Im FALCon: Nur lesen! *}

   PMT : BYTE absolute V25SEG:$0F3b; {* PortT-Moderegister R/W 8/1 (1-147) *}
   PT  : BYTE absolute V25SEG:$0F38; {* PortT R/O 8  (1-48)                *}

   {* direkter zZugiff auf pm0 NICHT erlaubt ! *}
VAR PM0_mirror : Byte;
    PM0_reg    : Byte Absolute V25SEG:$0f01; {* Port0-Moderegister R/O, 8 Bit *}

  PROCEDURE pm0_Write ( x : BYTE);
   FUNCTION pm0_Read  : BYTE;

{* V25+ Adressen fr EEPROM IO *}
CONST DATBIT = $01;  {* Datenbit 0 *}
      CLKBIT = $02;  {* Clockbit 1 *}


  {************************}
  {* SCC-Portdefinitionen *}
  {************************}
CONST
   DMA1        = $00		    ;  {* ISCC 1 DMA Base *}
   ISCC1       = $40		    ;  {* ISCC 1 SCC Base *}
   SDLC1       =ISCC1 + $01	   ;  {* Port 1 SDLC *}
   SDLC2       =ISCC1 + $00	   ;  {* Port 2 SDLC *}

   DMA2        = $20		    ;  {* ISCC 2 DMA Base *}
   ISCC2       = $60		    ;  {* ISCC 2 SCC Base *}
   SDLC3       =ISCC2 + $01	   ;  {* Port 3 SDLC *}
   SDLC4       =ISCC2 + $00	   ;  {* Port 4 SDLC *}

   PCLK        = 9830400;	       {* Taktrate PCLK *}

   RX_ENABLE   = $01		    ;  {* Maske RX Enable *}
   TX_ENABLE   = $08		    ;  {* Maske TX Enable *}
   RTS_ON      = $02		    ;  {* Maske RTS Ausgang *}
   DTR_ON      = $80		    ;  {* Maske DTR Ausgang *}
   WR0	       = 2 * $00	    ;  {* Various Initialization Commands *}
   WR1	       = 2 * $01	    ;  {* Transmit and Receive Interrupts, Wait/DMA *}
   WR2	       = 2 * $02	    ;  {* Interrupt Vektor *}
   WR3	       = 2 * $03	    ;  {* Receive Parameters and Control Modes *}
   WR3_MODE    = $D8		    ;  {* 8 Bit Rx, Hunt Mode, Rx CRC on *}
   WR4	       = 2 * $04	    ;  {* Transmit and Receive Modes and Parameter *}
   WR5	       = 2 * $05	    ;  {* Transmit Parameters *}
   WR5_MODE    = $61		    ;  {* Transmit Parameter *}
   WR6	       = 2 * $06	    ;  {* Sync Caracter/SDLC Address *}
   WR7	       = 2 * $07	    ;  {* Sync Chracter/SDLC Flag *}
   WR8	       = 2 * $08	    ;  {* Transmit Buffer *}
   WR9	       = 2 * $09	    ;  {* Master Interrupt Control and Reset Commands *}
   WR10        = 2 * $0A	    ;  {* Miscellaneous Transmit and Receive Control Bits *}
   WR11        = 2 * $0B	    ;  {* Clock Mode Controls for Receive and Transmit *}
   WR12        = 2 * $0C	    ;  {* Lower Byte of Baudrate Generator *}
   WR13        = 2 * $0D	    ;  {* Upper Byte of Baudrate Generator *}
   WR14        = 2 * $0E	    ;  {* Miscellaneous Control Bits *}
   WR15        = 2 * $0F	    ;  {* External Status Interrupt Enable Control *}

   RD0	       = 2 * $00	    ;  {* Transmit and Receive Buffer Status/External Status *}
   RD1	       = 2 * $01	    ;  {* Special Receive Condition Status *}
   RD2	       = 2 * $02	    ;  {* Interrupt Vektor (modified Can.B) (unmodified A) *}
   RD3	       = 2 * $03	    ;  {* Interrupt pending Bits Can. A only *}
   RD6	       = 2 * $06	    ;  {* SDLC FIFO Byte Count Low (only when enabled) *}
   RD7	       = 2 * $07	    ;  {* SDLC FIFO Byte Count and Status (only when enabled) *}
   RD8	       = 2 * $08	    ;  {* Receive Buffer *}
   RD10        = 2 * $0A	    ;  {* Miscellaneous Status Bits *}
   RD12        = 2 * $0C	    ;  {* Lower byte of Baudrate Time Constant *}
   RD13        = 2 * $0D	    ;  {* Upper Byte of Baudrate Time Constant *}
   RD15        = 2 * $0F	    ;  {* External Status Interrupt Information *}

   CCAR        = $00		    ;  {* Channel Command Register *}
   DSR	       = $00		    ;  {* DMA Status Register *}
   ICR	       = $01		    ;  {* Interrupt Control Register *}
   IVR	       = $02		    ;  {* Interrupt Vektor Register *}
   ICSR        = $03		    ;  {* Interrupt Command Register *}
   ISR	       = $03		    ;  {* Interrupt Status Register *}
   DER	       = $04		    ;  {* DMA Enable Register *}
   DCR	       = $05		    ;  {* DMA Control Register *}
   RDCRA0      = $08		    ;  {* Receive Count Register A Byte = $ *}
   RDCRA1      = $09		    ;  {* Receive Count Register A Byte 1 *}
   TDCRA0      = $0A		    ;  {* Transmit Count Register A Byte = $ *}
   TDCRA1      = $0B		    ;  {* Transmit Count Register A Byte 1 *}
   RDCRB0      = $0C		    ;  {* Receive Count Register B Byte = $ *}
   RDCRB1      = $0D		    ;  {* Receive Count Register B Byte 1 *}
   TDCRB0      = $0E		    ;  {* Transmit Count Register B Byte = $ *}
   TDCRB1      = $0F		    ;  {* Transmit Count Register B Byte 1 *}
   RDARA0      = $10		    ;  {* Receive Adress Register A Byte = $ *}
   RDARA1      = $11		    ;  {* Receive Adress Register A Byte 1 *}
   RDARA2      = $12		    ;  {* Receive Adress Register A Byte 2 *}
   TDARA0      = $14		    ;  {* Transmit Adress Register A Byte 0 *}
   TDARA1      = $15		    ;  {* Transmit Adress Register A Byte 1 *}
   TDARA2      = $16		    ;  {* Transmit Adress Register A Byte 2 *}
   RDARB0      = $18		    ;  {* Receive Adress Register A Byte = $ *}
   RDARB1      = $19		    ;  {* Receive Adress Register A Byte 1 *}
   RDARB2      = $1A		    ;  {* Receive Adress Register A Byte 2 *}
   TDARB0      = $1C		    ;  {* Transmit Adress Register A Byte 0 *}
   TDARB1      = $1D		    ;  {* Transmit Adress Register A Byte 1 *}
   TDARB2      = $1E		    ;  {* Transmit Adress Register A Byte 2 *}


CONST
  TNCCLOCK      = 10000000;  (* 10 Mhz Takt nur vorerst *)
  TIMER_CLOCK    = TNCCLOCK DIV 128;

CONST BLINK = 0;  {* Fr FD_DUMP *}
VAR  WindMin:     Word;
     WindMax:     Word;
     Con2 : Text;

(**********************************************************)
(* Interrupt beenden. Vorher sollte cli aufgerufen werden *)
(**********************************************************)
procedure fint; inline($0F/$92); (* Interrupt Ende *)

(*************************************************************)
(* Standby Flag Funktionen: Das Standby Flag des Prozessors  *)
(* wird beim Anlegen der Versorgungsspannung vom Prozessor   *)
(* auf FALSE gesetzt. Es kann jederzeit mit der Funktion     *)
(* get_standby abgefragt werden. Das Flag bleibt so lange    *)
(* im FALSE Zustand bis es mit der Prozedur set_standby min- *)
(* destens einmal gesetzt wird. Nach dem Setzen des Flags    *)
(* kann dieses nur durch Abschalten der Betriebsspannung     *)
(* rckgesetzt werden. Ein Reset hat keinen Einflu auf das  *)
(* Flag. Daher kann nach einem Reset jederzeit getestet      *)
(* werden, ob der Prozessor das erste Mal resettet wurde oder*)
(* bereits einmal sein Pascal-Programm abgearbeitet hat, wenn*)
(* der Benutzer in seinem Programm vorher das Flag gesetzt   *)
(* hat.                                                      *)
(* Besonders ntzlich ist das Flag in Verbindung mit der Stop*)
(* Prozedur.                                                 *)
(*************************************************************)
function get_standby:boolean; inline($B8/$00/$FF/$8E/$C0/$26/
                                     $A0/$E0/$0F/$25/$01/$00);
procedure set_standby;        inline($B8/$00/$FF/$8E/$C0/$26/
                                     $C6/$06/$E0/$0F/$01);


(******************************************)
(* Funktionen und Prozeduren der UNIT CRT *)
(******************************************)

TYPE t_OutCrt = (PRIM,SEK);

PROCEDURE SetCrtMoni ( x : t_outCrt );
PROCEDURE RevertMonitor;
PROCEDURE ShowMonitor ( x : T_outCRT);
PROCEDURE SetTextAttr ( x : Byte );
FUNCTION  GetTextAttr : Byte ;

PROCEDURE ClrScr;
PROCEDURE ClrEol;
PROCEDURE GotoXY(X, Y : Byte);
 FUNCTION WhereY: Byte;
 FUNCTION WhereX: Byte;
PROCEDURE Sound ( hz : Word );
PROCEDURE NoSound;
 FUNCTION ReadKey: Char;
 FUNCTION KeyPressed : BOOLEAN;

(******************************************)
(* Funktionen und Prozeduren der UNIT DOS *)
(******************************************)

PROCEDURE getintvec(intno:Byte;VAR vector:Pointer);
PROCEDURE setintvec(intno:Byte;vector:Pointer);
PROCEDURE intr(intno:Byte;VAR regs:registers);
PROCEDURE gettime(VAR Hour, Min, Second, Sec100:Word);
PROCEDURE settime(Hour, Min, Second, Sec100:Word);
PROCEDURE getdate(VAR Year, Month, Day, DayofWeek:Word);
PROCEDURE setdate(Year, Month, Day {**, DayofWeek ***} :Word);

(******************************)
(* TNC spezifische Funktionen *)
(******************************)

PROCEDURE WatchDog;
PROCEDURE _portena;
PROCEDURE _portdis;


{}


IMPLEMENTATION

USES fd_div;


{$F+}
PROCEDURE pm0_Write ( x : BYTE);
BEGIN
  pm0_mirror := x;
  pm0_reg := pm0_mirror;
END;
FUNCTION pm0_Read  : BYTE;
BEGIN
  pm0_READ := pm0_Mirror;
END;


PROCEDURE _portena; assembler;
asm
  lahf;
  or ah,2; {* IBRK auf 1 *}
  sahf;
  nop;   {* Recovery time! *}
END;

PROCEDURE _portdis;assembler;
{* verbietet den Zugriff auf alle CPU-IO-Ports. *}
{* Zugriffe erzeugen einen INT 19h              *}
ASM
  LAHF;
  AND  ah,0FDh;  {* IBRK auf 0 *}
  SAHF;
  nop;   {* Recovery time! test kw 1.6.97 *}
END;


PROCEDURE WatchDog;
 {* Watchdog triggern *}
 {* Achtung ! Diese Routine wird unter Umstnden aus den Niederungen von *}
 {* ISRs u.. unangenhmen Systemkram her aufgerufem. Also pse. Obacht !! *}
BEGIN
  {**  MemW[V25SEG:$0f80] := HWatch2_Tick; **}
  Inline($B8/$00/$FF/             (* mov ax,FF00h *)
         $8E/$C0/                 (* mov es,ax *)
         $9C/                     (* pushf *)
         $FA/                     (* cli *)
         $26/$80/$36/$10/$0F/$10/ (* xor byte ptr es:[f10],10h *)
         $26/$80/$36/$10/$0F/$10/ (* xor byte ptr es:[f10],10h *)
         $9D);                    (* popf *)
  SWD_Tick := SWD_Init;
END;


(*$L fd_tnc.obj*)

(*$F+*) PROCEDURE Intr (intno:Byte;VAR regs:registers); external;

PROCEDURE GetTime(VAR Hour, Min, Second, Sec100:Word);
  VAR regs:registers;
BEGIN (* gettime *)
  WITH regs DO
   BEGIN
     ah:=$2c;
     Intr($21,regs);
     Hour   := ch;
     Min    := cl;
     Second := dh;
     Sec100 := dl;
   END;
END;  (* gettime *)

PROCEDURE SetTime(Hour, Min, Second, Sec100:Word);
  VAR regs:registers;
BEGIN (* settime *)
  WITH regs DO
   BEGIN
     ah:=$2d;
     ch := Hour;
     cl := Min;
     dh := Second;
     dl := Sec100;
     Intr($21,regs);
   END;
END;  (* settime *)


PROCEDURE GetDate(VAR Year, Month, Day, DayofWeek:Word);
  VAR regs:registers;
BEGIN (* getdate *)
  WITH regs DO
   BEGIN
     ah:=$2a;
     Intr($21,regs);
     Year      := cx;
     Month     := dh;
     Day       := dl;
     DayofWeek := al;
   END;
END;  (* getdate *)


PROCEDURE SetDate(Year, Month, Day {**, DayofWeek ***} :Word);
  VAR regs:registers;
BEGIN (* setdate *)
  WITH regs DO
   BEGIN
   ah:=$2b;
   cx := Year;
   dh := Month;
   dl := Day;
   {***     al := DayofWeek; ****}
   Intr($21,regs);
   END;
END;  (* setdate *)


(*$F+*)PROCEDURE getintvec(intno:Byte;VAR vector:Pointer); external;
(*$F+*)PROCEDURE setintvec(intno:Byte;vector:Pointer); external;
(*$F+*)FUNCTION keypressed:BOOLEAN; external;
(*$F+*)FUNCTION readkey:Char; external;

{}


{* Die folgenden Sachen dienen lediglich dazu, Ausgaben versickern zu lassen *}
{* da es ein NUL:-Device auf dem FALCon nicht gibt. Alles aus dem            *}
{* Hilfesystem bertragen, da die Unit DOS ja nicht importiert werden darf *}

 CONST fmClosed = $D7B0;
       fmInput  = $D7B1;
       fmOutput = $D7B2;
       fmInOut  = $D7B3;

{* Textdateien *}
TYPE  TextBuf = array[0..127] of Char; {* Gre darf nicht gendert werden *}
                                       {* sonst CASTed TP nicht mehr....   *}
      TextRec = record
            Handle    : Word;
            Mode      : Word;
            BufSize   : Word;
            Private   : Word;
            BufPos    : Word;
            BufEnd    : Word;
            BufPtr    : ^TextBuf;
            OpenFunc  : Pointer;
            InOutFunc : Pointer;
            FlushFunc : Pointer;
            CloseFunc : Pointer;
            UserData  : array[1..16] of Byte;
            Name      : array[0..79] of Char;
            Buffer    : TextBuf;
          END;

CONST OutCrt : t_outCrt = PRIM;  {* Variable, wohin eine CRT ausgabe gehen soll *}
      erster : T_OUTCRT = PRIM;  {* Physikalische Umsetzung zu outCrt *}


{}
CONST SEKUNDAER = CRLF+' *** SEKUNDRER *** '+CRLF;
      PRIMAER   = CRLF+' *** PRIMRER *** '+CRLF;

PROCEDURE SetCrtMoni ( x : t_outCrt );
BEGIN
 IF x <> outCRT THEN
   IF outcrt = PRIM THEN outCrt := SEK
                    ELSE outCrt := PRIM;
END;


PROCEDURE RevertMonitor;
BEGIN
  IF erster=PRIM THEN BEGIN
                 Assign  (con2,'');   Rewrite (con2);
                 AssignNul (output); Rewrite (output);
                 erster := SEK;
                 WRITE (con2, SEKUNDAER);
                 END
            ELSE BEGIN
                 Assign (output,''); Rewrite (output);
                 AssignNul (con2);   Rewrite (con2);
                  WRITE ( PRIMAER );
                 erster := PRIM;
                 END;
END;

PROCEDURE ShowMonitor ( x : T_outCRT);
BEGIN
  IF x<>erster
    THEN RevertMonitor
    ELSE IF erster=SEK THEN WRITE (con2, SEKUNDAER )
                       ELSE WRITE ( PRIMAER );
END;


CONST TextAttr : BYTE = 255;

PROCEDURE SetTextAttr ( x : Byte );
  VAR vg, hg : BYTE;
BEGIN
 IF x=textAttr THEN Exit;  {* ein -Cache *}
 Watchdog;  {* whiiii! *}
 TextAttr := x;
 hg := (x SHR 4) AND 15;
 vg := (x AND 7);
 IF OutCRT = PRIM THEN Flush (output) {* wozu dat dann ? *}
                  ELSE Flush (con2);
 {* ANSI - Sequenz *}
 IF OutCRT = PRIM THEN Write (     #27,'[',(40+hg),';',(30+vg),'m')
                  ELSE Write (con2,#27,'[',(40+hg),';',(30+vg),'m');
END;


FUNCTION GetTextAttr : Byte ;
BEGIN
  GetTextAttr := TextAttr;
END;

PROCEDURE ClrScr;
BEGIN
 {* die passende ANSI - Sequenz einbauen *}
 {* Write (#27,'[2J');  *}
END;


PROCEDURE ClrEol;
BEGIN
 {* die passende ANSI - Sequenz einbauen *}
 {* Write (#27,'[K'); *}
END;


PROCEDURE GotoXY(X, Y : Byte);
BEGIN
 {* die passende ANSI - Sequenz einbauen *}
 {* Write (#27,'e[',f_str(x),';',f_str(y),'f'); *}
END;


FUNCTION WhereY: Byte;
BEGIN
  {* WIE SOLL MAN DAS ANSTNDIG IMPLEMENTIEREN ? *}
END;

FUNCTION WhereX: Byte;
BEGIN
  {* WIE SOLL MAN DAS ANSTNDIG IMPLEMENTIEREN ? *}
END;

PROCEDURE Sound(Hz: Word);
BEGIN
  Write (^G); {* Oh je ! *}
END;

PROCEDURE NoSound;
BEGIN
END;


{}

BEGIN
  StandByStartUp := Get_Standby;
  IF NOT StandByStartUp THEN fEiskaltstart := TRUE; {* garantiert Stromausfall *}
  Set_Standby;

  Assign (output,''); Rewrite (output);
  WatchDog;
  AssignNul (con2);   Rewrite (con2);
  erster := PRIM;
END. (* UNIT fd_tnc *)
