;*****************************************************
;* Unit Assemblercode fuer V50 Karte unter Turbo 4.0 *
;* Programmierer:Werner Cornelius  Version:1.0       *
;* Veraltet aber funktionsfhig                      *
;* Simulation der Dos und Crt Unit                   *
;*****************************************************

data       segment
           assume cs:data,ds:nothing

int_jmp    proc    far
i_jmp      label   byte
           db      3 dup(?)             ;Code Int nn retf
int_jmp    endp

data       ends

           public  getintvec,setintvec,intr
           public  keypressed,readkey

code       segment
           assume cs:code,ds:data

intr       proc    far
           push    bp                   ;Basiszeiger retten
           push    ds                   ;Datensegment retten
           mov     bp,sp                ;Zeiger auf Parameter
           mov     ah,[bp+0ch]          ;Interuptnummer holen
           mov     al,0cdh              ;Opcode Int
           mov     word ptr [i_jmp],ax  ;Int nn Ablegen
           mov     byte ptr [i_jmp+2],0cbh ;retf Instruction
           lds     si,[bp+8]            ;Adresse Register
           cld                          ;Richtung positiv
           lodsw                        ;Wert holen
           push    ax                   ;auf Stack (ax)
           lodsw                        ;Wert holen
           mov     bx,ax                ;(bx)
           lodsw                        ;Wert holen
           mov     cx,ax                ;(cx)
           lodsw                        ;Wert holen
           mov     dx,ax                ;(dx)
           lodsw                        ;Wert holen
           mov     bp,ax                ;(bp)
           lodsw                        ;Wert holen
           push    ax                   ;auf Stack (Si)
           lodsw                        ;Wert holen
           mov     di,ax                ;(di)
           lodsw                        ;Wert holen
           push    ax                   ;(ds)
           lodsw                        ;Wert holen
           mov     es,ax                ;(es)
           pop     ds                   ;ds setzen
           pop     si                   ;si setzen
           pop     ax                   ;ax setzen
           call    int_jmp              ;Ansprung Int
           pushf                        ;Flags retten
           push    es                   ;es retten
           push    di                   ;di retten
           push    bp                   ;bp retten
           mov     bp,sp                ;bp = Stack
           les     di,[bp+10h]          ;Zeiger auf Parameter
           cld                          ;Richtung
           stosw                        ;ax ablegen
           mov     ax,bx                ;bx
           stosw                        ;ablegen
           mov     ax,cx                ;cx
           stosw                        ;ablegen
           mov     ax,dx                ;dx
           stosw                        ;ablegen
           pop     ax                   ;bp
           stosw                        ;ablegen
           mov     ax,si                ;si
           stosw                        ;ablegen
           pop     ax                   ;di
           stosw                        ;ablegen
           mov     ax,ds                ;ds
           stosw                        ;ablegen
           pop     ax                   ;es
           stosw                        ;ablegen
           pop     ax                   ;flags
           stosw                        ;ablegen
           pop     ds                   ;Datensegment zurueck
           pop     bp                   ;Zeiger zurueck
           ret     6                    ;Parameter weg
intr       endp

keypressed proc    far
           push    bp                   ;Basiszeiger retten
           mov     bp,sp                ;Zeiger auf Parameter
           mov     ah,1                 ;get Status
           int     16h                  ;Tastaturaufruf
           mov     ax,00                ;Default keine Taste
           jz      key_ex               ;setzen
           mov     ax,0ffffh            ;Taste gedrueckt
key_ex:    pop     bp                   ;Zeiger zurueck
           or      ax,ax                ;Flags setzen
           ret
keypressed endp

readkey    proc    far
           push    bp                   ;Basiszeiger retten
           mov     bp,sp                ;Zeiger auf Parameter
           mov     ah,0                 ;read char
           int     16h                  ;Tastatur
           mov     ah,0                 ;High Byte = 0
           pop     bp                   ;Zeiger zurueck
           ret
readkey    endp

           push    bp                   ;Basiszeiger retten
           mov     bp,sp                ;Zeiger auf Parameter

           pop     bp                   ;Zeiger zurueck

getintvec  proc    far
           push    bp                   ;Basiszeiger retten
           mov     bp,sp                ;Zeiger auf Parameter
           mov     al,[bp+10]           ;Interuptnummer
           mov     ah,35h               ;Get Int Vec
           int     21h                  ;Dos Aufruf
           mov     dx,es                ;Segment nach dx
           les     si,[bp+6]            ;Zeiger laden
           mov     es:[si],bx           ;Offset ablegen
           mov     es:[si+2],dx         ;Segment ablegen
           pop     bp                   ;Zeiger zurueck
           ret     6                    ;Parameter weg
getintvec  endp

setintvec  proc    far
           push    bp                   ;Basiszeiger retten
           mov     bp,sp                ;Zeiger auf Parameter
           mov     al,[bp+10]           ;Interuptnummer
           mov     ah,25h               ;Set Int Vec
           push    ds                   ;Datensegment retten
           lds     dx,[bp+6]            ;Zeiger holen
           int     21h                  ;Dos Aufruf
           pop     ds                   ;Datensegment zurueck
           pop     bp                   ;Zeiger zurueck
           ret     6                    ;Parameter weg
setintvec  endp

code       ends
           end

