UNIT FD_Timer;

{$IFDEF VER70} {$C FIXED PERMANENT PRELOAD} {$ENDIF}
{$I FD_incl.pas}

INTERFACE

USES FD_Def;

  PROCEDURE InitTimer      ( VAR t : T_Timer; InitWert : LONGINT );
  PROCEDURE DelTimer       ( VAR t : T_Timer );
  PROCEDURE StartTimer     ( VAR t : T_Timer );
  PROCEDURE StartTimerFast ( VAR t : T_Timer );
  PROCEDURE StopTimer      ( VAR t : T_Timer );
  FUNCTION  TimerGetRemain ( VAR t : T_Timer ) : LongInt;
  PROCEDURE TimerCountDown (delta : LONGINT );
  PROCEDURE CallTimerRoutine;
  PROCEDURE AppendTimerAtStr( t : t_TIMER; VAR s : STRING );
  PROCEDURE AppendTimer2Str ( {$IFDEF VER70} Const {$ENDIF} t : t_timer; VAR s : String );


  CONST ftFast   : BOOLEAN = FALSE; {* wird alle    10 ms gesetzt *}
        ftSek    : BOOLEAN = FALSE; {* wird alle  1000 ms gesetzt *}
        ftSek8   : BOOLEAN = FALSE; {* wird alle  8000 ms gesetzt *}
        ftMinute : BOOLEAN = FALSE; {* wird alle 60000 ms gesetzt *}
        tcMinute : WORD = 0;        {* Global definiert, damit sie in *}
                                    {* main.doEveryMinute auf die Systemzeit sync. wird.*}
                                    {* von DL7GAI 4/92 *}

{}
IMPLEMENTATION


 USES {$IFDEF SCC} FD_SCC,  {* wg. rxtx_timer *}
                   FD_TNC,
      {$ELSE}      DOS, FD_CRT,
      {$ENDIF}
      {$IFDEF display}       CC_disp,    {$ENDIF}
      FD_DIV,     {* wg. _DI *}
      fd_Error,
      FD_Main     {* wg. WorkRx *}
{$IFDEF DCF}
      ,FD_DCF
{$ENDIF}
      ;


  CONST
     {$IFDEF SCC}
       ms = _clkTick;
       raster = (  TNCCLOCK div (128 * 1000)) * ms; (* Zhleranzahl *)
     {$ELSE}
       n_pro_s = 1000 Div _clktick;
       raster = TIMER_CLOCK DIV n_pro_s;
     {$ENDIF}

  CONST TimerRootSlow    : tP_timer = NiL;
        TimerRootFast    : tP_timer = NiL;
	TimerRootExpired : TP_TIMER = NiL; {* hier werden alle Timer eingehngt, die abgelaufen sind *}
	TimerTailExpired : TP_TIMER = NiL; {* ... Ende Zeiger dazu *}

  CONST tc     : WORD = 0;
        tcHalf : WORD = 0; {* Hilfszhler in der Timer-ISR *}
        tcSek  : WORD = 0; {* Hilfszhler in der Timer-ISR *}
        tcSek8 : WORD = 0; {* Hilfszhler in der Timer-ISR *}
        ftHalf : BOOLEAN = FALSE;


{}

PROCEDURE AppendTimerAtStr( t : t_TIMER; VAR s : STRING );
  VAR c,c2 : CHAR;
      st : STRING;
BEGIN
  CASE t.state OF
    running : c := 'r';
    Stopped : c := 's';
    expired : c := 'e';
    END;
  IF t.pbEnabled^ THEN c2 := '='
                  ELSE c2 := '-';
  IF t.state <> STOPPED THEN st := fStr(t.TicksRemaining)
                        ELSE st := '';
  AddString(s,c + c2 + st);
END;

PROCEDURE AppendTimer2Str ( {$IFDEF VER70} Const {$ENDIF} t : t_timer; VAR s : String );
  VAR c : CHAR;
BEGIN
  IF t.next = Nil
    THEN IF t.prev=NIL THEN c := ' '  {nil,nil}
                       ELSE c := '_'  { x ,nil}
    ELSE IF t.prev=NIL THEN c := '''' {nil, x }
                       ELSE c := ''; { x , x }
  AddChar(s,c);
  AppendTimerAtStr( t, s );
  IF t.state <> stopped THEN
    BEGIN
{$IFDEF scc}
    IF      t.pbEnabled = @scciface[1].ch_free THEN s:= s+'c1'
    ELSE IF t.pbEnabled = @scciface[2].ch_free THEN s:= s+'c2'
    ELSE IF t.pbEnabled = @scciface[3].ch_free THEN s:= s+'c3'
    ELSE IF t.pbEnabled = @scciface[4].ch_free THEN s:= s+'c4'
    ELSE IF t.pbEnabled = pf_FOREVER_TRUE   THEN s:= s+'ft'
    ELSE IF t.pbEnabled = pf_FOREVER_FALSE  THEN s:= s+'ff'
    ELSE s:= s+'??' ;
{$ENDIF}
    END;
END;



PROCEDURE DefaultTimerProc (p : Pointer); far;
BEGIN
  Inc(count[cntNoTimerProc]);
END;

PROCEDURE CheckTimer (VAR t : T_Timer);
BEGIN
  {$IFDEF debug}
  IF t.next <> Nil THEN IF t.prev = t.next THEN
    BEGIN
    Inc(count[cntTimLoop]);
    StoreStack('T','@ '+HexAddrString(@t)+' '+HexAddrString(t.next) );
    END;
  {$ENDIF}
END;

PROCEDURE InitTimer ( VAR t : T_Timer; InitWert : LONGINT );
  {* Timer darf nicht laufen ! *}
BEGIN
  t.Next := NiL;
  t.Prev := NiL;
  t.state := STOPPED;
  t.TickInit := InitWert;
  t.TicksRemaining := InitWert;
  _DI;
  t.pbEnabled := pf_FOREVER_TRUE;
  _EI;
  t.usefast := TRUE;
  t.timerFunction := DefaultTimerProc;
  t.Arg := NiL;
END;


PROCEDURE UnLinkExpired ( VAR t : T_Timer );
  {* t aus der Liste der ausgelaufenen Timer aushngen *}
BEGIN
  IF @t = NiL THEN BEGIN
                   StoreStack('E','x');
                   Exit;
                   END;
  CheckTimer (t);
{*  _DI;  *}
  {* Allgemein: Aushngen *}
  IF t.prev <> Nil THEN t.prev^.next := t.next;
  IF t.next <> Nil THEN t.next^.prev := t.prev;
  {* Sonderflle: erstes/Letztes Element der Kette *}
  IF TimerRootExpired = @t THEN TimerRootExpired := t.next;
  IF TimerTailExpired = @t THEN TimerTailExpired := t.prev;
  t.State := STOPPED;
  t.next := NIL;
  t.prev := NIL;
{*  _EI; *}
END;

{}

PROCEDURE StartTimer ( VAR t : T_Timer );
BEGIN
  CheckTimer (t);
  IF t.state = EXPIRED THEN BEGIN
                            UnLinkExpired (t); {* Mu erst ausgehngt werden *}
                            END;
  IF t.state = RUNNING
    THEN BEGIN {* nur Restzeit neu setzen *}
         IF t.usefast THEN t.TicksRemaining := t.Tickinit
                      ELSE t.TicksRemaining := t.Tickinit DIV 50;
         END
    ELSE IF (t.state = STOPPED) THEN
           BEGIN
           t.prev := Nil; {* Timer wird ganz vorne eingehngt *}
           IF t.tickinit < 250 {* Schwelle fast/slow ... sollte >> 50 sein *}
             THEN BEGIN
                  t.next := TimerRootFast;
                  IF timerRootFast <> Nil THEN timerrootFast^.prev := @t;
                  timerrootFast := @t;
                  t.TicksRemaining := t.Tickinit;
                  t.usefast := TRUE;
                  END
             ELSE BEGIN
                  t.next := TimerRootSlow;
                  IF timerRootSlow <> Nil THEN timerrootSlow^.prev := @t;
                  timerrootSlow := @t;
                  t.TicksRemaining := t.Tickinit DIV 50;
                  t.usefast := FALSE;
                  END;
           END;
  t.state := RUNNING;
END;


PROCEDURE StartTimerFast ( VAR t : T_Timer );
  {* "t" landet immer in der FastQueue *}
BEGIN
  CheckTimer (t);
  IF t.state = EXPIRED THEN
    BEGIN
    UnLinkExpired (t);
    {* T ist jetzt STOPPED *}
    END;
  IF (t.state = running) THEN
    BEGIN
    t.TicksRemaining := t.Tickinit;
    END
  ELSE IF (t.state = STOPPED) THEN
    BEGIN
    t.prev := Nil;
    t.next := TimerRootFast;
    IF timerRootFast <> Nil THEN timerrootFast^.prev := @t;
    timerrootFast := @t;
    t.TicksRemaining := t.Tickinit;
    t.usefast := TRUE;
    END;
  t.state := RUNNING;
END;


PROCEDURE StopTimer ( VAR t : T_Timer );
  {* Timer anhalten und aushngen *}
BEGIN
  CheckTimer (t);
  IF t.state = EXPIRED THEN BEGIN
                            UnlinkExpired (t);
                            END;
  IF t.state <> STOPPED THEN
    BEGIN {* Wenn er noch nicht steht *}
    IF t.prev <> Nil THEN t.prev^.next := t.next;
    IF t.next <> Nil THEN t.next^.prev := t.prev;
    IF t.usefast
       THEN BEGIN
            IF TimerRootFast = @t THEN TimerRootFast := t.next;
            END
       ELSE BEGIN
            IF TimerRootSlow = @t THEN TimerRootSlow := t.next;
            END;
    t.state := STOPPED;
    t.next := NIL;
    t.prev := NIL;
    END;
END;


PROCEDURE DelTimer ( VAR t : T_Timer );
  {* Timer anhalten, aushngen und ungltig machen *}
BEGIN
  CheckTimer (t);
  StopTimer(t);
  t.state := STOPPED;
  t.Next := NiL;
  t.Prev := NiL;
  t.TickInit := 99999999;
  t.TicksRemaining := 0;
  t.pbEnabled := NiL;
  t.usefast := FALSE;
  t.timerFunction := DefaultTimerProc;
  t.Arg := NiL;
END;


FUNCTION TimerGetRemain ( VAR t : T_Timer ) : LongInt;
  {* Zurckgabe des Wertes in s *}
BEGIN
  TimerGetRemain := 0;
  IF t.state = running THEN
    IF t.usefast THEN TimerGetRemain := t.ticksremaining DIV 100
                 ELSE TimerGetRemain := t.ticksremaining DIV 2;
END;

{ ISR }


CONST SaveInt08 : Pointer = NIL;
VAR   Exit_Ticker_Save : Pointer;


PROCEDURE CallTimerRoutine;
  {* Abarbeiten aller zwischenzeitlich abgelaufenen Timer. Diese Routine  *}
  {* wird synchron (u.a. aus der Hauptschleife) aufgerufen, dadurch spart *}
  {* man sich den ganze Hintergrundmist (MEM un so).                      *}
  VAR tAkt,
      tNext  : tp_Timer;
      pStart : tp_mBuf;
      n      : WORD;
      p      : POINTER;
BEGIN
  n := 0;
  _DI;   {* Kette der ausgelaufenen Timer mal eben schnell umhngen *}
  tAkt := TimerRootExpired;
  TimerRootExpired := Nil;
  TimerTailExpired := NiL;
  _EI;
  WatchDog;
  WHILE tAkt <> Nil DO
    BEGIN
    {* Zwischenspeichern, da der abgelaufene Timer ja durch TIMERFUNCTION *}
    {* vielleicht neu gestartet wird (z.B. FrAck). Dadurch wrde der      *}
    {* NEXT-Zeiger verschtt gehen wrde.                                 *}
    tNext := tAkt^.next;
    Inc (n);
    IF tAkt^.state = EXPIRED
      THEN BEGIN
	   {* Zunchst Status ndern, sonst gibts ne endlose Rekursion, *}
	   {* falls der gerade abgelaufende Timer wieder gestartet wird *}
	   tAkt^.state := STOPPED;
	   {* Timer muss nicht ausgehngt werden, da diese Kette eh temporr *}
	   {* ist und der Next-zwischengespeichert wird. Timer-Funktion aufrufen ... *}
	   {* Zusatztest: Zeigt er auf push bp oder ENTER ? *}
	   p := @tAkt^.TimerFunction;
	   IF (p = NiL) OR ( (byte(p^)<>$55) AND (byte(p^)<>$c8) AND (byte(p^)<>$cD) )
	     THEN BEGIN
		  Inc(Count[cntNilFN]);
		  Backup.pNilFN := p;
		  END
	     ELSE BEGIN
                  tAkt^.TimerFunction (tAkt^.Arg);
                  END;
	   END;
    tAkt := tNext;
    END; {* While *}
END;


PROCEDURE DoTimer ( VAR timerRoot : tp_timer; delta : LONGINT );
 {- Zhlt alle aktiven Timer runter, sofern jeweiliges Freigabeflag gesetzt. -}
 {- Abgelaufene Timer werden in die Kette Expired umgehngt.-}
  VAR t,tp: tp_Timer;
BEGIN
  WatchDog;
  t := TimerRoot;
  WHILE t <> Nil DO
    BEGIN {* Durchsuche die gesamte Liste *}
    tp := t^.next; {* Zwischenspeichern *}
    IF t^.state = RUNNING THEN
      BEGIN
      _DI;  {* pbEnabled wird in den Treiberroutinen umgelegt *}
      IF t^.pbEnabled^ THEN {* FreigabeFlag fr DCD abhngiges FRACK etc. *}
	BEGIN {* Tickzahl ernidrigen *}
	_EI; {* und zurck *}
	Dec (t^.TicksRemaining, delta);
	IF t^.TicksRemaining < 1 THEN
	   BEGIN {* Timer ist ausgelaufen -> der Timer wird in *}
		 {* die Liste abgelaufener Timer eingereiht    *}
	   StopTimer (t^); {* setzt auch STATE auf STOPPED und hngt aus *}
	   t^.state := EXPIRED;
	   {* Timer ist abgelaufen --> An Expired-Kette hinten anhngen *}
	   t^.next := NiL;
           t^.prev := TimerTailExpired;  {... mh sieht falsch aus! ... }
           IF TimerRootExpired = NiL THEN TimerRootExpired := t
                                     ELSE TimerTailExpired^.next := t;
           TimerTailExpired := t;
	   END;
        _DI;  {* Trick, wg. DI_ VOR der Abfrage *}
        END;
      _EI;
      END;
    t := tp;
    END; {* while *}
  WatchDog;
END;


PROCEDURE TimerCountDown (delta : LONGINT );
BEGIN
  IF ftHalf THEN
    BEGIN {* alle 0,5 Sek. *}
    ftHalf := FALSE;
    DoTimer (timerRootSlow, 1);
    END;
  DoTimer(timerRootFast,delta);
END;

{}


PROCEDURE WatchDogBite; far; {* Zubeissen bitte ! Wird direkt aus ner ISR aufgerufen *}
  VAR i :  Byte;
BEGIN
{* Hier kein HW-Watchdog-Triggern! *}
 {$IFDEF scc}
 StoreStack('W','');
 {$ENDIF}
          {$IFDEF blahhhhhh}   sfjlsjf
           FOR i := MAXRESET-1 DOWNTO 1 DO
             BEGIN
             backup.caller[i+1] := backup.caller[i];
             backup.grund[i+1] := backup.grund[i];
             backup.sData[i+1]  := backup.sData[i];
             END;
           backup.grund[1] := 'W';
           backup.sData[1] := '';
           FillChar ( backup.caller[1], sizeof(backup.caller[1]), #0 ) ;
           ASM
             PUSH BP
             MOV  SI,offset backup.caller
             MOV  CX,nCaller
             MOV  AX, fdcs
          @@1:
             MOV  BP, [BP+00] {* BP des Aufrufers der FnWatchDog, also der ISR, laden *}
             LES  DI, [BP+02] {* Ret Adresse der ISR *}
             MOV  WORD PTR [SI+2], ES
             MOV  WORD PTR [SI+0], DI
             SUB  WORD PTR [SI+2], AX
             ADD  si,4
             DEC  CX
             JNZ  @@1
             POP  BP
             END;
          {$ENDIF}
  SWD_Tick := SWD_Init; {*  Auf jeden Fall die SWD triggern *}
  Inc (backup.nSoftWatchDogBite);
END;


{$F+} PROCEDURE neu_int_08(Flags, CS, IP, AX, BX,
                           CX, DX, SI, DI, DS, ES, BP: Word);  INTERRUPT;
BEGIN
  Backup.LastISR := 21;
  {$IFDEF SCC}
    SCC_Timer; {* Level 1 Timer Routine anstossen *}
    ASM	CLI; NOP; END;
    fInt; {* Interupt beenden *}
    ASM NOP; STI; END;
  {$ENDIF}
  Inc (FastTick); {* Das ist die Hauptsache *}
  ftFast := TRUE;
  Inc (tcHalf);
  IF tcHalf >= (_clkSlowTick DIV _clkTick) THEN
    BEGIN {* Alle 0,5 sek. *}
    Inc (SlowTick);
    tcHalf := 0;
    ftHalf := TRUE;
    Inc (tcSek);
    IF tcSek > 1 THEN
      BEGIN {* jede Sekunde *}
      tcSek := 0;
      ftSek := TRUE;
{ $ IFDEF dcf}  {* eigentlich nicht spezifisch DCF, aber noch ungetestet *}
      {* Mitlaufende Sekunden *}
      Inc (SysTime.sec);
      if systime.sec>=60 then
        begin
        systime.sec:=0;
        inc(systime.min);
        if systime.min>=60 then
          begin
          systime.min:=0;
          inc(systime.hour);
          if systime.hour=24 then systime.hour:=0;
          end;
        end;
{ $ENDIF}
      Inc (tcSek8);
      IF tcSek8 >= 8 THEN
        BEGIN {* jede 8. Sekunde *}
        tcSek8 := 0;
        ftSek8 := TRUE;
        END;
      Inc (tcMinute);
      IF tcMinute >= 60 THEN
        BEGIN {* jede Minute *}
        tcMinute := 0;
        ftMinute := TRUE;
        END;
       END;
    END;

{$IFDEF DCF}
    IF do_dcf THEN dcf_pulse_dedection;
    IF dcf_ok THEN dcf_compute_time; {* Impulse sind alle da, dann rechnen wir *}
    IF (dcf_set AND dcf_puls) THEN set_dcf_time; {* Alles richtig ausgewertet -> Uhr stellen *}
{$ENDIF}

  Backup.LastISR := 33;

{$IFnDEF SCC}
  IF tc < raster
    THEN BEGIN  {* Alle 54,9 ms *}
	 ASM  {* Aufm PC: Original ClkTick aufrufen *}
          PUSHF
          CLI {* Davon knnte die Original - Routine ja ausgehen *}
	 END;
	 (* CALL FAR [fd_timer.SaveInt08] *)
         INLINE  ( $FF/$1e/SAVEInt08);
	 {* Interrupt-Controler ist schon durch die Original-int08-Routine zurckgesetzt_worden *}
	 END
    ELSE port [IRQ_FINISH_ADR] :=  $60 OR (0 AND 7);  {* EOI *}
{$ENDIF}

  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  ASM STI END; {* _EI und _DI sind ja Macros *}
  Dec (tc,raster);   {* tc zhlt die 8253-Ticks mit, um die Uhr zu korrig. *}

  Dec (SWD_Tick); {* Software Watchdog *}
  IF (SWD_Tick < 0) THEN WatchDogBite;
  Backup.LastISR := 34;

  {$IFDEF DISPLAY}
    IF disp_timer <> 0 THEN Dec(disp_timer);
  {$ENDIF}
END;
  {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}


{$IFDEF scc}
  CONST TickCount =  1400 * (TNCCLOCK DIV (128*1000));
                   {*^^^^ zeit in ms 2. Watchdog *}
{$F+} PROCEDURE int28hdl(Flags, CS, IP, AX, BX,
                        CX, DX, SI, DI, DS, ES, BP: Word);  INTERRUPT;
BEGIN
  Backup.LastISR := 70;
  ASM CLI; END;
  fInt; {* Interupt beenden *}
  ASM STI; END;
  MemW[V25SEG:$0f80] := HWatch2_Tick; {* kein Watchdog() - das wrde die MAX691-Watchdog neutralisieren ! *}
{  Inc(count_HW2); }
  StoreStack('w','');
  Backup.LastISR := 71;
END;
{$ENDIF}


{ Exit }

{$IFnDEF SCC}
{$F+} PROCEDURE Exit_Ticker; {$IFNDEF AllFar} {$F-} {$ENDIF}
BEGIN
  ExitProc := Exit_Ticker_Save;
  _DI;
  Port [TIMER_0] := 0;  {* WICHTIG ! Sonst wird man zu schnell alt :) *}
  Port [TIMER_0] := 0;
  SetIntVec( 8, SaveInt08);
  _EI;
END;
{$ENDIF}



BEGIN
{$IFDEF SCC}
  WriteLn ('- Timer-Init');

 {$IFDEF HardWareWatchdog}
   {* Jetzt 2.Watchdog auf Timer 0 init. *}
   SetIntVec ( 28, @int28hdl );
   _DI; mausefalle
   Mem [V25SEG:$0f90] := $80 + $40 {+ $01}; {* Timer 0, One Shot-Mode, kein MD0-Countdown CLK/128 *}
   MemW[V25SEG:$0f82] := word(TickCount); {* TM0 *}
   _EI;
   HWatch2_Tick := Word(TickCount);
 {$ENDIF}

  {* So, nu das Zeug fr Timer 1 des V25+, dem Herzschlag von DigiWare machen *}
  SetIntVec ( 29, @neu_int_08);
  _DI;
  mem [V25SEG:$0f91] := $80 + $40; {* TMC1 TimerControllRegister 1, CLK/128, Countdown-Mode *}
  memW[V25SEG:$0f8a]:= word(raster); {* MD1 Modulo/Timer Register  *}
  {* Interruptfreigabe usw. ist in FD_MAIN.Main - es muss ja ALLES erst init. sein *}
  _EI;

{$ELSE   also NOT SCC}

  GetIntVec( 8, SaveInt08);
  SetIntVec( 8, @neu_int_08);
  _DI;
  Port [Timer_0] := lo (raster);
  Port [Timer_0] := hi (raster);
  _EI;
  Exit_Ticker_Save := ExitProc;
  ExitProc := @Exit_Ticker;

{$ENDIF}
END.
