{$I FD_INCL.PAS}
UNIT FD_Text;   {* Textbehandlung: DIR REN ERASE etc. *}

INTERFACE

USES FD_Def;

CONST rtDEFAULT = TRUE;
      rtNODEFAULT = FALSE;

 FUNCTION FindText ( welcher : T_TxtName ) : INTEGER;
PROCEDURE CopyText ( sText : T_TxtName; pOrgText : Pointer; txtsize : WORD);
 FUNCTION ReadTxt (pCB : TP_AXCB; welcher : T_TxtName; default : BOOLEAN )  : BOOLEAN ;
 FUNCTION DelTxt (welcher : T_TxtName )	: BOOLEAN ;
 FUNCTION RenTxt (pCB : TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} von,nach : T_TxtName ) : BOOLEAN ;



{}

IMPLEMENTATION


 USES FD_Tx,
      FD_Div,
      FD_Subr,
      FD_mBuf,
      FD_Mem;


{}


FUNCTION FindText ( welcher : T_TxtName ) : INTEGER;
  {* Suche den Text in WELCHER.
   * Rckgabewert:
   * > 0 : "Welcher" gefunden. Wert ist der Index fr apTxt
   * = 0 : Nicht gefunden. Und auch kein freier Platz mehr fr einen neuen Text.
   * < 0 : Nicht gefunden. Freier Platz auf apText[wert*-1]
   *}
  VAR i,freier : INTEGER;
      found : BOOLEAN;
BEGIN
  findText := 0;
  IF welcher = '' THEN Exit;
  welcher := f_Upper (Copy (welcher,1,MAXTXTNAMELEN));
  i := 0; found := FALSE; freier := 0;
  WHILE (i<MAXTXT) AND NOT found DO
    BEGIN
    Inc (i);
    IF apText[i] = NiL
      THEN freier := i
      ELSE IF apText[i]^.name = welcher THEN found := TRUE;
    END;
  IF found THEN findText := i
           ELSE findText := -freier;
END;


PROCEDURE CopyText ( sText : T_TxtName; pOrgText : Pointer; txtsize : WORD);
  {* Kopiert einen Speicherblock als Text "STEXT" *}
  VAR i : INTEGER;
      j : WORD;
      p : Pointer;
BEGIN
  i := FindText ( sText ); {* Platz suchen *}
  IF i<0 THEN {* ok, noch platz da & Text existiert noch nicht *}
    BEGIN
    i := -i;
    MemGet ( pointer(apText[i]), sizeof(apText[i]^) );
    WITH apText[i]^ DO
      BEGIN
      Name := sText;
      sTitel := '';
      size := txtSize;
      readCount := 0;
      cdir := false;
      writeTime := systime;
      pMem := nil;
      pmText := Get_MBuf(txtSize);
      pmText^.inUse := txtSize;
      Move( pOrgText^, pmText^.pData^, txtSize);
      p := pmText^.pData;
      FOR j := 1 TO txtsize DO
        BEGIN  {* CRLF --> ^@ CR umwandeln *}
        IF char (p^) = LF
          THEN char (p^) := CR
          ELSE IF char (p^) = CR THEN char (p^) := ' ';
        Inc (Word(p));
        END;
      END;
    END;
END;



FUNCTION ReadTxt (pCB : TP_AXCB; welcher : T_TxtName; default : BOOLEAN )  : BOOLEAN ;
{* Gebe Text pa[Welcher] aus. Wenn nicht vorhanden,
 * so gebe, falls DEFAULT = TRUE, einen Standardtext aus
 *}
  VAR i : Integer;
BEGIN
  ReadTxt := FALSE;
  i := FindText ( welcher );
  IF i > 0
    THEN WITH apText[i]^ DO BEGIN
	 {* Vorlufig entfernt... TX_Info  (pCB, SPAETER, EOL ); *}
         IF (MemAvail<40000) AND (size>2000)
           THEN TX_EolSysInfo (pCB, SPAETER, 'Text kann zur Zeit nicht ausgegeben werden!')
	   ELSE BEGIN
                IF pmText = nil
                  THEN Tx_MemBlock      (pCB, SOFORT, pMem, size) {* Aus dem CfgFile(EPROM) nehmen *}
                  ELSE TXCopy_mbufChain (pCB, SOFORT, pmText); {* aus RAM (Remote-Write) *}
		ReadTxt := TRUE;
   	        Inc ( ReadCount );
		END;
	 END
    ELSE BEGIN {* Text nicht gefunden *}
	 IF default THEN TX_EolSysInfo (pCB, SOFORT, csNOTEXT);
	 END;
END;


FUNCTION DelTxt (welcher : T_TxtName )	: BOOLEAN ;
  VAR i : INTEGER;
BEGIN
  DelTxt := FALSE;
  i := FindText ( welcher );
  IF i > 0
    THEN IF apText[i]^.pMem = nil THEN
           BEGIN
	   Del_mBuf_chain (apText[i]^.pmText); {* eigentlichen Text lschen *}
	   MemFree ( pointer(apText[i]), Sizeof(apText[i]^) );
	   apText[i] := NiL;
	   DelTxt := TRUE;
	   END;
END;


FUNCTION RenTxt (pCB : TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} von,nach : T_TxtName ) : BOOLEAN ;
  VAR iVon : INTEGER;
      sNach : STRING;
BEGIN
  RenTxt := FALSE;
  IF (nach='') THEN Exit; {* Kontrolle fr "von" ist in FINDTEXT *}
  sNach := nach;
  Upper(sNach);
  ivon := FindText ( von );
  IF ivon <= 0
    THEN TX_EolSysInfo (pCB,SPAETER, von+' not found')
    ELSE BEGIN
	 IF FindText(snach) > 0
	   THEN TX_EolSysInfo (pCB,SPAETER, snach+' already exist')
	   ELSE BEGIN
		apText[iVon]^.name := snach;
		RenTxt := TRUE;
		END;
	 END;
END;

{}

{$IFNDEF SCC}
{$IFDEF wenn wir es mal wieder brauchen *}
PROCEDURE LoadText_disk ( VAR txt : t_text; filename : string);
  VAR f : File;
      p : Pointer;
      i : WORD;
      li : LongInt;
      T : DateTime;
BEGIN
  txt.pmText := Nil;
{$I-}  Assign (f, filename);  Reset (f,1);
  GetFTime (f,li);  UnpackTime(li,t);
  txt.size := FileSize (f);
  IF IOResult <> 0 THEN Exit;
  txt.pmText := Get_mBuf ( txt.size );
  BlockRead (f, txt.pmText^.pData^, txt.size );
  p := txt.pmText^.pData;
  FOR i := 1 TO txt.size DO
    BEGIN  {* CRLF --> ^@ CR umwandeln *}
    IF char (p^) = LF THEN char (p^) := CR
      ELSE IF char (p^) = CR THEN char (p^) := ' ';
    Inc (word(p));
    END;
  Close (f);
END;
{$ENDIF}
{$ENDIF}

{}

BEGIN
  FillChar ( apText, SizeOf(apText), #0 );
END.




