{$I FD_INCL.PAS}
{$DEFINE lokDebug}
UNIT FD_TERM;


INTERFACE

USES FD_Def;


{}

IMPLEMENTATION

USES FD_Div,
     FD_Subr,
     FD_Sysop,
     {$IFDEF SCC} fd_TNC,
     {$ELSE}	  fd_crt, DOS,
     {$ENDIF}
     FD_Error;

CONST csMyName = 'TERM';

TYPE  t_Term = RECORD
          fValid : BOOLEAN;
          mode   : (cTERM,cTRANSPARENT);
          BindNr : WORD;
          sBind,
          sKommandoZeile : STRING;
          ProcRx1Char : TFN_RX1CHAR;
          ProcNRxCHAR : TFN_NRXCHAR;
          ProcTx1Char : TFN_TX1CHAR;
          ProcNTXChar : TFN_NTXChar;

          sIPCFG1: STRING;
          sIPCFG2: STRING;
      END;

CONST MAXTerm = 1;
VAR  term : ARRAY [1..MAXTerm] OF t_term;


PROCEDURE Send(s:String);
  VAR i : WORD;
BEGIN
  {$IFDEF v24Life} WriteLn('-- send: ',s);{$ENDIF}
  WITH TERM [1] DO FOR i := 1 TO length(s) DO  ProcTx1Char(s[i]);
END;


PROCEDURE Termline (sArg:STRING);
 {* Kommando was ber die Trasportschicht (v24) kam, ausfhren *}
  VAR sTmp : STRING;
BEGIN
  {$IFDEF v24Life} WriteLn('-- TermLine: ',sArg);{$ENDIF}
  IF sArg='AT' THEN BEGIN Send('OK'+EOL); Exit; END;
  IF Copy(sArg,1,4)='ATDP' THEN
    BEGIN
    { QSO nach copy 5,255) aufbauen, dann: }
    Send('CONNECTED'+CR+LF);
    {* so, nun auf "Transparent"umschalten; alles was auf der v24 reinkommt,
     * wieder 1:1 rauspusten (in diesem QSO) }
    term[1].mode := cTRANSPARENT;
    Exit;
    END;
  IF Copy(sArg,1,3)='ATD' THEN   {* SLIP simmulieren *}
    BEGIN
    Send('CONNECTED'+CR+LF);
    { so, nun an IP binden }
    IF ExecDriver(term[1].sIPCFG1)THEN;;;
    IF ExecDriver(term[1].sIPCFG2)THEN;;;
    term[1].fValid := false;
    Exit;
    END;
  IF copy(sArg,1,5)='JHOST' THEN
    BEGIN
    { so, nun an Hostmode binden }
    sTmp := 'p host 1 bind '+term[1].sBind;
    IF ExecDriver(sTmp) THEN term[1].fValid := false;
    Exit;
    END;
  IF copy(sArg,1,4)='KISS' THEN
    BEGIN
    { so, nun an Kissmode binden }
    sTmp := 'p KISS 1 bind '+term[1].sBind;
    IF ExecDriver(sTmp) THEN term[1].fValid := false;
    Exit;
    END;
END;

{$F+}
PROCEDURE TermHandler;{$F-}
  VAR c : CHAR;
BEGIN
  WITH term[1] DO IF fValid THEN
    BEGIN
    IF ProcNRxCHAR > 0 THEN
      BEGIN
      c := ProcRx1Char;
      ProcTx1Char(c); {* Echo *}
      IF mode=cTERM THEN
         BEGIN
         IF (c<>#10) AND (c<>#13)
           THEN AddChar(sKommandoZeile,c)
           ELSE BEGIN
                TermLine(sKommandoZeile); {* Kommando ausfhren *}
                sKommandozeile := '';
                END;
         END;
      END;
    END;
END;

{}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'INIT BIND IPCFG1 IPCFG2 ';
        cmINIT=1; cmBIND=2; cmIPCFG1=3; cmIPCFG2=4;

        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   res,x,devNrDn : BYTE;
        sDn : STRING;
        p : Pointer;
        para : Longint;
BEGIN
WITH term[devnr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmIPCFG1: BEGIN sIPCFG1 := sArg; sArg := ''; END;
      cmIPCFG2: BEGIN sIPCFG2 := sArg; sArg := ''; END;
      cmINIT : fValid := true;
      cmBIND : BEGIN  {* z.B. BIND v24 2 *}
               sBind := sArg;
               ScanForText (sArg, sDn );
               devNrDn := ScanforNum(sArg);
               res := DoBind( csMyName,devnr, sDn, devNrDn );
               bindnr := res;
               IF res > 0 THEN
                 BEGIN
                 {* Hole die Routinen *}
                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpRX1CHAR) )
                 );
                 ProcRx1Char :=  TFN_RX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC,  ord(hpNRXCHAR) )
                 );
                 ProcNRXCHAR :=  TFN_NRXCHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpTX1CHAR) )
                 );
                 ProcTx1Char :=  TFN_TX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpNTXCHAR) )
                 );
                 ProcNTXCHAR :=  TFN_NTXCHAR(p);
                 END;
               END;
      END {Case}
  UNTIL x=0;
END;


CONST sReturn : STRING='';
{$F+}
FUNCTION TERM_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE TP_STRING = ^STRING;
  VAR i, loknr : BYTE;
BEGIN
WITH term[devnr] DO
  BEGIN
  Term_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( TP_STRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sReturn := ' '+sKommandozeile
                 ;
        Term_SetPara := Longint(@sReturn);
        END;
    ELSE {* case *} Term_SetPara := speNNCMD;
  END;
 END;
END;


BEGIN
  FillChar( term, SizeOF(term), #0 );
  DoRegister(csMyName,1, MAXTERM, Term_SetPara);
  DoRegisterPoller(TermHandler);
END.
