{$A-,B-,D+,E+,F-,I-,L+,N-,O-,R+,S-,V-,q-}
UNIT FD_Task;
{$I FD_INCL.PAS}

INTERFACE

USES FD_Def;


TYPE t_fnvp = PROCEDURE;
CONST MaxTask = 6;
      csPSHeader = 'Nr St Name   usedTicks      resTim   Stck Reserv      Switch F';
                   {12123x1234123456789abc123456789abc12345671234567123456789abcx1 }

PROCEDURE TaskSwitch;
PROCEDURE TaskDelay (t : Longint );
{***PROCEDURE WaitFor (sem:tp_bool);}
PROCEDURE InitTask (sName:Str8; vx:t_fnvp; stacksize:WORD; p:pointer);
 FUNCTION PSZeile ( i : WORD ) : STRING;

{-------------------------------------------------------------------------}

IMPLEMENTATION
  Uses FD_Div,
      {$IFDEF SCC} FD_TNC   {* wg. Watchdog *}
      {$ELSE}      FD_CRT   {* wg. Watchdog *}
      {$ENDIF}  ;

TYPE T_TASKID = BYTE;
     T_Task = RECORD
      status       : (ctUNDEF,     {* Undefiniert, kann neu vergeben werden}
                      ctLAUFEND,   {* luft gerade (gibt es nur einen von)}
                      ctWARTEND,   {* Warted auf erneute Aktivierung}
                      ctWAIT4ENDE, {* ist komplett abgelaufen, aber Speicher mu noch freigegeben werden}
                      ctWAIT4FIRST {* soll aktiviert werden - ist aber noch nicht initialsiert}
                     );
      stack        : POINTER;      {* Zeiger auf Untergrenze Stack *}
      ss,sp,bp     : WORD;         {* Stackpointer bei Unterbrechung *}
      maxStackSize : longint;      {* Gre des Speichers der fr den Stack zu Verfgung steht *}
{      InitData     : Array [1..8] OF BYTE;  }
      procStart    : Pointer; {* Zeiger auf Routinenstart (wird nur einmal verwendet) *}

      pBool        : TP_BOOL; {* Zeiger auf eine BOOL-Variable; fr WaitFor() *}
      resumeTime   : LongInt; {* Wenn > 0: Darf erst aktiviert werden wenn SYSTICK > resumeTime}
{     Prioritaet   : BYTE;    {* 0 = Hchste *}

      usedTicks    : LongInt;
      nSwitch      : Longint; {* Sooft ist ZU ihm geswitcht worden *}
      sName        : STR4;
    END;


VAR nTask : WORD;
    Task : ARRAY [1..MaxTask] OF T_Task;

CONST ccSTACKFILL = #$AA;
      cMAINTASK = 1;
      CurrentTask : T_TASKID = 1;
                    {* 1..MAXTASK - Normal;
                     * 0 = System,Sched. etc. *}


PROCEDURE _pop_ds ;   INLINE ($1F);
PROCEDURE _MOV_BP_SP; Inline ($89/$E5);
PROCEDURE _push_ds;   INLINE ($1e);
PROCEDURE _RETF;      INLINE ($CB);

PROCEDURE SetStack ( ss,sp,  bp : WORD );
  inline(
    $5d/          {pop bp      }
    $58/          {pop ax      }
    $5A/          {pop dx       todo: mov [xxx],flags; cli; ...; mov flags,[xxx]}
    $FA/          {cli         ;Interrupts off while changing SS:SP}
    $8E/$D2/      {mov ss,dx   }
    $89/$C4/      {mov sp,ax}
    $FB           {sti         ;Interrupts on}
  );


PROCEDURE Stop;
BEGIN
  Halt;
END;


{$F+}
PROCEDURE Terminate;
BEGIN
  IF nTask = cMAINTASK THEN Halt(0);
  Task [CurrentTask].Status := ctWAIT4ENDE;
  TaskSwitch;
  {* hierhin kehrt er nie zurck - der Stack wird ja gelscht .... *}
END;

PROCEDURE Terminate_All;
  VAR i : BYTE;
BEGIN
  SetStack (Task[cMAINTASK].ss,Task[cMAINTASK].sp,Task[cMAINTASK].bp);
  {* Stack mu zuerst umgesetzt werden, sonst mordet DELTASK den Stack... *}
  FOR i := 1 TO maxTask DO
    IF Task [i].Status IN [ ctLAUFEND,ctWARTEND,ctWAIT4FIRST] THEN  Task [i].Status := ctWAIT4ENDE;

  _pop_ds;
  _MOV_bp_sp; {* Endcode neutralisieren *}
END;


{-----------------------------------------}


{$F+}
PROCEDURE Scheduler;
{* Sucht nchsten Task aus und schiebt in nach CurrentTask*}
  VAR alt_Task : T_TaskID;
BEGIN
  alt_Task := CurrentTask;
  IF nTask = 0 THEN BEGIN
                    Halt(0);
                    Exit;
                    END;
  REPEAT
    Inc(CurrentTask); {* Round-Robin, just as dumb as Robin in TimeBandits *}
    IF CurrentTask > MaxTask THEN CurrentTask := 1; {* Great trick: Avoiding MOD-division.. *}

    IF Task [CurrentTask].Status = ctWAIT4ENDE
       THEN BEGIN
            IF nTask <= 1 THEN Halt(0);
            Dec (nTask);
            {* Stack freigeben (ist aber GsD nicht der aktive Stack...) *}
            System.FreeMem ( Task [CurrentTask].stack, Task [CurrentTask].MaxStackSize);
            Task [CurrentTask].resumeTime := 0;
            Task [CurrentTask].Status := ctUNDEF;
            END;

  UNTIL (Task[CurrentTask].Status IN [ctWAIT4FIRST,ctWARTEND] )
    AND ( Task[CurrentTask].resumeTime <= fasttick )
    AND ( Task[CurrentTask].pBool^ ) ;
END;



{------- TaskSwitch --------------------------------------}


VAR tmpCodeOffset,
    tmpCodeSegment,
    w : WORD;  {* Wichtig, muss ausserhalb stehen *}
CONST semSwitch : BYTE=0;
      lastswitchtick : LongInt=0;
PROCEDURE PUSH ( dummyA,dummyB : WORD); Inline ($90); {NOP}


PROCEDURE TaskSwitch;
BEGIN {* Vom Compiler wird hier das erzeugt:
  * Push bp
  * MOV bp,sp
  * (sub SP,+nn)
  *}
{  IF nTask = 0 THEN Exit; }
  IF semSwitch>0 THEN Exit;
  Inc(semSwitch);
  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(nTaskSwitch);
  {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
  WatchDog;
  _push_ds;

  _DI;
  Inc( Task[CurrentTask].usedTicks, fasttick-lastswitchtick);
  lastswitchtick := fasttick;
  _EI;
  Task[CurrentTask].ss := sseg;
  Task[CurrentTask].sp := sptr;
  ASM
    MOV w,BP
  END;
  Task[CurrentTask].bp := w;

  IF Task[CurrentTask].Status <> ctWAIT4ENDE THEN Task[CurrentTask].Status := ctWARTEND;

  {* Eigener System Stack setzen *}
  SetStack( Task[cMAINTASK].ss, Task[cMAINTASK].sp, Task[cMAINTASK].bp );
  {* !!! Lokale Variable (auch WITH) ab hier nicht mehr verwendbar !!! *}
{-------------------------------------------------------------------------}
  Scheduler; {* ndert CurrentTask *}

  Inc(Task[CurrentTask].nSwitch);

  IF Task[CurrentTask].Status = ctWAIT4FIRST
    THEN BEGIN {* erster Start eines neuen Tasks *}
         Task [CurrentTask].Status := ctLAUFEND;
         tmpCodeOffset  := Ofs( Task [CurrentTask].ProcStart^);
         tmpCodeSegment := Seg( Task [CurrentTask].ProcStart^);
         Dec(semSwitch);
         SetStack( Task[CurrentTask].ss,Task[CurrentTask].sp, 0 );
         Push (seg(Terminate),Ofs(Terminate)); {* Nach Ende der Routine springt er zu Terminate *}
         Push (tmpCodeSegment,tmpCodeOffset); {* Procstart adresse auf den Stack *}
         {* Trick: Push() ist nop, aber die ASM Parameterbergabe (durch
          * den Comiler erzeugt) macht das was wir brauchen
          *}
         _RETF; {*Sprung in den Task *}
         {* Mhhh, hier gelangt man nie hin.... ausser wenn Terminate returnt ...*}
         END
    ELSE BEGIN
         Task [CurrentTask].Status := ctLAUFEND;
         Task [CurrentTask].pBool := pf_FOREVER_TRUE;

         SetStack (Task[CurrentTask].ss,Task[CurrentTask].sp,Task[CurrentTask].sp);
         _pop_ds;
         _MOV_bp_sp; {* Endcode neutralisieren *}
         Dec(semSwitch);
         END;
{* Vom Compiler wird hier automatisch erzeugt:
        MOV sp,bp
        POP bp
        RET n }
END;


PROCEDURE PrivateInitTask (x:byte;  vx : t_fnvp; stacksize:WORD; pp : POINTER);
VAR   p     : Pointer;
      l     : LongInt;
      ss,sp : WORD;
BEGIN
WITH Task[x] DO
  BEGIN
  IF status in [ctLAUFEND,ctWARTEND] THEN Stop; {* da stimmt was nicht...*}
  status := ctWAIT4FIRST;
  ProcStart := @vx;
  MaxStackSize := stacksize;
  usedTicks := 0;
  pBool := pf_FOREVER_TRUE;
  resumetime := 0;
  nSwitch := 0;

  {* Stack fr den Task bereitstellen *}
  System.GetMem (p,MaxStackSize);
  FillChar(p^,maxStackSize, ccSTACKFILL);  {* Zum Feststellen der verwendeten Stackgrsse IDEE: Geklaut bei DL8MBT *}
  stack := p;
  {* p normalisieren *}
  l := $10*longint(seg(p^)) + ofs(p^);
  p := Ptr(l DIV 16,l MOD 16);
  l := Ofs(p^);
  Inc (l,MaxStackSize-10); {*mit sicherheitsmarge*}
  p := Ptr (seg (p^), l);
  sp := ofs(p^);
  ss := seg(p^);

{  Move( pp^, InitData, SizeOf (InitData));  }

  Inc (nTask);
  END;
END;


PROCEDURE InitTask( sName:Str8; vx:t_fnvp; stackSize:Word; p:Pointer);
{* Sucht eine freie Taskvar. Wenn keine frei ist schaltet er den Prozess um *}
  VAR i, x : Byte;
BEGIN
  x := 0;
  WHILE x = 0 DO
    BEGIN
    FOR i := 1 TO MaxTask DO
      IF Task[i].status = ctUNDEF THEN
        BEGIN
        x := i;
        Break;
        END;
    IF x=0 THEN TaskSwitch;
    END;
  task[x].sName := sName;
  PrivateInitTask (x, vx, Stacksize, p);
END;


PROCEDURE TaskDelay ( t : LongInt {t=Zeit in MS} );
BEGIN
  Task [CurrentTask].resumeTime := fastTick + (t DIV 10);
  TaskSwitch;
END;

PROCEDURE WaitFor( sem:tp_bool );
BEGIN
  Task [CurrentTask].pBool := sem;
  TaskSwitch;
END;

{--------------------------------------------------------------------}

FUNCTION PSZeile ( i : WORD ) : STRING;
  VAR p : ^Char;
      nFree : Longint;
BEGIN
  PSZeile := '';
  WITH task[i] DO
    BEGIN
    IF status = ctUNDEF THEN Exit;

    {* Benutzten Stack testen. Prinzip von DL8MBT *}
    nFree := 0;
    p := stack;
    WHILE (p^=ccSTACKFILL) AND (nFree<maxStacksize) DO
      BEGIN
      Inc(p);
      Inc(nFree);
      END;
    PSZeile :=  F_Using (i,2)
                + F_Using (ord(status),3)+' '
                + F_SetStrLength(sName,4)
                + F_Using (usedTicks,12)
                + F_Using (resumetime,12)
                + F_Using (maxstacksize,7)
                + F_Using (nFree,7)
                + F_Using (nSwitch,12)
                + '  '+F_Bool(pBool^);
    END;
EnD;



{--------------------------------------------------------------------------}

  VAR i : byte;
BEGIN
  CurrentTask := 1;
  nTask := 0;
  FillChar( Task,sizeof(Task), #0);
  FOR i := 1 TO MaxTask DO
    BEGIN
    Task[i].status := ctUNDEF;
    Task[i].resumeTime := 0;
    END;

  {* HauptTask *}
   WITH Task[cMAINTASK] DO
     BEGIN
     status := ctLaufend;
     Inc (nTask);
     sName := 'Main';
     END;
   CurrentTask := cMAINTASK;
END.
