UNIT FD_Sysop;
{$I FD_INCL.PAS}
{$IFnDEF scc}   {$O+,F+}  {$ENDIF}

INTERFACE

USES FD_Def;

{* Globale Variablen fr Upload lt. #BIN#: *}
  CONST ulState : ( NULL,       {* Nichts ist im Gange *}
                    WAIT,       {* Warten auf #BIN# *}
                    INPROGRESS  {* Konsumieren... *}
                  ) = NULL ;    {* Uploadstate *}
        ulLen : LONGINT = 0;

  VAR pULZiel  : POINTER;    {* Da soll es hin *}
      ulCRC    : WORD;
      ulByte   : Longint;
      ulFastTickStart : Longint;
      ulFake   : BOOLEAN; {* TRUE: nicht wirklich upgeloaden - nur CRC testen *}
      ulId     : WORD; {* ID desjenigen QSO, der uploaded *}

  {----- Passwortkram -----}
  CONST cMAXPWLISTSIZE=1620; {* Grsse derandene Grundmenge *}
        cMAXPWLISTINDEX=cMAXPWLISTSIZE-1;
        MAXPWGRUNDMENGE : WORD = cMAXPWLISTSIZE; {* Maximale Gre der Grundmenge, die verwendet wird (z.B. NET/ROM=80)  *}
        MAXLENPW=5; {* Maximale Lnge des relevanten Passwortteils *}
        PWGENOFF : INTEGER = 1; {* Fr Erzeugung des Passwords (offset by 1 kram) *}
  VAR   chPwList : ARRAY [0..cMAXPWLISTINDEX] OF CHAR;
  CONST sPW   : String[MAXLENPW]='';
        pCBPW : tp_AXCB = NiL; {* CB des QSOs der den letzen SYSOP Befehl absetzte *}
  {--------------}
  VAR   timLastTraceInfo : Longint;


PROCEDURE DoError(pCB : TP_AXCB; fStack : BOOLEAN );
PROCEDURE DoDump (pCB : TP_AXCB; s : STRING);
PROCEDURE DoPoke (pCB : TP_AXCB; sArg : STRING);
PROCEDURE DoInput (pCB : TP_AXCB; s : STRING);
PROCEDURE DoOutput (pCB : TP_AXCB; s : STRING);
PROCEDURE TxDebugPM (pCB : TP_AXCB; pm : TP_MBUF; byNDataBytes : BYTE);

 FUNCTION TraceIt(pm:tp_mBuf) : BOOLEAN;
     TYPE T_TraceMode=(cTraceRX,cTraceTX);
PROCEDURE DoTrace ( mode : T_TraceMode; pm : TP_mBuf; pTracedCB : TP_AXCB );

PROCEDURE TraceInfo ( {$IFDEF ver70} CONST {$ENDIF} sArg : STRING; pCB :TP_AXCB);
PROCEDURE TracePlain ( {$IFDEF ver70} CONST {$ENDIF} sArg : STRING;
                       {$IFDEF ver70} CONST {$ENDIF} chmode:STRING);


 FUNCTION DoWrite (pCB:tp_axcb; sArg : STRING) : BOOLEAN;
PROCEDURE fMsgWriteText ( pCB : tp_Axcb; msg : T_Msg);
PROCEDURE DoSysBusy  ( pCB : TP_axcb; sArg : STRING );
PROCEDURE DoTell ( pCB : TP_axcb; arg : STRING );

PROCEDURE ListWatch (pCB : TP_AXCB);
PROCEDURE SetWatch ( pCB : TP_AXCB; sArg : STRING);
 FUNCTION GetWatch (pCB : tp_axcb) : BYTE;

PROCEDURE DoKill ( pCB : TP_axcb; id : WORD );
{*** PROCEDURE SysOpLogin ( pCB : TP_axcb; sArg : STRING); ***}
PROCEDURE SysOpSNetLogin  ( pCB : TP_axcb; sArg : STRING);

PROCEDURE DoListPaketStatistik (pCB : TP_AXCB; nPort:BYTE);
PROCEDURE Toggle (  pcB:TP_AXCB;
                   VAR b : BOOLEAN; s : STRING;
                   VAR sArg : STRING; nrPara : WORD );
PROCEDURE DoParameter (pCB:tp_axcb; sArg : STRING);
PROCEDURE DoUpLoad (pCB:tp_axcb; fFake : BOOLEAN);
 FUNCTION DoDownLoad (pCB:tp_axcb; len : longint) : BOOLEAN;
PROCEDURE DoRestart ( pCB:tp_axcb; VAR sArg : STRING);
 FUNCTION GetRemoteStatus : STRING;
PROCEDURE GenPassWord( startwert : WORD );


{--------------------reg------------------------------------------------}

CONST MAXSUBDEV = 8; {* Maximale Anzahl Untergerte *}
 TYPE T_RegIf = WORD;
      {* Register interface; Hi() enthkt den Index von REGISTER[]; lo() die Nr des SubGertes *}
      T_Register = RECORD
                     sName : STRING[10];
                     devnrVon,
                     devNrbis : WORD;
                     procSetPara : TFN_SetPara;
                     bindnrUp,  {* Da ist sName als Up eingebunden *}
                     bindnrDn : ARRAY[1..MAXSUBDEV] OF WORD; {* Da ist sName als Dn eingebunden *}
                     {Index ist die Devnr}
                     END;
CONST MAXREGISTER = 16;
      sRegisterTable : STRING = '';
      iRegister : WORD = 0;
  VAR Register : ARRAY [1..MAXREGISTER] OF T_REGISTER;

PROCEDURE DoRegister( sNameArg : STRING;
           devnrVonArg,devNrbisArg : WORD;
                 ProcSetParaArg : TFN_SetPara );
PROCEDURE CloseRegister; {* Wird bei Beenden von DigiWare aufgerufen *}

FUNCTION DoBind( sUp: String; devNrUpArg: BYTE;
                 sDn: String; devNrDnArg: BYTE) : WORD;
FUNCTION DoUpSetPara ( bindnr:WORD;  what:T_SetPara; val:longint ) : Longint;
FUNCTION DoDnSetPara ( bindnr:WORD;  what:T_SetPara; val:longint ) : Longint;
FUNCTION Str2ifip (sDev:String; devNr : BYTE) : T_RegIf;

    CONST nPollHandler : WORD = 0;
          MAXPOLLHANDLER = 8;
     TYPE T_PollHandler=PROCEDURE;
      VAR pollHandler : ARRAY [1..MAXPOLLHANDLER] OF T_PollHandler;
PROCEDURE DoRegisterPoller( proc : T_PollHandler);
PROCEDURE DoPoll;
 FUNCTION ExecDriver( VAR sArg : STRING) : BOOLEAN;


{}

IMPLEMENTATION


USES fd_mem,
     fd_Div,
     FD_Subr,
     FD_mBuf,
     FD_Task,
     fd_axcb,
     FD_Circ,
     FD_Dump, {* pmHeaderStr *}
     fd_prom,
     fd_link, {* nZiel *}
     fd_flex, {* ReorgZiel *}
     FD_Info,
     FD_Host, {* wg. HostMonitor *}
     FD_Moni, {* pm2HeaderStr *}
     fd_text, {* MsgWrite/T_Text *}
     fd_error,
     fd_state, {* wegen Defaultmsghandler *}
     fd_timer,
     fd_tx,
     fd_main,  {* wg. Patch *}
     {$IFDEF SCC} fd_tnc,
     {$ELSE}      fd_crt,
                  DOS,
     {$ENDIF}
     fd_log,
     fd_ar;


{$IFDEF SpecialMEHack}
{$I fd_iz.pas} {*** Sollte es hier eine Fehlermeldung (File not found) geben,
******************* so kann man diese Zeile einfach lschen ...***}
{$ENDIF}

{}

PROCEDURE CloseRegister;
  VAR i,j : WORD;
BEGIN
 FOR i := 1 TO iRegister DO WITH Register[i] DO
  FOR j := devNrVon TO devNrBis DO
    IF ProcSetPara ( j, spDeInit, 0) = 0 THEN ;;;;
END;

FUNCTION RegisterSuche(sName:STRING) : WORD;
  VAR i : WORD;
BEGIN
 RegisterSuche := 0;
 FOR i := 1 TO iRegister DO
  IF register[i].sName = sName THEN
    BEGIN
    RegisterSuche := i;
    Exit;
    END;
END;

FUNCTION Str2ifip (sDev:String; devNr : BYTE) : T_RegIf;
{* Interne Nr erzeugen: TTgg    TT=TreiberNr; gg=GerteNr im Treiber *}
BEGIN
  Str2ifip := (RegisterSuche(sDev) SHL 8) + devNr;
END;


PROCEDURE DoRegister(  sNameArg : STRING;
           devnrVonArg,devNrbisArg : WORD;
                 ProcSetParaArg : TFN_SetPara);
{* Gebe bekannt, dass es diese Hardware GIBT, aber es wird noch keine Init
 * oder so durchgefhrt *}
BEGIN
{$IFDEF v24life}
  Writeln('- ',sNameArg,' Registrierung...');
  IF devNrbisArg>MAXSUBDEV THEN Writeln('--WARNUNG:devNrbisArg zu gross');
{$ENDIF}
  IF devNrbisArg>MAXSUBDEV THEN Exit;

  Upper(sNameArg);
  IF RegisterSuche(sNameArg) < 1 THEN
    BEGIN {- ist noch nicht drin -}
    IF @ProcSetParaArg=nil THEN Halt(254);
    AddString (sRegisterTable,sNameArg+' ');
    Inc(iRegister);
    IF iRegister>MAXREGISTER THEN Halt(ERR_NO_RESOURCE);
    FillChar( register[iRegister], sizeof(register[iRegister]) ,#0 );
    WITH register[iRegister] DO
      BEGIN
      sName       := sNameArg;
      devnrVon    := devnrvonArg;
      devNrbis    := devnrbisArg;
      ProcSetPara := ProcSetParaArg;
      END;
    END;
END;


FUNCTION DoBind( sUp: String; devNrUpArg: BYTE;
                 sDn: String; devNrDnArg: BYTE) : WORD;
  VAR iBind, regnrUp,regnrDn,bindportnr : WORD;
BEGIN
  DoBind := 0;
  Upper(sUp);
  Upper(sDn);
  regnrUp := ScanStr (sUp, @sRegisterTable[1], length(sRegisterTable) );
  regnrDn := ScanStr (sDn, @sRegisterTable[1], length(sRegisterTable) );
  bindportnr := 0;
  IF (regnrDn    >0) AND (regnrUp>0) AND
     (devNrDnArg >0) AND (devNrDnArg<100) AND
     (devNrUpArg >0) AND (devNrUpArg<100)
     THEN BEGIN
          iBind := 1;
          WHILE (iBind<= MAXBIND) AND (bindportnr=0) DO
            BEGIN
            IF NOT bind[iBind].valid THEN bindportnr := iBind;
            Inc(iBind);
            END;
          END;
   IF bindportnr=0 THEN
     BEGIN {* Falsche Argumente, oder kein Platz mehr *}
     WriteLn('- Gescheitert: Bindung ',
             ': ',   sUp,'-',devnrUpArg,
             ' an ', sDn,'-',devnrDnArg
     );
     Exit;
     END;
{$IFDEF v24life}
   WriteLn('- Bindung Nr.',bindportnr,
                  ': ',   Register[regnrUp].sname,'-',devnrUpArg,
                  ' an ', Register[regnrDn].sname,'-',devnrDnArg
   );
{$ENDIF}

   bind[bindportnr].valid   := true;
   bind[bindportnr].regNrDn := regNrDn ;
   bind[bindportnr].devNrDn := devNrDnArg ;
   bind[bindportnr].regNrUp := regNrUp ;
   bind[bindportnr].devNrUp := devNrUpArg ;

   register[regNrDn].bindnrdn[devNrDnArg] := bindPortNr;
   register[regNrUp].bindnrup[devNrUpArg] := bindPortNr;

   {- Den beiden Beteiligten Bescheid sagen -}
   IF Register[regnrDn].procSetPara(devNrDnArg,spBIND_DN,bindportnr) = 0 THEN ;;;
   IF Register[regnrUp].procSetPara(devNrUpArg,spBIND_UP,bindportnr) = 0 THEN ;;;
   DoBind := bindportnr;
END;


FUNCTION DoUnBind( bindNr : WORD ) : BOOLEAN;
BEGIN
  DoUnBind := false;
  IF bindnr=0 THEN Exit;

  WITH bind[bindnr] DO
    BEGIN
    IF NOT valid THEN Exit;

{$IFDEF v24life}
    WriteLn('- Entbinden Nr.',bindNr,
                  ': ',   Register[regnrUp].sname,'-',devnrUp,
                  ' an ', Register[regnrDn].sname,'-',devnrDn
    );
{$ENDIF}
   {- Den beiden Beteiligten Bescheid sagen -}
   IF Register[regnrDn].procSetPara(devNrDn,spUNBIND,bindnr) = 0 THEN ;;;
   IF Register[regnrUp].procSetPara(devNrUp,spUNBIND,bindnr) = 0 THEN ;;;

   register[regNrDn].bindnrdn[devNrDn] := 0;
   register[regNrUp].bindnrup[devNrUp] := 0;

   valid   := false;

   DoUnBind := TRUE;
   END;
END;


FUNCTION DoUpSetPara ( bindnr:WORD;  what:T_SetPara; val:longint ) : Longint;
  {* Rufe die bei Up eingetragenen Routine auf}
BEGIN
  DoUpSetPara := Register[ bind[bindnr].regNrUp ].procSetPara (bind[bindnr].devNrUp, what,val);
END;

FUNCTION DoDnSetPara ( bindnr:WORD;  what:T_SetPara; val:longint ) : Longint;
  {* Rufe die bei Dn eingetragenen Routine auf *}
BEGIN
  DoDnSetPara := Register[ bind[bindnr].regNrDn ].procSetPara (bind[bindnr].devNrDn, what,val);
END;


{$F+}
PROCEDURE DoRegisterPoller( proc : T_PollHandler ); {$F-}
BEGIN
  Inc(nPollHandler);
  IF nPollHandler>MAXPOLLHANDLER THEN Halt(ERR_NO_RESOURCE);
  pollHandler[nPollHandler] := proc;
END;


PROCEDURE DoPoll;
  VAR i : WORD;
BEGIN
  WHILE true DO
    BEGIN
    FOR i := 1 TO nPollHandler DO
      BEGIN
      WatchDog; {* Neu, 9-96, wg. Watchdogzuschlag in FD_KISS *}
      PollHandler[i];
      END;
    {$IFDEF Userware} TaskDelay(1); {$else} TaskDelay(10); {$ENDIF}
    END;
END;


FUNCTION ExecDriver( VAR sArg : STRING) : BOOLEAN;
{* Befehl indirekt ausfhren, z.B. "KISS 1  SLIP  BIND v24 1   init" *}
  VAR regnr,  para : LongInt;
BEGIN
  regnr := ScanStr (sArg, @sRegisterTable[1], length(sRegisterTable) );
  ExecDriver := regNr <> 0;
  If regnr <> 0 THEN
     BEGIN
     para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
     IF para > 255
       THEN
       ELSE IF Register[regnr].procSetPara (para, spKommandoZeile,Longint(@sArg)) = 0 THEN ;;;
     END;
END;

{}

PROCEDURE DoError(pCB : TP_AXCB; fStack : BOOLEAN );
  VAR i,j : WORD;
      s : STRING;
BEGIN
  IF fStack
    THEN BEGIN
         FOR i := 1 TO MAXRESET DO WITH backup.stack[i] DO
          IF caller[1]<>NiL THEN
           BEGIN
           j := 1;
           TX_Info (pCB,SPAETER, '  '+grund+' '+fStr(tick)+' '+sData+EOL);
           s := '';
           WHILE (j<nCaller) AND (caller[j] <> NiL) DO
             BEGIN {* letzte wird nicht ausgegeben...*}
             s := s + HexAddrString(caller[j])+' ';
             Inc(j);
             END;
           IF j<>1 THEN TX_Info (pCB,SPAETER,s+EOL);
           END;
         END
    ELSE BEGIN
         TX_Info (pCB,SPAETER,EOL+
           'nRst:'+     FStr(backup.nReset)+
          ' nErr:'+     FStr(backup.nError)+
          ' smMm:'+     FStr(backup.semem)+
          ' CS='  +     HexString(fdCS)  +
          ' DS='  +     HexString(fdDS)+
          EOL+
	   'nDeb:'+ FStr(semL1.nDeb1)+'/'+FStr(semL1.nDeb2)+
          EOL+
	   'nTxInt:'+ FStr(semL1.nSendInt)+'/'+FStr(semL1.nSendInt2)+
	  ' nTl:'   + FStr(semL1.nTxTail)+
	  ' nAb:'   + FStr(semL1.nAbort)+
          ' PTTwd:' + FStr(semL1.nPTTWatchDog0)+'-'+
                      FStr(semL1.nPTTWatchDog1)+'-'+
                      FStr(semL1.nPTTWatchDog2)+'-'+
                      FStr(semL1.nPTTWatchDog3)+
              {FStr(semL1.asmCntRxErr)+'/'+FStr(semL1.asmCntRxCrcErr)+}
	  EOL  );
	 TX_Info (pCB,SPAETER,
            {  ' IntTbl:'+HexString(backup.IntTbl_adr)+':'+HexByteString(backup.IntTbl_dat)
             +EOL+ }
	  'LastCmd:'+ShowLastCmd+EOL+
	  'Startup:'+EOL);

         {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
         s := '';
         FOR i := 1 TO MAXRESET DO IF backup.startTime[i].day <> 0 THEN
           s := s + Time2StrTTMMHHMM( backup.startTime[i] ) + EOL;
         TX_Info (pCB,SPAETER, s );

         FOR i := 1 TO MAXRESET DO
           IF seg(Backup.Err[i].Adr^) <> 0 THEN TX_Info (pCB,SPAETER,EOL+
             'At '    + Time2StrTTMMHHMM(backup.err[i].zeit) +
             ' RTErr '+ FStr(backup.err[i].Code) +
             ' Adr:'  + HexAddrString(Backup.Err[i].Adr) );
         END;
  {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
END;


PROCEDURE DoDump (pCB : TP_AXCB; s : STRING);
  VAR p,pZwisp  : POINTER;
      i  : WORD;
      sa : STRING;
BEGIN
  p := Scan4Adr(s);
  pZwisp := p;
  s := '';
  sa := '';
  FOR i := 1 TO 5*16 DO
    BEGIN
    s := s + HexByteString ( byte(p^))+' ';
    IF char(p^) >=' ' THEN sa := sa + char(p^)
                      ELSE sa := sa + '.' ;
    Inc (word (p));
    IF i MOD 8 = 0 THEN
      IF i MOD 16 = 0
        THEN BEGIN {* Zeilenende *}
             TX_Info (pCB,SPAETER,EOL+HexAddrString(pZwisp)+'  '+s+'  '+sa );
             s := ''; sa := ''; pZwisp := p;
             END
        ELSE BEGIN {* Mitten in der Zeile *}
             s  := s  + ' ';
             sa := sa + ' ';
             END;
    END;
END;

PROCEDURE DoPoke (pCB : TP_AXCB; sArg : STRING);
  VAR p : POINTER;
      i : Word;
      s : String;
BEGIN
  p := Scan4Adr (sArg);
  i := ScanForNum(sArg);
  IF (i<>NOTANUMBER) AND (i<256)
    THEN BEGIN
         Byte(p^) := i;
         s := 'done: '+HexAddrString(p)+'  '+HexByteString(i);
         END
    ELSE s := 'bad argument';
  TX_EolSysInfo (pCB,SPAETER, s );
END;


PROCEDURE DoInput (pCB : TP_AXCB; s : STRING);
  VAR p : POINTER;
      i : WORD;
BEGIN
  p := Scan4Adr(s);
  _portena;  {* Sonst: Bei Aufruf Reset *}
  TX_EOLSYSInfo (pCB,SPAETER, HexString (seg(p^))+' h:'+
                              HexByteString (Port[seg(p^)]) + ' hex' );
  _portdis;
END;


PROCEDURE DoOutput (pCB : TP_AXCB; s : STRING);
  VAR p : POINTER;
      i : WORD;
BEGIN
  p := Scan4Adr(s);
  _PortEna;
  Port[seg(p^)] := ofs(p^); {* Hugos Hacker Club... *}
  _PortDis;
  TX_EolSysInfo (pCB,SPAETER, 'done' );
END;

{}

PROCEDURE TxDebugPM (pCB : TP_AXCB; pm : TP_MBUF; byNDataBytes : BYTE);
  VAR pSrc,pziel : POINTER;
      i : BYTE;
      pmZ : TP_mBuf;
BEGIN
{$IFOPT R+} {$DEFINE rplus} {$ENDIF} {$R-}
  IF pm = Nil
    THEN TX_INFO( pCB, SOFORT,EOL+'NIL')
    ELSE BEGIN
         TX_INFO( pCB, SOFORT, EOL+
           HexAddrString (pm)+
           ': N:'+HexAddrString (pm^.next)+
           ' D:'+HexAddrString (pm^.pData)+
                { bufl  : longint;  {* TX/RX: pData als 20 Bit Addresse *}
           ' inU:'+FStr(pm^.inUse)+
           ' t:'+fStr(pm^.time)+
           ' i:'+FStr(pm^.Ifnr)+
           ' tx:'+char(48+ord(pm^.txed))+
           ' pT:'+HexAddrString (pm^.ptTimer)+
           ' disc:'+char(48+ord(pm^.discard))+
           ' len:'+FStr(pm^.len)+
           ' ofs:'+FStr(pm^.ofsctl)+
           ' nMy:'+FStr(pm^.nMyCall)+
           ' nH:'+FStr(pm^.nHeard)+
           ' pData:');
         IF pm^.pData <> NiL THEN
           BEGIN
           IF (byNDataBytes > pm^.inUSe) OR (byNDataBytes=255) THEN byNDataBytes := pm^.inUSe;
           pmZ := Get_MBuf (byNDataBytes);
           pZiel := pmZ^.pData;
           pSrc := pm^.pData;
           FOR i := 1 TO byNDataBytes DO
             BEGIN
             IF char(pSrc^) < #32 THEN Char(pZiel^) :=  ''
                                  ELSE Char(pZiel^) := Char(pSrc^);
             Inc( Word(pSrc) );
             Inc( Word(pZiel) );
             END;
           TxQueue_mBuf_chain ( pCB, SPAETER, pmZ );
           TX_INFO (pCB,SOFORT,'<<--'+EOL)
           END;
         END;
{$IFDEF rplus} {$UNDEF rplus} {$R+} {$ENDIF}
END;



FUNCTION TraceIt(pm:tp_mBuf) : BOOLEAN;
BEGIN
  TraceIt :=
  {$IFDEF Hostmode} pm^.IFnr<>ifloopBack
  {$ELSE}          (pm^.IFnr = trace.SrcPort)
  {$ENDIF}
  ;
END;

PROCEDURE DoTrace ( mode : T_TraceMode; pm : TP_mBuf; pTracedCB : TP_AXCB );
  VAR s : STRING;
      idTraced : Integer;
BEGIN
  IF pTracedCB=nil THEN idTraced := -1
                   ELSE idTraced := pTracedCB^.id;
  IF (pm^.IFnr<>trace.SrcPort) AND (trace.idTraced<>idTraced) THEN
    BEGIN {* Passt nicht ins Verfolgungsschema *}
    {$IFDEF HostMode} HostMonitor(pm,false); {$ENDIF}
    Exit;
    END;

  IF trace.idLauscher = 0 THEN Exit;
  {* Lauscher darf seine eigenen Frames nicht tracen, wg. Verstopfung *}
  IF trace.idLauscher = idTraced THEN Exit;
  IF cb[trace.idLauscher] = nil THEN
    BEGIN  {* Lauscher ist ungltig geworden *}
    trace.idLauscher := 0;
    Exit;
    END;

  IF cb[trace.idLauscher]^.txbufsize > 2000 THEN Exit;{* berlastkontrolle *}
  {* IDEE: IF < 2000 and < 3000  and not flag then tx_info "..." flag:=true. *}

  IF trace.fBodyOnlyInfo AND NOT IsIUIFrameTyp(pm) THEN Exit;

  CASE mode OF
    cTraceRX : s:= 'RX: ';
    cTraceTX : s:= 'TX: ';
    ELSE s:= '';
  END{case};
  AddString(s,Pm2AxHeaderStr(pm,true));
  IF (trace.sFilter = '') OR ((Pos(trace.sFilter,s) > 0) XOR trace.fExclFilter) THEN
    BEGIN
    Tx_Info( cb[trace.idLauscher], SPAETER, s+EOL );
    IF Trace.fBody THEN
      BEGIN
      s := Pm2BodyStr ( pm );
      {* $Idee: BodyFilter ... *}
      IF s<>'' THEN Tx_Info( cb[trace.idLauscher], SPAETER, s+EOL);
      END;
    IF Trace.fBodyHexDump THEN
      BEGIN
      s := AsHexString ( pm^.pdata, pm^.inUse,true{ascii},false{beauty});
      IF s<>'' THEN Tx_Info( cb[Trace.idLauscher], SOFORT, s+EOL);
      END;
    TX_Trigger(cb[Trace.idLauscher]);
    END;
END;


PROCEDURE TraceInfo ( {$IFDEF ver70} CONST {$ENDIF} sArg : STRING; pCB :TP_AXCB);
  VAR s : STRING;
BEGIN
  timLastTraceInfo := fastTick; {* z.B. fr den Hostmode-LED-Kram *}
  IF NOT Trace.fInfo THEN Exit;
  IF trace.idLauscher = 0 THEN Exit;
  IF cb[Trace.idLauscher] = nil THEN Exit;
  IF cb[Trace.idLauscher]^.txbufsize > 2000 THEN Exit;{* berlastkontrolle *}
  s := f_sh2ascUsing(pCB^.toCall, TRUE{w/SSID}, 9)+':'+sArg +EOL;
  IF (Trace.sFilter = '') OR (Pos(Trace.sFilter,s) <> 0) THEN
    BEGIN
    Tx_Info( cb[Trace.idLauscher], SOFORT, s );
    END;
END;


  CONST sTP : STRING='';
        chlstmode : STRING = ' ';
PROCEDURE TracePlain ( {$IFDEF ver70} CONST {$ENDIF} sArg : STRING;
                       {$IFDEF ver70} CONST {$ENDIF} chmode:STRING);
  VAR s : STRING;
BEGIN
  IF NOT Trace.fInfo THEN Exit;
  IF trace.idLauscher = 0 THEN Exit;
  IF cb[Trace.idLauscher] = nil THEN Exit;
  IF cb[Trace.idLauscher]^.txbufsize > 2000 THEN Exit;{berlastkontrolle*}
  if (length(sTp) > 15) or (chmode <> chlstMode) THEN
    BEGIN
    s := sTP;
    IF (Trace.sFilter = '') OR (Pos(Trace.sFilter,s) <> 0) THEN
      BEGIN
      s := AsHexString (@s[1], length(s), true, true);
      Tx_Info( cb[Trace.idLauscher], SOFORT, EOL+chlstmode+': '+s );
      END;
    sTP := '';
    END;
  chlstMode := chmode;
  sTP := sTP + sArg;
END;



{}


{$Ifdef DG5MPQ_STA}
PROCEDURE DoList10MinStatistik (pCB : TP_AXCB; nPort:BYTE; fDetail : BOOLEAN);
  VAR portNr : BYTE;
      s      : STRING;
      minnr,maxnr,
      chFaktor,Portnummer: Byte;
      lz : Word;
      zi,i : INTEGER;
BEGIN
  IF fSta10minMustBeInit THEN Exit;
  IF (nPort > MAX_IFACE) THEN nPort := MAX_IFACE;
  IF nPort=0 THEN BEGIN minnr := 1;     maxnr := MAX_IFACE; END
             ELSE BEGIN minNr := nPort; maxnr := nPort;     END;
  Watchdog;
  TX_Info (pCB, SPAETER, EOL+'Statistik der letzten 10 Minuten'+ EOL+EOL
    +' Po  Ident  QSO  I_TX-Fr  I_RX-Fr TXkB RXkB   Qty'{  Link  SSID   Laufzeit'} + EOL+EOL);
  {*   1.  noe-no 100 23232322 3322322  2333 2222   100  db0noe00-00  1234/1234 *}
  FOR portNummer := minnr TO MAXnr DO
    Begin
    WITH axIFace[portNummer] DO IF Valid THEN
      BEGIN
      s := ' ' + f_using(portNummer,2) + '. '
               + f_sh2ascUsing(IDent,true,6)+' ';
      SetStrLength ( s , 12 );
      With sta10min [portnummer] do
        BEGIN
        {* QSOs zhlen *}
        IfaceUser:=0;
        Links:=0;
        FOR i := 1 TO maxAXCB DO IF cb[i] <> NiL THEN
          IF (cb[i]^.qsotype <> qtBake) AND (cb[i]^.iface = portNummer) THEN
            Inc(IfaceUser);
        TxKByte:=0;
        RxKByte:=0;
        AnzBest:=0;
        ITx:=0;
        IRx:=0;
        FOR i := 1 to 10 do
          Begin
          Inc(TxKByte,min_TXKbyte[i]);
          Inc(RxKByte,min_RxKByte[i]);
          Inc(AnzBest,min_nAnzBest[i]);
          Inc(ITx,min_nITx[i]);
          Inc(IRx,min_nIRx[i]);
          IF fDetail THEN
            BEGIN
            IF i = 1 THEN TX_Info(pCB, SPAETER,EOL
                           + '                 I_TX-Fr  I_RX-Fr TXkB  RXkB  nAnzbest'
                           + EOL);
            TX_Info(pCB, SPAETER,
                    'Port:' + f_Using(Portnummer,2)
                   +' Min:' + f_Using(i,2)+'  '
                            + f_Using(min_nitx[i],8)+' '
                            + f_Using(min_nirx[i],8)+' '
                            + f_Using(min_txkbyte[i],4)+' '
                            + f_Using(min_rxkbyte[i],4)+' '
                            + f_Using(min_nanzbest[i],5)+' '+eol);
            END;
        END;

      TX_Info(pCB, SPAETER,s+f_Using(IfaceUser,3)+' '+
                             f_Using(ITx,8)+' '+
                             f_Using(IRx,8)+' '+
                             f_Using(TxKByte,4)+' '+
                             f_Using(RxKByte,4)+' ');
{$IFDEF voellig_Bloedsinnige_qualittaet}
      IF iTx <> 0
        THEN TX_Info(pCB, SPAETER, '  '+ f_Using(100*AnzBest DIV ITx,3)+'% ')
        ELSE TX_Info(pCB, SPAETER, '  ---% ');
{$ENDIF}
     END;

 {$IFDEF dfsfsd}
     FOR i := 1 TO nLinks DO
       BEGIN
       IF (link[i].portnr = portnummer) and link[i].valid and link[i].Direkt THEN
         BEGIN
         Inc(sta10min[portnummer].links);
         s := f_sh2AscOhneSSID(link[i].call);
         SetStrLength (s,6);
         IF link[i].SSID_von=link[i].SSID_bis
           THEN s := s + f_Using(link[i].SSID_von,2)+'    '
           ELSE s := s + f_Using(link[i].SSID_von,2)+'-'+f_Using(link[i].SSID_bis,2)+' ';
         IF (pCB^.who=sysop) and link[i].hidden
           THEN s:=s+'#'
           ELSE s:=s+' ';
 {* Linkzeiten ausgeben *}
         IF (link[i].lzMessen) AND (fLZMessungen) THEN
           BEGIN
           chFaktor := 0;
           zi := FlexSucheZiel (link[i].call,link[i].SSID_von, FALSE );
           IF zi>0 THEN
            IF (Ziel[zi].lkUsed<>i) AND (Ziel[zi].lkUsed<>0) THEN
             chFaktor := 1;
                    (*IF (tSchnitt = lzERROR) AND (tSchnitt<lzANZEIG) dg6may *)
           IF (link[i].tSchnitt = lzERROR) OR (link[i].tSchnitt>lzANZEIG) THEN
            s := s+'   '+Char(32+8*chFaktor)+'---'+Char(32+9*chFaktor)
           ELSE
           BEGIN
            IF link[i].System = dsFLEXNET THEN
             s := s + Char(32+8*chFaktor)+f_Using (link[i].tOur,4) +'/'+ fstr (link[i].tThem)+Char(32+9*chFaktor)
            ELSE
             s := s + Char(32+8*chFaktor)+f_Using (link[i].tSchnitt,4)+Char(32+9*chFaktor);
           END;
          IF link[i].startZeit <> 0 THEN
           s := s + '.';
         end;    {laufzeitmessen}
        If sta10min[portnummer].Links > 1
           THEN s := '                                                   '+s;
        TX_Info(pCB, SPAETER,s+EOL);
        s:='';
       END;
     END;      {For i = 1 to nLinks}
    If sta10min[Portnummer].Links = 0 Then TX_Info(pCB,Spaeter,EOL);
 {$ELSE}
    TX_Info(pCB, SPAETER,EOL);
 {$ENDIF}

    END;       {With   iface}
 end;          {for portnummer}
END;
{$ENDIF}



PROCEDURE DoListPaketStatistik (pCB : TP_AXCB; nPort:BYTE);
  VAR portNr : BYTE;
      s      : STRING;
BEGIN
{$IFDEF DG5MPQ_STA}
  IF nPort>=100 THEN
    BEGIN
    IF nPort>=200 THEN DoList10MinStatistik(pCB,nPort-200, TRUE)
                  ELSE DoList10MinStatistik(pCB,nPort-100, False);
    Exit;
    END;
{$Endif}

  {* Byte Statistik           1. 123456 ........12345678123456781234567890123456789012345678901234567890*}
  TX_Info (pCB, SPAETER, EOL+'  Ident    Call   MaxEffBd effBaud   TxNetto   TxBrut.   RxNetto  RxBrutto' + EOL);

  FOR portNr := 1 TO MAX_IFACE DO IF (nPort=PortNr) OR (nPort=0) THEN
    WITH axIFace[portnr] DO
      IF Valid THEN
        BEGIN
        s := f_using(portNr,1) + '. ' +
             f_sh2ascUsing(IDent,true,6)+' '+
             f_sh2Asc(Call);
        SetStrLength ( s , 18 );
        TX_Info (pCB, SPAETER, s+
             f_Using(brmax,8)+
             f_Using(brChAvg,8)+
             f_Using(nTxInfoNetto,10)+
             f_Using(nTxBrutto,10)+
             f_Using(nRxInfoNetto,10)+
             f_Using(nRxBrutto,10)+
             EOL);
        END;

  {* Paketstatistik *}
  TX_Info (pCB, SPAETER, EOL
           {* 1234561234567812345678123456781234567812345678 *}
            +' Port        I      RR     RNR     REJ    Poll   Ack.'
            + EOL);
  FOR portNr := 1 TO MAX_IFACE DO IF (nPort=PortNr) OR (nPort=0) THEN
    WITH axIFace[portnr] DO IF Valid THEN
      BEGIN
      TX_Info (pCB, SPAETER,
                f_using(portNr,1) + '. tx:' +
                f_Using(nITxBrutto,8)+
                f_Using(nRRTx,8)+
                f_Using(nRNRTx,8)+
                f_Using(nREJTx,8)+
                f_Using(nTxSvPolls,8)+
               '   '+
               fStr(nITxNetto)+'/'+fStr(nITxBrutto)
              );
      IF nITxBrutto <> 0 THEN TX_Info(pCB, SPAETER, '  '
                            + fStr(100*nITxNetto DIV nITxBrutto)+' %');
      TX_Info (pCB, SPAETER, EOL +
               '   rx:' +
               f_Using(nIrx,8)+
               f_Using(nRRrx,8)+
               f_Using(nRNRrx,8)+
               f_Using(nREJrx,8)+
               f_Using(nRxPolls,8)+
               EOL);
     END;
END;

{}


PROCEDURE PrintFlag ( pCB : TP_AXCB; b : BOOLEAN; s : STRING );
  VAR x : string[2];
BEGIN
  IF b THEN x := 'N'
       ELSE x := 'FF';
  s := s+':O'+x;
  SetStrLength( s, 16 * (Length (s) DIV 16+1) );
  IF Length(s) >= 70 THEN AddChar(s,EOL);
  TX_Info (pCB,SPAETER, s);
END;


PROCEDURE ListDigiPara (pCB:tp_axcb);
{* Das sind die allgemeinen Parameter die fr den ganzen Digi gelten *}
  VAR s : STRING;
      i : WORD;
BEGIN
  TX_Info (pCB, SPAETER, EOL
     + Datum (sysTime.Day,sysTime.Month,sysTime.Year) + ', '
     + UhrZeit (sysTime.Hour,SysTime.Min)
     + EOL
     + MYBAYCOMIDENT
     + EOL);

  PrintFlag( pCB, useTheNet,     'Net/ROM');
  PrintFlag( pCB, fLZMessungen,  'LZMess');
  PrintFlag( pCB, useFlexNet,    'FlexRout');
  PrintFlag( pCB, useTxDest,     'TxDest');

  PrintFlag( pCB, dnCallCheck,   'DnChk');
  PrintFlag( pCB, upCallCheck,   'UpChk');

  PrintFlag( pCB, useCvConnect,  'CvConnect');
  PrintFlag( pCB, useStopfen,    'Stopfen');
  PrintFlag( pCB, fDisplayFrames,'DispFr');

  FOR i := 1 TO MAXUSEFLAGS DO
     PrintFlag( pCB, use[i], scUseDesc[i] );

  IF pCB^.who=sysop THEN AddString(s, '  '+SysOpCall+' Log:'+FStr(wieLog) );

  IF useFind
    THEN s := '-Retry:'+FStr(findRetry)
    ELSE s := ' OFF';

  Tx_Info(pCB,SPAETER,
         'FMS:'+FStr(MyFlexMinSSID)+'/'+FStr(MyFlexMaxSSID)
       + '        Find' + s + EOL
       + 'TimeOut: ' + FStr(InfoboxTimeOut DIV (1000 DIV _ClkTick) DIV 60) + ' min.' +EOL
       + 'CvHosts:' + cvLINKCALL + EOL
  );
END;

PROCEDURE ListPortPara (pCB : TP_AXCB; selPortNr : Longint {Damit RangeChecking in dieser Routine stattfinden kann});
{* Liste der kanalbezogenen Parameter, selPortnr=255 -> alle zeigen *}
  VAR s : STRING[255];
      iReg,iDevNr : BYTE;
      l,wrkBindNr : LongInt;
BEGIN
  TX_Info (pCB, SPAETER, EOL);

  IF selPortNr=254 THEN
    BEGIN
    FOR iReg := 1 TO iRegister DO WITH register[iReg] DO
      FOR iDevNr := devNrVon TO devNrBis DO
        BEGIN
        s := '-- '
           + StrUsing( Register[iReg].sName+'-'+fStr(iDevNr),7) + ' ';
        l := ProcSetPara( iDevNr, spHOLEPARAMSTRING, 0 );
        IF l>0 THEN S :=s + TP_STRING( l )^;
        Tx_Info(pCB,SPAETER,s+EOL);
        END;
    Exit;
    END;

  FOR iReg := 1 TO iRegister DO WITH register[iReg] DO
    FOR iDevNr := devNrVon TO devNrBis DO
      BEGIN  {* Hole eine BindNr *}
      wrkBindNr := ProcSetPara( iDevNr, spHoleVAL, longint(hvBINDNR) );
      IF wrkBindNr > 0 THEN WITH bind[wrkBindNr] DO
        IF (selPortNr<>255) AND (devNrUp<>selPortNr)
          THEN wrkBindNr := 0 {* Den Port wollen wir nicht sehen *}
          ELSE BEGIN
               s := '-- '
                  + StrUsing(Register[ regNrUp ].sName+'-'+fStr(devNrUp),7) + ' '
                  + TP_STRING( DoUpSetPara(wrkBindNr, spHOLEPARAMSTRING, 0) )^
                  + EOL;
               Tx_Info(pCB,SPAETER,s);
               END;
      WHILE wrkBindNr > 0 DO WITH bind[wrkBindNr] DO
          BEGIN {* Weitere, niedere Schichten *}
          s :=  '   '
            + StrUsing(Register[ regNrDn ].sName+'-'+fStr(devNrDn) ,7)  +' '
            + TP_STRING( DoDnSetPara(wrkBindNr, spHOLEPARAMSTRING, 0) )^
            + EOL;
          wrkbindnr := register[regNrDn].bindNrUp[devnrDn]; {Wo bin ich als obere Schicht eingetragen?}
          Tx_Info(pCB,SPAETER,s);
          END;
      END;
  Tx_Trigger(pCB);
END;


PROCEDURE Toggle ( pcB:TP_AXCB;
                   VAR b : BOOLEAN; s : STRING;
                   VAR sArg : STRING; nrPara : WORD );
{* pCB kann auch nil sein... *}
  CONST COMANDS ='AUS OFF AN ON '; {* Letzte Leerzeichen ist wichtig *}
        ONOFFSCHWELLE = 3;
        cmdTab : ARRAY [1..length(COMANDS)] OF CHAR = COMANDS;
  VAR para : WORD;
BEGIN
  IF nrPARA <> NOTANUMBER  {* nrpara notwendig, da numerische Parameter vom Aufrufer weggenommen wurde *}
     THEN b := (nrpara<>0)
     ELSE BEGIN
          para := ScanStr ( sArg, @cmdTab, sizeOf (cmdTab));
          IF para > 0 THEN b := (para >= ONOFFSCHWELLE);
          END;
  PrintFlag (pCB,b,s);
END;



PROCEDURE DoParameter(pCB:tp_axcb; sArg : STRING);
{* Beispiel: PARA P1 FRACK 700 UINo P2 CHECKCALL *}
  CONST COMANDS1 =
{ 1}  'P1 P2 P3 P4 PORTNR TESTOMAT t r t c t rnrt '+
{13}  'r n p t r i d t '+
{21}  'DNCALLCHECK INFOBOXTIMEOUT l '+
{24}  'DIGISEARCH m TERMINAL FINDRETRY '+
{28}  'PFOERTNER l s u u u u ';
        comands2 =
{35}  'IFECHO p b s d LZMESS ' +
{41}  'STAT SIMPSPEZ FLEXNET UPCALLCHECK SMOOTHFRACK CVCONNECT ' +
{47}  'USER INTERLINK NRHINT CVHOST b BOXIFACE BOXPFAD ' +
{54}  'REORG TRANSLOG TRACE STOPFEN s CLKREG NRZI i ' +
{62}  'm f MAXFLEXSSID b TXDEST ';
        comands3 =
{67}  'MINFLEXSSID SYSOPCALL t d g a s '+
{74}  'UPDATE OLDPARA b i s GETVALUE SETVALUE CTEXT MYQTH '+
{83}  'P5 P6 P7 P8 MYNAME p RPS EWRITE a NETROM DISPFR m '+
      'LOG i CONHSSID p v TRACEINFO BC '; {* Das letzte Leerzeichen ist wichtig ! *}

  CONST cmPORTNR=5;               cmTEST=6;
        cmDNCALLCHECK=21; cmINFOBOXTIMEOUT=22;   cmDIGISEARCH=24;
        cmTERMINAL=26;    cmFINDRETRY=27;        cmPFOERTNER=28;
        CMIFECHO=35;
        cmLZMESS=40;      cmSTAT=41;
        cmFLEXNET=43;     cmUPCALLCHECK=44; cmSMOOTHFRACK=45;
        cmCVCONNECT=46;   cmUSER=47;        cmINTERLINK=48;   cmNRHINT=49;
        cmCVHOST=50;      cmBOXIFACE=52;    cmBOXPFAD=53;
        cmREORG=54;       cmTRANSLOG=55;    cmTRACE=56;       cmSTOPFEN=57;
        cmMAXFLEXSSID=64;
        cmTXDEST=66;      cmMINFLEXSSID=67; cmSysopCall=68;
        cmUPDATE=74;      cmOLDPARA=75;
                          cmGETVALUE=79;    cmSETVALUE=80;    cmCText=81;
        cmMYQTH=82;       cmP5=83;cmP6=84;  cmP7=85;cmP8=86;  cmMYNAME=87;
                          cmRPS=89;         cmEWRITE=90;
        cmNETROM=92;      cmDISPFR=93;      cmm=94;           cmLOG=95;
        cmCONHSSID=97;
        cmTRACEINFO=100;  cmBC=101;

  CONST cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
        cmdTab2: ARRAY [1..length(COMANDS2)] OF CHAR = COMANDS2;
        cmdTab3: ARRAY [1..length(COMANDS3)] OF CHAR = COMANDS3;
  VAR   x, portNr : BYTE;
        para,para2,i : Longint;
        sZwisp : STRING;
        ptmpCB : TP_AXCB;
BEGIN
  para := ScanForNum(sArg);
  IF para <> NOTANUMBER THEN {* erstes Argument ist eine Zahl *}
    BEGIN {* z.B. P 3 *}
    IF para = 0 THEN ListDigiPara (pCB)
                ELSE ListPortPara (pCB,para);
    Exit;
    END;
  IF (pCB^.who<>sysop) OR (sArg='') THEN
    BEGIN {* Nutzer. Oder der Sysop gab keine Parameter an *}
    ListDigiPara (pCB);
    ListPortPara (pCB,255);
    Exit;
    END;

  Portnr := 1;
{  FOR i := 1 TO MAX_IFACE DO reinit [i] := FALSE; }

  {* Absuchen, ob sich die Treiber angesprochen fhlen sollen, wenn ja ...}
  REPEAT
    IF ExecDriver(sArg)
      THEN x := 0  {* Jo, ist jetzt hier schon erledigt.  *}
      ELSE BEGIN
           x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
           IF x = 0 THEN
             BEGIN
             x := ScanStr ( sArg, @cmdTab2, sizeOf (cmdTab2));
             IF x <> 0 THEN Inc (x,34)
                       ELSE BEGIN
                            x := ScanStr ( sArg, @cmdTab3, sizeOf (cmdTab3));
                            IF x <> 0 THEN Inc (x,66);
                            END;
             END;
           END;
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}

    WITH axIFace[portNr] DO
    CASE x OF
      1..4    : portNr := x; {* P1..P4 *}
      cmP5,cmP6,cmP7,
      cmP8    : portNr := x-cmP5+5; {* P5..P8 *}
      cmPORTNR: IF (para >= 1) AND (para <= MAX_IFACE) THEN portnr := Para; {* PortNr *}
      cmDNCALLCHECK
              : Toggle (pCB,dnCallCheck, 'Check Down Call',sArg,para);
      cmUPCALLCHECK
              : Toggle (pCB,upCallCheck, 'Check Up Call',sArg,para);
      cmDIGISEARCH
              : Toggle (pCB,useFind, 'Find',sArg,para);
      cmINFOBOXTIMEOUT
              : BEGIN
                {$IFDEF scc}
                IF para < 45
                  THEN Tx_EolSysInfo(pCB,SPAETER,'mind.45 min.')
                  ELSE {$ENDIF}
                       InfoBoxTimeOut := para * 60 * (1000 DIV _ClkTick); {* INFOBOXTIMEOUT *}
                END;

      cmFINDRETRY
              : IF para<=50 THEN FindRetry := para;  {* FINDRETRY *}
      cmSTAT  : ;
      cmSMOOTHFRACK
              : BEGIN
{**                Toggle (useSmoothFrack, 'SmoothFrack',sArg,para);  }
                {* Wenn grade ausgeschaltet,.... *}
{**                 IF NOT useSmoothFrack THEN ResetDynPara(0);   **}
                END;
      cmCVCONNECT
              : Toggle (pCB, useCvConnect, 'CvConnect',sArg,para);
{$IFDEF NetROM}
      cmNRHINT,
      cmNETROM: Toggle (pCB, useTheNet, 'NetROM',sArg,para);
{$ENDIF}
      cmIFECHO: BEGIN {* p ifecho <ifnr>     (ifnr=0 -> aus) *}
                IF (para<=MAX_IFACE) THEN axifEcho := para;
                TX_EOLSysInfo (pCB,SPAETER,
                               +' Echo to axIf.'+FStr(axifEcho)
                               +EOL);
                END;
      cmTRACE : BEGIN {* p trace <if> <qsonr> [-[B][I][D][!]] [filterausdruck] *}
                IF (para<=MAX_IFACE) THEN
                  BEGIN
                  Trace.srcPort := para;
                  trace.idTraced := 0;
                  trace.idLauscher := 0;
                  IF para <> 0 THEN trace.idLauscher := pCB^.ID;
                  para2 := ScanForNum(sArg);
                  IF para2 < maxAXCB THEN
                    BEGIN
                    trace.idTraced := para2;
                    IF para2 <> 0 THEN BEGIN
                                       trace.srcPort := 0;
                                       trace.idLauscher := pCB^.ID;
                                       END;
                    ScanForText(sArg,sZwisp);
                    Trace.fBody := FALSE;
                    Trace.fBodyHexDump := FALSE;
                    Trace.fBodyOnlyInfo := FALSE;
                    Trace.fExclFilter   := FALSE;
                    IF sZwisp[1] = '-' THEN
                      BEGIN
                      trace.fBody         := Pos('B',sZwisp) > 0;
                      trace.fBodyOnlyInfo := Pos('I',sZwisp) > 0;
                      trace.fBodyHexDump  := Pos('D',sZwisp) > 0;
                      trace.fExclFilter   := Pos('!',sZwisp) > 0;
                      sZwisp := sArg;
                      END;
                    trace.sFilter := sZwisp;
                    sArg := '';
                    END;
                  END;
                TX_EOLSysInfo (pCB,SPAETER,
                   'QsoId.'+ FStr(Trace.idLauscher)
                   + ' <- Port:'   + FStr(Trace.SrcPort)
                   +' QSO:'        + FStr(Trace.idTraced)
                   +' showBody:'   + f_Bool2OnOff(Trace.fBody)
                   +' hexBody:'    + f_Bool2OnOff(Trace.fBodyHexDump)
                   +' nurInfoFr.:' + f_Bool2OnOff(Trace.fBodyOnlyInfo)
                   +' ExclFil.:'   + f_Bool2OnOff(Trace.fExclFilter)
                   +' Filter:'     + trace.sFilter
                   + EOL);
                END;
      cmTRACEINFO
              : BEGIN
                Toggle (pCB,Trace.fInfo, 'Info Trace',sArg,para);
                IF Trace.fInfo THEN
                  BEGIN
                  Trace.idLauscher := pCB^.ID;
                  Trace.SrcPort := 0; {* paralell is nicht, dennwenn 2 Sysops gleichzeitig....*}
                  Trace.idtraced := 0; {* dto. *}
                  ScanForText(sArg,sZwisp);
                  Trace.sFilter := sZwisp;
                  END;
                TX_EOLSysInfo (pCB,SPAETER,
                                'QsoId:'+FStr(Trace.idLauscher)
                               +' <- f:'+Trace.sFilter
                               +EOL);
                END;
      cmBC : BEGIN
{$IFDEF BroadCast}
             IF para < 9 THEN
               BEGIN
               BcPort := para;
               ScanForText(sArg,sZwisp);
               AscCall2shift ( f_Upper(sZwisp), BcShMyCall);
               ScanForText(sArg,sZwisp);
               AscCall2shift ( f_Upper(sZwisp), BcShBoxCall);
{               sBCViaPath:=sArg;
               Trim(sBCViaPath);
               IF sBCViaPath<>'' THEN
                 BEGIN
                 Upper(sBCViaPath);
                 IF sBCViaPath[1]<>',' THEN sBCViaPath:=','+sBCViaPath;
                 END; }
               END;
             TX_EOLSysInfo (pCB,SPAETER,FStr(BcPort)
                            +' My:'+f_sh2Asc(BcShMyCall)
                            +' Box:'+f_sh2Asc(BcShBoxCall)
                    {        +' ...'+sBCViaPath }
                            +EOL);
{$ENDIF}
             END;

      cmUSER  : art := aUSER;
      cmINTERLINK
              : art := aINTERLINK;
      cmTERMINAL
              : art := aTERMINAL;
      cmCVHOST: BEGIN
                ScanForText(sArg,sZwisp);
                cvLINKCALL := f_Upper(Copy(sZwisp,1,SizeOf(cvLINKCALL)-1))+' ';
                END;
      cmBOXIFACE
              : IF para <> NOTANUMBER THEN boxIFACE := para;
      cmBOXPFAD
              : BEGIN
                boxPfad := sArg; sArg := '';
                END;
      cmSYSOPCALL
              : BEGIN
                ScanForText(sArg,Sysopcall);
                Upper(Sysopcall);
                END;
      cmTRANSLOG
              : TransferLog;
      cmSTOPFEN
              : Toggle (pCB, useStopfen, 'Stopfen',sArg,para);
{$IFDEF LZM}
      cmLZMESS: Toggle (pCB, fLZMessungen, 'LZ-Mess',sArg,para);
      cmMINFLEXSSID {* Eigentlich nicht Flexnet sondern LZM abhngig ... *}
              : IF para <= 15 THEN MyFlexMinSSID := para;
      cmMAXFLEXSSID {* Eigentlich nicht Flexnet sondern LZM abhngig ... *}
              : IF para <= 15 THEN MyFlexMaxSSID := para;
{$ENDIF}
{$IFDEF FlexNet}
      cmREORG : BEGIN
                para := nZiel;
                ReorgZiele;
                TX_EolSysInfo (pCB, SPAETER,fStr(para)+'/'+FStr(nZiel) );
                END;
      cmFLEXNET
              : Toggle (pCB,useFlexNet, 'FlexNet',sArg,para);
      cmTXDEST: Toggle (pCB,useTxDest,'TxDest',sArg,para);
{$ENDIF}
{      cmGETVALUE
              : TX_EOLSYSInfo(pCB,SPAETER,'Value:'+
                  fStr(bind [Portnr].fnSetPara ( Portnr, spGETVALUE, para )) );
     cmSETVALUE
              : BEGIN
                para2 := ScanforNum(sArg);
                IF para2 <> NOTANUMBER THEN
                  TX_EOLSYSInfo(pCB,SPAETER,'Return:'+
                      fStr(bind [Portnr].fnSetPara ( Portnr, T_setPara(para), para2 ))
                      );
                END;
}      cmCText : BEGIN
                IF (sArg <> '') THEN
                  BEGIN
                  sCText := sArg;
                  sArg := '';
                  END;
                TX_EolSysInfo (pCB, SPAETER, '"'+sCText+'"' + EOL );
                END;
      cmMYQTH : BEGIN
                ScanForText(sArg,sZwisp);
                IF (length(sZwisp)=6) THEN myQTH:=f_Upper(sZwisp);
                TX_EOLSysInfo (pCB, SOFORT, myQTH );
                END;
      cmUPDATE: IF fBigEEPROM
                  THEN Tx_EolSysInfo (pCB, SPAETER,'no, bigEEPROM detected - use WRITE EEPROM!')
                  ELSE IF UpdateEEPROM THEN Tx_EolSysInfo (pCB, SPAETER,'ok, Port 1-'+FStr(EEMAXIFACE));
      cmOLDPARA
              : MakeEEPROMInvalid;
{$IFnDEF USERWARE}
      cmMYNAME: BEGIN
                ScanForText(sArg,MYBAYCOMIDENT);
                Upper(MYBAYCOMIDENT);
                END;
      cmDISPFR: Toggle (pCB,fDisplayFrames, 'DispFr',sArg,para);
{*
 *     cmROUTEUNKNOWN
 *             : Toggle (pCB,RouteUnknown, 'RouteUnknown',sArg,para);
 *}
{$ENDIF}
      cmRPS   : BEGIN
{                minRPS   := 999999;
                minRPS1H := 999999;
                TX_EolSysInfo (pCB, SPAETER, 'RPS del.');
}                END;
      cmLOG   : BEGIN (* dg6may: statistik im log *)
                IF (para <> NOTANUMBER) AND (para <= 255) THEN wieLog:= para;
                TX_EolSysInfo(pCB,SPAETER,'Log: '+FStr(wielog)+'d '+binstring(lo(wielog)));
                END;
      cmPFOERTNER
              : BEGIN
                IF para=42
                  THEN Pfoertner(pCB) {* Connect durchfhren *}
                  ELSE BEGIN
                       IF (para<=MAX_IFACE) AND (para<> pCB^.iface) THEN
                         BEGIN
                         PfoertPort := para;
                         ScanForText(sArg,sZwisp);
                         sPfoertFm := sZwisp;
                         ScanForText(sArg,sZwisp);
                         sPfoertTo := sZwisp;
                         sPfoertVia := sArg;
                         sArg := '';
                         END;
                       TX_EOLSysInfo (pCB,SPAETER,FStr(PfoertPort)
                                      +': '+sPfoertFm+' > ' +sPfoertTo+ ' v '+sPfoertVia
                                      +EOL);
                       END;
                END;
      cmCONHSSID
              : IF (para<=15) THEN SSIDCvConnect := para;
{$IFDEF neverdef}
      cmTEST :
        BEGIN
        IF (para<=MAX_IFACE) AND (para>0) THEN
          BEGIN
          para2 := ScanForNum(sArg);
          ScanForText(sArg,sZwisp);
          sPfoertFm := sZwisp;
          ScanForText(sArg,sZwisp);
          sPfoertTo := sZwisp;
          sPfoertVia := sArg;
          sArg := '';
          pTmpCB := CreateAXCB(para);
          Asc2axcb ( sPfoertFm,sPfoertTo,sPfoertVia, ptmpCB );
          FOR i := 1 to para2 DO
            BEGIN
            Tx_FRMR ( ptmpCB, nil, 0,0,0,0);
            eND;
          END;
        END;
{$ENDIF}
          ELSE BEGIN
               IF sArg <> '' THEN Tx_EolSysInfo (pCB, SPAETER,'bad argument: '+sArg);
               END

      END;
  UNTIL x = 0;

{  FOR i := 1 TO MAX_IFACE DO
    IF reinit[i] AND bind[i].valid THEN
      BEGIN
      li := bind[Portnr].fnSetPara( Portnr, spREINIT, 0 );
      IF li = 0
        THEN Tx_EolSysInfo (pCB, SOFORT,'OK ReInit Port '+FStr(i))
        ELSE Tx_EolSysInfo (pCB, SOFORT,'Error '+fStr(li)+': InitPort '+FStr(i));
      END;
}
END;


{}
{$F+}
PROCEDURE fMsgWriteText ( pCB : tp_Axcb; msg : T_Msg); {$F-}
{* Msg.Handler fr Upload von Texten des Sysops.
 * In pCB^.pDIV ist der Zeiger auf die zugeh. Text-Struktur.
 * Die RXQ wird solange nicht geleert, bis ein CTRL-Z auftaucht.
 * Danach wird die RXQ komplett dem vorher angegebenen Text zugeschlagen
 *}
  CONST endstring : ARRAY [1..2] OF Str6 = ('/EX','***END');
  VAR zielOfs,i : WORD;
      pTxt      : tp_text;
      p         : POINTER;
BEGIN
  CASE msg OF
    msgRx :
      BEGIN {* Diese Absucherei ist nicht besonders effektiv, aber *}
            {* WRITE ist ja auch kein hauefig verwendetes Kommando *}
      WatchDog;
      Inc(pCB^.RxWind,30000); {* $Hack,Hack Man kann ja keine Texte schrieben, die grsser als RxWindow sind... *}
      {* Wir suchen Ctrl-Z *}
      PeekQueueData (pCB^.RxBuf, pCB^.RxBufSize, ^Z, zielOfs, p );
      IF zielOfs <> 0
        THEN char(p^) := ' '  {* Da steht noch ^Z drauf; na ja, nich so doll... *}
        ELSE BEGIN {* Dann nach dem anderen String suchen *}
             zielOfs := 0;
             FOR i := 1 TO 2 DO
              IF zielofs = 0 THEN
                BEGIN
                PeekQueueData (pCB^.RxBuf, pCB^.RxBufSize, endstring[i][1], zielOfs, p );
                IF (zielOfs >= length(endstring[i])+1) AND
                   MemEq ( p, @endstring[i][1], length(endstring[i]) )
                  THEN BEGIN {* Lschen von ***END o.. aus dem Buffer... *}
                       FillChar ( p^, length(endstring[i])+1, ' ' );
                       END
                  ELSE zielOfs := 0; {* Fehler: wenn ein einziger Stern im Text  *}
                                     {* auftaucht, funktioniert ***END nich mehr *}
                END;
             END;

      IF maxWriteSize > 0 THEN
         IF pCB^.RxBufSize > maxWriteSize THEN zielOfs := pCB^.RxBufSize;

      IF zielOfs <> 0 THEN
        BEGIN {* Text ist ganz eingegeben. Das CR nach dem ^Z ist auch noch im Speicher! *}
        pTxt := pCB^.Divers.pText;
        Del_mBuf_chain (pTxt^.pmText); {* alten Text lschen *}
        IF zielofs > 1 THEN pTxt^.Size := zielOfs-1 ; {* Alles nach ^Z (incl.) interessiert nicht *}
        pTxt^.WriteTime := systime;
        pTxt^.ReadCount := 0;
        {* $OPT: Komprimieren zu einem Block GET_MBuf (pTxt^.pMText, pTxt^.size) *}
        {*       Dann mus fd_tx.pm2frame gendert werden (STOPFEN !)             *}
        {* Kette nun umhngen *}
        pTxt^.pmText := pCB^.RxBuf;
        pCB^.RxBuf := Nil;
        pCB^.RxBufSize := 0;
        TX_EolSysInfo (pCB, SOFORT, 'write ok: '+FStr(pTxt^.Size)+' Byte');
        {* ... und alles auf Anfang *}
        Dec(pCB^.RxWind,30000); {* $Hack,Hack Man kann ja keine Texte schrieben, die grsser als RxWindow sind... *}
        pCB^.fMsgHandler := fnMsgInfoBox;
        maxWriteSize := 0; {* Default: Keine Maxgroesse fuers nchste Write *}
        pCB^.divers.pText := NiL; {* Sauber san 'mer scho ! *}
        DoPrompt (pCB);
        END;
      END;
    ELSE fnMsgDefault ( pCB, msg );
   END;
END;



FUNCTION DoWrite ( pCB:tp_axcb; sArg:STRING) : BOOLEAN;
{* RETURNs TRUE, wenn erfolgreich *}
  VAR neu : BOOLEAN;
      i,lastfree : WORD;
      flHidden,ende,fcdir: BOOLEAN;
      sWrk : STRING;
BEGIN
  DoWrite := FALSE; neu := FALSE;
  fcdir := FALSE; flHidden := FALSE;
  pCB^.divers.pText := NiL;
  ScanForText (sArg, sWrk);
  IF F_Upper( sWrk ) = 'CDIR' THEN
    BEGIN
    fcdir := TRUE;
    ScanForText (sArg, sWrk);
    END;
  IF F_Upper( sWrk ) = 'HIDDEN' THEN
    BEGIN
    flHidden := TRUE;
    ScanForText (sArg, sWrk);
    END;
  IF sWrk <> '' THEN
    BEGIN
    Upper(sWrk);

    i := Abs(FindText(sWrk));

    IF (i<= MAXTXT) AND (i>0) THEN
      BEGIN {* Wir knnen was schreiben *}
      IF fCdir AND (sArg='') THEN sArg := sWrk; {* Ein Titel muss vorhanden sein wenn es im CTEXT erscheinen soll *}
      MemGet ( pointer(apText[i]), sizeof(apText[i]^) );
      WITH apText[i]^ DO
        BEGIN
        Name   := sWrk;
        sTitel := sArg;
        pMem   := nil;
        pmText := NiL;
        size   := 0;
        readCount := 0;
        cdir    := fcdir;
        fHidden := flHidden;
        FillChar (writetime, sizeof(writetime),#0);
        END;
      pCB^.divers.pText := apText[i];
      END;
    END;

  IF pCB^.divers.pText = Nil
    THEN TX_EolSysInfo (pCB, SOFORT,'can''t write')
    ELSE BEGIN
         TX_EolSysInfo (pCB, SOFORT,'start write, end with Ctrl-z or ***END in first column'+EOL);
         pCB^.fMsgHandler := fMsgWriteText;
         DoWrite := TRUE;
         END;
END;

{}
PROCEDURE BinCalcCRC (p : Pointer; len : WORD);
{* crc-Berechnung #bin# maessig. von dh1dae *}
VAR
  HiBit : Boolean;
  Shift : Integer;
  i     : WORD;
BEGIN
 FOR i := 1 TO len DO
   BEGIN
   Shift := $80;
   REPEAT
     HiBit := ulCRC AND $8000 > 0;
     ulCRC := ulCRC Shl 1;
     IF (byte(p^) AND Shift) > 0 THEN ulCRC := ulCRC OR 1;
     IF HiBit THEN ulCRC := ulCRC XOR $1021;
     Shift := Shift SHR 1;
   UNTIL Shift = 0;
   Inc (word(p)); {* Au weia... *}
   END;
END;

{$F+}
PROCEDURE fnMsgUpLoad ( pCB : tp_Axcb; msg : T_Msg);
 {* Msg.Handler fr Upload von DigiWare-Updates des Sysops. *}
 {* Das Verfahren entspricht dem von GP, SP und SuperKiss,  *}
 {* jedoch mit eigener Prfsumme. Der INT FF-Code wird von  *}
 {* FALCldr dazu gebunden.                                  *}
 {* $TODO: Konzept verallgemineren, so dass auch anderes    *}
 {* Hochgeladen werden kann *}
  VAR zwisp : WORD;
      pTxt  : ^t_text;
      p     : POINTER;
      pm    : tp_mBuf;
      info  : STRING;

PROCEDURE StopUpLoad;
BEGIN
  WatchDog;
  IF NOT ulFake THEN
    BEGIN
    ASM
      PUSH  bp
      push  ds
      mov   ah,2 {* Funktionscode fr beenden *}
      stc        {* Default: Fehler *}
      int   0ffh
      pop   ds
      pop   bp
    END;
    END;
  ulState := NULL;
  ulLen := 0;
  pCB^.fMsgHandler := fnMsgInfoBox;
  DoPrompt (pCB);
END;

PROCEDURE MoveThem;
BEGIN
  pm := GetMBufFromQueue ( pCB^.RxBuf ); {* Hole allerersten Buffer *}
  WHILE pm <> Nil DO
    BEGIN
    Dec (ulLen, pm^.inUse);
    IF NOT ulFake THEN
      BEGIN
      Move (pm^.pData^, pULZiel^, pm^.inUse);  {* Daten kopieren *}
      {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
      {* Zeigerarithmetik in pAscal, damit n > 64k werden kann :-( *}
      Inc ( L2W(pULZiel).ofs, pm^.inUse);
      Inc ( L2W(pULZiel).seg, L2W(pULZiel).ofs DIV 16 );
      L2W(pULZiel).ofs := L2W(pULZiel).ofs AND 15;
      {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
      END;
    BinCalcCRC (pm^.pData, pm^.inUse); {* CRC-Berechnung  la #BIN# *}
    Inc ( ulByte, pm^.inUse );
    Dec ( pCB^.RxBufSize, pm^.inUse );
    Del_mBuf ( pm ); {* Alles muss man selber machen :-)  s.FD_SUBR.GetMBufQueue *}
    IF ulLen > 0
      THEN pm := GetMBufFromQueue ( pCB^.RxBuf ) {* und der Naechste bitte *}
      ELSE BEGIN {* Es ist alles uebertragen *}
           ulFastTickStart := ((FastTick-ulFastTickStart) DIV 100)+1;
           TX_Info (pCB, SPAETER,EOL
                   + cDTW+': Upload OK, CRC='+FStr(ulCRC)+EOL+
                    + '      Bytes='+fStr(ulByte)
                    + ', Zeit='+Sekunden2RelString(ulFastTickStart)+' ,'
                    + ' Baud='+ fStr(8*ulByte DIV ulFastTickStart)
                    + BELL + EOL);
           StopUpLoad;
           pm := NiL; {* Schleife beenden *}
           END;
    END; {* WHILE *}
END;


PROCEDURE WaitBin;
  LABEL l_Ok;
  VAR b : BYTE;
      failure : WORD;
BEGIN
  Info := FrameInfo2Str (pCB);   {* Get RXq-Zeile: *}
  IF (Pos ('#NO#', INFO ) > 0) OR (Pos ('#ABORT#', INFO ) > 0)
    THEN BEGIN {* und tschuess *}
         TX_EolSysInfo (pCB, SOFORT, 'Upload aborted'+EOL);
         StopUpLoad;
         END
    ELSE IF Pos ('#BIN#', INFO ) > 0 THEN
           BEGIN
           b := Pos ('#BIN#', INFO )+5;
           ulLen := 0;
           WHILE (Info[b] >= '0') AND (Info[b] <= '9') AND (b<=Length(info)) DO
             BEGIN
             ulLen := 10*ulLen + ( byte(info[b]) - byte ('0') );
             Inc (b);
             END;
           IF ulLen <> 0 THEN
             BEGIN
             failure := 0;
             IF ulFake THEN GOTO l_OK;
               ASM
               push  bp
               push  ds
               mov   ah,0  {* Funktion 0: Remote Status abfragen  *}
               stc         {* Default: Fehler *}
               int   0ffh
               pop   ds
               pop   bp
               mov   word ptr [failure],ax
               jc    @@a1
               mov   word ptr [failure],0
               cmp   bl,2  {* luft Remote Programm schon ? *}
               jb    @@a1
               mov   word ptr [failure],4  {* ja!: Funktion nicht im Remote Betrieb nutzbar *}
              @@a1:
               END;
             END;
           IF (ulLen = 0) OR (failure<>0)
             THEN TX_EOLSysInfo (pCB, SOFORT, 'Error0: '+FStr(failure)+EOL)
             ELSE BEGIN
                  pUlZiel := NiL;
                  ASM
                    push  bp
                    push  ds
                    mov   ah,1  {* Funktion 1: Open Remote. Remote RAM zum Schreiben ffnen. *}
                    mov   bx,word ptr [ullen+2] {* Remote Lnge setzen *}
                    mov   cx,word ptr [ullen]
                    add   cx,15        {* MOD 16 machen *}
                    and   cx, NOT 15
                    int   0ffh
                    pop   ds
                    pop   bp
                    mov   word ptr [failure],ax
                    jc    @@a2
                    mov   word ptr [failure],0
                    mov   word ptr [pUlZiel+2],AX {* erstes Segment an die der Code transferiert werden mu. *}
                    mov   word ptr [pUlZiel],0
                    @@a2:
                  END;
                 l_ok:
                  IF Failure = 0
                    THEN BEGIN {* und loslegen *}
                         TX_Info (pCB, SOFORT, '#OK#'+EOL);
                         ulState := INPROGRESS;
                         ulCRC := 0;
                         ulByte := 0;
                         ulFastTickStart := FastTick;
                         END
                    ELSE BEGIN
                         TX_EOLSysInfo (pCB, SOFORT, 'Error1: '+FStr(failure)+EOL);
                         ulState := Wait;
                         END;
                  END;
             END;
END; {* WaitBin *}

BEGIN
  CASE msg OF
    msgRx   : BEGIN
              IF ulState = Wait
                THEN WaitBIN
                ELSE IF ulState = inProgress
                       THEN MoveThem
                       ELSE StopUpLoad;
              END;
    msgRetryCountExceeded,
    msgCBdel,
    msgDiscReq,
    msgRxDM : BEGIN {* Verbindung getrennt *}
              StopUpLoad;
              END;
    ELSE fnMsgDefault ( pCB, msg );
    END; {*case*}
END;


PROCEDURE DoUpLoad (pCB:tp_axcb; fFake : BOOLEAN);
  VAR s : STRING;
BEGIN
  IF ulState <> NULL
    THEN TX_Info (pCB, SOFORT,EOL+'#NO#'+EOL+'*** upload already in progress'+fstr(ulid) +EOL)
    ELSE BEGIN
         ulId := pCB^.id;
         ulState := WAIT;
         ulLen := 0;
         ulFake := fFake;
         IF ulFake THEN s := 'start faking'
                   ELSE s := 'start upload';
         Tx_EolSysInfo (pCB, SOFORT,s+' using AutoBIN'+EOL);
         pCB^.fMsgHandler := fnMsgUpLoad;
         END;
END;


{}


{$F+}
PROCEDURE fnMsgDownLoad ( pCB : tp_Axcb; msg : T_Msg);
 {* Msg.Handler fr Downoad zum Testen von Speed etc. *}
  VAR sinfo  : STRING;
      i     : BYTE;

  PROCEDURE WaitOK;
  BEGIN
  sInfo := FrameInfo2Str (pCB);   {* Get RXq-Zeile: *}
  IF Pos ('#OK#', sINFO ) > 0
    THEN BEGIN
         ulState := INPROGRESS;
         ulCRC := 0;
         ulByte := 0;
         ulFastTickStart := FastTick;
         END
    ELSE BEGIN {* Abbruch *}
         TX_EolSysInfo (pCB, SOFORT, 'Download aborted'+EOL);
         ulState := NULL;
         pCB^.fMsgHandler := fnMsgInfoBox;
         END;
  END; {* WaitBin *}

BEGIN
  CASE msg OF
    msgRx   : BEGIN
              IF ulState = Wait THEN
                BEGIN
                WaitOK;
                fnMsgDownLoad(pCB,msgTx); {* Und Anstoen des Krams *}
                END;
              END;
    msgTx : IF ulState = INPROGRESS THEN
              BEGIN {* $IDEE: in der PC Version knnte man ja wirklich nen File schicken... *}
              FOR i := 0 TO 255 DO sInfo[255-i] := Char(Random(i));
              sInfo := fStr(ulLen);
              WHILE (ulLen > 0 ) AND (pCB^.TxBufSize < 5*pCB^.txWind) DO
                BEGIN
                IF ulLen<256 THEN sInfo[0] := char(ulLen)
                             ELSE sInfo[0] := #255;
                BinCalcCRC ( @sInfo[1], Length(sInfo)); {* CRC-Berechnung  la #BIN# *}
                TX_Info(pCB,SOFORT,sInfo);
                Inc(ulByte,Length(sInfo));
                Dec(ulLen,Length(sInfo));
                END;

              IF ulLen <= 0 THEN
                BEGIN
                ulFastTickStart := 1+(FastTick-ulFastTickStart) DIV 100;
                TX_Info (pCB, SPAETER,EOL+EOL
                      +cDTW+': ready, CRC='+FStr(ulCRC)+EOL+
                      + '      Bytes='+fStr(ulByte)
                      + ', Zeit='+Sekunden2RelString(ulFastTickStart)+','
                      + ' Baud='+ fStr(8*ulByte DIV ulFastTickStart)
                      + BELL + EOL);
                ulState := NULL;
                pCB^.fMsgHandler := fnMsgInfoBox;
                DoPrompt (pCB);
                END;
              Tx_Trigger(pCB);
              END;

    msgRetryCountExceeded,
    msgCBdel,
    msgDiscReq,
    msgRxDM : BEGIN {* Verbindung getrennt *}
              ulState := NULL;
              pCB^.fMsgHandler := fnMsgInfoBox;
              END;
    ELSE fnMsgDefault ( pCB, msg );
    END; {*case*}
END;


FUNCTION DoDownLoad (pCB:tp_axcb; len : longint) : BOOLEAN;
  {* Sende nach *pCB* *len* Zeichen nach dem AutoBin-Verfahren *}
BEGIN
  DoDownLoad := FALSE;
  IF len < 1 THEN Exit;
  IF ulState <> NULL
    THEN TX_EolSysInfo (pCB, SOFORT,'xLoad already in progress '+fstr(ulid)+EOL)
    ELSE BEGIN
         ulId := pCB^.id;
         ulLen := len;
         Tx_Info (pCB, SOFORT,EOL+'#BIN#'+fStr(len)+'#'+EOL);
         ulState := WAIT;
         pCB^.fMsgHandler := fnMsgDownLoad;
         DoDownLoad := TRUE;
         END;
END;

{}

PROCEDURE DoRestart ( pCB : tp_axcb; VAR sArg : STRING);
  VAR count   : BYTE;
      error   : INTEGER;
      failure : WORD;
BEGIN
  Val (sArg,count,error);  {* Anzahl holen *}
  IF error <> 0
    THEN BEGIN
         IF pCB <> NiL THEN TX_EolSysInfo (pCB,SOFORT,'bad Argument')
         END
    ELSE BEGIN
         IF count=29 THEN Backup.Magic := 0;
{$IFDEF scc}
         SABMmode := smUA; {* sicher ist sicher *}
         {$IFDEF Doku}
         * Funktion 5: Patchadresse setzen                   *
         * Aufrufparameter: ah = 5                           *
         *                  ds:dx = Zeiger auf Patchbereich  *
         *                  cx = Lnge des Patchbereiches    *
         * Rckgabeparamter: wenn kein Fehler auftritt       *
         *                  (Carry rckgesetzt) keine        *
         {$ENDIF}
         Failure := 0;
         ASM;
          push  DS
          push  BP

{$IFDEF sdfsfdsd}
          MOV   ah,5
          MOV   cx, 2000 {**[lenPatch]   {* Erstmal *}
          MOV   dx,offset FD_Patch
          MOV   ax,seg    FD_Patch
          MOV   ds,ax
          INT   0ffh
          add   ax,20
          JC    @@1
{$ELSE}
          MOV  ax,$FF00
          MOV  es,ax
          MOV  dl,byte Ptr ES:[$0f10]         {* merken *}
          AND  Byte Ptr ES:[$0f10], NOT $08   {* Schreibschutz aufheben *}

          MOV  ax,$FFD8
          MOV  es,ax
          Mov  ax,[lenPatch]
          MOV  word Ptr ES:[$0001],ax
          MOV  word Ptr ES:[$0003], offset FD_Patch
          MOV  word Ptr ES:[$0005], seg    FD_Patch

          Mov  ax,$FF00
          MOV  es,ax
          MOV  byte Ptr ES:[$0f10],dl
{$ENDIF}

{$IFDEF Doku}
  {* Funktion 3: Start Remote/set auto Count
   *  Remote Programm starten und Anzahl der Restarts setzen. Ist kein Remote
   *  Programm vorhanden, wird automatisch der Epromcode aktiviert.
   *  Auto Count gibt an wie oft ein evtl. vorhandenes Remote Programm nach
   *  Resets wieder aktiviert wird.*
   *  Auto Count = 0 schaltet direkt auf den Epromcode um
   * Aufrufparameter: ah = 3                           *
   *                  al = Auto Count                  *
   * Funktion kehrt nicht zurck !!                    *
   *}
{$ENDIF}
          MOV   ax,seg @Data
          MOV   ds,ax
          mov   ah,3
          mov   al, byte ptr [count]
          int   0ffh  {* never come back *}
@@1:      pop   bp  {* falls doch :) *}
          pop   ds
          mov   [failure],ax
         END;
{$ENDIF}
         IF pCB <> NiL THEN TX_EolSysInfo (pCB,SOFORT,'restart failed:'+ FStr(failure) );
         END;
END;


FUNCTION GetRemoteStatus : STRING;
 CONST sMode : ARRAY [0..2] OF STRING[3] = ('+Er', '+ER', 'ER+');
  VAR maxLen : LongInt;
      mode, astCount : BYTE;
      uplSeg, epromSeg, failure : WORD;
      RAMhi,Ramlo : BYTE;
BEGIN
  IF ulState <> INPROGRESS
    THEN BEGIN {* Uploadstate kontolieren *}
         ASM
         push  bp
         push  ds
         mov   ah,0
         stc          {* Carryflag setzen, damit Fehler der Defaultfall ist, falls kein Handler installiert ist *}
         int   0FFh
         pop   ds
         pop   bp
         mov   word ptr [failure],ax
         jc    @@failed
         mov   word ptr [failure],0
         mov   word ptr [maxlen+2],dx;
         mov   word ptr [maxlen],ax
         mov   byte ptr [mode],bl
         mov   astCount,bh
         mov   uplseg,di
         mov   epromseg,si
         mov   RAMlo,cl
         mov   RAMhi,ch
       @@failed:
         END;
         IF failure <> 0
            THEN GetRemoteStatus := 'Remote-Err:'+FStr(failure)+EOL
            ELSE GetRemoteStatus := 'AStCnt:'+FStr(astCount) +
                                    ' ULSeg:'+ HexString (uplSeg) +
                                    ' EPROM:'+ HexString (epromSeg)+EOL+
                                    'maxLen:'+fStr(maxLen)+
                                    ' RAM:'+ HexByteString (RAMlo)+'/'+HexByteString (RAMhi)+
				 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
				    ' '+ sMode [ Mode ] +EOL;
				 {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
         END
    ELSE GetRemoteStatus := 'Uploading... '
                             + FStr(ord(ulState)) + ' '
                             + fStr(ulLen) + EOL ;
END;


{}

{$F+}
PROCEDURE fSABMmode ( p : POINTER ); FAR; {$IFNDEF AllFar} {$F-} {$ENDIF}
BEGIN
  SABMmode := smUA;
  StopTimer (timSABMmode);
  IF tp_axcb(p)^.state = CONNECTED THEN
    IF tp_axcb(p)^.who=sysop THEN {* Isser noch ein Sysop ? *}
      TX_EolSysInfo( tp_axcb(p),SOFORT, BELL+'sysbusy auto off'+EOL);
END;


PROCEDURE DoSysBusy  ( pCB : TP_axcb; sArg : STRING );
  {* verbietet und erlaubt das Einsteigen von neuen Staionen *}
  VAR tickinit,
      minuten : LongInt;
      mode : WORD;
BEGIN
  IF sArg <> '' THEN
    BEGIN
    minuten := ScanForNum(sArg);
    mode := ScanForNum(sArg);

    StopTimer (timSABMmode);
    IF (minuten > 0) AND (minuten <> NOTaNUMBER)
      THEN BEGIN
           IF (mode > MAX_IFACE) OR (mode <= 0) THEN mode := smDMAll; {* Alle Interface sperren *}
           tickInit := minuten*60* _Sekunden;
           InitTimer (timSABMmode,tickInit); {* Damit nach einiger Zeit alles wieder normal lauft *}
           timSABMmode.timerfunction := fSABMmode;
           timSABMmode.arg := pCB;
           StartTimer (timSABMmode);
           SABMmode := mode;
           END
      ELSE BEGIN
           SABMmode := smUA;
           END;
      END;
  TX_EolSysInfo (pCB, SOFORT,'SABMmode: '+FStr(SABMmode)+'/'+fStr(TimerGetRemain(timSABMmode)) );
END;



PROCEDURE DoTell ( pCB : TP_axcb; arg : STRING );
{* pCB (absender) darf auch nil sein *}
 VAR s,sRes   : String;
     i,n      : WORD;
     pPartner : tp_AXCB;
BEGIN
 i := Pos (' ',arg);
 s := copy (arg, i,255); {* lse Message heraus *}
 arg := Copy (arg, 1, i );
 sRes := '';
 IF (F_Upper(arg) = 'BROADCAST ') OR (pCB=nil)
   THEN BEGIN
        n := 0;
        FOR i := 1 TO maxAXCB DO
          IF cb[i] <> NiL THEN
            IF cb[i]^.qsoType IN [qtInfoBox,qtConvers{* $TODO: qtCQ?!? *}] THEN
              BEGIN
              IF pCB = nil   {Hackhack}
                THEN TX_EolSysInfo ( cb[i],SOFORT,
                      BELL+'(BROADCAST from SYSTEM):'+EOL
                      + arg + ' ' + s +  EOL) {Hackhack}
                ELSE TX_EolSysInfo ( cb[i],SOFORT,
                      BELL+'BROADCAST from '+f_sh2asc(pCB^.toCall)+' (Sysop '+axIFace[1].asMyCall+'):'+
                      EOL+      s+EOL);
              Inc(n);
              END;
        sRes := ' msg. txed '+FStr(n)+' times';
        END
   ELSE BEGIN
        SucheCallInDigi ( arg, scmJeder, pPartner );
        IF pPartner <> NiL
          THEN BEGIN
               TX_EolSysInfo (pPartner,SOFORT,
                   BELL+'Message from '+f_sh2asc(pCB^.toCall)+' (SYSOP '+axIFace[1].asMyCall+'):'+
                   EOL+ s +EOL);
               sRes := 'msg. transmitted to '+f_sh2asc(pPartner^.toCall)
                      +' Ofs:'+FStr(pPartner^.txBufSize);
               END
          ELSE sRes := arg+' not found';
        END;
 IF sRes <> '' THEN TX_EolSysInfo (pCB,SOFORT, sRes+EOL);
{ 24950H 2AA96H 06147H FD_SYSOP           CODE }
END;

{}

PROCEDURE ListWatch (pCB : TP_AXCB);
  VAR i : BYTE;
      s : String;
BEGIN
  FOR i := 1 TO nWatch DO WITH Watch[i] DO {* per Defin. ist Watch[1..nWatch] gltig *}
    BEGIN
    s := FStr(i)+'.  '+f_sh2Asc (call);
    IF (typ AND bgSILENT      ) <> 0 THEN s := s + ' Silent';
    IF (typ AND bgDM          ) <> 0 THEN s := s + ' DM';
    IF (typ AND bgEntryLog    ) <> 0 THEN s := s + ' Log';
    IF (typ AND bgNoExtConnect) <> 0 THEN s := s + ' NoExt';
    IF (typ AND bgBeamter     ) <> 0 THEN s := s + ' Beamt';
    IF (typ AND bgAutoRedirect) <> 0 THEN s := s + ' Redirect to P'+FStr(data.ifRedirect);
    IF (nConnect <> INVALIDNCONNECTS) THEN s := s + ' n:'+FStr(nConnect);
    IF pText <> NiL THEN s := s + ' "' + string(pText^)+'"';
    TX_Info (pCB,SPAETER, EOL+s);
    END;
END;


PROCEDURE SetWatch ( pCB : TP_AXCB; sArg : STRING);
 CONST COMANDS =
  'ADD INS DEL NR CALL SILENT DM LOG NOEXTCONNECT MAXCONNECT REDIRECT '+
  'BEAMTER '; {* Letzte Leerzeichen ist wichtig ! *}
      cmADD=1;    cmINS=2; cmDEL=3;  cmNR=4;  cmCALL=5;
      cmSILENT=6; cmDM=7;  cmLOG=8;  cmEXT=9; cmMAXCONNECT=10;
      cmREDIRECT=11; cmBEAMTER=12;

      cmdTab : ARRAY [1..length(COMANDS)] OF CHAR = COMANDS;
  VAR i, maxConnects   : BYTE;
      action : t_WatchAction;
      modus  : (INS,DEL);
      sText,
      sCall  : STRING;
      nr : WORD;
      lRed : Longint;
BEGIN
  sCall := '';  sText := ''; modus := INS;  action := bgNULL; nr:=0;
  lRed := 0;
  maxConnects := INVALIDNCONNECTS;
  REPEAT
    i := ScanStr (sArg, @cmdTab, sizeOf (cmdTab));
    CASE i OF
      cmADD,
      cmINS : modus := INS; {* ADD,INS *}
      cmDEL : modus := DEL; {* DEL *}
      cmCALL: ScanForText ( sArg, sCall );
      cmMAXCONNECT
            : maxConnects := ScanForNum (sArg);
      cmREDIRECT
            : BEGIN
              lRed := ScanForNum (sArg);
              IF lRed <> NOTANUMBER THEN OrSelf( action , bgAutoRedirect)
                                    ELSE lRed := 0;
              END;
      cmNR  : Nr := ScanForNum (sArg);
      cmSILENT
            : action := Action OR bgSILENT;
      cmDM  : action := Action OR bgDM;
      cmLOG : action := Action OR bgEntryLog;
      cmEXT : action := Action OR bgNoExtConnect;
      cmBEAMTER : action := Action OR bgBEAMTER;
      END;
  UNTIL i = 0;
  IF sArg <> '' THEN ScanForText (sArg, sText);

  IF (modus = INS) THEN
    IF (sCall = '' )
      THEN TX_EOLSYSInfo (pCB, SPAETER, 'WATCH ADD: no Callsign(s)' )
      ELSE BEGIN
           i := nWatch+1;
           IF i > MAXWATCH
             THEN TX_EolSysInfo (pCB,SPAETER, 'to much entrys')
             ELSE WITH Watch[i] DO
                    BEGIN
                    Inc(nWatch);
                    AscCall2shift ( f_Upper(sCall), call);
                    typ := action;
                    nConnect := maxConnects;
                    data.ifRedirect:= lRed;
                    pText := NiL;
                    IF sText <> '' THEN
                      BEGIN
                      MemGet (pText, 1+Length(sText));
                      string(pText^) := sText;
                      END;
                    END;
           END;

  IF (modus = DEL) THEN
    IF (nr>0) AND (nr<=nWATCH)
       THEN WITH watch[nr] DO
            BEGIN
            IF pText <> NiL THEN
              BEGIN {* Speicher fr Text freigeben *}
              MemFree (pText, 1+byte(pText^));
              pText := NiL;
              END;
            IF nr < nWatch THEN Move( Watch[nr+1], Watch[nr], (nWatch-nr)*sizeof(Watch[1]) );
            Dec(nWatch);
            TX_EolSysInfo (pCB, SPAETER, 'deleted' );
            END
       ELSE TX_EolSysInfo (pCB, SPAETER, 'DEL:sri,wrong Nr' );
END;

FUNCTION GetWatch (pCB : tp_axcb) : BYTE;
{* Kontollieren der Watchtabelle. GGfs pCB^ ndern. *}
{* Gibt den Watchmode zurck.                       *}
  VAR i : BYTE;
      nCon : WORD;
      lnPakete : longint ;
BEGIN
 GetWatch := bgNULL;
 FOR i := 1 TO nWATCH DO  {*$TODO WITH *}
   IF CmpShCallJoker( pCB^.tocall, watch[i].Call ) THEN
     BEGIN {* gefunden *}
     pCB^.watchMode := i;
     GetWatch := Watch[i].typ;
     IF (Watch[i].typ AND bgEntryLog    ) <> 0 THEN LogAddEntry (pCB, leWATCH, '');
     IF (Watch[i].typ AND bgAutoRedirect) <> 0 THEN pCB^.redirectIfNr := watch[i].data.ifRedirect;
     IF (Watch[i].typ AND bgBeamter     ) <> 0 THEN pCB^.fBeamt := true;
     IF (Watch[i].nConnect <> INVALIDNCONNECTS) AND {* Beschrnkung Connectanzahl? *}
        (Watch[i].typ AND bgNoIntConnect = 0) THEN  {* Connect eh schon unerwnscht? *}
       BEGIN
       ZaehleConnects(pCB, nCon, lnPakete);
       IF nCon>Watch[i].nConnect THEN GetWatch := bgDM; {* und Tschuess *}
       END;
     END;
END;

{}


PROCEDURE DoKill ( pCB : TP_axcb; id : WORD );
 {* Lsche einen Benutzer aus dem Digi *}
 VAR pKilled : tp_AXCB;
BEGIN
  pKilled := id2CB (id);
  IF pKilled <> Nil
    THEN BEGIN
         DoDisconnectImm (pKilled);
         {* IMM, denn die Verbindung knnte ja noch haengen *}
         TX_EolSysInfo (pCB,SPAETER, 'hd:'+f_sh2asc(pKilled^.toCall))
         END
    ELSE TX_EolSysInfo (pCB,SPAETER, BELL+'invalid id');
END;


PROCEDURE SysOpSNetLogin  ( pCB : TP_axcb; sArg : STRING);
  {* Einlog - Prozedur  la THENet / erweitertes SNet *}
BEGIN
  IF ( Pos(sPW,sArg) > 0 )
    {$IFnDEF SCC}
     OR (axiface[pCB^.iface].fLOOPBACK)
    {$ENDIF}
    {$IFDEF Userware}
     OR (axiface[pCB^.iface].fLOOPBACK)
     OR (axiface[pCB^.iface].sNameDn='KISS') {* Unsicher! *}
    {$ENDIF}
    {$IFDEF SpecialMEHack}
     AND HackLogin(pCB)
    {$ENDIF}
    THEN BEGIN {* erfolgreich *}
         pCB^.who := SYSOP;
         LogAddEntry (pCB, leLoginSysOpSucces, '');
         pCB^.pInfoBox^.PrivCount := 0;
         END
    ELSE BEGIN
         LogAddEntry (pCB, leLoginSysOpFail, FStr(pCB^.pInfoBox^.PrivCount));
         END;
  sPW:= ''; {* Ansonsten kann sich der naechste auch einloggen *}
  pCBPW := NiL;
END;

{}


{$F+}
PROCEDURE fnRestartTimeOut ( p : POINTER );
  VAR s : STRING;
BEGIN
  s := '0';
  StoreStack('R','');
  DoRestart ( NiL, s );
  Halt(ERR_NO_CONNECT); {* Sicher ist sicher *}
END;



PROCEDURE GenPassWord( startwert : WORD );
   {* Passwort generieren *}
  CONST pwTabelle : ARRAY [1..2*26+10] OF Char = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
  VAR   i         : WORD;
BEGIN
 {$IFDEF SpecialMEHack} HackPassWort1(StartWert); {$ENDIF}
 WatchDog;
 MyRandSeed := startwert;
 FOR i := 0 TO cMAXPWLISTINDEX DO
   BEGIN
   IF MyRandom(2) = 1 THEN;;;;
   chPwList[i] := pwTabelle [1+MyRandom (2*26+10)];
   END;
END;

{}


BEGIN
 GenPassWord(1); {* Default *}
 WatchDog;
 InitTimer (timSABMmode,100);

 {$IFnDEF userware}
  InitTimer(timRestart,15*_Minuten);
  StartTimer(timRestart);
  timRestart.TimerFunction := fnRestartTimeOut;
  timRestart.Arg := NiL;
 {$ENDIF}
END.
