{$I FD_INCL.PAS}
UNIT FD_Subr;

INTERFACE


USES FD_Def;


PROCEDURE CvMacro (pCB : TP_AXCB; VAR s,sRet : STRING );

PROCEDURE AscCall2shift ( a:String; VAR s : T_shCall);
PROCEDURE DecodeAX25Call (VAR p : Pointer; VAR s : String);
PROCEDURE Shift2ascCall ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall; VAR a : String);
PROCEDURE Shift2ascCall_short ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall; VAR a : String);
 FUNCTION FSh2SSID ( {$IFDEF ver70} CONST {$ENDIF}  s : T_shCall ) : T_SSID;
 FUNCTION f_sh2ascOhneSSID ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall ) : String;
 FUNCTION f_sh2asc ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall ) : String;
 FUNCTION f_sh2ascUsing ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall; fMitSSID : BOOLEAN; len : BYTE ) : String;
 FUNCTION f_toCall2ascIface (pCB:TP_AXCB) : String;
 FUNCTION f_digi2str ( pCB : tp_axcb; n : BYTE ) : String;

PROCEDURE StripShSSID ( VAR x : T_SHCall);
PROCEDURE SetHBit ( pShCall : TP_ShCall );

 FUNCTION EqualCall ( pm : tp_mbuf; {$IFDEF ver70} CONST {$ENDIF} asccall : STRING ) : BOOLEAN;
 FUNCTION EqualShCall ( pm : tp_mbuf; call : T_ShCall ) : BOOLEAN;
 FUNCTION CmpShCallSSID (a,b : POINTER) : BOOLEAN;
 FUNCTION CmpShCall ( VAR ta,tb : T_SHCALL ) : BOOLEAN;
 FUNCTION CmpShCallJoker ( VAR ta,tb : T_SHCALL ) : BOOLEAN;

PROCEDURE String2tv ( s : String; VAR t,v : String);
PROCEDURE String2shPath ( s : String; VAR shPath : T_ShPath);
PROCEDURE ShPath2String ( shPath : T_ShPath; von,bis: BYTE;fMitPort : BOOLEAN; VAR sRet : String);

 FUNCTION fAsciiCallCheck (s:String):String;
 FUNCTION ValidCall ( s : String ) : BOOLEAN;
 FUNCTION ValidVia ( s : String ) : BOOLEAN;
 FUNCTION ValidShCall ( VAR sh : t_ShCall ) : BOOLEAN;

PROCEDURE Asc2axcb ( f,t,v:String; pCB : Tp_Axcb );
PROCEDURE Pm2pcb ( pM : TP_mBuf; pCB : TP_axCB  );

FUNCTION FrameInfo2str  ( pCB : tp_axcb ) : String;
FUNCTION FrameInfo2string_CR  ( pCB : tp_axcb ) : String;

FUNCTION CalcOfsCtl ( pm : TP_mBuf ) : WORD;
FUNCTION DoCompletePM ( pm : TP_mBuf ) : BOOLEAN;
FUNCTION FrameValid (pm:tp_mbuf):BOOLEAN;
FUNCTION Pm2Txdelay(pm:tp_mBuf) : Real;
FUNCTION Txdelay2String( pcb : tp_axcb) : STRING;
FUNCTION TxDelayCB(pCB : TP_AXCB) : LongInt;

FUNCTION IsNumberedFrameTyp ( pm : tp_mBuf ) : BOOLEAN;
FUNCTION IsIUIFrameTyp ( pm : tp_mBuf ) : BOOLEAN;
FUNCTION Get_Info ( pm : tp_mBuf ) : String;
FUNCTION GetFrameTyp ( pm : tp_mBuf ) : T_FrameTyp;
FUNCTION GetPID ( pm : tp_mBuf ) : BYTE;

FUNCTION GetKMPF ( pm : tp_mBuf ) : T_KMPF;
FUNCTION GetPollFinal ( pm : tp_mBuf ) : BOOLEAN;
FUNCTION GetResponse( pm : tp_mBuf ) : BOOLEAN;
FUNCTION GetR_Nr( pm : tp_mBuf ) : BYTE;
FUNCTION GetS_Nr( pm : tp_mBuf ) : BYTE;


    CONST NOTANUMBER = 65535; {* MUSS eine hinreichend groe Zahl sein; und darf nie 0 oder so sein *}
PROCEDURE _ScanForText ( VAR sArg, sErg : String );
 FUNCTION ScanForVal (  VAR sArg : String ) : longint;
 FUNCTION ScanForNum ( VAR sArg : String ) : Longint;
 FUNCTION ScanStr ( VAR sArg : String;  pVgl : POINTER; lVgl : WORD) : BYTE;

 FUNCTION CountQueue ( pm : tp_mBuf) : WORD;
 FUNCTION EnQueue ( VAR pmRoot : tp_mBuf; pm : tp_mBuf ) : WORD;
PROCEDURE EnQueue2 ( VAR pmRoot,pmNeu : tp_mBuf );
 FUNCTION GetQueueData (VAR pmRoot : tp_mBuf;
                        VAR QueueSize : LongInt;
                        pDest : POINTER;
                        maxSize : WORD;
                        stopCh : CHAR ) : WORD;
 FUNCTION GetMBufFromQueue (VAR pmRoot : tp_mBuf ) : tp_mBuf;
PROCEDURE PeekQueueData ( pmRoot : TP_mBuf;
			  maxSize : WORD;
                          stopCh : CHAR;
                      VAR offset : WORD;
                      VAR pReturn : POINTER );

 FUNCTION MemEq ( a,b : Pointer; Len : WORD ) : BOOLEAN;
 FUNCTION MemGE ( a,b : Pointer; Len : WORD ) : BOOLEAN;
 FUNCTION MemCmp ( a,b : Pointer; Len : WORD ) : shortint;


{}

IMPLEMENTATION

USES FD_Timer,
     FD_mBuf,
     FD_Mem,
     {$IFDEF SCC} FD_TNC, fd_scc,
     {$ELSE}      FD_CRT,
     {$ENDIF}
     FD_Error,    {* StoreStack *}
     FD_Moni,     {* dump text }
     FD_AXCB,
     FD_Div
     ;

{}


PROCEDURE CvMacro (pCB : TP_AXCB; VAR s,sRet : STRING );
{* Expandiert Macros in s nach sRet *}
  VAR i : BYTE;
      ps : ^CHAR;
      state : (cNORMAL,cMACRO);
      fCBok : BOOLEAN;
      txdms : Longint;
BEGIN
  sRet := '';
  fCBok := CheckAXCB( pCB, false{fStore} );

  state := cNORMAL;
  ps := @s[0];

  FOR i := 1 TO length(s) DO
    BEGIN
    Inc(word(ps));
    IF state=cNORMAL
      THEN IF ps^ = '%'
             THEN state := cMACRO
             ELSE BEGIN
                  {* eigentlich nix anderes als sRet := sRet + s[i], aber viel schneller:*}
                  IF length(sRet) < 255 THEN
                    BEGIN
                    Inc(sRet[0]);
                    sRet[length(sRet)] := ps^;
                    END;
                  END
      ELSE BEGIN {* hier keine Optim.-Tricks ntig, da selten durchlaufen *}
           CASE ps^ OF
             'c' : IF fCBok THEN AddString(sRet,f_sh2asc(pCB^.toCall));
             'd' : IF fCBok THEN
                       AddString(sRet, axiface[pCB^.aktIfnr].AsMyCall)
                       ;
             't' : AddString(sRet,Uhrzeit(sysTime.Hour,sysTime.Min));
             'n' : AddChar(sRet,EOL);
             'i' : IF fCBok THEN AddString(sRet,axiface[pCB^.aktIfnr].asMyIdent);
             'z' : AddString( sRet, sZeitZone);
             'l' : AddString( sRet, CurrentDatumUhrZeitDieBox);
             'q' : AddString( sRet, fstr(nAXCBAnzahl) ); (* dg6may: Anzahl QSO's *)
             's' : IF fCBok THEN
                     IF axIFace[pCB^.aktIfnr].MinSSID <> 0 THEN
                       AddString(sRet,'-'+FStr(axIFace[pCB^.aktIfnr].MinSSID));
             'a' : AddString(sRet,FStr(DiffUhrzeit ( systime.hour, systime.min,
                                                     pCB^.loginH, pCB^.loginM)));
             'm' : BEGIN
                   txdMs := TxDelayCB(pCB);
                   IF ( TxDelayCB(pCB)>20)  THEN
                     AddString(sRet,'Ihr TxDelay ist um '+fStr(txdms)+
                                    ' ( '+fStr(txdms div 10)+'=Einheiten) zu lang!!'+EOL);
                   END;
             '%' : AddChar(sRet,'%');
             '0' : sRet := '';
             ELSE AddString(sRet, '%'+ps^);
             END;
           state := cNORMAL;
           END;
    END;
END;


FUNCTION IsDigit (c:char) : BOOLEAN;
BEGIN
  IsDigit := (c>='0') AND (c<='9');
END;

FUNCTION ValidShCall ( VAR sh : t_ShCall ) : BOOLEAN;
  CONST stc = [64,96..114,130..180]; {* geshiftet: ' ',0-9,A-Z *}
  VAR i : BYTE;
BEGIN
  ValidShCall := TRUE;
  FOR i := 1 TO 6 DO
    IF NOT ( byte(sh[i]) IN stc) THEN ValidShCall := FALSE;
END;


FUNCTION fAsciiCallCheck (s:String):String;
  {* Gibt ein 'vernnftiges' Call zurck, oder Leerstring, wenn Fehler.
   * Wir wollen uns hier keinen abbrechen und alle moeglichen
   * AFU-Calls testen.. nur ein paar Grundregeln !!!!!      DL7GAI,96 *}
  {* $TODO: Redunanzen in fAsciiCallCheck und ValidCall beseitigen *}
  VAR i    :BYTE;
      sNeu :String;
      ssid :integer;
BEGIN
  fASCIICALLCHECK:='';
  sNeu:='';
  FOR i := 1 TO length(s) DO
    BEGIN
    IF s[i] in ['0'..'9','A'..'Z','a'..'z','-']
       THEN sneu  := sNeu + upcase(s[i])
       ELSE Exit;
         {* tja, ein nicht gueltiges Zeichen fuehrt zum Abbruch;
          * Hab zwar schon Userfragen gehoert, wieso xx1yyy/A nicht
          * geht... aber das ist ne andere sparte..
          * und wieso nur immer ne negative SSID, man sollte
          * positiv denken.. aba lassen mer das... *}
    END;

  {* die ssid checken wir auch *}
  i := pos ('-',s);
  IF i>0 THEN
    BEGIN {* SSID angegeben ... *}
    ssid := f_val(copy(sNeu,i,ord(sNeu[0])));
    IF ssid=0 then begin {* Trick: SSID -0 oder nur - entfernen *}
                   ssid:=-10; {* intern -10 setzten damit wir weiterkommen *}
                   sNeu:=copy(sNeu,1,i-1)
                   end;

    if (ssid < -15) or (ssid > -1) then exit;  {* unzulaessige SSID !! *}
    END;

  {* das Call darf maximal 6 Stellen haben... mehr is nicht ! *}
  i := pos ('-',sNeu);
  if i > 7 then exit;

  {* zum schluss noch nen check min 1 Ziffer max 2 in Folge ...*}
  if ValidCall(sNeu) THEN fASCIICALLCHECK:=sNEU;

  {* und was ist mit A1A1A1 ???? Is ja ungueltig,aba jedem ist ja
   * die DV-AFug bekannt.. Aussendung irrefuehrender Calls ist
   * verboten..... Soll mir nur keiner kommen.. wieso das dann
   * einzustellen ist. Auf dem 11m Band wirds ja hoffentlich
   * keine TW/DW geben !!! *}
END;



FUNCTION ValidCall ( s : String ) : BOOLEAN;
  {* Testet ob *s* ein gltiges Call (ASCII)
   *  la 3d1rt, y12ab, g3dbi oder dl7kab ist
   * Ziemlich daemlich gemacht... *}
  {* $TODO: Redunanzen in fAsciiCallCheck und ValidCall beseitigen *}
  VAR i : Byte ;
      pattern : String;
BEGIN
  ValidCall := FALSE;
  Trim (s);
  IF s = '' THEN Exit;
  i := pos ('-',s);
  IF i > 0 THEN BEGIN {* SSID Kontrolle *}
                IF f_val (copy (s,i+1,255)) > 15 THEN Exit;
                byte(s[0]) := Pos ('-',s)-1;
                END;
  IF (Length (s) < 3) THEN Exit;

  pattern[0] := s[0];
  FOR i := 1 TO Length (s) DO
    IF      isLetter(s[i]) THEN pattern[i] := 'l'
    ELSE IF isDigit (s[i]) THEN pattern[i] := 'd'
    ELSE exit;

  IF Pos ('d',pattern) = 0 THEN Exit; {* eine Ziffer ist ntig *}
  i := Pos ('dd',pattern);
  IF (i <> 0) AND (i <> 2) THEN Exit; {* zwei Ziffern hintereinander nur wie bei y22lo *}

  {* DL7GAI *}
  i := Pos ('ddd',pattern);
  IF i <> 0 THEN Exit; {* drei Ziffern hintereinander ist nicht erlaubt *}

  ValidCall := TRUE;
END;


FUNCTION ValidVia ( s : String ) : BOOLEAN;
  {* Testet ob s ein gltiges Weg (via) angegeben wurde (ASCII) *}
  VAR i,j,a,b : Byte ;
      bl      : BOOLEAN;
BEGIN
  ValidVia := FALSE;
  Trim (s);
  a := 1;
  REPEAT
    i := pos (',',s);
    j := pos (' ',s);
    IF i + j = 0 THEN b := length (s)
    ELSE IF i < j THEN IF i <> 0 THEN b := i-1
                                 ELSE b := j-1
                  ELSE IF j <> 0 THEN b := j-1
                                 ELSE b := i-1;

    bl := ValidCall (copy (s,a,b-a+1) );
    s := Copy(s,b+2,255);
    a := 1;
  UNTIL (NOT bl) OR (a >= length (s));
  ValidVia := (a>= length(S));
END;




{$IFDEF dflkgdfjkdkjej}

FUNCTION TestShCall ( p : pointer ) : BOOLEAN;
  {* Testet ob P auf ein gltiges Call (shiftASC)
   *  la 3d1rt,y12ab oder dl7kab weist
   *}
  VAR i : Byte ;
BEGIN
  Runerror (E_ASSERT);

  IF p^ GrossBuchstabe THEN
      p+2 muss Zahl sein
      p+3 muss Grossbuchstabe sien
  TestCall := FALSE;
  IF (Length (s) < 3) OR (NOT isDigit ( s[3] ))  THEN Exit;
  FOR i := 4 TO Length (s) DO
     IF NOT isLetter ( s[i] ) THEN Exit;
  IF isDigit (s[1]) THEN
    IF isDigit (s[2]) THEN Exit;
  TestCall := TRUE;
END;
{$ENDIF}

{}


PROCEDURE Shift2ascCall ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall; VAR a : String);
  VAR i : BYTE;
BEGIN
  a[0] := #6;
  FOR i := 1 TO 6 DO  Byte(a[i]) := Byte(s[i]) DIV 2;
  a := a + '-' +  FStr ((Byte(s[7]) DIV 2) AND 15) ;
END;


PROCEDURE Shift2ascCall_Short ( {$IFDEF ver70} CONST {$ENDIF} s : T_shCall; VAR a : String);
  VAR i,ssid : BYTE;
BEGIN
  FOR i := 1 TO 6 DO Byte(a[i]) := Byte(s[i]) DIV 2;
  i := 6;
  WHILE (a[i]=' ') AND (i>0) DO Dec (i);
  a[0] := char (i);
  ssid := (Byte(s[7]) DIV 2) AND 15;
  IF SSID > 0 THEN a := a + '-' +  FStr (ssid);
END;

PROCEDURE DecodeAX25Call (VAR p : Pointer; VAR s : String);
  VAR i,ssid : BYTE;
BEGIN
  FOR i := 1 TO 6 DO
    BEGIN
    AddChar(s, char(byte(p^) DIV 2));
    Inc(word(p));
    END;
  ssid := (Byte(p^) DIV 2) AND 15;
  IF ssid <> 0 THEN BEGIN
                    i := 6;
                    WHILE (s[i]=' ') AND (i>0) DO Dec (i);
                    s[0] := char (i);
                    s := s + '-' +  FStr (ssid);
                    END;
  Inc(word(p));
END;

FUNCTION FSh2SSID ( {$IFDEF ver70} CONST {$ENDIF}  s : T_shCall ) : T_SSID;
BEGIN
  FSh2ssid := (Byte(s[7]) DIV 2) AND 15;
END;

FUNCTION f_sh2AscOhneSSID ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall ) : String;
  VAR i : BYTE;
      a : String;
BEGIN
  FOR i := 1 TO 6 DO  Byte(a[i]) := Byte(s[i]) DIV 2;
  i := 6;
  WHILE (a[i]=' ') AND (i>0) DO Dec (i);
  a[0] := char (i);
  f_sh2AscOhneSSID := a;
END;


FUNCTION F_Sh2Asc ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall ) : String;
  VAR a : String;
BEGIN
  Shift2ascCall_short (s,a);
  f_sh2asc := a;
END;


FUNCTION f_sh2ascUsing ({$IFDEF ver70} CONST {$ENDIF} s : T_shCall;
                        fMitSSID : BOOLEAN; len : BYTE ) : String;
  VAR i : BYTE;
      a : String;
BEGIN
  IF fMitSSID THEN Shift2ascCall_Short (s,a)
              else a := f_sh2AscOhneSSID (s );
  WHILE length(a) < len DO a := a + ' ';
  f_sh2ascUsing := a;
END;

FUNCTION f_toCall2ascIface (pCB:TP_AXCB) : String;
  {* Wandelt das TOCall aus dem pCB in ASCII um. Wenn der zugehrige Port
   * ein Usereinstieg ist, so sind es Kleinbuchstaben, sonst Grossbuchstaben
   * Wird in der UserListe verwendent *}
  VAR a : String;
BEGIN
 {* Schnauze voll hab.... *}
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Shift2ascCall_short (pCB^.toCall,a);
  IF axIFace[pCB^.iface].art = aUser
    THEN f_toCall2ascIface := f_lower(a)
    ELSE f_toCall2ascIface := a;
 {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
END;


FUNCTION F_Digi2Str ( pCB : tp_axcb; n : BYTE ) : String;
  VAR i : BYTE;
      a : String;
BEGIN
  a := '';
  FOR i := n TO pCB^.nDigi DO
    AddString(a,  f_sh2asc(pCB^.digi[i]) +' ');
  RTrim(a); {kw 17.8.96}
  f_digi2str := a;
END;



FUNCTION fPfad2Str ( pCB : tp_axcb; n : BYTE ) : String;
  VAR i : BYTE;
      a : String;
BEGIN
  a := '';
  FOR i := n TO pCB^.nDigi DO
    AddString(a,  f_sh2asc(pCB^.digi[i]) +' ');
  RTrim(a); {kw 17.8.96}
  fPfad2Str := a;
END;


{}



PROCEDURE AscCall2shift ( a:String; VAR s : T_shCall);
  VAR i,j,ssid,ssid1,ssid2 : BYTE;
      heard : BOOLEAN;
BEGIN
  i := 1;  s[7] := #0;
  heard := (a [length(a)] = '*');
  IF heard THEN Dec (Byte (a[0]));

  WHILE (i <= 6) AND (i<= Length(a)) AND (a[i] <> '-') DO
    BEGIN {*Call umwandeln *}
    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
    Byte(s[i]) := 2*Byte(a[i]);
    {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
    Inc (i);
    END;
  FOR j := i TO 6 DO {*Rest mit Leerzeichen fllen *}
    Byte(s[j]) := 2*Byte(' ');
  IF i <= length (a) THEN
    IF (a[i] = '-') THEN
      BEGIN {* SSID einfgen, ziemlich hausbacken, aber was solls ? *}
      ssid1 := 0;
      IF (i+1 <= length (a)) THEN
        IF (a[i+1]>='0') AND (a[i+1]<='9') THEN ssid1 := byte (a[i+1]) - Byte ('0');

      ssid2 := 11;
      IF (i+2 <= length (a)) THEN
        IF (a[i+2]>='0') AND (a[i+2]<='9') THEN ssid2 := byte (a[i+2]) - Byte ('0');

      IF (ssid1 < 10) THEN  ssid := ssid1;
      IF (ssid2 < 10) THEN  ssid := ssid2+10*ssid1;
      Byte(s[7]) := 2 * (ssid AND 15);
      END;
  Byte(s[7]) := Byte(s[7]) OR $60; {* rr-Bits setzen *} ;
  IF heard THEN Byte(s[7]) := Byte(s[7]) OR $80;{* Heard_Bit setzen *}
END;


PROCEDURE StripShSSID ( VAR x : T_SHCall);
BEGIN
  byte(x[7]) := Byte(x[7]) AND NOT $1e; {* 0001 1110 = SSID ausblenden*}
END;

PROCEDURE SetHBit ( pShCall : TP_ShCall );
BEGIN
  byte(pShCall^[7]) := Byte(pShCall^[7]) OR $80; {* Heard_Bit setzen *}
END;

FUNCTION EqualCall ( pm : tp_mbuf; {$IFDEF ver70} CONST {$ENDIF} asccall : STRING ) : BOOLEAN;
  VAR s : T_shCall;
BEGIN
  AscCall2shift ( asccall, s);
  EqualCall := EqualShCall ( pm, s);
END;


FUNCTION EqualShCall ( pm : tp_mbuf; call : T_ShCall ) : BOOLEAN;
{* Testet, ob das ZielCall (oder das erste DigiCall in PM^ ohne H-Bit)
 * gleich CALL ist. SSID wird nicht ! bercksichtigt
 *}
    VAR i : WORD;
BEGIN
  EqualShCall := false;
  IF pm^.ofsctl=cOFFVIRT THEN Exit; {* Virt. Addressierung untersttzen wir nit *}
  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  {* Inc(count[cntEqCall]); *}
  {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}

  IF pm^.nMyCall = 0 THEN i := 1
                     ELSE i := pm^.nMyCall*7+7+1;
  EqualShCall := MemEq( @by1Array (pm^.pdata^)[i], @Call, 6 );
END;


FUNCTION CmpShCallSSID (a,b : POINTER) : BOOLEAN;
{* Vergleiche zwei Rufzeichen im Shift Format (a,b zeigen drauf) *}
{* Auch die SSID's men vllig gleich sein! *}
    VAR i : WORD;
BEGIN
  i := 1;
  WHILE (i<=6) AND ( Byte (a^) = Byte (b^) ) DO
    BEGIN
    Inc (word(a));
    Inc (word(b));
    Inc (i);
    END;
  cmpShCallSSID := (i=7) AND ( (Byte (a^) AND $1e) = (Byte (b^) AND $1e) );
END;


FUNCTION CmpShCall ( VAR ta,tb : T_SHCALL ) : BOOLEAN;
{* Vergleiche zwei Rufzeichen im Shift Format  *}
{* Die SSID's sind dabei egal                  *}
    VAR i : WORD;
      a,b : POINTER;
BEGIN
  a := @ta;  b := @tb;
  i := 1;
  WHILE (i<=6) AND ( Byte (a^) = Byte (b^) ) DO
    BEGIN
    Inc (word(a));
    Inc (word(b));
    Inc (i);
    END;
  cmpShCall := (i=7);
END;

FUNCTION CmpShCallJoker ( VAR ta,tb : T_SHCALL ) : BOOLEAN;
{* Vergleiche zwei Rufzeichen im Shift Format  *}
{* Die SSID's sind dabei egal                  *}
{* Stellen die ein ? enthalten werden nicht verglichen *}
    CONST cSHQM= ord('?') SHL 1;
    VAR i : WORD;
      a,b : POINTER;
BEGIN
  a := @ta;  b := @tb;
  i := 1;
  WHILE (i<=6) AND ( (Byte (a^) = Byte (b^)) OR (byte(a^)=cSHQM) OR (byte(b^)=cSHQM) )DO
    BEGIN
    Inc (word(a));
    Inc (word(b));
    Inc (i);
    END;
  cmpShCallJoker := (i=7);
END;



{}



PROCEDURE Asc2axcb ( f,t,v:String; pCB : Tp_Axcb );
{* wandelt die Strings (from, to, via) in den Pfad fr einen AX25
 * Control-Block um *}
  VAR i,il : BYTE;
BEGIN
  AscCall2shift (f, pCB^.fromCall);
  AscCall2shift (t, pCB^.toCall);

  pCB^.nDigi := 0;
  Trim (v);
  IF v <> '' THEN
    BEGIN
    il := 1;
    AddChar(v,',');
    FOR i := 1 TO length(v) DO
      IF (v[i] = ',') THEN
        IF pCB^.nDigi < 8 THEN
          BEGIN
          Inc (pCB^.nDigi);
          AscCall2shift ( copy (v, il, i-il), pCB^.digi[pCB^.nDigi] );
          il := i+1;
          END;
    END;
  {* EoA-Bit setzen *}
  IF pCB^.nDigi = 0
    THEN ORself( byte(pCB^.fromCall[7]         ) , $01 )
    ELSE ORself( byte(pCB^.digi [pCB^.nDigi][7]) , $01 );

  {* Bei SABM bercksichtigen wir die Anzahl der Digis in FrAck. Nachdem der
   * Connect zustande gekommen ist, setzen wir ihn wieder zurck (in FD_STATE)
   *}
  pCB^.t1.tickinit := Longint (axIFace[pCB^.iFace].t1_init) + Longint(300*pCB^.nDigi);
END;



PROCEDURE String2tv ( s : String; VAR t,v : String);
  {* "df1jC via dk7jc,dk8jv"---> "DF1JC","DK7JC,DK8JV" *}
  VAR i : BYTE;
      lastKomma : BOOLEAN;
BEGIN
  i := 1; t := ''; v := '';
  RTrim (s);
  WHILE (Length(s)>0) AND (s[ Length(s) ] < ' ')  DO Dec (byte (s[0]));
  WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Fhrende Blanks ausblenden *}

  IF s <= '' THEN EXIT;

  WHILE (i<=Length (s)) AND (s[i]<>' ') DO
    BEGIN
    AddChar(t, UpCase(s[i]) );
    Inc (i);
    END;

  WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Blanks berlesen *}

  IF upCase(s[i]) = 'V' THEN BEGIN
                             WHILE (i<=Length (s)) AND (s[i]<>' ') DO Inc (i);  {* Blanks suchen *}
                             WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Blanks berlesen *}
                             END;
  lastKomma := FALSE;
  WHILE (i<=Length (s)) DO
    BEGIN
    IF s[i]<> ' ' THEN BEGIN
                       AddChar(v,upCase(s[i]));
                       lastKomma := (s[i] = ',');
                       END
                  ELSE IF NOT lastKomma THEN
                         BEGIN
                         AddChar(v,',');
                         lastKomma := TRUE;
                         END;
    Inc (i);
    END;
END;

PROCEDURE String2shPath ( s : String; VAR shPath : T_ShPath);
{* DF1jc v dg9ep... --> *}
  VAR i : BYTE;
      lastKomma : BOOLEAN;
      v,t : STRING;
BEGIN
  shPath.ilDigi := 0;
  shPath.ifnr := 0;
  shPath.nMyCall := 0;
  i := 1; t := ''; v := '';
  RTrim (s);
  WHILE (Length(s)>0) AND (s[ Length(s) ] < ' ')  DO Dec (byte (s[0]));
  WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Fhrende Blanks ausblenden *}
  IF s <= '' THEN Exit;
  {* TO Call herausnehmen *}
  WHILE (i<=Length (s)) AND (s[i]<>' ') DO
    BEGIN
    AddChar(t,UpCase (s[i]));
    Inc (i);
    END;

  WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Blanks berlesen *}
  IF upCase(s[i]) = 'V' THEN
    BEGIN {* "Via" ignorieren *}
    WHILE (i<=Length (s)) AND (s[i]<>' ') DO Inc (i);  {* Blanks suchen *}
    WHILE (i<=Length (s)) AND (s[i]=' ') DO Inc (i);  {* Blanks berlesen *}
    END;
  lastKomma := FALSE;

  WHILE (i<=Length (s)) AND (shPath.ilDigi<nShPathDIGIS) DO
    BEGIN {* Vias auseinanderklmsern *}
    IF s[i]<> ' ' THEN BEGIN
                       v := v + (upCase(s[i]));
                       lastKomma := (s[i] = ',') ;
                       END
                  ELSE IF NOT lastKomma THEN
                         BEGIN
                         AscCall2shift (v, shPath.Digi[shPath.ilDigi]);
                         Inc(shPath.ilDigi);
                         v := '';
                         lastKomma := TRUE;
                         END;
    Inc (i);
    END;
  IF (v <> '') AND (shPath.ilDigi<=nShPathDIGIS) THEN
    BEGIN  {* letztes V noch nicht umgewandelt *}
    AscCall2shift (v, shPath.Digi[shPath.ilDigi]);
    Inc(shPath.ilDigi);
    END;
  AscCall2shift(t, shPath.Digi[shPath.ilDigi]);
  {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
END;

PROCEDURE ShPath2String ( shPath   : T_ShPath;
                          von,bis  : BYTE;
                          fMitPort : BOOLEAN;
                      VAR sRet     : String);
  VAR i : BYTE;
      s : String;
BEGIN
  sRet := '';
  IF shPath.ilDigi = shpINVALID THEN Exit;

  IF von > bis           THEN von := bis;
  IF von < 0             THEN von := 0;
  IF bis > shPath.ilDigi THEN bis := shPath.ilDigi;
  FOR i := von TO bis DO
    sRet := sRet + f_sh2asc ( shPath.Digi[i] )+',';
  IF sRet[length(sRet)] = ',' THEN Dec (Byte(sRet[0]));
  IF fMitPort THEN
    BEGIN
    IF axIFace[shPath.ifnr].art = aUSER THEN s := 'Userport'
                                      ELSE s := 'Interlink';
    sRet := sRet + ' ('+s+' - Port '+FStr(shPath.ifnr)+')';
    END;
END;


{}


PROCEDURE pm2pcb ( pM : TP_mBuf; pCB : TP_axCB  );
 {* Fllt pCB^ mit Daten aus pm; Der Addresspfad WIRD umgedreht.
  * Wird bei Aufbau eines QSOs verwendet.
  * EOA und H-Bit werden richtig gesetzt
  * pm darf keinen komprimierten virt. Header haben
  *}
  VAR i,j : WORD;
      p   : POINTER;
BEGIN
  p := pm^.pData;

  pCB^.iface := pm^.ifnr;
  pCB^.aktIfnr := axIFace[pm^.ifnr].mapIfnr;

  Move ( by1Array (p^)[1], pCB^.fromCall, SizeOf(pCB^.fromCall));
  Move ( by1Array (p^)[8], pCB^.toCall,   SizeOf(pCB^.toCall));

  {* EOA ausblenden *}
  ANDself(BYTE (pCB^.fromCall [7]),$fe);
  ANDself(BYTE (pCB^.toCall   [7]),$fe);

  {* Extended Bits auf Default setzen *}
  ORself(BYTE (pCB^.toCall [7]),$60);
  ORself(BYTE (pCB^.fromCall [7]),$60);

  IF pm^.ofsCtl <= 14 THEN pCB^.nDigi := 0
                      ELSE pCB^.nDigi := (pm^.ofsCtl DIV 7)-2;

  {* hier wird der Pfad umgedreht - also sollte auch nMyCall korrigiert werden *}
  IF pm^.nMyCall > 0 THEN pCB^.nMyCall := pCB^.nDigi - pm^.nMyCall + 1
                     ELSE pCB^.nMyCall := 0;
  IF pm^.nHeard  > 0 THEN pCB^.nHeard := pCB^.nDigi - pm^.nHeard + 1;
  j := 15;
  FOR i := pCB^.nDigi DOWNTO 1 DO
    BEGIN
    MOVE ( by1Array (p^)[j], pCB^.Digi[i], 7 );
    {* Ersma alle EOA ausblenden und alle H einblenden: *}
    BYTE (pCB^.Digi[i][7]) := (BYTE (pCB^.Digi[i][7]) AND $fe) OR $80;
    Inc (j,7);
    END;

 {* EOA setzen *}
  IF pCB^.nDigi > 0
    THEN BYTE (pCB^.Digi[pCB^.nDigi][7]) := BYTE (pCB^.Digi[pCB^.nDigi][7]) OR $01
    ELSE BYTE (pCB^.fromCall        [7]) := BYTE (pCB^.fromCall        [7]) OR $01;

 {* H-Bit an der richtigen Stelle setzen, durch lschen der ungltigen *}
  FOR i := pCB^.nDigi DOWNTO pCB^.nMyCall+1 DO {* Heard von MYCall soll ja immer gesetzt sein*}
    BEGIN
    Byte( pCB^.digi[i] [7]) := Byte(pCB^.digi[i] [7]) AND $7f; {*  Lschen des H-Bits *}
    END;

  pCB^.t1.tickinit := axIFace[pCB^.iFace].t1_init + 1;
  pCB^.Pid := 0;
END;


FUNCTION IsVirtAdrFrame ( pm : TP_mBuf ) : BOOLEAN;
BEGIN
  IsVirtAdrFrame :=  pm^.OfsCtl = cOFFVIRT;
END;


FUNCTION CalcOfsCtl ( pm : TP_mBuf ) : WORD;
  VAR iEoA : WORD;
      p : POINTER ;
BEGIN
  iEoA := 1;
  p := pm^.pdata;
  {* $OPT: Byte 3 untersuchen, dann erst ab Byte 14 suchen,
   * und in 7er Schritten *}
  {* Suche EoA (Bit 0 gesetzt) *}
  WHILE (( Byte (p^) AND 1) = 0) AND (iEoA<=pm^.inUse) DO
    BEGIN
    Inc (iEoA);
    Inc (word(p));
    END;
{$IFDEF VirtAdr}
  IF iEoA=2
    THEN BEGIN  {* virtAdr ala Flexnet *}
         {* pm^.nHeard := cfVIRTADR; *}
         CalcOfsCtl := cOFFVIRT;
         END
    ELSE {$ENDIF}
         CalcOfsCtl := iEoA+1;
END;


FUNCTION DoCompletePM ( pm : TP_mBuf ) : BOOLEAN;
{* Bereitet alle Felder von pm auf; wenn kein gltiges ax25 Frame. kommt
 * FALSE zurck *}
  VAR ii : WORD;
BEGIN
  DoCompletePM := FALSE;
  WITH pm^ DO
    BEGIN
    ofsCtl := CalcOfsCtl(pm);
    IF ( (ofsCtl<15) OR (ofsCtl MOD 7 <> 1)) AND (ofsctl<>cOFFVIRT) THEN Exit;
    IF NOT FrameValid(pm) THEN Exit;
    IF ofsctl=cOFFVIRT THEN
      BEGIN {* Flexnet Virt.Adress *}
      nHeard := 0;   {* muss aus dem zugehrigen pCB gefllt werden *}
      nMyCall := 0;
      DoCompletePM := True;
      Exit;
      END;

    IF ofsCtl = 15
      THEN BEGIN
           nHeard := 0; {* Paket hat keine Digis im Adressfeld*}
           nMyCall := 0;
           END
      ELSE BEGIN {* mindestens 1 Digi im Adressfeld *}
           ii := 21;
           WHILE ( ii<=ofsCtl ) AND (by1Array (pData^)[ii] AND $80 <> 0) DO
             Inc (ii,7);
           IF ii<=ofsCtl
               THEN BEGIN
                    nHeard := ii DIV 7 - 2 - 1;
                    nMyCall := nHeard + 1;
                    END
	       ELSE BEGIN {* Sonderfall: auch der letzte Digi hats *}
                    nHeard := ofsctl DIV 7 - 2;
                    nMyCall := 0;
                    END;
           END;
    END;
  DoCompletePM := True;
END;



FUNCTION FrameValid (pm:tp_mbuf):BOOLEAN;
Begin
  FrameValid :=  (CheckMBuf(pm) = cAllOK)  AND
                 (pm^.iFnr   <= MAX_IFACE) AND
		 (pm^.iFnr   >  0)  	   AND
		 (pm^.inuse  <= BUFFSIZE)  AND
                 (pm^.inuse  >=
{$IFDEF VirtAdr}                8
{$ELSE}                         9
{$ENDIF}                         )         AND
                 (pm^.ofsCtl <  BUFFSIZE);
END;


FUNCTION Pm2Txdelay(pm:tp_mBuf) : Real;
BEGIN
 pm2txDelay := 0;
{$IFDEF scc}
 IF fGlobMessTxd THEN
   BEGIN
   {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
   WITH pm^ do
    IF pttimer <> nil THEN
      IF time-longint(pttimer) > 0 THEN
           BEGIN
           pm2txDelay := 10*(time-longint(pttimer))  {Dauer Frame...}
                      - (  (inUse+5)   {...abzglich Nutzdaten...}
                          / ( (scciface[ifnr].baud+1) / 8000.0)  {...im Verhltnis zur Baudrate..}
                        );
           END;
   END;
   {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
   {$ENDIF}
END;


FUNCTION Txdelay2String( pcb : tp_axcb) : STRING;
BEGIN
  IF pCB^.txdn<5
    THEN Txdelay2String := ''
    ELSE Txdelay2String := f_Using( pcb^.txdn,4)
                         + f_Using( TxDelayCB(pCB),4)
                         + f_Using( pcb^.txdmin,7)
                         + f_Using( pcb^.txdmax,7);
END;

FUNCTION TxDelayCB(pCB : TP_AXCB) : LongInt;
BEGIN
  TxDelayCB := 0;
  IF pCB^.txdn<5 THEN Exit;
  TxDelayCB := pCB^.txdSum DIV pCB^.txdn;
END;

{}

FUNCTION Get_Info ( pm : tp_mBuf ) : String;
  {* Gibt den InfoText eines Frames zurck. Wird in MH gebraucht *}
  VAR s : String;
      p : Pointer;
BEGIN
  s := '';
  IF IsIUIFrameTyp(pm) THEN {* Hat diese Paket Art berhaupt ein PID ? *}
    BEGIN  {* ja *}
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}   {kw 1.6.97}
    byte(s[0]) := pm^.inuse-pm^.ofsctl-1;
    p:=pm^.pData;
    Inc( word(p), pm^.ofsctl+1);
    Move( p^, s[1], byte(s[0]) );
 {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
    END;
  Get_Info := s;
END;


FUNCTION GetFrameTyp ( pm : tp_mBuf ) : T_FrameTyp;
  VAR sTyp    : t_FrameTyp;
      control : BYTE;
BEGIN
  sTyp := unKnown;
  control := by1Array (pm^.pData^)[pm^.ofsCtl];

  IF Control and $0f =   1 THEN sTyp := RR   ELSE
  IF Control and $01 =   0 THEN sTyp := INFO ELSE
  IF Control and $0f =   5 THEN sTyp := RNR  ELSE
  IF Control and $0f =   9 THEN sTyp := REJ  ELSE
  IF Control and $ef = $63 THEN sTyp := UA   ELSE
  IF Control and $ef = $2f THEN sTyp := SABM ELSE
  IF Control and $ef = $43 THEN sTyp := DISC ELSE
  IF Control and $ef = $0f THEN sTyp := DM   ELSE
  IF Control and $ef = $03 THEN sTyp := UI   ELSE
  IF Control and $ef = $87 THEN sTyp := FRMR;

  GetFrameTyp := sTyp;
END;


FUNCTION IsNumberedFrameTyp ( pm : tp_mBuf ) : BOOLEAN;
  VAR control : BYTE;
BEGIN
  control := by1Array (pm^.pData^)[pm^.ofsCtl];
  IsNumberedFrameTyp := (control and $03 = 1) {* rr,rnr,rej *}
                     OR (control and $01 = 0) {* I *}
END;

FUNCTION IsIUIFrameTyp ( pm : tp_mBuf ) : BOOLEAN;
{* Ist es ein I oder ein UI-Frame
 * Muss so gem8 werden - z.B. gibt es lange SABMs von Flexnet
 *}
  VAR control : BYTE;
BEGIN
  control := by1Array (pm^.pData^)[pm^.ofsCtl];
  IsIUIFrameTyp := ((control and $01) =   0) {* I *}
                OR ((control and $ef) = $03) {*UI*}
END;


FUNCTION GetPID ( pm : tp_mBuf ) : BYTE;
BEGIN
  IF IsIUIFrameTyp ( pm  ) {* hat diese Paket Art berhaupt ein PID ? *}
    THEN GetPID := (by1Array (pm^.pData^)[pm^.ofsCtl+1])
    ELSE GetPID := 0;
END;


FUNCTION GetPollFinal ( pm : tp_mBuf ) : BOOLEAN;
BEGIN
  {* if isvirtArdFrame (pm) then
   *    GETKMPF := bit 1 von byte 2
   *}
  GetPollFinal :=   (
                    (by1Array (pm^.pData^)[pm^.ofsCtl])
                    AND $10 <> 0
                    );
END;

FUNCTION GetResponse( pm : tp_mBuf ) : BOOLEAN;
BEGIN
  {* if isvirtArdFrame (pm) then
   *    GETKMPF := bit 1 von byte 2
   *}
  GetResponse := (
                  (by1Array (pm^.pData^)[07] AND $80 = 0)
                  AND
                  (by1Array (pm^.pData^)[14] AND $80 <> 0)
                 );
END;

FUNCTION GetKMPF ( pm : tp_mBuf ) : T_KMPF;
BEGIN
  {* if isvirtArdFrame (pm) then
   *    GETKMPF := bit 1 von byte 2
   *}
  IF (   {* Meldung = TRUE; *}
       (by1Array (pm^.pData^)[07] AND $80 = 0)
        AND
       (by1Array (pm^.pData^)[14] AND $80 <> 0)
     ) THEN BEGIN {* Meldung *}
            IF ( (by1Array (pm^.pData^)[pm^.ofsCtl]) AND $10 <> 0 )
              THEN GetKMPF := cFINAL
              ELSE GetKMPF := cMELD;
            END
       ELSE BEGIN   {* Kommando *}
            IF ( (by1Array (pm^.pData^)[pm^.ofsCtl]) AND $10 <> 0 )
              THEN GetKMPF := cPOLL
              ELSE GetKMPF := cKOMM;
            END
END;


FUNCTION GetR_Nr( pm : tp_mBuf ) : BYTE;
BEGIN
  GetR_Nr := ((by1Array (pm^.pData^)[pm^.ofsCtl]) AND $E0 ) SHR 5;
END;


FUNCTION GetS_Nr( pm : tp_mBuf ) : BYTE;
BEGIN
  GetS_Nr := ((by1Array (pm^.pData^)[pm^.ofsCtl]) AND $0e ) SHR 1;
END;


{}

FUNCTION FrameInfo2str  ( pCB : tp_axcb ) : String;
  VAR s : String;
BEGIN
  byte (s[0]) := GetQueueData (pCB^.RxBuf, pCB^.RxBufSize,
                               @s[1], sizeof(s)-1, #0);
  frameInfo2str := s;
END;


FUNCTION FrameInfo2string_CR  ( pCB : tp_axcb ) : String;
 VAR s : String;
     wZwisp : WORD;
     offset : WORD;
     pReturn : POINTER;
BEGIN
  {* Ersma nachnem EOL suchen *}
  PeekQueueData ( pCB^.RxBuf, pCB^.RxBufSize, EOL, offset, pReturn );
  IF offset <> 0
    THEN BEGIN
         wZwisp := GetQueueData (pCB^.RxBuf, pCB^.RxBufSize,
                                 @s[1], sizeof(s)-1, EOL);
         s[0] := Char (wZwisp);
         FrameInfo2string_CR := s;
         END
    ELSE FrameInfo2string_CR := '';
END;


{}

FUNCTION CountQueue ( pm : tp_mBuf) : WORD;
  {* Gibt die Zahl der eingereihten Pakete zurck.                      *}
  LABEL lEoP;
  VAR n : WORD;
BEGIN
  CountQueue := 0;
  IF pm = Nil THEN GOTO lEoP; {* Wo nix einzureihen ist.... *}

  n := 0;
  WHILE pm<>Nil DO
    BEGIN
    pm := pm^.next;
    Inc(n);
    END;

  CountQueue := n;
lEop:
END;



FUNCTION EnQueue ( VAR pmRoot : tp_mBuf; pm : tp_mBuf ) : WORD;
  {* Einreihen von pm^ an das Ende der Kette, die bei pmRoot^ beginnt. *}
  {* Gibt die Zahl der eingereihten Bytes zurck.                      *}
  {* Spaetere OPTIMIERUNG: Rx-TailPointer  *$OPT*                      *}
  LABEL lEoP;
  VAR p, pLast : tp_mBuf;
BEGIN
  EnQueue := 0;
  IF pm = Nil THEN GOTO lEoP; {* Wo nix einzureihen ist.... *}
  IF pm^.pData = Nil THEN GOTO lEoP; {* Dto. Aber neu 15.4.93; $TODO pm^ wieder freigeben!*}

  {* Suche letztes Element in der bestehenden Liste *}
  p := pmRoot; pLast := NiL;
  WHILE p<>Nil DO
    BEGIN
    pLast := p;
    p := p^.next;
    END;

  IF pLast <> Nil THEN pLast^.next := pm
                  ELSE pmRoot := pm;  {* 1. Paket in der Kette *}
  pm^.next := NiL; {* Klar - ein Ende muss immer auf nix verweisen *}
  EnQueue := pm^.inUse;  {* Lnge Paket *}
lEop:
END;

PROCEDURE EnQueue2 ( VAR pmRoot,pmNeu : tp_mBuf );
  {* Hngt pmNeu an das Ende der Kette, die bei pmRoot^ beginnt um.
   * pmRoot und pmNeu werden entsprechend verndert.
   * Gibt die Zahl der eingereihten Pakete zurck.
   *}
  LABEL lEoP;
  VAR p, pLast : tp_mBuf;
BEGIN
  IF pmNeu = Nil THEN GOTO lEoP; {* Wo nix einzureihen ist.... *}

  {* Suche letztes Element in der bestehenden Liste *}
  p := pmRoot; pLast := NiL;
  WHILE p<>Nil DO
    BEGIN
    pLast := p;
    p := p^.next;
    END;

  IF pLast <> Nil THEN pLast^.next := pmNeu
                  ELSE pmRoot := pmNeu;  {* 1. Paket in der Kette *}
  pmNeu := NiL;
lEop:
END;

FUNCTION GetQueueData  (VAR pmRoot  : tp_mBuf;
                        VAR QueueSize : LongInt;
                            pDest   : POINTER;
                            maxSize : WORD;
                            stopCh  : CHAR ) : WORD;
{* Holt vom Anfang der Queue maximal MAXSIZE Zeichen bzw. bis das Zeichen *}
{* STOPCH auftaucht (#0 gilt als DON'T CARE(geht nicht!), STOPCH wird     *}
{* mitkopiert) (was halt eher passiert) und schreibt sie nach PDEST^. Der *}
{* Aufrufer muss den Platz bereitgestellt haben.                          *}
{* Alle dabei verbrauchten Buffer werden gelscht.                        *}
{* QueueSize wird entsprechend korrigiert                                 *}
{* Zurckgegeben werden die Anzahl der nach PDEST^ geschriebenen Zeichen. *}
  VAR n,  {* Zhler insgesamt kopierte Bytes *}
      nCM {* Zhler der aus dem aktuellen Buffer (pCM^) kopierten Bytes *}
               : WORD;
      pCM,
      pCMLast,
      pz, pw   : tp_mBuf;
      pSrc     : POINTER;
      ende     : BOOLEAN;
BEGIN
  GetQueueData := 0;
  IF pmRoot = NiL THEN Exit; {* Nix drin! *}
  pCM := pmRoot;   {* Zeiger auf derzeit zur Datenentnahme verwendeten pm *}
  pSrc:= pmRoot^.pData;
  pCMLast := NiL;  {* Zeiger auf letzten vollstndig aufgebrauchten MBUF *}
  nCM := 0;        {* Anzahl verwendeter Bytes im aktuellen MBUF *}
  n := 0;  Ende := FALSE;
  WHILE (n < maxSize) AND NOT Ende DO
    BEGIN
    IF (nCM >= pCM^.inUse)
      THEN BEGIN {* Buffer ist aufgebraucht, hole nchsten *}
           pCMLast := pCM;   {* Zwischenmerken *}
           pCM := pCM^.next;
           nCM := 0;
           ende := (pCM = NiL);
           IF NOT ende THEN pSrc := pCM^.pData;
           END
      ELSE BEGIN
           BYTE (pDest^) := BYTE (pSrc^);  {* Die eigentliche Kopieraktion *}
           Inc (n); Inc (nCM);
           IF char (pSrc^) = stopCh THEN
             BEGIN
             ende := TRUE;
             IF (nCM >= pCM^.inUse)
               THEN BEGIN {* Sonderfall, wenn Stopzeichn das letzte Zeichen im akt. mBuf ist *}
                    pCMLast := pCM;
                    pCM := pCM^.next;
                    nCM := 0;
                    END;
             END;
           Inc (word(pSrc));  Inc (word(pDest));
           END;
    END;
{* pCMLast zeigt nun auf den letzten zu lschenden Block *}

{* krzen von pCM^, wenn der Block mittendrin zu Ende war *}
  IF nCM > 0 THEN DelMBufData (pCM, nCM); {* nur die ersten nCM Bytes sind kopiert worden *}

{* lschen aller Buffer zwischen pmRoot und pCMLast (incl.) *}
  pz := pmRoot;
  pmRoot := pCM;
  WHILE (pz <> Nil) AND (pz <> pCM) DO
    BEGIN
    pw := pz^.next;
    Del_mBuf (pz);
    pz := pw;
    END;

  {* Abfrage, um RangeCheckError zu vermeiden *}
  IF n<=QueueSize THEN Dec(QueueSize,n)
                  ELSE BEGIN
                       QueueSize := 0;
                       Inc(count[cntErrGetData]);
                       END;
  GetQueueData := n;
END;



FUNCTION GetMBufFromQueue (VAR pmRoot : tp_mBuf ) : tp_mBuf;
 {* Hngt genau einen mBuf-Buffer am Anfang der Queue aus. Dies entspricht *}
 {* gerade dem Nettoinhalt eines RXten Frames. Fr die Vernichtung des     *}
 {* Buffers nach Gebrauch hat der Aufrufer selbst zu sorgen. Ebenso fr *}
 {* das Herabzhlen irgendwelcher SizeVaraiblen!              *}
  VAR pz : tp_mBuf;
BEGIN
  GetMBufFromQueue := NiL;   {* Davon gehen wir mal aus *}
  IF pmRoot = NiL THEN Exit; {* Ist ja gar nix da *}
  pz := pmRoot;              {* Wagon besteigen.. *}
  pmRoot := pmRoot^.Next;    {* ... und Zugrest abkoppeln *}
  pz^.next := NiL;           {* sicher ist sicher *}
  GetMBufFromQueue := pZ;
END;


PROCEDURE PeekQueueData ( pmRoot : TP_mBuf;
                          maxSize : WORD;
                          stopCh : CHAR;
                      VAR offset : WORD;
                      VAR pReturn : POINTER );
{* Werfe einen Blick in die Queue - Inhalt oder Verweise werden, und ich sage
 * dies mit allen Nachdruck, meine lieben Freude, in keinster Weise gendert.
 * Denn diese Routine, und dabei bin ich vllig offen, soll nur zum Zwecke
 * der Einsichtnahme und nicht zum, was ich ganz und gar unertrglich fnde,
 * der Spionage dienen. (Ghnen des Abgeordneten Mega-HZ (CPU))
 * Sucht ab Anfang der Queue (pmRoot), maximal MAXSIZE Zeichen weit nach dem
 * Zeichen STOPCH ab. Wenn gefunden wird der Offset zurckgeliefert und
 * pReturn zeigt drauf, ansonsten sind die Werte 0 bzw. NiL.
 *}
  VAR n ,nCM      : WORD;
      pz, pw, pcm : TP_mBuf;
      pSrc        : POINTER;
      ende, found : BOOLEAN;
BEGIN
  offSet := 0; pReturn := NiL; found := FALSE;
  IF pmRoot = NiL THEN Exit;
  n := 0;
  pCm := pmRoot;  nCm := 0;
  ende := FALSE;
  pSrc:= pCM^.pData;
  WHILE (n < maxSize) AND NOT ende DO
    BEGIN
    IF nCm = pCm^.inUse
      THEN BEGIN {* nchster Block *}
           nCM := 0;
           pCm := pCm^.next;
           pSrc:= pCM^.pData;
           ende := pCM = NiL;
           END
      ELSE BEGIN
           Inc (n); inc(nCm);
           IF char (pSrc^) = stopCh THEN
             BEGIN {* Zeichen gefunden ! *}
             ende := TRUE;
             found := TRUE;
             pReturn := pSrc;
             END;
           Inc (word(pSrc));
           END;
    END;
  IF found THEN offset := n
           ELSE offset := 0;
END;


{}


PROCEDURE _ScanForText ( VAR sArg, sErg : String );
  {* liest das nchste Argument als Text (mit " als MetaZeichen) *}
  {* wird aus sArg geloescht und zurckgegeben *}
  VAR i      : BYTE;
      ende   : BOOLEAN;
      SkipSpace : BOOLEAN;
BEGIN
  sErg := '';  i := 1;
  WHILE  (sArg[i] = ' ') AND ( i < Length(sArg) ) DO Inc (i);
  {* ab sArg[i] steht das nchste Argument oder Stringende *}
  skipSpace := (sArg[i] = '"');
  IF skipSpace THEN Inc (i);
  ende := FALSE;
  WHILE (NOT ende) AND ( i <= Length(sArg) ) DO
    BEGIN
    IF skipSpace THEN ende :=  sArg[i] = '"'
                 ELSE ende :=  sArg[i] <= ' ';
    IF NOT ende THEN BEGIN
                     AddChar(sErg,sArg[i]);
                     Inc (i);
                     END;
    END;
  Delete (sArg, 1,i);
END;

FUNCTION ScanForVal ( VAR sArg : String ) : longint;
  VAR sErg : String;
      v    : LongInt;
      error : Integer;
BEGIN
  ScanForText(sArg,sErg);
  Val( sErg, v, error );
  IF error = 0 THEN ScanForVal := v
               ELSE BEGIN
                    sArg := sErg + ' ' + sArg;
                    ScanForVal := 0;
                    END;
END;


FUNCTION ScanForNum ( VAR sArg : String ) : longint;
  {* testet ob das nchste Argument eine WORD ist                  *}
  {*  - wenn ja wird sie aus sArg geloescht und zurckgegeben;     *}
  {*  - wenn nicht bleibt sArg unverndert und es wird NOTANUMBER  *}
  {*    zurckgegeben                                              *}
  VAR i,z    : BYTE;
      wZwisp : Longint;
      c : Char;
      ende,fHex   : BOOLEAN;
BEGIN
  ScanForNum := NOTANUMBER;
  IF sArg ='' THEN Exit;
  i := 1;
  WHILE  (sArg[i] = ' ') AND ( i < Length(sArg) ) DO Inc (i);
  {* ab sArg[i] steht das nchste Argument oder Stringende *}

  wZwisp := 0; ende := FALSE;
  fHex := sArg[i] = '$';
  IF fHex  {* umstndlich, aber schnell (zu implementieren) }
    THEN BEGIN {* hexadezimal *}
         Inc(i); {* $ berlesen *}
         WHILE  (NOT ende) AND ( i <= Length(sArg) ) DO
           BEGIN
           c := UpCase (sArg[i]);
           ende := ((c<'0') OR (c>'9'))  AND ((c<'A') OR (c>'F'));
           IF NOT ende THEN
             BEGIN
             z := BYTE (c) - BYTE ('0');
             IF z > 10 THEN Dec(z,7);
             wZwisp := 16*wZwisp + z;
             Inc (i);
             END;
           END;
         END
    ELSE BEGIN  {* Dezimal *}
         WHILE  (NOT ende) AND ( i <= Length(sArg) ) DO
           BEGIN
           ende := (sArg[i] < '0') OR (sArg[i] > '9');
           IF NOT ende THEN
             BEGIN
             wZwisp := 10*wZwisp + BYTE (sArg[i]) - BYTE ('0');
             Inc (i);
             END;
           END;
         END;

  IF (sArg[i] = ' ') OR ( i > Length(sArg) ) THEN
    BEGIN {* Zahl erkannt *}
    ScanForNum := wZwisp;
    Delete (sArg, 1,i);
    END;
END;


FUNCTION ScanStr ( VAR sArg : String;  pVgl : POINTER; lVgl : WORD) : BYTE;
{*
 * Sucht nach einem String(teil) aus sARG in pVgl^. Gefundene Argumte
 * werden aus sArg entfernt
 * Beispiel:
 *
 * CONST  xtext = 'CONNECT CONVERS INFO HELP ';
 *        x : ARRAY [1..length(xText)] OF CHAR = xText;
 * ScanStr ( 'Conv', @x, sizeOf(x) )
 * liefert 2 zurck
 *
 * ScanStr ( 'sdkfhsdfConv', @x, sizeOf(x) )
 * liefert 0 zurck (nicht gefunden)
 *
 * ScanStr ( 'c', @x, sizeOf(x) )
 * liefert 1 zurck (zuerst gefunden)
 *
 * Die Vergl.Tabelle muss in Grossbuchstaben sein !
 *}

  LABEL l_eop;
  VAR vglNr, i, lArg : BYTE;
      iVgl           : WORD;
      return         : BYTE;
BEGIN
  {*
   * LTRim (sArg)
   * krze Sarg ab 1. leerzeichen
   * ::: suche 1. nichtleerzeichen im VglString (also ab p)
   *     memeq ( @sArg[1], p, length (sArg);
   *     wenn gleich--> klasse !
   *     wenn nicht suche 1. leerzeichen im vglString, und gehe nach :::
   *}
  return := 0;
  LTrim (sArg);
  {* Steuerzeichen am Ende entfernen *}
  WHILE (Length(sArg)>0) AND ( sArg [Length(sArg)] < #32 ) DO
    Dec (Byte(sArg[0]));

  lArg := Pos (' ',sArg);
  IF lArg = 0 THEN lArg := length (sArg)
              ELSE Dec (lArg); {* das Leerzeichen selbst interessiert nicht *}
  IF lArg = 0 THEN GOTO l_eop;

  IF sArg[1] <> '"' THEN {* wenn Anfhrungszeichen, dann nicht gross machen *}
     FOR i := 1 TO lArg DO
       sArg[i] := UpCase (sArg[i]); {* Nur das 1.Argument gross machen *}

{* suche 1. nichtleerzeichen im VglString (also ab p) *}
  iVgl := 1; vglNr := 0;
  REPEAT
    WHILE (char(pVgl^) = ' ') AND (iVgl <= lVgl) DO
      BEGIN
      Inc (iVgl); Inc (word(pVgl));
      END;
    IF iVgl > lVgl THEN GOTO l_eop;
    IF iVgl + lArg > lVgl THEN GOTO l_eop; {* der restliche Vergleichsstring ist zu kurz-->kann also nicht stimmen *}
    Inc (vglNr);
    IF MemEq ( @sArg[1], pVgl, lArg)
      THEN return := vglNr
      ELSE BEGIN
           {* Suche 1. Leerzeichen im vglString *}
           WHILE (char(pVgl^) <> ' ') AND (iVgl <= lVgl) DO
             BEGIN
             Inc (iVgl); Inc (word(pVgl));
             END;
           IF iVgl > lVgl THEN GOTO l_eop;
           END;
  UNTIL return <> 0;
l_eop:
  IF return <> 0 THEN Delete (sArg, 1, lArg);
  ScanStr := return;
END;


{}


FUNCTION MemEq ( a,b : Pointer; Len : WORD ) : BOOLEAN;
{$IFDEF neverdef}
BEGIN
  MemEq:= TRUE;
  WHILE Len <> 0 DO
    BEGIN
    IF Byte(a^) <> Byte (b^) THEN BEGIN
                                  MemEq := FALSE;
                                  Exit;
                                  END;
    Inc (word(a));
    Inc (word(b));
    dec (len);
    END;
END;
{$ELSE}
ASSEMBLER;
  {* Vergleicht die Speicherbereiche auf die A und B zeigen. Lediglich die
   * Offsets werden erhht, also VORSICHT mit nicht normalisierten Zeigern
   * und grossen Lngen *}
ASM
             push   ds
             mov    cx, len
             lds    si,A
             les    di,B
@@0:
             cmp    cx,0000        {* Lnge testen *}
             je     @@1            {* Schluss jetzt *}
             mov    al,ds:[si]
             cmp    al,es:[di]     {* da gibts bestimt noch ein Abk.-Befehl fr *}
             je     @@2
             mov    al,00          {* MemEq := FALSE *}
             jmp    @@99           {* Exit }
@@2:
             inc    si
             inc    di
             dec    cx
             jmp    @@0
@@1:
             mov    al,01          {* MemEq := TRUE *}
@@99:
             pop ds
END;
{$ENDIF}

FUNCTION MemGE ( a,b : Pointer; Len : WORD ) : BOOLEAN;
BEGIN {* True: a^>=b^ *}
  MemGE := TRUE;
  WHILE Len <> 0 DO
    BEGIN
    IF Byte(a^) = Byte (b^)
      THEN BEGIN
           Inc (word(a));Inc (word(b));
           Dec (len);
           END
      ELSE BEGIN
           MemGE := Byte(a^) > Byte (b^);
           Exit;
           END;
    END;
END;

FUNCTION MemCmp ( a,b : Pointer; Len : WORD ) : shortint;
 {* Return 0 wenn gleich
  *       -1 wenn a^<b^
  *        1 wenn a^>b^  *}
BEGIN
  MemCmp := 0;
  WHILE Len <> 0 DO
    BEGIN
    IF Byte(a^) = Byte (b^)
      THEN BEGIN
           Inc (word(a));
           Inc (word(b));
           Dec (len);
           END
      ELSE BEGIN
           IF Byte(a^) < Byte (b^)
             THEN MemCmp := -1
             ELSE MemCmp := 1;
           len := 0;
           END;
    END;
END;


END.
