UNIT FD_State;
{$I FD_INCL.PAS}

INTERFACE

USES FD_Def;


PROCEDURE UnknownQSO ( pM : TP_mBuf; VAR pCB : TP_axCB);

PROCEDURE Event_BecomeBusy (pCB : TP_axcb);
PROCEDURE Event_BecomeUnBusy (pCB : TP_axcb);
PROCEDURE Event_LocalStart(pCB:TP_AXCB);
PROCEDURE Event_LocalStop (pCB:TP_AXCB);

PROCEDURE t1Out ( p : Pointer );
PROCEDURE t2Out ( p : Pointer );
PROCEDURE t3Out ( p : Pointer );
PROCEDURE tTimeOutOut ( p : Pointer );

PROCEDURE DoDisConnect ( pCB : TP_axcb );
PROCEDURE DoDisconnectImm ( pCB : TP_axcb );

 FUNCTION Try2Connect ( ifnr : T_IFNR; f,t,v : String; fIncSSID : BOOLEAN ) : tp_axcb;
    CONST cINCSSID=TRUE;  cNOINCSSID=FALSE;

PROCEDURE GetDigiConnected ( pCB : tp_axCB ); {* in FD_INFO verwendet *}
PROCEDURE CalcState ( VAR pCB : TP_axcb; VAR pm : tp_mBuf);


{}

IMPLEMENTATION


USES FD_AxCB,
     FD_Div, {* wg. DI / EI *}
     FD_Tx,
     FD_Sysop, {* getWatch *}
     FD_Subr,
     FD_mBuf,
     FD_Main,   {* Queuemsg *}
     FD_Timer,
     FD_Circ,
     FD_Info,
     FD_NetRom,
     FD_Error, {* StoreStack *}
     FD_AR,
     FD_Beacon,
     FD_Log,    {* LogAddEntry *}
     {$IFDEF SCC} FD_TNC,
     {$ELSE}	  FD_CRT,
     {$ENDIF}
     FD_Mem;

{}


FUNCTION Try2Connect ( ifnr : T_IFNR; f,t,v : String; fIncSSID : BOOLEAN ) : tp_axcb;
{* Baue ein QSO gemss f,t,v auf - KEIN Routing!  Ist fIncSSID TRUE, so wird
 * die SSID von f solange erhht, bis QSO mglich ist
 *}
  VAR pCB : tp_axcb;
      fEnde,fOk : BOOLEAN;
      sh : T_ShCall;
      ssid : BYTE;
BEGIN
  Try2Connect := NiL;
  Upper(f);  Upper(t);	Upper(v);
  REPEAT {* SSID - Erhh-Schleife - bei Bedarf *}
    fOK := (SearchAxcbAscDigi ( f,t,v ) = NiL);
    fEnde := TRUE;
    IF NOT fOK AND fIncSSID THEN
      BEGIN
      {* SSID von FROM erhhen, falls mglich *}
      AscCall2shift ( f, sh );
      ssid := (byte(sh[7]) SHR 1) AND 15;
      IF SSID < 15 THEN BEGIN
                        byte(sh[7]) := ((SSID+1) * 2);
                        Shift2ascCall (sh,f);
                        fEnde := FALSE; {* nochma probieren *}
                        END;
      END;
  UNTIL fOK OR fEnde;

  IF fOK THEN
    BEGIN {* Ein derartiges QSO existiert noch nicht *}
    pCB := CreateAXCB(ifnr);
    IF pCB <> NiL THEN
      BEGIN
      pCB^.iFace := ifnr;
      Asc2axcb ( f,t,v, pCB );
      {$IFnDEF Hostmode} {* Kommt nicht gut, fast jeder HostmodeConnect ist ein Selbstconnect *}
      IF CmpShCall ( pCB^.tocall, pCB^.fromCall ) AND
         (axIFace[pCB^.iface].art = aUser) THEN LogAddEntry ( pCB, leSELFCONNECT ,'');
      {$ENDIF}
      Event_LocalStart (pCB); {* los gehts! *}
      END;
    Try2Connect := pCB;
    END;
END;

{}

Procedure HandleFlensBurg(pCB:TP_AXCB; wert:ShortInt);
{* Werte: Reject Rx:        +9
 *        RR (Response)     -4
 *        Retry             +5
 *}
BEGIN
  Inc(pCB^.Flensburg,wert);
  IF      pCB^.Flensburg < 0   THEN pCB^.Flensburg := 0
  ELSE IF pCB^.Flensburg > 20  THEN pCB^.Flensburg := 20;

  {* Zuckerbrot und Peitsche *}
  IF use[iusFlensburg] THEN
    BEGIN
    IF      pCB^.Flensburg > 13 THEN pCB^.maxFrame := 1
    ELSE IF pCB^.Flensburg >  7 THEN pCB^.maxFrame := axIFace[pCB^.iface].maxFrame_init DIV 2 + 1
    ELSE IF pCB^.Flensburg <  1 THEN pCB^.maxFrame := axIFace[pCB^.iface].maxFrame_init;
    END;
END;



PROCEDURE t1Out ( p : Pointer );
  VAR byZwisp : BYTE;
      pCB : TP_Axcb;
      pmtxqBy : TP_mBuf;
BEGIN
  pCB := p;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
{$IFDEF DAMA_SLAVE}
  IF (pCB^.state = CONNECTED) AND pCB^.fDama THEN Exit;
{$ENDIF}

  IF pCB^.tries >= pCB^.Retry
    THEN BEGIN {* Retried out *}
	 StopTimer (pCB^.t1);
	 QueueMsg (pCB, msgRetryCountExceeded ); {* Mierfolg melden *}
	 Event_LocalStop (pCB); {* und Verbindung beenden *}
	 END
    ELSE BEGIN {* Next Try *}
         Inc (pCB^.tries); {* wird evtl. wieder runtergezhlt, s.u. *}
	 StopTimer (pCB^.t1);
	 StopTimer (pCB^.t3); {* sicher ist sicher *}
	 CASE pCB^.state OF
	   CONNECTED
	    : BEGIN
	      StopTimer (pCB^.t2); {* Es wird ja auf jeden Fall was besttigt *}
	      byZwisp := (pCB^.lastack + 1) MOD 8;
              {*!!! anzahl unack testen !!!??? zur Qualittskontrolle *}
              pmtxqBy := pCB^.txQ[byZwisp];
              IF (pmtxqBy = Nil) {* erstes unbesttigte Paket *}
                THEN BEGIN {* tja, wat nu: t1 lief, obwohl nix mehr zum *}
                     {* Nachfragen vorliegt !? Kann ja eigentlich nur 'ne *}
                     {* laufende t3-Nachfrage sein. Also muss ein Poll    *}
                     {* rausgehen und t1 gestartet werden. s.u.           *}
                     Tx_Ctrl (pCB, RMR, cPOLL, pCB^.t1);
		     END
                ELSE BEGIN {* das unbest. Paket ist noch da *}
		     {* Das Frame, welches nachgefragt wurde, muss schon *}
		     {* ausgesendet sein, ansonsten waere pollen sinnlos.*}
		     {* Dann darf auch Retry nicht erhht werden. *}
   	             IF (pmtxqBy^.txed) <> TRANSMITTED
                        THEN Dec(pCB^.tries)  {* korrigieren *}
                        ELSE BEGIN
                             HandleFlensburg(pCB,+5);
                             IF (pCB^.tries <= 3) AND
		                (pmtxqBy^.inUse - pmtxqBy^.ofsCtl - 1
 			          < axIFace[pCB^.iFace].iPollSchwelle)
		                  THEN TX_fromTXq ( pCB, byZwisp, POLL ) {* IPollen *}
		                  ELSE Tx_Ctrl (pCB, RMR, cPOLL, pCB^.t1);
                             END;
                     END; {* = NiL *}
	      END; {* Connected *}
	   DISCONNECTED
	    : BEGIN
              QueueMsg (pCB,msgSpecialT1Out);{???}
              END;
	   DISCPENDING
	    : IF pCB^.fDama THEN Exit
                            ELSE Tx_Ctrl (pCB, DISC , cPOLL, pCB^.t1);
	   SETUP
	    : Tx_Ctrl (pCB, SABM , cPOLL, pCB^.t1);
	  END; {* Case *}
	 pCB^.rejSent := FALSE;
	 StartTimerFast (pCB^.t1);
         IF use[iusLOGAFRACK] THEN
            BEGIN
            {* 1,5sek draufaddieren wg. logarithmischen Frack *}
            Inc(pCB^.t1.TicksRemaining, 150);
            END;
	 END; {* Next Try *}
  WatchDog;
END;

PROCEDURE t2Out ( p : Pointer );
{* T2 abgelaufen - jetzt mssen wir mal was senden
 * Oder: Antwort auf DAMA-Poll <*}
  VAR pCB : TP_Axcb;
      byDummy : WORD;
BEGIN
  pCB := p;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  StopTimer (pCB^.t2); {* na ja, sollte eigentlich nich mehr laufen *}

  pCB^.rejsent := FALSE;

  IF pCB^.busy AND (pCB^.frameToSendT2=REJ) THEN pCB^.frameToSendT2 := RNR;
    {* Ein gesendetes REJ wuerde den anderen denken machen, *}
    {* dass mein busy-Zustand vorbei waere. Also RNR senden *}

  byDummy := 0;
{$IFDEF DAMA_SLAVE}
  IF pCB^.fDama THEN
     byDummy := TryToTxIFrames (pCB,cNORMAL); {* senden, auch wiederholt *}
{$ENDIF}

  IF byDummy = 0 THEN
    IF pCB^.PF = cPOLL THEN Tx_Ctrl (pCB, pCB^.frameToSendT2, cFINAL, NULLTIMER)
                       ELSE Tx_Ctrl (pCB, pCB^.frameToSendT2, cMELD, NULLTIMER);
  pCB^.PF := cNULL;

{$IFDEF DAMA_SLAVE}
  IF pCB^.fdama THEN Exit;
{$ENDIF}

  IF pCB^.nUnbest > 0
    THEN BEGIN {* Wir warten noch auf Besttigungen, also fracken *}
         {* Wir haben grade was gesendet, dann kan man FRACK noch mal vom Startwert her laufen lassen *}
	 StartTimerFast (pCB^.t1);
	 END
    ELSE BEGIN {* keine ausstehenden Frames mehr *}
	 StopTimer  (pCB^.t1);
         StartTimer (pCB^.t3); {* Den hatten wir beim Starten von T2 ausgemacht *}
	 END
END;


PROCEDURE t3Out ( p : Pointer );
{* T3 abgelaufen *}
  VAR pCB : TP_AXCB;
BEGIN
  pCB := p;
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  IF pCB^.state = CONNECTED THEN {* Nur in diesem Status sinnvoll *}
    BEGIN {* Kontrolle ob Verbindung noch besteht und evt. ob noch RNR *}
    StopTimer (pCB^.t3);
    StopTimer (pCB^.t2);       {* Wir senden ja sofort was *}

    {$IFDEF DAMA_SLAVE}
      IF pCB^.fdama THEN Exit; {* Spontanbetrieb bei DAMA-Slave darf nicht sein *}
    {$ENDIF}

    Tx_Ctrl (pCB, RMR, cPOLL, pCB^.t1 );
    StartTimerFast (pCB^.t1);  {* Frack starten, da  Antwort erforderlich *}
    WatchDog;
    END;
END;

PROCEDURE tTimeOutOut ( p : Pointer );
BEGIN
  QueueMsg(tp_AXCB(p),msgTimeOut);
END;



{}

PROCEDURE EVENT_LocalStart (pCB:TP_AXCB);
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  IF pCB^.state <> Setup THEN
    BEGIN
    IF fHackFlxComp THEN TX_Ctrl_SABMHack(pCB, SABM, cPOLL,pCB^.id, pCB^.t1)
                    ELSE Tx_Ctrl (pCB, SABM, cPOLL, pCB^.t1);
    pCB^.State := SETUP;
    StopTimer ( pCB^.t3 );
    StartTimerFast ( pCB^.t1 );
    END;
  WatchDog;
END;

{$F+}
PROCEDURE fMsgDisc ( pCB : tp_axcb; msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
BEGIN
  IF (msg=msgTX) AND (pCB^.txBufSize=0) AND (pcb^.nUnbest = 0)
    THEN BEGIN
         pcb^.fMsgHandler := fnMsgDefault;
         Event_LocalStop (pCB);
         END
    ELSE fnMsgDefault ( pCB, msg );
END;


PROCEDURE DoDisConnect ( pCB : TP_axcb );
BEGIN
  IF pCB = NiL THEN Exit;
  {* nur wenn alle anstehenden Frames besttigt sind, sofort unterbrechen. *}
  {* sonst auf die Routine umleiten, die nach Besttigen aller             *}
  {* Frames disconnected..                                                 *}
  IF (pCB^.nUnbest = 0) AND (pCB^.txBufSize = 0)
    THEN Event_LocalStop (pCB)
    ELSE pCB^.fMsgHandler := fMsgDisc;
END;


PROCEDURE DoDisconnectImm ( pCB : TP_axcb );
 {* Sofort, ohne warten da TXQueue sich leert, disconnecten *}
BEGIN
  IF pCB <> NiL THEN Event_LocalStop (pCB);
END;


PROCEDURE EVENT_LocalStop ( pCB:TP_AXCB );
BEGIN
  {* StoreStack ('i',fstr(pCB^.iface)); *}
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  CASE pCB^.state OF
   Ignore,
   DisConnected : Del_AXCB (pCB);

   SetUp,
   DiscPending	: BEGIN
		  StopTimer (pCB^.t1);
		  IF pCB^.state = SETUP
		    THEN Tx_Ctrl (pCB, DISC, cPOLL, NULLTIMER)
		    ELSE Tx_Ctrl (pCB, DM,   cMELD, NULLTIMER);
		  pCB^.state := Disconnected;
		  Del_AXCB (pCB);
		  END;
            {* Connected.... *}
	    ELSE {of CASE }
                 BEGIN {* Nur hier wird DISC gestartet *}
                 {$IFDEF DAMA_SLAVE}
                   IF NOT pCB^.fDama THEN {* erst auf poll warten! *}
                 {$ENDIF}
	               Tx_Ctrl (pCB, DISC, cPOLL, pCB^.t1 );
		 {* Disconectversuche erfolgen nicht sooo oft...aber mindestens einmal *}
		 pCB^.Retry := 1+axIFace[pCB^.iFace].retry_init DIV 4;
		 pCB^.state := DiscPending;
		 pCB^.remoteBusy := FALSE;
		 pCB^.tries := 0;
		 StopTimer (pCB^.t3);
		 StopTimer (pCB^.t2);
		 StartTimerFast (pCB^.t1);
		 END;
	       END;
END;


PROCEDURE Event_BecomeBusy (pCB : TP_axcb);
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
 {* $TODO: Probleme, wenn zu schnell busy/unbusy. Beispiel: Window 512 Byte,
  * Befehl Parameter wird gegebn -| unntiges Poll, denn Puffer wird kurzzetig
  * voll, daher busy, und sofort wieder unbusy, der mittels RR+ aufgehoben wird
  *}
  pCB^.busy := TRUE;
  WatchDog;
END;

PROCEDURE Event_BecomeUnBusy (pCB : TP_axcb);
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  IF pCB^.busy THEN
      BEGIN
      pCB^.busy := FALSE;
      {* ein RR MUSS lt. Protokoll auf jeden Fall gesendet werden *}
      {* als Hinweis, dass wir wieder unbusy sind, t1 starten damit *}
      {* der Partner diese RR-Aussendung auch bestaetigt *}
      Inc(Count[cntBusyResolve1]);
      IF pCB^.rnrSent AND NOT pCB^.fDAMA THEN {* Spontan betrieb ist bei DAMA SLAVE verboten *}
        BEGIN {* Es wurde bereits ein rnr gesendet *}
        Inc(Count[cntBusyResolve2]);
        Tx_Ctrl (pCB, RR, cPOLL, NULLTIMER); {* Hier wird auch rnrSent zurckgesetzt *}
        StopTimer (pCB^.t3);
        StopTimer (pCB^.t2);
        StartTimerFast (pCB^.t1);  {* NR-Timer waere besser !? *}
        END;
      END;
  WatchDog;
END;


{}

PROCEDURE UnknownQSO ( pM   : TP_mBuf;
                   VAR pCB  : TP_axCB  );
{* in pM^ ist ein Frame an oder ber uns, aber
 * wir haben kein dazugehrendes QSO gefunden
 *}
  VAR frameTyp : T_FrameTyp;
      kmpf     : T_KMPF;
      ok       : BOOLEAN;
      pid      : BYTE;
      bgModus  : BYTE;
      p        : Pointer;
      pCBDummy : TP_AXCB;
      mode     : (modeDirect,modeDigi);
BEGIN
  {* Erstmal alles mit Henkeln zum Anpacken versehen... *}
  p := pm^.pData;
  if pm^.nMyCall = 0 THEN mode := modeDirect
                     ELSE mode := modeDigi;
  frameTyp := GetFrameTyp (pm);
  kmpf     := GetKMPF(pm);
  {* ... und einen leeren AXCB besorgen *}
  pCB := CreateAXCB (pm^.ifnr);
  IF pCB = Nil THEN Exit; {* Fataler Fehler (kein Speicher mehr oder so)! Sofort abbrechen *}
  pCB^.pf := kmpf;
  pm2pCB ( pM, pCB );  {* pCB^ mit Daten aus pm^ fllen, dabei Pfad umdrehen *}

  IF mode = modeDigi
    THEN pCB^.QSOType := qtCircuitSlave
    ELSE pCB^.QSOType := qtInfoBox;

  WatchDog;
  IF FrameTyp = SABM
    THEN BEGIN {* Connect will er ? aha *}
	 bgModus := GetWatch (pCB);
	 IF mode=modeDigi THEN
	   BEGIN {* Bei Direkt QSOs wird die Kontrolle von der Infobox aus durchgefhrt *}
	   IF upCallCheck THEN
	     IF NOT ValidCall (f_sh2asc(pCB^.toCall)) THEN bgModus := bgSILENT;
	   IF dnCallCheck THEN
	     IF NOT ValidCall (f_sh2asc(pCB^.fromCall)) THEN bgModus := bgSILENT;
	   {* VIA Qsos kann man nicht auf die Infobox beschrnken, also ignorieren *}
	   IF (bgModus = bgNoExtConnect) THEN bgModus := bgSILENT;
	   END;
	 IF (bgModus AND bgSILENT) <> 0
	   THEN Del_AXCB (pCB) {* gar nicht drauf antworten *}
	   ELSE IF (bgModus AND bgDM) <> 0
		  THEN BEGIN
		       {* Busy senden bei DirektQSO, Nicht bei vias, sonst wrde *}
		       {* man meinen das dass DM vom wirklichen Ziel kommt!      *}
		       IF mode <> modeDigi THEN Tx_Ctrl (pCB, DM, reply[kmpf], NULLTIMER);
		       Del_AXCB (pCB);
		       END
		  ELSE BEGIN  {* WATCH & Co. haben QSO-Aufbau erlaubt *}
		       IF mode = modeDirect THEN
			 BEGIN
			 CalcState (pCB,pm); {* ganz normal ber Zustandstabelle aufbauen *}
                         Exit;
			 END;
		       IF mode = modeDigi
			 THEN BEGIN {* Digipeaten bzw. Linken *}
			      IF (axIFace[pm^.ifnr].l2DigiOn) AND {* Auf diesem Interface erlaubt ? *}
				 (SABMmode<>smDMall)        AND {* Und connecten des Digis ist nicht generell.. *}
				 (SABMmode<>pm^.ifnr)       {* ..oder fr das Iface verboten *}
				    THEN pCBDummy := DoDigiConnect (pCB,pm)
				    ELSE Del_AXCB (pCB);
			      END;
		       END;
	 END
    ELSE IF (FrameTyp = UI) THEN
	   BEGIN
	   pid := GetPID (pm);
           bgModus := GetWatch (pCB);
           IF UIRoute (pCB) THEN;;;; {* pCB^ wird gendert *}
	   IF mode = modeDigi
	     THEN BEGIN {* UI BER uns  *}
		  {* Berechtigung testen: *}
		  CASE axIFace[pCB^.iFace].UIMode OF {*OPT*: alles in eine Abfrage *}
		     uiNoAX25 : ok := pid <> PID_TEXT;
		     uiTXD    : ok := (pid <> PID_TEXT) OR (pm^.inUse <= pm^.ofsctl+2); {PID + EOL}
		     uiKeine  : ok := FALSE;
		  {* uiAlle   : ok := TRUE; *}
		     ELSE ok := TRUE;
		    END;

		  IF ok AND (bgModus AND bgNoOutConnect=0) THEN {* darf er ? *}
                    RepaetRoutedPM(pCB,pm); {* ja, also wieder aussenden *}
		  END
	     ELSE BEGIN {* UI AN uns *}
		  IF (bgModus AND bgNoOutConnect=0) THEN {* darf er? *}
		    BEGIN {* Er darf *}
		    IF kmpf = cPOLL THEN Tx_Ctrl (pCB, DM, cMELD, NULLTIMER);
		    IF useTheNet THEN IF pid = PID_NETROM THEN NR_RxBroadcast (pm);
		    END
		  END; {* UI an uns *};
	   Del_AXCB (pCB);
	   END {* IF = UI *}
    ELSE IF (FrameTyp = FRMR) THEN
           BEGIN
           {* Es muss an uns gerichtet sein - da es ja unknown QSO ist knnen wir nicht fr andere antworten *}
           IF mode<>modeDigi THEN {* AN uns *}
   	     BEGIN
	     pm2pcb( pM, pCB );
	     Tx_Ctrl (pCB, DISC, cFINAL, NULLTIMER);
	     Del_AXCB (pCB);
	     END;
           END
    ELSE IF mode = modeDirect THEN
           BEGIN {* Alles andere AN uns wegtun *}
	   IF (kmpf=cPOLL) THEN Tx_Ctrl (pCB, DM, cFINAL, NULLTIMER);
	   Del_AXCB (pCB);
           END
    {* so, hier kommen nur noch mode=modeDigi hin *}
    ELSE IF (FrameTyp = DM) AND (kmpf=cFINAL) THEN
	 BEGIN {* DM- *}
	 IF NOT DMfinalReceived (pm, pCB) THEN {* DM-Final bearbeiten *}
           BEGIN {* normal routen, denn das war keine Antwort auf ein FIND von uns *}
           {* pm2pcb_Reverse (pM,pCB); *}
           IF UIRoute( pCB ) THEN; {* Pfad/Interface eventuell ndern *}
           RepaetRoutedPM(pCB,pm); {* ja, also wieder aussenden *}
           END;
         Del_AXCB (pCB);
	 END
    ELSE BEGIN
	 IF use[iusRouteUnknown] THEN
           BEGIN
           IF UIRoute( pCB ) THEN; {* Pfad/Interface eventuell ndern *}
           RepaetRoutedPM(pCB,pm); {* also wieder aussenden *}
           END;
         Del_AXCB (pCB);         {* Reste in den gelben Sack *}
	 END;
END;


{}

TYPE T_how = (AGAIN,FIRST);
     T_MITINF = (MITINF,OHNEINF);

PROCEDURE GetConnected (pCB:tp_axcb; how:t_how; infobox : T_MitInf);
  VAR i,nCon : WORD;
      lnpakete : longint;
BEGIN
WITH pCB^ DO
  BEGIN
  nCon := 0;
  IF how=FIRST THEN
    BEGIN {* Nur beim ersten Mal - sind nmlich schon welche ausgesendet
	   * worden, so muessten ansonsten die Queues gelscht werden und
	   * - was schlimmer waere - die MessageHandler muessten sich auch
	   * selbst reseten. hmmm... wahrscheinlich muss man doch eine neue
	   * Message msgLinkReset einfhren - allein schon wg. dem Hostmode *}
    nUnbest := 0;
    Zaehleconnects(pCB,nCon,lnpakete);
    {* evtl.Logbuch eintrag machen *}
    {$IFDEF CountMultiConnect}
    IF wieLog AND (1 SHL (pCB^.iface-1)) <> 0 THEN
       LogAddEntry(pCB, leWATCH, 'nCon '+ fstr(nCon));
    {$ENDIF}
    END;
  nr := 0;
  lastack := 7; {* Sozusagen... *}
  rejsent := FALSE;
  State := CONNECTED;
  tries := 0;
  {* IF how=AGAIN THEN maxFrame := 1;  {* Strafe mu sein *}
  remoteBusy := FALSE;
  who := user;	{* wg. Link Reset (z.B. status=CONNECTED & RXin = I) *}
  {  IF pCB^.watchMode <> 0 THEN
    IF (watch[pCB^.watchMode].typ AND bgBeamter     ) <> 0  THEN}

  StopTimer (t1);
  StopTimer (t2);
  StartTimer (t3);
  IF how=FIRST THEN QueueMsg( pCB, msgConnectSuccess ) {* Erfolg melden *}
               ELSE QueueMsg (pCB, msgReconnect);
  IF (infobox = MITINF) THEN OpenInfoBox (pCB, TRUE, nCon, lnpakete);

  {$IFnDEF SCC}   Sirene;   {$ENDIF}
  END;  {with}
END;


PROCEDURE GetDigiConnected ( pCB : tp_axCB );
  {* Wird in FD_CIRC aufgerufen *}
BEGIN
  {* es muesste noch ein UA gesendet werden *};
  Tx_Ctrl (pCB, UA, cMELD, NULLTIMER );
  GetConnected (pCB,FIRST,OHNEINF);
END;


PROCEDURE HandleSABM( pm : tp_mbuf; pCB : tp_axCB );
BEGIN
  pCB^.VirtAdr := 0;
  {$IFDEF VirtAdr}
  IF pm^.inuse = pm^.ofsctl+2 THEN {* verlngertes Frame *}
    {* IF erlaubt auf diesem Link/ax-Iface/von diesem Partner THEN *}
      BEGIN
      pCB^.fVirtAdr := false; {* Wird erst nach aussenden des UAs freigeschaltet *}
      pCB^.VirtAdr := by1Array(pm^.pData^)[pm^.ofsctl+2]
                 +256*by1Array(pm^.pData^)[pm^.ofsctl+1];
      END;
  {$ENDIF}
END;



PROCEDURE HandleAck( pm : tp_mbuf; pCB : tp_axCB );
  VAR b,
      byVorHerUnbest   : BYTE;
      rxR	       : 0..7;
BEGIN {* Bearbeiten einer Besttigung. *}
  byVorherUnbest := pCB^.nUnbest;
  rxR := GetR_Nr( pm );  {* Extrahiere RX-te R-Nr *}
  b := (pCB^.lastAck+1) MOD 8; {* Nr. des ersten noch unbest. Tx-Frames *}
  {* Alles in [b..rxR[ ist hiermit besttigt *}
  WHILE (b <> rxR) AND
        (pCB^.nUnbest > 0) AND
        {* Wenn die Gegenstation unsere Besttigung nicht gehrt hat, und *}
        {* nochmal pollt, men wir das ignorieren - deshalb die Abfrage  *}
        {* auf nUnbest.                                                   *}
        (pCB^.txq[b] <> NiL) DO
    BEGIN {* $OPT WITH Txq[b] DO bzw p^ *}
    IF CheckMBuf (pCB^.txq[b]) <> cAllOK THEN Exit;

    {* Statistik *}
    Inc( axIFace[pm^.ifNr].nTxInfoNetto, pCB^.txq[b]^.inUse-pCB^.txq[b]^.ofsCtl-1);

    {* Hnge die Pakete aus SendeQueue aus, die besttigt wurden und *}
    {* lsche sie falls mglich. Wurde dieser noch gar nicht gesendet, *}
    {* koennte man ihn aus der TXQ* rausnehmen oder nach dem Senden lschen *}
    _DI;
    IF pCB^.txq[b]^.txed = TRANSMITTED
      THEN BEGIN {* Discard steht bei I-Frames meistens auf FALSE (Ausnahmen: QSO wird abgebaut;s.u.;...) *}
	   IF pCB^.txq[b]^.discard
	     THEN {* txq[] nicht lschen, da noch in der pmDelQueue drinhngend *}
	     ELSE Del_mBuf (pCB^.txq[b]);
	   END
      ELSE BEGIN {* Besttigtes Frame wurde noch nicht (wieder) ausgesendet *}
           pCB^.txq[b]^.ptTimer := NiL; {* damit nicht nochmal in t1 rumgemacht wird *}
           pCB^.txq[b]^.discard := TRUE; {* Lschen tuts dann die SendeQueue *}
	   Inc (count[cntAckDiscard]);
	   END;
    _EI;
    pCB^.txq[b] := NiL; {* Referenz lschen, dieses Paket ist jetzt besttigt *}
    Dec (pCB^.nUnbest);
    pCB^.lastAck := b;  {* dto. *}
    b := (b + 1) MOD 8; {* und mit dem nchsten versuchen *}
    END; {* WHILE *}

  IF (pCB^.nUnbest = 0)
    THEN BEGIN {* Alle noch ausstehenden Frames sind vom Partner besttigt *}
	 StopTimer  (pCB^.t1);
	 StartTimer (pCB^.t3); {* wird evt. durch nachfolgenden MsgHandler (der I_Frames aussendet) wieder gestopt) *}
	 IF byVorherUnbest <> 0 THEN QueueMsg (pCB,msgNoMoreTxOutstanding); {* Sofort jubeln! *}
	 END;
END;



PROCEDURE CalcState (VAR pCB : TP_axcb; VAR pm : tp_mBuf);
  VAR FrameTyp	: T_FrameTyp;
      ok,
      bpoll,
      bfinal    : BOOLEAN;
      byDummy   : BYTE;
      kmpf      : T_kmpf;
      rxR, rxS	: 0..7;
      wZwisp	: WORD;
      pmDup	: TP_mBuf;
      piface    : ^t_axiface;
      txdms     : Longint;
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;

  {* sobald ein nicht kurzes Frame empfangen wird, virtAdr fr
   * dieses QSO ausschalten (Problem: SABM im Reconnect --> wenn verlngertes Sabm-> kein Problem
   * Wenn not pm^.virt then pCB^.fVirtAdr := false;
   *}

  frameTyp := GetFrameTyp ( pm );
  IF frameTyp = unknown THEN BEGIN {* $TODO .... *}
			     {* Tx_FRMR (pCB,pm,1,0,0,0); *}
                             Inc(Count[cntUNKNOWNFRAMERX]);
			     Exit;
			     END;
  pIFace := @axIFace[pCB^.iface];

  kmpf:= GetKMPF(pm);
  pCB^.pf := kmpf;  {* P/F Zustand setzen *}
  {* $TODO wegoptimieren: *}
  bPoll := kmpf=cPOLL;
  bFinal := kmpf=cFINAL;

  {IF final THEN}  pCB^.fIvePolled := false;

  CASE frameTyp OF
       INFO: BEGIN Inc (pCB^.wIrx);   Inc (piface^.nIrx);   END;
       RR  : BEGIN Inc (pCB^.wRRrx);  Inc (piface^.nRRrx);  END;
       RNR : BEGIN Inc (pCB^.wRNRrx); Inc (piface^.nRNRrx); END;
       REJ : BEGIN Inc (pCB^.wREJrx); Inc (piface^.nREJrx); END;
       FRMR : Inc(count[cntRxFRMR]);
    END;


  {* Statistik und Messung von FRACK *}
  IF bPoll
    THEN BEGIN
	 Inc (pCB^.wRxPolls);
         Inc (pIface^.nRxPolls);
         IF pCB^.tlastPoll >0 THEN
           BEGIN
           pCB^.messFrack := pm^.time-pCB^.tlastPoll;
	   IF pCB^.messfrack < pCB^.minFrack THEN
	     IF pCB^.messfrack > (1000 DIV _clkTick) {* Weniger als eine Sekunde kann nicht sein *}
	       THEN pCB^.minFrack := pCB^.messfrack;
	   END;
	 pCB^.tlastPoll := pm^.time;
	 END
    ELSE IF frameTyp = INFO THEN pCB^.tlastPoll := pm^.time {* Auch ein I-Frame kann man als 1. Poll interpretieren *}
           		    ELSE pCB^.tlastPoll := 0;

  IF frameTyp = DM THEN QueueMsg (pCB, msgRxDM);

  IF (pCB^.state = CONNECTED) AND
     (frameTyp IN [RR, RNR, REJ, INFO]) THEN HandleAck(pm, pCB);

  IF frameTyp = INFO THEN pCB^.Pid := GetPid(pm); {* Wir machen jeden PID-Wechsel mit - das nennt man wohl transparent.. *}

  IF fGlobMessTxd AND (pm^.pttimer <> nil) THEN WITH pCB^ DO
     BEGIN
     txdms := Round(pm2Txdelay(pm));
     Inc(txdN);
     txdSum := txdSum + txdms;
     IF txdms>txdmax THEN txdmax := txdms;
     IF (txdms<txdmin) AND (txdms>0) THEN txdmin:=txdms;
     END;


  CASE pCB^.state OF
    {---------------------------------------------------------------------}
    CONNECTED {* der hufigste Fall *}
      : BEGIN
	CASE FrameTyp OF
 	  RR
	   : BEGIN
	     pCB^.RemoteBusy := FALSE;
	     StopTimer (pCB^.t1);
	     StartTimer (pCB^.t3);
	     {byDummy := 0;}
             IF bPoll
	       THEN BEGIN {* Partner will auf jeden Fall 'ne Antwort haben *}
		    StopTimer (pCB^.t2);
                    byDummy := 0;
                    {$IFDEF DAMA_SLAVE}
                      IF pCB^.fdama THEN
                          byDummy := TryToTxIFrames (pCB,cNORMAL); {* senden, auch wiederholt *}
                    {$ENDIF}
                    {* Wenn keine I-Frames gesendet wurden, muss ein normales RR- kommen *}
		    IF byDummy = 0 THEN Tx_Ctrl (pCB, RMR, reply[kmpf], NULLTIMER);
		    END
               ELSE BEGIN {* kein poll *}
                    IF bFinal
                      THEN BEGIN
                           {* senden, denn jetzt ist der Zustand klar (unser Poll wurde beantwortet) *}
                           byDummy := TryToTxIFrames (pCB,cNORMAL);
                           END
                      ELSE BEGIN {* "Freiwillige" (nicht von uns gepollte) Besttigung des Partners *}
                           IF NOT pCB^.fdama THEN
                             BEGIN
                             HandleFlensburg (pCB, -4); {* Bestrafung rckgngig machen *}
                             IF pCB^.nUnbest=0 THEN byDummy := TryToTxIFrames (pCB,cNURNEUE);
                             END;
                           END;
                    END;
	     pCB^.RejSent := FALSE;
	     pCB^.tries := 0; {* RR ist ja 'ne Antwort *}
             IF pCB^.nUnbest> 0 THEN
               BEGIN
	       StartTimerFast (pCB^.t1);
	       StopTimer (pCB^.t3);
               END;
	     END;

	  INFO
 	   : BEGIN
	     StopTimer (pCB^.t2);
	     StopTimer (pCB^.t3);
             pCB^.frameToSendT2 := RMR;
             IF {pCB^.busy AND} (pCB^.RxBufSize>pCB^.RXwind+700)
               THEN BEGIN {* Ballert er mich (trotz RNR) voll ? 14.10.97 *}
                    EVENT_BecomeBusy(pCB); {* RUHE *}
                    {* Dann neue Frames voll ignorieren *}
                    {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
                    Inc(count[cntBigBusy]);
                    {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
                    END
               ELSE BEGIN
                    rxS := GetS_Nr(pm);
                  {$IFDEF sammler}
                    {* Falls wir den noch im Sammler hatten brauchen wir ihn nicht mehr *}
                    IF pCB^.sammler[rxS]<>nil THEN Del_mBuf(pCB^.sammler[rxS]);
                    {IF rxS <> pCB^.nr THEN}
                  {$ENDIF}
	            IF (rxS = pCB^.nr) {* ist es die erwartete Nummer? *}
	              THEN BEGIN  {* ja -> besttigen; Inhalt nach oben tun *}
		           pCB^.nr := (rxS+1) MOD 8; {* nchste erwartete Nummer setzen *}
		           {* Daten einreihen *}
		           wZwisp := EnQueue (pCB^.RxBuf, StripAndCopy_mBuf (pCB,pm));
                           IF wZwisp = 0    THEN IF CheckAXCB(pCB, cSTORE) THEN;;;;
                           IF wZwisp > 1024 THEN IF CheckAXCB(pCB, cSTORE) THEN;;;;
		           Inc (pCB^.RxBufSize, wZwisp);

		           {* Statistik *}
		           Inc( brBytes, wZwisp); {* Baudratenmessung *}
		           Inc( piface^.nRxInfoNetto, wZwisp);

		           IF (pCB^.redirectIfNr<>0) THEN
		             BEGIN {* 1:1 Wiederholung auf nem annerem Interface *}
		             pmDup := copymBuf(pm);
		             pmDup^.ifnr := pCB^.redirectIfnr;
		             pmDup^.txed := WAITING;
 		             pmDup^.discard := TRUE;
		             SendPaket(pmDup, pCB);
		             {* kein Del_mBuf - das macht Sendpacket im Hintergrund *}
		             END;

                           IF pCB^.fBeamt THEN
                             BEGIN  {* Bser Bube - wir tun so, als wenn er busy wre *}
                             pCB^.remotebusy := Random(2)=1;
                             pCB^.busy := Random(2)=1;
                             END;

	                   StopTimer (timRestart); {* Globale RestartWatchdog stoppen *}
		           IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
		           END
	              ELSE BEGIN {* Fehler in der Reihenfolge *}
                           pCB^.frameToSendT2 := REJ;
       {$IFDEF sammler}
                           {* Den merken wir uns *}
                           pCB^.sammler[rxS] := copymBuf(pm);
       {$ENDIF}
		           END;
                    END;

             IF pCB^.fDama
                 THEN BEGIN
                      IF bPoll THEN t2Out(pCB) {* Sofort antworten *}
                      END
                 ELSE StartTimerFast (pCB^.t2); {* Besttigungstimer starten *}
	   END; {*I*}

	  REJ
	   : BEGIN
             pCB^.RemoteBusy := FALSE; {* Wer ein REJ sendet, frisst auch I-Frames (mit Senf) *}
             rxR := GetR_Nr (pm);  {* Extrahiere RX-te R-Nr *}
	     IF pCB^.TxQ[rxR] <> Nil THEN
	       BEGIN {* Rejectetes Paket darf noch nicht besttigt sein *}
	       StopTimer (pCB^.t1);  {* Das war 'ne Antwort *}
 	       StartTimer (pCB^.t3); {* ...per Definition wg. T1 *}
               HandleFlensburg (pCB, +9); {* Strafe frs REJten *}
               IF pCB^.fDama THEN IF bPoll THEN TX_fromTXq ( pCB, rxR, FALSE )
                                           ELSE {schweig}
                             ELSE IF bPoll THEN Tx_Ctrl (pCB, RMR, cFINAL, NULLTIMER)
                                           ELSE TX_fromTXq ( pCB, rxR, FALSE );
               StartTimerFast (pCB^.t1); {* Lasset uns FRACKen *}
               StopTimer      (pCB^.t3); {* t1 - luft ja *}
	       pCB^.tries := 0;
               END;
	     END;

	  RNR
	   : BEGIN
	     pCB^.RemoteBusy := TRUE;
	     StopTimer (pCB^.t1);
	     StartTimer (pCB^.t3);
             IF bPoll THEN
               BEGIN {* Partner will auf jeden Fall 'ne Antwort haben *}
	       StopTimer (pCB^.t2);
	       Tx_Ctrl (pCB, RMR, reply[kmpf], NULLTIMER);
	       END;
	     pCB^.tries := 0; {* RNR ist ja 'ne Antwort *}
	     END;
	  UI
	   : IF bPoll THEN Tx_Ctrl (pCB, RMR, reply[kmpf], NULLTIMER);
	  SABM
	   : BEGIN {* Reconnected *}
             HandleSABM( pm, pCB );
	     Tx_Ctrl (pCB, UA, reply[kmpf], NULLTIMER);
	     GetConnected (pCB,AGAIN,OHNEINF);
	     END;
	  DISC
	   : BEGIN
	     Tx_Ctrl (pCB, UA, reply[kmpf], NULLTIMER);
	     pCB^.state := DISCONNECTED;
	     QueueMsg (pCB, msgDiscReq);
	     Del_AXCB (pCB);
	     END;
	  UA
	   : BEGIN
	     IF pCB^.remoteBusy OR pCB^.RejSent OR pCB^.Busy
	       THEN Event_LocalStart (pCB)
               ;
{***  ELSE GetConnected (pCB,AGAIN,OHNEINF); {* neu 20.11.92 *}
	     END;
	  DM
	   : BEGIN
	     QueueMsg (pCB, msgDiscReq);
	     Del_AXCB (pCB);
	     END;
	  FRMR
 	   : BEGIN
	     StopTimer (pCB^.t1);
	     StopTimer (pCB^.t2);
	     StopTimer (pCB^.t3);
  	     Event_LocalStart (pCB);
	     Event_LocalStop  (pCB);
	     END;

	 END; {*CASE FrameTyp * }
       END; {*CASE CONNECT*}

    {---------------------------------------------------------------------}
    DISCONNECTED :
      CASE FrameTyp OF
 	SABM : BEGIN
               HandleSABM( pm, pCB );
	       ok := (SABMmode<> smDMall) AND (SABMmode <> pCB^.iface );
	       IF NOT Ok THEN
		 BEGIN  {* So. mit diesem SpezialCall kommt man auch bei Verbot rein *}
		 ok :=( f_sh2Asc(pCB^.toCall)=SysopCall );
		 END;
	       IF NOT ok
		 THEN BEGIN {* Neueinstiege verhindern *}
		      Tx_Ctrl (pCB, DM, reply[kmpf], NULLTIMER);
		      Del_AXCB (pCB);
		      END
		 ELSE BEGIN
		      Tx_Ctrl (pCB, UA, reply[kmpf], NULLTIMER);
		      GetConnected (pCB,FIRST,MITINF);
		      END;
	       END;
	DISC : BEGIN
	       IF (kmpf AND cPFBIT)=0
		 THEN Tx_Ctrl (pCB, UA, cMELD, NULLTIMER)
		 ELSE Tx_Ctrl (pCB, DM, cFINAL, NULLTIMER);
	       Del_AXCB (pCB);
	       END;
	FRMR : BEGIN
	       Tx_Ctrl (pCB, DISC, reply[kmpf], NULLTIMER);
	       Del_AXCB (pCB);
	       END
	  ELSE BEGIN
	       IF bPoll THEN Tx_Ctrl (pCB, DM, cFINAL, NULLTIMER);
	       Del_AXCB (pCB);
	       END;
	END;

    {---------------------------------------------------------------------}
    IGNORE : {* wie der Name schon sagt - wird bei
              * via-Connectversuchen beim Auslsenden gesetzt *}
      CASE FrameTyp OF
	DM,
	DISC,  {* Der Auffordernde hat es sich anders berlegt *}
	FRMR : BEGIN
	       {* Gar nicht antworten, die einzige Antwort die erlaubt ist *}
 	       {* ist UA und die kann hier ja wohl nicht gemeint sein :-). *}

	       {* Der Block, der den Setup durchfhrt muss noch gestoppt werden:*}
	       IF pCB^.pPartnerCB <> NiL THEN
                 BEGIN
                 Event_LocalStop (pCB^.pPartnerCB);
                 {* $TODO: s.o. lst im delAxcb immer ein storestack aus *}
                 {pCB^.pPartnerCB := nil  erst nachvollziehen Beziehung lschen }
                 END;
	       Del_AXCB (pCB);
	       END;
       END {*CASE*};

    {---------------------------------------------------------------------}
    SETUP  {* An den haben wir SABM geschickt *}
      : BEGIN {* Zunchst den Frack wieder herabsetzen *}
	pCB^.t1.tickinit := Longint (piface^.t1_init);
	CASE FrameTyp OF
	  UA   : GetConnected (pCB,FIRST,OHNEINF); {* Hurra ! *}
	  DM   : BEGIN {* Grummel *}
		 StopTimer (pCB^.t1);
		 Del_AXCB (pCB);
		 END;
	  DISC : BEGIN
		 StopTimer (pCB^.t1);
		 Tx_Ctrl (pCB, DM, reply[kmpf], NULLTIMER);
		 Del_AXCB (pCB);
		 END;
	  SABM : BEGIN {* Wenn zwei dasselbe tuen *}
                 HandleSABM( pm, pCB );
		 Tx_Ctrl (pCB, UA, reply[kmpf], NULLTIMER);
		 GetConnected (pCB,FIRST,MITINF);
		 END;
	  END; {* CASE *}
	END;

    {---------------------------------------------------------------------}
    DISCPENDING
      : BEGIN
	CASE FrameTyp OF
	  UA,
	  DM  : BEGIN {* ordnungsgemaesse Auflsung *}
		QueueMSG ( pCB, msgDiscReq );
		Del_AXCB (pCB);
		END;
	  DISC: BEGIN {* Wenn zwei dasselbe wollen... *}
		QueueMSG ( pCB, msgDiscReq );
		Tx_Ctrl (pCB, UA, reply[kmpf], NULLTIMER);
		Del_AXCB (pCB);
		END;
	  ELSE IF kmpf=cPOLL THEN
		BEGIN {* nur bei POLLs antworten. Finals ignorieren *}
		QueueMSG ( pCB, msgDiscReq );
		IF pCB^.fDama
                  THEN Tx_Ctrl (pCB, DISC, reply[kmpf], NULLTIMER)
                  ELSE Tx_Ctrl (pCB, DM, reply[kmpf], NULLTIMER);
		Del_AXCB (pCB);
		END;
	  END; {* CASE *}
	END;

    {---------------------------------------------------------------------}
    FRAMEREJECT  : ;


  END; {* case state *}
 WatchDog;
 END;

{* Kein Init *}
END.

