;****************************************************************
;* Datenstrukturen fr FD_SDLC im Zusammenspiel mit FD_SDLC.ASM *
;****************************************************************
TRUE      equ     1                         ;wie in PASCAL
FALSE     equ     0                         ;wie in PASCAL

L2MFLEN   equ     328                       ;Level 2 max. Framelnge

ZUST_NOP  equ     0                         ;Zustand Kanal inaktiv
ZUST_DCD  equ     1                         ;DCD ist an
ZUST_DWAIT equ    2                         ;DWAIT luft
ZUST_FREE equ     3                         ;Frei fr Start (Dwait abgelaufen)
ZUST_TXD  equ     4                         ;TXD aktiv
ZUST_DAT  equ     5                         ;Daten werden gesendet
;;ST_TAIL EQU     6                         ; TxTail  wird  "
; Zust_Hold 6  ; Pseudo-Zustand fr FD_SCC.TXHOLD

DUP_MODE  equ     0                         ;Modus Vollduplex
SIMP_MODE equ     1                         ;Modus normales Simplex
SPEC_SIMP equ     2                         ;Simplex mit Switch

;* externe Header Definition der Control Blcke (in DigiWare: T_mBuf)
mbuf         struc
ifnr         db      ?                      ;Nummer des Interfaces 1..4
time         dd      ?                      ;aktuelle Zeit in 10ms
next         dd      ?                      ;Zeiger auf nchstes Element
discard      db      ?                      ;boolsch TRUE wenn weggeworfen
buf          dd      ?                      ;Zeiger auf Daten Segment:Offset
nMyCall      db      ?                      ;hier: Debugzaehler
bufl         dd      ?                      ;20 Bit Adresse ohne Segment
txed         db      ?                      ;Frame wurde gesendet
InUse        dw      ?                      ;Lnge der Daten
nHeard	     db      ?                      ;hier: Debugzaehler
ptTimer      dd      ?                      ;Zeiger auf Timer ??
dummy1       dw      ?
dummy2       dw      ?
mbuf         ends

;* Definitionen fr SCC-Ports
liste     struc                             ;Listenstruktur
hd        dd       ?                        ;Anfang
tl        dd       ?                        ;Ende
          ends

liste1    struc                             ;Listenstruktur wie Liste, aber nur Head :)
hd        dd       ?                        ;Anfang
          ends

sccdef    struc                             ; IFace
  prtnr     db       ?                        ;Portnummer Bereich 0..3
  baud      dd       ?                        ;eingestellte Baudrate
  duplex    db       ?                        ;0 = Duplex, 1 = Simplex ohne Switch
                                              ;2 = Simplex mit Switch
  txd       dw       ?                        ;TXD in * 10 ms
  pers      db       ?                        ;Persistence
  slot      dw       ?                        ;Slottime + DWAIT * 10 ms
  clk_reg   db       ?                        ;Register 11 Modus
  nrzi_mode db       ?                        ;0 = NRZ, 1 = NRZI
  chk_crc   db       ?                        ;CRC zum Prfen der obigen Parameter
  ;* ab hier kommen nur noch nicht festgelegte Variablen
  l1_state  db       ?                        ;Zustand L1
            ;0 = inaktiv (oder CRC falsch)
            ;1 = RX ein, DCD ein
            ;2 = RX ein, DCD aus (z.B. DWAIT)
            ;3 = TX ein, TXD aktiv
            ;4 = TX ein, Daten werden gesendet
            ;5 = TX-Tail
  fak_rx    dw       ?                        ;RX-Baudfaktor
  fak_tx    dw       ?                        ;TX-Baudfaktor
  wr5_rx    db       ?                        ;WR5 Mode RX
  wr5_tx    db       ?                        ;WR5 Mode TX
  wr10_trx  db       ?                        ;WR10 Mode TRX - Spiegel-Register
  wr15_rx   db       ?                        ;WR15 Mode RX
  wr15_tx   db       ?                        ;WR15 Mode TX
  fTail     db       ?                        ;wird speziell fr TxTail gebraucht
  rd0_scr   db       ?                        ;alter Register 0 Zustand
  rxakt     dd       ?                        ;aktuelles RX-Element
  rxadr_low dw       ?                        ;aktuelle RX-Adresse Low Word
  rxadr_hi  db       ?                        ;aktuelle RX-Adresse High Byte
  txqueue   liste    ?                        ;aktuelle TX-Liste
  chan_time dw       ?                        ;Timervariable des Kanals
  ch_free   db       ?                        ;Kanal ist belegt, wenn FALSE
  dummy_messtxd db       ?   ; Dummy fr Pascal
  dummy_valid db ?           ; Dummy fr Pascal
         ends



t_SemL1  struc                             ;Backup4reset
	    asmCntRxErr      dw ?
	    asmCntRxCrcErr       dw ?
	    semExtInt2       dw ?
	    semExtInt3       dw ?
	    nExtIntSemErr    dw ?
	    semSpecInt0       dw ?
	    semSpecInt1       dw ?
	    semSpecInt2       dw ?
	    semSpecInt3       dw ?
	    nSpecIntSemErr    dw ?
            nPTTWatchDog0  dw ?
            nPTTWatchDog1  dw ?
            nPTTWatchDog2  dw ?
            nPTTWatchDog3  dw ?
            nTxTail dw ?
            nSendInt  dw ?
            nSendInt2 dw ?
            nAbort dw ?

            nDeb1 dw ?
            nDeb2 dw ?

            fIsTailRun0 db ?
            fIsTailRun1 db ?
            fIsTailRun2 db ?
            fIsTailRun3 db ?
	  ends

	   .data

extrn constFOREVER_TRUE:byte


   ;*** Debug + Testing
	   extrn   semL1:t_SemL1

           extrn  fasttick:dword

           extrn  l2_parms
l2_parms0  equ    l2_parms+0
l2_parms1  equ    l2_parms+ 1 * size sccdef
l2_parms2  equ    l2_parms+ 2 * size sccdef
l2_parms3  equ    l2_parms+ 3 * size sccdef
l2_parmse  equ    l2_parms+ 4 * size sccdef ;zum Berechnen der Lnge

           extrn  stfl:liste                ;gelscht Liste Sender
           extrn  rxfl:liste                ;Empfangsliste
           extrn  freel:liste               ;Freiliste
           extrn  constFOREVER_TRUE:byte    ;zum Umlegen der Zeiger
           extrn  nFreeBuffer:word          ;aktueller Stand freien Buffer
           extrn  nMinFreeBuffer:word       ;minimaler Stand freier Buffer  1.6.97

           extrn  nChWeg:word              ;Fehlerzhler

            extrn dcdtimer0:Dword
            extrn dcdtimer1:Dword
            extrn dcdtimer2:Dword
            extrn dcdtimer3:Dword

            extrn tstState0:byte;
            extrn tstState1:byte;
            extrn tstState2:byte;
            extrn tstState3:byte;



