;**************************************************************
;* Assemblermodul zur Ansteurung der ISCC-Ports auf Falcon25. *
;* DIGIware-Level1                                            *
;* Untersttzt wird das Modell Turbo-Pascal.                  *
;* ISCC 1 und 2 Register-Bank 2 Context Switch                *
;**************************************************************

             .186                           ;fr 186er Prozessor
             locals                         ;lokale Labels erlauben
             warn                           ;Warnungen ein
             .model tpascal
             include  fd_sdlc.inc           ;Pufferdefinitionen Level 1/2
             include  fd_v25.inc            ;V25-Ports
             include  fd_iscc.inc           ;SCC-Ports


WITH_INT     equ      0                     ; <> 0->mit Interrupts; 0=Banking
MESSTXD      equ      0                     ;wenn <> 0 dann Messung von Txdelay

if WITH_INT eq 0
             %OUT Bank-Switching-Version
else
             %OUT Interupt-Pushing-Version
endif
if MESSTXD ne 0
   %OUT Mit Messung von Benutzer-TxDelay
else
   %OUT Ohne Messung von Benutzer-TxDelay
endif

             .data                          ;_BSS Segment uninitialisiert
if WITH_INT eq 0
bnk2_stk     dw    864 dup (?)              ;Stack fr Registerbank 2
bnk2_stkend  label word                     ;Ende des Stacks
endif

             .code
             public   scc_first             ;einmalige Init-Funktion
             jumps                          ;Sprnge optimieren


;***************
;* Kanalmacros *
;***************
;******************************************
;* Interrupt on external Condition        *
;* Aufruf: SDLC Basisadresse des SCC Ports*
;*         DMA  Basisadresse der DMA      *
;*         CONTROL Adresse des Ctr.Blk    *
;*         CHAN Kanalnummer 0-3           *
;******************************************
ext_int      macro CHAN,IFACE,SDLC,DMA,DMA_CMD
             assume ds:DATA


	     in    al,[SDLC+RD0]            ;DCD-Status holen
	     mov   bl,al                    ;und merken (bl = neuer Status)
	     mov   al,10h                   ;Reset External Status (s.5-4)
	     out   [SDLC+WR0],al            ;ausgeben
	     mov   bh,bl                    ;Status nach bh

if MESSTXD ne 0
@@messdcd:
             mov   byte ptr [IFACE.ch_free],TRUE ;Kanal ist frei
             mov   al,1
             test  bl,08h                        ;DCD an ?
             jz    short @@skipMess1             ;nein,
             ;- DCD ist an
             mov   byte ptr [IFACE.ch_free],FALSE ;Kanal ist frei

             mov   al,byte ptr [tstState&chan] ;
             cmp   al,1
             jne   short @@skipMess2

             mov   ax,word ptr [fasttick+0]     ;DCD-Angeh-Zeit merken (lo)
             mov   word ptr [dcdtimer&chan],ax  ;
             mov   ax,word ptr [fasttick+2]     ;High
             mov   word ptr [dcdtimer&chan+2],ax;
             mov   al,2
@@skipMess1:
             mov   byte ptr [tstState&chan],al
@@skipMess2:
endif

;-          Hier Test auf innerhalb TX-Underrun/EOM Interrupt
;-          Ist im Zustand ZUST_DAT die DMA nicht abgelaufen, gab es einen
;-          Underrun. (Das sollte nicht vorkommen)
	     cmp   byte ptr DATA:[IFACE.l1_state],ZUST_DAT ;End of Frame ??
	     jb    @@no_dcd                 ;irgendwas unterhalb
	     test  bl,40h                   ;Bit 6 = Tx Underrun/EOM
	     jz    @@no_dcd                 ;kein Underrun

;;;;-         cmp   byte ptr DATA:[semL1.fIsTailRun&Chan],1;  laft TxTail?
;;;;-         je    @@tailend                ;jo.  *SH*

             ;- es:si := tx_root^
	     les   si,dword ptr DATA:[IFACE.txqueue.hd] ;Zeiger Sendeblock
	     mov   ax,es                    ;Test auf      (TXROOT=NiL?)
	     or    ax,si                    ;Null Pointer
	     jnz   @@new_frame              ;weitere Frames folgen
	     ;* hier ist TxTail abgelaufen (gibt keinen extra zustand fr !)
	     ;* Auto Abort wieder ausschalten

@@tailend:   ;- Sender ausmachen etc. Sollten zwischenzeitlich neue Daten zum
             ;- Senden da sein, so werden diese durch L1Time.Dwait angestossen
	     mov   byte ptr DATA:[semL1.fIsTailRun&Chan],0
             mov   al,byte ptr DATA:[IFACE.wr5_rx] ;Modus Sender aus
	     out   [SDLC+WR5],al            ;an ISCC
	     mov   byte ptr DATA:[IFACE.fTail],0
	     mov   al,byte ptr DATA:[IFACE.wr10_trx] ;(kein Auto Abort)
	     out   [SDLC+WR10],al           ; raus damit

	     cmp   byte ptr DATA:[IFACE.duplex],SPEC_SIMP ;Spezial Simplex ??
	     jne   short @@no_ssimp         ;nein  *SH*
	     mov   ax,word ptr DATA:[IFACE.fak_rx];RX Faktor holen
	     out   [SDLC+WR12],al           ;Low Byte Baud Register
	     mov   al,ah                    ;und
	     out   [SDLC+WR13],al           ;High Byte umschalten

@@no_ssimp:  mov   al,WR3_MODE+RX_ENABLE    ;Modus Empfnger
	     out   [SDLC+WR3],al            ;ein
	     mov   al,byte ptr DATA:[IFACE.wr15_rx];Interruptenable-Kram
	     out   [SDLC+WR15],al           ;neu setzen
	     mov   byte ptr DATA:[IFACE.l1_state],ZUST_DWAIT ;ISCC erstmal abwarten
	     mov   byte ptr [IFACE.ch_free],TRUE ;Kanal ist frei

	     cmp   byte ptr DATA:[IFACE.duplex],DUP_MODE ;Vollduplex ??
; test kw 6.2.97	     je    @@no_dcd                 ;ja nichts weiter tun
	     je    short @@is_Duplex

	     mov   ax,word ptr DATA:[IFACE.rxadr_low] ;untere 16 Bit Adresse
          if (CHAN and 1) eq 0
	     out   [DMA+RDARA0],ax          ;Low Word Anfang -> DMA
          else
	     out   [DMA+RDARB0],ax          ;Low Word Anfang -> DMA
          endif
	     mov   al,byte ptr DATA:[IFACE.rxadr_hi] ;obere 4 Bit Adresse
          if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al        ;Low Word Anfang -> DMA
          else
             out   [DMA+RDARB0+2],al        ;Low Word Anfang -> DMA
          endif
             mov   ax,L2MFLEN             ;DMA Lnge
          if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax          ;ausgeben
             mov   al,0E0h                  ;Startkommando A
          else
	     out   [DMA+RDCRB0],ax          ;ausgeben
             mov   al,0A0h                  ;Startkommando B
          endif
             out   [DMA+CCAR],al            ;ausgeben
             cmp   byte ptr DATA:[IFACE.duplex],DUP_MODE ;Duplex ?
             je    short @@is_duplex        ;ja   *SH*
             mov   byte ptr [IFACE.ch_free],FALSE ;Kanal ist belegt
             mov   byte ptr DATA:[IFACE.l1_state],ZUST_DCD ;falls DCD an
             test  bl,08h                   ;DCD an ??
             jnz   @@no_dcd                 ;ja

             mov   byte ptr DATA:[IFACE.l1_state],ZUST_DWAIT ;DWAIT Zustand
             mov   byte ptr [IFACE.ch_free],TRUE ;Kanal ist frei
             mov   ax,word ptr DATA:[IFACE.slot] ;Wartekonstante (DWAIT)
             mov   word ptr DATA:[IFACE.chan_time],ax ;setzen
             jmp   @@no_dcd                 ;bei DCD weitermachen

@@is_duplex: mov   byte ptr DATA:[IFACE.l1_state],ZUST_FREE ;Kanal ist frei
	     mov   byte ptr [IFACE.ch_free],TRUE ;Kanal ist frei
             jmp   @@no_dcd                 ;ohneDCD Check weiter

@@new_frame: mov   byte ptr es:[si.txed],1  ;Frame wurde gesendet

             mov   bl, byte ptr DATA:[IFACE.duplex] ;   kw 4.2.97

             Inc   word ptr DATA:[semL1.nDeb1]

             ;- if es:si^.ptTimer <> NiL THEN es:si^.pbenabled := @iface[].chfree
             mov   dx,ds                    ;DS retten
             assume ds:nothing              ;DS ist ungltig
             lds   di,dword ptr es:[si.ptTimer] ;Zeiger holen
             mov   ax,ds                    ;Test auf
             or    ax,di                    ;nil
             jz    short @@pb_no            ;egal *SH*

             cmp   bl,DUP_MODE              ;Vollduplex ??   kw 4.2.97
             je    short @@dupforevertrue   ;ja, anderes Zeigerziel kw 4.2.97

             _cli
	     mov   word ptr ds:[di  ],offset IFACE.ch_free ;Offset auf Variable
	     mov   word ptr ds:[di+2],dx    ;Datensegment ist Ziel
             _sti
             jmp   short @@pb_no            ;und weiter   kw 4.2.97

@@dupforevertrue:
             _cli
 	     mov   word ptr ds:[di  ],offset constFOREVER_TRUE ;  kw 4.2.97
 	     mov   word ptr ds:[di+2],dx;;;seg    constFOREVER_TRUE ;  kw 4.2.97
             _sti

             mov   ds,dx                         ;ds zurck
             assume ds:data                      ;ds wieder gltig (Pascal)
             Inc   word ptr DATA:[semL1.nDeb2]

@@pb_no:     mov   ds,dx                         ;ds zurck
             assume ds:data                      ;ds wieder gltig (Pascal)
             ;- txq.hd := si.Next        {In SI. steht der gerade gesendete block drin}
             _cli                                ;auch hier!, da Transfer in zwei Teilen
             mov   ax,word ptr es:[si.next]      ;Offset nchstes Frame
	     mov   word ptr DATA:[IFACE.txqueue.hd],ax ;setzen
             mov   ax,word ptr es:[si.next+2]    ;Segment nchstes Frame
             mov   word ptr DATA:[IFACE.txqueue.hd+2],ax ;setzen
             _sti
	     ;- si.next := NiL;
             mov   word ptr es:[si.next],0       ;Next auf NiL
             mov   word ptr es:[si.next+2],0     ;setzen
             ;- Element ist ausgehngt
             ;- if pmbuf_txed^.discard <> 1 THEN
             test  byte ptr es:[si.discard],1    ;darf das Paket weg ??
             _cli;
             jz short @@txfirst                  ;nein, wird noch gebraucht *SH*
             ;- if lstdel.root = NIL THEN
             mov   ax,word ptr DATA:[stfl.hd+0]  ;Offset Listenbeginn
             or    ax,word ptr DATA:[stfl.hd+2]  ;Segment Nulltest
             jnz   short @@not_txfirst           ;es ist noch was drin *SH*
             ;- lstDel.root := pmbuf_txed;
             mov   word ptr DATA:[stfl.hd+0],si  ;Offset Listenbeginn
             mov   word ptr DATA:[stfl.hd+2],es  ;Segment Listenbeginn
             ;- lstDel.tail := pmbuf_txed;
	     mov   word ptr DATA:[stfl.tl+0],si  ;Offset Listenende
             mov   word ptr DATA:[stfl.tl+2],es  ;Segment Listenende
             jmp   short @@txfirst               ;weitermachen *SH*
@@not_txfirst:
             ; es:si.mbuf am ende der Lschliste anhngen
             ; lstdel.tail^.next := pmtxed
             mov   dx,ds                      ;Segment merken
             lds   di,DATA:[stfl.tl]          ;Zeiger auf letztes Element
             assume ds:nothing
             mov   word ptr ds:[di.next],si   ;Offset in altes Element
             mov   word ptr ds:[di.next+2],es ;Segment in altes Element
             mov   ds,dx                      ;DATA zurck
             assume ds:DATA
             ; lstdel.tail := pmtxed
             mov   word ptr DATA:[stfl.tl+0],si;Offset neues Ende
             mov   word ptr DATA:[stfl.tl+2],es;Segment neues Ende

@@txfirst:   ;Das alte(bereits TXte) Element ist ausgehngt, das neue steht in txqueue
             _sti
	     les   si,dword ptr [IFACE.txqueue.hd] ;neuen Zeiger holen
             mov   ax,es                    ;Segment fr
             or    ax,si                    ;Nulltest
	     jnz   short @@new_frame1       ;ist taschlich noch eins zum Senden da *SH*
                                            ;so hier is nun schluss mit Senden
             Inc   word ptr DATA:[semL1.nTxTail]
             mov   byte ptr DATA:[IFACE.fTail],1; Autoabort muss noch gesetzt werden
	     mov   byte ptr DATA:[semL1.fIsTailRun&Chan],1 ;tail luft
             mov   ax,2                     ;Txtail Bytes
             LOCK
         if (CHAN and 1) eq 0
             out   [DMA+TDCRA0],ax          ;Kanal A
         else
             out   [DMA+TDCRB0],ax          ;Kanal B
         endif
             mov   al,0C0h                  ;Reset
             out   [SDLC+WR0],al            ;EOM Latch
             mov   al,19h + 02h             ;Sendeinterrupt
             out   [SDLC+WR1],al            ;freigeben
@@wart1:     in    al,[SDLC+RD0]            ;nochmal gucken
             test  al,04h                   ;Sende-Bit bereit
;;;;;        jz @@wart1
             jz    short @@no_dcd           ;und weiter *SH*
             mov   al,byte ptr DATA:[IFACE.wr10_trx]  ;Spiegelregister laden
	     or    al,04h                   ;Auto-Abort (on Underrun)
             out   [SDLC+WR10],al           ;raus damit
             mov   byte ptr DATA:[IFACE.fTail],0 ; AutoAbort ist gesetzt worden
             mov   al,19h
             out   [SDLC+WR1],al
             mov   al,DMA_CMD               ;Startkommando
             _cli                           ;ohne Interrupts
             out   [DMA+CCAR],al            ;ausgeben
             mov   al,0C0h                  ;Reset EOF-Flag
             out   [SDLC+WR0],al            ;an SCC
             _sti                           ;Interrupt wieder freigeben
             jmp   short @@no_dcd           ;und weiter *SH*

@@new_frame1:
             mov   al,byte ptr DATA:[IFACE.wr10_trx] ;Spiegelregister laden
             out   [SDLC+WR10],al                    ;raus damit (kein Auto Abort)
	     mov   byte ptr DATA:[IFACE.fTail],0
             mov   ax,word ptr es:[si.bufl+0]    ;untere 16 Bit
          if (CHAN and 1) eq 0
	     out   [DMA+TDARA0],ax               ;Low Word der Adresse ausgeben
             mov   al,byte ptr es:[si.bufl+2]    ;obere 8 Bit
             out   [DMA+TDARA0+2],al             ;High Byte der Adresse ausgeben
          else
             out   [DMA+TDARB0],ax               ;Low Word der Adresse ausgeben
             mov   al,byte ptr es:[si.bufl+2]    ;obere 8 Bit
             out   [DMA+TDARB0+2],al             ;High Byte der Adresse ausgeben
          endif
             mov   ax,word ptr es:[si.inUse] ;Anzahl holen
          if (CHAN and 1) eq 0
             out   [DMA+TDCRA0],ax          ;Anzahl ausgeben
          else
             out   [DMA+TDCRB0],ax          ;Anzahl ausgeben
          endif
	     mov   al,0C0h                  ;Reset
             out   [SDLC+WR0],al            ;EOM Latch
             mov   al,19h + 02h             ;Sendeinterrupt
	     out   [SDLC+WR1],al            ;freigeben
@@warte2:    in    al,[SDLC+RD0]            ;nochmal gucken
             test  al,04h                   ;Sende-Bit bereit
;;;;;;;;;;;  jz @@warte2
             jz    short @@no_dcd           ;und weiter, da Sendebit nicht bereit *SH*
             mov   al,19h                   ; sendint brauch mn doch nicht external Interupt Enable; rx on Special Cond. only
             out   [SDLC+WR1],al
             mov   al,DMA_CMD               ;Startkommando
	     _cli                           ;ohne Interrupts
             out   [DMA+CCAR],al            ;ausgeben
             mov   al,0C0h                  ;Reset EOF-Flag
             out   [SDLC+WR0],al            ;an SCC
             _sti                           ;Interrupt wieder freigeben

@@no_dcd:    test  bh,80h                   ;Abort ??
             jz    short @@ext_end          ;nein *SH*

	     Inc  word ptr DATA:[semL1.nAbort]
             xor   ax,ax                    ;Empfangs-DMA
if (CHAN and 1) eq 0
             out   [DMA+RDCRA0],ax          ;abbrechen
else
	     out   [DMA+RDCRB0],ax          ;abbrechen
endif
             in    al,[DMA+DSR]             ;Status DMA leeren
             cmp   byte ptr DATA:[IFACE.l1_state],ZUST_TXD ;Senden wir ??
             jb    short @@no_send          ;nein *SH*
             cmp   byte ptr DATA:[IFACE.duplex],DUP_MODE ;Vollduplex ??
             je    short @@no_send          ;ja normal weiter *SH*
             jmp   short @@ext_ex           ;sofort Ende   *SH*
@@no_send:   mov   ax,word ptr DATA:[IFACE.rxadr_low] ;untere 16 Bit Adresse
if (CHAN and 1) eq 0
             out   [DMA+RDARA0],ax          ;Low Word Anfang -> DMA
else
             out   [DMA+RDARB0],ax          ;Low Word Anfang -> DMA
endif
             mov   al,byte ptr DATA:[IFACE.rxadr_hi] ;obere 4 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al        ;Low Word Anfang -> DMA
else
             out   [DMA+RDARB0+2],al        ;Low Word Anfang -> DMA
endif
             mov   ax,L2MFLEN             ;DMA Lnge
if (CHAN and 1) eq 0
             out   [DMA+RDCRA0],ax          ;ausgeben
             mov   al,0E0h                  ;Startkommando A
else
             out   [DMA+RDCRB0],ax          ;ausgeben
             mov   al,0A0h                  ;Startkommando B
endif
	     out   [DMA+CCAR],al            ;ausgeben
@@ext_end:
@@ext_ex:    ;Ende des Status Interrupts

if CHAN LT 2
	     jmp   scc1_lp                  ;SCC 1
else
	     jmp   scc2_lp                  ;SCC 2
endif
             nop
             nop
             nop
	     endm

;*************************************************
;* Interrupt on Special Receive Condition        *
;* Aufruf: SDLC Basisadresse des SCC Ports       *
;*         DMA  Basisadresse der DMA             *
;*         IFACE Adresse des Ctr.Blk           *
;*         CHAN Kanalnummer 0-3                  *
;*************************************************
spec_int     macro CHAN,IFACE,SDLC,DMA
             assume ds:DATA

	     cmp   byte ptr [IFACE.duplex],DUP_MODE   ;Vollduplex ??
             je    short @@spec_err0        ;ja nicht weiter abfragen *SH*
             cmp   byte ptr [IFACE.l1_state],ZUST_TXD ;Senden wir ??
             jb    short  @@spec_err0       ;nein; kein Problem *SH*
					    ;Sender ist an!
             mov   al,30h                   ;Error Reset
             out   [SDLC+WR0],al            ;an ISCC
	     jmp   @@spec_ex                ;sofortiges Ende
@@spec_err0: in    al,[SDLC+RD1]            ;Fehlerstatus holen

             and   al,80h+40h+20h+0Eh       ;Test auf EOF, Overrun, CRC, Lnge
             cmp   al,80h+06h               ;End of Frame, kein Fehler, Lnge mod 8
             jne   @@spec_err1              ;Fehler aufgetreten, da ungleich

          if (CHAN and 1) eq 0                        ; EoF
             in    ax,[DMA+RDCRA0]          ;Lnge A holen
             mov   dx,ax                    ;merken
             xor   ax,ax                    ;lschen
             out   [DMA+RDCRA0],ax          ;und Ende DMA
          else
	     in    ax,[DMA+RDCRB0]          ;Lnge B holen
             mov   dx,ax                    ;merken
             xor   ax,ax                    ;lschen
             out   [DMA+RDCRB0],ax          ;und Ende DMA
          endif
             mov   al,30h                   ;Error Reset
             out   [SDLC+WR0],al            ;an ISCC
             mov   ax,L2MFLEN - 2       ;Grsse Puffer -2 wegen CRC
             sub   ax,dx                    ;ax = Lnge des Frames
             les   bx,dword ptr [IFACE.rxakt] ;aktuelle Adresse holen
             mov   word ptr es:[bx.inUse],ax ;Lnge setzen
             mov   byte ptr es:[bx.ifnr],CHAN+1 ;Portnummer ebenfalls
             _cli
             mov   ax,word ptr [fasttick+0] ;Low word Zeit
             mov   word ptr es:[bx.time+0],ax;setzen
             mov   ax,word ptr [fasttick+2] ;High word Zeit
             mov   word ptr es:[bx.time+2],ax;ebenfalls

if MESSTXD ne 0
             mov   word ptr es:[bx.pttimer],0
             mov   word ptr es:[bx.pttimer+2],0
             mov   al,byte ptr [tstState&chan]
             cmp   al,2
             jne   short @@skipmesspak

             mov   ax,word ptr [dcdtimer&chan]
             mov   word ptr es:[bx.pttimer],ax
             mov   ax,word ptr [dcdtimer&chan +2]
             mov   word ptr es:[bx.pttimer+2],ax

             mov   byte ptr [tstState&chan],1
@@skipmesspak:
endif
             mov   word ptr es:[bx.next+0],0  ;Null Pointer
             mov   word ptr es:[bx.next+2],0;als nchstes Element
             ;unbedingt ohne Interrupts: (sind noch aus)
	     mov   dx,es                    ;Segment in dx merken
             les   si,dword ptr DATA:[freel.hd];Anfang Freiliste holen
             mov   ax,es                    ;Auf NIL
             or    ax,si                    ;testen
             jz    @@spec_err2i             ;Liste ist leider leer *SH*

             mov   ax,word ptr DATA:[nFreeBuffer]  ; Statistik fhren
             dec   ax
             mov   word ptr DATA:[nFreeBuffer],ax  ;
             cmp   ax, word ptr DATA:[nMinFreeBuffer]
             jge   short @@keinRekord
             mov   word ptr DATA:[nMinFreeBuffer],ax  ; Neuer NegativRekord

@@keinRekord:
             mov   ax,word ptr es:[si.next+0]    ;Offset Folgeelemnet
             mov   word ptr DATA:[freel.hd+0],ax ;setzen
             mov   ax,word ptr es:[si.next+2]    ;Segment Folgeelemnet
             mov   word ptr DATA:[freel.hd+2],ax ;setzen
            ;neues Element ist ausgehngt
             mov   word ptr DATA:[IFACE.rxakt+0],si ; neuer Offset
             mov   word ptr DATA:[IFACE.rxakt+2],es ; neues Segment
            ;Element in rxakt gemerkt
            ;Longadresse berechnen
             mov   al,byte ptr es:[si.bufl+2];obere 4 Bit
	     mov   byte ptr DATA:[IFACE.rxadr_hi],al
if (CHAN and 1) eq 0
             out   [DMA+RDARA0+2],al        ;Low Word Anfang -> DMA
else
             out   [DMA+RDARB0+2],al        ;Low Word Anfang -> DMA
endif
             mov   ax,word ptr es:[si.bufl+0];untere 16 Bit
             mov   word ptr DATA:[IFACE.rxadr_low],ax
if (CHAN and 1) eq 0
             out   [DMA+RDARA0],ax          ;Low Word Anfang -> DMA
else
             out   [DMA+RDARB0],ax          ;Low Word Anfang -> DMA
endif
             in    al,[DMA+DSR]             ;Status DMA leeren
             mov   ax,L2MFLEN             ;DMA Lnge
if (CHAN and 1) eq 0
             out   [DMA+RDCRA0],ax          ;ausgeben
             mov   al,0E0h                  ;Startkommando A
else
             out   [DMA+RDCRB0],ax          ;ausgeben
	     mov   al,0A0h                  ;Startkommando B
endif
             out   [DMA+CCAR],al            ;ausgeben
            ;- Das empfangene Frame steht noch in dx:bx (Next ist schon = NIL)
            ;- Jetzt einhngen, HDLC ist ja wieder in Betrieb
             les   si,dword ptr DATA:[rxfl.hd];Anfang Liste lesen
             mov   ax,es                    ;Test auf
             or    ax,si                    ;NIL
             jnz   short  @@rx_noempty       ;Liste nicht leer *SH*
             mov   word ptr DATA:[rxfl.hd+0],bx ;Offset setzen
             mov   word ptr DATA:[rxfl.hd+2],dx ;Segment auch
             jmp   short @@rx_empty             ;ist leer   *SH*
@@rx_noempty:les   si,dword ptr DATA:[rxfl.tl]  ;Ende Liste lesen
             mov   word ptr es:[si.next+0],bx   ;Fortsetzung Offset
             mov   word ptr es:[si.next+2],dx   ;Fortsetzung Segment
@@rx_empty:  mov   word ptr DATA:[rxfl.tl+0],bx ; Tail Zeiger setzen
             mov   word ptr DATA:[rxfl.tl+2],dx ;   "    "      "
             _sti                           ;jetzt knnen wieder Ints

             jmp   short @@spec_ex          ;Ende  *SH*

             ;** Fehler ist aufgetreten; in AL ist der Inhalt von RD1 (teilmaskiert)
@@spec_err1:
             if MESSTXD ne 0
               mov   byte ptr [tstState&chan],1  ;DCD Zeitmarke ist ungltig
             endif

             test  al,80h                   ;Empfangsfehler ?? (END OF FRAME RXed)
             jnz   short @@test8495        ;ja *SH*
             mov   al,30h                   ;Error Reset, da anderer Fehler
             out   [SDLC+WR0],al            ;an ISCC
             jmp   short @@spec_ex          ;und Ende *SH*

; test 8495
@@test8495:
             inc   word ptr [semL1.asmCntRxErr]
             test  al,40h   ; crc-Error ?
             jz    short @@err_noCrc
             inc   word ptr [semL1.asmCntRxCrcErr]
; end test 8495
@@err_noCrc:
             jmp   short @@spec_err2        ;ja *SH*


@@spec_err2i:_sti                           ;weitere Interrupts zulassen
@@spec_err2:                                ;
             xor   ax,ax                    ;lschen
if (CHAN and 1) eq 0
             out   [DMA+RDCRA0],ax          ;und Ende DMA
else
             out   [DMA+RDCRB0],ax          ;und Ende DMA
endif
             mov   al,30h                   ;Error Reset nun auch hier.
             out   [SDLC+WR0],al            ;an ISCC
             cmp   byte ptr [IFACE.l1_state],ZUST_TXD ;sind wir am Senden ??
             jb    short @@spec_err3        ;nein, kein Problem   *SH*
             cmp   byte ptr [IFACE.duplex],DUP_MODE ;Vollduplex ?
             jne   short @@spec_ex          ;kein DMA Init   *SH*
	     inc   Word Ptr DATA:[nChWeg]   ; Fehlerzhler
             in    al,[SDLC+RD8]            ;gepufferte Zeichen weg
             in    al,[DMA+DSR]             ;Status DMA leeren
@@spec_err3: ;*** DMA wieder scharf machen
             mov   ax,word ptr DATA:[IFACE.rxadr_low] ;untere 16 Bit Adresse
if (CHAN and 1) eq 0
             out   [DMA+RDARA0],ax          ;Low Word Anfang -> DMA
             mov   al,byte ptr DATA:[IFACE.rxadr_hi] ;obere 4 Bit Adresse
             out   [DMA+RDARA0+2],al        ;Low Word Anfang -> DMA
             mov   ax,L2MFLEN             ;DMA Lnge
             out   [DMA+RDCRA0],ax          ;ausgeben
             mov   al,0E0h                  ;Startkommando A
else
             out   [DMA+RDARB0],ax          ;Low Word Anfang -> DMA
             mov   al,byte ptr DATA:[IFACE.rxadr_hi] ;obere 4 Bit Adresse
             out   [DMA+RDARB0+2],al        ;Low Word Anfang -> DMA
             mov   ax,L2MFLEN             ;DMA Lnge
             out   [DMA+RDCRB0],ax          ;ausgeben
             mov   al,0A0h                  ;Startkommando B
endif
             out   [DMA+CCAR],al            ;ausgeben

@@spec_ex:   ;Ende des Special Interrupts

if CHAN LT 2
             jmp   scc1_lp                  ;SCC 1
else
             jmp   scc2_lp                  ;SCC 2
endif
             endm

;*************************************************
;* Sende-Interrupt (nur fr End-of-Frame)        *
;* Aufruf: SDLC Basisadresse des SCC Ports       *
;*         DMA  Basisadresse der DMA             *
;*         DMA_CMD DMA-Starkommando              *
;*         CHAN Kanalnummer                      *
;*************************************************
tx_int       macro    CHAN,IFACE,SDLC,DMA,DMA_CMD
	     mov      al,19h                ;Sendeinterrupt
             out      [SDLC+WR1],al         ;wieder aus

             Inc   word ptr DATA:[SemL1.nSendInt]
             cmp   byte ptr DATA:[IFACE.fTail],1
             jnz   short @@skipautoabort ;*SH*
             Inc   word ptr DATA:[SemL1.nSendInt2]
             mov   al,byte ptr DATA:[IFACE.wr10_trx]  ;Spiegelregister laden
             or    al,04h                   ;Auto-Abort (on Underrun)
             out   [SDLC+WR10],al           ;raus damit
             mov   byte ptr DATA:[IFACE.fTail],0
@@skipautoabort:
             mov      al,DMA_CMD            ;Startkommando
             _cli                           ;ohne Interrupts
             out      [DMA+CCAR],al         ;ausgeben
             mov      al,0C0h               ;Reset EOF-Flag
             out      [SDLC+WR0],al         ;an SCC
             _sti                           ;Interrupt wieder freigeben

  if CHAN LT 2
             jmp      scc1_lp       ;SCC 1
  else
             jmp      scc2_lp       ;SCC 2
  endif
             endm

;*------------------------------------------------------------------------

ext_int0:    ext_int  0,l2_parms0,SDLC1,DMA1,0C0h
ext_int1:    ext_int  1,l2_parms1,SDLC2,DMA1,080h
ext_int2:    ext_int  2,l2_parms2,SDLC3,DMA2,0C0h
ext_int3:    ext_int  3,l2_parms3,SDLC4,DMA2,080h

rx_int0      label near
spec_int0:   spec_int  0,l2_parms0,SDLC1,DMA1
rx_int1      label near
spec_int1:   spec_int  1,l2_parms1,SDLC2,DMA1
rx_int2      label near
spec_int2:   spec_int  2,l2_parms2,SDLC3,DMA2
rx_int3      label near
spec_int3:   spec_int  3,l2_parms3,SDLC4,DMA2

tx_int0:     tx_int    0,l2_parms0,SDLC1,DMA1,0C0h
tx_int1:     tx_int    1,l2_parms1,SDLC2,DMA1,080h
tx_int2:     tx_int    2,l2_parms2,SDLC3,DMA2,0C0h
tx_int3:     tx_int    3,l2_parms3,SDLC4,DMA2,080h

;            retrbi   ; was soll das hier ?

;************************************************************************
;* Interrupteintrittsfunktionen der V25 Version, die nicht vektorisiert *
;* arbeitet.                                                            *
;************************************************************************
if 0
scc1_tab     label word
             dw    offset tx_int1           ;Sendeinterrupt Kanal 2
             dw    offset ext_int1          ;External Condition Kanal 2
             dw    offset rx_int1           ;Empfangsinterrupt Kanal 2
             dw    offset spec_int1         ;Special Receive Kanal 2
             dw    offset tx_int0           ;Sendeinterrupt Kanal 1
             dw    offset ext_int0          ;External Condition Kanal 1
             dw    offset rx_int0           ;Empfangsinterrupt Kanal 1
             dw    offset spec_int0         ;Special Receive Kanal 1
scc2_tab     label word
             dw    offset tx_int3           ;Sendeinterrupt Kanal 4
             dw    offset ext_int3          ;External Condition Kanal 4
             dw    offset rx_int3           ;Empfangsinterrupt Kanal 4
             dw    offset spec_int3         ;Special Receive Kanal 4
             dw    offset tx_int2           ;Sendeinterrupt Kanal 3
             dw    offset ext_int2          ;External Condition Kanal 3
             dw    offset rx_int2           ;Empfangsinterrupt Kanal 3
             dw    offset spec_int2         ;Special Receive Kanal 3
endif

;******************************************
;* Interrupt der beiden SCCs und des SCSI *
;******************************************
             include fd_tab.inc   ; Definitionen der Int-Prios

if WITH_INT eq 0
             ;*  portdis am Ende nicht noetig, wg. Banking
bnk2_int     proc   FAR
             assume ds:DATA                 ;durch Context Switch
;             Inc    word ptr [backup.semMain]   ; debug only
             portena                        ;IO erlauben
             mov    al,byte ptr es:[IRQS]   ;Interruptquelle holen (s.S.4-47) (welcher v25 int-pin war's?)
             sti                            ;weitere IRQs zulassen
             push   es                      ;retten
             cmp    al,18h                  ;SCC 1 ?
             jne    short @@not_scc1        ;nein   *SH*
scc1_lp:
             in     al,SDLC1+RD3            ;Status lesen (hier landet man auch nach dem Jump)
             mov    bl,al
             xor    bh,bh
             shl    bx,1
             jmp    word ptr cs:[bx+scc1neutab]

scc1_lp1_ende:
             pop    es                      ;wieder zurck
             cli                            ;besser wieder verbieten
             fint                           ;Interruptende anzeigen
;-             Dec    word ptr [backup.semMain]
             retrbi                         ;Register Bank Return

@@not_scc1:  cmp    al,19h                  ;SCC 2 ?
             jne    short @@not_scc2        ;nein   *SH*

scc2_lp:
             in     al,SDLC3+RD3            ;Status lesen (hier landet man auch nach dem Jump)
             mov    bl,al
             xor    bh,bh
             shl    bx,1
             jmp    word ptr cs:[bx+scc2neutab]
scc2_lp1_ende:
             pop    es                      ;wieder zurck
             cli                            ;besser wieder verbieten
             fint                           ;Interruptende anzeigen
             retrbi                         ;Register Bank Return

@@not_scc2:  cmp    al,1Ah                  ;SCSI ?
             jne    short @@not_scsi        ;nein
             pop    es                      ;wieder zurck
             cli                            ;besser wieder verbieten
             fint                           ;Interruptende anzeigen
;-             Dec    word ptr [backup.semMain]
             retrbi                         ;Register Bank Return

@@not_scsi:  portdis
             pop    es                      ;wieder zurck
             cli                            ;besser wieder verbieten
             fint                           ;Interruptende anzeigen
;-             Dec    word ptr [backup.semMain]
             retrbi                         ;Register Bank Return
             assume ds:nothing,es:nothing
bnk2_int     endp

else
             ;* Interupt Version *
intp0_int    proc   near
             sti
             pusha                          ;alle Register retten
             push   ds                      ;Datensegment
             push   es                      ;und Extrasegment
             portena                        ;IO-erlauben - braucht wohl lnger: IN sofort danach kracht!
             mov    ax,DATA                 ;Datensegment
             mov    ds,ax                   ;setzen
             assume ds:DATA
@@scc1_lp1:  in     al,SDLC2+RD2            ;Read modified Int Vektor
             and    al,0Eh                  ;16 Adressen
             xor    ah,ah                   ;High Byte auf 0
             mov    bx,ax                   ;in passendes Register
             jmp    word ptr cs:scc1_tab[bx];Ansprung
scc1_lp:     in     al,SDLC1+RD3            ;Status lesen
             or     al,al                   ;Ende ?
             jnz    @@scc1_lp1              ;nein
             pop    es                      ;Extrasegment zurck
             pop    ds                      ;Datensegment
             popa                           ;und Rest
             cli                            ;keine Interrupts mehr
             fint                           ;Interrupt Ende
             iret                           ;und Ende
             assume ds:nothing,es:nothing
intp0_int    endp

intp1_int    proc   near
             sti
             pusha                          ;alle Register retten
             push  ds                       ;Datensegment
             push  es                       ;und Extrasegment
             portena                        ;IO-erlauben; s.o.
             mov   ax,DATA                ;Datensegment
             mov   ds,ax                    ;setzen
             assume ds:DATA
@@scc2_lp1:  in     al,SDLC4+RD2           ;Read modified Int Vektor
             and    al,0Eh                  ;16 Adressen
             xor    ah,ah                   ;High Byte auf 0
             mov    bx,ax                   ;in passendes Register
             jmp    word ptr cs:scc2_tab[bx];Ansprung
scc2_lp:     in     al,SDLC3+RD3           ;Status lesen
             or     al,al                   ;Ende ?
             jnz    @@scc2_lp1              ;nein
             pop   es                       ;Extrasegment zurck
             pop   ds                       ;Datensegment
             popa                           ;und Rest
             cli                            ;keine Interrupts mehr
             fint                           ;Interrupt Ende
             iret                           ;und Ende
             assume ds:nothing,es:nothing
intp1_int    endp

endif

;*******************************************
;* Initialisierungstabelle einmaliges Init *
;*******************************************
first_tab1   label  word
             dw     SDLC1+WR9               ;Register 9 SCC1
             db     0C1h                    ;Master Reset SCC, modify Vektor
             dw     SDLC1+WR2               ;Vektor Register
             db     0                       ;Tabellenwert
             dw     SDLC1+WR9               ;Register 9 SCC1
             db     09h                     ;MIE und VIS ein
             dw     DMA1+CCAR               ;Kommandoregister DMA
             db     060h                    ;Reset DMA
             dw     DMA1+DCR                ;DMA Control Register
             db     8Fh                     ;normale Prioritt, Increment
             dw     DMA1+ICR                ;Interrupt Control Register
             db     10h                     ;Interrupts aus, Status ein
             dw     SDLC3+WR9               ;Register 9 SCC1
             db     0C1h                    ;Master Reset SCC, modify Vektor
             dw     SDLC3+WR2               ;Vektor Register
             db     0                       ;Tabellenwert
             dw     SDLC3+WR9               ;Register 9 SCC2
             db     09h                     ;MIE und VIS ein
             dw     DMA2+CCAR               ;Kommandoregister DMA
             db     060h                    ;Reset DMA
             dw     DMA2+DCR                ;DMA Control Register
             db     8Fh                     ;normale Prioritt, Increment
             dw     DMA2+ICR                ;Interrupt Control Register
             db     10h                     ;Interrupts aus, Status ein
             dw     0FFFFh                  ;Ende der Tabelle

scc_first    proc far
             arg    struclen:word           ;Lnge der L1-Struktur
             assume ds:DATA                 ;Ist bei TP halt so.
             push   si
             push   di
             mov    bx,offset DATA:l2_parmse;Ende der L1-Struktur
             sub    bx,offset DATA:l2_parms ; - Anfang
             mov    ax,FALSE                ;falls Fehler
             cmp    bx,[struclen]           ;gleich ?
             jne    @@first_err             ;nein Fehler
             mov    cx,4                    ;Anzahl Ports
             mov    si,offset DATA:l2_parms0;Anfang der Struktur
             xor    ax,ax                   ;ax = 0
@@first_lp:
             mov    word ptr DATA:[si.rxakt],ax
             mov    word ptr DATA:[si.rxakt+2],ax
             mov    word ptr DATA:[si.txqueue.hd],ax
             mov    word ptr DATA:[si.txqueue.hd+2],ax
;- Init der Lschliste ist;;;;;;; mov    word ptr DATA:[stfl.hd],ax
;- Sache von Digware-Pascalteil;; mov    word ptr DATA:[stfl.hd+2],ax
             mov    word ptr DATA:[si.chan_time],ax
             mov    byte ptr DATA:[si.l1_state],ZUST_NOP
             mov    byte ptr DATA:[si.wr5_rx],al
             mov    byte ptr DATA:[si.wr5_tx],al
             mov    byte ptr DATA:[si.ch_free],FALSE ;Kanal ist "belegt"
             add    si,size sccdef          ;einen Eintrag weiter
             loop   @@first_lp              ;ber alle Ports

	     mov    byte ptr DATA:[semL1.fIsTailRun0],0
	     mov    byte ptr DATA:[semL1.fIsTailRun1],0
	     mov    byte ptr DATA:[semL1.fIsTailRun2],0
	     mov    byte ptr DATA:[semL1.fIsTailRun3],0

             portena                        ;IO-Ports freigeben
             mov   si,offset first_tab1     ;Zeiger auf Port Init Tabelle
@@first1:    mov   dx,word ptr cs:[si]      ;Portadresse holen
             cmp   dx,0FFFFh                ;Ende ?
             je    short @@first2           ;ja
             mov   al,byte ptr cs:[si+2]    ;Ausgabewert
             out   dx,al                    ;an Port
             add   si,3                     ;Zeiger auf nchsten Eintrag
             jmp   short @@first1           ;und weiter

@@first2:    mov   ax,V25_SEG               ;Segment V25 IO
             mov   es,ax                    ;setzen
             assume es:V25_SEG
             or    byte ptr es:[PRC],40h    ;internes RAM ein
if WITH_INT eq 0
             ; Bankigregister vorbelegen
             pushf                          ;temporr sperren
             cli                            ;jetzt nicht
             mov   word ptr es:[bnk2.cs_reg],cs      ;Codesegment setzen
             mov   word ptr es:[bnk2.pc_vektpr],offset bnk2_int ;Offset dazu
             mov   word ptr es:[bnk2.ds_reg],DATA    ;Zeiger auf Datensegment
             mov   word ptr es:[bnk2.es_reg],V25_SEG ;V25-IO-Segment
             mov   word ptr es:[bnk2.ss_reg],DATA    ;Stack ist im Datensegment
             mov   word ptr es:[bnk2.sp_reg],offset DATA:bnk2_stkend-2 ;Ende des Stacks
             mov   al,12h                   ;Bank Switch Interrupt 2
             mov   byte ptr es:[EXIC0],al   ;Interrupt freigeben
             mov   al,17h                   ;Bank Switch Interrupt 2
             mov   byte ptr es:[EXIC1],al   ;Interrupt freigeben
             popf                           ;alter Interrupt Zustand
else
;;; *** Int-Version ***
             push  ds                       ;retten
             push  bp
             mov   ax,cs                    ;Codesegment
             mov   ds,ax                    ;nach ds
             mov   dx,offset intp0_int      ;Offset dazu
             mov   ax,2518h                 ;Vektor Extern 0
             int   21h                      ;setzen
             mov   ax,cs                    ;Codesegment
             mov   ds,ax                    ;nach ds
             mov   dx,offset intp1_int      ;Offset dazu
             mov   ax,2519h                 ;Vektor Extern 1
             int   21h                      ;setzen
             pop   bp
             pop   ds                       ;wieder zurck
             mov   byte ptr es:[EXIC0],02h  ;Prioritt 2 ein
             mov   byte ptr es:[EXIC1],07h  ;Prioritt 2 ein
endif
             portdis                        ;IO-Port Zugriffe sperren
             mov   ax,TRUE                  ;kein Fehler
@@first_err: pop   di
             pop   si
             ret
             assume ds:nothing,es:nothing
scc_first    endp

             end
