{$I FD_INCL.PAS}
UNIT FD_SCC;

INTERFACE

USES FD_Def;


{$IFnDEF scc}  ##### Padauz !!! ######	{$ENDIF}

{$DEFINE LED}
{$R+}

 PROCEDURE BugFixV25;
  FUNCTION GetIO ( bitnr : Byte ):Byte;
 PROCEDURE SetIO ( bitnr : Byte; wert : Byte );
  FUNCTION ReadPortT (b : t_0to7 ) : t_0to16;
 PROCEDURE PortT2 (VAR s:String);
 PROCEDURE SCC_Timer;

(*$F+*)

CONST MAX_scciface=4;
TYPE T_scciface = RECORD
	chan_nr : byte;    (* Nummer dieses Kanals (fr Assembler) (0-3) *)
	baud	: longint; (* aktuelle Baudrate *)
	simpdup : Byte;    {* 0 = Duplex, 1 = Simplex ohne Switch
			    * 2 = Simplex mit Switch.
			    * Siehe Constante
			    * Achtung darf nur nach Deinit gen-
			    * dert werden !!!! *}
	txd	: Word;    {* Gibt TX Delay in 10ms Schritten *}
			   {* an. Jederzeit nderbar 1..255   *}
	persist : Byte;    {* Persistence (nicht implementiert) *}
	dwait	: Word;    {* Gibt DWAIT Konstante in 10ms Schritten an.
			    * Bereich 1..255 zulssig. Darf jederzeit gendert werden.
			    * (Spter Slottime) *}
	clk_reg : Byte;    {* Intern Treiber SCC [Inhalt WR11] *}
	nrzi_mode: Byte;   {* Intern Treiber SCC *}
	chk_crc : Byte;    {* fr die Daten bis hierhin (EEPROM!) *}
	l1_state: Byte;    {* Gibt den aktuellen Sende- bzw.
			    * Empfangszustand an:
			    * ZUST_NOP	equ	0   ;Zustand Kanal inaktiv (PTT ist aus)
			    * ZUST_DCD	equ	1   ;DCD ist an (PTT ist aus)
			    * ZUST_DWAIT equ	2   ;DWAIT luft (PTT ist aus)
			    * ZUST_FREE equ	3   ;Frei fr Start (PTT ist aus)
			    * ZUST_TXD	equ	4   ;TXD aktiv (PTT ist an)
			    * ZUST_DAT	equ	5   ;Daten werden gesendet (PTT ist an)
			    *}
	fak_rx	 : Word; {* RX-Baudfaktor *}
	fak_tx	 : Word; {* TX-Baudfaktor *}
	wr5_rx	 : Byte; {* WR5 Mode RX  *}
	wr5_tx	 : Byte; {* WR5 Mode TX  *}
	wr10_trx : Byte; {* WR10 Mode immer *}
	wr15_rx  : Byte; {* WR15 Mode RX *}
	wr15_tx  : Byte; {* WR15 Mode TX *}
	fTail	 : BYTE; {* Interne Verwendung im ASM Teil. Default=0 *}
	old_stat : Byte;   {* Alter Wert des Statusregisters. (rd0_scr) *}
			   {* Nur intern verwendet. *}
	rx_akt	: TP_mBuf; {* Zeiger auf aktuellen RX-Puffer-Controllblock *}
	rxadr_low : Word;  {* ASM lokal *}{* 20 Bit Adresse ohne Segment und
			    * Offset des aktuellen Empfangspuffers (rx_akt^.pData). *}
	rxadr_hi  : Byte;  {* ASM lokal *}{* 20 Bit Adresse ohne Segment und
			    * Offset des aktuellen Empfangspuffers. *}
	tx_root : TP_MBUF; {* Far Pointer auf den ersten zu senden-
			    * den Block. Die Definition der Struk-
			    * tur ist analog zu der bei den RootRx
			    * Zeigern. *}
	tx_tail : TP_MBUF; {* Far Pointer auf den letzten Block, ungltig wenn TX_ROOT=NIL*}
	chan_time: Word;   {* Nur intern in DIGIL1 verwendet. *}
			   {* Darf nicht verndert werden.    *}
	ch_free : boolean; {* Kanal ist frei !(PTT || DCD). Hier zeigen dann Timer-Pointer drauf *)
    {***^^^^^ Bis hierhin darf nicht gendert werden (siehe .ASM ^^^^^ *}
        preDAMAMode : Byte;   {* 0 = DAMA aktiv, danach wieder Duplex,
                            * 1 = DAMA aktiv, danach wieder Simplex ohne Switch
			    * 2 = DAMA aktiv, danach wieder Simplex mit Switch.
                            * 255 = kein DAMA aktiv.
                            *}
			   
	valid	: BOOLEAN; {* Dieser Eintrag ist gltig *}
 {* ACHTUNG: bei nderungen muss digil1.asm/falcl1.inc bzw. *}
 {* SCC_IO.ASM.SIZE_IFACE angepasst werden. Ausserdem FD_TX.InitIface anpassen.*}
END;
VAR sccIFace : ARRAY [1..MAX_scciface] OF T_scciface;


CONST dcdtimer0:Longint = 0;
      dcdtimer1:Longint = 0;
      dcdtimer2:Longint = 0;
      dcdtimer3:Longint = 0;

      tstState0:byte=0;
      tstState1:byte=0;
      tstState2:byte=0;
      tstState3:byte=0;


{}

IMPLEMENTATION

USES FD_Div,
     FD_Subr,
     FD_Mem,
     FD_Sysop, {wg.DoRegister}
     FD_Tnc  {wg. SDLC}
     ;


    {- ABSOLUTE entspricht hier GROB einem C-Define -}
VAR l2_parms : ARRAY [1..SizeOf(sccIFace)] OF Char ABSOLUTE sccIFace;
    stfl     : TP_Liste  ABSOLUTE lstDel;
    rxfl     : TP_Liste  ABSOLUTE lstRxInUse;
    freeL    : TP_1Liste ABSOLUTE RootRxFree; {- Ohje.... Hier wird nur next verwendet. -}

{$F+} PROCEDURE SCC_Timer;		      External; {$IFNDEF AllFar} {$F-} {$ENDIF}
{$F+}  FUNCTION SCC_First(x:Word) : BOOLEAN;  External; {$IFNDEF AllFar} {$F-} {$ENDIF}


CONST scc_tab : ARRAY [1..ANZ_SCCPORTS] OF Word = (SDLC1,SDLC2,SDLC3,SDLC4); {- SDLC Portadressen -}
      dma_tab : ARRAY [1..ANZ_SCCPORTS] OF Word = (DMA1,DMA1,DMA2,DMA2);     {- DMA Portadressen -}

CONST pInt10Original : POINTER = nil; {- Orginaladresse des Int10 des Laders, Wird fr WriteLn verwendet -}

VAR   INT10 : Pointer Absolute $0000:$0040;

{ Hardware: V24 }
TYPE T_FV24 = RECORD
                baud : Longint;
                nTX,nRX : Longint; {* Bytezhler *}
                fTrace : boolean;  {* Alles aufm Lauscherport ausgeben (p traceinfo) *}
                END;
CONST MAXFV24=2;
VAR fv24 : ARRAY [1..MAXfv24] OF t_fv24;

{ Hardware: scc }
TYPE T_FSCC = RECORD
                {baud : Longint;}
                nondamasimpdup : BYTE;
                END;
CONST MAXFSCC=4;
VAR fSCC : ARRAY [1..MAXfSCC] OF t_fSCC;
    mapping : ARRAY [1..MAX_IFACE] OF BYTE; {hier steht die devnr fr die im Packet enthaltene Ifacenr drin }
                       {^^^     ^ das ist korrekt (ist ja reziprok) }

{}

{$L v25io1.obj}	{- 1 Interrupt / 256 Byte , ohne Hardwaresuche nach FEND -}

{$F+}FUNCTION ishget1: Word ; External; {$F-}  {- gibt TRUE zurck wenn etwas im Rx-Buffer steht -}
{$F+}FUNCTION hgetc1: Byte; External; {$F-} {- liest genau 1 Zeichen aus dem Rx-Puffer. Wenn keins drin wird daruaf gewartet -}
{$F+}FUNCTION ishput1: Word ; External; {$F-}  {- gibt Anzahl freier Zeichen im Tx-Puffer zurck -}
{$F+}PROCEDURE hputc1( x : Byte); External; {$F-} {- bergibt ein Byte in den Puffer. Keine Rckgabewerte! -}
{$F+}PROCEDURE InitSeri1(Baud:Longint); External; {$F-}
{- serielle Schnittstelle Initialisieren; muss genau einmal aufgerufnen werden -}

{$L v25io0.obj}	{- 2 Interrupt / 256 Byte , ohne Hardwaresuche nach FEND -}

{$F+}FUNCTION ishget0: Word ; External; {$F-}  {- gibt TRUE zurck wenn etwas im Rx-Buffer steht -}
{$F+}FUNCTION hgetc0: Byte; External; {$F-} {- liest genau 1 Zeichen aus dem Rx-Puffer. Wenn keins drin wird daruaf gewartet -}
{$F+}FUNCTION ishput0: Word ; External; {$F-}  {- gibt TRUE zurck, wenn noch Platz im Tx-Buffer ist -}
{$F+}PROCEDURE hputc0( x : Byte); External; {$F-} {- bergibt ein Byte in den Puffer. Keine Rckgabewerte! -}
{$F+}PROCEDURE InitSeri0(Baud:Longint); External; {$F-}
{- serielle Schnittstelle Initialisieren; muss genau einmal aufgerufnen werden -}


{}


PROCEDURE BugFixV25;
BEGIN
  _DI;
  IF (p1 and 06) <> 06 THEN
    BEGIN
    if (p1 and 2)=0 THEN exic0 := exic0 or $80;
    if (p1 and 4)=0 THEN exic1 := exic1 or $80;
    END;
  _EI;
END;



{ FALCon I/O - Leitungen }

PROCEDURE SetIO ( bitnr : Byte; wert : Byte );
 {- Bitnr von PORT 0 auf WERT schalten -}
BEGIN
  IF wert = 0 THEN P0 := P0 AND NOT (1 SHL bitnr)
	      ELSE P0 := P0 OR	    (1 SHL bitnr);
END;

FUNCTION GetIO ( bitnr : Byte ):Byte;
 {- Port 0 befragen -}
BEGIN
  GetIO := Byte(( P0 AND (1 SHL bitnr) ) > 0);
END;


PROCEDURE PortT2 (VAR s:String);
{- Beispiel Programmierung T-Port. Aufruf nur in FD_Dump -}
  VAR i : Byte;
BEGIN
  s[0] := #16;
  FOR i := 1 TO 16 DO
    BEGIN {- Alle 16 Teiler durchlaufen -}
    pmt := i MOD 16;   {- Vref := Vth * i/16 -}
    s[i] := Char(pt);
    END;
END;

FUNCTION ReadPortT (b : t_0to7 ) : t_0to16;
  {- Abfrage T-Port: Durchlaufe alle Teilerwerte der Ref.Spannnung -}
  {- gebe den Index (0..16) zurck, wo das Signal von 0 auf 1 springt -}
 VAR  i   : ShortInt;
      orgx,x, mask : Byte;
BEGIN
  mask := (1 SHL b);
  orgx := NOT mask;
  ReadPortT := 16;
  i := 16;
  WHILE i >= 1 DO
    BEGIN {- Alle 16 Teiler durchlaufen -}
    pmt := i MOD 16;   {- Vref := Vth * i/16 setzen -}
    x := pt AND mask;
    IF i = 16 THEN orgx := x;

    IF x <> orgx THEN
      BEGIN
      ReadPortT := i; {- Aha! Hier nderte sich der Pegel auf 1 -}
      i:=-1; {- und Schluss -}
      END;
    Dec(i);
    END;
  IF i=0 THEN IF orgx = 0 THEN ReadPortT := 0
			  ELSE ReadPortT := 16;
END;


PROCEDURE SwitchStaLed(ifNr:byte; mode : t_doLED); far;
 {- An, Aus oder umschalten - auf jeden Fall das 7 Bit von Register 5 -}
 {- Dies ist in iface.wr5_tx gespiegelt. Wird beim nchsten ein oder  -}
 {- ausschalten der PTT gettigt. Irgendwie nicht optimal, aber wie   -}
 {- sagte schon Osgood Fielding III ? "Nobody is perfect"	      -}
 {- OK,OK dann machen wir das eben per hand.... -}
BEGIN
{$IFDEF LED}
  IF (ifnr<1) OR (ifNr>MAX_scciface) THEN Exit;
  IF NOT sccIFace[ifNr].valid THEN Exit;
  _portEna;
  _DI;         {* wg. SPiegelregister wr5_?x *}
  CASE mode OF
  cANSCHALTEN : BEGIN
		ORself ( sccIFace[ifNr].wr5_tx, $80);
		ORself ( sccIFace[ifNr].wr5_rx, $80);
		END;
 cAUSSCHALTEN : BEGIN
		ANDself ( sccIFace[ifNr].wr5_tx, $7f);
		ANDself ( sccIFace[ifNr].wr5_rx, $7f);
		END;
  cUMSCHALTEN : BEGIN
		XORself ( sccIFace[ifNr].wr5_tx, $80);
		XORself ( sccIFace[ifNr].wr5_rx, $80);
		END;
  END;{case}

  {* und nun auch wirklich durchfhren ... *}
  IF sccIFace[ifNr].l1_state >= 4 {- PTT_an ? -}
    THEN Port[scc_tab[ifNr]+WR5] := sccIFace[ifNr].wr5_tx  {- PTT ist an! -}
    ELSE Port[scc_tab[ifNr]+WR5] := sccIFace[ifNr].wr5_rx; {- PTT ist aus! -}
  _EI;
  _portdis;
{$ENDIF}
END;

{ SCC }

{$L fd_l1tim.obj}
{$L fd_sdlc.obj}   {- Der macht die eigentliche Arbeit an der SCC -}

PROCEDURE SCC_DeIni(ifNr:Word);
VAR chan : Word;
    sccp,dmap : Word;  {- SCC-Basis, DMA-Basis -}
BEGIN
  IF (ifNr > ANZ_SCCPORTS) THEN Exit; {- Fehler -}
  chan := ifNr-1; {- Anpassen auf SCC-Range 0..3 -}
  sccp := scc_tab[ifNr]; {- Basisadresse SDLC -}
  dmap := dma_tab[ifNr]; {- Basisadresse DMA -}

  _portEna; {- Port Access Enable -}
  _DI; {- keine Interrupts mehr -}
  sccIFace[ifNr].l1_state := ZUST_NOP; {- Kanal ist aus -}
  Port[sccp+WR1]:= 0; {- alle Interrupts aus -}
  Port[sccp+WR3]:= 0; {- RX aus -}
  Port[sccp+WR5]:= 0; {- TX aus -}
  IF (chan AND 1) <> 0
    THEN BEGIN
	 portw[dmap+RDCRB0] := 0;
	 portw[dmap+TDCRB0] := 0;
	 END {- Kanal B DMAs aus -}
    ELSE BEGIN
	 portw[dmap+RDCRA0] := 0;
	 portw[dmap+TDCRA0] := 0;
	 END; {- Kanal A DMAs aus -}
  IF Port[dmap+DSR] = 0 THEN; {- Status leeren -}
  _EI; {- Interrupts wieder zulassen -}
  _portdis
END; {- scc_deini -}


PROCEDURE Kick_TX(ifNr : Word); (* Sender anstossen *)
  VAR chan : Byte;
      sccp,
      dmap : Word;	   {- SCC-Basis, DMA-Basis -}
      par  : ^T_sccIFACE;  {- Parameterzeiger SCCs -}
      adr24 : Longint;
      lenAdr: WORD;
BEGIN
  chan := ifNr - 1;		      {- Anpassen auf SCC-Range 0..3 -}
  par := @sccIFace[ifNr];             {- Zeiger holen -}

  _DI;
  IF ((par^.l1_state <> ZUST_FREE) OR {- Kanal ist belegt/Dwait ist abgeelaufen -}
      (par^.tx_Root = NiL))  THEN     {- oder gar keine Frames da -}
    BEGIN {- dann brauch man nix tuen -}
    _EI;  {- nun kann erstmal ohne Eingriff von Interrupts gearbeitet werden -}
    Exit; {- Hintergrundroutine wird es machen -}
    END;
  {- Wir knnen/mssen 'hndisch' starten -}
  sccp := scc_tab[ifNr]; {- Basisadresse SDLC -}
  dmap := dma_tab[ifNr]; {- Basisadresse DMA -}
  _portEna;		 {- Ports freigeben -}
  IF (par^.simpdup <> DUPLEX) THEN
    BEGIN {- kein Duplex -}
    IF (Port[sccp+RD0] AND $08) <> 0 THEN
      BEGIN (* DCD ist doch an *)
      par^.l1_state := ZUST_DCD; (* DCD ist an *)
      par^.ch_free  := FALSE;	 (* belegt *)
      par^.old_stat := par^.old_stat OR $08; (* Anzeigen LED DCD an *)
      _EI;
      _portdis;
      (* ->>> *)  Exit;
      END;
    IF (chan AND 1) <> 0
      THEN portw[dmap+RDCRB0] := 0  {- Kanal B RX DMA aus -}
      ELSE portw[dmap+RDCRA0] := 0; {- Kanal A RX DMA aus -}
    Port[sccp+WR12] := par^.fak_tx AND $FF; {- Low Byte -}
    Port[sccp+WR13] := par^.fak_tx shr 8;   {- High Byte -}
    Port[sccp+WR15] := par^.wr15_tx;	    {- TX_IE_Register -}
    Port[sccp+ WR3] := WR3_MODE;	    {- Rx aus -}
    par^.ch_free := FALSE;
    END; {- kein Duplex -}

  IF par^.tx_root = Nil THEN Inc(count[cntKickError]);
  adr24 := par^.tx_Root^.bufl;
  lenAdr := par^.tx_Root^.inUse;
  _EI; {- wieder erlauben -}
  _portEna; {- Ports freigeben - EI setzt evtl. das Flag wieder falsch! -}

  {- TX-DMA starten -}
  IF (chan AND 1) <> 0
    THEN BEGIN {- Kanal B -}
	 portw[dmap+TDARB0]  := adr24 AND $FFFF;{- Adresse wird schon oben festgehalten, neu 6.11.94 -}
	 Port [dmap+TDARB0+2]:= (adr24 shr 16) AND $FF;
	 portw[dmap+TDCRB0]  := lenAdr; {- Anzahl -}
	 END {- Kanal B -}
    ELSE BEGIN {- Kanal A -}
	 portw[dmap+TDARA0]  := adr24 AND $FFFF;
	 Port [dmap+TDARA0+2]:= (adr24 shr 16) AND $FF;
	 portw[dmap+TDCRA0]  := lenAdr; {- Anzahl -}
	 END; {- Kanal A -}

  _DI; {- wieder sperren -}
  _portEna; {- Ports freigeben - DI setzt evtl. das Flag wieder falsch! -}
  par^.chan_time := par^.txd;	   {- Zhler TXD setzen -}
  Port[sccp+WR5] := par^.wr5_tx;   {- Sender mit entspr. Pars ein -}
  par^.l1_state := ZUST_TXD;	   {- neuer Zustand TXD -}
  Port[sccp+WR0] := $80;	   {- Reset TX CRC -}
  IF par^.txd = 0 THEN
    BEGIN			   {- CTS gesteuert -}
    IF (Port[sccp+RD0] AND $20) <> 0 THEN
      BEGIN			   {- CTS ist an -}
      IF (chan AND 1) <> 0
	THEN Port[dmap+CCAR] := $80  {- Start DMA B -}
	ELSE Port[dmap+CCAR] := $C0; {- Start DMA A -}
      {- Hier ist bei ASM ein NOP notwendig. Aber wir haben ja nen "TURBO"-Compiler... -}
      Port[sccp+WR0] := $C0;	     {- Reset EOM Flag (hier kein NOP ntig: dmap+wr0 muss ersma berechnet werden :-S) -}
      par^.l1_state := ZUST_DAT;     {- neuer Zustand -}
      END			     {- CTS ist an -}
    END;			     {- CTS gesteuert -}
  _EI;				     {- wieder freigeben -}
  _portdis;			     {- Ports wieder sperren -}
END; {- kicktx -}


PROCEDURE SCC_Ini(ifnr:WORD);
VAR chan : WORD;
    sccp,dmap : WORD;  {- SCC-Basis, DMA-Basis -}
    par : ^t_sccIFACE;
BEGIN  {- scc_ini -}
  {$IFDEF v24life} WriteLn('- SCC ',ifnr); {$ENDIF}

  IF (ifnr > ANZ_SCCPORTS) THEN Exit; {- Fehler -}
  chan := ifnr - 1; {- Anpassen auf SCC-Range 0..3 -}
  SCC_deini(ifnr);	 {- erstmal Deinit -}
  sccp := scc_tab[ifnr]; {- Basisadresse SDLC -}
  dmap := dma_tab[ifnr]; {- Basisadresse DMA -}
  par  := @sccIFace[ifnr];  {- Zeiger merken -}
  par^.chan_nr := chan;
  _portena; {- Ports ein -}
  port[sccp+WR4] := $20;      {- SDLC Mode setzen -}
  port[sccp+WR3] := WR3_MODE; {- Modus RX, 8 Bit, Hunt Mode, CRC on -}
  par^.wr5_tx  := WR5_MODE OR
		  TX_ENABLE OR	{- Sender ein -}
		  RTS_ON;	{- PTT(=RTS) ein -}
  par^.wr5_rx  := WR5_MODE OR
		  TX_ENABLE;  {- Flags in Pausen -}
  port[sccp+WR5] := WR5_MODE; {- Modus TX, 8 Bits, Tx CRC on -}
  port[sccp+WR7] := $7E;      {- Register 7 -> Flag -}
  IF (par^.nrzi_mode) <> 0
    THEN par^.wr10_trx := $80+$20  {- CRC-Preset, NRZI, Flag Idle, Flag EOM, no Loop -}
    ELSE par^.wr10_trx := $80+$00; {- CRC-Preset, NRZ,	Flag Idle, Flag EOM, no Loop -}
  port[sccp+WR10] := par^.wr10_trx;
  par^.fTail := 0;
  port[sccp+WR14] := $02; {- BRG Source=PCLK, BRG aus -}
  port[sccp+WR11] := par^.clk_reg; {- Clock Optionen -}

  par^.fak_rx := ((PCLK SHR 6) DIV par^.baud) - 2; {- Baudfaktor RX 32 fach -}
  IF (par^.simpdup = SIMPLEXSPEZ)
    THEN par^.fak_tx := ((par^.fak_rx + 2) SHL 5) - 2 {- Special Simplex -}
    ELSE par^.fak_tx := par^.fak_rx; {- Simplex normal od. Duplex -}

  IF ((par^.clk_reg AND $60) <> $60) AND  {if ReceiveClock<>DPLL Output AND}
     ((par^.clk_reg AND $18) <> $18) THEN {   TransmitClockk<>DPLL Output DANN}
       BEGIN {- wird die DPLL berhaupt nicht benutzt -}
       par^.fak_rx := ((PCLK SHR 1) DIV par^.baud ) - 2; {-  -}
       par^.fak_tx := par^.fak_rx; {-  -}
       END;

  port[sccp+WR14] := $62;		  {- disable DPLL -}
  port[sccp+WR14] := $82;		  {- DPLL Source = BRG -}
  port[sccp+WR14] := $E2;		  {- DPLL NRZI-Mode -}
  port[sccp+WR12] := par^.fak_rx AND $FF; {-  Low Byte Zeitkonstante BRG -}
  port[sccp+WR13] := par^.fak_rx SHR 8;   {- High Byte Zeitkonstante BRG -}
  port[sccp+WR14] := $03;		  {- BRG start -}
  port[sccp+WR14] := $23;		  {- DPLL Start -}
  IF ((par^.clk_reg AND $F8) = $50) THEN port[sccp+WR14] := $13; {- Local loopback! -}

  par^.wr15_rx := $80 + $40;   		  {- Abort, EOM --> ext.Ints -}
  IF fGlobMessTxd THEN OrSelf(par^.wr15_rx,$08); {- DCD lst auch ext.int aus-}

  par^.wr15_tx := par^.wr15_rx AND $F7; {- erstmal gleiche Option ohne DCD -}
  IF (par^.simpdup <> DUPLEX) THEN par^.wr15_tx := par^.wr15_tx AND $60; {- Nur TX under + CTS -}
  port[sccp+WR15] := par^.wr15_rx; {- erstmal RX-Zustand -}

  IF par^.rx_akt = Nil THEN
    BEGIN
    par^.rx_akt := GetL1Rxbuf;
    END;
  {- Flache Adresse des eigentlichen Buffers fr DMA berechnen -}
  par^.rxadr_hi  :=	 par^.rx_akt^.bufl SHR 16;
  par^.rxadr_low := word(par^.rx_akt^.bufl);
  IF (chan AND 1) <> 0
    THEN BEGIN {- B-Kanal -}
	 portw[dmap+RDARB0] := par^.rxadr_low; {- Low Word Adresse -}
	 portw[dmap+RDARB2] := par^.rxadr_hi;  {- High Word Adresse -}
	 portw[dmap+RDCRB0] := par^.rx_akt^.len+3;  {- maximale Lnge -}
	 portw[dmap+CCAR]   := $A0;	     {- rx-DMA starten -}
	 END {- B-Kanal -}
    ELSE BEGIN {- A-Kanal -}
	 portw[dmap+RDARA0] := par^.rxadr_low; {- Low Word Adresse -}
	 portw[dmap+RDARA2] := par^.rxadr_hi;  {- High Word Adresse -}
	 portw[dmap+RDCRA0] := par^.rx_akt^.len+3; {- maximale Adresse -}
	 portw[dmap+CCAR]   := $E0;		{- DMA starten -}
	 END; {- A-Kanal -}
  _DI; {- sperren, da Interrupt Manipulation -}
  port[sccp+WR0] := $10;	    {- Reset Ext. Status -}
  port[sccp+WR0] := $10;	    {- 2 mal -}
  par^.old_stat := port[sccp+RD0];  {- aktueller Zustand -}
  par^.chan_time := 0;		    {- Timer erstmal aus -}
  par^.ch_free := TRUE;
  IF ( (par^.simpdup = DUPLEX)	OR     {- Bei Duplex ... -}
       ((par^.old_stat AND $08) = 0))  {- ...oder DCD aus... -}
      THEN par^.l1_state := ZUST_FREE  {- ...kann sofort gesendet werden -}
      ELSE par^.l1_state := ZUST_DCD;  {- DCD ist ein -}
  port[sccp+WR1] := $01+$18;	       {- Ext. Int + spec. Receive Enable -}
  port[sccp+WR3] := WR3_MODE+RX_ENABLE;{- Empfnger ein -}
  port[sccp+WR5] := par^.wr5_rx;
  _EI; {- alter Interrupt Zustand -}
  _portdis; {- Ports aus -}

  par^.valid := TRUE;
  SwitchStaLed(ifnr, cANSCHALTEN);
END; {- scc_ini -}



PROCEDURE FSCC_TxPacket( pm : tp_mbuF ); Far;
{* Wird indirekt angesprungen *}
  VAR ifNr : t_ifnr;
BEGIN
 ifNr := mapping[pm^.ifNr];
 IF ifNr <= MAX_sccIFACE THEN  WITH sccIFace[ifNr] DO
   BEGIN (* SCC INTERFACE *)
   WatchDog;
   pm^.bufl := LongInt(l2w(pm^.pData).seg) SHL 4
		     + l2w(pm^.pData).ofs; (* 20 Bit Adresse *)
   pm^.next := NiL; (* sicher ist sicher *)
   _DI;
   IF tx_Root = NiL
     THEN BEGIN
          IF (l1_State=ZUST_DAT) THEN Inc(Count[cntTailNil]);
          IF (l1_State=ZUST_TXD) THEN Inc(Count[cntTailNil2]);
          tx_Root := pm	 (* Root neu setzen *)
          END
     ELSE tx_tail^.next := pm; (* an altes dran *)
   tx_tail := pm;  (* Tail neu setzen *)
   _EI; {- _Kick_tx muss ja wohl nicht geklammert werden. kw090193 -}
   Kick_TX (ifNr); (* Sender anstossen *)
   END;  (* SCC INTERFACE *)
END;

{---------------------------------------------------------------------}

PROCEDURE FSCCKommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 =
  { 1}  'BAUD INIT DF9IC G3RUH AFSK CLKREG NRZI DUPLEX SIMPLEX SIMPSPEZ '+
        'TXDELAY DWAIT TXTAIL MESSTXD STOP NRZ ';
        cmBAUD=1;     cmINIT=2;   cmDF9IC=3;   cmG3RUH=4;   cmAFSK=5;
        cmCLKREG=6;   cmNRZI=7;   cmDUPLEX=8;  cmSIMPLEX=9; cmSIMPSPEZ=10;
        cmTXDELAY=11; cmDWAIT=12; cmTXTAIL=13; cmMESSTXD=14;cmSTOP=15;
        cmNRZ=16;

        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   i,x, portNr : BYTE;
        li,para,para2 : Longint;
BEGIN
with sccIFace[devnr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird 0 oder ein sehr hoher Wert verwendet *}
    CASE x OF
      cmBAUD : {sccIFace[devnr].}
               BEGIN
               Baud := para;
               END;
      cmINIT : ; {* ab 6.5.97 berflssig *}
      cmSTOP : Scc_DeIni(devnr);
     cmDF9IC : BEGIN
               clk_reg := $08;  {* DF9IC stellt TX/RX-Takt selber zur Verfgung *}
               simpDup := SIMPLEX;
               NRZI_MODE := 0;
               END;
     cmG3RUH : BEGIN
               clk_reg := $66;  {* RxTakt selber; TxTakt ausgabe an TrXc vom BRG *}
               simpDup := SIMPLEX;
               NRZI_MODE := 1;
               END;
     cmAFSK  : BEGIN
               clk_reg := $76; {*RxC immer DPLL; TxC=BRG ...*}
               simpDup := SIMPLEXSPEZ;
               NRZI_MODE := 1;
               END;
     cmCLKREG: IF para <= 255 THEN clk_reg := para;
     cmNRZI  : IF para <= 255 THEN NRZI_mode := para
                              ELSE NRZI_mode := 1;
     cmNRZ   : nrzi_mode := 0;
     cmDUPLEX: BEGIN
               simpdup := DUPLEX;
               END;
     cmSIMPSPEZ
             : BEGIN
               simpdup := SIMPLEXSPEZ;
               END;
     cmSIMPLEX
             : BEGIN
               simpdup := SIMPLEX;
               END;
     cmTXTAIL : fTail := para;
     cmTXDELAY
             : IF para < 3000 THEN txd := para;
     cmDWAIT : IF (para <= 255) AND (para>0) THEN
                  BEGIN
                  Dwait := Para;
                  END;
     cmMESSTXD:IF para<255 then
                 BEGIN
                 fGlobMessTxd := para>0;
                 END;
(*      cmIO    : BEGIN {* Port Befehle *}
                IF (para >= 3) AND (para<=7) THEN
                  BEGIN
                  IF para2<255 THEN SetIO(para, byte(para2<>0) );
                  {* ^^^^^Wenn kein 2.Argument angegeben, ist dies > 255 *}
                  TX_Info(pCB,SPAETER,'IO:'+FStr( GetIO( para )));
                  END;
                END;
      cmAD    : BEGIN {* Port T Befehle: P AD 2 gibt einen Wert von 0..16 zurck *}
                IF (para >= 0) AND (para<=7) THEN
                  BEGIN
                  para2 := ReadPortT(para);
                  TX_EolSysInfo(pCB,SPAETER,'PT'+FStr(para)+'='+FStr( para2 )
                              +'  fuer VTH=5V sind dies '+FStr(para2*5000 DIV 16)+' mV' );
                  END;
                END;
 *)

      END; {Case}
    IF x <> cmSTOP THEN SCC_Ini(devNr);
  UNTIL x=0;
END;



{$F+}CONST sReturn : STRING='';

FUNCTION FSCC_SetPara ( hwnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
      s : STRING;
BEGIN
 FSCC_SetPara := speOK;
 WITH sccIFace[hwnr] DO
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        FSCCKommandozeile( T_PSTRING(wert)^, hwnr );
        Exit;
        END;
{$IFDEF DAMA_SLAVE}
    spSETZEDAMAPARA
      : BEGIN
        IF (wert = 1) AND (preDAMAMode<>255) THEN Exit; {schon aktiv}
        IF (wert <>1) AND (preDAMAMode=255) THEN Exit; {is schon aus}
        IF wert = 1 THEN BEGIN {* DAMA an (Simplexspezial kann kein Duplex) }
                         IF simpDup <> SIMPLEXSPEZ
                           THEN BEGIN
                                preDAMAMode := simpDup;
                                simpDup := DUPLEX
                                END
                           ELSE BEGIN
                                preDAMAMode := Dwait;
                                Dwait := 0;
                                END;
                         END
                    ELSE BEGIN { DAMA ausmachen }
                         IF (preDAMAMode=duplex) OR (preDAMAMode=simplex)
                           THEN simpDup := preDAMAMode
                           ELSE Dwait := preDAMAMode;
                         preDAMAMode := 255;
                         END;
        s := 'INIT';
        FSCCKommandozeile( s, hwnr );
        Exit;
        END;
{$ENDIF}
    spHOLEPARAMSTRING
      : BEGIN
        sReturn :=  fStr(baud)+' baud'
                  + ' txd:'    + fStr(txd)
                  + ' dWait:'  + fStr(dwait)
                  + ' '        + casSIMPDUP[simpDup];
        IF preDAMAMode <> 255 THEN AddString(sReturn,' -D'+FStr(preDAMAMode));
        AddString(sReturn,
                    ' '        + casNRZI[nrzi_mode]
                  + ' clk:0x'  + HexByteString(clk_reg)
                  + ' mTxd:'   + F_Bool2OnOff(fGlobMessTxd)

                  + ' f:'      + fStr(byte(ch_free))
                  + ' s:'      + fStr(l1_state)
                  + ' t:'      + fStr(chan_time)
                  );
        FSCC_SetPara := Longint(@sReturn);
        END;
    spSETZEWertIFACENr
      : BEGIN
        {ifacenr:=wert;}
        mapping[wert] := hwnr; {fr TXPAcket}
        END;
    spHOLEPROC
      : BEGIN
        IF wert = ord(hpTxPacket) THEN FSCC_SetPara:=Longint(@FSCC_TXPacket)
        ELSE IF wert = ord(hpLED) THEN FSCC_SetPara:=Longint(@SwitchStaLed)
                                  ELSE FSCC_SetPara := 0;
        END;
    ELSE {* case *} FSCC_SetPara := speNNCMD;
  END;
END;

{-------------V24---------------------------------------------------}

FUNCTION hgetc0_Redirect: Byte;      far;
 {- liest genau 1 Zeichen aus dem Rx-Puffer. Wenn keins drin wird daruaf gewartet -}
  var x:byte;
BEGIN
  x := hgetc0;
  IF fv24[2].fTrace THEN TracePlain ( char(x), 'r2');
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(FV24[2].nRx);
 {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
  hgetc0_Redirect:=x;
END;

PROCEDURE hputc0_Redirect( x : Byte); far;
{- bergibt ein Byte in den Puffer. Keine Rckgabewerte! -}
BEGIN
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(FV24[2].nTx);
 {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
  IF fv24[2].fTrace THEN TracePlain ( char(x), 't2');
  hputc0(x);
END;
FUNCTION hgetc1_Redirect: Byte; far;
{- liest genau 1 Zeichen aus dem Rx-Puffer. Wenn keins drin wird daruaf gewartet -}
  var x:byte;
BEGIN
{*  SwitchStaLed(3,cUmschalten); { xx. }
  x := hgetc1;
  IF fv24[1].fTrace THEN TracePlain ( char(x), 'r1');
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(FV24[1].nRx);
 {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
  hgetc1_Redirect:=x;
{*  SwitchStaLed(3,cAusschalten); { xx. }
END;
PROCEDURE hputc1_Redirect( x : Byte); far;
{- bergibt ein Byte in den Puffer. Keine Rckgabewerte! -}
BEGIN
  {* SwitchStaLed(4,cAnschalten); { xx. }
  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  Inc(FV24[1].nTx);
  {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
  IF fv24[1].fTrace THEN TracePlain (char(x), 't1');
  hputc1(x);
  {* SwitchStaLed(4,cAusschalten); { xx. }
END;

{*FUNCTION ishget1_redirect: Word ; far;
 * var x : word;
 *begin
 * x := ishget1;
 * IF fv24[1].fTrace THEN TracePlain (fStr(x), '?1');
 * ishget1_redirect := x;
 * end;
 *}



PROCEDURE FV24Init(devnr:word);
BEGIN
    WITH fv24[devnr] DO
      BEGIN
      {$IFDEF v24life}
      WriteLn('- V24-',devnr, Baud:7);
      {$ENDIF}
      IF devnr=1 THEN InitSeri1(Baud)
                 ELSE BEGIN
                      Int10:=@Proc_RETI; {* umleiten *}
                      InitSeri0(Baud);
                      END;
      END;
END;


PROCEDURE FV24Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'BAUD INIT TRACE NOTRACE ';
        cmBAUD=1; cmINIT=2; cmTrace=3; cmNoTrace=4;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   x : BYTE;
        para : Longint;
BEGIN
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforVal(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmBAUD    : BEGIN
                  fv24[devnr].Baud := para;
                  FV24Init(devnr); {* 6.5.97 *};
                  END;
      cmINIT    : FV24Init(devnr); {* 6.5.97 *}
      cmTrace   : fv24[devnr].fTrace := true;
      cmNoTrace : fv24[devnr].fTrace := false;
     END {Case}
  UNTIL x=0;
END;


{$F+}
FUNCTION FV24_SetPara ( hwnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
BEGIN
  FV24_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Fv24Kommandozeile( T_PSTRING(wert)^, hwnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sReturn := fStr(fv24[hwnr].baud)+' baud'
                 + ' byRx:'+ Fstr(fv24[hwnr].nRx)
                 + ' byTx:'+ Fstr(fv24[hwnr].nTx)
                 + ' trace:'+ F_Bool2OnOff (fv24[hwnr].fTrace)
                 ;
        FV24_SetPara := Longint(@sReturn);
        END;
    spHOLEPROC :
        BEGIN
        CASE wert OF
           ord(hpRX1CHAR) : case hwnr of
                             1 :  FV24_SetPara := Longint(@hgetc1_redirect);
                             2 :  FV24_SetPara := Longint(@hgetc0_redirect);
                             END;
           ord(hpNRXCHAR) : CASE  hwnr of
                             1 :  FV24_SetPara := Longint(@ishget1);
                             2 :  FV24_SetPara := Longint(@ishget0);
                             END;
           ord(hpTX1CHAR) : case hwnr of
                             1 :  FV24_SetPara := Longint(@hputc1_redirect );
                             2 :  FV24_SetPara := Longint(@hputc0_redirect );
                             END;
           ord(hpNTXCHAR) : CASE  hwnr of
                             1 :  FV24_SetPara := Longint(@ishput1);
                             2 :  FV24_SetPara := Longint(@ishput0);
                             END;
           ord(hpLED)     : FV24_SetPara:=Longint(@SwitchStaLed);
           END;
        END;
    ELSE {* case *} FV24_SetPara := speNNCMD;
  END;
END;


{}

{* G3RUH: ClkModus $66; SIMPLEX/DUPLEX;  NRZI=1 *}
{* DF9IC: ClkModus $08; SIMPLEX/DUPLEX;  NRZI=0 *}
{* ext.Loopback, TCM3105, AM7911: ClkModus $76; SIMPLEXSPEZIAL;  NRZI=1 *}
{* evtl. falsche Baudrate, dann TCM3105, AM7911: ClkModus $7E; SIMPLEX/DUPLEX; NRZI=1; (z.B. bei DL1EBQ)*}
{*  ext.Loopback geht dann NICHT (macht PTT-Haenger, Rx braucht Flanke zum Starten!) *}
{* ExtLoopback: clk $52 dupl nrzi  geht auch...*}

PROCEDURE InitSCCIFace;
  {* IFACE mit Default Werten versorgen *}
  VAR j : WORD;
BEGIN
  FOR j := 1 TO MAX_sccIFace DO WITH sccIFace[j] DO
    BEGIN
    Watchdog;
    valid := FALSE;
    {$IFDEF scc}
    nrzi_mode := 1;
    clk_reg := {01110110} $76; {* Taktverteilung *}
    {$ENDIF}
    tx_root := NiL;
    tx_tail := NiL; {* muss nicht ist aber schoener so *}

    ch_free := TRUE;
    simpdup := SIMPLEX;
    preDAMAMode := 255;
    dwait   := 40;    txd     := 4;           baud :=9600;
    END;
END;


{}
BEGIN
  WatchDog;
  pInt10Original := Int10; {* Wird gebraucht um die 2.V24 per Kiss anzustehern -}

  {- Port 0 initialisieren -}
  pm0_Write ($07); {- Port Mode Register 0: P 03-07 als Output schalten -}

 {- WriteLn('- IFace: n*Size:',ANZ_SCCPORTS,'*',SizeOf(T_IFACE) ); -}
  IF NOT SCC_First(ANZ_SCCPORTS*SizeOf(T_sccIFACE)) THEN
    BEGIN {- ASM und PAS Datenstrukturen haben ungleiche Gre -}
    WriteLn ('*** Err:IFace-Struc.Size',ANZ_SCCPORTS*SizeOf(T_sccIFACE));
    RunError(ERR_IFACE_NE); {- Notbremse -}
    END;

  DoRegister('SCC', 1,MAXFSCC, FSCC_SetPara);
  DoRegister('V24', 1,MAXFV24, FV24_SetPara); {* 1=falconv24-1  2=falconv24-0 *}

  FillChar(Fv24, sizeof(fv24), #0);
  InitSCCiFace;
END.
