UNIT FD_QTH;   {* von DL7GAI *}

{$I FD_INCL.PAS}
{$IFnDEF scc} {$O+,F+} {$ENDIF}

INTERFACE

USES FD_Def;

PROCEDURE CompQTH(pCB: TP_AXCB; VAR sArg1,sArg2 : String); {* von cmQTH aufgerufen *}

{}

IMPLEMENTATION

 USES FD_Tx,
      FD_Div,
      FD_Mem;


PROCEDURE nloc2deg(mayloc:Str6; VAR targetlen,targetbri: REAL);
 {* Neuer Maydenheadloc. nach Lnge/Breite wandeln *}
BEGIN;
  targetlen:=-180+((Ord(mayloc[1])-65)*20)+
                  ((Ord(mayloc[3])-48)*2)+
                  ((Ord(mayloc[5])-65)/12)+
                  1/24;
  targetbri:= -90+((Ord(mayloc[2])-65)*10)+
                  ((Ord(mayloc[4])-48))+
                  ((Ord(mayloc[6])-65)/24)+
                  1/48;
END;

FUNCTION deg2str( mode : Byte; w : REAL):Str12;
  {* Winkel nach String *}
VAR argp,arg1,arg2,arg3:INTEGER;
    dummy:REAL;
    ars2,ars3:String[2];
    ars1 : Str3;
    dstr : Str12;
BEGIN
  arg1:=Trunc(Int(w));
  dummy:=w-arg1;
  arg2:=Trunc(Int(dummy*60));
  dummy:=dummy-(arg2/60);
  arg3:=Trunc(Int(Round(dummy*3600)));

  argp:=arg1; {* w/s negativ; e/n positiv*}
  arg1:=Abs(arg1);
  arg2:=Abs(arg2);
  arg3:=Abs(arg3);
  Str(arg1:3,ars1);Str(arg2:2,ars2);Str(arg3:2,ars3);
  dstr:=ars1+':'+ars2+#39+ars3+#34+' ';
  IF mode=1 THEN IF argp<0 THEN dstr:=dstr+'W'
                           ELSE dstr:=dstr+'O'
            ELSE IF argp<0 THEN dstr:=dstr+'S'
                           ELSE dstr:=dstr+'N';
  deg2str:=dstr;
END;

PROCEDURE Aloc2deg(altloc:str5; VAR targetlen,targetbri : REAL);
   {* Alter Locator -> Lnge/Breite *}
BEGIN;
  targetlen:=0+(Ord(altloc[1])-65)*2+((Ord(altloc[4])-49)*0.2);
  CASE altloc[5] of
  'F','G','H' : targetlen:=targetlen+(1/30);
  'A','E','J' : targetlen:=targetlen+(3/30);
  'B','C','D' : targetlen:=targetlen+(5/30);
  END;
  targetbri:=40+(Ord(altloc[2])-64)*1+((Ord(altloc[3])-48)*-0.125);
  CASE altloc[5] of
  'A','B','H' : targetbri:=targetbri+(-1/48);
  'C','G','J' : targetbri:=targetbri+(-3/48);
  'E','F','D' : targetbri:=targetbri+(-5/48);
  END;
  IF altloc[4]='0' THEN BEGIN;
                        targetlen:=targetlen+2;
                        targetbri:=targetbri+0.125;
                        END;
END;

FUNCTION Grad2nloc( targetlen,targetbri:REAL):Str6;
  {* Lnge/Breite -> Maydenhead-Loc. *}
VAR igo,rgo,
    ign,rgn,
    zmo,rmo,
    zmn,rmn   :REAL;
    ioi,ini,
    izoi,izni :ShortInt;
    dstr      :Str6;
BEGIN
  dstr[0] := #6;
  igo:=(targetlen+180)/20;
  ioi:=Trunc(Int(igo));
  dstr[1]:=chr(65+ioi);

  rgo:=(targetlen+180)-(ioi*20);
  ign:=(targetbri+90)/10;
  ini:=Trunc(Int(ign));
  dstr[2]:=chr(65+ini);

  rgn:=(targetbri+90)-(ini*10);
  zmo:=rgo/2;
  izoi:=Trunc(Int(zmo));
  dstr[3]:=chr(48+izoi);

  rmo:=rgo-(izoi*2);
  zmn:=rgn/1;
  izni:=Trunc(Int(zmn));
  dstr[4]:=chr(48+izni);

  rmn:=rgn-izni;
  dstr[5] := chr(Trunc(rmo*12)+65);
  dstr[6] := chr(Trunc(rmn*24)+65);
  Grad2nloc:=dstr;
END;

FUNCTION Grad2aloc(targetlen,targetbri:REAL):String;
    {* Lnge/Breite -> Alt-Locator *}
VAR zio,zin,
    indgo,indgn,
    rgo,rgn,
    rmo,rmn:REAL;
    mko,mkn:INTEGER;
    sALoc:String[5];
BEGIN;
  IF (targetlen<0)  or (targetlen>52) or  {* alt_loc's Funktionsbereich *}
     (targetbri<40) or (targetbri>66) THEN
       BEGIN;
       Grad2aloc:='';
       Exit;
       END;
  sALoc[0] := #5;
  indgo:=targetlen/2;
  sALoc[1]:=chr(65+Trunc(indgo));

  rgo:=targetlen-(2*Trunc(indgo));
  indgn:=targetbri-40;
  sALoc[2] := chr(65+Trunc(indgn));

  rgn:=1-(Frac(indgn));
  zio:=rgo/0.2+1;
  rmo:=0.2*(zio-Trunc(zio));
  IF rgn>0.124 THEN BEGIN;
                    zin:=rgn/0.125;
                    rmn:=rgn-(0.125*Trunc(zin));
                    END
               ELSE BEGIN
                    zin:=0;
                    rmn:=rgn;
                    END;
  IF Trunc(zio)=10 THEN BEGIN;   {* korrektur eines systematischen teilungsfehlers *}
                        zio:=0;
                        zin:=zin+1;
                        END;
  sALoc[3]:=chr(48+Trunc(zin));
  sALoc[4]:=chr(48+Trunc(zio));

  rmo:=rmo*30;
  rmn:=rmn*48;
{* rmo und rmn auf passende Werte runden *}
  IF  rmo<2              THEN mko:=1;
  IF (rmo>2) AND (rmo<4) THEN mko:=3;
  IF  rmo>4              THEN mko:=5;
  IF  rmn<2              THEN mkn:=1;
  IF (rmn>2) AND (rmn<4) THEN mkn:=3;
  IF  rmn>4              THEN mkn:=5;
  CASE mkn of
   1: CASE mko of
       1: sALoc[5]:='H';
       3: sALoc[5]:='A';
       5: sALoc[5]:='B';
      END;
   3: CASE mko of
       1: sALoc[5]:='G';
       3: sALoc[5]:='J';
       5: sALoc[5]:='C';
      END;
   5: CASE mko of
       1: sALoc[5]:='F';
       3: sALoc[5]:='E';
       5: sALoc[5]:='D';
      END;
  END;
  Grad2aloc:=sALoc;
END;

FUNCTION ALocCheck (aloc:String):BOOLEAN; {* prueft alten locator *}
  TYPE  a_sof= set of Char;
  CONST check_arr:ARRAY[1..5] of a_sof
       = (['A'..'Z'],      (* Z. 1 *)
          ['A'..'Z'],      (* Z. 2 *)
          ['0'..'8'],      (* Z. 3 *)
          ['0'..'9'],      (* Z. 4 *)
          ['A'..'H','J']); (* Z. 5 *)
  VAR   i      :ShortInt;
        m_feld :String;
BEGIN
  ALocCheck:=TRUE;
  FOR i:=1 TO 5 DO IF NOT(aloc[i] in check_arr[i]) THEN ALocCheck:=FALSE;
  m_feld:=Copy(aloc,3,2);
  IF (m_feld='00') or (m_feld>'80') THEN ALocCheck:=FALSE;
END;

FUNCTION N_loc_check(nloc:String):BOOLEAN; {* prueft maydenhead locator *}
 TYPE  n_sof = set of Char;
 CONST check_arr:ARRAY[1..6] of n_sof
     = (['A'..'R'],   (* Z. 1 *)
        ['A'..'R'],   (* Z. 2 *)
        ['0'..'9'],   (* Z. 3 *)
        ['0'..'9'],   (* Z. 4 *)
        ['A'..'X'],   (* Z. 5 *)
        ['A'..'X']);  (* Z. 6 *)
 VAR i : ShortInt;
BEGIN
  N_loc_check:=TRUE;
  FOR i:=1 to 6 do IF NOT(nloc[i] in check_arr[i]) THEN N_loc_check:=FALSE;
END;

FUNCTION Arccos(xar:REAL):REAL;
BEGIN;
  Arccos:=pi/2-Arctan(xar/Sqrt(Abs(1-Sqr(xar))));
END;

{$IFDEF dsfsfd}
FUNCTION StrGrad2Real( l_b : String; VAR targetbri,targetlen : REAL):BOOLEAN;
{* wandelt O9,12,30/N47,41,15 nach Realwerten in Laenge und Breite *}
{* und prueft das eingabeformat*}
VAR la,br:ARRAY[1..3] of String;
    ls,bs:String;
    p,x:ShortInt;
    y:INTEGER;
    du:REAL;
BEGIN
  StrGrad2Real := FALSE;
  p:=Pos('/',l_b);
  ls:=Copy(l_b,1,p-1);
  bs:=Copy(l_b,p+1,Length(l_b));
  IF ((ls[1]<>'O') AND (ls[1]<>'E') AND (ls[1]<>'W')) or
     ((bs[1]<>'N') AND (bs[1]<>'S')) THEN  Exit;
  x:=1;
  la[1]:='';
  la[2]:='';
  la[3]:='';
  FOR p:=2 to Length(ls) do
    IF ls[p]=',' THEN BEGIN
                      Inc(x); IF x > 3 THEN Exit;
                      END
                 ELSE la[x]:=la[x]+ls[p];
  Val(la[1],targetlen,y);
  IF (targetlen>=180) or (y>0) THEN Exit;
  Val(la[2],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetlen:=targetlen+(du/60);
  Val(la[3],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetlen:=targetlen+(du/3600);
  IF ls[1]='W' THEN targetlen:=targetlen*(-1);
  x:=1;
  br[1]:='';
  br[2]:='';
  br[3]:='';
  FOR p:=2 to Length(bs) do
    IF bs[p]=',' THEN BEGIN
                      Inc(x);
                      IF x > 3 THEN
                      END
                 ELSE br[x]:=br[x]+bs[p];
  Val(br[1],targetbri,y);
  IF (targetbri>=90) or (y>0) THEN Exit;

  Val(br[2],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetbri:=targetbri+(du/60);
  Val(br[3],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetbri:=targetbri+(du/3600);
  IF bs[1]='S' THEN targetbri:=targetbri*(-1);
  StrGrad2Real:=TRUE;
END;
{$ENDIF}


FUNCTION StrGrad2Real( l_b : String; VAR targetbri,targetlen : REAL):BOOLEAN;
{* wandelt O9,12,30/N47,41,15 nach Realwerten in Laenge und Breite *}
{* und prueft das Eingabeformat*}
VAR la,br:ARRAY[1..3] of String;
    ls,bs:String;
    p,x:ShortInt;
    y:INTEGER;
    du:REAL;
BEGIN;
  StrGrad2Real := FALSE;
  p:=Pos('/',l_b);
  ls:=Copy(l_b,1,p-1);
  bs:=Copy(l_b,p+1,Length(l_b));
  IF ((ls[1]<>'O') AND (ls[1]<>'E') AND (ls[1]<>'W')) or
     ((bs[1]<>'N') AND (bs[1]<>'S')) THEN  Exit;
  x:=1;
  la[1]:='';
  la[2]:='';
  la[3]:='';
  FOR p:=2 to Length(ls) do
    IF ls[p]=',' THEN BEGIN
                      Inc(x); IF x > 3 THEN Exit;
                      END
                 ELSE la[x]:=la[x]+ls[p];
  Val(la[1],targetlen,y);
  IF (targetlen>=180) or (y>0) THEN Exit;
  Val(la[2],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetlen:=targetlen+(du/60);
  Val(la[3],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetlen:=targetlen+(du/3600);
  IF ls[1]='W' THEN targetlen:=targetlen*(-1);
  x:=1;
  br[1]:='';
  br[2]:='';
  br[3]:='';
  FOR p:=2 to Length(bs) do
    IF bs[p]=',' THEN BEGIN
                      Inc(x);
                      IF x > 3 THEN
                      END
                 ELSE br[x]:=br[x]+bs[p];
  Val(br[1],targetbri,y);
  IF (targetbri>=90) or (y>0) THEN Exit;

  Val(br[2],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetbri:=targetbri+(du/60);
  Val(br[3],du,y);
  IF (du>=60) or (y>0) THEN Exit;

  targetbri:=targetbri+(du/3600);
  IF bs[1]='S' THEN targetbri:=targetbri*(-1);
  StrGrad2Real:=TRUE;
END;


PROCEDURE ComTarget( VAR locator,target:String;
                     VAR dist,dist_l,beam,beam_l:REAL );
 {* m = 2 Beamrichtung *}
VAR la1,be1,la2,be2,tw,td,eang:REAL;
    targetlen,targetbri:REAL;
BEGIN
  nloc2deg(locator, targetlen,targetbri);
  la1:=targetlen/180*pi;be1:=targetbri/180*pi;
  nloc2deg(target, targetlen,targetbri);
  la2:=targetlen/180*pi;be2:=targetbri/180*pi;
  eang:=Arccos(Sin(be1)*Sin(be2)+Cos(be1)*Cos(be2)*Cos(Abs(la1-la2)));
  td:=40009/(2*pi)*eang;
  tw:=Arccos((Sin(be2)-Sin(be1)*Cos(eang))/(Cos(be1)*Sin(eang)))*180/pi;
  IF Sin(la2-la1)<0 THEN tw:=360-tw;
  dist := td;
  dist_l := 40009-dist;
  beam := Round(tw);
  IF tw>179 THEN tw:=tw-180
            ELSE tw:=tw+180;
  beam_l := Round(tw);
END;



PROCEDURE CompQTH(pCB: TP_AXCB; VAR sArg1,sArg2 : String); {* von cmQTH aufgerufen *}
  VAR sFehler : String;

  FUNCTION Normalisiere ( sArg : String;
                          VAR sALoc,sNLoc : String;
                          VAR l,b : REAL ) : BOOLEAN;
    LABEL l_eop;
  BEGIN
  Normalisiere := FALSE;
  Upper(sArg); Trim(sArg);  {* Loc krzen, da event. alter Loc *}

  {* Berechnungen zum angegebenen 1. Locator *}
  IF Length(sArg)=6 THEN BEGIN {* es ist ein Maydenhead-Loc. *}
                         IF NOT N_loc_check (sArg) THEN
                           BEGIN
                           sFehler := sArg+' ist kein gueltiger Neu-Locator';
                           GOTO l_eop; {* Ja, sowas verwende ich auch... *}
                           END;
                         sNLoc := sArg;
                         nloc2deg(sArg, l,b);
                         sALoc := Grad2aloc(l,b);
                         END
  ELSE IF Length(sArg)=5 THEN BEGIN {* es ist ein alter Locator *}
                         IF NOT ALocCheck (sArg) THEN
                           BEGIN
                           sFehler := sArg+' ist kein gueltiger QTH-Locator';
                           GOTO l_eop; {* Ja, sowas verwende ich auch... *}
                           END;
                         sALoc:= sArg;
                         Aloc2deg(sArg, l,b);
                         sNLoc:=Grad2nloc(l,b);
                         END
  ELSE IF StrGrad2Real( sArg, b,l ) THEN BEGIN
                         sNLoc:=Grad2nloc(l,b);
                         sALoc:=Grad2aloc(l,b);
                         END
  ELSE BEGIN
       sFehler := 'Formatangabe nicht erkannt';
       GOTO l_eop; {* Ja, sowas verwende ich auch... *}
       END;
  Normalisiere := TRUE;
  l_eop:
END;

LABEL l_eop;
VAR y_ang1,y_ang2,
    m_ang1,m_ang2,
    sALoc1,sALoc2 : String;
    sNLoc1,sNLoc2 : String{[20]};
    l1,b1,
    l2,b2,
    dist,dist_l,
    angle,angle_l : REAL;
BEGIN;
  sFehler := '';
 {* my_loc = Digi-Locator; sNLoc2 wird verwendet als Ziel-Loc, wenn 2 Loc's angegeben sind *}
  IF sArg2 = '' THEN sArg2:=myQTH;

  IF NOT Normalisiere ( sArg1, sALoc1, sNLoc1, l1,b1 ) THEN GOTO l_eop;
  IF NOT Normalisiere ( sArg2, sALoc2, sNLoc2, l2,b2 ) THEN GOTO l_eop;

  m_ang1:=deg2str(1,l2);  m_ang2:=deg2str(2,b2);
  y_ang1:=deg2str(1,l1);  y_ang2:=deg2str(2,b1);

  ComTarget( sNLoc1,sNLoc2, dist,dist_l,angle,angle_l);
  IF (dist=0.0) AND (angle=90) THEN angle := 0;

  TX_Info (pCB, SPAETER,EOL+'   Ihr QTH: '+y_ang1+' '+y_ang2+' -> '+sNLoc1+'  '+sALoc1+EOL);
  IF sNLoc2=myQTH THEN TX_Info (pCB, SPAETER,'  Digi')
                  ELSE TX_Info (pCB, SPAETER,'  Ziel');
  TX_Info (pCB, SPAETER,
            ' QTH: '+m_ang1+' '+m_ang2+' -> '+sNLoc2+'  '+sALoc2+EOL
           +'Entfernung: '+F_UsingReal(dist ,   7,2)+' km'+EOL
           +'  Richtung: '+F_UsingReal(angle,   7,2)+' Grad'+EOL
           +'  Longpath: '+F_UsingReal(angle_l, 7,2)+' Grad'+EOL
           );
l_eop:
  IF sFehler <> '' THEN TX_EOLSysInfo (pCB, SPAETER,sFehler);
END;


{}

END.