UNIT FD_PROM;
{* EEPROM Routinen fr den 'kleinen' EEPROM wie er im Original
 * FALCon/TNC4 drin ist. Fr den 'groen' EERPOM (der auf der huckepack-
 * Platine) siehe FD_24c65.pas.
 * Aktualisiert gleichzeitig die Checksumme. s.a.ct 12/92 S.230
 *}

{$I FD_INCL.pas}
{$IFnDEF scc}{$O+,F+}{$ENDIF}

INTERFACE

USES FD_Def;


CONST EEMAXIFACE = 6;
      FD_PROM_VERSION = 3; {* muss bei nderungen von Strukturen gendert werden        *}
                   {* Die CRC-Routine kann nmlich nicht typgeprft anspeichern *}
TYPE T_EEPROM_PORT = RECORD {* Daten eines Kanals *}
                       fValid   : BOOLEAN;
                   {    driver   : T_dTyp; }
                       xloknr   : Byte; {* aus bind[] *}
                       minMaxSSID : BYTE;
                       BaudSdUi : BYTE; {* simpdup:2; UIMODE:2 *}
                       l2digitxd: BYTE; {* L2Digion:1;  txd:7 *}
                       PttNrzi   : Byte; {* ptt:2  nrzi:1 *}
                       xDwait    : Byte;
                       xclk      : BYTE;
                       xretry    : BYTE;
                       xt1       : WORD;
                       xMap      : BYTE;
                       xCall     : T_ShCall;
                     END;
     T_EEPROM_INNERDAT = RECORD
                          Ver   : Byte;
                          fRouteUnknown : BOOLEAN;
                          ch : ARRAY [1..EEMAXIFACE] OF T_EEPROM_PORT; {* nur zur einfacheren Deklaration verwendet *}
                         END;
     T_EEPROM_DAT = RECORD {* Hier DRFEN KEINE weiteren Felder zu !, alles weitere nach innerdat ! *}
                      Dat   : T_EEPROM_INNERDAT;
                      Dummy : ARRAY [sizeof(T_EEPROM_INNERDAT)+1..128-2] OF BYTE;
                      CRC   : WORD; {* Wird nie direkt angesprochen ! *}
                    END;
TYPE tc=array[1..sizeof(T_EEPROM_DAT)] OF Byte;

  VAR EEPROM_DAT : T_EEPROM_DAT;

TYPE T_CRC=(MITCRC,OHNECRC);
PROCEDURE Write_EEPROM (MitMakeCRC:t_crc);
 FUNCTION Read_EEPROM        : BOOLEAN;
 FUNCTION RestartEEPROM_Read : BOOLEAN;
 FUNCTION UpdateEEPROM       : BOOLEAN;
PROCEDURE MakeEEPROMInvalid;

{}

IMPLEMENTATION

USES fd_div,
     fd_tx,
     FD_KISS,
     {$IFDEF SCC} fd_TNC, {* Portena *}
                  fd_scc  {* FSCC_Init *}
     {$ELSE}	  fd_crt
     {$ENDIF}
     ;


CONST POLYNOM = $8024;
PROCEDURE make_crc ( cptr: TP_BYTE; clen : WORD );
{* Checksummenfunktionen von DG3DBI *}
{* make_crc aktualisiert die Checksumme des bergebenen Blocks    *}
{* Die Prfsumme besteht aus einem Wort, das als letztes im Block *}
{* steht.							  *}
  VAR akt_crc,
      akt_char,
      count : WORD;
BEGIN
akt_crc := $FFFF;
  WHILE (clen >2) DO
    BEGIN
    Dec(cLen);
    akt_char := cptr^ SHL 8;
    Inc ( Word (cPtr) );
    FOR count := 8 DOWNTO 1 DO
      BEGIN
      IF (((akt_char XOR akt_crc) AND $8000) <>0 )
        THEN akt_crc := (akt_crc SHL 1) XOR POLYNOM
        ELSE akt_crc := akt_crc SHL 1;
      akt_char := akt_Char SHL 1;
      END;
    END; {* while *}
  cptr^ := akt_crc SHR 8; {* CRC low setzen *}
  Inc (Word(cPtr));
  cptr^ := akt_crc AND 255;
END; {* make_crc *}


FUNCTION Check_crc( cptr: tp_Byte; clen : WORD ) : BOOLEAN;
{* Check_crc berprft die Checksumme ber den bergebenen Block   *}
  VAR akt_crc,
      akt_char,
      count : WORD;
BEGIN
  akt_crc := $FFFF;
  WHILE (clen > 0 ) DO
    BEGIN
    Dec(cLen);
    akt_char := cptr^ SHL 8;
    Inc (word(cptr));
    FOR count := 8 DOWNTO 1 DO
      BEGIN
      IF (((akt_char XOR akt_crc) AND $8000)<>0)
        THEN akt_crc := (akt_crc SHL 1) XOR POLYNOM
        ELSE akt_crc :=  akt_crc SHL 1;
      akt_char := akt_char SHL 1;
      END;
    END; {* while *}
  Check_crc := ((akt_crc AND $FFFF) = 0);
  Dec(word(cptr),3);
END; {* check_crc *}

{}

{$IFDEF scc}
PROCEDURE _EE_CS_ON; ASSEMBLER;
ASM
  lahf;
  or   ah,2;
  sahf            {* /IBRK auf 1 *}
  IN   al, $ff
  lahf
  and  ah,0FDh;
  sahf            {* /IBRK auf 0 *}
END;
PROCEDURE EE_CS_ON;
BEGIN
 _Portena;
 IF port [$FF]=0 THEN;
 _Portdis;
END;

PROCEDURE EE_CS_OFF;
BEGIN
 _Portena;
 IF port [$DF]=0 THEN;
 _Portdis;
END;

PROCEDURE EE_CLK;
{* EEPROM takten *}
BEGIN
  p0 := p0 XOR CLKBIT;
  p0 := p0 XOR CLKBIT;
END;


PROCEDURE Serial_out( wert, anzahl : WORD );
  {* Kommando an seriellen Bus ausgeben *}
BEGIN
  pm0_Write ( pm0_Read AND (NOT (DATBIT + CLKBIT)) );  {* Clock + Datenleitung sind Ausgang *}
  wert := wert SHL (16 - anzahl); {* Bits an korrekte Position *}
  WHILE (anzahl<>0) DO
    BEGIN {* Bitweise ausgeben *}
    Dec(anzahl);
    IF (wert AND $8000) <> 0 THEN p0 := p0 OR DATBIT
			     ELSE p0 := p0 AND (NOT DATBIT); {* Bit ausgeben *}
    EE_CLK;              {* Clock ausgeben *}
    wert := Wert SHL 1;  {* ein Bit weiter *}
    END; {* Bitweise ausgeben *}
END; {* Serial_out *}
{$ENDIF}

{************************* EEPROM lesen und schreiben **********************}
{* Bei der PC_Version wird der EEPROM durch die Datei EEPROM.DAT simuliert *}

FUNCTION Read_EEPROM : BOOLEAN;
 VAR i, ii   : INTEGER;
     eep     : ^BYTE;
     inword  : WORD;
{$IFnDEF scc}
     f       : FILE OF T_EEPROM_DAT;
{$ENDIF}
BEGIN
  Read_EEPROM := FALSE;
  FillChar( Eeprom_dat, sizeof(Eeprom_dat), #42);
{$IFnDEF SCC} {$I-}
  ASSIGN (f,'EEPROM.DAT');
  Reset (f);
  IF IOResult=0 THEN
    BEGIN   {* Bei Diskfehlern wird der CRC-Check zuschlagen *}
    {$I+ Es folgen ja keine Abfragen von IOResult mehr *}
    Read (f,Eeprom_dat);
    Close(f);
    END;
{$ELSE}
  pm0_Write (pm0_Read AND (NOT (CLKBIT+DATBIT) )); {* Ausgnge setzen *}
  eep := Pointer(@eeprom_dat);
  FOR ii := 0 TO sizeof(eeprom_dat)-1 DO
    BEGIN  {* ein Byte lesen *}
    IF ((ii AND 1) = 0)
      THEN BEGIN  {* Lesebefehl geben *}
	   EE_CS_OFF;      {* Chip Select aus *}
	   p0 := p0 AND (NOT CLKBIT); {* Clock auf 0 *}
	   EE_CS_ON; {* Chip Select ein *}
	   Serial_out( $180 OR ((ii SHR 1) AND $3F), 9); {* READ: Ab Adresse ii lesen *}
           pm0_Write (pm0_Read OR DATBIT);   {* Port nun Eingang *}
	   inword := 0;              {* wei auch nicht warum mu *}
	   FOR i := 16 DOWNTO 1 DO
	     BEGIN {* Bitweise lesen *}
	     inword := inWord SHL 1; {* Bit schieben *}
       	     p0 := p0 XOR CLKBIT;  {* Clock wechseln *}
	     IF ((p0 AND DATBIT) <> 0) THEN inword := INWORD OR 1;  {* ist 1 *}
	     p0 := p0 XOR CLKBIT; {* Clock wechseln *}
	     END; {* Bitweise lesen *}
	   eep^  := inword AND $FF; {* Low Byte *}
	   END
      ELSE BEGIN
	   eep^  := (inword SHR 8); {* Low Byte *}
	   END;
    Inc (Word(eep));
    END; {* ein Byte lesen *}
  EE_CS_OFF; {* Chip Select aus *}
{$ENDIF}
  Read_EEPROM := CHECK_CRC( Pointer(@EEPROM_DAT), SizeOf(EEPROM_DAT) );
END; {* read_eeprom *}



PROCEDURE Write_EEPROM (MitMakeCRC:t_crc);
  VAR   i,ii    : INTEGER;
	eep     : ^WORD;
	outword : WORD;
       {$IFnDEF scc}  f : FILE OF T_EEPROM_DAT; {$ENDIF}
BEGIN
  Watchdog; {* wegen langer Wartezeiten *}
  IF MitMakeCRC=MITCRC THEN Make_CRC( Pointer(@EEPROM_DAT), SizeOf(EEPROM_DAT) );
{$IFnDEF SCC} {$I+}
  ASSIGN (f,'EEPROM.DAT');
  ReWrite (f);
  Write (f,Eeprom_dat);
  Close (F);
{$ELSE}
  Watchdog; {* wegen langer Wartezeiten *}
  pm0_Write (pm0_Read AND (NOT(CLKBIT+DATBIT))); {* Ausgnge setzen *}
  EE_CS_OFF;      			 {* Chip Select aus *}
  p0 := p0 AND (NOT CLKBIT); 		 {* Clock auf 0     *}
  EE_CS_ON;           {* Chip Select ein *}
  Serial_out($130,9); {* EWEN: Write Enable    *}
  EE_CS_OFF;          {* Chip Select aus *}
  EE_CS_ON;           {* Chip Select ein *}
  ii := 0;
  eep := Pointer(@eeprom_dat);
  WHILE ( ii < sizeof(eeprom_dat) ) DO
    BEGIN  {* ein Wort schreiben *}
    outword := eep^;
    Inc( Word(eep),2 );   {* erstes Byte ist Low *}
    EE_CS_ON; 	          {* Chip Select ein *}
    Serial_out( $140 OR ((ii SHR 1) AND $3F),9); {* WRITE: Kommando + Adresse *}
    FOR i := 16 DOWNTO 1 DO
      BEGIN {* Bitweise schreiben *}
      IF (outword AND $8000) <> 0 THEN p0 := p0 OR DATBIT
         			  ELSE p0 := p0 AND (NOT DATBIT);
      outword := outword SHL 1; {* Bit weiter *}
      EE_CLK;                   {* Bit ausgeben *}
      END;                      {* Bitweise schreiben *}
    p0 := p0 AND (NOT DATBIT); {* Daten auf 0 *}
    EE_CS_OFF;               {* Select aus  *}
    outword := outword;      {* kurz warten *}
    EE_CS_ON;                {* Check ein   *}
    pm0_Write (pm0_Read OR DATBIT);     {* Port nun Eingang *}
    WHILE ((p0 AND DATBIT) = 0) DO EE_CLK; {* EEPROM busy *}
    EE_CS_OFF; 		     {* Wieder aus *}
    Inc (ii,2);
    END;                   {* ein Wort schreiben *}
  EE_CS_ON; 		   {* Chip Select ein *}
  Serial_out($100,9);    {* Write Disable *}
  EE_CS_OFF;             {* Chip Select aus *}
  Watchdog;
{$ENDIF}
END; {* Write_EEPROM *}

{}
CONST maxBAUDTAB=9;
      baudtab : ARRAY [0..maxBAUDTAB] OF longint = (300,2400,1200,4800,9600,14400,19200,38400,76800,115200);

PROCEDURE Iface2EEPROM(ifnr : BYTE);
  VAR bZwisp, i : BYTE;
BEGIN
{$IFDEF sdfjsldfsdf    $TODO:z }
IF ifnr > EEMAXIFACE THEN EXit;
 WITH scciface[ifnr] DO with axiface[ifnr] do
   BEGIN
   bZwisp := 2; {* Defaultwert: 1200 *}
   FOR i := 0 TO maxBAUDTAB DO IF baud = baudtab[i] THEN bZwisp := i;
   WITH EEPROM_DAT.Dat.ch[ifnr] DO
    BEGIN
    fvalid := valid;
    driver := bind[ifnr].dTyp ;
    xlokNr := bind[ifnr].lokNr;

    BaudSdUi :=  (bZwisp AND $0F)
              OR (Ord(simpDup) SHL 4)
              OR (Ord(UImode)  SHL (4+2)); {* Baud:4 simpdup:2 UIMODE:2 *}
    l2digitxd := (TXD AND $7F) OR (ORD (l2DigiOn) * $80);
    minmaxssid := (minSSID AND $0f) OR ((maxSSID AND $0f) SHL 4);
    PttNrzi:= ord(Nrzi_mode) OR (ord(Ptt_mode) SHL 1);

    xDwait := DWait;
    xClk   := clk_reg;
    xt1    := t1_init;
    xretry := retry_init;
    xMap   := Mapifnr;
    xCall  := Call;
    END;
  END;
{$ENDIF}
END;

FUNCTION EEPROM2IFACE(ifnr : BYTE):BOOLEAN;
  VAR bZwisp : BYTE;
      lZwisp : Longint;
BEGIN
EEPROM2IFACE := FALSE;
IF ifnr > EEMAXIFACE THEN EXit;
{$IFDEF sdfjsldfsdf    $TODO:z }
WITH scciface[ifnr] DO with axiface[ifnr] do
  BEGIN
  WITH EEPROM_DAT.Dat.ch[ifnr] DO
  IF NOT fValid
   THEN BEGIN {* PORTSTOP durchfhren *}
        {iface[ifnr].Valid := FALSE;}
        END
   ELSE BEGIN
        IF (bind[ifnr].dTyp <> driver) AND bind[ifnr].valid THEN
          bind[ifnr].fnDeInitCh(ifnr); {* Falls auf dem Port ein anderer Kanal lag, muss er ausgeschaltet werden *}
        bind[ifnr].dTyp := driver;
        bind[ifnr].lokNr := xlokNr;

        Baud := baudtab[(BaudSdUi AND $0F)];
        SimpDup := (BaudSdUi SHR 4) AND 3;
        UIMode := T_UIMODE((BaudSdUi SHR 6) AND 3);

        txd := (l2digitxd AND $7F);
        l2DigiOn := (l2digitxd SHR 7) = 1;
        minSSID := MinMaxSSID AND $0F;
        maxSSID := MinMaxSSID SHR 4;

        byte(Nrzi_mode) := PttNrzi AND 1;
        byte(Ptt_Mode) := (PttNrzi SHR 1) AND 3;

        dwait := xDwait;
        Clk_reg := xclk;
        t1_init := xt1;
        retry_init := xretry;
        Mapifnr := xMap;
        Call := xCall;

        EEPROM2IFACE := TRUE;
    END;
  END;
{$ENDIF}
END;

{}

FUNCTION RestartEEPROM_Read : BOOLEAN;
  VAR i : BYTE;
      liResult : LongInt;
BEGIN
  RestartEEPROM_Read := FALSE;
exit;
  IF Read_EEPROM THEN
    BEGIN
    WriteLn ('- EEPROM Ver.: ',EEPROM_DAT.dat.ver);
    IF EEPROM_DAT.dat.ver = FD_PROM_VERSION THEN
      BEGIN
      RestartEEPROM_Read := TRUE;
      use[iusRouteUnknown] := EEPROM_DAT.dat.fRouteUnknown;
      FOR i := 1 TO EEMAXIFACE DO
        BEGIN
        IF EEPROM2IFACE(i) THEN
          BEGIN {* Treiber nochmal Initialisieren *}
          {ASE bind[i].dTyp OF
            {dLOOPBACK : iface [i].Valid := LOOP_Init (i, bind[i].loknr);}
            {dFISS     : iface [i].Valid := FISS_Init (i, bind[i].loknr);}

            {$IFnDEF scc}
               {dKIFF     : iface [i].Valid := KIFF_Init (i, bind[i].loknr);}
            {$ELSE}
              {dFSCC     : iface [i].Valid := FSCC_Init (i, bind[i].loknr); }
            {$ENDIF}
{           END; {* Case *}
{         bind[i].valid := bind[i].fnInitCh(i);}
{         liResult := bind[i].fnSetPara ( i, spREINIT, 0 );}
          Write ('- EEPROM PortData '+FStr(i));
          IF liResult = 0
            THEN WriteLn(' - OK')
            ELSE WriteLn(' - Error '+fStr(liResult));
          END;
        END;
      END;
    END;
END;


FUNCTION UpdateEEPROM : BOOLEAN;
  VAR i : BYTE;
BEGIN
  UpdateEEPROM := FALSE;
  FOR i := 1 TO MAX_IFACE DO IFACE2EEPROM(i);
  EEPROM_DAT.dat.ver := FD_PROM_VERSION;
  EEPROM_DAT.dat.fRouteUnknown := use[iusRouteUnknown];
  Write_EEPROM(MITCRC);
  UpdateEEPROM := TRUE;
END;


PROCEDURE MakeEEPROMInvalid;
  {* CRC ungltig machen *}
BEGIN
  IF Read_EEPROM THEN
    BEGIN
    EEPROM_DAT.crc := EEPROM_DAT.crc XOR 1; {* Irgendein Bit kippen,damit CRC ungltig wird *}
    Write_EEPROM(OHNECRC);
    END;
END;


{* Kein Init *}
END.
