UNIT FD_PKTDR;
{* A fast hack, only capable of receiving ax25 frames from BAYCOM *}

{$I FD_INCL.PAS}
{$IFDEF scc} ### Nix da - FALCon-Hardware kann das nicht {$ENDIF}

{$IFDEF VER70} {$C FIXED PERMANENT PRELOAD} {$ENDIF}

INTERFACE

USES FD_Def;


{}
IMPLEMENTATION

USES  FD_Div,
      FD_Subr,
      FD_Mem,
      FD_Sysop,
      FD_CRT, DOS;


{/* Packet driver interface classes */}
 CONST  CL_NONE 	=0;
 CONST  CL_ETHERNET	=1;
 CONST  CL_PRONET_10	=2;
 CONST  CL_IEEE8025	=3;
 CONST  CL_OMNINET	=4;
 CONST  CL_APPLETALK	=5;
 CONST  CL_SERIAL_LINE	=6;
 CONST  CL_STARLAN	=7;
 CONST  CL_ARCNET	=8;
 CONST  CL_AX25 	=9;
 CONST  CL_KISS 	=10;
 CONST  CL_IEEE8023	=11;
 CONST  CL_FDDI 	=12;
 CONST  CL_INTERNET_X25 =13;
 CONST  CL_LANSTAR	=14;
 CONST  CL_SLFP 	=15;
 CONST  CL_NETROM	=16;
 CONST  NCLASS		=17;

{/* Packet driver interface types (not a complete list) */}
 CONST TC500=  $1;
 CONST PC2000= $10;
 CONST WD8003= $14;
 CONST PC8250= $15;
       ne2000= 54;
 CONST ANYTYPE=$ffff;

TYPE T_HANDLE = WORD;
CONST nNoBuffer : WORD = 0;
      MAXLEN=500;
VAR   PKTDRifNr: t_ifnr;
      PKTDRint : BYTE;
      PKTDRhnd : T_HANDLE;
      ExitSave : Pointer;
      pktBuffer : ARRAY [1..MAXLEN] OF Char;
      pNeuBuf : tp_mbuF;
      len : WORD;
      rax,rcx,rdi,res : WORD;


FUNCTION PktDrvrFound (intnr : BYTE) : BOOLEAN;
  TYPE Str9=String[9];
  CONST cPktDrvID :STRING[9] = 'PKT DRVR'+#0;
  VAR p : POINTER;
BEGIN
  PKTDrvrFound := FALSE;
  GetIntVec( intNr, p );
  IF p = nil THEN Exit;
  Inc (word(p),3);
  PKTDrvrFound := MemEq( @cPktDrvID[1], p, 9);
END;


FUNCTION PktDrvInfo( intNr:BYTE ):BYTE;
  VAR r : REGISTERS;
      p : POINTER;
BEGIN
PktDrvInfo := 0;
  r.ah := 1; r.al := 255;
  r.bx := 0;
  Intr(IntNr,r);
  IF (r.flags AND FCARRY) <> 0
    THEN WriteLn('GetInfo: Error')
    ELSE BEGIN
         Write('- PktDRV IntNr:',intNr,'  ');
         p := Ptr(r.ds,r.si);
         WHILE char(p^)<>#0 DO
           BEGIN
           Write(char(p^));
           Inc(Word(p));
           END;
         Writeln(' Ver.',r.bx);
         Writeln('Class:',r.CH,'  Type:',r.dx,
                 '   Number:',r.cl,'  Funkt.:',r.al);
         PktDrvInfo := r.ch;
         END;
END;


{$R-,S-}  {* Ansonsten stimmt AX am Anfang nicht mehr *}
PROCEDURE RxIsr; FAR;
BEGIN
  ASM
    push ds
    push ax
    mov  ax,seg @Data
    mov  ds,ax
    pop  ax
    mov  rax,ax
    mov  rcx,cx
  END;
  IF rax = 0
    THEN BEGIN  {* Erster Aufruf: Hole buffer *}
         len := rcx;
                res := seg(pktBuffer);
                rdi := ofs(pktBuffer);
           {ELSE BEGIN
                res := 0;
                rdi := 0;
                END;}
         ASM
         mov  es,res
         mov  di,rdi
         END;
         END
    ELSE BEGIN {* Paket ist da *}
         _DI;
         IF L1RxBufAvail THEN
           BEGIN {* Buffer noch frei *}
           {* Neuen Buffer allokieren *}
           pNeuBuf := GetL1Rxbuf;
           _EI;
           {* kopieren des Pakets *}
           Move ( pktBuffer[1], pNeuBuf^.pData^, len );
           pNeuBuf^.inUse := len;
           pNeuBuf^.ifnr := PKTDRifNr; (* INTERFACE *)
           pNeuBuf^.ofsCtl := CalcOfsCtl(pNeuBuf);
           pNeuBuf^.time := fasttick;
           pNeuBuf^.next := NiL;
           {* Einhngen in RXQueue *}
           _DI;
           IF lstRxInUse.Root <> NiL THEN lstRxInUse.Tail^.next := pNeuBuf (* anhngen *)
   	                             ELSE lstRxInUse.Root := pNeuBuf; (* nur setzen *)
           lstRxInUse.Tail := pNeuBuf;
           END;
         _EI;
nosound;
         END;
  ASM
  POP DS
  END;
END;



    Var  buffer : array[1..100] of char;
FUNCTION PktDrvAccessType( intNr:BYTE; class:byte;typ:WORD;number:BYTE ) : T_HANDLE;
  VAR r : REGISTERS;
      p : POINTER;
BEGIN
  PktDrvAccessType := $FFFF; {* Fehler annehmen *}
  r.ah := 2;
  r.al := class;
  r.bx := typ;
  r.dl := number;
  r.cx := 0;
  r.ds := seg(buffer);
  r.si := ofs(buffer);
  r.es := seg(rxisr);
  r.di := ofs(rxisr);
  Intr(IntNr,r);
  IF (r.flags AND FCARRY) <> 0
    THEN WriteLn('Access: Error:', r.dh)
    ELSE BEGIN
         WriteLn('Handle: ',r.ax);
         PktDrvAccessType := r.ax; {* Fehler annehmen *}
         END;
END;

PROCEDURE PktDrvReleaseType( intNr:BYTE; handle:T_HANDLE );
  VAR r : REGISTERS;
BEGIN
  r.ah := 3;
  r.bx := handle;
  Intr(IntNr,r);
  IF (r.flags AND FCARRY) <> 0
    THEN WriteLn('- Release: Error:', r.dh)
    ELSE WriteLn('Release: ok');
END;

PROCEDURE PktDrvSendPkt( intNr:BYTE; buffer:pointer; len : WORD );
  VAR r : REGISTERS;
      p : POINTER;
BEGIN
  r.ah := 4;
  r.ds := seg(buffer^);
  r.si := ofs(buffer^);
  r.cx := len;
  Intr(IntNr,r);
  IF (r.flags AND FCARRY) <> 0
    THEN WriteLn('Send: Error ',r.dh)
    ELSE BEGIN
         END;
END;


{$F+}
PROCEDURE PKTDRExit; {$F-}
BEGIN
  WriteLn;
  PktDrvReleaseType( PKTDRint, PKTDRhnd);
  exitProc := ExitSave;
END;


PROCEDURE PKTDR_Init ( devNr : Byte );
  VAR i,class : BYTE;
BEGIN
  IF devNr <>1 THEN Exit;
  PKTDRhnd := $FFFF;
  FOR i := $60 TO $80 DO
    IF PktDrvrFound ( i ) THEN
      BEGIN
      class := PktDrvInfo( i );
      IF PKTDRhnd = $FFFF THEN
        BEGIN
        PKTDRint := i;
        PKTDRhnd := PktDrvAccessType( i, class, $FFFF, 0 );
        END;
      END;
  IF PKTDRhnd <> $FFFF
    THEN BEGIN
         ExitSave := exitProc;
         exitProc := @pktDrExit;
         PKTDRifNr := devNr;
         END
    ELSE Writeln('- Kein PktDrv gefunden');
noSound;
END;


PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'INIT ';
        cmINIT=1;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   x : BYTE;
        para : Longint;
BEGIN
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : PKTDR_Init(devNr);
      END {Case}
  UNTIL x=0;
END;


CONST sReturn : STRING='';
{$F+}
FUNCTION PKTDRV_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT; far;
  TYPE T_PSTRING = ^STRING;
  VAR  loknr : BYTE;
BEGIN
  PKTDRV_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sReturn := ''{Pakete TX/RX: '}
                 ;
        PKTDRV_SetPara := Longint(@sReturn);
        END;
    spSETZEWertIFACENr
      : BEGIN
        PKTDRifNr := wert;
        END;
    spHOLEPROC
      : BEGIN
       {IF wert = ord(hpTxPacket) THEN PKTDRV_SetPara:=Longint(@PKTDRV_TXPacket)
                                   ELSE}PKTDRV_SetPara := 0;
        END;
    ELSE {* case *} PKTDRV_SetPara := speNNCMD;
  END;
END;


BEGIN
  DoRegister('PKTDR',1,1, PKTDRV_SetPara);
END.
