UNIT FD_PCSIO;  {* Gegenstck zu FD_SCC bei SCC - Einsatz      *}
                {* SIO-Routinen der FD_Testumgebung auf dem PC *}

{$IFDEF VER70} {$C FIXED PERMANENT PRELOAD} {$ENDIF}

{...$DEFINE lokDebug   Debugroutinen (Write&Co) *}

INTERFACE

{$I FD_INCL.PAS}
{$IFDEF SCC}  ####FEHLER:  SCC darf nicht definiert sein !!!  {$ENDIF}

USES FD_Def;


{}

IMPLEMENTATION

USES Dos,
     FD_Sysop, {* wg. DoRegister *}
     FD_Div,   {* wg. _DI *}
     FD_CRT,   {* wg. LEDs *}
     FD_mBuf,
     FD_Subr   {* wg. Del_mBuf *}

 ;
 CONST cV24rxbufsize=300;
  TYPE T_Parit = (cEVEN,cODD,cNO);
       T_UARTtyp = (cKeine,c8250,c16550,c16550A);
 CONST sUARTTyp : Array [cKeine..c16550A] OF String[6] = ('','8250','16550','16550A');

  TYPE T_COM= RECORD
	       valid	   : BOOLEAN;
               UARTtyp     : t_UARTTyp;
	       BaseIO 	   : WORD;      {* Basis Adresse 8250 im PC *}
	       IRQ	   : BYTE;      {* verwendeter IRQ derselben muss <= 9 sein *}
	       IntNr	   : BYTE;      {* Soft-Int. Nr - wird automatisch errechnet *}
	       AltISR 	   : POINTER;   {* Speichert den alten ISR-Vector zwischen *}
	       sEOI	   : BYTE;      {* enthlt die EOI Anweisung fr den entsprechenden IRQ *}
	       Baud	   : Longint;
	       Databits,
	       Stopbits	   : BYTE;
	       Parity 	   : T_Parit;
               indWrite,
               indRead     : Word;
               v24rxbuf    : ARRAY [1..cV24rxbufsize] of Byte;
               nlostInt,
               nV24Int,
               nV24OverrunError,
               nV24ParityError,
               nV24FrameError,
               nV24Breaks,
               nV24RxFIFOErr: Longint;
            END;
CONST MAXCOM = 4;
VAR  aCOM : ARRAY [1..MAXCOM] OF T_COM;


CONST IntContrMaster : INTEGER = $20;
      IntContrSlave  : INTEGER = $A0;
      EOI             	 = $20;
      IRQ_Mask {: INTEGER} = $21;
      OFS_LCR = 3; {* LineControlRegister *}
      OFS_MCR = 4; {* ModemControlRegister *}
      OFS_LSR = 5; {* LineStatusRegister *}
      OFS_MSR = 6;
      OFS_IIR = 2; (* Interrupt Kennungsregister *)
      OFS_IER = 1; (* Interrupt Freigaberegister *)



FUNCTION InitPcUART ( baseport : INTEGER;
                        baud : REAL;
                        databit, stopbit : Byte;
                        parit : T_Parit  ) : T_UARTtyp;
  VAR divisor : INTEGER;
      local   : Byte;
BEGIN
  InitPcUART := cKEINE;
  IF port [baseport]=0 THEN; {*  RX Port leerlesen *}
  Divisor := ROUND (115200.0 / baud );
  Port [baseport+3] := $80;  {* LineCtrl : Bit7= 1 --> Umschaltung auf Baudratenregister *}
  Port [baseport  ] := Lo (divisor);
  Port [baseport+1] := Hi (divisor); {* BaudRate einstellen *}

  CASE databit OF
       8 : local := 3 ; { 11 }
       7 : local := 2 ; { 10 }
       6 : local := 1 ; { 01 }
      ELSE local := 0 ; { 00 }
    END ;

  IF stopbit = 2 THEN ORself(local,4); {* Bit 2 *}

  CASE parit OF
     cEven : ORself(local,$18); {*  Bit 4 setzen, Bit 3 setzen  *}
     cOdd  : ORself(local,$08); {*  Bit 4 nicht setzen, Bit 3 setzen  *}
     ELSE     		  ; {*  Bit 4 nicht setzen, Bit 3 nicht setzen  *}
    END;
  port [baseport+OFS_LCR] := local;

  {* zunchst das LSR nochmals lesen: angeblich blockiert der     *}
  {* UART, wenn das Overrunbit noch gesetzt ist:  (DL5FBD, 11/90) *}
  IF port [baseport+OFS_LSR] = 0 THEN;

  port [baseport+OFS_IER] := 1 + 4; (* Interrupt bei Empfang oder Fehler auslsen *)
  port [baseport+4] := $0b;  {* 000 0 10 11  dtr/rts setzten *}
                             {* ......^ BIT 3 sollte immer gesetzt sein; bei manchen Rechnern ist das die Interruptfreigabe *}
  IF port [baseport]=0 THEN; {*  RX Port nochmals leerlesen *}

  {* 16550A FIFO an - auf Verdacht, 8 Byte Trigger; alles Reseten. s. ct 2/92 s.190 *}
  port [baseport+OFS_IIR] := $87;
  local := port [baseport+OFS_IIR] AND $C0;
  IF      local = $80 THEN InitPcUART := c16550
  ELSE IF local = $C0 THEN InitPcUART := c16550A
  ELSE                     InitPcUART := c8250  ;
  {WriteLn ('- V24:',Baud:6:0,' Baud  IO:$',HexString(baseport));}
END;

    {$IFDEF Doku_16550}
    IIR:   Lesen:                           Schreiben:
    Bit 0   Interupt Pending                FIFO enable
        1   ID-Bit 1                        FIFO Reset receive
        2   ID-Bit 2                        FIFO Reset transmit
        3   ID-Bit 3 (FIFo-Timeout          0
            (immer nach 4 Zeichen)          0
        4   0                               0
        5   0                               0
        6   FIFO ist AN (nur 16550A ff)     TriggerLevel 0
        7   FIFO ist AN                     TriggerLevel 1
    tl1 und tl0: 0=1Byte, 1=4Byte, 2 = 8Byte, 3=14 Byte
    {$ENDIF}




{$F+}
FUNCTION ishget(nr:BYTE): Word ;
 {- gibt Anzahl Zeichen im Rx-Buffer zurck -}
BEGIN
  ishget := 0;
  WITH aCom[nr] DO
    BEGIN
    IF NOT valid then exit;
    IF indread<>indWrite THEN ishGet:=1;
    END;
END;


FUNCTION ishget1: Word ; BEGIN ishget1 := ishget(1); END;
FUNCTION ishget2: Word ; BEGIN ishget2 := ishget(2); END;
FUNCTION ishget3: Word ; BEGIN ishget3 := ishget(3); END;
FUNCTION ishget4: Word ; BEGIN ishget4 := ishget(4); END;


FUNCTION hgetc (nr:BYTE): Byte;
{- liest genau 1 Zeichen aus dem Rx-Puffer. Wenn keins drin wird daruaf gewartet -}
BEGIN
  WHILE ishget(nr)=0 DO;
  WITH aCom[nr] DO
    BEGIN
    Inc(indread);
    IF indread > cV24rxbufsize THEN indread := 1;
    hgetc := v24rxbuf [ indread ];
    {** write( v24rxbuf[indread] :4); **}
    END;
END;

FUNCTION hgetc1:BYTE; BEGIN hgetc1 := hgetc(1); END;
FUNCTION hgetc2:BYTE; BEGIN hgetc2 := hgetc(2); END;
FUNCTION hgetc3:BYTE; BEGIN hgetc3 := hgetc(3); END;
FUNCTION hgetc4:BYTE; BEGIN hgetc4 := hgetc(4); END;


FUNCTION ishput(nr:BYTE): Word;
 {- gibt Anzahl freier Zeichen im Tx-Puffer zurck -}
BEGIN
 ishput := 0;
 IF NOT aCOM[nr].valid THEN Exit;
 IF (port[aCOM[nr].BaseIO+OFS_LSR] AND $20 <> 0) THEN ishPUT := 6;
END;

FUNCTION ishput1: Word ; BEGIN ishput1 := ishput(1); END;
FUNCTION ishput2: Word ; BEGIN ishput2 := ishput(2); END;
FUNCTION ishput3: Word ; BEGIN ishput3 := ishput(3); END;
FUNCTION ishput4: Word ; BEGIN ishput4 := ishput(4); END;


PROCEDURE hputc (nr, x : Byte);
BEGIN
  IF NOT aCOM[nr].valid THEN Exit;
  WHILE (port[aCOM[nr].BaseIO+OFS_LSR] AND $20 = 0) DO;  {* waiting for a free 8250 *}
  Port [aCOM[nr].BaseIO] := x;
END;


PROCEDURE hputc1 ( x : Byte); BEGIN hputc (1,x); END;
PROCEDURE hputc2 ( x : Byte); BEGIN hputc (2,x); END;
PROCEDURE hputc3 ( x : Byte); BEGIN hputc (3,x); END;
PROCEDURE hputc4 ( x : Byte); BEGIN hputc (4,x); END;
{$F-}


PROCEDURE SendChar (loknr : Byte; c: Char);
  VAR base : WORD;
BEGIN
  IF (loknr > MAX_IFACE) THEN  Runerror;
  base := aCom[loknr].baseio;
  WHILE (port[base+OFS_LSR] AND $20 = 0) DO;  {* waiting for a free UART *}
  Port [base] := Byte (c);
END;


{$IFnDEF AllFar} {$F-} {$ENDIF}
{}


PROCEDURE SioInt_an( loknr : BYTE );
BEGIN
  Port[irq_mask] := (port [irq_mask] AND NOT (1 SHL aCom[loknr].IRQ));
  port[ aCom[loknr].BaseIO+OFS_IER ] := 4+2+1; (* Error, Tx und Rx erzeugen Interupt *)
END;


PROCEDURE SioInt_aus( loknr : BYTE );
BEGIN
  port[aCom[loknr].BaseIO+OFS_IER] := 0;
  Port[irq_mask] := (port [irq_mask] OR (1 SHL aCom[loknr].IRQ) );
END;


{ TNC Interrupt Routinen }


(********************* Sende Interrupt Routine ***********************)
PROCEDURE SendISR( comNr : BYTE );
BEGIN
END;


(********* Schnittstellenfehler ist aufgetreten **************)
{$IFnDEF AllFar} {$F-} {$ENDIF}
PROCEDURE ErrorCom( comNr : BYTE );
  VAR  err : Byte;
BEGIN (* ErrorCom *)
  WITH aCom[comNr] DO
     BEGIN (* Fehler auswerten *)
     err := port[BaseIO]; (* Dummy-RX lesen *)
     err := port[BaseIO+OFS_lsr]; (* Fehlerstatus holen *)
     IF err AND $02 <> 0 THEN Inc (nV24OverrunError);
     IF err AND $04 <> 0 THEN Inc (nV24ParityError);
     IF err AND $08 <> 0 THEN Inc (nV24FrameError);
     IF err AND $10 <> 0 THEN Inc (nV24Breaks);
     IF err AND $80 <> 0 THEN Inc (nV24RxFIFOErr);
     IF (port[BaseIO+OFS_ier] and $02) <> 0 THEN
       BEGIN {* Overrun *}
       port[BaseIO+OFS_ier] := port[BaseIO+OFS_ier] xor $02; (* Sendebit aus *)
       port[BaseIO+OFS_ier] := port[BaseIO+OFS_ier] xor $02; (* Sendebit ein *)
       END;
     END;  (* Fehler auswerten *)
  END;	(* ErrorCom *)

(*************************** Interrupt Hauptroutine ***********************)

PROCEDURE TNC_ISR(comNr:BYTE);
{$IFnDEF AllFar} {$F-} {$ENDIF}
  VAR inByte : BYTE;
BEGIN
  __STI; {* weitere Interrupts drfen *}
  WITH aCOM[comNr] DO
    BEGIN
    CASE port[BaseIO+OFS_IIR] AND $0F OF {* welcher Interupt war es denn ? *}
        $04,  {* RX-Interupt *}
        $0C : BEGIN {* Rx - Timeoutint. des 16550 *}
              REPEAT
                inByte := port[BaseIO];
                {- Vorher hochzhlen, so kann man auf 0 init. -}
                Inc(indWrite);
                IF indWrite > cV24rxbufsize THEN indWrite:= 1;
                v24rxbuf[ indWrite ] := inByte;
                { fv24[comnr] := true }
              UNTIL (Port[BaseIO+OFS_LSR] AND 1)=0; {* solange bis nix mehr im SIO drin ist *}
              END;
        $02 : SendISR(comNr);  (* Sende Interrupt ausfhren *)
        $06 : ErrorCom(comNr); (* Fehler ist aufgetreten *)
        ELSE Inc (nlostInt);
       END; (* OF CASE ber Interruptquellen *)
    port[IntContrMaster] := sEOI; (* spezielles EOI Kommando *)
    Inc(nv24Int);
    END; {*with*}
END;

(*$F+*)
PROCEDURE TNC1_ISR; interrupt; BEGIN  TNC_ISR(1); END;
PROCEDURE TNC2_ISR; interrupt; BEGIN  TNC_ISR(2); END;
PROCEDURE TNC3_ISR; interrupt; BEGIN  TNC_ISR(3); END;
PROCEDURE TNC4_ISR; interrupt; BEGIN  TNC_ISR(4); END;
{$IFnDEF AllFar} {$F-} {$ENDIF}



{}

{* TYPE T_TNCMODE = (cNOTNC,cFirmWare,cTAPR,cSMACK,cFLEXCRC,cCRC,cSLIP);
 *
 * PROCEDURE InitKiss (ifnr : t_ifnr; tncmode : T_TNCMODE);
   {* Schaltet KISS/SMACK am TNC ein *}{
 * CONST s : ARRAY [cFirmWare..cCRC] OF String[20] = (
 *           ^Q + ^X + ^X + #27 + ' @K '  + #13+#10,   {TF->KISS}{
 *           ^C+'KISS ON'+ #13 + 'RESTART'+ #13,       {TAPR}{
 *           #$c0+#$80+#$20+#$60+#$18+#$c0,            {smack}{
 *           #$c0+#$20+#$00+#$dc+#$22+#$c0,            {flexcrc}{
 *           #$c0+#$80+#$20+#$60+#$18+#$c0+            {crc}{
 *                 #$c0+#$20+#$00+#$dc+#$22+#$c0
 *           );
 *  VAR j,i : Byte;
 * BEGIN
 * FOR j := 1 TO 2 DO
 *   FOR i := 1 TO Length (s[tncmode]) DO
 *     SendChar ( ifnr, s[tncmOde][i] );
 * END;
 *}

PROCEDURE IF_TxPacket( pm : TP_Mbuf ); FAR;
  VAR i : Word;
      ifnr : T_Ifnr;
      loknr : BYTE;
      p : Pointer;
BEGIN
  ifnr := pm^.ifnr;
  loknr := ifnr;

{$IFnDEF zu_langsam} {* Mein XT schafft es einfach nicht, im Hintergrund zu senden...*}
  WITH aCom[loknr] DO
    BEGIN
    p := pm^.pData;
    FOR i := 1 TO pm^.inUse DO
      BEGIN
      SendChar (loknr, Char(p^) );
      Inc (Word(p));
      END;
    _DI;
    IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE;
    _EI;
    pm^.txed := TRANSMITTED;
    IF pm^.discard THEN Del_mBuf (pm)
		   ELSE pm^.next := Nil; (* Nicht unbedingt ntig *)
    END;
{$ELSE}
  WITH aCom[loknr] DO
     BEGIN  (* in die Sendequeue damit *)
     _DI; (* da Zeiger gebogen werden *)
     pm^.next := NIL; (* Ende der Queue *)
     IF Tx_BuffBase <> NIL THEN Tx_BuffTail^.next := pm (* anhngen *)
			   ELSE Tx_BuffBase := pm; (* nur setzen *)
     Tx_BuffTail := pm; (* und auf sich selber zeigen *)
     IF TxZustand = IDLE
       THEN BEGIN (* neu anticken *)
	    TxZustand := SEND_CMD; (* Kommando senden *)
            Port[BaseIO+OFS_IER] := 4+2+1; (* Error, Tx und Rx erzeugen Interupt *)
	    WHILE (port[BaseIO+OFS_lsr] and $60) <> $60 DO ;
	    Port[BaseIO] := FEND; (* Tx_Interupt Mechanik in Gang setzen *)
	    END
       ELSE ; {* port[BaseIO+IER] := $05 *}  (* Empfnger *)
     _EI;
     END;   (* In die Sendequeue damit *)
{$ENDIF}
END;



PROCEDURE Deinit (devnr:Byte);
BEGIN
 WITH aCom[devnr] DO  IF valid THEN
   BEGIN
   {* Erst die Interrupt-Quelle UART ausschalten (INTID:=0) *}
   SioInt_aus(devnr);   {* Interrupt aus *}
   {* 16550A FIFO aus, RX/Tx-FIFO lschen. Alles ohne zu wissen, ob es ein 550 ist: *}
   {*   port [BAseIO+OFS_IIR] := $6; }
   IF port[BaseIO] = 0 THEN;  {* Noch anstehende Daten weglesen *}
   {*   SetIntVec (IntNr, AltISR); {* Original Vector von COMn wiederhestellen *}
   END;
END;



{---------------------------------------------------------------------}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 =
        { 1}  'BAUD IRQ IOBASE BASE INIT ';
        cmBAUD=1; cmIRQ=2; cmIOBASE=3; cmBASE=4; cmINIT=5;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   x    : BYTE;
        para : Longint;
BEGIN
WITH aCom[devnr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforVal(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmBAUD    : Baud := para;
      cmBASE,
      cmIOBASE  : BaseIO := para;
      cmIRQ     : IRQ := para;
      cmINIT    : BEGIN
                  IF irq >=8 THEN Writeln ('-- V24  IRQ>=8 not supported --')
                             ELSE
                    BEGIN
                    nV24OverrunError := 0;  nV24ParityError := 0;
                    nV24FrameError   := 0;  nV24Breaks	    := 0;
                    nV24RxFIFOErr    := 0;
                    nlostInt         := 0;
                    nv24Int := 0;
                    Databits := 8;
                    Stopbits := 1;
                    Parity := cNo;
                    IF irq >=8 THEN intNr := $68 + irq    {* Irq8-->Int $70 *}
                               ELSE intNr := $08 + irq;
                    sEOI := $20; {* $60 OR (IRQ AND 7); *}
                    GetIntVec ( IntNr, AltISR );
                    IF devnr = 1 THEN SetIntVec ( IntNr, @TNC1_isr );
                    IF devnr = 2 THEN SetIntVec ( IntNr, @TNC2_isr );
                    IF devnr = 3 THEN SetIntVec ( IntNr, @TNC3_isr );
                    IF devnr = 4 THEN SetIntVec ( IntNr, @TNC4_isr );
                    uarttyp := InitPcUART(BaseIO,Baud,Databits,Stopbits,Parity);
                    SioInt_an( devnr );
                    valid := true;
                    END; {cmINIT}
                  END;
      END {Case}
  UNTIL x=0;
END;


FUNCTION PCV24_SetPara ( hwnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
BEGIN
 PCV24_SetPara := speOK;
 WITH aCOM[hwnr] do
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, hwnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sGlobReturn :=
                 fStr(Baud) + ' Baud '
               + ' I/O:'      + HexString(BaseIO)
	       + ' IRQ'       + FStr(IRQ)
	       + ' '          + sUARTTyp[uarttyp]
               + ' nLostInt:' + fStr(nlostInt)
               + ' nInt:'     + fStr(nV24Int)
               + ' nOvrn:'    + fStr(nV24OverrunError)
               ;
        PCV24_SetPara := Longint(@sGlobReturn);
        END;
    spDEinit
     : DeInit(hwnr);
    spHOLEPROC :
        BEGIN
        CASE wert OF
           ord(hpRX1CHAR) : case hwnr of
                             1 :  PCV24_SetPara := Longint(@hgetc1);
                             2 :  PCV24_SetPara := Longint(@hgetc2);
                             3 :  PCV24_SetPara := Longint(@hgetc3);
                             4 :  PCV24_SetPara := Longint(@hgetc4);
                             END;
           ord(hpNRXCHAR) : CASE  hwnr of
                             1 :  PCV24_SetPara := Longint(@ishget1);
                             2 :  PCV24_SetPara := Longint(@ishget2);
                             3 :  PCV24_SetPara := Longint(@ishget3);
                             4 :  PCV24_SetPara := Longint(@ishget4);
                             END;
           ord(hpTX1CHAR) : case hwnr of
                             1 :  PCV24_SetPara := Longint(@hputc1);
                             2 :  PCV24_SetPara := Longint(@hputc2);
                             3 :  PCV24_SetPara := Longint(@hputc3);
                             4 :  PCV24_SetPara := Longint(@hputc4);
                             END;
           ord(hpNTXCHAR) : CASE  hwnr of
                             1 :  PCV24_SetPara := Longint(@ishput1);
                             2 :  PCV24_SetPara := Longint(@ishput2);
                             3 :  PCV24_SetPara := Longint(@ishput3);
                             4 :  PCV24_SetPara := Longint(@ishput4);
                             END;
           ord(hpLED) : PCV24_SetPara := Longint(@SwitchStaLed); {in FD_CRT}
           END;
        END;
    ELSE {* case *} PCV24_SetPara := speNNCMD;
  END;
END;


BEGIN
  FillChar( aCOM, SizeOF(aCOM), #0 );
  DoRegister('V24', 1,MAXCOM, PCv24_SetPara);
END.

