UNIT FD_NetROM;

{$I FD_INCL.PAS}
{$IFNDEF scc} {$O+,F+} {$ENDIF}

INTERFACE

USES fd_def;


CONST  DECQUALI = 25;  {* Alle 5 Minuten reduziert sich die Qualitt *}
       OBSOQUALI = 40; {* Alles was darunter ist, wird ignoriert/gelscht *}

CONST  nNRTbl = 65;
TYPE   T_NR = RECORD
                 Valid   : BOOLEAN;  {* Eintrag gltig *}
		 ifnr    : T_IfNr;   {* Wo wurde der BC gehrt *}
		 Ident   : Str6;
		 Ziel,               {* Zielrufzeichen *}
		 Nachbar,            {* Der hat den Broadcast ausgestrahlt *}
		 via     : T_shCall;
		 qualit	 : BYTE;     {* Qualitt: 255=Optimal *}
	       END;
       T_NRTbl = ARRAY [1..nNRTbl] OF T_NR;

VAR  NRTbl : T_NRTbl;



PROCEDURE DoEvery5MinuteNetRom;
{FUNCTION NR_SucheRoute ( t : String ) : WORD; }

PROCEDURE NR_RxBroadcast ( pm : tp_mBuf );
PROCEDURE DoListNodes (pCB:tp_axcb; sArg : STRING );

 FUNCTION DoConnect_NR (pCB : TP_AXCB; t : STRING ) : BOOLEAN;
PROCEDURE ManTryToConnectViaNr (  ifnr : T_IFNR; f,t,v,nrEinstieg : String );

{}

IMPLEMENTATION


USES fd_subr,
     fd_div,
     FD_Main,
     fd_ar,
     fd_info,
     fd_circ,
     fd_state,  {* defaultmsghandler *}
     fd_tx,
     {$IFDEF SCC} fd_TNC,
     {$ELSE}      fd_crt,
     {$ENDIF}
     fd_timer,
     fd_Mem;


CONST routesAreSorted : (notSorted,sortZiel,sortIdent,sortQuali) = sortZiel;

{}

FUNCTION NR_SucheRoute ( t : String ) : WORD;
 {* gibt den Index der besten Route nach T *}
 {* zurck, 0 wenn keine Route vorhanden   *}
  VAR shT      : t_shCall;
      i, iBest : WORD;
      bestQ    : BYTE;
BEGIN
  WatchDog;
  AscCall2shift(t,shT);
  iBest := 0; bestQ := 0;
  FOR i := 1 TO nNRTbl DO WITH NRTbl[i] DO IF Valid THEN
    IF MemEq(@shT,@Ziel,6) AND (qualit > bestQ) THEN
      BEGIN
      iBest := i;
      bestQ := qualit;
      END;
  NR_SucheRoute := iBest;
END;


PROCEDURE NR_RxBroadcast ( pm : tp_mBuf );
  VAR i,quali	: BYTE;
      ZielCall,
      viaCall,
      NachBarCall : t_shCall;
      IdentCall	: str6;

   PROCEDURE DoTheNetRout;  {* Routtabelle fllen: quick&dirty *}
      {* Implizite Parameter: *}
      {*  (ZielCall,From^Call : T_shCall; frameZeit : LongInt; q : BYTE); *}
	VAR i,j     : BYTE;
	    miesest : BYTE;
	    iMiesest : BYTE;
      BEGIN
      {* hier Calls einer Plausi unterziehen *}
      FOR i := 1 TO nNRTbl DO WITH NRTbl[i] DO
       IF valid THEN
	 IF (ZielCall = Ziel) THEN
	   IF (NachbarCall = Nachbar) THEN
	     BEGIN {* vom akt. Nachbarn liegt schon ein Eintrag vor - aktualisierenn! *}
	     via := viaCall;
	     qualit := quali;
             IF quali < OBSOQUALI THEN Valid := FALSE; {* bah! Ausschuss - sofort lschen *}
             EXIT; {******}
	     END;

      IF quali < OBSOQUALI THEN Exit; {* bah ! Ausschuss - Tragen wir nicht neu ein *}

      {* Nun muss ein freier Eintrag gesucht werden. *}
      {* Gleichzeitig suchen wir den ltesten Eintrag - der wird dann *}
      {* - falls kein freier Platz existiert - berschrieben:         *}

      iMiesest := 1; miesest := 255;
      i := 1;
      WHILE (i<=nNRTbl) AND (Miesest <> 0) DO WITH NRTbl[i] DO
        BEGIN
        IF NOT valid THEN BEGIN {* freier Platz *}
		          iMiesest := i;
			  Miesest := 0;
			  END
	             ELSE IF miesest > qualit THEN
                          BEGIN
		          iMiesest := i;
			  Miesest := qualit;
			  END;
	Inc (i);
	END; {WHILE}

      {* In iOldest steht jetzt auf jeden Fall - der Index, der berschreben werden kann *}
      WITH NRTbl[iMiesest] DO
	BEGIN
        Valid   := True;
	Ziel    := ZielCall;
	via     := viaCall;
	Nachbar := NachbarCall; {* aus ax25-Header *}
	Ident   := IdentCall;
	qualit  := quali;
	ifnr    := pm^.ifnr;
	END;
      END;


 {* Welche andere Knoten hrt der TheNet-Knoten denn nun ?
  *  Format:
  *	  Offset/Elw Lnge
  *          01            $FF                   (Nachbar)
  *          02 --    6    IDENT des Absenders   (Nachbar)
  *	     08 01    7    Call eines Knotens (AX25Call)
  *	     15 08    6    ID dieses Knotens (ASCII !)
  *	     21 14    7    via zu diesem Knoten (AX25Call)
  *	     28 21    1    Qualitt der Verbindung
  *}
  VAR p : POINTER;
BEGIN
  p := pm^.pData;  Inc  ( word(p), 7);
  Move ( p^, NachbarCall, 7 );  {* FROMCALL AX25-HEader *}

  p := pm^.pData;  Inc( Word (p), pm^.ofsCtl + 1);
  IF byte (p^) <> 255 THEN Exit; {* das ist wohl KEIN Broadcast !*}
  Inc (word(p));
  Move ( p^, IdentCall[1], 6); IdentCall[0] := #6;
  Inc ( word (p), 6 );
  ZielCall := NachbarCall;
  {* Der ausstrahlende Knoten muss natrlich auch in die RouteTabelle aufgenommen werden! *}
  viaCall := ZielCall;
  quali := 192;	 {* Er hat natrlich auch 'ne hohe Qualitt $OPT: LZ umrechnen *}
  DoTheNetRout;

  i := 7;
  WHILE ( pm^.ofsCtl + 1 +21+i <= pm^.inuse) DO
    BEGIN {*OPT*: direkt die Zeiger bergeben *}
    {* Zeigt auf Call eines Knoten *}
    Move ( p^, ZielCall, 7 );
    Inc ( word (p), 7 );
    {* Hier zeigt er auf den IDENT *}
    Move ( p^, IdentCall[1], 6 ); IdentCall[0] := #6;
    Inc ( word (p), 6 );
    {* Hier zeigt er auf das zugeh. viaCall *}
    Move ( p^, ViaCall, 7 );
    Inc ( word (p), 7 );
    {* Hier zeigt er auf die Qualitt *}
    quali := byte (p^);   {* Quali := 192 * word(Quali) DIV 256; }
    DoTheNetRout;         {* ZielCall := viaCall; *}
                          {* Der Nachbar kann das viaCall arbeiten - also wir auch (evt. doppelt gemoppelt) *}
    Inc ( word (p) );
    Inc (i,21);
    END ;
  routesAreSorted := notSORTED;
END;


{ NRC - Zeuch }

{$F+} PROCEDURE fnMsgConnectViaNR ( pCB : TP_AXCB; msg : T_Msg);
 {* Handler fr Connectversuche via NETROM-DIGIS *}
  VAR s : STRING;
BEGIN
  CASE msg OF
    msgReconnect,
    msgConnectSuccess :
      BEGIN
      Move ( pCB^.digi[7], s, SizeOf(s) ); {* digi [7] = HACK *}
      Tx_Info (pCB,Sofort,'C '+s+EOL);
      TX_EOLSysInfo( pCB^.pPartnerCB, SOFORT, 'link setup to '+s+' at '+f_sh2asc(pCB^.tocall)+' - pse wait');
      END;

    msgRX :
      BEGIN
      REPEAT
        s := FrameInfo2String_CR (pCB);
        IF (Pos ('onnected to ',s ) > 1) AND ( pCB^.pPartnercb <> Nil )
          THEN WITH pCB^ DO
                 BEGIN {* Erfolg, nun die beiden Verbindungen zusammenstppseln *}
	         Tx_EOLSysInfo (pPartnerCB, SOFORT, s);
                 StopTimer (pPartnerCB^.tTimeOut); {* Infobox timeout stoppen *}
	         pPartnerCB^.QSOType := qtCircuitMaster;
	         pPartnerCB^.fMsgHandler := fnCircuit;
	         pPartnerCB^.state := CONNECTED;
	         QSOType := qtCircuitSlave;
	         fMsgHandler := fnCircuit;
                 s := ''; {* Schleife beenden *}
	         END
          ELSE IF (Pos ('ailure ',s ) > 1) AND ( pCB^.pPartnercb <> Nil )
                  THEN fnMsgConnectViaNR ( pCB, msgRetryCountExceeded );
                       {* HAcking live :-(; hier darf NIX mehr folgen... *}
      UNTIL s='';
      END;

    msgRxDM,
    msgDiscReq,
    msgRetryCountExceeded :
      BEGIN
      pCB^.fMsgHandler := fnMsgDefault;
      IF msg = msgRxDM
          THEN s := f_sh2asc(pCB^.tocall) + ' busy '
	  ELSE s := 'failure with ' + f_sh2asc(pCB^.tocall);
      Tx_EolSysInfo (pCB^.pPartnerCB, SPAETER, s);
      Reconnected (pCB^.pPartnerCB);
      pCB^.pPartnerCB := NiL;
      END;
     ELSE BEGIN {* Case *}
          fnMsgDefault ( pCB, msg );
          END;
   END; {CASE}
END;


FUNCTION TryToConnectStepByStep ( pCB : TP_AXcb;
                                     ifnr : T_IFNR;
                                     f,t,v,nrEinstieg : String ) : BOOLEAN;
  VAR pNeu : tp_axcb;
      i    : WORD;
BEGIN {* Es kommen sich manchmal noch das herkoemmlich in den Weg *}
  TryToConnectStepByStep := FALSE;
  IF t=nrEinstieg THEN Exit; {* Ziel ist gleich Einstieg; also Ziel auch herkmmlich erreichbar *}
  pNeu := Try2Connect (ifnr, f,nrEinstieg, v ,cNOINCSSID);
  IF pNeu = NiL THEN Exit; {* tja, ging wohl nich *}
  Move (t, pNEU^.digi[7], length(t)+1); {* $HACK*}
  pNeu^.fMsgHandler := fnMsgConnectViaNr;
  pCB^.pPartnerCB := pNeu;
  pNeu^.pPartnerCB := pCB;
  TryToConnectStepByStep := TRUE;
END;


FUNCTION DoConnect_NR (pCB : TP_AXCB; t : STRING ) : BOOLEAN;
  {* Suche die passende Route automatisch und stelle danach *}
  {* den Connect her,indem der Nachbar cnnected wird, und   *}
  {* dann automatisch "C ziel" gegeben wird. Liefert FALSE  *}
  {* zurck, wenn CONNECT nicht sinnvoll/mglich ist        *}
  VAR i, besti,
      bestQ    : WORD;
      s,v      : STRING;
      einstieg : T_ShCall;
BEGIN
  {* Suche t in der Nodes Liste *}
  bestQ := 0; bestI := 0; UPPER (t);
  FOR i := 1 TO nNRTbl DO WITH NRTbl[i] DO IF valid THEN
    IF (t = f_sh2Asc(Ziel)) THEN
      IF qualit > bestQ THEN BEGIN
                        bestq := qualit;
                        bestI := i;
                        END;
  DoConnect_NR := (bestI>0);
  IF bestI > 0
     THEN WITH NRTbl[bestI] DO
          BEGIN {* Gefunden. Bestimme den Netrom-Einstieg *}
          einstieg := Nachbar; {* oder := via *}
          {* Suche Weg zum Einstieg *}
          v := '';
          IF AR_SearchRoute ( Einstieg, FALSE,ifnr, v )=0 THEN;
          IF v <> '' THEN v := ',' + v ;
          v := axiface[ifnr].asMyCall+'*'+v ;

          IF TryToConnectStepByStep ( pCB, ifnr,
                                 f_sh2asc(pCB^.toCall),
                                 t, v,
                                 f_sh2asc(einstieg))
             THEN s := 'link setup to '+f_sh2Asc(Ziel)+' via '+f_sh2Asc(einstieg)
             ELSE BEGIN
                  s := 'not possible, try CONNECT';
                  DoConnect_NR := FALSE;
                  END;
          END
     ELSE s := 'not found, try CONNECT';
  Tx_EoLSysInfo(pCB,SOFORT,s);
END;


PROCEDURE ManTryToConnectViaNR (  ifnr : T_IFNR;  f,t,v, nrEinstieg : String );
  VAR pCB : tp_axcb;
      i   : WORD;
BEGIN
  pCB := Try2Connect ( ifnr, f, nrEinstieg, v ,cNOINCSSID);
  IF pCB = NiL THEN Exit;
  Move (t, pCB^.digi[7], length(t)+1); {*HACK*}
  pCB^.fMsgHandler := fnMsgConnectViaNr;
  pCB^.pPartnerCB := NiL;
END;

{}


PROCEDURE DoEvery5MinuteNetRom;
 {* Wird alle 5 Minuten vom Hauptprogramm aufgerufen. *}
 {* Dient zum Runterzhlen der Qualitt               *}
  VAR i : WORD;
BEGIN
  FOR i := 1 TO nNRTbl DO  WITH NRTbl[i] DO IF valid THEN
    BEGIN
    IF (qualit > DECQUALI) THEN Dec (qualit, DECQUALI)
                           ELSE valid := FALSE;
    IF (qualit < OBSOQUALI) THEN valid := FALSE;
    END;
END;

{}

PROCEDURE SortNodesByZiel;  {* $OPT*}
  VAR i,j : WORD;
      h : T_NR;
BEGIN
  FOR i := 1 TO nNRTbl-1 DO
   FOR j := i+1 TO nNRTbl DO
     IF NRTbl[i].Ziel > NRTbl[j].Ziel THEN
	BEGIN
        WatchDog;
	Tausche( @NRTbl[i], @NRTbl[j], sizeof(NRTbl[1]) );
	END;
  routesAreSorted := sortZiel;
END;

PROCEDURE SortNodesByIdent; {* $OPT*}
  VAR i,j : WORD;
      h : T_NR;
BEGIN
  FOR i := 1 to nNRTbl-1 DO
   FOR j := i+1 TO nNRTbl DO
     IF NRTbl[i].Ident > NRTbl[j].Ident THEN
	BEGIN
        WatchDog;
	h := NRTbl[i];
	NRTbl[i] :=  NRTbl[j];
	NRTbl[j] := h;
	END;
  routesAreSorted := sortIDENT;
END;



PROCEDURE SortNodesByQuali; {* $OPT*}
  VAR i,j : WORD;
      h : T_NR;
BEGIN
  FOR i := 1 TO nNRTbl-1 DO
    BEGIN
    WatchDog;
    FOR j := i+1 TO nNRTbl DO
      IF NRTbl[i].qualit < NRTbl[j].qualit THEN
	BEGIN
	h := NRTbl[i];
	NRTbl[i] :=  NRTbl[j];
	NRTbl[j] := h;
	END;
    END;
  routesAreSorted := sortQUALI;
END;



PROCEDURE DoListNodes (pCB:tp_axcb; sArg : STRING );
 CONST	COMANDS =
   'LONG # ZIEL CALL IDENT QUALI '; {* Letzte Leerzeichen ist wichtig ! *}
    cmdTab : ARRAY [1..length(COMANDS)] OF CHAR = COMANDS;
  VAR i, j : WORD;
      s : STRING;
      last : T_ShCall;
      long : BOOLEAN;
      nCalls : WORD;
BEGIN
  Long := FALSE;
  REPEAT
    i := ScanStr (sArg, @cmdTab, sizeOf (cmdTab));
    CASE i OF
      1,2 : long := TRUE;
      3,4 : IF routesAreSorted <> sortZiel THEN SortNodesByZiel;
      5   : IF routesAreSorted <> sortIdent THEN SortNodesByIdent;
      6   : IF routesAreSorted <> sortQuali THEN SortNodesByQuali;
     END; {case}
  UNTIL i = 0;

  {* zustzliches Argument = suche nach Call oder so *}
  Upper (sArg);
  IF sArg <> '' THEN long := TRUE;

  s := EOL;
  Tx_EoLSysInfo (pCB, SPAETER,
  + 'HINWEIS: Diese Liste ist nur zur INFO, Connecten ist NICHT IMMER moeglich' + EOL);
  nCalls := 0;
  FOR i := 1 to nNRTbl DO IF NRTbl[i].Valid THEN WITH NRTbl[i] DO
    BEGIN
    WatchDog;
    j := 6;
    WHILE (ident[j] = ' ') AND (j >= 1) DO {* Ident rechtsbndig formatieren *}
      Dec (j);
    IF j <> 0 THEN BEGIN
                   Move ( Ident[1], Ident[7-j], j );
                   FillChar (Ident [1], 7-j-1, ' ');
                   END;
    s := ident + ':' + f_sh2ascUsing (Ziel,true,10);
    {* Kennzeichen zur Selektion z.B: N :DB0II oder N DB0QS, *}
    IF long THEN  s := s + f_sh2ascUsing (nachbar,true,8) +','
                         + f_sh2ascUsing (via,true,8)     +'.'
                         + ' Q=' + f_Using(qualit,3)
                         + ' P'  + FStr(ifnr);
    IF (sArg='') OR (Pos(sArg, s)<>0 ) THEN
      BEGIN
      IF NOT long THEN SetStrLength (s,19);
      Tx_Info (pCB, SPAETER, s ); s:= '';
      Inc (nCalls);
      IF long OR (nCalls MOD 4 = 0) THEN Tx_Info (pCB, SPAETER, EOL );
      END;
    END;
END;


BEGIN
  FillChar ( NRTbl, SizeOf (NRTbl), #0);
END.
