UNIT FD_Moni;
{$I FD_INCL.PAS}
{...$DEFINE DumpDetails}

INTERFACE

USES FD_Def;

(*TYPE T_StrRes = RECORD
       sHead1 : STRING;
       sData1 : String;
       colData1 : ARRAY [1..255] OF BYTE; {Farbinfo}
       sError : String;
      END;
CONST cStrResNil : T_StrRes = (sHead1:'';sData1:'';sError:'');
*)

 PROCEDURE DumpHex (VAR hdl:TEXT;  p : Pointer; len : Longint);
 PROCEDURE DumpText ( p : Pointer; len : WORD);

{* PROCEDURE Call2Str ( pBasis : Pointer; n : WORD; VAR s : STRING); }
{* PROCEDURE Call2Str2 ( pBasis : Pointer; n : WORD; VAR s : STRING;var mdama,fMaxF128:boolean); }

 PROCEDURE IPHead2Str ( p1 : Pointer; gesamtLen : WORD; VAR s : STRING);

  FUNCTION Pm2AxHeaderStr ( pm : tp_mbuf; fTimeStamp:BOOLEAN ) : String;
  FUNCTION Pm2BodyStr     ( pm : tp_mbuf ) : String;

 PROCEDURE Ax25Body2Str( pid:Byte; p:Pointer; len:WORD; VAR s : STRING);
 PROCEDURE Ax25Body2StrAppend( pid:Byte; p:Pointer; len:WORD; VAR s : STRING);


{}

IMPLEMENTATION

USES
     {$IFDEF SCC}
         FD_TNC,
      {$ELSE}
         FD_CRT,
         dos,
     {$ENDIF}
     FD_Div,
     FD_Subr {* Pm2Txdelay *}
     ;

  VAR LastTimeStamp : LongInt;


PROCEDURE DumpHex (VAR hdl:TEXT;  p : Pointer; len : Longint);
  VAR i : WORD;
      sAscii : STRING;
BEGIN
  SetTextAttr (_green_Black);
  sAscii := '';

  FOR i := 1 TO len do
    BEGIN
    Write (hdl,HexByteString(BYTE (p^)),' ');
    IF byte(p^) >= 32 THEN AddChar(sAscii,char(p^))
                      ELSE AddChar(sAscii,'.');
    IF i MOD 16 = 0
      THEN BEGIN
           Writeln(hdl,'  ',sAscii);
           sAscii := '';
           END
      ELSE IF i MOD 8 = 0 THEN
             BEGIN
             AddChar(sAscii,' ');
             Write (hdl,'  ');
             END;

    Inc (word (p));
    END;
  Writeln(hdl,'  ',sAscii);
END;


PROCEDURE TextAsString ( pc : TP_CHAR; len : WORD; VAR s:STRING);
  VAR l : WORD;
BEGIN
  IF len < 1 THEN Exit;
  IF length(s)<255
    THEN BEGIN
         l := Min(255-length(s),len);
         Move( pc^, s[length(s)+1], l );
         byte(s[0]) := length(s)+l;
         IF len>l THEN s[length(s)] := '<';
         END
    ELSE s[length(s)] := '<';

{  FOR i := 1 TO len do
    BEGIN
    AddChar(s, pc^);
    IF length(s)>252 THEN BEGIN AddString(s,'<..>'); Exit; END;
    Inc (pc);
    END;}
END;


{----}


PROCEDURE TCPHead2Str ( p1 : Pointer; dLen : WORD; VAR s : STRING);
  VAR p : tp_by1Array;
      len,wor,i : WORD;
BEGIN
  p := p1;
  AddString(s, {'Ports:'+} StrML (p,1)+''+ StrML (p,3) );

  AddString(s,' seq:');
  FOR wor := 5 to 8 DO  AddString(s,HexByteString (p^[wor]) ); {*Sequenznr.*}
  AddString(s,' ack:' );
  FOR wor := 9 to 12 DO AddString(s,HexByteString ( p^[wor] )); {*Ack.Nr.*}
{$IFDEF DumpDetail}
  AddString(s, ' Window:'+ StrML (p,15) );
{$ENDIF}

  IF p^[14] AND  1 =  1 THEN AddString(s,' FIN');
  IF p^[14] AND  2 =  2 THEN AddString(s,' SYN');
  IF p^[14] AND  4 =  4 THEN AddString(s,' RST');
  IF p^[14] AND  8 =  8 THEN AddString(s,' PSH');
  IF p^[14] AND 16 = 16 THEN AddString(s,' ACK');

{$IFDEF DumpDetail}
  IF p^[14] AND 32 = 32 THEN AddString(s,' Urg.P.:'+StrHexML (p,39) );
{$ENDIF}
  len := (p^[13] SHR 4)*4;
  IF len <> 20 THEN AddString(s,' tcp-len:'+FStr(len));
  IF dLen > len THEN AddChar(s,CR);

  Inc (word(p1), len);
  TextAsSTRING ( p1, dLen-len,s);
END;



PROCEDURE IPHead2Str ( p1 : Pointer; gesamtLen : WORD; VAR s : STRING);
  VAR i, wor,
      ipLen,
      fOffSet,
      prot,
      headerLen : WORD;
      p         : ^by1Array;
      p2        : POINTER;
BEGIN
  p := p1;

  IF gesamtlen < 20 THEN Exit;

  ipLen := wordML (p,3); {* TOTAL LENGTH: Header+Data gesamtes Datagramm *}
  headerLen := (p^[1] AND 15) * 32 DIV 8; {* HEADER LENGTH in 32 Bit-words *}
  IF ipLen < headerLen THEN Exit;
  IF headerlen > 50 THEN Exit;
  IF iplen > 8000 THEN Exit;

  AddString(s, 'IP[');
  FOR wor := 13 to 16 DO  AddString(s, FStr(p^[wor])+'.');
  Dec(s[0]);
  AddString(s, '][');
  FOR wor := 17 to 20 DO  AddString(s, FStr(p^[wor])+'.' );
  Dec(s[0]);
  AddString(s, '] ipLen:'+FStr(ipLen) );
  IF headerlen <>20 THEN AddString(s, ' Headerlen:' + FStr(headerLen) );

  fOffset := (WordML(p,7) AND $1fff) * 8; {* Fragment Offset in Bytes *}

{$IFDEF DumpDetail}
  AddString(s,' ttl: '+ FStr(p^[9])+
         ' Vers.: '+ HexByteString ( p^[1] SHR 4 )
         );

  IF (fOffset <>0) OR (WordML(p,7) AND $2000 <>0 )  {* More Fragment *}
     THEN AddString(s,' ID: '+StrHexML (p,5)+
                  ' f.off: '+ FStr(fOffset)
                 );

  IF (WordML(p,7) AND $4000 <>0 ) THEN AddString(s,' DF');
  IF (WordML(p,7) AND $2000 <>0 ) THEN AddString(s,' MORE');

  IF p^[2] <> 0 THEN AddString(s,' ToS: $'+ HexByteString (p^[2]) );
{$ENDIF}
  CASE p^[10] OF
     IPID_ICMP,IPID_TCP,IPID_UDP,IPID_RSPF :
     ELSE  AddString(s, '  Prot:'+FStr(p^[10]));
     END {case};

  AddChar(s,CR);
  prot := 0;
  IF fOffSet>0
    THEN AddString(s,'ipFrag')
    ELSE BEGIN
         prot := by1Array (p^) [10];
         CASE prot OF
            IPID_ICMP :  AddString(s,'ICMP');   {/* Internet Control Message Protocol *}
            IPID_TCP  :  AddString(s,'TCP');   {/* Transmission Control Protocol *}
            IPID_UDP  :  AddString(s,'UDP');   {/* User Datagram Protocol *}
            IPID_RSPF :  AddString(s,'RSPF');   {/* Radio Shortest Path First *}
            ELSE         AddString(s,'????');
         END;{case}
         END;

  Inc (word (p1),headerLen);
  CASE prot OF
     IPID_TCP  : TCPHead2Str(p1, ipLen-Headerlen, s);
     ELSE TextAsSTRING ( p1, ipLen-Headerlen, s);
    END;
END;




PROCEDURE AXSegHead2Str( p1 : Pointer; gesamtLen : WORD; VAR s : STRING);
{* Format: 1.Byte: Bit 7=1: erstes Segment. das folgende Byte enthlt die
 *                 getunnelte PID; das darauf folgende Byte ist das erste
 *                 Datenbyte
 *                 Bit 6-0: Anzahl der noch folgenden Segmente
 *         2.Byte: ggfs (s.o) die PID, ansonsten 1.Byte der Daten
 *}
  TYPE t_c = record code,pid:BYTE;END;
  VAR seg,pid : byte;
      s2 : STRING[20];
BEGIN
  AddString(s, 'AxSeg ');
  seg := t_C(p1^).code;
  s2 := ' remain.segs:'+FStr(seg and AXSEG_REM);
  IF (seg and AXSEG_FIRST) <> 0
    THEN BEGIN
         pid := t_C(p1^).pid;
         AddString(s,'1.Seg;'+s2+' pid:'+FStr(pid));
         AddChar(s,cr);
         Ax25Body2StrAppend(pid, IncP(p1,2), gesamtLen-2, s ); {* Rekursion *}
         END
    ELSE BEGIN
         AddString(s, s2);
         AddChar(s,cr);
         Inc(tp_Byte(p1));
         TextAsSTRING ( p1, gesamtLen-1,s);
         END;
END;



PROCEDURE Call2Str2 ( pBasis : Pointer; n : WORD; VAR s : STRING;var mdama,fMaxF128:boolean);
VAR i  : WORD;
   ssh,l,ssid : BYTe;
BEGIN
  ssh := by1Array (pBasis^)[n+6];
  IF (ssh AND $60) <> $60 THEN
    BEGIN {* Testen der "RESERVED BITS" im SSID-Byte *}
    IF (n=8) and ((ssh AND $20) = 0) THEN mdama:=true; {* DAMA *}
    IF (ssh AND $40) = 0 THEN fMaxF128:=true; {* MaxFrame 128 *}
    END;
  {* Call. Ggfs. rechtsbndige Leerzeichen ausblenden *}
  l := n+5;
  WHILE (by1Array (pBasis^)[l] = Byte(' ') SHL 1) AND (l>n) DO  Dec (l);
  FOR i := n TO l DO  AddChar(s, char (by1Array(pBasis^)[i] DIV 2) );

  ssid := (ssh div 2) and 15;
  IF ssid > 0 THEN AddString(s,'-'+FStr(ssid));
{$IFnDEF HostMode}
{* Wenn hier die H-bits angezeigt werden, dann bei allen die das H gesetzt haben}
  {IF n > 10 THEN IF (ssh AND $80) <> 0 THEN AddChar(s,'*');}
{$ENDIF}
END;

{PROCEDURE Call2Str ( pBasis : Pointer; n : WORD; VAR s : STRING);
 var mdama,fMaxF128:boolean;
BEGIN
  mdama := false; fMaxF128:=False;
  Call2Str2 ( pBasis,n,  s,mdama,fMaxF128);
  IF mdama THEN AddChar(s,'');
  IF fMaxF128 THEN AddChar(s,'');
*END;}



FUNCTION Pm2axHeaderStr ( pm : TP_MBuf; fTimeStamp:BOOLEAN ): String;
  VAR qsoNr, i,
      h, coff        : WORD;
      ssid,
      control        : BYTE;
      p              : TP_Data;
      fKompress,
      fPID,fCommand,
      fDAMA,fMaxF128 : BOOLEAN;
      txd            : REAL;
      sHilf          : String[6];
      sTyp           : STRING [10];
      sHeader        : STRING;
BEGIN
  p := pm^.pData;
  coff := pm^.ofsCtl;

  fKompress := coff=cOFFVIRT;

  IF (coff<14) AND NOT fKompress THEN
    BEGIN
    sHeader := '?OffsetCtrl<14!';
    AddString( sHeader,
               FStr(coff)+EoL
               +AsHexString( p, Min(pm^.len,25),true{fWithAscii},false{fBeauty})
               +EOL
             );
    Pm2axHeaderStr := sHeader;
    Exit;
    END;

  control := by1Array (p^)[cOff];
  Inc (cOff);
  IF fKompress THEN fCommand := (by1Array (p^)[2] AND $02 <> 0)
               ELSE fCommand := (by1Array (p^)[7] AND $80 <> 0);

  fpid := false;
  IF      Control and $0f =   1 THEN       sTyp := 'RR'
  ELSE IF Control and $01 =   0 THEN BEGIN sTyp := 'I'; fpid :=true;END
  ELSE IF Control and $0f =   5 THEN       sTyp := 'RNR'
  ELSE IF Control and $0f =   9 THEN       sTyp := 'REJ'

  ELSE IF Control and $ef = $03 THEN BEGIN sTyp := 'UI';fpid := true; END
  ELSE IF Control and $ef = $0f THEN       sTyp := 'DM'
  ELSE IF Control and $ef = $2f THEN       sTyp := 'SABM'
  ELSE IF Control and $ef = $43 THEN       sTyp := 'DISC'
  ELSE IF Control and $ef = $63 THEN       sTyp := 'UA'
  ELSE IF Control and $ef = $87 THEN       sTyp := 'FRMR'
  ELSE                                     sTyp := '??';

  fDAMA:=false;
  fMaxF128:=false;

 {* Calls ausgeben *}
  IF fKompress
    THEN BEGIN {* FlexKompress *}
         {* $TODO *}
         qsonr := ((by1Array (p^)[1] SHL 8) OR (by1Array (p^)[2] AND $FC)) SHR 2;
         sHeader := 'fm ('+fStr(QSONr)+') to ';
         byte(sHilf[0]) := 6;
         byte(sHilf[1]) := $20+ (by1Array (p^)[3] AND $Fc) SHR 2;
         byte(sHilf[2]) := $20+((by1Array (p^)[3] AND $03) SHL 4) OR ( (by1Array (p^)[4] AND $f0) SHR 4 );
         byte(sHilf[3]) := $20+((by1Array (p^)[4] AND $0f) SHL 2) OR ( (by1Array (p^)[5] AND $c0) SHR 6 );
         byte(sHilf[4]) := $20+ (by1Array (p^)[5] AND $3f);
         byte(sHilf[5]) := $20+ (by1Array (p^)[6] AND $Fc) SHR 2;
         byte(sHilf[6]) := $20+((by1Array (p^)[6] AND $03) SHL 4) OR ( (by1Array (p^)[7] AND $f0) SHR 4 );
         AddString(sHeader,sHilf);
         ssid := (by1Array (p^)[7]) AND 15;
         IF ssid > 0 THEN AddString(sHeader,'-'+FStr(ssid));
         END
    ELSE BEGIN {* Echt-AX.25 *}
         sHeader := 'fm ';
         Call2Str2 (p,8,sHeader,fDAMA,fMaxF128);
         AddString(sHeader,' to ');
         Call2Str2 (p,1,sHeader,fDAMA,fMaxF128);
         i := 15;
         IF by1Array (p^)[14] AND 1 = 0
           THEN BEGIN
                AddString(sHeader,' via ');
                h:=0;
                REPEAT {* erst ma letztes H-Bit testen*}
                  IF (by1Array (p^)[i+6] and $80 <>0) then h:=i;
                  Inc (i,7);
                UNTIL (by1Array (p^)[i-1] AND 1) = 1;
                i:=15;
                REPEAT {* un nu die via-calls *}
                  IF i<>15 THEN AddChar(sHeader,',');
                  Call2Str2 (p,i,sHeader,fDAMA,fMaxF128);
                  IF h=i   THEN AddChar(sHeader,'*'); {* der hat als letzter das h-bit *}
                  Inc (i,7);
                UNTIL ((by1Array (p^)[i-1] AND 1) = 1) OR (i>10*7+5);
                                                          {^^^^^^^^^ kw 1.10.97}
                END;
         END;

  AddString( sHeader, ' ctl '+sTyp);

  IF (Control and $03 = 1) OR
     (Control and $01 = 0) THEN AddString (sHeader,FStr ((Control AND $e0) SHR 5 ));
  IF  Control and $01 = 0 THEN  AddString (sHeader,FStr ((Control AND $0e) SHR 1 ));


  {* Unterscheidung V1, V2 und FlexCompress *}
  IF fKompress OR ( (by1Array (p^)[14] AND 128) <> (by1Array (p^)[7] AND 128) )
    THEN IF Control and $10 >0  THEN  IF fCommand THEN AddChar(sHeader,'+')
                                                  ELSE AddChar(sHeader,'-')
                                ELSE  IF fCommand THEN AddChar(sHeader,'^')
                                                  ELSE AddChar(sHeader,'v')
    ELSE AddString (sHeader,' V1') ;


  IF fpid THEN AddString( sHeader, ' pid '+HexByteString(by1Array (p^)[cOff]));

  IF fKompress THEN AddString(sHeader,' [FlxKompr]');
  IF fDAMA     THEN AddString(sHeader,' [DAMA]');
  IF fMaxF128  THEN AddString(sHeader,' [M128]');

  txd := Pm2Txdelay(pm);
  IF txd > 0 THEN AddString(sHeader, ' TxD:'+FStrReal(txd) );

  IF fTimeStamp THEN
    BEGIN
    AddString(sHeader,' : '+fStr(pm^.time)
                    + ' (' + fStr(pm^.time-LastTimeStamp) +')'
    );
    LastTimeStamp := pm^.time;
    END;

  Pm2AxHeaderStr := sHeader;
END;



PROCEDURE Ax25Body2StrAppend( pid:Byte; p:Pointer; len:WORD; VAR s : STRING);
BEGIN
  CASE pid OF
    PID_IP :
      BEGIN
      IPHead2Str ( p, len, s);
      END;
    PID_AXSEG :
      BEGIN
      AXSegHead2Str ( p, len, s);
      END;
    ELSE
      BEGIN
      TextAsSTRING ( p, len, s);
      END;
  END; {case}
END;

PROCEDURE Ax25Body2Str( pid:Byte; p:Pointer; len:WORD; VAR s : STRING);
BEGIN
  s := '';
  Ax25Body2StrAppend( pid, p, len, s );
END;


FUNCTION Pm2BodyStr ( pm : tp_mbuf ) : String;
  VAR p : POINTER;
      s : STRING;
      pid : Byte;
BEGIN
  Pm2BodyStr := '';
  {* Vorabplausi *}
  IF (pm^.ofsctl<14) AND (pm^.ofsctl<>cOFFVIRT) THEN  {nur echtes ax.25 und Flex-Kompr. durchlassen}
    BEGIN
    Pm2BodyStr := '[*** Kein AX.25-Frame / OffsetCtrl='+FStr(pm^.ofsctl)+']';
    Exit;
    END;
  IF NOT IsIUIFrameTyp (pm) THEN Exit;  {* Ein Protokollframe *}

  p := IncP(pm^.pData, pm^.ofsCtl);
  pid := byte(p^);
  s:= '';
  Ax25Body2Str( pid,
                IncP(p,1), pm^.inUse-pm^.ofsCtl-1,
                s );
  Pm2BodyStr := s;
END;


PROCEDURE DumpText ( p : Pointer; len : WORD);
{* ACHTUNG! Benutzt Writeln *}
  VAR k,i : WORD;
      CRflag : BOOLEAN;
BEGIN
  IF len > 1200 THEN BEGIN
                     WriteLn;
                     WriteLn (' I. Lngenfehler: ',len);
                     fDisplayFrames := FALSE;
                     Exit;
                     END;
  CRFlag := FALSE;
  FOR i := 1 TO len do
    BEGIN
    CASE char (p^) OF
           CR  : BEGIN
                 {$IFnDEF SCC}
                 SetTextAttr (_Green_Black);
                 Write ('');
                 k := WhereX;
                 IF WhereX<> 1 THEN
                 {$ENDIF}
                    CRFLAG := TRUE;
                 END;
      #00..#31 : BEGIN
                 {$IFnDEF SCC}
                 SetTextAttr (_Green_Black);
                 Write (char(byte(p^)+64));
                 {$ELSE}
                 Write ('.');
                 {$ENDIF}
                 IF CRFLAG THEN WriteLn;
                 CRflag := FALSE;
                 END;
      #255 : BEGIN
             SetTextAttr (_Green_Black);
             Write ('-');
             END;
      ELSE BEGIN
           IF CRFLAG THEN WriteLn;
           CRflag := FALSE;
           SetTextAttr (_White_Black);
           {$IFnDEF SCC}
           Write (char (p^));
           {$ELSE}
           Write (char (byte(p^) {and 127}));
           {$ENDIF}
           END;
      END;
    Inc (word (p));
    END;
END;



(*
PROCEDURE Pm2BodyDetailStr ( pm : tp_mbuf; VAR res : T_StrRes);
  VAR p : ^BYTE;
      s : STRING[255];
      pid : BYTE;
      lenData : WORD;
BEGIN
  IF pm^.ofsctl<14 THEN
    BEGIN
    res.sError := '*** OffsetCtrl zu klein ';
    Exit;
    END;
  IF pm^.ofsctl=pm^.inUse  THEN Exit;  {* Ein Protokollframe *}

  p := pm^.pData;
  Inc(p, pm^.ofsCtl);
  pid := p^;
  Inc(p);
  lenData := pm^.inUse-pm^.ofsCtl-1;

  CASE pID OF
    PID_Text ,
    PID_FlexNet: TextAsResult (p, lenData, res);
    PID_NetROM : DumpNetROM (p, len-cOff+1);
    8          : DumpPIDSegment (output,p, len-cOff+1);
             PID_IP     : DumpIP (p, len-cOff+1);
             PID_ARP    : DumpARP (p, len-cOff+1);
             PID_BC     : BEGIN
                          BC2Str (p, len-cOff+1, sHead, sDat);
                          SetTextAttr ( _yellow_black );
                          WriteLn(sHEad);
                          DumpText(@sDat[1], length(sDat));
                          END;
             ELSE DumpText (p, len-cOff+1) ;
            END; {* CASE *}

  Pm2BodyDetailStr := s;
END;
*)


END.
