UNIT FD_MH;


{$I FD_INCL.PAS}

{$DEFINE nurInfo           - nur InfoFrames und UIs ohne Poll werden fuers MH ausgewertet *}
{..$DEFINE MayExtension  - Div. Erweiterungen nach DG6MAY (ungetestet) }

INTERFACE

USES FD_Def;


  CONST maxMHEARD = {$IFDEF scc} 170; {$ELSE} 290; {$ENDIF}
        MAXMHDIGIS = 4;
  TYPE tp_mHeard = ^T_mHeard;
       t_mHeard = RECORD
         ifNr   : T_ifnr;
         Call   : t_ShCall;
         {* SSID : SET of 0..15 *}
         {*$TODO: nur noch einen Digi, nmlich den Einstiegsdigi speichern *}
         Digi   : ARRAY [1..maxMHDigis] OF t_ShCall;
         nDigi  : 0..MAXMHDIGIS;   {*  Anzahl Digis im Header *}
         {txd : REAL}

         tFirst,
         tLast : longint; {* Uhrzeiten a la unix *}

         nPaket,           {* Anzahl Pakete Insgesamt *}
          nDirekt,          {* So viele Pakete von Ihm sind verbotenerweise direkt gegangen *}
          nDigiPeated,
          nUI,              {* Anzahl UIs *}
         nText,            {* Anzahl normaler Pakete *}
          nAxSeg,
          nIP, nARP,
          nFlexNet, nNetRom,
          nAndere
                   : WORD;
                   END;

  TYPE T_aMHeard = ARRAY [1..maxmHeard] OF t_mHeard;
  VAR nMHeard : INTEGER;    {* Alle mit Index > nMHeard sind ungltig *}
      pMHeard : ^T_aMHeard; {* Basisvariable *}

      aSonstPID : ARRAY [0..255] OF WORD;   {* Zhler fr sonstige PIDs - global *}


PROCEDURE DoMHeard ( pm : tp_mBuf; direktQSO : BOOLEAN );
PROCEDURE MHClear;
PROCEDURE SortMH_Time;
PROCEDURE SortMH_Call;


{}

IMPLEMENTATION


USES  FD_Mem,
      FD_Subr,              {* wg. MemEq    *}
      FD_Div,               {* wg. Tausche  *}
      FD_Task,
      {$IFDEF SCC} FD_TNC   {* wg. Watchdog *}
      {$ELSE}      FD_CRT   {* wg. Watchdog *}
      {$ENDIF}
     ;

{$IFnDEF NurInfo}  NotBremse {$ENDIF}

{}

PROCEDURE DoMHeard ( pm : tp_mBuf; direktQSO : BOOLEAN );
  CONST  cDB0 : STR3 = #136#132#96;  {* shifted-ASCII Vergleichsmuster fr DigiCalls *}
{$IFDEF MayExtension}
  var    p1  : POINTER;
{$ENDIF}
  VAR i,j     : WORD;
      mintime : Longint;
      minind  : WORD;
      p       : POINTER;
      b, pid  : byte;
      trotzdem: BOOLEAN;
      ofsCall : word;
      diginr  : BYTE;
BEGIN
  {* Virt. Addressierung untersttzen wir noch nit - und wie sollten wir
   * auch, wenn es kein Frame an uns ist? *}
  IF pm^.ofsctl=cOFFVIRT THEN Exit;

  {$IFnDEF SCC}
  IF pm^.ofsCtl < 15 THEN Exit; {* verstmmelt *}
  {$ENDIF}


  IF axiface[pm^.ifnr].fLOOPBACK THEN Exit; {* kw 22.3.97 *}

  {$IFDEF nurINFO}
  trotzdem := FALSE;
  IF GetPollFinal (pm) THEN
    CASE GetFrameTyp (pm) OF
      UI :  {* Ein UI mit Poll riecht nach Flexnetsearch mit falschem Pfad *}
           IF Pos('Flex',Get_Info(pm)) <> 0 THEN Exit;
      DM : trotzdem := TRUE; {* DM- wg. Find ! *}
      FRMR : Exit;
      END;
  IF NOT IsIUIFrameTyp ( pm ) AND NOT trotzdem THEN Exit; {* dies ist kein I-Frame! Hinfort damit! *}
  {$ENDIF}

  ofsCall := 7; {* Absender des Frames *}
   BEGIN  {doit}
   p := pm^.pData;
   Inc (word(p),ofsCall);

{$IFnDEF MayExtension}
   {* DB0* Calls, die nicht ber ein Userport kommen, werden ignoriert *}
   IF MemEq(p,@cDB0[1],3) AND (axiface[pm^.ifnr].art <> aUser) THEN Exit;

{$ELSE}
   (*-------------------------------------------------------------------
     dg6may: nix mh wenn: - verstmmelte Calls, d.h. ein char < '0' und
                            <> <space> war drin
                          - DB0..., es sei denn, es ist in der Link-
                            liste enthalten, oder Port ist Usertyp
     ------------------------------------------------------------------ *)

   if memeq(p,@cDB0[1],3) then       (* aha, ein DB0 ... ist gehrt *)
   begin
     j:=0; i:=1;                    (* j=0: nicht in Linkliste *)
     repeat
       if link[i].valid and memeq(p,@link[i].call[1],6) then inc(j);
       inc(i);
     until (i > nLinks) or (j > 0);
     if (j=0) and (axiface[pm^.ifnr].art <> aUser) then exit;
   end;

   {* Call check }
   p1:=p;
   for i:=1 to 6 do
   begin
     if (byte(p1^) < 96) and (byte(p1^) <> 64) then exit;
     inc(word(p1));
   end;

  (* ---------------------------------------------------------- *)
{$ENDIF}

   {* Suche Call in der Liste *}
   i := 1;
   mintime := maxLongint;
   minInd := 0;
   WHILE ( i <= nmHeard  ) AND
         ( NOT MemEq (p, @pmHeard^[i].Call, Sizeof(t_shCall)-1)) DO
     BEGIN
     IF pmHeard^[i].tLast < mintime THEN
       BEGIN {* und den ltesten vorhandenen Eintrag merken wir uns auch schon mal *}
       minTime := pmHeard^[i].tLast;
       minInd := i;
       END;
     Inc(i);
     END;
   IF i>MAXMHEARD THEN i := minInd;

   WITH pmHeard^[i] DO {* entweder gefunden oder der lteste wird ueberschrieben *}
     BEGIN
     IF (i = minInd) OR (i>nmHeard)  THEN
       BEGIN {* Neuer / anderes Call berschreibender Eintrag *}
       FillChar(pmHeard^[i],sizeOf(pmHeard^[1]),#0);
       Move (p^, Call, Sizeof(Call)-1 ); {* ohne SSID *}
       OrSelf( Byte(Call[7]), $60); {* SSID ausblenden, damit es z.B. in AR benutzt werden kann *}
       tFirst := UnixZeitNow;
{*      nPaket   := 0; nText   := 0; ndigipeated :=0;  nUI := 0;  nFlexNet := 0; nNetRom := 0;
 *      nIp      := 0; nARP    := 0; nAxSeg := 0; nAndere := 0; nDirekt := 0;
 *     t  := sysTime.day;  m := sysTime.month;
 *     h1 := sysTime.Hour; m1 := sysTime.Min;
 *}
       IF i > nmHeard  THEN nmHeard := i;
          {* Nicht sauber aber es fkt.: entweder sind noch welche frei, dann wird ...*}
       END;

     IF pm^.OfsCtl > 14
       THEN BEGIN {* Digis sind vorhanden, werden immer eingetragen, sonst kriegt MH Wegnderungen nicht mit *}
            Inc (word(p),7); {* zeigt auf ersten Digi *}
            nDigi := Min(pm^.nHeard,MAXMHDIGIS);
            Move ( p^, Digi[1], nDigi*SizeOf(digi[1]) );
            END
       ELSE nDigi := 0;

     tLast := UnixZeitNow; {* Besser : tLast := pm^.time *};
     ifnr := pm^.ifnr;
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
     IF direktQSO THEN Inc (nDirekt);
     Inc (nPaket);
     IF ofsCall > 7
       THEN Inc (nDigipeated)
       ELSE BEGIN
              CASE GetPid(pm) OF
              PID_Text   : Inc (nText);
              PID_FlexNet: Inc (nFlexNet);
              PID_NetROM : Inc (nNetRom);
              PID_IP     : Inc (nIP);
              PID_AXSEG  : Inc (nAxSeg);
              PID_ARP    : Inc (nARP);
              0          : ; {* keine PID *}
              ELSE         BEGIN
			   Inc (nAndere);
  			   Inc (aSonstPID[GetPid(pm)]);
			   END;
              END; {case}
            END;
     IF GetFrameTyp (pm) = UI THEN Inc (nUI);
 {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
     END;
   END;  {* PROC DoIt *}
END;

{}

PROCEDURE MHClear;
BEGIN
  nmHeard:=0;
END;

PROCEDURE SortMH_Time;
{* kw 23.3.97  Verwendet nun Tausche *}
  VAR i, j : Integer; {* Integer wg. -1 *}
BEGIN
  FOR i := 1 TO nmHeard-1 DO
    BEGIN
    TaskSwitch;
    FOR j := i+1 TO nmHeard DO
      IF pmHeard^[i].tlast < pmHeard^[j].tlast THEN
        BEGIN
        WatchDog;
        Tausche(@pmHeard^[j], @pmHeard^[i], sizeof(pmHeard^[j]));
        END;
    END;
END;

PROCEDURE SortMH_Call;
{* kw 23.3.97  Verwendet nun Tausche *}
  VAR i, j : Integer; {* Integer wg. -1 *}
BEGIN
  FOR i := 1 TO nmHeard-1 DO
    BEGIN
    TaskSwitch;
    FOR j := i+1 TO nmHeard DO
      IF pmHeard^[i].call > pmHeard^[j].call THEN
        BEGIN
        WatchDog;
        Tausche(@pmHeard^[j], @pmHeard^[i], sizeof(pmHeard^[j]));
        END;
    END;
END;

{}

BEGIN
  MemGet( pointer(pmHeard), SizeOf(pmHeard^) );
  FillChar ( pmHeard^, SizeOf(pmHeard^), #0 );
  FillChar ( aSonstPID, SizeOf(aSonstPID), #0 );
  MHClear;
END.
