UNIT FD_Mem;

INTERFACE

{$I FD_INCL.PAS}
USES FD_Def;


{...$DEFINE CountGap}
{$IFDEF DPMI}{$unDEF CountGap} {$ENDIF}


{* Heapstruktur TurboPascal 6.0 und 7.0 (REAL MODE only) *}
TYPE  TP_FreeRec = ^T_FreeRec;
      T_freeRec  = RECORD
	             next : TP_FreeRec;
	             size : Pointer;
                   END;

CONST nAllocFreeBuffer:WORD=0;
VAR   rootRxFree : TP_mbuf;  {* Far Pointer auf die Kette der freien Puffer *}

      nMinFreeBuffer,        {* ACHTUNG! --> wird von FD_SDLC.inc eingebunden *}
      nFreeBuffer            {* ACHTUNG! --> wird von FD_SDLC.inc eingebunden *}
               : Integer;    {* Anzahl freier Buffer *}


PROCEDURE MemGet  (VAR p : POINTER; Size : WORD);
PROCEDURE MemFree (VAR p : POINTER; Size : WORD);

 FUNCTION L1RxBufAvail : BOOLEAN;
 Function GetL1Rxbuf : TP_MBuf;
PROCEDURE ReleaseL1Rxbuf(pm:tp_mbuf);

 FUNCTION MemCountGaps : WORD;
 FUNCTION CheckMem(p : POINTER; Size : WORD; fStore:BOOLEAN):BOOLEAN;
 CONST cSTORE=True;
       cCHECKONLY=false;

{* MauseFallen, damit kein anderer die SYSTEM.GetMem etc. benutzt *}
PROCEDURE New;
PROCEDURE Dispose;
PROCEDURE GetMem;
PROCEDURE FreeMem;

{}
IMPLEMENTATION


USES FD_Div,               {* wg. _DI *}
     FD_Subr,
     FD_mBuf,
     {$IFDEF SCC} fd_TNC   {* wg. Watchdog *}
     {$ELSE}      fd_crt
     {$ENDIF}
     ;

VAR   MEMDEBUG : T_MEMDEBUG;
CONST ADDMEM=sizeof(MEMDEBUG);


{----------------------------------------------}


FUNCTION PrivateAllocL1RXBuf : tp_mBuf;
  VAR pm: TP_Mbuf;
BEGIN
  pm := Get_mBuf ( BuffSize );
  pm^.inUse := 0;
  pm^.bufl := longint(l2w(pm^.pData).seg) SHL 4
                    + l2w(pm^.pData).ofs;
{ FillChar(pm^.pData^, pm^.len, #255);}
  pm^.next := nil;
  Inc(nAllocFreeBuffer);
  PrivateAllocL1RXBuf := pm;
END;


FUNCTION L1RxBufAvail : BOOLEAN;
{* Ist noch ein RX-Buffer verfgbar?   kw 11.5.97
 * In FD_SDLC.ASM ist es auch noch mal kodiert.
 *}
BEGIN
  L1RxBufAvail := RootRxFree <> NiL;
                  {nFreeBuffer > 0;  }
END;


Function GetL1Rxbuf : TP_MBuf;
{* Neuen Buffer holen (mu aus RootRxFree kommen)   kw 11.5.97
 * In FD_SDLC.ASM ist es auch noch mal kodiert.
 *}
BEGIN
  IF NOT L1RxBufAvail {$IFDEF UserWare} OR (nFreeBuffer<10) {$ENDIF}
    THEN BEGIN
         {* neuen Buffer allokieren... *}
         GetL1Rxbuf := PrivateAllocL1RXBuf;
         END
    ELSE BEGIN
         _DI;
         GetL1Rxbuf := RootRxFree;
         RootRxFree := RootRxFree^.next;
         _EI;
         Dec( nFreeBuffer );
         IF nFreeBuffer < nMinFreeBuffer THEN nMinFreeBuffer := nFreeBuffer;
         END;
END;

PROCEDURE ReleaseL1Rxbuf(pm:tp_mbuf);
{* Buffer wieder nach RootRxFree zurcktun ("freigeben")   kw 11.5.97 *}
BEGIN
  pm^.inUse := 0;
  {*** FillChar(pm^.pData^, pm^.len, 'B'); {* $DEBUG }
  _DI;
  pm^.next := RootRXFree;
  RootRXFree := pm;
  _EI;
  Inc(nFreeBuffer);
END;


{----------------------------------------------}


PROCEDURE MemGet (VAR p : POINTER; Size : WORD);
BEGIN
  p := NiL;
  Watchdog;
  IF Size=0 THEN BEGIN
                 StoreStack('F','g');
                 Exit;
                 END;
{$IFDEF memStack}
  FillChar(memDebug, ADDMEM, #0);
  MemDebug.size := size;
  Inc(size,ADDMEM);
{$ENDIF}

{***  size := (size+8) AND $FFF8; {* auf 8 runden *}

  _DI;
  Inc (backup.semem,30);
  System.GetMem (p,sIze);
  Dec (backup.semem,30);
  _EI;
  FillChar(p^,size,#0);

{$IFDEF memStack}
  ASM
   PUSH BP
   MOV  AX,fdcs
   MOV  SI,offset memDebug.pCaller
   LES  DI,[BP+02] {* Ret Adresse des Aufrufers *}
   MOV  WORD PTR [SI+0],DI
   MOV  WORD PTR [SI+2],ES
   SUB  WORD PTR [SI+2],ax {* Abziehen, damit man fuer MAP-File nicht umrechnen muss *}
   MOV  BP,[BP+00]
   LES  DI,[BP+02] {* Ret Adresse des Aufrufers *}
   MOV  WORD PTR [SI+4],DI
   MOV  WORD PTR [SI+6],ES
   SUB  WORD PTR [SI+6],ax {* Abziehen, damit man fuer MAP-File nicht umrechnen muss *}
   POP  BP
  END;
  memdebug.pOrg := p;
  Move (memdebug, p^, ADDMEM);
  Inc(word(p),ADDMEM);
{$ENDIF}
END;


PROCEDURE MemFree (VAR p : POINTER; Size : WORD);
  LABEL l_eop;
BEGIN
  IF p=NiL THEN BEGIN
                StoreStack('F','F'+FStr(size));
                Goto l_eop;
                END;
{$IFDEF memStack}
  IF NOT CheckMem(p,size,true) THEN Goto l_eop;
  Dec(Word(p),ADDMEM);
  Inc(size,ADDMEM);
{$ENDIF}
{***  size := (size+8) AND $FFF8; {* auf 8 runden *}

  Watchdog;
  FillChar(p^,size,#0);

  _DI;
  Inc (backup.semem);
  System.FreeMem (p, size);
  Dec (backup.semem);
  _EI;
l_eop:
  p := NiL;
END;



FUNCTION CheckMem( p : POINTER; Size : WORD; fStore:BOOLEAN):BOOLEAN;
BEGIN
{$IFDEF memStack}
  CheckMem := FALSE;
  Dec(Word(p),ADDMEM);
  IF (t_MemDebug(p^).Size<>Size) OR (t_MemDebug(p^).pOrg<>p) OR (Size=0) THEN
    BEGIN
    IF fStore THEN  StoreStack('F',
                    ' '+FStr(size)+' '+FStr(t_MemDebug(p^).Size)+' '+
                  HexAddrString(p)+' '+HexAddrString(t_MemDebug(p^).pOrg) +
                  '  '+HexAddrString(t_MemDebug(p^).pCaller)+
                   ' '+HexAddrString(t_MemDebug(p^).pCaller2)
                  );
    {Move(p^, BackUp.MemDebug, ADDMEM);}
    Exit;
    END;
{$ENDIF}
  CheckMem := TRUE;
END;


FUNCTION MemCountGaps : WORD;
{* Zhlt die Anzahl der Lscher im Heap *}
  VAR p : tp_FreeRec;
      n : WORD;
BEGIN
  n := 0;
{$IFDEF CountGap}
  p := FreeList;
  WHILE p <> HeapPtr DO
    BEGIN
    Inc(n);
    p := p^.next;
    END;
{$ENDIF}
  MemCountGaps := n;
END;

{* Vorsicht Falle! Nibbles, Schalter, Compilerfehler! *}
{* Falls jemand NEW oder DISPOSE verwendet, wird er   *}
{* hierdurch von Ede Compiler gefasst                 *}
PROCEDURE GetMem;
BEGIN
END;
PROCEDURE FreeMem;
BEGIN
END;
PROCEDURE New;
BEGIN
END;
PROCEDURE Dispose;
BEGIN
END;

(*  VAR pSparStrumpf :POINTER;
function HeapFunc (Size: Word): Integer; far;
{* Der Parameter Size enthlt die Gre des Blocks, der nicht zugewiesen
 * werden konnte. Die Heap-Fehlerfunktion sollte einen Block von mindestens
 * dieser Gre freimachen.
 * Die Funktion HeapError gibt folgendes zurck:
 *    0  Scheitern, sofortige Auslsung eines Laufzeitfehlers
 *    1  Scheitern; New oder GetMem geben einen nil-Zeiger zurck
 *    2  Erfolg; ein neuer Versuch wird gestartet (der wieder die
 *       Heap-Fehlerfunktion aufrufen kann).
 *}
BEGIN
  IF pSparStrumpf <> nil THEN
    BEGIN
    System.FreeMem(pSparStrumpf,10000);
    pSparStrumpf := nil;
    HeapFunc := 2;
    Exit;
    END;
  HeapFunc := 0;

{  WriteLn('--HeapError,size: ',size, '  MemAvail:',MemAvail,'  ',MaxAvail);
  IF size=0 THEN HeapFunc := 1
            ELSE HeapFunc := 0; }
END;
  *)

{}
  VAR pl, pm : tp_mbuf;
      j      : WORD;

BEGIN
{$IFDEF DPMI}
  heaplimit := 1;  {* Hilft beim Debuggen!*}
  heapblock := 1024; {* Hilft beim Debuggen!*}
{$ENDIF}

  {* System.GetMem(pSparStrumpf,6000);
   * HeapError := @HeapFunc;
   *}

  {* RX-Buffer allokieren - feste Groesse u.a. wg. DMA *}
  {* Hieraus haben sich alle Treiber zu bedienen.      *}
  WatchDog;
  pl := NiL;
  FOR j := 1 TO nBuffer DO
    BEGIN
    pm := PrivateAllocL1RXBuf;
    pm^.next := pl;
    pl := pm;
    END;
  RootRxFree := pl;
  lstRxInUse.root := NiL;
  nFreeBuffer := nBuffer;
  nMinFreeBuffer := nBuffer;
END.
