{$I FD_INCL.PAS}
UNIT FD_mBuf;

INTERFACE


USES FD_Def;



 FUNCTION Get_mBuf ( size : WORD ) : tp_mbuf;
PROCEDURE Clone_mBuf ( pm : tp_mBuf; size : WORD );
 FUNCTION CopyMBuf ( pm : tp_mbuf) : tp_mbuf;
 FUNCTION StripAndCopy_mBuf (pCB:TP_AXCB; pm : tp_mbuf) : tp_mbuf;
PROCEDURE Del_mBuf (VAR pm : tp_mBuf);
PROCEDURE Del_mBuf_chain (VAR pm : tp_mBuf);
PROCEDURE DelmBufData (pm : tp_mBuf; delsize:WORD);
     TYPE T_CheckMbuf = (cAllOk, cPmNil, cPmDataNil, cOtherErr, cFatal);
 FUNCTION CheckMBuf (pm : TP_Mbuf) : T_CheckMbuf;

{}

IMPLEMENTATION

USES {FD_Timer,}
     FD_Mem,
     {$IFDEF SCC} FD_TNC, fd_scc,
     {$ELSE}      FD_CRT,
     {$ENDIF}
     FD_Error,    {* StoreStack *}
     FD_Pack,
     FD_AXCB,
     FD_Div
     ;

{}

FUNCTION Get_mBuf ( size : WORD ) : tp_mbuf;
  {$IFDEF So_waers_schn__geht_aber_wg._Freemem_nicht *}  Test, ob auch ausgedeft...
  __GetMem ( pointer(pm), SizeOf (pm^)+size ); pm^.pdata := pm+SizeOf (pm^);
  {$ENDIF}
  VAR pm : tp_mbuf;
BEGIN
  pm := NiL; {*$DEBUG *}
  MemGet ( pointer(pm), SizeOf (pm^) );
  pm^.next  := Nil;
  pm^.pData := NiL; {* $DEBUG *}
  MemGet( pm^.pdata, size );
  pm^.bufl    := 0;  {* $DEBUG *}
  pm^.inUse   := size;
  {*  Time    : longint  *}
  pm^.nHeard  := 0;
  pm^.Ifnr    := 0;
  pm^.txed    := WAITING;
  pm^.ptTimer := NiL;
  pm^.Discard := FALSE;
  pm^.len     := size;
  pm^.ofsCtl  := 0;
  Get_mBuf    := pm;
END;

PROCEDURE Clone_mBuf ( pm : tp_mBuf; size : WORD );
BEGIN
  IF pm^.pData <> NiL THEN MemFree ( pm^.pData, pm^.len );
  pm^.pData := NiL; {* $DEBUG *}
  MemGet( pm^.pdata, size );
  pm^.bufl    := 0;  {* $DEBUG *}
  pm^.inUse   := size;
  pm^.len     := size;
END;



PROCEDURE Del_mBuf (VAR pm : tp_mBuf);
BEGIN
  IF CheckMBuf (pm) <> cAllOK THEN
    BEGIN
    pm := Nil; {* Hinterlsst zwar HeapWaisen, ist aber besser als sofortiger Suizid *}
    Exit;
    END;
  pm^.inuse := 0; {* Kennzeichnen, falls noch irgendwer anderes drauf zeigt *}
  {* _DI oder so, drfte hier nicht ntig sein *}
  IF pm^.pData <> NiL THEN MemFree ( pm^.pData, pm^.len )
		      ELSE StoreStack('m' ,'b'+FStr(pm^.len)+' '+FStr(pm^.inUse));
  pm^.len := 0;
  MemFree ( pointer(pm), SizeOf (pm^) );
  pm := NiL;
END;


PROCEDURE Del_mBuf_chain (VAR pm : tp_mBuf);
  VAR pz : tp_mBuf;
BEGIN
  WHILE pm <> Nil DO
    BEGIN
    pz := pm^.next;
    Del_mBuf (pm);
    pm := pz;
    END;
END;


PROCEDURE DelmBufData (pm : tp_mBuf; delsize:WORD);
  {* lscht die ersten "delSize" Byte aus tp_mbuf.pData^ *}
  VAR p : POINTER;
BEGIN
  IF pm = Nil THEN Exit;
  IF (pm^.inUse >= delSize) THEN
    BEGIN
    p := pm^.pData;
    Inc ( word(p), delSize );
    {* p und pm^.pdata haben garantiert das selbe Segment: *}
    Move (p^, pm^.pData^, pm^.inUse-delSize);
    Dec (pm^.inUse, delSize);
    END;
END;


FUNCTION CopyMBuf ( pm : tp_mbuf) : tp_mbuf;
  VAR pmNeu : tp_mbuf;
BEGIN
  MemGet ( pointer(pmNeu), SizeOf (pmNeu^) );  {* = New (pmNeu) *}
  pmNeu^ := pm^;
  pmNeu^.len := pm^.inUse;
  MemGet ( pmNeu^.pData, pmNeu^.len );
  Move ( pm^.pData^, pmNeu^.pData^, pmNeu^.len );
  CopyMBuf := pmNeu;
END;

{$IFDEF ist_es_getestet?}
FUNCTION SplitMBuf ( pm : tp_mbuf; offset : WORD) : tp_mbuf;
  {* Teile einen Buffer ab Offset auf            *
   * vorher pm: 1..n                             *
   * nacher  pm: 1..offset     neu: offset+1..n  *
   *}
  VAR x : tp_mbuf;
      p : Pointer;
BEGIN
  IF offset >= pm^.inUse
    THEN SplitMBuf := NiL
    ELSE BEGIN
         MemGet ( pointer(x), SizeOf (x^) );  {* = New (x) *}
         x^ := pm^;
	 x^.inUse := pm^.inUse-offset;
         MemGet ( p, x^.inUse );
         x^.len := x^.inUse;
	 x^.pData := p;
         Inc (word(p), offset );
         Move ( pm^.pData^, p^, x^.inUse );
         pm^.inUse := offset;
         SplitMBuf := x;
         END;
END;
{$ENDIF}


FUNCTION StripAndCopy_mBuf (pCB:TP_AXCB; pm : tp_mbuf) : tp_mbuf;
  {* wie Copy_mBuf, allerdings werden nur I-Daten kopiert, *}
  {* wenn keine da, so ist tp_mBuf = NIL                   *}
  VAR pmNeu : tp_mbuf;
      p : POINTER;
BEGIN
  IF pm^.inUse <= pm^.ofsCtl+1
    THEN BEGIN {* keine Nutzdaten drin *}
         pmNeu := NiL;
         StoreStack('K',FStr(pm^.inUse)+' '+FStr(pm^.ofsCtl));
	 END
    ELSE BEGIN {* und kopieren *}
         p := pm^.pData;
         Inc(Word(p), pm^.ofsCtl+1); {* Zeigt jetzt aufs erste InfoByte *}
         IF pCB^.pid = PID_PACKES
           THEN BEGIN
                pmNeu := PackEsAus(p,pm^.inUse-pm^.ofsCtl-1);
                END
           ELSE BEGIN
                pmNeu := Get_mBuf(pm^.inUse-pm^.ofsCtl-1);  {* Platz fr Info holen *}
                Move (p^, pmNeu^.pData^, pmNeu^.len);
                END;
         END;
  StripAndCopy_mBuf := pmNeu;
END;


FUNCTION CheckMBuf (pm : TP_Mbuf) : t_CheckMbuf;
BEGIN
  CheckMBuf := cOtherErr;
  IF (pm = NiL) THEN
    BEGIN
    StoreStack ('m', 'pmNil ' );
    CheckMBuf := cPMNil;
    Exit;
    END;
  IF NOT CheckMem (pm, sizeof(pm^) , cSTORE) THEN Exit;
  IF (pm^.pData = NiL) THEN
    BEGIN
    StoreStack ('m', 'pmDNil '+hexAddrString(pm)+' '
			      +FStr(pm^.len)
			      +' '+FStr(pm^.inUse) );
    CheckMBuf := cPMNil;
    Exit;
    END;
  IF NOT CheckMem (pm^.pData, pm^.len, cSTORE ) THEN Exit;
  IF pm^.inuse > pm^.len THEN
    BEGIN
{*    StoreStack('m', ' inuse>len ' + FStr (pm^.inUse)
 *                  +' ' + FStr (pm^.len)
 *                  +' ' + HexAddrString(pm)
 *                  );
 *}   CheckMBuf := cOtherErr;
    Exit;
    END;
  CheckMBuf := cAllOk;
END;



END.
