UNIT FD_Main;
{$I FD_INCL.PAS}

INTERFACE

USES FD_DEF;

PROCEDURE Main;

{$IFDEF scc} PROCEDURE FD_Patch; {$ENDIF}
PROCEDURE QueueMsg (pCB : TP_AXCB; msg : T_Msg);
{PROCEDURE DeQueueMsg (pCB : TP_AXCB; msg : T_Msg);}
PROCEDURE fnMsgDefault ( pCB : tp_axcb; msg : T_Msg );


{}

IMPLEMENTATION


USES FD_Dump,     {* wg. DumpAx25 *}
     FD_Moni,
     FD_Subr,
     FD_Text,
     FD_mBuf,
     FD_Mem,
     FD_Task,
     FD_Div,
     {$IFDEF slip} FD_IP, {$ENDIF}
     FD_Tx,       {* Wg. SendPaket (Copysrc) *}
     FD_axcb,     {* Suche der QSO *}
     {$IFDEF SCC} fd_TNC, fd_scc,  FD_24C65,    {* Auch EEPROM *}
     {$ELSE}	  fd_crt, DOS, {fd_PCSIO,}
     {$ENDIF}
     FD_Timer,
     FD_State,
     FD_PROM,     {* wg. RestartEEPROM_Read *}
     FD_Error,
     FD_Info,   {* OpenInfoBox *}
     FD_Log,    {* ClearLog *}
     FD_Netrom, {* wg. DoEvery5MinuteNetRom *}
     FD_Flex,	{* wg. DeleteFlexRoutingQso *}
     FD_Conv,   {* wg. CloseConv *}
     FD_Beacon,	{* wg. DoEveryMinuteBeacon *}
     FD_SysOp,  {* wg. Adressvergleich bei Write *}
     FD_Link,	{* wg. DoEveryMinuteLink *}
     FD_Host,   {* wg. HostEverySecond *}
     FD_MH
     {$IFDEF DCF} ,FD_DCF  {$ENDIF}
;

{}

{$F+}
PROCEDURE fnMsgDefault ( pCB : tp_axcb; msg : T_Msg );
BEGIN
  IF msg=msgCBDel THEN
    BEGIN {* Notnagel *}
    IF pCB^.pCv <> Nil THEN CloseConv (pCB^.pCv,WHY_CB_INVALID, '');
    IF pCB^.pInfobox <> Nil THEN CloseInfoBox (pCB);
    IF pCB^.qsoType = qtFlexRouter THEN DeleteFlexRoutingQso ( pCB );
    END;
END;


PROCEDURE QueueMsg (pCB : TP_AXCB; msg : T_Msg);
BEGIN
{$IFDEF ver60}  pCB^.setMsg := pCB^.setMsg + [msg];
{$ELSE}         Include( pCB^.setMsg,msg);
{$ENDIF}
END;
PROCEDURE DeQueueMsg (pCB : TP_AXCB; msg : T_Msg);
BEGIN
{$IFDEF ver60}  pCB^.setMsg := pCB^.setMsg - [msg];
{$ELSE}         Exclude( pCB^.setMsg,msg);
{$ENDIF}
END;

PROCEDURE DoMsg (pCB : TP_AXCB; msg : T_Msg);
BEGIN
  pCB^.fMsgHandler(pCB, MSG);
  DeQueueMsg(pCB,MSG);
END;


PROCEDURE WorkLevel3; far;
{* Dies ist ein eigener Prozess fr sich. Er vermittlet die L2-Ereignisse
 * nach oben (L3-L7) weiter *}
  VAR iCB : WORD;
      pCB : TP_AXCB;
BEGIN
WHILE True DO
  BEGIN
  {$IFDEF v24Life} IF KeyPressed THEN TestKey;  {$ENDIF}
  TaskSwitch;
  FOR icb := 1 TO MaxAssignedCBId DO
    BEGIN
    IF cb[icb] <> NiL THEN WITH cb[icb]^ DO
      BEGIN
      pCB := cb[icb];

      IF msgConnectSuccess IN setMsg      THEN DoMsg(pCB, msgConnectSuccess);

      IF (txBufSize<txWind DIV 2) AND (nUnbest<maxframe)
                                          THEN DoMsg(pCB, msgTx);
      IF msgNoMoreTxOutstanding IN setMsg THEN DoMsg(pCB, msgNoMoreTxOutstanding);

      IF rxBufSize>0 THEN
        BEGIN
        DoMsg(pCB,msgRx);
        IF      RxBufSize>RXwind THEN       Event_BecomeBusy(pCB)
        ELSE IF RxBufSize<RXwind DIV 2 THEN Event_BecomeUnBusy(pCB);
        END;

      IF msgTimeOut      IN setMsg THEN DoMsg(pCB, msgTimeOut);
      IF msgSpecialT1Out IN setMsg THEN DoMsg(pCB, msgSpecialT1Out);
      IF msgReconnect    IN setMsg THEN DoMsg(pCB, msgReconnect);

      IF msgRetryCountExceeded IN setMsg THEN DoMsg(pCB, msgRetryCountExceeded);
      IF msgDiscReq IN setMsg THEN DoMsg(pCB, msgDiscReq);
      IF msgRxDM    IN setMsg THEN DoMsg(pCB, msgRxDM);
      IF msgCBDel   IN setMsg THEN BEGIN
                                   DoMsg(pCB, msgCBDel);
                                   Private_Del_AXCB(pCB);
                                   pCB := nil;
                                   END;
      {TaskSwitch; 14.10.97}
      END;
    END;
  END;
END;



{}



PROCEDURE DoEveryMinute;
{* Wird garantiert GENAU einmal pro Minute aufgerufen *}
 VAR i,j,iCB : word;
     portnummer: Byte;
BEGIN
  Inc( count[cntEveryMinute] );
  CheckIntTable;

  GetTime( sysTime.Hour, sysTime.Min,	sysTime.Sec, wDummy) ;
  GetDate( sysTime.Year, sysTime.Month, sysTime.Day, wDummy) ;

{$IFDEF dcf}   {* mhhh, ob das keine Nebenwirkungen hat? *}
  tcMinute := systime.sec; {* Syncronisieren, damit Minutentick auf die Sekunde 0 fllt *}
  if systime.sec<>0 then exit; {* floet troet.. wenigstens neu gesynct ham mer **}
{$ENDIF}

  DoEveryMinuteLink;	{* Fr LZ-Messungen *}
  DoEveryMinuteBeacon;	{* Baken benutzen keinen eigenen Timer *}
  DoEveryMinuteConvers; {* Um Hosts dran zu locken und fr den Stundengong *}

  {$IFDEF DAMA_SLAVE}
  {- DamaTimeOut fr alle Interfaces berprfen -}
  FOR portNummer := 1 TO MAX_axIFACE DO
    IF axIFace[portnummer].dama.fSLAVE THEN
      IF axIFace[portnummer].dama.ftLastRxDAMABit + 3*60*100 < fasttick THEN
        BEGIN {* DAMA-Slave-Timeout}
        DamaAus(portNummer);
        END;
  {$ENDIF}

  IF useTheNet AND (Systime.Min MOD 5 = 0) THEN
    BEGIN {* alle 5 Minuten *}
    DoEvery5MinuteNetRom; {* Qualitaet runterzaehlen *}
    END;

{$Ifdef dg5mpq_STA}
 IF fSta10minMustBeInit THEN
   BEGIN
   FillChar(sta10min, sizeof(sta10min), #0);
   FOR portNummer := 1 TO MAX_IFACE DO sta10min[portNummer].min_pointer:=1;
   fSta10minMustBeInit:=False;
   END;
 FOR portNummer := 1 TO MAX_IFACE DO
   With axIFace[portnummer] do If valid then With sta10min[portnummer] do
     Begin
     min_TxKByte[min_Pointer]:= (nTxInfoNetto - old_TxByte) Div 1024;
     old_TxByte:= nTxInfoNetto;
     min_RxKByte[min_Pointer]:= (nRxInfoNetto - old_RxByte) Div 1024;
     old_RxByte:= nRxInfoNetto;
     min_nAnzBest[min_Pointer]:=nTXSvPolls - old_nAnzBest;
     old_nAnzBest:= nTXSvPolls;
     min_nITx[min_Pointer]:=nITxBrutto - old_nITx;
     old_nITx:= nITxBrutto;
     min_nIRx[min_Pointer]:=nIRx - old_nIRx;
     old_nIRx:= nIRx;
     Inc(min_Pointer);
     IF min_Pointer > 10 THEN min_Pointer:= 1;
     END;
{$endIf}

{  IF Systime.Min = 0 THEN
    BEGIN {* Jede volle Stunde *
    END;
}

{$IFDEF DCF}
  {* DCF-DEKODER ANWERFEN um 01:59:00 wg. MEZ/MESZ *}
    if to_do_dcf and (not do_dcf) then
      begin;
      if (systime.hour=1) and (systime.min=58) then
        begin
        if dcf_sync_timer>480 then {* nur wenn setinterv. >9 min *}
          begin
          dcf_trigger;
          dcf_count:=30; {* ab 01:58:30 startlcke suchen *}
          end;
        end;
      end;
  {$ENDIF}

END;

{}


PROCEDURE DoFrameInvalidStatistik (pm:tp_mbuf);
  Var fValid : BOOLEAN;
      p      : POINTER;
Begin
    IF (pm^.ifnr>0) AND (pm^.Ifnr<7) THEN Inc(statoc[MAXSTATOc-7+pm^.Ifnr])
                                     ELSE Inc(statoc[MAXSTATOc-8]);
    IF pm^.inUse <  MAXSTATINUSE THEN Inc( statinuse[pm^.inUse] )
                                 ELSE Inc( statinuse[MAXSTATINUSE]);

{    IF NOT (pm^.ofsCtl>=15)        THEN Inc(statoc[MAXSTATOc-09]);
    IF NOT (pm^.ofsCtl MOD 7 = 1)  THEN Inc(statoc[MAXSTATOc-10]);
 }  IF NOT (pm^.iFnr <=MAX_IFACE)  THEN Inc(statoc[MAXSTATOc-11]);
    IF NOT (pm^.iFnr >0)  	   THEN Inc(statoc[MAXSTATOc-12]);
    IF NOT (pm^.inuse<=BUFFSIZE)   THEN Inc(statoc[MAXSTATOc-13]);
    IF NOT (pm^.inuse>=15)         THEN Inc(statoc[MAXSTATOc-14]);
    IF NOT (pm^.ofsCtl<BUFFSIZE)   THEN Inc(statoc[MAXSTATOc-15]);

    {$IFDEF HostMode}
      {* Wir haben im Monitor einen Gammelmode. Hoffentlich ist der robust :-) *}
      HostMonitor(pm,true);
    {$ENDIF}

    {$IFDEF Debug_es_oder_auch_nicht}{$IFnDEF scc}
       WriteLn(EOL,'--------',EOL,'--i',pm^.ifnr,
                     ' t',HexLiString(pm^.time),
                     ' o',pm^.ofsCtl,
                    ' fl:',HexLiString(pm^.bufl),
                     ' = ',HexAddrString(pm^.pData),
                    ' iU',pm^.inUse,
                     ' l',pm^.len,'----------',EOL);
       DumpText(pm^.pData, pm^.inUse);
       Writeln;
       p := pm^.pData; inc(word(p),pm^.inUse);
       DumpText(p, 25);
       Writeln;
       IF pm^.bufl <> longint(l2w(pm^.pData).seg) SHL 4 + l2w(pm^.pData).ofs
         THEN Write ('*** bufl falsch');
       WriteLn('*************************');
    {$ENDIF}{$ENDIF}
END;



PROCEDURE WorkRx;
    VAR pm	  : TP_MBuf;
        pmDup,
        pStart    : tp_mbuf ;
        pCB       : tp_axcb;
	fFremdQso : BOOLEAN;
BEGIN
  {$IFDEF scc} BugfixV25; {$ENDIF}

  _DI;
  pStart := lstRxInUse.Root;
  lstRxInUse.Root := NiL;
  _EI;
  {* pStart ist der Zeiger auf eine Liste mit RXten-Frames (mBuf) *}
  {* Das lteste Frame hngt am Anfang der Liste. *}
  WHILE pStart <> NiL DO
    BEGIN
    WatchDog;
    pm := pStart;
    pStart := pStart^.next;

    IF NOT DoCompletePM ( pm )  {* Bereitet alle Felder von pm auf; wenn kein gltiges ax25 Frame. kommt  FALSE zurck *}

{$IFDEF neverdef} {$IFDEF userware}
  {* testweise QRM erzeugen *}
       OR ( (pm^.ifnr=5) AND (Random(10)=4) )
       {$IFnDEF Userware} mausefalle {$ENDIF}
{$ENDIF}          {$ENDIF}
      THEN BEGIN {* Kein gltiges ax25 Frame *}
         {$IFDEF SLIP}
           IF IsIP(pm) THEN DoIP( pm )
                       ELSE
         {$ENDIF}
                            DoFrameInvalidStatistik (pm);
           END
      ELSE BEGIN {* Frame ist gltiges AX25 Teil *}
           IF pm^.ofsCtl < MAXSTATOC-16 THEN Inc( statoc[pm^.ofsCtl] )
                                        ELSE Inc( statoc[MAXSTATOC-16]);
           pCB := nil;
           fFremdQso := FALSE;
           {$B-}
           IF EqualShCall ( pm, axIFace[pm^.ifnr].Call ) OR {* ohne ssid-Vergleich*}
              EqualShCall ( pm, axIFace[pm^.ifnr].Ident )   {* der muss spter stattfinden *}
              {$IFDEF hostmode} OR EqualHostCalls (pm) {$ENDIF}
             THEN BEGIN
                  Inc ( axIFace[pM^.Ifnr].nRxBrutto, pM^.inUse );
                  pCB := Search_AXCB( pm ); {* QSO schon bekannt ? *}

                  {$IFDEF DAMA_SLAVE}
                  {* Findet auf der QRG fr mich hier DAMA statt? *}
                  {* if not pm^.virt THEN *}
                  IF (by1Array (pm^.pData^)[14] AND $20) = 0 THEN
                    IF axIFace[pm^.ifnr].dama.fSLAVEALLOWED THEN
                      BEGIN {* DAMA-Frame --> Merker fr Timeout setzen *}
                      axIFace[pm^.ifnr].dama.ftLastRxDAMABit := fasttick;
                      IF NOT axIFace[pm^.ifnr].dama.fSLAVE THEN
                        BEGIN {* Auf DAMA umschalten *}
                        {* L1 muss auch noch was umschalten: *}
                        IF DoDnSetPara( axIFace[pm^.ifnr].bindnr, spSETZEDAMAPARA, 1 )=0 THEN;;;;
                        axIFace[pm^.ifnr].dama.fSLAVE := TRUE;
                        END;
                      IF pCB <> nil THEN pCB^.fDama := TRUE;
                      END;
                  {$ENDIF}

                  {$IFDEF v24Life}
                    IF pm^.nMyCall=0 THEN Dump_ax25 ( pm, myRx )
                                     ELSe Dump_ax25 ( pm, myRxDigi );
                  {$ENDIF}
                  DoTrace( cTraceRX, pm, pCB ); {* Trace muss vor der Verarbeitung der Frames passiere *}

                  {* Haben wir dieses QSO schon? *}
                  IF pCB = NiL
                    THEN UnknownQSO ( pM, pCB)  {* nein: pCB erzeugen und initialisieren *}
                    ELSE CalcState ( pCB, pm ); {* Wir lassen den DEA (Determin...) arbeiten *}
                  END
	     ELSE BEGIN {* fremdes Frame - ist nicht fr uns *}
                  {$IFDEF v24Life}
	          IF DisplayAlle THEN Dump_ax25 (pm, andere);
                  {$ENDIF}
                  DoTrace( cTraceRX, pm, nil );

	          fFremdQso := TRUE;
                  {* In FD_State werden die UI an UNS (DB0NETROM>DG9EP), aber nicht    *}
                  {* die Broadcasts (DB0NETROM>NODES) bearbeitet! Also hier das ganze. *}
                  IF useTheNet AND (GetPID(pm) = PID_NETROM) THEN NR_RxBroadcast (pm);
                  IF GetFrameTyp(pm) = UI THEN
                    IF EqualShCall ( pm, shCQCall ) THEN
                      UICQReceived(pm);
	          END;

           {* Hier kommt nun wieder JEDES ax.25-Frame vorbei *}

           {* I-Frames zur Baudratenmessung benutzen *}
           IF IsIUIFrameTyp(pm) THEN Inc ( axIFace[pm^.ifnr].brChBytes, pm^.inUse-pm^.ofsCtl-1 );

           DoMHeard ( pm, fFremdQso ); {* Bearbeiten fr die HeardList *}

           IF axifEcho>0 THEN
             IF pm^.ifnr <> axifecho THEN
               {* Wenn es sowieso ber dieses iface geht, brauchts nicht
                * noch geechot  zu werden .. kw 25.1.99 *}
               BEGIN
               pmDup := CopyMBuf(pm);
               pmDup^.ifnr := axifEcho;
               pmDup^.discard := true;
               SendPaket(pmdup, nil);
               END;

           END; {* frame ist gltig *}

    {* Bearbeiteten Buffer zurckhngen *}
    ReleaseL1Rxbuf(pm);
    END; {* WHILE *}
END;



PROCEDURE WorkTx;
  VAR iCB : WORD;
      pCB : TP_AXCB;
BEGIN
  FOR icb := 1 TO MaxAssignedCBId DO
    IF cb[icb] <> NiL THEN WITH cb[icb]^ DO
      BEGIN
      pCB := cb[icb];
{$IFDEF DAMA_SLAVE}
      {* Bei Dama kein I-Spontanbetrieb (wird ersetzt durch Antwort auf Pollen) *}
      IF NOT fDama THEN
        BEGIN
{$ENDIF}
        WorkRx; {* erst nochmals: Bearbeite eingegangene Buffer   22.8.97 *}
        IF (fDoTxBuf AND (txBufSize>0))   {* Sofortsenden erlaubt & irgendwas zum Senden da *}
           AND (nUnbest=0) THEN
          BEGIN
          bDummy := TryToTXIFrames (pCB,cNURNEUE);
          IF txBufSize=0 THEN fDoTxBuf := false;
          END;
{$IFDEF DAMA_SLAVE}
        END;
{$ENDIF}

      IF pCB^.State = DISCONNECTED THEN Del_AXCB(pCB);
      END;
END;



{}


{$IFDEF scc}
{$L fd_patch.obj}  PROCEDURE FD_Patch; External;
{$ENDIF}

FUNCTION Read_EEPROM24c65(pCB:TP_AxCB) : BOOLEAN;
  VAR f : Text;
      s : STRING;
BEGIN
  Read_EEPROM24c65 := FALSE;
{$IFDEF scc}
  Assign24c65(f);
{ IF IOResult <> 0 THEN Exit; }
  Reset(f);
  IF ioresult <> 0 THEN Exit;
  fBigEEPROM := TRUE;
  WriteLn('- BIG EEPROM detected');
  While NOT EOF(f) DO
    BEGIN
    ReadLn(f,s);
    WriteLn(s);
    Infobox_Interpreter (pCB,DIGISETUP,s);
    END;
  Close(f);
  Read_EEPROM24c65 := TRUE;
{$ENDIF}
END;



PROCEDURE ReadInitParameter;
VAR s : STRING;
    scrWert : BYTE ;
    fScramble : BOOLEAN;
    p : Pointer;

  PROCEDURE SCC_READLN_s;   {* Lesen aus dem Patchbereich *}
    VAR ende : BOOLEAN;
        d,c : CHAR;
  BEGIN
    s := '';
    ende := FALSE;
    REPEAT
      c := char(p^);
      IF fScramble THEN
        BEGIN
        d := c;
        c := char(scrWert XOR ord(c));
        scrWert := ord(d);
        END;
      IF c <> LF THEN {* LF wird ignoriert *}
        IF c <> CR
           THEN BEGIN
     	        AddChar(s,c);
	        ende := length(s) > 240;
	        END
           ELSE ende := TRUE;
      Inc( word(p) );  {* p ist "global" *}
      Inc( lenPatch );  {* der auch       *}
    UNTIL ende;
  END;

  VAR fWriting,fEnde : BOOLEAN;
      pCB  : tp_axCB;
      pWritingStart : Pointer;
      lenText,
      i    : Integer;
      f    : Text;
      s2 : String;
BEGIN
  WriteLn ('- Lese CFG-Bereich');
  pCB := CreateAXCB( MAX_IFACE ); {* irgendwo einloggen *}
  IF pCB= NiL THEN Exit;
  AscCall2shift (SysopCall, pCB^.toCall);
  OpenInfoBox (pCB,FALSE{mitCText},0,0 {Statistikzeug});
  pCB^.who := SysOp;

  fScramble := false;
  scrWert := $E7;
  lenPatch := 0;  {* Zhlt wirkliche Lnge mit *}
  {$IFDEF scc}
   p := @FD_PATCH; {* Addresse besorgen *}
   SCC_ReadLn_s;   {* Kennung weglesen *}
  {$ELSE}
   IF ParamCount <> 1 THEN s2 := 'DIGIWARE.CFG'
                      ELSE s2 := PARAMSTR(1);
   {$I-} Assign (f,s2); Reset(f);
   IF IOResult <> 0 THEN
     BEGIN
     WriteLn ('*** Configfile "',s2,'" not found ****');
     Halt(ERR_NO_ARGS);
     END;
  {$ENDIF}
  i := 0;  fende := FALSE;
  fWriting := false; lenText := 0;
  pWritingStart := Nil;

  REPEAT {* BTW: Prompt steht auf %0 - deswegen gibt es keinen! *}
    WatchDog; {* Ein guter Einstieg :-) *}
    {$IFDEF scc}
     SCC_ReadLn_s;
    {$ELSE}
     ReadLn(f,s);
     Inc(lenPatch,length(s));
    {$ENDIF}
    Inc(i);
    fende := f_upper(s)='END';
    LTrim(s);
    IF Length(s) > 220 THEN WriteLn ('Warn.: Zeile ',i,' zu lang!');
    IF s='hellzapopin' THEN
      BEGIN
      fScramble := true;
      s[1] := ';';
      END;
    fWriting := fWriting OR (f_upper(s)='WRITE');
    IF fWriting AND NOT fENDE THEN
      BEGIN
      IF pWritingStart = nil THEN BEGIN
                                  pWritingStart := p;
                                  lentext := lenPatch;
                                  fScramble := false;
                                  END;
      END
    ELSE IF (s[1]<>';') AND (NOT fENDE) THEN
      BEGIN
      WatchDog;
      Infobox_Interpreter (pCB,DIGISETUP,s);
      {* Antwort der Infobox wegtun *}
      REPEAT
	WatchDog; {* Irgendwie krieg ich langsam 'ne Hundephobie... *}
        byte(s[0]) := GetQueueData (pCB^.txBuf, pCB^.txBufSize, @s[1], sizeof(s)-1, #13);
        {* CR wird von WriteLn wrtlich genommen *}
        WHILE (s<> '') AND (s[1]=#13) DO Dec (byte(s[0])); {* CR entfernen *}
        IF s <> '' THEN WriteLn('Zeile ',i-1,': ',s);
      UNTIL s = '';
      END;
  UNTIL fende
  {$IFnDEF scc} OR eof(f);
   Close(f);  {$I-}
  {$ENDIF};

{$IFDEF SCC}
  IF pWritingStart <> nil THEN
    BEGIN
    i := FindText ( 'INFO' ); {* Platz suchen *}
    IF i<0 THEN {* ok, noch platz da & Text existiert noch nicht *}
      BEGIN
      i := -i;
      MemGet ( pointer(apText[i]), sizeof(apText[i]^) );
      WITH apText[i]^ DO
        BEGIN
        Name := 'INFO';
        sTitel := '';
        size := lenPatch-lentext-4{Lnge von"END"+eol};
        readCount := 0;
        cdir := false;
        writeTime := systime;
        pMem := pWritingStart;
        pmText := nil;
        END;
      END;
    END;
{$ENDIF}

  WriteLn;WriteLn ('- CFG-Len:',lenPatch);

  IF Read_EEPROM24c65(pCB)
    THEN Writeln('- BIG-EEPROM Data used')
    ELSE BEGIN
         WriteLn('- miniEEPROM detected');
         IF RestartEEPROM_Read THEN
           Writeln('- miniEEPROM Data used'); {* und diese dann dadrber legen *}
         END;
  Private_Del_Axcb(pCB);
END;



    CONST a8s : WORD = 0;
PROCEDURE Alle8Sekunden;
  VAR  liCatchedSlowTick : Longint;
       i                 : BYTE;
BEGIN {* Alle 8 Sekunden *}
  ftSek8 := FALSE;

  {* Baudratenmessung *}
  _DI; {* Da auf Slowtick direkt zugegriffen wird *}
  liCatchedSlowTick := SlowTick;
  _EI;
  IF liCatchedSlowTick > brStartTime THEN {* DIVISION durch 0 abfangen *}
    BEGIN
    {** brAvg := ( brAvg + 2*8*brBytes DIV (liCatchedSlowTick-brStartTime) ) DIV 3;***}
    FOR i := 1 TO MAX_IFACE DO WITH axIFace[i] DO
      BEGIN
      brChAvg := ( 3*brChAvg + 8*brChBytes DIV (liCatchedSlowTick-brStartTime) ) DIV 4;
      IF brChAvg > brmax THEN brmax := brChAvg;
      brChBytes := 0;
      END;
    brStartTime := liCatchedSlowTick;
    brBytes := 0;
    END;

  Watchdog;
  _DI;
  Inc (backup.semem,59);
  sysMemAvail := MemAvail;
  Dec (backup.semem,59);
  _EI;
  _NOP;
  _DI;
  Inc (backup.semem,23);
  sysMaxAvail := MaxAvail;
  Dec (backup.semem,23);
  _EI;

  WatchDog;
  {$IFDEF scc}
  {* Speicherknappheit? Mit Hysterese! *}
  IF (sysMemAvail<40000) AND (NOT fSysMemLow)
    THEN BEGIN
         fSysMemLow := TRUE;  { $TODO: auc CB umbauen }
         FOR i := 1 TO MAX_IFACE DO IF axIFace[i].valid THEN
           BEGIN
           DIVself( axIFace[i].txWindowinit, 4);
           DIVself( axIFace[i].rxWindowinit, 4);
           END;
         END
    ELSE IF (sysMemAvail>51000) AND fSysMemLow THEN
           BEGIN
           fSysMemLow := FALSE;
           FOR i := 1 TO MAX_IFACE DO IF axIFace[i].valid THEN
             BEGIN
             MULself ( axIFace[i].txWindowinit, 4 );
             MULself ( axIFace[i].rxWindowinit, 4 );
             END;
           END;
  {$ENDIF}
  IF sysMaxAvail < everSysMinMaxAvail THEN everSysMinMaxAvail := sysMaxAvail;

  nBCUI := 0; {broadcast - hack }

  Inc(a8s);
  IF a8s = 2 THEN
    BEGIN
    a8s := 0;
    DoEvery16sLink;
    END;
END; {* Alle 8 Sekunden *}


PROCEDURE Main;
 VAR tmpFastTick,
     deltaFastTick : LONGINT;
BEGIN
  Watchdog;
  Writeln (copyright1+CR+LF+copyright2);

 {* Timerinterupt freigeben (Timertick und *}
 {$IFDEF scc}
    Mem[V25SEG:$0F9c] := $03;  {* TMIC0, stellt auch die PRIO von TMIC1! *}
    Mem[V25SEG:$0F9D] := $07;  {* TMIC1  Freigabe TimerKanal1 (Int.-Betrieb) *}
 {$ELSE}
    _DI; Port[irq_mask_adr] := Port [irq_mask_adr] AND (NOT 1); _EI;
 {$ENDIF}

  GetTime( sysTime.Hour, sysTime.Min,   sysTime.Sec, wDummy) ;
  GetDate( sysTime.Year, sysTime.Month, sysTime.Day, wDummy) ;
  tcMinute := systime.sec; {* Syncronisieren, damit Minutentick auf die Sekunde 0 fllt *}

  {* Damit die Uhr nicht allzugrossen Bldsinn anzeigt *}
{****  IF (sysTime.Year < 1992) OR (systime.Year > 1999) THEN  SetDate(1992,10,20); {* DG6MAY *}

  BackupStartTime;
  StoreIntTable;
  ReadInitParameter; {* Lese Parameter aus CFG-File bzw. ROM *}

  {* Ersma alle an *}
  WatchDog;
  DoEveryMinute; {* Direkt loslegen *}

{$IFDEF DCF}
  DCF_Error_Termination(3);
  if to_do_dcf then dcf_init;
{$ENDIF}

  deltaFastTick := 0;
  Watchdog;
  Writeln('- starting MTask');
  {$IFDEF  hostmode}
   InitTask( 'L3',   WorkLevel3, 14000, nil );
   InitTask( 'Poll', DoPoll,     14000, nil );
  {$ELSE}
   InitTask( 'L3',   WorkLevel3, 14000, nil );
   InitTask( 'Poll', DoPoll,      3000, nil );
  {$ENDIF}

  Writeln ('- starting Mainloop');

  REPEAT {* Hauptschleife *}
    WatchDog;

    IF ftFast THEN
      BEGIN {* Alle 10 ms *}
      ftFast := FALSE;
      WatchDog;
      _DI; {* Fasttick ist long, also 2 CPU-Zugriffe -> INT-Gefahr *}
      tmpFastTick := FastTick - deltaFastTick;
      deltaFastTick := FastTick;
      _EI;
      TimerCountDown(tmpFastTick);   {* Timer runterzhlen ... *}
      WatchDog;
      CallTimerRoutine;  {* und ggfs. abgelaufene TimerProcs ausfhren *}

      IF tmpFastTick < maxaDELTATIME THEN Inc (aDELTATIME[tmpFastTick])
                                     ELSE Inc (aDELTATIME[maxaDELTATIME]);
      END;

    IF ftSek THEN
      BEGIN {* jede Sekunde (--> eigentlich was fr den Pollerprozess) *}
      ftSek := FALSE;
      {$IFDEF DCF} DCF_Inc; {$ENDIF}
      {$IFDEF hostMode}  HostEverySecond;   {$ENDIF}

      IF ftMinute THEN
        BEGIN
	ftMinute := FALSE;
	DoEveryMinute;
	END;
      IF ftSek8 THEN Alle8Sekunden;
      END;

    {$IFDEF scc} BugfixV25; {$ENDIF}

    {TaskSwitch; 16.8.97}
    WorkRx; {* Bearbeite eingegangene Buffer *}
    WorkTx; {* Gug nach, ob was zu senden anliegt *}
    TaskSwitch;

    {$IFDEF DCF} Dcf_check; {$ENDIF}

  UNTIL FALSE;
END;

{}

CONST ExitSema : BYTE = 0;
  VAR ExitSave : Pointer;

{$F+} PROCEDURE Main_Exit; {$IFNDEF AllFar} {$F-} {$ENDIF}
BEGIN
  IF exitSema = 0 THEN
    BEGIN
    exitSema := 1;
    CloseRegister;
    {$IFnDEF SCC}
    ClearLog;
    _DI;
    Del_mBuf_Chain (lstDel.Root);
    Del_mBuf_Chain (lstRxInUse.Root);
    Del_mBuf_Chain (RootRxFree);
    _EI;
    {$ENDIF}
    exitSema := 0;
    END;
  exitProc := exitSave;
END;

{ init }

  VAR pl, pm : tp_mbuf;
      j      : WORD;
BEGIN
  Watchdog;
  WriteLn ('- Main-Init; Mem:',MaxAvail);
  FillChar( statoc, sizeof(statoc), #0);
  FillChar( statinUse, sizeof(statinUSe), #0);

  FOR j := 1 TO maxbind DO bind[j].valid := FALSE;

  exitSave := exitProc;
  exitproc := @Main_Exit;
  InitSoftWatchDog;
  Watchdog;
  AscCall2shift (cCQCALL, shCQCall );
END.
