UNIT FD_Log;
{$I FD_INCL.PAS}

{$IFnDEF USERWARE}
  {$DEFINE LogTransfer}
{$ENDIF}

INTERFACE
{* Generalisieren: Kanal zur Mailbox Open(); Read(n der eigenen Rubrik), Close *}
{* Anwendungen: Log, Allgemein Texte nachladen, uploads, ... *}

{$IFnDEF scc} {$O+,F+}  {$ENDIF}

USES FD_Def;

TYPE {* Wozu soll eigentlich dieser Typ wirklich gut sein? *}
     T_LogEvent = (leNULL,
                   leComment,
                   leAutoComment,
                   leTryChgLink,
                   leTryChgWatch,
                   leLoginSysOpFail,
                   leLoginSysOpSucces,
                   leSELFCONNECT,    {* Eine Station auf dem Einstieg hat sich selbstconnected *}
                   leCONVERSDLOOP,   {* Eine ConversD-Schleife wurde entdeckt *}
                   leWatch,
                   leLogOut,
                   leIntTbl,
                   leFlexCB,
                   leDCF
                  );


PROCEDURE LogAddEntry ( pCB : TP_AXCB;  code : t_logevent; s : STRING );
PROCEDURE TransferLog;
PROCEDURE ClearLog;
PROCEDURE DumpLog ( pCB : tp_axcb; fNurAnzahl:BOOLEAN );


{}

IMPLEMENTATION


{$IFDEF scc}  {.$UNDEF LogTransfer}  {$ENDIF}
{$IFDEF UserWare}  {$UNDEF LogTransfer}  {$ENDIF}

 USES FD_State,
      FD_Tx,
      FD_Main,
      FD_AxCB,  {* TxWindowberschritten }
      FD_Subr,
      FD_Div,
      FD_Mem,
      {$IFDEF SCC} fd_tnc
      {$ELSE}      fd_crt
      {$ENDIF}
      ;


 TYPE tp_LogBuch = ^T_LogBuch;
      t_LogBuch = RECORD
                    next      : TP_LogBuch;
                    time      : T_TIME;
                    event     : t_LogEvent;
                    Data      : t_shCall;
                    ifnr      : BYTE;
                    nDigis    : 0..8;
                    pDigis    : POINTER;
                    pRemark   : ^STRING;
                   END;
 CONST pRootLogBuch : tp_logbuch = Nil;
       nLogBuch : WORD = 0;


PROCEDURE ClearLog;
  VAR pL,pz : TP_LogBuch;
BEGIN
  pl := pRootLogBuch;
  WHILE pl <> Nil DO
    BEGIN
    WatchDog;
    IF pl^.pRemark <> NiL THEN MemFree (pointer(pl^.pRemark), Length (pl^.pRemark^)+1);
    pz := pl^.Next;
    MemFree( pointer(pl), sizeof(pl^) );
    pl := pz;
    END;
  nLogbuch := 0;
  pRootLogBuch := NiL;
END;

{}

PROCEDURE LogAddEntry ( pCB : TP_AXCB;  code : t_logevent; s : STRING );
  VAR pL : TP_LogBuch;
BEGIN
  IF nLogBuch >= maxLog THEN Exit; {* $OPT: ltesten Eintrag rausschmeisen *}
  pl := NiL; {*$DEBUG *}
  MemGet ( pointer(pl) , sizeof (pl^) );
  WITH pl^ DO
    BEGIN
    time := SysTime;
    event := code;
    IF pCB <> NiL
      THEN BEGIN
           data  := pcb^.toCall;
           ifnr := pCB^.iface;
           nDigis :=  pcb^.nDigi;
           IF nDigis > 0 THEN BEGIN
                              MemGet (pDigis, nDigis*SizeOF (t_ShCall) );
                              MOVE   (pCB^.Digi, pDigis^, nDigis*SizeOF (t_ShCall));
                              END
                         ELSE pDigis := NiL ;
           END
      ELSE BEGIN
           AscCall2shift ('',data);
           ifnr := 0;
           nDigis := 0;
           pDigis := NiL;
           END;

    IF s = '' THEN pRemark := NiL
              ELSE BEGIN
                   MemGet (pointer(pRemark), Length (s)+1);
                   Move (s[0], pRemark^, Length (s)+1 );
                   END;
    END;
  pl^.next := pRootLogBuch;
  pRootLogBuch := pl;

  Inc (nLogBuch);
  {$IFDEF LogTransfer}
  IF nLogbuch > nLogTransferGT THEN Transferlog;
  {$ENDIF}
END;

{}

PROCEDURE MakeLine ( p : TP_LogBuch; VAR s : STRING );
  VAR i : BYTE;
      sPort : String[29];
BEGIN
WITH p^ DO
  BEGIN
  if ifnr<>0 THEN sPort := ' P' + chr(ifnr+48)
             ELSE sPort := '   ';
  s := DatumTTMM (time.day,time.month)
       + '  ' + UhrZeit (time.hour,time.min)
       + sPort
       + ' ' + f_sh2Asc(data)+' ';
  IF nDigis > 0 THEN BEGIN
                     s := s + 'v.';
                     FOR i := 1 TO nDigis DO
                       s := s + f_sh2Asc( t_digis(pDigis^)[i])+',';
                     END;
  CASE event OF
    leComment          : AddChar(s,':');
    leAutoComment      : AddChar(s,'#');
    leLoginSysOpFail   : s := s + 'SysIn failed';
    leLoginSysOpSucces : s := s + 'SysIn success';
    leTryChgWatch      : s := s + 'Tried chg watch';
    leTryChgLink       : s := s + 'Tried chg link';
    leSELFCONNECT      : S := s + 'selfcon';
    leCONVERSDLOOP     : s := s + 'cnvLoop';
    leWatch            : s := s + 'in';
    leLogOut           : s := s + 'out';
    leIntTbl           : s := s + 'IntTbl';
    leFlexCB           : s := s + 'ErrLinkQSO';
    ELSE                AddChar(s,char(65+ord(event)) );
    END;
  IF pRemark <> NiL THEN s := s + ' '+pRemark^;
  s := s + EOL;
  END;
END;


PROCEDURE DumpLog ( pCB : tp_axcb; fNurAnzahl:BOOLEAN );
  VAR pOut : TP_LogBuch;
         s : STRING;
BEGIN
  TX_INFO (pCB,SPAETER, EOL +'DigiWare Logbuch ('+FStr(nLogbuch)+')'+EOL);
  IF fNurAnzahl THEN Exit;
  pOut := pRootLogBuch;
  WHILE (pOut <> Nil) DO
    BEGIN
    MakeLine (pOut,s);
    Tx_Info (pCB,SPAETER,s);
    pOut := pOut^.Next
    END;
  Tx_Trigger (pCB);
END;

{}
{$IFDEF LogTransfer}

CONST zLogQsoZustand : (NULL,waitCONNECT,waitsend,send,waitquit,close) = NULL;
VAR  pOut : TP_LogBuch;

{$F+}
PROCEDURE DoLogTransfer ( pCB : tp_axcb;  msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
  VAR info, s : STRING;
BEGIN
CASE msg OF
  msgConnectSuccess,
  msgRX
    : BEGIN
      IF zLogQsoZustand = WAITCONNECT
       THEN  BEGIN
             REPEAT
               Info := FrameInfo2String_CR (pCB);
             UNTIL (Pos(logWaitForConnect, Info) > 0) OR (Info = '');
             IF Info <> '' THEN
               BEGIN
               TX_INFO (pCB,SPAETER, logSendCmd);
               TX_INFO (pCB,SOFORT,' DigiWare LogBuch '+axIFace[1].asMyCall+EOL);
               zLogQsoZustand := WAITSEND;
               pOut := pRootLogBuch;
               END;
             END
       ELSE IF zLogQsoZustand = WAITSEND
             THEN BEGIN
                  REPEAT
                    Info := FrameInfo2String_CR (pCB);
                  UNTIL (pos (logWaitForSend, Info) > 0) OR (Info = '');
                  IF info <> '' THEN zLogQsoZustand := SEND;
                  END;

      IF zLogQsoZustand = SEND THEN
        BEGIN
        WHILE (pOut <> Nil) AND Not TxWindowUeberschritten(pCB) DO
          BEGIN {* Es darf noch was in den Puffer geschrieben werden *}
          MakeLine (pOut,s);
          TX_INFO (pCB,SPAETER,s);
          pOut := pOut^.Next
          END;
        IF pOut = NiL THEN BEGIN
                           zLogQsoZustand := WAITQUIT;
                           TX_INFO (pCB,SPAETER,'(Dieser Logauszug wurde automatisch erzeugt und uebertragen)'+EOL);
                           TX_INFO (pCB,SOFORT,logClose);
                           END
                      ELSE TX_INFO (pCB,SOFORT,EOL);
        END;

      IF zLogQsoZustand = WAITQUIT THEN
        BEGIN
        REPEAT
          Info := FrameInfo2String_CR (pCB);
        UNTIL (pos (logWaitForDisc, Info) > 0) OR (Info = '');
        IF info <> '' THEN BEGIN
                           zLogQsoZustand := CLOSE;
                           DoDisconnect (pCB);
                           ClearLog;
                           END;
        END;
      END;
  msgDiscReq, {* ein DisconectRequest traf ein *}
  msgRetryCountExceeded,
  msgRxDM,
  msgCBDel
        : BEGIN
          zLogQsoZustand := NULL;
          END;
  ELSE fnMsgDefault ( pCB, msg );
 END;
END;
{$ENDIF}

PROCEDURE TransferLog;
  VAR pNewCB : TP_AXCB;
BEGIN
{$IFDEF LogTransfer}
  IF zLogQsoZustand <> NULL THEN Exit; {* Transfer laueft schon *}
  pNewCB := Try2Connect ( logIfnr,
                           axIFace[logIfnr].asMyCall ,
                           logTo,
                           logVia, cNOINCSSID );
  IF pNewCB <> Nil THEN
    BEGIN
    pNewCB^.who := auto;
    pNewCB^.fMsgHandler := DoLogTransfer;
    zLogQsoZustand := WAITCONNECT;
    END;
{$ENDIF}
END;

END.
