UNIT FD_Link;

{$I FD_INCL.PAS}
{$IFNDEF scc} {$O+,F+} {$ENDIF}

INTERFACE

USES FD_Def;

{$IFDEF Flexnet}
  {$IFDEF scc}
   CONST maxFLEXNBAR=maxLINKS; {* $OPT, denn nicht zu jedem Nachbarn wird die LZ gemessen *}
         maxZIEL=800;
  {$ELSE}
   CONST maxFLEXNBAR=8;
         maxZIEL=100;
  {$ENDIF}
{$ELSE}
   CONST maxFLEXNBAR=1;
         maxZIEL=1;
{$ENDIF}
  CONST MAXLZ = MAXINT;
        lmMESSTIMEOUTSEK = 120; {* Timeout in Sekunden nach SABM bzw.UA . Solange wird auf UA bzw. Text gewartet. *}
  TYPE  T_Ziel = RECORD
             Call     : T_ShCall;
             {*** sSymbName : STR9; {* BayCom-Namenrouting - wenn denn mal *}
             SSID_von,
             SSID_bis : 0..15;
             lkUsed   : 0..maxFLEXNBAR;
               {* Link der benutzt wird. Gleichzeitg Index des Eintrags
                * im Arrays lz.
                * lkUsed zeigt dabei aber nicht unbedingt auf den
                * Eintrag mit der NIEDRIGSTEN Laufzeit (wg. Hysterese!)
                * 0 -> Keine Route bekannt
                *}
             lz : ARRAY [1..maxFLEXNBAR] OF t_Lz;
               {* Index ist die Nr. des entsprechenden Links.
                * Werte > 0: Der Link hat diese Ziel gemeldet
                *            - downstream - NUR hier wird drber gerouted
                *            (heisst aber nicht unbedingt, dass ber
                *             DIESEN gerouted wird -> substream)
                * Werte < 0: Diesen Wert hab ich an diesen Link geschickt
                *            - upstream - wird NIEMALS drber geroutet
                * Wert  = 0: Das Ziel ist ber diesen Nachbarn NICHT
                *            zu erreichen - nixstream - wird
                *            NIEMALS drber geroutet
                *}
             bfChange : longint;  {* Bitfeld. 0 = Alles ndern *}
             holddownftick : longint;
               {* Nur gltig, wenn auch bfChange gltig
                * Nur wenn >= FASTTICK, darf diese Route weitergegeben werden
                * fWeitergebbar : BOOLEAN; Darf nicht weitergegeben werden
                *}
           END;

   TYPE T_AZiel = ARRAY [1..MAXZIEL] OF T_ZIEL;  {* Immer sortiert nach Call! *}
    VAR paZiel : ^T_AZIEL;  {* Immer sortiert nach Call! *}
  CONST nZiel : WORD = 0; {* Cache: enthlt aktuelle obere Grenze des Index von ZIEL *}


 PROCEDURE PrintLinkInfo ( pCB : TP_AXCB; VAR sArg:STRING );    {* fr TBL *}
 FUNCTION  GetLinkInfo4Beacon : STRING;

TYPE t_lpvMode=(cNORMAL,cTOKEN6TX,cTOKEN6RX);
 FUNCTION  LinkPort2Via ( x : BYTE; modus : t_lpvMode ) : STRING;
 FUNCTION  LinkPort2IfNr ( x:BYTE ) : T_IFNR;
 PROCEDURE LinkPort2ViaShPath ( x : BYTE; VAR ret : T_shPath);
 PROCEDURE Send6Token (pCB : TP_AXCB; linkNr : BYTE; destCall : STRING; fWithTrace:BOOLEAN );
 FUNCTION  CheckLinkPath (pCB: TP_AXCB) : BYTE;

 TYPE T_Hidden = (cNILHID,cHIDDEN,cPUBLIC);
      T_Messen = (cNILMESS,cMESSEN,cNICHTMESSEN);

 PROCEDURE SetLinks ( pCB : TP_AXCB; sArg : STRING);
 PROCEDURE DoEvery16sLink;
 PROCEDURE DoEveryMinuteLink;
 PROCEDURE TryToStartLZMess ( i : WORD );
      TYPE T_KORREKTUR = (cNEU,cKORREKTUR);
 PROCEDURE SetAndCalcLZ ( pCB : TP_AXCB; t : Longint; kor : T_KORREKTUR );
 {* Wird in FD_Flex nach RXen einer "1" bentigt *}

{}

IMPLEMENTATION

USES FD_Div,
     FD_Mem,
     FD_Tx,
     FD_Beacon,
     FD_Main,
     FD_Timer,
     FD_Log,    {* wg. LogAddEntry(leFlexCB) *}
     FD_AxCB,
     FD_Subr,
     FD_Ar,      {* fr Laufzeitmessungen - KONSTANTEN *}
     FD_State,
     FD_Flex,
     FD_Info,
     FD_Error,
     {$IFDEF SCC} FD_tnc
     {$ELSE}      FD_crt
     {$ENDIF}
     ;

{}

FUNCTION GetLinkInfo4Beacon : STRING;
  {* Stellt die Info bereit, die fr die ##LINK## BAke gebraucht wird. *}
  VAR s : STRING;
      i : WORD;
BEGIN
  s := '';
  FOR i := 1 TO nLinks DO WITH link[i] DO
    IF Valid
       AND lzMessen
       AND NOT HIDDEN
       AND (tSchnitt < lzANZEIG)
       AND (tSchnitt <> 0) THEN
             BEGIN
             IF system = dsFLEXNET
               THEN s := s + EOL +         f_sh2Asc ( call )
               ELSE s := s + EOL + F_lower(f_sh2Asc ( call ));
             s := s +':'+FStr(tSchnitt);
             END;
  IF s <> '' THEN s := 'Links (Time):'+s
             ELSE s := 'No links active';

  GetLinkInfo4Beacon :=
      {* pgmVersion + '  ' + }
         axIFace[1].asMyIdent+':' + axIFace[1].asMyCall + '  ' + MYQTH + EOL
    + s + EOL;
END;


PROCEDURE PrintLinkInfo ( pCB : TP_AXCB; VAR sArg:STRING );    {* fr TBL *}
  {* Realisierung des TBL-Kommandos *}
  VAR s : STRING;
      i,n : BYTE;
BEGIN
 FOR n := 1 TO nLinks DO WITH link[n] DO
  IF valid AND lzMessen THEN
    BEGIN
    s := f_sh2ascUsing(Call,true,10)
       +'lst:'+ fStr(lastLZat)
       +' st:'+ fStr(StartZeit)
       +' nxt:'+fStr(sekBisMess)
       +'  s:' +FStr(tSchnitt)
       +  ' ' + FStr(tOur)
       +  '/' + FStr(tThem)
       +' +:' + FStr(ord(TOKENSTAT));

    IF pCBRout <> NiL THEN
       BEGIN
       s := s +' id:'+FStr(pCBRout^.id)+ ' tOut:';
       AppendTimerAtStr(pCBRout^.tTimeOut, s);
       END;
{$IFDEF sdfdsfsdf}
    s := s + EOL + '             ';
    FOR i := 1 TO sizeof(link[1].rxinit) DO s := s + HexByteString(rxinit[i])+' ';
{$ENDIF}
    s := s + EOL + '          ';

    FOR i := 1 TO maxLZMESS DO
      IF tlz[i] = lzERROR THEN s := s + '- ' {* Fehler *}
      ELSE IF tlz[i] = 0  THEN s := s + '. ' {* keine Messung *}
                          ELSE s := s + fStr(tlz[i])+' ';
    IF (sArg='') OR ( Pos(f_Upper(sArg),f_Upper(s))>0 ) THEN TX_Info(pCB,SPAETER,EOL+s);
    END;
 TX_Info( pCB, SOFORT, EOL + '->FT:'+fStr(fasttick)
                           + ' ST:' +fStr(SlowTick)
                           + '  '   +FStr((slowtick mod 120) DIV 2));
END;

{}

FUNCTION DelLink ( Nr : WORD ) : BOOLEAN;
  VAR i : BYTE;
BEGIN
  DelLink := FALSE;
  IF nr > MAXLINKS THEN Exit;
  IF NOT link[nr].valid THEN Exit;

  SetzeNachbarLinkZeit ( nr, 0 );
  link[nr].valid := FALSE;
  IF link[nr].pCBRout <> NiL THEN DoDisconnect(link[nr].pCBRout);
  i := 1;
  FOR i := 1 TO MAXLINKS DO
    IF link[i].valid AND NOT link[i].direkt AND (link[i].PortNr = Nr )
       THEN BEGIN {* wenn einem Link der via gelscht wurde, soll er ber *}
                  {* den Benutzereinstieg routen *}
            link[i].portnr := 1;
            link[i].direkt := TRUE;
            {*$TODO Laufzeitmessung sollte er einstellen, Hidden sollte er werden ...*}
            END;
  delLink := TRUE;
END;


FUNCTION MakeLink (portNr : WORD; lcall, via, beschreibung : STRING;
                     MaxSSID : WORD;
                     sys : t_DigiSystem;
                     lhidden : T_Hidden;
                     llzMessen : T_Messen;
                     lfLinkTxDest:BOOLEAN;
                     lredirectPID : WORD) : BOOLEAN;
  VAR shCall,shVia : T_ShCall;
      i,j, linkNr  : BYTE;
      ende         : BOOLEAN;
      linkZwisp    : t_Link;
BEGIN
  MAKELINK := FALSE;
  WatchDog;

  {* ACHTUNG ! Wenn ein Link gendert/gelscht wird, muss ein evt. lfd. *}
  {*           FlexNet-Internode-QSO abgebrochen werden !               *}

  {* Suche Eintrag fr Call. Wenn nicht gefunden, dann freien Platz suchen *}
  AscCall2shift ( f_upper(lcall), shCall);
  i := 1; ende := FALSE;  linkNr := 0;
  WHILE (i<=MAXLINKS) AND ( NOT ENDE ) DO
    BEGIN
    IF link[i].valid
      THEN {$IFDEF Nur_ein_weg_zum_nachbar_erlaubt *}
           ende := MemEq  ( @link[i].call, @shCall, 7)
           {$ENDIF}
      ELSE IF linkNr = 0 THEN linkNr := i;
    Inc (i);
    END;

  IF ende THEN linkNr := i-1
          ELSE IF linkNr = 0 THEN Exit; {* can't do it *}

  {* So, ab hier wird mit linkNr gearbeitet, aber erst mal zwischenspeichern *}
  {* fr den Fall dass eine LinkSchleife eingebaut wird. *}
  {* Nicht sehr elegant, aber robust... *}
  linkZwisp := link[linkNr];

  link[linkNr].direkt := TRUE; {* $OPT*}
  link[linkNr].portNr := 1;

  {* zuerst einen via suchen *}
  IF via = ''
   THEN BEGIN
        IF link[linkNr].valid
          THEN {* nderung bestehender Link *}
          ELSE BEGIN {* neuer Eintrag *}
               IF portNr = NOTANUMBER THEN Exit;  {*OPT* Fehlernummer*}
               link[linkNr].direkt := TRUE;
               link[linkNr].portNr := portNr;
               END;
        END
   ELSE BEGIN
        AscCall2shift ( f_upper(via), shVia);
        i := 1; ende := FALSE;
        WHILE ( i<=MAXLINKS ) AND ( NOT ENDE ) DO
          BEGIN
          IF link[i].valid THEN ende := MemEq( @link[i].call, @shVia, 7 );
          Inc (i);
          END;
        IF NOT ende THEN Exit;
        {* in i-1 ist nun die Nummer des Eintrags, ber den geroutet werden soll *}
        link[linkNr].direkt := FALSE;
        link[linkNr].portNr := i-1;
        END;
  WITH link[linkNr] DO
    BEGIN
    valid := TRUE;
    id := linkNr;
    call := shCall;
    ssid_von := (byte(shCall[7]) AND 30) SHR 1;
    IF MaxSSID = NOTANUMBER
      THEN BEGIN
           IF pos('-',f_upper(lcall) ) = 0 THEN ssid_bis:= 15
                                           ELSE ssid_bis:= ssid_von;
           END
      ELSE ssid_bis:= MaxSSID;
    IF ssid_bis < ssid_von THEN Tausche( @ssid_von, @ssid_bis, sizeof(ssid_von) );
    hidden := (lhidden=cHIDDEN);
    text := beschreibung;
    pCBRout := NIL;
    system := sys;
    art := daUNKNOWN;
    lzMessen := (llzMessen=cMESSEN);
    fLinkTxDest := lfLinkTxDest;
    redirectPID := lredirectPID;
    FOR i := 1 TO maxLZMESS DO tLz[i]:=0;
    tSchnitt := 0;
    tOur := 0; tThem := 0;
    startZeit := 0;
    {* Messrate bestimmen. Z.Zt im Minutentakt ! *}
    sekInit := 5*60; {* 5 Minuten *}

    sekBisMess := sekInit; {* Damits direkt losgeht *}
    isOpt := TRUE;         {* Davon gehen wir erst mal aus *}
    lastLZat := 0;
    END; {* with *}

  {* Test auf Endlosschleife *}
  i := 1; j := linkNr;
  WHILE (NOT link[j].direkt) AND (i < 2*MaxLinks) DO
    BEGIN
    j := link[j].PortNr;
    Inc (i);
    END;

  IF NOT link[j].direkt
    THEN BEGIN {* Fehler: Linkschleife *}
         MakeLink := FALSE;
         link[linkNr] := linkZwisp;
         END
    ELSE BEGIN
         IF fLZMessungen AND link[linkNr].lzmessen THEN TryToStartLZMess ( linkNr );
         MakeLink := TRUE;
         END;
END;



PROCEDURE SetLinks ( pCB : TP_AXCB; sArg : STRING);
{*  LINK [ADD|INS|DEL] [ZIEL <Ziel>] [VIA <call>] [PORT <wert>]  [NR <nr>]
 *       [HIDDEN|PUBLIC] [[NO]MEASURE]] [MAXSSID <ssid>] <text>
 *  link add ziel db0qt port 1  "Mayen bei Koblenz"
 *  link add ziel db0lj via db0qt  Kruft
 *  l a z db0zdf v db0qt "ZDF,Mainz"
 *}
 CONST COMANDS =
 'ADD INS DEL PORT ZIEL VIA HIDDEN PUBLIC MEASURE NOMEASURE ' +
 'NETROM FLEXNET TCPIP BOX NR CHG LIST MAXSSID TXDEST NOTXDEST ' +
 'REDIRECTPID '; {* Letzte Leerzeichen ist wichtig ! *}
CONST cmLIST=17; cmMAXSSID=18; cmTXDEST=19; cmNOTXDEST=20;
      cmREDIRECTPID=21;
      cmdTab : ARRAY [1..length(COMANDS)] OF CHAR = COMANDS;
  VAR i       : BYTE;
      MaxSSID,
      LinkNr,
      PortNr  : WORD;
      modus   : (ins,del,CHG,NULL);
      sBeschreibung,
      viaCall,
      zielCall : STRING;
      lzMessen : T_MESSEN;
      lfLinkTxDest:BOOLEAN;
      hidden   : T_HIDDEN;
      sys      : t_Digisystem;
      redirectPID : WORD;
BEGIN
  PortNr := NOTANUMBER;
  LinkNr := NOTANUMBER;
  MaxSSID := NOTANUMBER;
  sys := dsNIL;
  hidden := cNILHID;
  redirectPID := 0;
  lzMessen :=  {$IFDEF userware} cNICHTMESSEN
               {$ELSE}  cNILMESS
               {$ENDIF};
  lfLinkTxDest := TRUE;
  zielCall := ''; viaCall := '';
  sBeschreibung := '';
  modus := NULL;
  REPEAT
    i := ScanStr (sArg, @cmdTab, sizeOf (cmdTab));
    CASE i OF
       1,2: modus := INS; {* INS *}
         3: modus := DEL; {* DEL *}
         4: portnr := ScanForNum ( sArg );
         5: ScanForText ( sArg,zielCall );
         6: ScanForText ( sArg,viaCall );
         7: hidden := cHIDDEN;
         8: hidden := cPUBLIC;
         9: lzMessen := cMESSEN;
        10: lzMessen := cNICHTMESSEN;
        11: sys := dsNETROM;
        12: sys := dsFLEXNET;
        13: sys := dsTCPIP;
        14: sys := dsBOX;
        15: BEGIN
            linkNr := ScanForNum (sArg);
            IF (LinkNr > maxLinks) OR (LinkNr<1) THEN LinkNr := NOTANUMBER;
            END;
        16: modus := CHG;
   cmTXDEST:lfLinkTxDest := TRUE;
   cmNOTXDEST
          : lfLinkTxDest := FALSE;
   cmLIST : BEGIN
            modus := NULL;
            i := 0;
            END;
   cmMAXSSID
          : BEGIN
            maxSSID := ScanForNum (sArg);
            IF (maxSSID<0) OR (MAXSSID>15) THEN MaxSSID := NOTANUMBER;
            END;
   cmREDIRECTPID
          : BEGIN
            redirectPID := ScanForNum (sArg);
            IF (redirectPID<0) OR (redirectPID>255) THEN redirectPID := 0;
            END;
      END;
  UNTIL (i = 0);

  IF Modus = NULL THEN
    BEGIN
    ListLink (pCB, f_Upper (sArg));
    Exit;
    END;

  IF sArg <> '' THEN ScanForText (sArg, sBeschreibung);
  IF (modus = INS) THEN
    IF (zielCall <> '' )
      THEN BEGIN
           IF sys = dsNIL THEN sys := dsAndere;
           IF hidden = cNILHID THEN hidden := cPUBLIC;
           IF lzMessen = cNILMESS THEN lzMessen := cMESSEN;
           IF MakeLink ( portnr, ZielCall, viaCall, sBeschreibung,
                         maxssid,sys,hidden,lzMessen,lfLinkTxDest,redirectPID )
              THEN TX_EolSysInfo (pCB, SPAETER, 'LINK stored' )
              ELSE TX_EolSysInfo (pCB, SPAETER, 'can''t store LINK' )
           END
      ELSE TX_EolSysInfo (pCB, SPAETER, 'LINK ADD: wrong Parameter' );

  IF (modus = CHG) THEN
    IF (linkNr <> NOTANUMBER) AND (link[linkNr].Valid)
       THEN BEGIN
            IF PortNr   <> NOTANUMBER THEN
               IF Link[linknr].direkt THEN link[linkNr].portnr := portnr;
            IF maxSSID  <> NOTANUMBER THEN link[linkNr].ssid_bis := MAXSSID;
            IF sys      <> dsNIL      THEN link[linkNr].system := sys;
            IF hidden   <> cNILHID    THEN link[linkNr].hidden := (hidden=cHIDDEN);
            IF lzMessen <> cNILMESS   THEN link[linkNr].lzMessen := (lzMessen=cMESSEN);
            IF zielCall <> ''         THEN AscCall2shift ( f_upper(zielcall), link[linkNr].Call);
            TX_EolSysInfo (pCB, SPAETER, 'link changed' );
            END
       ELSE TX_EolSysInfo (pCB, SPAETER, 'link chg: wrong param.' );

  IF (modus = DEL) THEN
    IF (linkNr <> NOTANUMBER) AND (link[linkNr].Valid)
       THEN IF DelLink (LinkNr)
              THEN TX_EolSysInfo (pCB, SPAETER, 'linkentry deleted' )
              ELSE TX_EolSysInfo (pCB, SPAETER, 'can''t delete this linkentry' )
       ELSE TX_EolSysInfo (pCB, SPAETER, 'link del: wrong param.' );
END;


{}

FUNCTION LinkPort2IfNr ( x : BYTE ) : T_IFNR;
  {* Wandelt die Nr. eines Links in die zugeh. ifnr um *}
BEGIN
  WHILE NOT link[x].direkt DO  x := link[x].PortNr;
  LinkPort2IfNr := link[x].PortNr;
END;

FUNCTION LinkNr2LUAscCall ( LinkNr : Byte) : STRING;
  {* LinkNr to Lower Upper Ascii Call *}
BEGIN
  IF (link[linkNr].system <> dsFLEXNET)
    THEN LinkNr2LUAscCall := F_lower(f_sh2asc ( link[linkNr].Call ))
    ELSE LinkNr2LUAscCall :=         f_sh2asc ( link[linkNr].Call );
END;

FUNCTION LinkPort2Via ( x : BYTE; modus : t_lpvMode ) : STRING;
  {* Gibt den via Weg zurck, der ber LINK[x] gehen soll,              *}
  {* Token6 ist gesetzt beinem speziellen Aufruf durch die FlexMatshine *}
  VAR v : STRING;
      count : BYTE;
      cTrenn : CHAR;
BEGIN
  v := '';
  IF modus=cNORMAL THEN cTrenn := ','
                   ELSE cTrenn := ' ';
  {* via weg zusammenbasteln - hoffentlich ist die Linktabelle schleifenfrei..*}
  {* Der erste bzw. ist es ja der Letzte im Linkweg wird *normalerweise* }
  {* bersprungen - wir kennen ihn ja schon. *}
  IF modus<>cTOKEN6TX THEN IF NOT Link[x].direkt THEN x := link[x].PortNr;
  count := 0;
  WHILE (NOT Link[x].direkt) AND (count<9) DO
     BEGIN
{sac}     v := LinkNr2LUAscCall(x) + cTrenn + v;
     IF length (v) > 100 THEN RunError (ERR_LINK_TBL_LOOP); {* kommt nicht wieder *}
     x := link[x].PortNr;
     Inc (count);
     END;
  v := LinkNr2LUAscCall(x) + cTrenn + v ; {* und das ist nun der DirektNachbar *}
  IF v [Length(v)] = cTrenn THEN Dec (Byte(v[0]));
  LinkPort2Via := v;
END;


PROCEDURE LinkPort2ViaShPath ( x : BYTE; VAR ret : T_shPath);
  {* Gibt den via Weg zurck, der ber LINK[x] gehen soll *}
  VAR n,zx : WORD;
BEGIN
  {* Erst mal zhlen, wieviele Digis im Weg sind *}
  n := 0; zX := x;
  WHILE (NOT Link[zx].direkt) AND (n<=nShPathDIGIS) DO
    BEGIN
{sac}    IF n > nShPathDIGIS THEN RunError (ERR_LINK_TBL_LOOP); {* kommt nicht wieder *}
    zx := link[zx].PortNr;
    Inc (n);
    END;
  IF n > nShPathDIGIS THEN RunError (ERR_LINK_TBL_LOOP); {* kommt nicht wieder *}
  {* Insgesamt n Digis *}
  {* Und nun via weg zusammenbasteln *}
  ret.ilDigi := n;
  FOR zx := n DOWNTO 1 DO
     BEGIN
     ret.Digi[zx] := link[x].Call;
     x := link[x].PortNr;
     END;
  ret.Digi[0] := link[x].Call; {* und das ist nun der Direkteinstieg *}
  ret.iFnr  := link[x].PortNr;
  ret.nMyCall := 0;
END;

PROCEDURE Send6Token (pCB : TP_AXCB; linkNr : BYTE; destCall : STRING;
                     fWithTrace : BOOLEAN);
  {* Sende auf Link LINKNR eine Anfrage nach DESTCALL. *}
  {* Antwort bitte an pCB                              *}
  VAR s, v : STRING;
      ifnr : T_IFNR;
      x, count : BYTE;
BEGIN
 ifnr := LinkPort2IfNr(linknr);
 v := '';
 {* via weg zusammenbasteln - hoffentlich ist die Linktabelle schleifenfrei..*}
 count := 0; x:= linknr;
 REPEAT
   IF (link[x].system <> dsFLEXNET)
      THEN v := f_lower(f_sh2asc ( link[x].Call )) + ' ' + v
      ELSE v := f_sh2asc ( link[x].Call ) + ' ' + v;
   IF link[x].direkt THEN count := 25 {* abbrechen Schleife *}
                     ELSE x := link[x].PortNr;
   Inc (count);
 UNTIL (count>8);

 s := '6!'+F_using(pCB^.Id,5)
      + f_sh2asc(link[linknr].pCBRout^.fromCall) {* Das enthlt dann auch die richtige SSID *}
      + ' '
      + v                    {* hat abschliessendes Space *}
      + destCall;            {* nicht klar ob EOL erforderlich ! *}
 IF fWithTrace THEN s[3] := '`';
 TX_Info( link[linknr].pCBRout, SOFORT, s);
 IF routBeaconPort <> 0 THEN
   TxBeacon ( RoutBeaconPort, axIFace[1].asMyCall,'ROUTE','', 'T'+s+Eol, cMELD);
END;


FUNCTION CheckLinkPath (pCB: TP_AXCB) : BYTE;
 {* Testet, ob in pCB^ der Pfad eines Links eingetragen ist, so   *}
 {* wie er in der Link Tabelle steht. Wenn ja, wird der Index des *}
 {* Links zurckgegeben (<>0), ansonsten 0. Wird in OpenInfoBox gebraucht. *}
  VAR i,x,iDig,testssid : BYTE;
BEGIN
  CheckLinkPath := 0;
  FOR i := 1 TO MAXLINKS DO WITH link[i] DO
    IF valid THEN
{*   IF pCBRout=nil THEN  *}
      IF MemEq ( @pCB^.toCall, @Call, 6 ) THEN
       {* Test ob es auch an MyCALL ging (und nicht etwa das Ident) *}
       IF MemEq ( @pCB^.fromCall, @axIFace[pCB^.iface].Call, 6 ) THEN
        BEGIN
        testSSID := (byte(pCB^.tocall[7]) DIV 2) AND 15;
        IF (testssid=SSID_von) THEN {* SSID des Partners mu dem low-Eintrag in der LinkListe entsprechen *}
         {* eigene angepollte SSID muss auch genau meine sein *}
         IF ((byte(pCB^.fromcall[7]) DIV 2) AND 15)=MyFlexMinSSID THEN
           BEGIN
           {* Nun Kontrolle, ob QSO-Pfad exakt gleich wie im Linkeintrag: *}
           x := i; iDig := 1;
           WHILE NOT link[x].direkt AND (iDig<=pCB^.nDigi) DO
             BEGIN
             x := link[x].PortNr;
             IF NOT CmpShCallSSID ( @pCB^.Digi[iDig], @link[x].call ) THEN iDig := 20-1; {* Schleifenabbruch *}
             Inc(iDig);
             END;
           IF (iDig=pCB^.nDigi+1) AND          {* Weg stimmt *}
              (link[x].Portnr=pCB^.iface) THEN {* Port stimmt *}
                BEGIN {* Erfolg *}
                CheckLinkPath := i;
                i := MAXLINKS;
                END;
           END
        END
END;

{}

PROCEDURE SetAndCalcLZ ( pCB : TP_AXCB; t : Longint; kor : T_KORREKTUR );
  {* Setzt und berechnet die Laufzeit fr den Link mit dem LinkQSO-Block pCB *}
  VAR i, n : BYTE;
      schnitt : Longint;
BEGIN
IF (t > lzERROR) THEN t := lzERROR;
WITH pCB^.Divers.pLink^ DO
  BEGIN
  IF kor = cNEU THEN FOR i := maxLZMESS-1 DOWNTO 1 DO tLz[i+1] := tLz[i]; {* Tabelle nach rechts schieben *}
  tlz[1] := t;
  n := maxLZMESS;  schnitt := 0;
  FOR i := 1 TO maxLZMESS DO
    IF tLz[i] = 0 THEN Dec(n) {* 0 "Messungen" zhlen nicht *}
                  ELSE IF tLz[i] = lzERROR
                         THEN IF i < 4 THEN Inc (schnitt, 600)
                                       ELSE Dec(n) {* Alte Fehlversuche zlen nicht *}
                         ELSE Inc (schnitt, tlz[i]);
  IF (n = 0) OR (tLZ[1]=lzError)
    THEN tSchnitt := lzERROR
    ELSE BEGIN
         schnitt := schnitt DIV n;
         tSchnitt := schnitt;
         END;
  END;
END;

{$IFDEF asdasdsad * $OPT}
PROCEDURE SetSekInit;
  {* Dynamisches errechnen der Messrate *}
BEGIN
  sekinit := ((LZ des Links in 100ms ) div 42 + 1) * 60;
  IF sekinit  > 5*60 then sekinit := 5*60;
END;
{$ENDIF}



{$F+}
PROCEDURE fnMsgLaufZeitSABMUA ( pCB : TP_AXCB; msg : T_Msg);  {$IFnDEF AllFar} {$F-} {$ENDIF}
  {* Hier sollen alle Msg. die von LZM-QSOs stammen auflaufen *}
  VAR zeit : LONGINT;
BEGIN
  IF NOT CheckAxcB (pCB, cSTORE) THEN Exit;
  CASE msg OF
    msgReconnect,
    msgConnectSuccess
     : BEGIN
       zeit := fastTick;  {* Sofort die Zeit nehmen *}
       WITH pCB^.Divers.pLink^ DO
	 BEGIN
	 {* Immer aufrunden, damit LinkZeit nie Null wird *}
	 SetAndCalcLZ (pCB, (zeit-startZeit) DIV 10 + 1, cNEU);
         StartTimer (pCB^.tTimeOut); {* Timer Restarten *}
	 {* Hier drfen wir noch kein PID240 Testpaket schicken;   *}
	 {* ein FLX-fhiger Partner wre ob dieser PID verwirrt    *}
	 {*  und wrde uns flschlicherweis' als Dummdigi bewerten+abwerfen *}
	 startZeit := 0;  {* Eigentliche Messung ist beendet *}
	 END; {* WITH *}
       END;

    msgRx   {* Der Partner hat was geschickt, entweder InfoText, oder L3 Reset *}
     : WITH pCB^.Divers.pLink^ DO
	 BEGIN
	 {* Hier knallts manchmal! *}
	 StopTimer (pCB^.tTimeOut); {* es kam ja was an, Timeout wird nicht mehr bentigt *}
	 IF (pCB^.PID = PID_FLEXNET) AND useFlexNet
	   THEN BEGIN  {* OK, der andere kann Flexen - alles weitere in FD_FLEX *}
		tOur := tSchnitt;
		InitFlexRoutingQso ( pCB,
				     TRUE {* = WIR haben Connected *},
				     pCB^.Divers.pLink^.Id );
		END
	   ELSE BEGIN
		{* Der andere ist doch kein Flexnet, bzw. macht es nicht mit uns *}
		art := daANDERE;
		{* Test ob Strecke luft, wenn nicht, fliegen wir raus   *}
		{* Ausserdem wird so eine Antwort vom Nachbar provoziert *}
		Tx_Info (pCB,SOFORT,f_RepChar (240,' ')+CR);
		IF system = dsFlexNet THEN
		  BEGIN {* Tja, das ist wohl keiner mehr (staun) *}
		  system := dsANDERE;
		  art := daANDERE;
		  END;
		{* Es ist nur ein Dummi, aber er schickte Text: addieren *}
                {* wir also mal was drauf (nderung darf wg. optimal-Prinzip nicht zu gro sein *}
		SetAndCalcLZ (pCB, tLz[1]+10, cKORREKTUR );
		SetzeNachbarLinkZeit ( id, tSchnitt );
		pCBRout := NiL;
		pCB^.fMsgHandler := fnMsgDefault;
		DoDisconnect (pCB); {* und tsch *}
		sekBisMess := sekInit;
		END;
	   END; {* WITH *}

    msgTimeOut   {* Timeout, weil kein Connect, kein CText oder kein L3-Reset kam *}
     : IF pCB^.state <> connected
        THEN BEGIN
             fnMsgLaufZeitSABMUA(pCB,msgRetryCountExceeded); {* ist ja irgendwie dasselbe... *}
             DoDisconnectImm(pCB);
             END
        ELSE WITH pCB^.Divers.pLink^ DO
	 BEGIN
	 {* Man knnte nun die ursprnglich gemessene Zeit mal 3 nehmen (es *}
         {* ist ja ein Dummdigi ohne CText) aber dann kommt evtl ein RMNC  *}
         {* und meldet was besseres. Also nur kleine nderung *}
         SetAndCalcLZ (pCB, tLz[1] + 13, cKORREKTUR );
	 SetzeNachbarLinkZeit ( id, tSchnitt );
	 sekBisMess := sekInit; {* Zeitpunkt nchste Messung festlegen *}
	 pCB^.fMsgHandler := fnMsgDefault; {* Damit nicht nochmal was hier landet *}
	 pCBRout := NiL;
	 DoDisconnect(pCB);
	 END;

    msgRxDM,
    msgDiscReq
     : WITH pCB^.Divers.pLink^ DO
	 BEGIN {* Link ist wohl in Ordnung, nur der Nachbar will nicht *}
	 IF startzeit = 0 {* warten wir auf einen Text? *}
	    THEN SetAndCalcLZ (pCB, tLz[1] * 3, cKORREKTUR ) {* ja *}
	    ELSE SetAndCalcLZ (pCB, 3*((FastTick-Startzeit) DIV 10+1),cNeu );
	 SetzeNachbarLinkZeit ( id, tSchnitt );
	 startzeit := 0; {* Sonst kommt er hinten nicht mehr hoch *}
	 sekBisMess := sekInit;
	 pCBRout := NiL;
	 pCB^.fMsgHandler := fnMsgDefault; {* Damit nicht nochmal was hier landet *}
	 END;

    msgCBDel,
    msgRetryCountExceeded
     : WITH pCB^.Divers.pLink^ DO
	 BEGIN {* Verbindung kam gar nicht zustande (SABM erfolglos) oder riess nach dem UA ab *}
	 SetAndCalcLZ (pCB, lzERROR, cNeu );
	 SetzeNachbarLinkZeit ( id, 0 );
	 startZeit := 0;
	 sekBisMess := sekInit;
	 pCBRout := NiL;
	 pCB^.fMsgHandler := fnMsgDefault; {* Damit nicht nochmal msgDISCREQ hier landet *}
	 END;

     ELSE fnMsgDefault ( pCB,msg );
   END; {* CASE *}
END;



PROCEDURE TryToStartLZMess ( i : WORD );
  {* Startet die LZ-Messung zum Dummdigi aus Link[i] *}
  {* (der sich als Flex erweisen knnte)             *}
  VAR pWork,
      pLinkE : TP_Link;
      v      : STRING;
BEGIN
{$IFnDEF LZM}  Exit;
{$ENDIF}
  pLinkE := @link[i]; {* Handlich... *}
  pWork := pLinkE;
  v := ''; {* via-Weg zusammenbasteln - die Linktabelle ist schleifenfrei *}
  WHILE NOT pWork^.direkt DO
    BEGIN
    v := f_sh2asc (link[ pWork^.portNr ].Call ) + ',' + v;
    pWork := @link[pWork^.portNr];
    END;
  IF v [Length(v)] = ',' THEN Dec (Byte(v[0]));
  {* Der Weg steht nun in v *}

  {* Die Messung ist incl. TryToConnect etc. -    *}
  {* einem User ergeht es ja auch nicht anders ...*}
  pLinkE^.Startzeit := fastTick; {* Beginnzeit festhalten *}
  pLinkE^.pCBRout := {* Eigenes Call muss mit der kleinsten akzeptierten SSID des MyCalls beginnen *}
                     {* Try2Connect geht NICHT ber den Autorouter *}
        Try2Connect ( pWork^.PortNr, {* WICHTIG: pWORK ist hier RICHTIG - er zeigt auf den tatschlichen Weg! *}
                      axIFace[pWork^.PortNr].asMyCall+'-'+FStr(MyFlexMinSSID),
                      f_sh2asc (pLinkE^.Call),
                      v, cNOINCSSID );
  WITH pLinkE^ DO
      IF pCBRout = NiL
        THEN pLinkE^.startZeit := 0  {* War wohl nix mit conncten *}
        ELSE BEGIN
             lastLZat := SlowTick;
             WITH pCBRout^ DO
               BEGIN
               retry := 5;
               Divers.pLink := pLinkE; {* Selbstverweis *}
               fMsgHandler := fnMsgLaufZeitSABMUA;
               QsoType := qtNULLQSO; {* Steht ja noch nicht *}
	       {* Timer starten damit nicht endlos auf UA gewartet wird *}
               {* Wichtig, wenn Port blockiert ist und keine SABMs TXt werden! *}
	       tTimeOut.tickinit := lmMESSTIMEOUTSEK * 100;
	       StartTimer (tTimeOut);
               END;
             END;
END;

PROCEDURE DoEvery16sLink;
  {* Wird alle 32s aus der Hauptschleife her aufgerufen *}
  VAR i: WORD;
BEGIN
  IF NOT fLZMessungen THEN Exit; {* Laufzeitmessungen sind ganz abgeschaltet *}
  FOR i := 1 TO nLinks DO WITH link[i] DO
    IF valid AND lzMessen THEN
      IF (pCBRout <> NiL) AND (pCBRout^.qsoType = qtFlexRouter)
        THEN LinkStelle3FramesZusammen(i);
END;


PROCEDURE DoEveryMinuteLink;
  {* Wird jede Minute ($TODO ) aus der Hauptschleife *}
  {* her aufgerufen und init. die Laufzeit-Messungen *}
  VAR i: WORD;
BEGIN
  IF NOT fLZMessungen THEN Exit; {* Laufzeitmessungen sind ganz abgeschaltet *}

  FOR i := 1 TO nLinks DO WITH link[i] DO
    IF valid AND lzMessen AND (startZeit = 0) THEN {* gltiger Eintrag, Messen erwnscht & noch nicht am laufen *}
      BEGIN
      IF sekBisMess <= 0 THEN
        BEGIN
        sekBisMess := sekInit; {* Schon mal wieder setzen *}
        IF (pCBRout <> NiL) AND (pCBRout^.qsoType = qtFlexRouter)
            THEN BEGIN {* FlexNet-QSO *}
                 IF CheckAXCB(pCBRout, cSTORE)
                   THEN SendTestPacket( link[i].pCBRout ) {* QSO besteht *}
                   ELSE BEGIN           {* Debug gescheitert *}
                        LogAddEntry (NiL, leFlexCB, FStr (i) );
                        pCBRout := Nil; {* Ist ja nicht gltig. *}
                                        {* Kein guter Stil, aber.... *}
                        END
                 END
            ELSE TryToStartLZMess ( i ); {* Dummdigi, oder nicht bekannt *}
        END;
      Dec (sekBisMess,60);
      END;
END;


{}

BEGIN
  nLinks := maxLinks; {* $TODO nLink als dynamische Obergrenze *}
  FillChar ( Link, sizeof(Link),#0);
  MemGet (pointer(paZiel), sizeOf(paZiel^) );
  FillChar ( paZiel^, sizeof(paZiel^),#0);
END.

