;*****************************************************************
;* Timersteuerung der einzelnen SCC-Kanle auf FALCon-25         *
;* Die einzelnen Prozeduren werden via Tabelle in Abhngigkeit   *
;* vom l1_state angesprungen. Die Tabellen verfgen ber jeweils *
;* 8 Eintrge fr Zustnde. Nicht belegte Zustnde werden auf    *
;* ein Return gelenkt.                                           *
;* Die einzelnen Kanle werden als Macro implementiert, um       *
;* eine feste Adressenbelegung zu bekommen.                      *
;*****************************************************************
	     .186                           ;fr 186er Prozessor
	     locals                         ;lokale Labels erlauben
	     warn                           ;Warnungen ein
	     .model tpascal
	     include  fd_sdlc.inc           ;Pufferdefinitionen Level 1/2
             include  fd_v25.inc            ;V25-Ports
             include  fd_iscc.inc           ;SCC-Ports

             public   scc_timer

             .code
             jumps

;**************
;* Kanalmacro *
;**************
ch_timer     macro  CHAN,IFACE,SDLC,DMA
             local  timtab,txd_down,timer_end,dcd_on,dwait,dwait_fail
             local  free,free_dup,txd,ptt_watchdog,skipWatch

;*****************************************************************
;* Tabelle der acht lokalen Entrittsoffsets fr die Zustandsfkt. *
;* Die Zustnde DCD an und DWAIT werden nur bei Simplex benutzt. *
;*****************************************************************
             mov    bx,word ptr DATA:[IFACE.l1_state] ;Zustand holen
             and    bx,7                    ;Modulo 8
             shl    bx,1                    ;16 Bit Offsets
             jmp    word ptr cs:[timtab+bx] ;Ansprung

timtab:      dw     offset timer_end        ;Zustand 0 (NOP)
             dw     offset dcd_on           ;Zustand 1 (DCD an)
             dw     offset dwait            ;Zustand 2 (DWAIT)
             dw     offset free             ;Zustand 3 (Free)
             dw     offset txd              ;Zustand 4 (TXD)
             dw     offset ptt_watchdog     ;Zustand 5 (DAT)
             dw     offset timer_end        ;Zustand 6 (--)
             dw     offset timer_end        ;Zustand 7 (--)

dcd_on:      ;*** State 1 *** DCD war vorher an bei Eintritt
             in     al,[SDLC+RD0]           ;Status SCC lesen
             test   al,08h                  ;DCD noch an ?
             jnz    timer_end               ;ja -> direktes Ende
             mov    byte ptr DATA:[IFACE.l1_state],ZUST_DWAIT ;nun DWAIT abwarten
             mov    byte ptr [IFACE.ch_free],TRUE             ;Kanal ist frei
             mov    ax,word ptr DATA:[IFACE.slot]             ;Slottinme holen
             mov    word ptr DATA:[IFACE.chan_time],ax        ;Timer dann neu setzen
             or     ax,ax                   ;Slottime = 0 ?
             jnz    timer_end               ;nein -> Timerfunktion Ende (DWAIT muss abgewartet werden).
             mov    word ptr DATA:[IFACE.chan_time],1  ;fr Start

dwait:       ;*** State 2 *** DWAIT lief vorher
             in     al,[SDLC+RD0]           ;Status SCC lesen
             test   al,08h                  ;DCD noch aus ?
             jnz    short  dwait_fail       ;nein wieder angegangen
             dec    word ptr DATA:[IFACE.chan_time]  ; sonst Zeit - 1
             jnz    timer_end               ;Ende falls DWAIT nicht abgelaufen
             mov    byte ptr DATA:[IFACE.l1_state],ZUST_FREE;bereit zum Senden
             jmp    short  free             ;prfen auf Sendestart

dwait_fail:  mov    byte ptr DATA:[IFACE.l1_state],ZUST_DCD ;erneut mit Senden warten
             mov    word ptr DATA:[IFACE.chan_time],0       ;Reset Timer
             mov    byte ptr [IFACE.ch_free],FALSE          ;Kanal ist belegt
             jmp    timer_end               ;und Ende

free:        ;*** State 3 *** Kanal war vorher frei und Dwait ist abgelaufen
             ;* Im Duplexmodus wird der Sender IMMER durch Kicktx() gestartet
             ;* und NIEMALS durch den Timer !
             cmp    byte ptr DATA:[IFACE.duplex],DUP_MODE   ;Vollduplex ??
             jz     timer_end               ;ja kicktx ist zustndig
             in     al,[SDLC+RD0]           ;Status SCC lesen
             test   al,08h                  ;DCD noch aus ?
             jnz    short dwait_fail        ;nein wieder angegangen(!)
             les    si,dword ptr DATA:[IFACE.txqueue.hd] ;Anfang der Kette holen
             mov    ax,es                   ;berhaupt was zu senden da?  (TXROOT = NiL ?)
             or     ax,si                   ;
             jz     timer_end               ;ja nix drin -> Ende

             ;* hier angekommen ist nun der Sender einzuschalten
             ;* und das TXD abzuwarten
             ;* Das Herunterzhlen von TXD wird durch CTS freigegeben !
             ;* Die DMA wird bereits initialisiert!
             _cli                           ;temporr sperren
             mov    al,byte ptr DATA:[IFACE.wr15_tx] ;TX-IE Register
             out    [SDLC+WR15],al          ;setzen (wegen DCD,CTS..)
             mov    al,WR3_MODE             ;Modus Empfnger
             out    [SDLC+WR3],al           ;aus
             xor    ax,ax                   ;Empfangs-DMA
          if (CHAN and 1) eq 0
             out    [DMA+RDCRA0],ax         ;abbrechen
          else
             out    [DMA+RDCRB0],ax         ;abbrechen
          endif
             mov    ax,word ptr DATA:[IFACE.fak_tx] ;TX-Faktor holen
             out    [SDLC+WR12],al          ;Low Byte
             mov    al,ah                   ;und
             out    [SDLC+WR13],al          ;High Byte umschalten
             _sti                           ;erstmal wieder freigeben
             les    si,dword ptr DATA:[IFACE.txqueue.hd] ;Anfang der Kette holen
             mov    ax,word ptr es:[si.bufl+0];untere 16 Bit
          if (CHAN and 1) eq 0
             out    [DMA+TDARA0],ax         ;Low Word der Adresse ausgeben
          else
             out    [DMA+TDARB0],ax         ;Low Word der Adresse ausgeben
          endif
             mov    al,byte ptr es:[si.bufl+2];obere 16 Bit
          if (CHAN and 1) eq 0
             out    [DMA+TDARA0+2],al       ;High Byte der Adresse ausgeben
          else
             out    [DMA+TDARB0+2],al       ;High Byte der Adresse ausgeben
          endif

             mov    ax,word ptr es:[si.inUse] ;Anzahl holen
          if (CHAN and 1) eq 0
             out    [DMA+TDCRA0],ax         ;Anzahl ausgeben
          else
             out    [DMA+TDCRB0],ax         ;Anzahl ausgeben
          endif

;- bis hier war alles doppelt! (seit: les si,dword ptr DATA:[IFACE.txqueue.hd] ;Anfang der Kette holen)

             _cli                           ;wieder keine Interrupts
             mov    cx,word ptr DATA:[IFACE.txd]       ;TXD holen
             mov    word ptr DATA:[IFACE.chan_time],cx ;und setzen
             mov    al,byte ptr DATA:[IFACE.wr5_tx]    ;Modus Register 5
;;;;         or     al,69h                  ;Parameter auer RTS und CTS
             out    [SDLC+WR5],al           ;setzen (= PTT an)
             mov    byte ptr DATA:[IFACE.l1_state],ZUST_TXD ;wir sind im TXD
             mov    byte ptr [IFACE.ch_free],FALSE ;Kanal ist belegt
             mov    al,80h                  ;Reset TX CRC
             out    [SDLC+WR0],al           ;ausgeben
             _sti                           ;wieder freigeben
             or     cx,cx                   ;TXD = 0 ?
             jnz    short timer_end         ;nein Ende
             mov    word ptr DATA:[IFACE.chan_time],1 ;Sofortstart bei TXD 0

txd:         ;*** State 4 *** TXD luft **
             ;*** ein inaktives CTS hlt das TXD an!, sofern TXD=0 ist **
             cmp    word ptr DATA:[IFACE.txd],0
             jne    short txd_down          ;TXD!=0 -> Normal zhlen
             in     al,[SDLC+RD0]           ;Status SCC lesen
             test   al,20h                  ;CTS aus ?
             jz     short timer_end         ;ja warten

txd_down:    dec    word ptr DATA:[IFACE.chan_time] ;Zhler - 1
             jnz    short timer_end         ;TXD noch nicht abgelaufen...
             _cli                           ;wegen TX/EOF
          if (CHAN and 1) eq 0
             mov    al,0C0h                 ;Enable TX-A DMA
          else
             mov    al,080h                 ;Enable TX-B DMA
          endif
             out    [DMA+CCAR],al           ;DMA starten
             mov    al,0C0h                 ;Reset Underrun Latch
             nop                            ;warten auf Transfer
             out    [SDLC+WR0],al           ;und Reset TX/EOM
             mov    byte ptr DATA:[IFACE.l1_state],ZUST_DAT ;Daten senden
             mov    word ptr DATA:[IFACE.chan_time],100*60 ; 1 Minute Watchdog.
             _sti                           ;wieder zulassen
             jmp    short skipWatch

ptt_Watchdog:                               ;schlgt nach x*10ms zu (max.11 Minuten)
             dec    word ptr DATA:[IFACE.chan_time] ;Zhler - 1
             jnz    short timer_end         ;auch warten
;-           Watchdog schlgt zu - kann aber lediglich den Statistik Zhler erhhen.
             Inc    word ptr DATA:[semL1.nPTTWatchDog&CHAN]
             mov    word ptr DATA:[IFACE.chan_time],100*60 ; Watchdog Zeit neu setzen
skipWatch:
             mov    al,0C0h                 ;Reset Underrun Latch
             nop                            ; test kw 6.2.97 - eigentlich ist das reseten hier dpch berflssig?
             out    [SDLC+WR0],al           ;und Reset TX/EOM

timer_end:                                  ;Ende der Timerfunktion
             endm                           ;Macro Ende

;**********************************
;* Timerroutine fr die SCC-Ports *
;* Wird alle 10 ms aufgerufen.    *
;**********************************
scc_timer    proc  far
             assume ds:DATA,es:nothing
             portena
             ch_timer 0,l2_parms0,SDLC1,DMA1
             ch_timer 1,l2_parms1,SDLC2,DMA1
             ch_timer 2,l2_parms2,SDLC3,DMA2
             ch_timer 3,l2_parms3,SDLC4,DMA2
             portdis
             ret                            ;Ende
             assume ds:nothing,es:nothing
scc_timer    endp


             end

