{$I FD_INCL.PAS}
{...$DEFINE lokDebug}
UNIT FD_KISS;

{* Ist fr KISS, SLIP, SMACK, FlexCRC und KISS-TNC anbindung zustndig *}

INTERFACE


{}

IMPLEMENTATION

USES FD_Def,
     FD_Div,
     FD_Subr,
     FD_mBuf,
     FD_Sysop,
     FD_CRC,
     FD_Mem,
     FD_Task,
     {$IFDEF SCC}  FD_TNC,
      {$ELSE}      FD_CRT,
     {$ENDIF}
     FD_Error;


Procedure FISSHAndler;forward;


CONST csMyName = 'KISS';
      cMAXTXANEINEMSTUECK = 500;

  CONST FEND = $C0;  {* KISS-Konstante: FrameEND *}
	FESC = $DB;  {* KISS-Konstante: FrameESCape *}
	TFEND= $DC;  {* KISS-Konstante: Transponiertes FrameEND *}
	TFESC= $DD;  {* KISS-Konstante: Transponiertes FrameESCape *}


TYPE T_CRCArt = ( caKISS,  {* Zwischen- oder Endzustand: reines KISS *}
	          caSMACK, {* Der Andere benutzt definitiv ein SMACK *}
		  caFLEX,  {* Bei 7WJ ist alles anders               *}
                  caSLIP   {* vielleicht kriegen wir das so hin :)   *}
      );
CONST crcArt2Str : ARRAY [ T_CRCART ] OF Str6 = ('KISS',  {plainKISS}
                                                 'SMACK',
                                                 'FlxCRC',
                                                 'SLIP');
      cFissMaxSize = BUFFSIZE;  (* eigentlich noch - Mwst - 1 Zusatz von CRC *)

TYPE  T_FISS = RECORD
          fValid      : BOOLEAN;
          bindnr      : WORD;     {* Index von self in bind[] *}
          ifacenr     : BYTE;     {* die DevNr des UP-Protokolls *}
          ProcRx1Char : TFN_RX1CHAR;
          ProcNRxCHAR : TFN_NRXCHAR;
          ProcTx1Char : TFN_TX1CHAR;
          ProcNTXChar : TFN_NTXChar;

          ProcRXPacketUp : TFN_RXPacketUp;
          {* TNC *}
          fTNC        : BOOLEAN;
           TXDELAY,
           PERSIST,
           SLOTTIME,
           TXTAIL : LONGINT;
           DUPLEX : BOOLEAN;
          {* fr CRC ... *}
          crcArt      : T_CRCArt; (* Standardverwendung FISS typ *)
          nRXByte,nTxByte, nPakete,
          nCrcOKSmack, nCrcFehlerSmack,
          nCrcOKFlex,  nCrcFehlerFlex,
          nTXOverFlow : Longint;
          {* Zustand, zum wiederholten Initialsieren SMACK/FlexCRC *}
          ResetPara   : ( rpNORX,   {* Noch wurde kein KISS RXt *}
                          rpDOIT,   {* bei nchster Gelegenheit neu initialisieren *}
                          rpDONE);  {* ok, alles gemacht, nicht mehr beachten *}
          CRC         : WORD;       {* Zwischenspeicher CRC in der IST        *}
          ComByte     : BYTE;       {* KISS-Kommandobyte *}
          TX_Root, Tx_Tail : TP_mBuf;

  (* Sendevariablen des FISS-Teils				     *)
  (* Im Zustand TX_IDLE wartet der Sender auf neue Frames IN tx_Root *)
  (* Whrend TX_DATA zeigt tx_Root auf das aktuelle Sendeframe.      *)
  (* FISS_TXcount gibt die noch zu sendende Anzahl an, FISS_TXptr    *)
  (* zeigt auf die aktuellen Sendedaten. FISS_TXmode gibt den typ der*)
  (* Aussendung an.						     *)
        TXstate : (TX_IDLE,TX_DATA,TX_END); (* Status FISS Sender *)
        TXcount : Word; (* Anzahl noch zu sendender Bytes bei TX_DATA *)
        TXptr   : Pointer; (* Zeiger auf aktuelle FISS-Sendedaten *)
        TXmode  : T_CRCArt; (* modus des FISS-Senders *)
        TXcrc   : Word; (* aktuelle TX-CRC *)
        (* Empfangsvariablen des FISS-Teils				     *)
        RXstate : (RX_FEND,RX_CMD,RX_DAT); (* warten auf FEND *)
        RXmode  : T_CRCArt; (* .... *)
        RXbuff  : tp_mbuF; (* aktueller Datenpuffer *)
        RXptr   : Pointer; (* Zeiger auf aktuelles Datum *)
        RXcrc   : Word;	(* aktuelle RX-CRC *)
        fRXesc   : BOOLEAN; (* Escape Zustand *)
        RXlen   : Word;	(* aktuelle Lnge *)
        (* sonstiges Variablen *)
        semFISSHandler : BOOLEAN; (* FISS_Handler noch nicht aufgerufen *)
      END;

CONST MAXFISS = 4;
VAR  fiss : ARRAY [1..MAXFISS] OF t_fiss;
     mapping : ARRAY [1..MAX_IFACE] OF BYTE; {hier steht die devnr fr die im Packet enthaltene Ifacenr drin }
                       {^^^      ^ das ist korrekt (ist ja reziprok) }

{ KISS }

PROCEDURE KISS_TXPacket_Dev( devNr : BYTE; pm : tp_mbuF );
{* Sende Routine *}
BEGIN
 IF (devNr <= MAXFISS) AND (devNr > 0) THEN WITH fiss[devNr] DO
   BEGIN
   pm^.next := NiL; (* sicher ist sicher *)
   _DI;
   IF tx_Root = NiL THEN tx_Root := pm	       (* Root neu setzen *)
		    ELSE tx_tail^.next := pm; (* an altes dran *)
   tx_tail := pm;  (* Tail neu setzen *)
   _EI;
   FISSHandler; (* Aufruf Handler *)
   END; {- WITH -}
END;

PROCEDURE KISS_TXPacket( pm : tp_mbuF ); Far;
  VAR devNr : BYTE;
BEGIN
  devNr := mapping[pm^.ifNr];
  KISS_TXPacket_Dev( devNr, pm );
END;

PROCEDURE Send_FISSKennung(lokFissNr:BYTE);
(* Ein Paket mit dem aktuellen CRC-Modus abschicken *)
  VAR pm : tp_mbuF;
BEGIN (* Send_FISSKennung *)
  pm := Get_mbuf(10);   (* Puffer holen *)
  pm^.discard := TRUE; (* kann weg nach Senden *)
  pm^.inUse   := 0;    (* Lnge 0 *)
  pm^.ifNr    := lokFissNr;
  pm^.ptTimer := NiL;
  pm^.next    := NiL;
  KISS_TXPacket_Dev(lokFissNr,pm); (* Senden *)
  Inc(Count[cntFISSKEnnung]);
END;  (* Send_FISSKennung *)


PROCEDURE TxPara (loknr : BYTE; what,wert : BYTE );
{* "PArameter senden" ist bei SMACK,FLEX-CRC und KISS gleich *}
BEGIN
WITH Fiss[loknr] DO IF fValid THEN if fTNC THEN
  BEGIN
  ProcTx1Char( Char(FEND) );
  ProcTx1Char( Char(what) );
  ProcTx1Char( Char(wert) );
  ProcTx1Char( Char(FEND) );
  END;
END;


PROCEDURE KISSTNC_PARA( devnr : WORD);
CONST sInitTnc : String = (
            ^Q + ^X + ^X + #27 + ' MN '  + #13+#10+  {Monitor lschen}
            ^Q + ^X + ^X + #27 + ' @K '  + #13+#10);
  VAR i : WORD;
BEGIN
  WITH fiss[devnr] DO IF fTNC THEN
    BEGIN
    FOR i := 1 TO length(sInitTnc) do ProcTx1Char( sInitTNC[i] );
    TxPara(devnr, 1, txdelay );
    TxPara(devnr, 2, persist );
    TxPara(devnr, 3, slottime);
    TxPara(devnr, 4, txtail  );
    TxPara(devnr, 5, ord(Duplex));
    END;
END;


{************************************************************************
 KISS        ::= FEND  Addr/Kommandobyte  Daten [crc] FEND
 Daten       ::= Bytefolge, in der FEND nicht vorkommt (--> TFEND)
 crc         ::= 2 Byte CRC, wenn im FlexCRC oder SMACK-Modus
 Addr/Kommandbyte
             ::= Wert   Bedeutung
                   0   Daten (KISS)
                   1   TXDELAY
                   2   PERSIST
                   3   SLOTTIME
                   4   TXTAIL
                   5   DUPMODE
                  13   L7-Daten (Wx-Test)
                   6-15 unbenutzt

                 Sonderfkt.:
                 ============
                x and $ff = 255   KISS Beenden
                x and $20 = $20   Daten (FlexCRC)
                x and $80 = $80   Daten (SMACK)
     (Kommandobyte SHR 4) AND 7   Devicenumber

       7 6 5 4 3 2 1 0
       ===============
       S d F d b b b b

**************************************************************************}


{$F+}
PROCEDURE FISS_Handler(fnr:BYTE);
{* Die Statusmaschine *}
  VAR txfree    : Integer; {bis 22.10.97: Word}
      w         : Word;
      pm	: tp_mbuF;
      nTxed,    {* Anzahl in einem Durchgang gesendeter Zeichen *}
      rxnum     : Word;
      b	        : Byte;
      fEnde, ok	: BOOLEAN;

  PROCEDURE FISS_TXbyte(b:Byte);
  BEGIN (* FISS_TXbyte *)
    WITH fiss[fnr] DO
      BEGIN
      Inc( nTXByte );
      Inc( nTxed );
      CASE b OF
        FEND : BEGIN
               ProcTx1Char(Char(FESC));
               ProcTx1Char(Char(TFEND));
	       Dec(txfree,2);
	       END;
        FESC : BEGIN
               ProcTx1Char(Char(FESC));
               ProcTx1Char(Char(TFESC));
	       Dec(txfree,2);
	       END;
        ELSE   BEGIN
	       ProcTx1Char(Char(b)); (* Byte ausgeben *)
	       Dec(txfree); (* ein zeichen weniger *)
	       END;
       END; (* CASE *)
    CASE fiss[fnr].TXmode OF
      caSMACK : TXcrc :=     (TXcrc shr 8) XOR
		    (crc_smack_table[(TXcrc XOR b) AND $FF]); (* SMACK-CRC *)
      caFLEX  : TXcrc := Word(TXcrc SHL 8) XOR
  	                 crc_flex[hi(TXcrc) XOR b]; (* Flex-CRC *)
      END; (* CASE crcArt *)
    END; {with}
  END;	(* FISS_TXbyte *)

{$R+}
BEGIN (* FISS_Handler *)
WITH fiss[fnr] DO
  BEGIN
  IF NOT fValid THEN Exit; (* nicht freigegeben *)
  _DI;
  IF semFISSHandler THEN
    BEGIN {- luft schon -}
    _EI;
    Exit;
    END;
  semFISSHandler := TRUE; (* Prozedur sperren *)
  _EI; (* Interrupts wieder erlauben *)

  WatchDog;
  (* Sender bearbeiten *)
  nTxed := 0;
  txfree := ProcNTXChar; (* Anzahl freier Zeichen Im Puffer *)
  WHILE (txfree >= 5) AND (nTxed < cMAXTXANEINEMSTUECK) DO
    BEGIN (* noch Platz *)
    IF TXstate = TX_IDLE THEN
      BEGIN (* TX_IDLE - wir senden gerade nichts *)
      IF tx_Root = NiL
        THEN txfree := 0 (* Ende, da nix zu Senden anliegt *)
        ELSE BEGIN (* neues Frame starten *)
             TXptr   := tx_Root^.pData; (* Zeiger *)
             TXcount := tx_Root^.inUse; (* Lnge *)
             {IF tx_Root^.txed=SUSPENDED THEN Goto L_nexttx;}
             ProcTx1Char(char(FEND)); (* Framestart *)
             Dec(txfree); (* Zhler - 1 *)
             {if tx_root^.h??? = xxx THEN <SLIP, nix senden, sofort in
                TX_DATA bergehen> else }
             CASE TXmode OF
	       caSMACK: BEGIN
			TXcrc := $0000; (* CRC-Init *)
			FISS_TXbyte($80); (* SMACK-Daten *)
			END;
	       caFLEX : BEGIN
			TXcrc := $ffff; (* CRC-Init *)
			FISS_TXbyte($20); (* FlexCrc-Daten *)
			END;
               caSLIP : ; {* Gar nix tuen *}
	       ELSE	  FISS_TXbyte($00); (* normaler Kiss *)
	       END; (* CASE *)
             IF TXcount <> 0 THEN TXstate := TX_DATA (* Daten Start *)
	                     ELSE TXstate := TX_END; (* Direktes Ende *)
             END;  (* neues Frame starten *)
	 END  (* TX_IDLE *)

	ELSE IF TXstate = TX_DATA THEN
	       BEGIN (* Daten senden *)
	       WHILE (TXcount <> 0) AND (txfree >= 2) DO
		 BEGIN
		 FISS_TXbyte(Byte(TXptr^)); (* Byte Senden *)
		 Inc(Word(TXptr)); (* Zeiger + 1 *)
		 Dec(TXcount); (* Anzahl - 1 *)
		 END;
	       IF TXcount = 0 THEN TXstate := TX_END; (* Ende der daten *)
	       END   (* daten Senden *)
	     ELSE {* richtig so? *}
		BEGIN (* CRC + FEND Senden *)
		w := TXcrc; (* CRC merken *)
		CASE TXmode OF
		  caSMACK: BEGIN (* SMACK-mode *)
			   FISS_TXbyte(lo(w)); (* Low Byte *)
			   FISS_TXbyte(hi(w)); (* High Byte *)
			   END;  (* SMACK-mode *)
		  caFLEX : BEGIN (* Flex-mode *)
			   FISS_TXbyte(hi(w)); (* High Byte *)
			   FISS_TXbyte(lo(w)); (* Low Byte *)
			   END;  (* Flex-mode *)
		END; (* CASE *)
                ProcTx1Char(char(FEND)); (* Ende des Frames *)
                Dec(txfree); (* ein zeichen weniger *)
		pm := tx_Root; (* Zeiger auf Frame *)
		_DI;
		tx_Root := tx_Root^.next; (* ein Frame weiter *)
		_EI;
		pm^.txed := TRANSMITTED; (* Frame wurde gesendet *)
		IF pm^.ptTimer <> NiL THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE; (* umhngen *)
		IF pm^.discard THEN
		  BEGIN {- Benutztes Frame in die gelbe Tonne -}
		  pm^.next := NiL; (* Ende der Liste *)
		  _DI;
		  IF lstDel.Root = NiL
         	     THEN lstDel.Root := pm (* send-Frame List Head *)
		     ELSE lstDel.Tail^.next := pm;
		  lstDel.Tail := pm;
		  _EI;
		  END;
		TXmode  := crcArt; (* neuer modus nach Frame *)
                WatchDog;
		TXstate := TX_IDLE;
	    END;  (* CRC + FEND Senden *)
    END; (* WHILE noch Platz *)

  IF nTxed >= cMAXTXANEINEMSTUECK THEN Inc(nTXOverFlow);

  {----------------------- Rx-Teil -------------------------------}

  WatchDog;
  rxnum := ProcNRxChar; (* Anzahl Zeichen im RX-Puffer holen *)
  WHILE rxnum <> 0 DO
   BEGIN (* ber alle RX-zeichen *)
   b := byte(ProcRx1Char); (* Zeichen holen *)
   Dec(rxnum); (* Anzahl Decrement *)
   Inc( nRXByte );
   REPEAT
     fEnde := true;
     CASE RXstate OF
       RX_FEND  : IF b = FEND THEN (* warten auf FEND *)
       		    BEGIN (* FEND da *)
		    RXstate := RX_CMD; (* auf Kommando warten *)
		    END;  (* FEND da *)
       RX_CMD   : IF b <> FEND THEN
		    BEGIN (* kein FEND *)
		    ok := TRUE;
		    CASE b OF {- b ist nun Adress&Kommandobyte -}
		      $00 : BEGIN (* normaler KISS *)
			    RXmode := caKISS; (* modus *)
			    END;  (* normaler FISS *)
		      $80 : BEGIN (* SMACK *)
			    RXmode := caSMACK; (* modus *)
			    RXcrc  := crc_smack_table[$80]; (* CRC Init *)
			    END;  (* SMACK *)
		      $20:  BEGIN (* Flex *)
			    RXmode := caFLEX; (* modus *)
                            {rxCrc := $FFFF;}
                            {RXcrc := Word(RXcrc SHL 8) XOR
					   crc_flex[ hi(RXcrc) XOR b];}
                            RXcrc := Word($FF00) XOR
					   crc_flex[ $ff XOR $20];
			    END;  (* Flex *)
		      $ff:  BEGIN (* KISS ausschalten *)
                            { $TODO ... was tun wir hier ? }
			    END;
                      ELSE IF (b)SHR 4 = $4 THEN
                            BEGIN
                            rxmode := caSLIP;
                            fEnde := false; {* sofort Statuswechseln) *}
                            END
                      ELSE IF (b and $0f) = 13 THEN
                            BEGIN {* Speziller Datenmodus *}
                            rxmode := caSLIP;
                            fEnde := false; {* sofort Statuswechseln) *}
                            END
                      ELSE ok := FALSE; (* Fehler *)
                    END; (* CASE b OF *)
		    IF NOT ok
		      THEN RXstate := RX_FEND (* erneut warten *)
		      ELSE BEGIN (* RX-Init *)
			   fRXesc   := FALSE; (* kein Escape *)
			   RXlen   := 0; (* Lnge 0 *)
			   RXptr   := RXbuff^.pData; (* Zeiger *)
			   RXstate := RX_DAT; (* daten kommen *)
			   END;  (* RX-Init *)
		   END;  (* kein FEND *)

       RX_DAT   : BEGIN (* daten *)
		  IF b <> FEND THEN
		    BEGIN (* weitere daten *)
		    IF fRXesc
                      THEN BEGIN (* Escaped *)
		           fRXesc := FALSE; (* Rcksetzen *)
		           IF         b = TFEND THEN b := FEND (* Umsetzen -> FEND *)
 			      ELSE IF b = TFESC THEN b := FESC (* Umsetzen -> FESC *)
			      ELSE BEGIN
		    	           RXstate := RX_FEND; (* Fehler *)
			           fRXesc   := TRUE;
			           END;
		           END   (* Escaped *)
                      ELSE IF b = FESC THEN fRXesc := TRUE; (* -> Escape *)
		    IF NOT fRXesc THEN
		      BEGIN (* eintragen *)
		      IF RXlen >= cFissMaxSize
                        THEN RXstate := RX_FEND (* Fehler, zu lang *)
		        ELSE BEGIN (* ok *)
		             Inc(RXlen);
			     Byte(RXptr^) := b;
			     Inc(Word(RXptr));
			     CASE RXmode OF
			       caSMACK: RXcrc := (RXcrc shr 8) XOR
					         (crc_smack_table[(RXcrc XOR b) AND $FF]); (* SMACK-CRC *)
                                caFLEX: RXcrc := Word(RXcrc SHL 8) XOR
					         crc_flex[ hi(RXcrc) XOR b];
			       END; (* CASE *)
			     END;  (* ok *)
		      END;  (* eintragen *)
		    END	(* weitere daten *)
               ELSE BEGIN (* Frameende: b = FEND *)
		    CASE RXmode OF
		      caSMACK : IF (RXcrc <> 0) OR (RXlen < 2)
                                  THEN BEGIN {* RX-Fehler *}
				       ok := FALSE;
				       Inc(ncrcFehlerSmack);
				       END
			          ELSE BEGIN (* Empfang ok *)
				       ok := TRUE; (* kein Fehler *)
				       Inc(ncrcOKSmack);
				       Dec(RXlen,2); (* Lnge Korrektur *)
				       END;  (* Empfang ok *)
		      caFLEX  : IF (RXcrc <> $7070) OR
  				   (RXlen < 2)
                                  THEN BEGIN
				       ok := FALSE ;
                                       Inc(nCrcFehlerFlex);
				       END
                                  ELSE BEGIN (* Empfang ok *)
                                       Inc(nCrcOKFlex);
				       ok := TRUE; (* kein Fehler *)
				       Dec(RXlen,2); (* Lnge Korrektur *)
				       END;  (* Empfang ok *)
		      ELSE BEGIN{case}
                           ok := (RXlen <= cFissMaxSize - 2); (* Lnge Test *)
                           Inc(nPakete);
                           END;
		      END; (* CASE RXmode OF *)

		    RXstate := RX_CMD; (* neuer Status *)
		    IF (crcArt <> RXmode) AND ok THEN
		      BEGIN (* Unterschiede global/lokal *)
 		      IF crcArt <> caKISS
                        THEN BEGIN (* falsches Frame *)
 			     (* Empfnger Sollmode Anzeigen *)
			     IF TXstate = TX_IDLE THEN TXmode := crcArt;
			     Send_FISSKennung(fnr); (* modus Anzeigen *)
			     ok := FALSE;
			     END (* falsches Frame *)
			ELSE crcArt := RXmode; (* neuer modus *)
 		      END;  (* Unterschiede global/lokal *)
		    IF ok THEN
		      BEGIN (* korrektes Ende *)
		      RXbuff^.inUse := RXlen; (* Lnge setzen *)
		      RXbuff^.ifNr  := ifacenr; (* INTERFACE *)
		      RXbuff^.next  := NiL;
		      _DI;
		      RXbuff^.time  := fastTick;
		      _EI;
                      WatchDog;
                      ProcRXPacketUp(RXBuff);
                      {* Neuen Buffer frs nchste Paket holen *}
		      RXbuff := GetL1Rxbuf;
		      END;  (* korrektes Ende *)
		    END; (* Frameende *)
                  END;  (* daten *)
	 END; (* CASE RXstate OF *)
        UNTIL fENDE;
       END;  (* ber alle RX-zeichen *)
  semFISSHandler := FALSE; (* Ende der Prozedur *)
  END;
END; (* FISS_Handler *)

{$F+}
PROCEDURE FISSHandler;{$F-}
  VAR i : BYTE;
BEGIN
  FOR i := 1 TO MaxFiss DO
    Fiss_Handler(i);
END;

{----------------------------}

PROCEDURE InitDevice(devNr:WORD);
  CONST INITLEN = 3; (* 3 Init Pakete *)
	INITTAB : ARRAY[1..INITLEN] OF T_CRCArt =
		   ({caSMACK,caSMACK,}caFLEX,caFLEX,caKISS); (* Init-Folge *)
  VAR b : Byte;
BEGIN
WITH fiss[devnr] DO
  BEGIN
  KISSTNC_PARA(devNr);
  IF RXbuff = NiL THEN
    BEGIN  {* Rx_Speicher allokieren *}
    RXbuff := GetL1RxBuf;
    END;
  RXbuff^.inUse := 0; (* kein zeichen da *)

  TXstate:= TX_IDLE; (* NOT busy *)
  RXstate:= RX_FEND; (* warten auf FEND *)
  fValid:= TRUE;
  FOR b := 1 TO INITLEN DO
    BEGIN (* Paketfolge Senden *)
    WHILE TXstate <> TX_IDLE DO FISS_Handler(devNr);
    IF crcArt = caKISS THEN TXmode := INITTAB[b] (* Anfangsfolge *)
                       ELSE TXmode := fiss[devNr].crcArt; (* bernehmen *)
    Send_FISSKennung(devNr); (* Paket Senden *)
    END;  (* Paketfolge Senden *)
  TXmode := crcArt; (* aktuellen crcArt setzen *)
  END;
END;

{}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}
        'INIT BIND SLIP TNC TXDELAY PERSIST SLOTTIME TXTAIL DUPLEX'
        + ' SIMPLEX FLEXCRC SMACK KISS ';
        cmINIT=1; cmBIND=2; cmSLIP=3; cmTNC=4;
        cmTXDELAY=5;  cmPERSIST=6; cmSLOTTIME=7; cmTXTAIL=8;
        cmDUPLEX=9;  cmSIMPLEX=10;
        cmFLEXCRC=11; cmSMACK=12; cmKISS=13;

        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   res,x,devNrDn : BYTE;
        sDn : STRING;
        p : Pointer;
        para : Longint;
BEGIN
WITH fiss[devnr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : {InitDevice(devNr);};
      cmSLIP : crcArt := caSLIP; {* SLIP erzwingen *}
      cmTNC  : fTNC := true;
      cmFLEXCRC
             : BEGIN
               crcArt := caFLEX;
               Send_FISSKennung(devnr);
               END;
      cmSMACK: BEGIN
               crcArt := caSMACK;
               Send_FISSKennung(devnr);
               END;
      cmKISS : BEGIN {* Damit man von SMACK und FlexCRC zurckschalten kann *}
               crcArt := caKISS;
               END;
      cmTXDELAY
             : txdelay := para;
      cmPERSIST
             : persist := para;
      cmSLOTTIME
             : Slottime := para;
      cmTXTAIL
             : TxTail := para;
      cmDUPLEX
             : DUPLEX := true;
      cmSIMPLEX
             : DUPLEX := false;
      cmBIND : BEGIN  {* z.B. BIND v24 2 *}
               ScanForText (sArg, sDn );
               devNrDn := ScanforNum(sArg);
               res := DoBind( csMyName,devnr, sDn, devNrDn );
               bindnr := res;
               IF res > 0 THEN
                 BEGIN
                 {* Hole die Routinen *}
                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpRX1CHAR) )
                 );
                 ProcRx1Char :=  TFN_RX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC,  ord(hpNRXCHAR) )
                 );
                 ProcNRXCHAR :=  TFN_NRXCHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpTX1CHAR) )
                 );
                 ProcTx1Char := TFN_TX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpNTXCHAR) )
                 );
                 ProcNTXCHAR :=  TFN_NTXCHAR(p);

                 InitDevice(devNr); {6.5.97}
                 END;
               END;
      END {Case}
  UNTIL x=0;
END;


CONST sReturn : STRING='';
{$F+}
FUNCTION KISS_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
      l : LongInt;
BEGIN
WITH fiss[devnr] DO
  BEGIN
  KISS_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        {$r-}
        IF fTNC THEN sReturn := 'tnc-'
                ELSE sReturn := '';
        AddString(sReturn,
           crcArt2Str[crcArt]
           + ' byRx:' + fStr(nRxByte)
           + ' byTx:' + fStr(nTxByte)
           + ' nPaketK/S/F:' + fStr(nPakete)+'/'+ fStr(nCrcOKSmack)+'/'+fStr(nCrcOKFlex)
           + ' nErr:-/'      + fStr(ncrcFehlerSmack)+'/'+fStr(nCrcFehlerFlex)
           + ' nTxO:'        + fStr(nTXOverFlow)
        );
        {$r+}
        KISS_SetPara := Longint(@sReturn);
        END;
    spBIND_DN
      : BEGIN
        l := Register[bind[wert].regNrUp].procSetPara (
                   bind[wert].devNrUp, spHOLEPROC, ord(hpRXPacketUp)
        );
        ProcRXPacketUp := TFN_RXPacketUp(Pointer(l));
        END;
    spSETZEWertIFACENr
      : BEGIN
        ifacenr:=wert;
        mapping[wert] := devnr; {fr TXPAcket}
        END;
    spDeinit
      : BEGIN
        TxPara (devnr,255,0);
        END;
    spHOLEPROC
      : BEGIN
        IF wert = ord(hpTxPacket) THEN KISS_SetPara:=Longint(@KISS_TXPacket)
                                  ELSE KISS_SetPara := 0;
        END;
{$IFDEF SLIP}
    spTXPacket
      : BEGIN
        {*Writeln('--kiss: txPacket:',devnr,'--'); *}
        tp_mbuf(wert)^.ifnr := devNR;
        crcart := caSLIP;
        Kiss_TxPacket( tp_mbuf(wert) );
        END;
{$ENDIF}
    ELSE {* case *} KISS_SetPara := speNNCMD;
  END;
 END;
END;


BEGIN
  FillChar( fiss, SizeOF(fiss), #0 );
  DoRegister(csMyName,1, MAXFISS, KISS_SetPara);
  DoRegisterPoller(FISSHandler);
END.
