;**********************************
;* Definitionen fr die SCC-Ports *
;**********************************

DMA1         equ    000h                    ;ISCC 1 DMA Base
ISCC1        equ    040h                    ;ISCC 1 SCC Base
SDLC1        equ    ISCC1 + 001h            ;Port 1 SDLC
SDLC2        equ    ISCC1 + 000h            ;Port 2 SDLC
VEKTOR1      equ    24                      ;Interrupt Vektor Basis ISCC 1

DMA2         equ    020h                    ;ISCC 2 DMA Base
ISCC2        equ    060h                    ;ISCC 2 SCC Base
SDLC3        equ    ISCC2 + 001h            ;Port 3 SDLC
SDLC4        equ    ISCC2 + 000h            ;Port 4 SDLC
VEKTOR2      equ    25                      ;Interrupt Vektor Basis ISCC 2

RX_ENABLE    equ        001h                ;Maske RX Enable
TX_ENABLE    equ        008h                ;Maske TX Enable
RTS_ON       equ        002h                ;Maske RTS Ausgang
DTR_ON       equ        080h                ;Maske DTR Ausgang
WR0          equ    2 * 000h                ;Various Initialization Commands
WR1          equ    2 * 001h                ;Transmit and Receive Interrupts, Wait/DMA
WR2          equ    2 * 002h                ;Interrupt Vektor
WR3          equ    2 * 003h                ;Receive Parameters and Control Modes
WR3_MODE     equ        0D8h                ;8 Bit Rx, Hunt Mode, Rx CRC on
WR4          equ    2 * 004h                ;Transmit and Receive Modes and Parameter
WR5          equ    2 * 005h                ;Transmit Parameters
WR5_MODE     equ        061h                ;Transmit Parameter
WR6          equ    2 * 006h                ;Sync Character/SDLC Address
WR7          equ    2 * 007h                ;Sync Chracter/SDLC Flag
WR8          equ    2 * 008h                ;Transmit Buffer
WR9          equ    2 * 009h                ;Master Interrupt Control and Reset Commands
WR10         equ    2 * 00Ah                ;Miscellaneous Transmit and Receive Control Bits
WR11         equ    2 * 00Bh                ;Clock Mode Controls for Receive and Transmit
WR12         equ    2 * 00Ch                ;Lower Byte of Baudrate Generator
WR13         equ    2 * 00Dh                ;Upper Byte of Baudrate Generator
WR14         equ    2 * 00Eh                ;Miscellaneous Control Bits
WR15         equ    2 * 00Fh                ;External Status Interrupt Enable Control

RD0          equ    2 * 000h                ;Transmit and Receive Buffer Status/External Status
RD1          equ    2 * 001h                ;Special Receive Condition Status
RD2          equ    2 * 002h                ;Interrupt Vektor (modified Chan.B) (unmodified A)
RD3          equ    2 * 003h                ;Interrupt pending Bits Chan. A only
RD6          equ    2 * 006h                ;SDLC FIFO Byte Count Low (only when enabled)
RD7          equ    2 * 007h                ;SDLC FIFO Byte Count and Status (only when enabled)
RD8          equ    2 * 008h                ;Receive Buffer
RD10         equ    2 * 00Ah                ;Miscellaneous Status Bits
RD12         equ    2 * 00Ch                ;Lower byte of Baudrate Time Constant
RD13         equ    2 * 00Dh                ;Upper Byte of Baudrate Time Constant
RD15         equ    2 * 00Fh                ;External Status Interrupt Information

CCAR         equ        000h                ;Channel Command Register
DSR          equ        000h                ;DMA Status Register
ICR          equ        001h                ;Interrupt Control Register
IVR          equ        002h                ;Interrupt Vektor Register
ICSR         equ        003h                ;Interrupt Command Register
ISR          equ        003h                ;Interrupt Status Register
DER          equ        004h                ;DMA Enable Register
DCR          equ        005h                ;DMA Control Register
RDCRA0       equ        008h                ;Receive Count Register A Byte 0
RDCRA1       equ        009h                ;Receive Count Register A Byte 1
TDCRA0       equ        00Ah                ;Transmit Count Register A Byte 0
TDCRA1       equ        00Bh                ;Transmit Count Register A Byte 1
RDCRB0       equ        00Ch                ;Receive Count Register B Byte 0
RDCRB1       equ        00Dh                ;Receive Count Register B Byte 1
TDCRB0       equ        00Eh                ;Transmit Count Register B Byte 0
TDCRB1       equ        00Fh                ;Transmit Count Register B Byte 1
RDARA0       equ        010h                ;Receive Adress Register A Byte 0
RDARA1       equ        011h                ;Receive Adress Register A Byte 1
RDARA2       equ        012h                ;Receive Adress Register A Byte 2
TDARA0       equ        014h                ;Transmit Adress Register A Byte 0
TDARA1       equ        015h                ;Transmit Adress Register A Byte 1
TDARA2       equ        016h                ;Transmit Adress Register A Byte 2
RDARB0       equ        018h                ;Receive Adress Register A Byte 0
RDARB1       equ        019h                ;Receive Adress Register A Byte 1
RDARB2       equ        01Ah                ;Receive Adress Register A Byte 2
TDARB0       equ        01Ch                ;Transmit Adress Register A Byte 0
TDARB1       equ        01Dh                ;Transmit Adress Register A Byte 1
TDARB2       equ        01Eh                ;Transmit Adress Register A Byte 2

