UNIT FD_IPX;
{*  a fast hack, only capable of exchanging ax25 frames at socket $ce73  *}
{* 4.9.93 nach ct 7/91 S.237 *}

{$I FD_INCL.PAS}
{$IFDEF scc} ### Nix da - FALCon-Hardware hat (noch) keinen IPX-Treiber {$ENDIF}

{$IFDEF VER70} {$C FIXED PERMANENT PRELOAD} {$ENDIF}

INTERFACE

USES FD_Def;


{}
IMPLEMENTATION

USES  FD_Div,
      FD_Subr,
      FD_mBuf,
      FD_Sysop,
      FD_Mem,
      FD_CRT,
      DOS;

CONST  cIPXmaxLen=512;

TYPE t_NetAdr = LongInt;           { aber in Hi-Lo}
     HiloWord = Word;               {    "         }
     tNodeID  = ARRAY[0..5] OF Byte; {    "         }

TYPE tProcessID = RECORD
       net    : t_NetAdr;
       node   : tNodeID;
       socket : HiloWord;
     END;

TYPE Headertyp = RECORD             {hi lo- definiert}
       checksum     :HiloWord;
       ipxlen       :HiloWord;
       transCtl     :Byte;
       packType     :Byte;
       destNet      :t_NetAdr;
       destNode     :tNodeID;
       destsocket   :HiloWord;
       SourceNet    :t_NetAdr;
       sourcenode   :tNodeID;
       sourceSocket :HiloWord;
       END;

TYPE packetTyp =RECORD
             header:Headertyp;
             datenbuffer:ARRAY [0..cIPXmaxLen] OF Byte;
            END;

TYPE ECBtyp = RECORD
       link      : Pointer;
       esradr    : Pointer;
       inUse     : Byte;
       completion: Byte;
       socket    : HiloWord;                    { hi lo}
       IPXarea   : t_NetAdr;
       DriverArea: ARRAY[1..12] OF Byte;
       ImmAdr    : tNodeID;                 { hi lo}
       FragmCount: Word;
       adr1      : ^packetTyp;
       len1      : Word;               { lo hi }
     END;

TYPE checkTyp = (check,nocheck);

CONST everynode  : tNodeID=($FF,$FF,$FF,$FF,$FF,$FF);
      leerNode   : tNodeID=(0,0,0,0,0,0);
      sameNet    : t_NetAdr=0;
      stayOpen  =$FF;
      AutoClose =0;
      openok    =0;
      errSchonDa=$FF;
      voll      =$FE;
      DiagnoseSocket=swap($456);

VAR   myNet  : t_NetAdr;
      myNode : tNodeID;
      ipxInitResult:INTEGER;

 TYPE T_Reg = RECORD
                 CASE INTEGER OF
                   0: (_AX,     _CX,_DX,_SI,_DI,_ES : Word);
                   1: (_AL,_AH : Byte);
               END;

  VAR fn_ipx:PROCEDURE;



FUNCTION Node2String (x:tNodeID):STRING;
  VAR i : Byte;
      s : String;
BEGIN
  s := '';
  FOR i:=0 TO 5 DO s:=s+HexByteString(x[i]);
  Node2String := s;
END;

FUNCTION Net2String (n:t_NetAdr):STRING;
VAR i:Byte;
    x:ARRAY[0..3] OF Byte absolute n;
    s:STRING;
BEGIN
  s := '';
  FOR i:=0 TO 3 DO s := s + HexByteString(x[i]);
  Net2String := s;
END;

PROCEDURE Error (errmsg:String;errnr:Word);
BEGIN
  WriteLn (chr(7)); Write (errmsg,' ',errNr);
  halt(errnr);
END;


PROCEDURE setDS; { mu zu beginn jeder Eventroutine stehen }
assembler;
asm
  mov  ax,seg @Data
  mov  ds,ax
END;


FUNCTION GetIPXAdr:Pointer;
  VAR reg:registers;
BEGIN
  GetIPXAdr:=NiL;
  WITH reg DO BEGIN
    ax:=$7a00;
    Intr ($2F,reg);
    IF reg.al <> $0FF THEN Exit;
    GetIPXAdr:=ptr(ES,DI);
  END;
END;


FUNCTION equalNode (node1,node2:tNodeID):BOOLEAN;
VAR i:Byte;
BEGIN
  equalNode:=TRUE;
  FOR i:=0 TO 5 DO IF node1[i] <> node2[i] THEN equalNode:=FALSE;
END;

{ ****** alle IPX-Funktionen ****** }

VAR request,reply  :tProcessID;

PROCEDURE setECB (VAR ecb:ECBtyp;
                      esradr:Pointer;
                      socket:HiloWord;
                      wem:tNodeID;
                      adrPacket : POINTER;
                      lenPacket : WORD);
 {* beschrnkt auf ein Fragment *}
BEGIN
  ecb.link:=NiL;
  ecb.esradr:=esradr;
  ecb.inUse:=0;
  ecb.socket:=socket;
  ecb.ImmAdr:=wem;
  ecb.FragmCount:=1;
  ecb.adr1:=adrPacket;
  ecb.len1:=lenPacket;
END;

PROCEDURE OpenSocket ( modus:Byte; socket:HiloWord;
                   VAR completion:Byte;
                   VAR assignedNr:HiloWord;
                       checkin:checkTyp);
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  al,modus
   mov  dx,socket
   mov  bx,0
   call fn_ipx
   POP  bp
   POP  ds
   les  bx,completion;     mov  Byte ptr ES:[bx],al
   les  bx,assignedNr;     mov  Word ptr ES:[bx],dx
  END;
  IF checkin=check THEN
    CASE completion OF
      openok    : WriteLn ('- open ok');
      errSchonDa: error ('Socketnr bereits benutzt',2);
      voll:       error ('Sockettabelle voll',3);
     END;
END;

PROCEDURE CloseSocket (socket:HiloWord);
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  dx,socket
   mov  bx,1
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

PROCEDURE GetLocalTarget (net:t_NetAdr;node:tNodeID;socket:HiloWord;
                           VAR LocalTargetNode:tNodeID;
                           VAR completion:Byte; VAR TransportTime:Word );
{* nicht von EventRoutine aufrufen ! *}
  VAR Locadr : tNodeID absolute reply;
BEGIN
  request.net:=net;
  request.node:=node;
  request.socket:=socket;
  asm
   PUSH ds
   PUSH bp
   mov  bx,2
   mov  ax,seg request     ;   mov  ES,ax
   mov  ax,offset request  ;   mov  si,ax
   mov  ax,offset reply    ;   mov  si,ax
   call fn_ipx
   POP  bp
   POP  ds
   mov  Byte ptr [completion], al
   mov  Word ptr [TransportTime], dx
  END;
  LocalTargetNode:=Locadr;
END;

PROCEDURE send (VAR ecb:ECBtyp);
BEGIN
  asm
   PUSH ds
   PUSH bp
   les  si,ecb;
   mov  bx,3
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

PROCEDURE listen (VAR ecb:ECBtyp);
BEGIN
  asm
   PUSH ds
   PUSH bp
   les  si,ecb;
   mov  bx,4
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

PROCEDURE ScheduleIPXEvent (DelayTime:Word; VAR ecb);
BEGIN
  asm
   PUSH ds
   PUSH bp
   les  si,ecb;
   mov  ax,DelayTime
   mov  bx,5
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

PROCEDURE CancelEvent (VAR ecb);
BEGIN
  asm
   PUSH ds
   PUSH bp
   les  si,ecb;
   mov  bx,6
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

FUNCTION GetIntervalMarker:Word;
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  bx,8
   call fn_ipx
   POP  bp
   POP  ds
   mov  @result,ax
  END;
END;

PROCEDURE GetInterNetadr (VAR net:t_NetAdr;VAR node:tNodeID);
  { nicht von EventRoutine aufrufen !}
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  ax,seg reply;     mov ES,ax;
   mov  ax,offset reply;  mov si,ax;
   mov  bx,9
   call fn_ipx
   POP  bp
   POP  ds
  END;
  net:=reply.net;
  node:=reply.node;
END;

PROCEDURE RelinquishControl;
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  bx,$0a
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

PROCEDURE DisconnectTarget (net:t_NetAdr;node:tNodeID;socket:HiloWord);
{ nicht von EventRoutine aufrufen !}
BEGIN
  request.net:=net;
  request.node:=node;
  request.socket:=socket;
  asm
   PUSH ds
   PUSH bp
   mov  ax,seg request;     mov ES,ax;
   mov  ax,offset request;  mov si,ax;
   mov  bx,0bh
   call fn_ipx
   POP  bp
   POP  ds
  END;
END;

{**** Ein bischen SPX ****}
CONST spxVersion: WORD=0; {* Hi=Major; Lo=Minor-VersionsNr *}
      spxMaxConnections : WORD=0;
FUNCTION SPXInstalled : BOOLEAN;
BEGIN
  asm
   PUSH ds
   PUSH bp
   mov  al,0;
   mov  bx,$10
   call fn_ipx
   mov  spxVersion,bx
   MOV  spxMaxConnections,cx
   { MOV  spxAvailableConnections,dx }
   POP  bp
   POP  ds
   mov  @Result,AL {* $FF= Installed; $00=Nicht Intalliert *}
  END;
END;


FUNCTION GetInfoString : STRING;
  VAR s : STRING;
BEGIN
  IF ipxInitResult=1
    THEN s := 'IPX nicht geladen'
    ELSE BEGIN
         s := ' Adresse $'+Net2String(myNet)
             +':'+Node2String(myNode);
         IF NOT SPXInstalled
           THEN s := s + ' - SPX nicht geladen'
           ELSE BEGIN
                s := s + ' SPX Vers.'+fStr(Hi(spxVersion))+'.'+fstr(lo(spxVersion));
                END;
         END;
  GetInfoString := s;
END;
{ DigiWare Zeug }

CONST prSocket:HiloWord=swap ($ce73);
      prPacketTyp = 25;

VAR completion  : Byte;
    IPXifNr     : t_ifnr;
    assignedNr  : HiloWord;
    rxPacket    : packetTyp;
    rxECB       : ECBtyp;
    txPacket    : packetTyp;
    txECB       : ECBtyp;
    ExitSave    : Pointer;
CONST nTXPacket : Longint = 0;
      nRXPacket : Longint = 0;

PROCEDURE IPX_txESR; Far;  { Eventroutine mu FAR sein! }
BEGIN
  IF txECB.completion <> 0 THEN WriteLn (con2,' Fehler beim Senden:',txECB.completion);
END;


PROCEDURE IPX_TxPacket( pm : tp_mbuF ); Far;
BEGIN
  IF pm^.inUse <= cIPXmaxLen THEN
    BEGIN
    WHILE txECB.inUse<>0 DO;;;;
    IF txECB.completion <> 0 THEN Write (con2,' IPX:Fehler beim Senden:',txECB.completion);
    WITH txPacket DO
      BEGIN
      Move (pm^.pData^, datenbuffer[0], pm^.inUse);
      header.ipxlen    := swap(SizeOf (Headertyp)+pm^.inUse);
      header.destNet   := 0; {* same Net *}
      header.destNode  := everynode;
      header.destsocket:= prSocket;
      header.packType  := prPacketTyp;
      END;
    SetECB ( txECB, NiL, prSocket, everynode,  @txPacket, SizeOf (Headertyp)+pm^.inUse);
    Send (txECB);
    Inc(nTXPacket);
    END;
  _DI;
  IF pm^.ptTimer <> NiL THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE;
  pm^.txed := TRANSMITTED;
  _EI;
  IF pm^.discard THEN Del_mBuf (pm);
END;


PROCEDURE IPX_rxISR; Far;  { Eventroutine mu FAR sein! }
VAR len : Word;
    i   : INTEGER;
    pNeuBuf : tp_mbuF;
BEGIN
  SetDS;                    { am Beginn jeder Eventroutine !! }
  ASM STI END;
  WITH rxPacket DO WITH header DO
    IF rxECB.completion <> 0
      THEN Write(^g)
      ELSE BEGIN  {* Ok, Operation ist komplett *}
      {* Testen ob SourceNode im Header nicht =MyNode ist -> ist nur ein Echo des eigenen gesendeten *}
      IF NOT MemEq( @myNode, @sourcenode, SizeOf(myNode)) THEN
        BEGIN
        _DI;
        len := swap(ipxlen)-30;
        IF L1RxBufAvail AND (BUFFSIZE >= swap(ipxlen)-1) THEN
          BEGIN {* Buffer noch frei *}
          {* Neuen Buffer allokieren *}
          pNeuBuf := GetL1Rxbuf;
          _EI;
          {* kopieren des Pakets *}
          Move ( datenbuffer[0], pNeuBuf^.pData^, len );
          pNeuBuf^.inUse := len;
          pNeuBuf^.ifnr := IPXifNr; (* INTERFACE *)
          pNeuBuf^.ofsCtl := CalcOfsCtl(pNeuBuf);
          pNeuBuf^.time := fasttick;
          pNeuBuf^.next := NiL;
          Inc(nRXPacket);
          {* Einhngen in RXQueue *}
          _DI;
          IF lstRxInUse.Root <> NiL THEN lstRxInUse.Tail^.next := pNeuBuf (* anhngen *)
   	                            ELSE lstRxInUse.Root := pNeuBuf; (* nur setzen *)
          lstRxInUse.Tail := pNeuBuf;
          END;
        _EI;
        END;
      END;
  Listen (rxECB);
END;

{$F+}
PROCEDURE IpxExit; {$F-}
BEGIN
  WriteLn;
  WriteLn('- IPX: Exiting...');
  CancelEvent(rxECB);
  IF txECB.inUse <> 0 THEN CancelEvent(txECB);
  CloseSocket (prSocket);
  WriteLn('- IPX: Closed');
  exitProc := ExitSave;
END;


PROCEDURE InitDevice (devNr : Byte);
BEGIN
{$IFnDEF DPMI}
  IF devNr<>1 THEN Exit;
  Writeln(GetInfoString);
  IF ipxInitResult = 1 THEN Exit;
  openSocket (AutoClose, prSocket, completion, assignedNr, nocheck);
  IF completion <> openok
    THEN BEGIN
         IF completion=errSchonDa THEN WriteLn('- Socketnr bereits benutzt');
         IF completion=voll THEN WriteLn('- Sockettabelle voll');
         END
    ELSE BEGIN
         ExitSave := exitProc;
         exitProc := @IpxExit;
         IPXifNr := devNr;

         nTXPacket := 0;
         nRXPacket := 0;
         FillChar( txECB, SizeOf(txECB), #0 );
         FillChar( rxECB, SizeOf(rxECB), #0 );

         SetECB (rxECB, @IPX_rxISR, prSocket, leerNode, @rxPacket, SizeOf(Headertyp)+cIPXmaxLen);
         Listen (rxECB);
         END;
{$ENDIF}
END;

{}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'INIT ';
        cmINIT=1;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   res,x,devNrDn : BYTE;
        sDn : STRING;
        p : Pointer;
        para : Longint;
BEGIN
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : InitDevice(devNr);
      END {Case}
  UNTIL x=0;
END;


{$F+}
FUNCTION IPX_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
BEGIN
  IPX_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sGlobReturn := 'Pakete TX/RX: ' + fStr(nTXPacket)
                                   +'/' + fStr(nRXPacket)
                          + '  '        + GetInfoString
                        ;
        IPX_SetPara := Longint(@sGlobReturn);
        END;
    spSETZEWertIFACENr
      : BEGIN
        IPXifNr := wert;
        END;
    spHOLEPROC
      : BEGIN
         IF wert = ord(hpTxPacket) THEN IPX_SetPara:=Longint(@IPX_TXPacket)
                                   ELSE IPX_SetPara := 0;
        END;
    ELSE {* case *} IPX_SetPara := speNNCMD;
  END;
END;


BEGIN
{$IFnDEF DPMI}
  ipxInitResult:=0;
  @fn_ipx:=GetIPXAdr;
  IF @fn_ipx = NiL THEN ipxInitResult:=1
                   ELSE GetInterNetadr (myNet,myNode);
{$ENDIF}
  DoRegister('IPX', 1,1, IPX_SetPara);
END.
