{$I FD_INCL.PAS}
UNIT FD_IP;

INTERFACE

USES FD_Def;



 FUNCTION IsIP(pm:tp_mbuf):BOOLEAN;
PROCEDURE DoIP(pm:tp_mbuf);
PROCEDURE DoAXIP(pcb:tp_axcb);


{}

IMPLEMENTATION

USES FD_Div,
     FD_Dump,
     FD_Subr,
     FD_Tx,
     FD_Sysop
     ;

{}

TYPE T_IPAddr = Longint;

CONST IPID_ICMP =    1;   {/* Internet Control Message Protocol */}
      IPID_TCP  =    6;   {/* Transmission Control Protocol */}
      IPID_UDP  =   17;   {/* User Datagram Protocol */}
      IPID_RSPF =   73;   {/* Radio Shortest Path Find */}

TYPE
  T_UDP=RECORD
     sourcePort,
     destPort,
     messLen,
     crc : WORD;
    END;
  T_UDP_Pseudo = RECORD
      sourceIP, destIP : T_IPAddr;
      zero, prot : BYTE;
      udplen : WORD;
     END;
  T_IP = RECORD {* commer I, p.92 *}
      vershlen,
      tos       : BYTE;
      totLen    : WORD;
      ID        : WORD;
      flag_fragoff : WORD;
      ttl,
      prot      : BYTE;
      headerCRC : WORD;
      sourceIP,
      destIP    : Longint;
      END;
     t_IPAll=RECORD
        head : T_IP;
        CASE integer of
          0 : (data : ARRAY [1..1] OF CHAR);
          IPID_UDP : (udp : T_UDP);
        END;

  TP_IP = ^T_IP;
  tp_ipALL = ^T_IPAll;


{ ICMP }
TYPE T_ICMP = RECORD
       typ,code : BYTE;
       checksum, id, seqNr : WORD;
       data : Byte;
     END;

FUNCTION ComputeIPCRC( pOrg:Pointer; len:LongINT ):WORD;
  VAR i,sum : LongInt;
      p: TP_WORD;
BEGIN
  p := pOrg;
  sum := 0;
  FOR i := 1 TO len DIV 2 DO
    BEGIN
    sum := sum + swap(p^);
    inc(Word(p),2)
    END;
  ComputeIPCRC := word(not swap(word(sum)));
END;



PROCEDURE SetIPCRC( pOrg:Pointer );
  VAR i,sum,len : LongInt;
      pseudo : T_UDP_Pseudo;
BEGIN
  len := (TP_byte(pOrg)^ AND 15) * 4;
  TP_IP(pOrg)^.headerCRC := 0;
  TP_IP(pOrg)^.headerCRC := ComputeIPCRC(pOrg,len);

{$IFDEF fasfdsa}
  IF tp_ip(pOrg)^.prot = IPID_UDP THEN WITH tp_ipALL(pOrg)^.udp DO
    BEGIN {* UDP bezieht in seine Prfsumme auch Teile von IP ein! *}
    pseudo.sourceIP:= TP_IP(pOrg)^.sourceIP ;
    pseudo.destIP  := TP_IP(pOrg)^.destIP ;
    pseudo.zero    := 0;
    pseudo.prot    := IPID_UDP;
    pseudo.udplen  := messlen;
    crc := ComputeIPCRC( @pseudo, sizeof(pseudo));
    END;
{$ENDIF}
END;

FUNCTION CheckIPCRC(p:POINTER):BOOLEAN;
  VAR i,len,sum : longint;
BEGIN
  len := (TP_byte(p)^ AND 15) * 4;
  CheckIPCRC := ComputeIPCRC(p,len)=0;
END;

{ Action }

CONST csMyName='IP';
TYPE T_IFIP = RECORD
      myIP : T_IPAddr;
      ifDefaultGateWay : T_RegIf;
      ifHost : T_RegIf;
      bindnr : BYTE;
      ProcTxPacket : TFN_TxPacket;
      END;
VAR ifIP : T_IfIP;


FUNCTION IsIP(pm:tp_mbuf):BOOLEAN;
{* gugt nach, ob in pm ein IP Frame drin ist (kein SLIP, denn das htte ja
 * schon der Treiber ausgepackt .... ). Wenn es kein IP ist, gibt er FALSE
 * zurck *}
BEGIN
  IsIp := (byte(pm^.pdata^) SHR 4 = $4) {AND CheckIPCrc (pm^.pData)};
  {ersten 4 bits testen ob Vers=4 ist}
  {total lnge ok?}
  {chksumme berprfen}
END;

PROCEDURE DoAXIP(pcb:tp_axcb);
{* Auspacken eines IP-Frames aus ax25 *}
  VAR pm : TP_mBuf;
BEGIN
  pCBGlob := pCB;
  REPEAT
    pm := GetMBufFromQueue (pCB^.RxBuf);
    IF pm <> nil THEN
      BEGIN
      Dec (pCB^.RxBufSize, pm^.inUse);
{**      WriteLn('-- DoAXIP-- ',HexLiString(longint(pCBGlob)),'--'); **}
      DoIP (pm);
      Del_mBuf (pm);  {* GetMBufQueue schreibt vor, dass *wir* den Buffer freigeben muessen *}
      END;
  UNTIL pm = nil;
END;


PROCEDURE DoIP(pm:tp_mbuf);
{* Mache irgenndwas mit dem IP Frame ...
 *}
 VAR pip : ^t_ip;
     li : Longint;
     pmIP : TP_mBuf;
     ifZiel : T_RegIf;
BEGIN
   DumpIP (pm^.pData, pm^.inUse);
   pmIP := CopyMBuf ( pm );
   pIP := pmIP^.pData;

{   IF pIP^.ttl > 1 THEN Dec(pIP^.ttl,1)
                   ELSE Exit; {verwerfen, ICMP Generieren!}

{*   RouteIP *}

   {* In pm^.ifnr ist die devnr des IP Interfaces drin *}
{*** WriteLn('---',pIp^.destIP,'*',ifip.myIP,'---'); **}

   IF pIp^.destIP = ifip.myIP THEN ifZiel := ifip.ifHost
                              ELSE ifZiel := ifip.ifDefaultGateWay;

 {  SetIPCRC(pip); }

   pmIP^.discard := true;

   {* SendePaket *}
   IF Register[Hi(ifZiel)].
      procSetPara( Lo(ifZiel), spTXPacket, longint(pmip) ) = 0 THEN ;;;

  {iface := route(dest.address)
   if iface=pm^.ifnr then discard

   if iface<>slipfhig
      destcall := such ax25call fr dest ip-addr/netz
      suche route nach destcall
      suche oder erzeuge ein QSO oder UI
      verpacke pm in ein ax25-frame (evtl. sx-fragmentieren)
   }
END;

{}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'INIT BIND MYIP DEFAULT ';
        cmINIT=1; cmBIND=2; cmMYIP=3; cmDefault=4;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   res,x : BYTE;
        sDn : STRING;
        p : Pointer;
        para,devNrDn : Longint;
BEGIN
WITH ifip DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanForVal(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : ;
      cmMYIP : BEGIN
               myip := para;
               END;
      cmDEFAULT
             : BEGIN  { z.B. DEFAULT KISS 2 }
               ScanForText (sArg, sDn );
               devNrDn := ScanForVal(sArg);
               ifDefaultGateWay := Str2ifip( sDn,devNrDn);
               END;
      cmBIND : BEGIN  { z.B. BIND v24 2 }
               ScanForText (sArg, sDn );
               devNrDn := ScanforNum(sArg);
               res := DoBind( csMyName,devnr, sDn, devNrDn );
               bindnr := res;
               IF res > 0 THEN
                 BEGIN
                 ifHost := Str2ifip(sDn,devNrDn);
                 {* Hole die SendeRoutine *}
                 p := Pointer( Register[bind[bindnr].regNrDn].procSetPara (
                      bind[bindnr].devNrdn, spHOLEPROC, ord(hpTxPacket) )
                 );
                 ProcTxPacket := TFN_TxPacket(p);
                 IF DoDnSetPara(bindnr, spSETZEWertIFACENr, devNr) = 0 THEN;;;
                 END;
               END;
      END {Case}
  UNTIL x=0;
END;


CONST sReturn : STRING='';
{$F+}
FUNCTION IP_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
BEGIN
WITH ifip DO
  BEGIN
  IP_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sReturn :='MyIP: 0x'       + HexLIString(myIP)
                 + ' ifGate/Host:' + HexString(ifDefaultGateWay)
                 +             '/' + HexString(ifHost)
                 ;
        IP_SetPara := Longint(@sReturn);
        END;
    spHoleVAL
      : IF wert = ord(hvBINDNR) THEN IP_SetPara := bindNr;
    spHOLEPROC
      : BEGIN
{        IF wert = ord(hpTxPacket) THEN IP_SetPara:=Longint(@IP_TXPacket)
                                  ELSE IP_SetPara := 0;
 }       END;
    ELSE {* case *} IP_SetPara := speNNCMD;
  END;
 END;
END;



BEGIN
  ifip.myIP := $3213822C;   { 50 19 130 44 }
  ifip.ifDefaultGateWay := Str2ifip('KISS',1);;
  ifip.ifHost :=           Str2ifip('KISS',2);
  ifip.bindnr := 0;
  pCBGlob := nil;
  DoRegister(csMyName, 1,1, IP_SetPara);
END.
