UNIT FD_Info;
{$I FD_INCL.PAS}

INTERFACE

USES FD_Def;


PROCEDURE OpenInfoBox (VAR pCB : TP_AXCB;
                      mitCText : BOOLEAN;
 		          nCon : Word;
		      lnPakete : LongInt
		      );
PROCEDURE CloseInfoBox ( VAR pCB : TP_AXCB);
PROCEDURE DoPrompt (pCB:TP_AXCB);
 FUNCTION CheckCalls (pCB : TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} v,t : String) : BOOLEAN;


     TYPE T_vonWo = (INFOBOX,CONV,DIGISETUP);
PROCEDURE Infobox_Interpreter (pCB : TP_AXCB; von_wo :T_vonWo ; VAR Info : String);
PROCEDURE fnMsgInfoBox ( pCB : TP_AXCB; msg : T_Msg);

PROCEDURE ListLink (pCB:TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} sUarg : String);
PROCEDURE DoQuit (pCB:TP_AXCB);


{}

IMPLEMENTATION

USES FD_Div,
     FD_AXCB,
     FD_Conv,
     FD_Task,
     FD_Subr,
     FD_mBuf,
     FD_State,
     FD_ALDE,
     FD_Main,
{$IFDEF slip}  FD_IP, {$ENDIF}  {DOAXIP}
     FD_Circ,
     FD_NetROM,
     FD_Host, {* wg. OpenHost *}
     FD_BC,
     FD_Timer,
     FD_Error,  {* StoreStack *}
     FD_Beacon, {* SendBeacon *}
     FD_Log,
     FD_Tx,
     FD_Text,
     FD_Link,
     FD_24C65,
     {$IFDEF SCC} FD_Tnc,
     {$ELSE}	  FD_CRT, Dos,
     {$ENDIF}
     FD_Sysop,
     {$IFDEF MitLocator}
     FD_QTH,
     {$ENDIF}
     FD_Mem,
     FD_MH,
     FD_AR,
     FD_Flex
{$IFDEF DCF}
    ,FD_DCF
{$ENDIF}
     ;

CONST sVersionCFG : STRING = ''; {* Fr den erweiterten VERSION-Befehl *}
VAR   fEEPROM : Text;
{}

FUNCTION CheckCalls (pCB : TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} v,t : String) : BOOLEAN;
 {* Gibt TRUE zurck wenn alles o.k ist *}
  LABEL l_eop;
BEGIN
  CheckCalls := FALSE;
  IF dnCallCheck THEN
    BEGIN
    IF NOT ValidCall(t) THEN
      BEGIN
      TX_EOLSysInfo (pCB,SPAETER,'invalid call');
      GOTO l_eop;
      END;
    IF v <> '' THEN
      IF NOT ValidCall(v) THEN
        BEGIN
	TX_EOLSysInfo (pCB,SPAETER,'invalid via-path');
	GOTO l_eop;
	END;
    END;
  CheckCalls := TRUE;
l_eop:
END;


PROCEDURE DoInfoBoxTimeOut ( pCB : TP_AXCB );
BEGIN
  IF pCB^.who = sysop THEN Exit;
  Inc (pCB^.pInfoBox^.TimeOutStufe);
  CASE pCB^.pInfoBox^.TimeOutStufe OF
    ibtSchluss
     : BEGIN
       TX_SysInfo (pCB, SPAETER, 'TIMEOUT!'+BELL+EOL);
       DoQuit(pCB);
       END;
    ibtGelb
     : BEGIN
       TX_EOLSysInfo (pCB, SOFORT,
	      'TIMEOUT warning: '
              +fStr(InfoBoxTimeOut DIV 3 DIV (1000 DIV _clktick) DIV 60)
              +' minutes left'+^g+EOL);
       pCB^.tTimeOut.TickInit := 1 * InfoBoxTimeOut DIV facGelbeKarte;
       StartTimer (pCB^.tTimeOut);
       END;
    END;
END;



PROCEDURE DoDestList ( pCB : TP_AXCB; sArg : String );
  VAR i,j : Word;
      s : String;
BEGIN
  Upper(sArg);
  TX_Info( pCB, SPAETER, fStr(fasttick));
  FOR i := 1 TO nZiel DO WITH paZiel^[i] DO
    BEGIN
    WatchDog;
    s :=  EOL+
          FStr(i)+'. '+
          f_sh2ascUsing(call,true,7)+
          f_Using(SSID_von,2) + '-' + f_Using(SSID_bis,2) +
          f_Using(lkUsed,3) + 'I *';
    FOR j := 1 TO maxFLEXNBAR DO
      IF link[j].lzMessen AND link[j].valid THEN {* Nur wenn der zugeh. Link auch relevant ist *}
          BEGIN
          AddString(s,  ' '+fStr(lz[j]) );
          IF (bfChange AND (1 SHL j)) = 0 THEN AddChar(s,'_');
          IF j=lkUsed THEN AddChar(s,'*');
          END;
    AddString(s,  ' * ' + HexLIString (bfChange)
           + ' '   + fStr(holddownftick)
           + ' '   + fStr(fasttick-holddownftick) );
    IF Pos( sArg, s) > 0 THEN TX_Info( pCB, SPAETER, s);
    END;
  TX_Info( pCB, SPAETER, EOL+'n='+fStr(nZiel)); (* dg6may: Anzahl Dest *)
END;



PROCEDURE ListAlleZiele ( pCB : TP_AXCB; minlimit, maxlimit : T_LZ; {$IFDEF ver70} CONST {$ENDIF} wildCard : String );
  VAR i,
      nCall : Word;
      s  : String;
BEGIN
  IF NOT useFlexNet THEN
    BEGIN
    TX_SysInfo (pCB,SPAETER,'Flex-Router z.zt. abgeschaltet'+EOL);
    Exit;
    END;

  WatchDog;
  nCall := 0;
  FOR i := 1 TO nZiel DO WITH paZiel^[i] DO
    IF lkUsed > 0 THEN {* Route gltig ? *}
      IF  ((minlimit <= lz[lkUsed] ) AND (lz[lkUsed] <= maxlimit))
       OR (maxlimit = 0) THEN
	BEGIN
        WatchDog;
	s := FStr(SSID_von) + '-' + FStr(SSID_bis);
	SetStrLength(s,5);
	s := ' ' + f_sh2ascUsing( call,true,7)
		 + s
		 + f_Using(lz[lkUsed],5)
		 + ' ';
	IF (wildCard='') OR (Pos(wildCard,s) <> 0) THEN
          BEGIN
          IF nCall=0 THEN
            BEGIN
            TX_EOLSysInfo( pCB, SPAETER, 'Ziele mit Laufzeit <='+FStr(maxlimit)
                                         +'. Fr mehr Ziele z.B. "D 3000" verwenden!'
                                         +EOL );
            IF minlimit <> 0 THEN TX_Info( pCB, SPAETER, ' und Laufzeit >='+FStr(minlimit)+EOL );
            END;
	  TX_Info( pCB, SPAETER, s );
	  Inc (nCall);
	  IF nCall MOD 4 = 0 THEN TX_Info (pCB, SPAETER, EOL );
	  IF nCall MOD 128 = 0 THEN
            BEGIN
            WatchDog;
            TX_Trigger(pCB);
            END;
	  END;
	END;
  IF nCall = 0  THEN TX_EOLSysInfo( pCB, SPAETER, 'keine Ziele mit Laufzeit <='+FStr(maxlimit) );
END;



PROCEDURE DoDest ( pCB : TP_AXCB; sArg : String; WithRT : BOOLEAN );
  LABEL l_eop;
  VAR pNewCB : TP_AXCB;
      i      : Byte;
      w      : Word;
      ifnr   : t_ifnr;
      fWithTrace : BOOLEAN;
      t,v    : String;
      shZ    : t_ShCall;
      lz     : T_LZ;
      n : integer;  flong: boolean; (* dg6may *)
BEGIN
  w :=f_ValWord(sArg);
  IF (w>0) AND (w<32000) THEN {* so grosse LZ werden eh nicht gespeichert *}
    BEGIN {* Eine obere LZ-Grenze ist angegeben worden *}
    ListAlleZiele( pCB, 0, w, '' );
    Exit;
    END;

  String2tv ( sArg, t,v);
  IF t = '' THEN
    BEGIN {* Gar kein Argument ! *}
    ListAlleZiele (pCB,0,600,'');
    Exit;
    END;

  fWithTrace := v='>';
  IF fWithTrace THEN v := '';

  IF NOT CheckCalls (pCB, v,t ) THEN GOTO l_eop;

  fLong:= v='*';         (* dg6may *)
  v := '';
  AscCall2shift(t,shZ);

  ifnr := 0;
  lz := AR_SearchRoute ( shZ, FALSE,ifnr, v );

  IF ifnr = 0
    THEN BEGIN
	 TX_EOLSysInfo (pCB,SPAETER, 'no route to '+t{*EOL findet in nachfolgenden Proc statt*});
	 ListAlleZiele( pCB, 0, 3000, t );
	 END
    ELSE BEGIN
	 sArg := EOL + '*** route to '+t;
	 IF v <> '' THEN sArg := sArg + ': via '+v+' (port '+FStr(ifnr)+')'
		    ELSE sArg := sArg + ':  direct, port '+FStr(ifnr);
{*
 *        IF (AR_GlobReturn = 0)
 *          THEN sArg := sArg + ' T=(unknown)'
 *          ELSE IF (lz > 0) AND (lz<>lzERROR) THEN sArg := sArg + '  T='+FStr(lz);
 *}
 {* DG6MAY *}
         IF (lz<>lzERROR) AND (lz<30000) THEN sArg := sArg + '  T='+FStr(Abs(lz));

	 IF (AR_GlobReturn > 0) AND (v <> '') AND NOT fLong THEN
	   BEGIN {* Weg geht per FlexNet und das Ziel ist kein Nachbar aus   *}
                 {* der Linkliste, erzeuge also 6er Frame und schicke es los *}
	   Send6Token (pCB, AR_GlobReturn, t, fWithTrace );
	   END;
	 TX_Info (pCB,SPAETER, sArg);
         IF fLong THEN                 (* dg6may *)
           BEGIN
           n := FlexSucheZiel(shZ,(byte(shZ[7]) AND 30) SHR 1, FALSE);
           if n > 0 then
             begin
             for i:=1 to maxFLEXNBAR do with link[i] do
               if lzMessen and valid and (not hidden) then
                 BEGIN
                 lz := paziel^[n].lz[i];
                 IF lz <> 0 THEN TX_Info(pCB,spaeter,EOL
                                          +'    '
                                          + f_sh2ascOhneSSID(call)
                                          + f_using(lz,7));
                 end; (* if lzMessen... *)
             end;    (* if n > 0 *)
           end;     (* if long *)
	 END;
l_eop:
END;


{}


PROCEDURE DoPrompt (pCB:TP_AXCB);
  VAR sUserPrompt : String;
BEGIN
{$IFDEF hmmmm}
  * IF (pCB^.minFrack > 0 ) AND (pCB^.minFrack < 3*(1000 DIV _clktick))
  *    AND (pCB^.nDigi=0) AND (axIFace[pCB^.iface].art = aUSER) {* es sollen ja nur direkt-QSO beachtet werden *}
  *  THEN BEGIN
  *	  TX_Info (pCB, SPAETER, EOL+ BELL + '*** BITTE FRACKTIMER - WERT ERHOEHEN'+EOL);
  *	  pCB^.minFrack := 0;
  *	  END;
{$ENDIF}
  IF pCB^.pCv <> NiL {* Wenn aus Convers her aufgerufen, gibt es einen anderen Prompt *}
    THEN TX_EOLSysInfo(pCB, SOFORT, 'ready'+EOL)
    ELSE BEGIN
         CvMacro (pCB,sPromptTemplate,sUserPrompt);
	 IF sUserPrompt = '' THEN Tx_Trigger(pCB) {* kw 7.3.98: Ansonsten kriegt er in der Infobox nie nen Trigger.... *}
                             ELSE TX_Info (pCB, SOFORT, EOL + sUserPrompt);
	 END;
END;


PROCEDURE DoQuit (pCB:TP_AXCB);
BEGIN
  IF NOT ReadTxt ( pCB, 'BYE', rtNODEFAULT ) THEN TX_Info (pCB, SOFORT, EOL+csBye);
  DoDisconnect (pCB); {* disconnecten, wenn alle TXFrames besttigt sind *}
END;


PROCEDURE ListLink (pCB:TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} sUarg : String);
  VAR i, chFaktor, pass : Byte;
      s : String;
      lz : Word;
      zi : INTEGER;
BEGIN
  TX_Info (pCB, SPAETER, EOL+'Call     SSID   Laufz.    Port         System  Bemerkungen'
			+EOL+'----------------------------------------------------------'+EOL);
  FOR pass := 1 TO 2 DO   {* pass1=direkte Links, Pass 2 = Vias *}
    FOR i := 1 TO nLinks DO WITH link[i] DO
      BEGIN
      IF valid AND (NOT hidden OR (pCB^.who=sysop)) THEN {* Hidden werden nur den SysOps angezeigt *}
       IF ((pass=1) AND direkt) OR ((pass=2) AND NOT direkt) THEN {* zuerst die direkten ausgeben *}
	BEGIN
	s := f_sh2AscOhneSSID(call);  SetStrLength (s,8);
        IF SSID_von=SSID_bis
          THEN AddString(s, f_Using(SSID_von,2)+' '+               '  '+' ' )
	  ELSE AddString(s, f_Using(SSID_von,2)+'-'+f_Using(SSID_bis,2)+' ' );
	IF lzMessen AND fLZMessungen THEN {* lokal und global erlaubt *}
          BEGIN
          chFaktor := 0;
          zi := FlexSucheZiel ( call, SSID_von, FALSE );
          IF zi>0 THEN
            IF (paZiel^[zi].lkUsed<>i) AND (paZiel^[zi].lkUsed<>0) THEN chFaktor := 1;
	  IF (tSchnitt = lzERROR) OR (tSchnitt>lzANZEIG)
            THEN s := s+'   '+Char(32+8*chFaktor)+'---'+Char(32+9*chFaktor)
	    ELSE BEGIN
                 IF System = dsFLEXNET
		   THEN AddString(s, Char(32+8*chFaktor)+f_Using (tOur,4) +'/'+ FStr (tThem)+Char(32+9*chFaktor))
		   ELSE AddString(s, Char(32+8*chFaktor)+f_Using (tSchnitt,4)               +Char(32+9*chFaktor));
                 END;
          END;
	SetStrLength (s,27);
	IF NOT direkt THEN AddString(s, 'via '+ f_sh2asc (link[PortNr].call))
		      ELSE AddString(s, 'P' + FStr(PortNr) );
        {* Das IFace kennzeichen, ber das das QSO luft *}
	IF direkt AND (pCB^.iface = PortNr) THEN
          BEGIN
          IF pCB^.nHeard > 0
            THEN BEGIN
                 IF pCB^.digi[pCB^.nHeard]=call THEN AddChar(s,'*');
                 END;
          END;
        {* Laufzeitmessung luft? *}
	IF startZeit <> 0 THEN AddChar(s,'.');
	SetStrLength (s,42);

        CASE art OF
         daFLEXNET : AddString(s,  'Flx');
         daDIGIWARE: AddString(s,  'DW ');
         daBAYCOM  : AddString(s,  'Bay');
         daSNet    : AddString(s,  'SNt');
         daTNN     : AddString(s,  'TNN');
	 ELSE CASE System OF
	       dsbox    : AddString(s, 'Box');
	       dsFLEXNET: AddString(s, 'FLX');
	       dsNETROM : AddString(s, 'ThN');
	       dsTCPIP  : AddString(s, 'TCP');
 	       ELSE       AddString(s, '   ');
           END;
        END;
        IF NOT fLinkTxDest THEN AddChar(s,'+');
        s := s+'   '+Text;
	IF pCB^.who=sysop THEN
	  BEGIN
	  AddString(s, ' Nr.' + FStr(i)
                     + '  redirectPID:$'+HexByteString(redirectPID));
	  IF hidden THEN AddString(s,  ' #');

	  END;

	IF (sUarg='') OR (Pos(sUarg, f_Upper(s)) >0) THEN TX_Info (pCB, SPAETER, s+EOL );
	END;
      END;
END;




PROCEDURE ListUser (pCB:TP_AXCB; sArg:String);
  VAR i,j   : Word;
      s     : String;

  TYPE T_lstMode = (cKURZSTAT,cLANGSTAT,cPATH);

  PROCEDURE DoUserExtraLong( lstModus: T_lstMode; PortNr : Byte);
    VAR i,j : Word;
  BEGIN
    Trim (sArg);
    IF lstModus = cPATH THEN s := ''
    ELSE BEGIN
         s :=   ' Nr.             RxRR RxREJ RxI RxPo FrAck MaxF Paclen'+ EOL;
         IF lstModus = cLANGSTAT THEN AddString(s,
		'                 TxRR TxREJ TxI TxPo Typ PID  Window   Txd'+ EOL);
         s := s+'----------------------------------------------------------'+EOL;
         END;
    TX_Info (pCB,SPAETER,EOL+s);
    FOR i := 1 TO maxAXCB DO IF cb[i] <> NiL THEN
      IF cb[i]^.qsotype <> qtBake THEN WITH cb[i]^ DO
       IF (PortNr=0) OR (PortNr=iface) THEN
	BEGIN
	s :=  f_Using (id,3) + '. '
	     + UhrZeit (loginH,LoginM)
	     +' P'+FStr(iface);
        IF lstModus = cPATH THEN AddString(s,'/'+FStr(aktifnr) );
	CASE state OF
	    CONNECTED	 : IF nUnbest = 0 THEN AddString(s, '  I')
					  ELSE AddString(s, ' U'+f_Using(nUnbest,1));
	    SETUP	 : AddString(s, ' C ' );
	    IGNORE	 : AddString(s, ' ..' );
	    DISCONNECTED : AddString(s, ' DM' );
	    DISCPENDING  : AddString(s, '  D' );
	    FRAMEREJECT  : AddString(s, ' FR' );
	  END;
	SetStrLength (s, 12);

        IF lstModus <> cPATH THEN
          BEGIN
	  AddString(s, f_Using( cb[i]^.wRRrx,   5)
                     + f_Using( cb[i]^.wREJrx,  5)
	             + f_Using( cb[i]^.wIrx,    5)
	             + f_Using( cb[i]^.wRxPolls,5)
                    );
	  IF cb[i]^.minFrack < MAXLONGINT
	    THEN AddString(s,' ' + F_UsingReal(cb[i]^.minFrack / 100, 5,1))
	    ELSE AddString(s,'    - ') ;
          AddString(s, f_Using( cb[i]^.maxFrame,2) + ' ' + +f_Using( cb[i]^.PacLen,4) + ' ');
          END;

        IF lstModus = cPATH THEN  AddString(s, '  ' + Txdelay2String(cb[i]) );

        AddString(s, ' ' + f_sh2asc (fromCall)+'>' + f_sh2asc (toCall));
        IF lstModus <> cPATH
          THEN AddString(s,' ('+FStr(nDigi)+')')
          ELSE BEGIN
    	       FOR j := 1 TO nDigi DO
                 BEGIN
                 AddString(s, ','+f_lower(f_sh2asc ( Digi[j] )) );
                 IF (Byte(Digi[j][7]) AND $80)<> 0 THEN AddChar(s,'*');
                 END;
               END;
        IF lstModus = cLANGSTAT THEN
          BEGIN
          AddString(s, EOL
                 + '           P'
                 + FStr(aktifnr) + '   '
                 + f_Using( cb[i]^.wRRtx,   5)
	         + f_Using( cb[i]^.wREJtx,  5)
	         + f_Using( cb[i]^.wItx,    5)
 	         + f_Using( cb[i]^.wTxPolls,5)
 	         + f_Using( Ord(cb[i]^.qsotype),4)
 	         + f_Using( (cb[i]^.PID),4)
 	         + f_Using( (cb[i]^.TxWind),5)
 	         + f_Using( (cb[i]^.RxWind),5)
                 + Txdelay2String(cb[i])
	         );
          END;

	WatchDog;
	IF (sArg='') OR (Pos (f_Upper(sArg), f_Upper(s)) > 0) THEN {*OPT*}
	   TX_TrimInfo (pCB, SPAETER, s+EOL );
	END; {if}
  END;


                   TYPE T_short_Long = (SHORT,LONG);
 PROCEDURE DoUser ( x : T_short_Long; {$IFDEF ver70} CONST {$ENDIF} sArg : String) ;
    VAR i	: Word;
	doit	: BOOLEAN;
	bHilf	: BOOLEAN;
	stZwisp : T_State;

       PROCEDURE AddUpLink ( pCB : TP_AXCB );
	 VAR j : Byte;
       BEGIN
         AddString(s, '('+FStr(pCB^.iface)+':' );
         IF pCB^.nDigi <> 0 THEN
	   BEGIN
	   FOR j := pCB^.nDigi DOWNTO 1 DO
       	     BEGIN
	     IF j < pCB^.nDigi THEN AddChar(s,',');
	     AddString(s,  f_lower(f_sh2asc ( pCB^.Digi[j] )));
	     END;
	   END;
         AddString(s,  ') ');
       END;

       PROCEDURE AddDownLink ( pCB : TP_AXCB );
	 VAR j : Byte;
       BEGIN
         AddString(s, ' ('+FStr(pCB^.iface)+':');
         IF pCB^.nDigi <> 0 THEN
	   BEGIN
	   FOR j := 1 TO pCB^.nDigi DO
	     BEGIN
	     IF j > 1 THEN s := s+',';
	     AddString(s,  f_lower(f_sh2asc ( pCB^.Digi[j] )));
	     END;
	   END;
         AddChar(s, ')');
       END;


  VAR pass : Byte; {* 0 = Digi, 1..NIFACE, nIface +1 = conserven *}
      n    : Word;
 BEGIN {* DoUserShort 3 Spalten *}
  n := 1;
{$IFDEF HOSTMODExxxx}
x HostUserList(pCB);
{$ENDIF}
  TX_Info(pCB, SPAETER, EOL+'Userlist:'+EOL);
  FOR pass := 0 TO MAX_IFACE+1 DO {* Ausgabe sortiert nach Infobox-Qsos, Interface, Converser ganz am Ende *}
   FOR i := 1 TO MaxAssignedCBId DO IF cb[i] <> NiL THEN
    BEGIN
    WatchDog;
    doit := (pass = cb[i]^.iface );
    IF cb[i]^.who=sysop THEN s := '*'
                        ELSE s := ' ';
    s := s+f_toCall2ascIface (cb[i]);
    SetStrLength( s, 10 );
    IF x = LONG THEN BEGIN
                     AddUpLink (cb[i]);
                     END;
    CASE cb[i]^.qsotype OF
       qtInfoBox
	 : BEGIN
	   bHilf := FALSE;
	   IF cb[i]^.pPartnerCB <> NiL THEN
	     IF cb[i]^.pPartnerCB^.qsotype = qtCQ THEN bHilf := TRUE;
	   IF bHilf THEN AddString(s,' > CQ')
                    {$IFDEF UserWare}
		    ELSE AddString(s,' > FALCon');
                    {$ELSE}
		    ELSE AddString(s,' > Digi');
                    {$ENDIF}
	   doit := (pass = 0);
	   END;
       qtConvers
	 : BEGIN {* $TODO IF pCb^.pCv=host then *; if remoteuser then (@host) *}
	   doit := (pass = MAX_IFACE+1);
	   IF doit THEN
             IF cb[i]^.pCv^.typ = cvLINK {* Grrr, sowas is nicht modular *}
               THEN AddString(s,  ' >>Cv-Link')
               ELSE AddString(s,  ' > conv.'+FStr(cb[i]^.pCv^.Kanal));
	   END;
       qtCircuitMaster
	 : IF cb[i]^.pPartnerCB <> NiL
             THEN BEGIN
                  IF cb[i]^.pid = PID_TEXT THEN s := s + '<>'
                                           ELSE s := s + '()';
	          IF x = LONG THEN AddDownLink (cb[i]^.pPartnerCB);
                  s := s + ' ' + f_toCall2ascIface (cb[i]^.pPartnerCB);
	          END
	     ELSE doit := FALSE;
{$IFDEF HOSTMODE}
       qtHOST
	 : BEGIN
           s := ' HostCh.' + PCB2HostChannelStr(cb[i]) + ' > ' + s;
	   END;
{$ENDIF}
	 ELSE {of CASE} doit := FALSE;
      END; {* Case *}

    IF doit THEN
      BEGIN
      stZwisp := cb[i]^.state;
      IF cb[i]^.pPartnerCB <> NiL THEN
	IF cb[i]^.pPartnerCB^.qsotype <> qtNULLQSO THEN
          BEGIN
          IF CheckAXCB(cb[i]^.pPartnerCB, cSTORE) THEN stZwisp := cb[i]^.pPartnerCB^.state;
          END;
      IF stZwisp = CONNECTED THEN
	      IF cb[i]^.nUnbest > 0 THEN ReplaceCh ('','-',s)
				    ELSE ReplaceCh ('','=',s)
      ELSE IF stZwisp = DISCPENDING THEN ReplaceCh ('',':',s)
      ELSE				 ReplaceCh ('','.',s);

      IF (Pos(sArg,f_Upper(s)) <> 0) OR (sArg='') THEN
        BEGIN
        IF (x=LONG) OR ((n MOD 3)=0) THEN AddChar(s,EOL)
                                     ELSE SetStrLength (s,27);
        Inc(n);
        TX_Info (pCB, SPAETER, s );
        END;
      END;
    END; {* FOR *}
  END;


  CONST COMANDS =
   'LONG XLONG CONVERS PATH STAT '; {* Letzte Leerzeichen ist wichtig *}
   cmLONG=1; cmXLONG=2; cmCONVERS=3; cmPATH=4; cmSTAT=5;
    cmdTab : ARRAY [1..Length(COMANDS)] OF Char = COMANDS;
   VAR PortNr : Word;
BEGIN
  PortNr := ScanForNum (sArg); {* Fr Flexnet Liebhaber  U 1 *}
  IF (PortNr = NOTANUMBER) OR (PortNr > MAX_AXIFACE)
    THEN BEGIN
         CASE ScanStr (sArg, @cmdTab, SizeOf (cmdTab)) OF
           cmLONG    : DoUser (LONG, sArg);
           cmXLONG   : DoUserExtraLong(cKURZSTAT,0);
	   cmCONVERS : {ListCvUser ( pCB, -1, sArg, cLANG );}
	               ListChannels ( pCB, TRUE{fNurLebende}, TRUE{fMitUser});
	   cmPATH    : DoUserExtraLong(cPATH,0);
           cmSTAT    : DoUserExtraLong(cLANGSTAT,0);
          ELSE DoUser (SHORT, sArg);
          END; {*case*}
         END
    ELSE DoUserExtraLong(cPATH,PortNr);
    {* aber OHNE Statistik, damit es genau so hlich wie bei Flexnet aussieht *}
END;




PROCEDURE DoListMHeard ( pCB : TP_AXCB; sArg : String);
 {* MHEARD  [LONG] [CALL|TIME] [MINUTEN <wert>]  [<text>]
  * MHEARD  [CLEAR|DELETE] *}
  CONST COMANDS =
   'LONG CALL TIME MINUTEN DELETE CLEAR '; {* Letzte Leerzeichen ist wichtig *}
    cmdTab : ARRAY [1..Length(COMANDS)] OF Char = COMANDS;
    cmLONG   = 1;   cmCALL  = 2;   cmTIME = 3;  cmMINUTEN = 4;
    cmDELETE = 5;   cmCLEAR = 6;

  VAR n, nCalls: Word;
      lastSek  : LongInt;
      i        : Byte;
      s        : String;
      LONG     : BOOLEAN;
      sortBy   : (time,call);
BEGIN
  LONG := FALSE; sortBy := time;    lastSek := NOTANUMBER;
  REPEAT
    i := ScanStr (sArg, @cmdTab, SizeOf (cmdTab));
    CASE i OF
	 cmLONG    : LONG := TRUE;
	 cmCALL    : sortBy := call;
	 cmTIME    : sortBy := time;
	 cmMINUTEN : lastSek := ScanForNum (sArg);
         cmDELETE,
         cmCLEAR   : IF pCB^.who=sysop THEN MHClear;
    END; {case}
  UNTIL i = 0;

  IF sortBy = time THEN SortMH_Time
		   ELSE SortMH_Call;

  {* Ein nicht erkanntes Argument blieb brig - also z.B MH DG9EP. *}
  {* Dann Long annehmen. Damit nicht z.B. MH P gemacht wird und damit *}
  {* alles ausgegeben wird, ist die Mindestlnge 2, also M DG ist noetig *}
  IF Length(sArg) > 1 THEN LONG := TRUE;

  {* Wenn ein nicht numerisches Argument angegeben wurde (z.B. IP:), *}
  {* so wird ein gengend langer Zeitraum angenommen, ansonsten die  *}
  {* letzten 10 Min                                                  *}
  IF lastSek = NOTANUMBER {* kein Minutenargument angegeben *}
    THEN BEGIN
         IF (sArg = '') AND LONG THEN lastSek :=    5*60
                                 ELSE lastSek := 1000*60;
         END
    ELSE lastSek := lastSek * 60;

  n := 1; nCalls := 0; s:= '';
  IF LONG THEN s :=  EOL +
		     '   first      last  port frames  CALL (via) - proto.'+EOL+
		     '----------------------------------------------------';
  TX_Info (pCB, SPAETER, EOL+'MHeard last '+fStr(lastSek DIV 60)+' min:'+s+EOL );
  WHILE n <= nMHeard DO  WITH pmHeard^[n] DO
    BEGIN
    WatchDog;
    IF (nPaket <> 0) THEN
     {* innerhalb der letzten x Sekunden: *}
     IF (UnixZeitNow-tlast) <= lastSek THEN
      IF NOT LONG
	THEN BEGIN
	     TX_Info(pCB, SPAETER,
                      StrRechtsBuendig( Sekunden2RelString( UnixZeitNow-tlast), 8)
                    + ' '
                    + f_sh2ascUsing(call,true,9)
             );
	     Inc (nCalls);
	     IF nCalls MOD 4 = 0 THEN TX_Info (pCB, SPAETER, EOL);
	     END
	ELSE BEGIN
	     s :=          StrRechtsBuendig( Sekunden2RelString( UnixZeitNow-tfirst), 8)
	        + ' -'   + StrRechtsBuendig( Sekunden2RelString( UnixZeitNow-tlast), 8)
                + '   P' + f_LeftUsing(ifnr,2)
		+ ' '    + f_Using(nPaket,5)
		+ '  '   + f_sh2asc ( call );

{	     IF (t<>Systime.day) OR (m<>Systime.month)
	       THEN s := ' ' + DatumTTMM (t,m)
	       ELSE s := ' ' + UhrZeit (h1,m1) ;
	     AddString(s, '-'+ UhrZeit (h2,m2)
		    + '   P' + f_LeftUsing(ifnr,2)
		    + ' '    + f_Using(nPaket,5)
		    + '  '   + f_sh2asc ( call )
             );
}
	     IF nDigi > 0 THEN s := s + ' v';
	     FOR i := 1 TO nDigi DO AddString(s,  ' ' + f_sh2asc ( Digi[i] ));
	     AddString(s,  ' -');
	     IF nText	   > 0 THEN  AddString(s,  ' ax:'    +FStr(nText));
	     IF nUI	   > 0 THEN  AddString(s,  ' ui:'    +FStr(nUI));
	     IF nDirekt    > 0 THEN  AddString(s,  ' d:'     +FStr(nDirekt));
	     IF ndigipeated> 0 THEN  AddString(s,  ' dig:'   +FStr(ndigipeated));
	     IF nIP	   > 0 THEN  AddString(s,  ' ip:'    +FStr(nIP));
	     IF nARP	   > 0 THEN  AddString(s,  ' arp:'   +FStr(nARP));
	     IF nAxSeg     > 0 THEN  AddString(s,  ' seg:'   +FStr(nAXSeg));
	     IF nNETROM	   > 0 THEN  AddString(s,  ' NetRom:'+FStr(nNETROM));
	     IF nFLEXNET   > 0 THEN  AddString(s,  ' Flx:'   +FStr(nFLEXNET));
	     IF nAndere    > 0 THEN  AddString(s,  ' Son:'   +FStr(nAndere));
	     WatchDog;
	     IF (sArg='') OR (Pos (f_Upper(sArg), f_Upper(s)) > 0)
	       THEN TX_Info (pCB, SPAETER,s+EOL);
	     END;
    Inc (n);
    END;

  FOR n := 0 to 255 DO
    IF aSonstPID[n] <> 0 THEN Tx_Info(pCB, spaeter, HexByteString(n)+':'+fStr(aSonstPID[n])+'  ');

END;



PROCEDURE DoHilfe (pCB:TP_AXCB; {$IFDEF ver70} CONST {$ENDIF} sArg : String);
  CONST txt1 =
   'Befehle der InfoBox:' + EOL +
    EOL+
   'Aktuell Beacon CLear COMment Connect Convers CQ      Dest' + EOL +
   'DIr     ECHo   Find  Help    Info    Links   Mailbox MHeard' + EOL +
   'Nodes   Param  QTh   Quit    Read    STatis  User    Version'  + EOL+
   EOL;
  txt2 =
   '<call> <text> auf der Kommandozeile schickt <text> an <call>, wenn <call> da'  + EOL;
  VAR Name : String;
BEGIN
  IF sArg <>''
    THEN BEGIN
	 IF	ReadTxt ( pCB, 'HELP_'+f_Upper(sArg), rtDEFAULT ) THEN;
	 END
    ELSE IF NOT ReadTxt ( pCB, 'HELP', rtNODEFAULT ) THEN
           BEGIN
	   TX_Info (pCB, SPAETER, txt1 );
	   TX_Info (pCB, SPAETER, txt2 );
           END;
END;

{  CQ-Zeug }

PROCEDURE MsgCQ (pCB : TP_AXCB; msg : T_Msg); Far;
  VAR s : String;
BEGIN
  CASE msg OF {* Andere sind nicht mglich... glaub ich jedenfalls *}
    msgSpecialT1Out : {* T1 ist abgelaufen, CQ wiederholen *}
       BEGIN
       {* Move (pCB^.divers.pCqText^,s, Byte(pCB^.pDiv^)+1); *}
       s := pCB^.divers.pCqText^;
       Tx_UInfo ( pCB, cKOMM, s);
       END;
    msgDiscReq,
    msgCBDel,
    msgRxDM,
    msgRetryCountExceeded :
       BEGIN {* Das wars... schwupp di wupp *}
       TX_EOLSysInfo ( pCB^.pPartnerCB, SOFORT, 'CQ ended'+EOL);
       pCB^.pPartnerCB^.pPartnerCB := NiL;
       IF pCB^.divers.pCqText <> NiL THEN
          MemFree ( Pointer(pCB^.divers.pCqText), Length(pCB^.divers.pCqText^)+1 );
       END;
    ELSE fnMsgDefault ( pCB, msg );
   END;
END;

PROCEDURE CQ (pCB:TP_AXCB; s:String; l:LongInt);
  VAR pCBCQ : TP_AXCB;
      ifnr  : t_ifnr;
BEGIN
  ifnr := pCB^.aktifnr;
  {* CQ ist nur auf einem Usereinstieg sinnvoll *}
  IF axIFace[pCB^.iface].art<>aUSER THEN ifnr := axIFace[pCB^.iface].mapIfnr;
  pCBCQ := CreateAXCB(ifnr);
  IF pCBCQ = NiL THEN BEGIN {* Kein Speicher, oder Pfad wird schon verwendet *}
		      TX_SysInfo (pCB,SOFORT, 'can''t call CQ now');
		      Exit;
		      END;
  Asc2axcb ( f_sh2asc(pCB^.toCall),    {* Ohje... $TODO *}
	     'CQ',
	     axIFace[ifnr].asMyCall+'*',
	     pCBCQ );
  pCBCQ^.fMsgHandler := MsgCQ;
  pCBCQ^.iface := ifnr;
  pCBCQ^.qsotype := qtCQ;
  pCBCQ^.pPartnerCB := pCB;
  pCB^.pPartnerCB := pCBCQ;
  pCBCQ^.state := DISCONNECTED;

  IF s = '' THEN s := 'CQ CQ CQ - pse connect '+f_sh2asc(pCB^.toCall)+' via '+axIFace[ifnr].asMyCall;
  IF Length (s) > 200 THEN Dec(Byte(s[0])); {* ???? *}
  MemGet ( Pointer(pCBCQ^.divers.pCqText), Length(s)+1);
  pCBCQ^.divers.pCqText^ := s;   {* MOVE (s, pCBCQ^.pDiv^, Length(s)+1); *}

  MsgCQ (pCBCQ, msgSpecialT1Out ); {* das ganze mal anstossen *}
  StartTimer (pCBCQ^.T1);
  TX_EOLSysInfo (pCB,SPAETER, 'calling CQ '
                              +FStr(pCBCQ^.retry)
                              +' times... at Port '
                              +FStr(ifnr)
                              +' pse QRX'+EOL);
END;

{}


PROCEDURE Infobox_Interpreter (pCB    : TP_AXCB;
                               von_wo : T_vonWo ;
                           VAR Info   : String);
 LABEL	l_eop,l_eop_mitPrompt;
 CONST	COMANDS =
{01} 'CON AKTUELLES BEACON CONNECT CONVERS DESTINATIONS FIND HELP INFO LINKS ' +
{11} 'MAILBOX QUIT WATCH USERS HOST CQ BYE LOGBUCH VERSION PARAMETER '+
{21} 'TECH 200 STATISTIK KILL TALK CLEAR NODES PROMPT QTH LOCATOR ' +
{31} 'HAL 2001 SETTIME SETDATE 4 PRIV COMMENT NRC ? UPLOAD ';
      COMANDS2 =
{41} 'READ BOX WRITE MYPACLEN TELL PORTS RESET DUMP INPUT OUTPUT '+
{51} 'ERROR FLAG ECHO 42 DIR RESTART DELETE RENAME REDIRECT TBL '+
{61} 'MHEARD PUT DESTLIST FAKE MSG SYSOP SYSBUSY DQUEUE TXQU ALDE AUTOLOGINCMD '+
{72} 'POKE PASSWORD '+#255+' DDEST DCF COUNT DOWNLOAD PS CHAT '#$80#$ff'BROADCAST ';
      COMANDS3 =
{82} 'PASSWORDMODE ';
     {* Letzte Leerzeichen ist wichtig ! *}
  {.. $80$ffBROADCAST <argumentcall z.b. QST-1>}
CONST
  cmCON=1;      cmAKTUELLES=2;  cmBEACON=3;     cmCONNECT=4;
  cmCONVERS=5;  cmDEST=6;       cmFIND=7;       cmHELP=8;
  cmINFO=9;     cmLINKS=10;     cmMAIL=11;      cmQUIT=12;
  cmWATCH=13;   cmUSERS=14;     cmHOST=15;      cmCQ=16;
  cmBYE=17;     cmLOGBUCH=18;   cmVERSION=19;   cmPARAMETER=20;
  cmTECH=21;    cmSTATISTIK=23; cmKILL=24;      cmTALK=25;
  cmCLEAR=26;   cmNODES=27;     cmPROMPT=28;    cmQTH=29;          cmLOCATOR=30;
  cmHAL=31;     cm2001=32;      cmSETTIME=33;   cmSETDATE=34;
  cmPRIV=36;    cmCOMMENT=37;   cmNRC=38;       cmQUESTIONMARK=39; cmUPLOAD=40;

  cmREAD=41;    cmBOX=42;       cmWRITE=43;     cmMYPACLEN=44;     cmTELL=45;
  cmPORTS=46;   cmRESET=47;     cmDUMP=48;      cmINPUT=49;        cmOUTPUT=50;
  cmERROR=51;   cmFLAG=52;      cmECHO=53;      cm42=54;           cmDIR=55;
  cmRESTART=56; cmDELETE=57;    cmRENAME=58;    cmREDIRECT=59;     cmTBL=60;
  cmMHEARD=61;  cmPUT=62;       cmDESTLIST=63;  cmFAKE=64;         cmMSG=65;
  cmSYSOP=66;   cmSYSBUSY=67;   cmDQUEUE=68;    cmTXQ=69;          cmALDE=70;
  cmAUTOLOGINCMD=71; cmPOKE=72; cmPASSWORD=73;  cmLOGBUCH2=74;     cmDDEST=75;
  cmDCF=76;     cmCOUNT=77;     cmDOWNLOAD=78;  cmPS=79;           cmCHAT=80;
  cmBroadcast=81;

  cmPASSWORDMODE=82;

     cmdTab : ARRAY [1..Length(COMANDS)] OF Char = COMANDS;
     cmdTab2: ARRAY [1..Length(COMANDS2)] OF Char = COMANDS2;
     cmdTab3: ARRAY [1..Length(COMANDS3)] OF Char = COMANDS3;
 VAR pm  : tp_mBuf;
     p	 : Pointer;
     bZwisp,i,j,
     lastCmd, cmpCmd : Byte;
     w,
     wZwisp : Word;
     lMArg1,lMArg2,
     lZwisp : LongInt;
     sZwisp,
     sOrgInfo,          {* Das unvernderte Kommando *}
     sMArg1,sMArg2,
     sUarg,
     sArg : String;   {* String Argument, String Upper Argument *}
     Fehler : INTEGER;
     fZwisp,
     bError,
     bPrompt : BOOLEAN;
     nZwispPw : ARRAY [1..5] OF Word;
BEGIN
  WHILE (Length(Info)>0) AND ( Info [Length(Info)] < #32 )
                         AND ( Info [Length(Info)] <> ^z ) DO  Dec (Byte(Info[0]));
  FOR i := 1 TO Length(Info) DO IF Info[i]=^I THEN Info[i] := ' ';
  LTrim (Info);
  TraceInfo( Info, pCB );

  bError := FALSE;
  bPrompt := TRUE;
  sOrgInfo := Info;
  Backup.Last_Cmd := f_sh2asc(pCB^.toCall)+'*I:'+Info;

  {* Status checken: Password Eingabe aktiv? *}
  IF pCB=pCBPW THEN {* nur der, der *zuletzt* SYSOP sachte *}
    IF pCB^.pInfoBox^.byLastCmd = cmSYSOP THEN
      BEGIN
      pCB^.pInfoBox^.byLastCmd := 0;
      SysopSNetLogin(pCB,info);
      Goto l_eop_mitPrompt;
      END;

  {* Write Aktiv? *}
  IF pCB^.pInfoBox^.byLastCmd = cmWRITE THEN
    IF length(Info) > 0 THEN
      BEGIN
      IF Info[1] = ^Z
        THEN BEGIN
             Close(fEEPROM);
             TX_EolSysInfo(pCB,SPAETER,'EEPROM written:'+FStr(IOResult));
             pCB^.pInfoBox^.byLastCmd := 0;
             Goto l_eop_mitPrompt;
             END
        ELSE BEGIN
             RTrim(Info); {* LTrim ist schon *}
             WriteLn(fEEPROM,Info);
             IF IOResult<>0 THEN TX_EolSysInfo(pCB,SPAETER,'Line: '+FStr(IOResult));
             Goto l_eop;
             END;
      END;

  IF Info[1] = ';' THEN GOTO l_eop;  {* ; = REMARK *}
  IF (Info[1] = '/') OR (Info[1] = '!') AND (von_wo<>CONV) THEN
    BEGIN
    TX_EOLSysInfo (pCB, SPAETER,
	'BTW: "'+Info[1]+'" is not necessary, since this isn''t CONVERS'+EOL);
    WHILE (Info[1] = '/') AND (Length(Info)>=1) DO Delete (Info,1,1);
    WHILE (Info[1] = '!') AND (Length(Info)>=1) DO Delete (Info,1,1);
    END;
  bZwisp := Pos (' ', Info);
  sArg := '';
  IF bZwisp <> 0 THEN sArg := Copy (Info, bZwisp, 255);
  RTrim (sArg); LTrim (sArg);
  bZwisp := Pos (' ', sArg ) ;
  IF bZwisp <> 0
    THEN BEGIN
	 sMArg1 := Copy(sArg, 1,	bZwisp-1);
	 sMArg2 := Copy(sArg, bZwisp+1, 255);
	 END
    ELSE BEGIN
	 sMArg1 := sArg;
	 sMArg2 := '';
	 END;
  Val (sMArg1, lMArg1, Fehler);
  Val (sMArg2, lMArg2, Fehler);
  sUarg := f_Upper (sArg);

  Val (sArg, lZwisp, Fehler);
  IF (lZwisp > 255) OR (lZwisp<0) THEN bZwisp := 0
				  ELSE bZwisp := lZwisp;

  lastCmd := ScanStr (Info, @cmdTab, SizeOf (cmdTab));
  IF lastCmd = 0 THEN
    BEGIN {*OPT* Nicht gefunden *}
    lastCmd := ScanStr (Info, @cmdTab2, SizeOf (cmdTab2));
    IF lastCmd <> 0
      THEN Inc (lastCmd,40)
      ELSE BEGIN {*OPT* Nicht gefunden *}
           lastCmd := ScanStr (Info, @cmdTab3, SizeOf (cmdTab3));
           IF lastCmd <> 0 THEN Inc (lastCmd,81);
           END;
    END;

  WatchDog;

  {* Abfangen wiederholter Kommandos *}
  IF (lastCmd IN [cmAKTUELLES,cmINFO,cmCOMMENT]) AND (pCB^.who <> sysop) THEN
    BEGIN {* Info, Aktuelles, Help *}
    IF	    lastCmd = cmAKTUELLES THEN cmpCmd := 1
    ELSE IF lastCmd = cmINFO	  THEN cmpCmd := 2
    ELSE IF lastCmd = cmCOMMENT	  THEN cmpCmd := 4
    ELSE cmpCmd := 0;

    IF ( (cmpCmd AND (pCB^.pInfoBox^.byLastCmd)) <> 0 )
      THEN BEGIN {* Aktuell, Help, Info *}
	   IF cmpCmd = 4 THEN TX_EOLSysInfo (pCB, SPAETER, 'not again!'+BELL)
                         ELSE TX_EOLSysInfo (pCB, SPAETER, 'you''ve already read this message'+ BELL);
	   lastCmd := 255;
	   END;
    pCB^.pInfoBox^.byLastCmd := pCB^.pInfoBox^.byLastCmd OR cmpCmd;
    END;

  WatchDog;

  CASE lastCmd OF
   cmCON : BEGIN
	   bPrompt := FALSE;
	   IF von_wo = INFOBOX THEN
	     IF (Fehler = 0) OR (sArg='')
	       THEN OpenConv (pCB, lZwisp)
	       ELSE IF NOT DoAscConnect ( pCB^.aktifnr, pCB, sUarg, WITHVIA, TRUE)
		      THEN bPrompt := TRUE;
	   END;
   cmCONNECT
	 : IF von_wo = INFOBOX THEN
	     IF DoAscConnect ( pCB^.aktifnr, pCB, sUarg, WITHVIA, TRUE ) THEN bPrompt := FALSE;
   cmCONVERS {* $IDEE stringArgument -> dann in den Kanal wechseln, der dieses Element als Topic hat)}
	 : IF von_wo = INFOBOX THEN OpenConv (pCB,lZwisp);
   cmAKTUELLES
	 : IF NOT ReadTxt (pCB, 'AKT', rtNODEFAULT ) THEN
	     IF NOT ReadTxt (pCB, 'AKTUELL', rtDEFAULT ) THEN;
   cmBEACON
	 : DoBeacon (pCB,sArg);  {* bei Nichtsysops wird nur aufgelistet *}
   cmNODES
         : IF useTheNet {* NODES *}
	     THEN DoListNodes (pCB, sArg)
	     ELSE DoDest ( pCB, sUarg, FALSE);
   cmDEST: {$IFDEF FlexNet}
           {**IF sMArg2='*'
             THEN DoDestList ( pCB, sMArg1 )
             ELSE ***} DoDest ( pCB, sUarg, FALSE)  {* Destinations *}
           {$ENDIF};
   cmTBL : {$IFDEF LZM} PrintLinkInfo ( pCB , sArg ){$ENDIF};
   cmFIND: IF von_wo = INFOBOX THEN {* FIND *}
 	      IF useFind THEN DoFind (pCB, sUarg)
	         	 ELSE TX_EOLSysInfo (pCB,SOFORT, 'FIND disabled');
   cmQUESTIONMARK,
   cmHELP: DoHilfe (pCB,sArg); {* HELP *}
   cmINFO: IF ReadTxt ( pCB, 'INFO', rtDEFAULT ) THEN;
   cmLINKS,
   cmPORTS
         : IF pCB^.who = sysop THEN SetLinks (pCB, sArg)
	                       ELSE ListLink (pCB, sUarg);
   cmMHEARD
         : DoListMHeard ( pCB, sUarg);
   cmBYE,
   cmQUIT: BEGIN {* QUIT *}
	   DoQuit (pCB);
	   bPrompt := FALSE;
	   END;
   cmWATCH
         : IF pCB^.who = sysop
	     THEN IF sArg = '' THEN ListWatch (pCB)
			       ELSE BEGIN
                                    CvMacro (pCB, sArg,sUarg); { Damit z.B. der Auszugebene Text umgewandelt wird}
                                    SetWatch (pCB,sUarg)
                                    END
	     ELSE bError := TRUE; {* Fehler simulieren *}
   cmUSERS
         : ListUser ( pCB, sUarg); {* USER *}

   cmPASSWORD
         : IF von_wo=DIGISETUP THEN GenPassWord( lZwisp ) {* Nur beim Anlaufen des Digis erlaubt - nicht Remote ! *}
                               ELSE bError := TRUE;

   cmCQ  : IF von_wo = INFOBOX THEN CQ (pCB, sArg, lZwisp); {* CQ *}

   cmLOGBUCH2
         : DumpLog (pCB,sUarg<>'L');
   cmLOGBUCH
         : IF (pCB^.who<>sysop)
	     THEN bError := TRUE
	     ELSE IF sUarg = 'CLEAR' THEN ClearLog
	  		             ELSE DumpLog (pCB,sUarg<>'L');
   cmVERSION
         :  IF von_wo=DIGISETUP
               THEN sVersionCFG := sArg
               ELSE IF sArg =''
                      THEN TX_EOLSysInfo (pCB, SPAETER, COPYRIGHT1+EOL)
                      ELSE TX_EOLSysInfo (pCB, SPAETER,
                           {$IFDEF DAMA_SLAVE}+'d'  {$ENDIF}
                           {$IFDEF SCC}       +'S'  {$ENDIF}
                           {$IFDEF Userware}  +'U'  {$ENDIF}
                           {$IFDEF Deutsch}   +'g'  {$ENDIF}
                           {$IFDEF v24life}   +'v'  {$ENDIF}
                           {$IFDEF FlexNet}   +'f'  {$ENDIF}
                           {$IFDEF LZM}       +'l'  {$ENDIF}
                           {$IFDEF BroadCast} +'b'  {$ENDIF}
                           {$IFDEF MemStack}  +'M'  {$ENDIF}
                           {$IFDEF DCF}       +'d'  {$ENDIF}
                           {$IFDEF DG5MPQ_STA}+'q'  {$ENDIF}
                           {$IFDEF Debug}     +'D'  {$ENDIF}
                           {$IFDEF AllFar}    +'A'  {$ENDIF}
                           {$IFDEF SLIP}      +'s'  {$ENDIF}
                           {$IFDEF HostMODE}  +'h'  {$ENDIF}
                           {$IFDEF ALDE}      +'a'  {$ENDIF}
                           {$IFDEF VirtAdr}   +'V'  {$ENDIF}
                           {$IFDEF Sammler}   +'$'  {$ENDIF}
                           + '  ' + csPLATTFORM + EOL
                           + sVersionCFG
                           );
   cmPARAMETER
         : DoParameter (pCB, sArg);

   cmPASSWORDMODE
         : IF pCB^.who<>sysop
              THEN bError := TRUE
	      ELSE BEGIN
                   IF ( lMarg1> MAXLENPW) AND (lMArg1 <= cMAXPWLISTSIZE) THEN
                      MAXPWGRUNDMENGE := lMarg1;
                   IF sMArg2 <> '' THEN PWGENOFF := lMArg2;
                   TX_EOLSysInfo (pCB, SPAETER, 'Passwordmode: '
                                              + fStr(MAXPWGRUNDMENGE)
                                              + ' ' + fStr(PWGENOFF) );
                   END;
   cmPRIV, {*** SysopLogin(pCB, sArg); ***}
   cmSYSOP
         : BEGIN  {* DG6MAY: Passwort  la TheNet/SNet *}
           bPrompt := FALSE;
           sArg := '';
           MyRandomize; {* Wichtig! Darf nicht fehlen! *}
           FOR i := 1 TO MAXLENPW DO
             BEGIN
             REPEAT
               w := MyRandom(MAXPWGRUNDMENGE);  {* 0.. *}
               bError := FALSE;
               {* Verhindere, da derselbe Index 2mal hintereinadener kommtDublette raussuchen *}
               FOR j := 1 TO i-1 DO
                 IF w=nZwispPw[j] THEN bError := TRUE;
             UNTIL NOT bError;
             nZwispPw[i] := w;
             sPW[i] := chPwList[w];
             AddString(sArg,FStr(w+PWGENOFF)+' ');
             END;
           sPW[0] := char(MAXLENPW);
           TX_Info(pCB,SOFORT, axIFace[pCB^.aktIFnr].asMyIDENT+':'+
                               axIFace[pCB^.aktIFnr].asMyCall+'> '+sArg+EOL);
           pCB^.pInfoBox^.byLastCmd := cmSYSOP;
           pCBPW := pCB;
           END;
   cmSYSBUSY
         : IF pCB^.who<>sysop THEN bError := TRUE
			      ELSE DoSysBusy (pCB,sArg);
   cmKILL: IF pCB^.who=sysop THEN DoKill (pCB, lZwisp)
			     ELSE bError := TRUE; {* KILL *}
   cmFLAG : IF pCB^.who<>Sysop
              THEN bError := TRUE
              ELSE BEGIN
                   FOR i := 1 TO MAXUSEFLAGS DO
                     IF Pos( f_Upper(sMArg1),f_Upper(scUseDesc[i])) = 1 THEN
                       BEGIN
                       Toggle (pCB, use[i], scUseDesc[i], sMArg2, NOTANUMBER);
                       END;
                   END;

   cmTELL: IF pCB^.who=sysop THEN DoTell (pCB, sArg )
			     ELSE bError := TRUE;  {* TELL *}
   cmCLEAR
         : BEGIN {* Lsche TXQ *}
	   Del_mBuf_Chain (pCB^.TxBuf);
	   pCB^.TxBufTail := NiL;
	   pCB^.TxBufSize := 0;
	   END;
   cmPROMPT
         : BEGIN
	   IF (sArg <> '') AND (pCB^.who=sysop) THEN sPromptTemplate := sArg;
	   TX_EOLSysInfo (pCB, SPAETER, '"'+sPromptTemplate+'"' + EOL );
	   END;
   cmAUTOLOGINCMD
         : BEGIN
	   IF (sArg <> '') AND (pCB^.who=sysop) THEN sLoginAutoCMD := sArg;
	   TX_EOLSysInfo (pCB, SPAETER, '"'+sLoginAutoCMD+'"' + EOL );
	   END;
   cmSETTIME
         : IF pCB^.who<>sysop
	     THEN bError := TRUE
	     ELSE BEGIN {* SETTIME *}
		  IF Length (sArg)=4
		    THEN SetTime (f_val (sArg) DIV 100, f_val(sArg) MOD 100, 0,0)
		    ELSE TX_EOLSysInfo (pCB, SPAETER, 'usage: SETTIME hhmm');
		  GetTime( Systime.hour, Systime.min, Systime.sec, wDummy) ;
		  TX_EolSysInfo (pCB, SPAETER, FStr(Systime.hour)+'.' + FStr (Systime.min)+'.' + FStr (Systime.sec));
		  END;
   cmSETDATE
         : IF pCB^.who <> sysop
	     THEN bError := TRUE
	     ELSE BEGIN {* SETDATE *}
		  IF Length(sArg) = 8
		    THEN SetDateDW (f_val (sArg) MOD 10000, ((f_val(sArg) MOD 1000000) DIV 10000), f_val(sArg) DIV 1000000)
		    ELSE TX_EolSysInfo(pCB, SPAETER, 'SYNTAX:  SETDATE DDMMYYYY');
		  GetDate( Systime.Year, Systime.month, Systime.day, wDummy) ;
		  TX_EolSysInfo(pCB, SPAETER, FStr(Systime.day)+'.' + FStr (Systime.month)+'.' + FStr (Systime.Year));
		  END;
   cmHAL,
   cm2001: BEGIN {* HAL *}
	   TX_EOLSysInfo (pCB, SOFORT, ' I don''t think, that this was a good idea, Dave...'+EOL);
	   LogAddEntry ( pCB, leAutoComment , '2001/HAL' );
	   END;
   cm42  : BEGIN
	   CASE MyRandom (100) OF {* 42: The PRitchhikers Guide to DigiWare *}
	       1..33 : sZwisp := ' "Don''t blame you" said Marvin and then turned himself off.';
	      34..66 : sZwisp := ' "Yes, this is the answer, but what''s the question ?"';
	      ELSE sZwisp := ' "Stop it, or Prostetnic Vogon Jeltz will read a poem for you"';
	      END;
            TX_Info (pCB,SOFORT, EOL+sZwisp+EOL) ;
	    LogAddEntry ( pCB, leAutoComment , '"42"' );
	    END;
   cmCOMMENT
         : BEGIN {* Comment *}
	   IF sArg = '' THEN TX_SysInfo (pCB,SPAETER,'argument required')
                        ELSE BEGIN
			     LogAddEntry (pCB, leComment, sArg);
			     TX_SysInfo (pCB,SPAETER,'ok');
			     END;
	    END;
   cmNRC : IF NOT useTheNet
	     THEN TX_EOLSysInfo (pCB, SOFORT, 'NET/ROM z.Zt. ausser Betrieb')
	     ELSE IF von_wo = INFOBOX THEN
		    BEGIN
		    bPrompt := NOT DoConnect_NR ( pCB, sArg );
		    END;
{$IFDEF MitUpLoad}
   cmUPLOAD
         : IF (pCB^.who = sysop)
	     THEN BEGIN
	          DoUpload (pCB,FALSE);
	          bPrompt := FALSE;
	          END
	     ELSE bError := TRUE;
   cmFAKE
         : IF von_wo = INFOBOX THEN BEGIN
	   DoUpload (pCB,TRUE);
	   bPrompt := FALSE;
	   END;
   cmDOWNLOAD
         : IF von_wo = INFOBOX THEN
             BEGIN
  	     bError := NOT DoDownload (pCB,lZwisp);
	     bPrompt := FALSE;
	     END ELSE bError := TRUE;
{$ENDIF}
   cmRESET,
   cmRESTART
         : IF (pCB^.who = sysop)
	     THEN BEGIN
                  IF sArg='DoIt' THEN WHILE TRUE DO; {* Watchdog, bernehmen Sie *}
	          DoRestart (pCB,sArg);
	          bPrompt := FALSE;
	          END
	     ELSE bError := TRUE;
   cmMAIL,
   cmBOX : BEGIN {* BOX *}
	   IF (von_wo = INFOBOX) THEN
             IF sArg <> ''
                THEN TX_EOLSysInfo (pCB,SPAETER,'Befehl Box/Mailbox bedarf keiner Parameter')
                ELSE BEGIN
{$IFDEF BoxMailBox}
                     IF lastCmd=cmBOX
                       THEN BEGIN
        	            IF NOT DoAscConnect ( 3, pCB, 'DL8MAR-1', WITHVIA, TRUE)
                              THEN TX_EOLSysInfo (pCB,SPAETER,'can''t connect')
                              ELSE bPrompt := FALSE;
                            END
                       ELSE
{$ENDIF}
                            BEGIN
  	                    IF NOT DoAscConnect ( boxIFACE, pCB, boxPfad, WITHVIA, TRUE)
                              THEN TX_EOLSysInfo (pCB,SPAETER,'can''t connect')
                              ELSE bPrompt := FALSE;
                            END;
                     END;
	    END;
   cmREAD : IF (sUArg <> 'EEPROM') OR (pCB^.who <> sysop)
	      THEN BEGIN
		   IF NOT ReadTxt (pCB, sArg, rtNODEFAULT ) THEN
		      TX_EOLSysInfo (pCB, SPAETER, 'no such text'+EOL);
		   END
	      ELSE BEGIN
		   Assign24c65(fEEPROM);
		   Reset(fEEPROM);
                   IF IOResult = 0 THEN
                     BEGIN
		     WHILE Not eof(fEEPROM) DO
		       BEGIN
		       ReadLn(fEEPROM,sZwisp);
		       Tx_Info(pCB,SOFORT,sZwisp+EOL);
		       END;
		     Close(fEEPROM);
                     END;
		   END;
   cmWRITE
	 : IF (von_wo = INFOBOX) THEN
{$IFnDEF UserWare}    {* Nur bei DigiWare darf nur der SYSOP schreiben *}
	     IF pCB^.who<>sysop
	       THEN BEGIN
                    bError := TRUE
                    END
	       ELSE
{$ENDIF}
                    BEGIN
		    pCB^.pInfoBox^.byLastCmd := 0; {* Wenn i.O dann KEIN Prompt *}
		    IF sUArg <> 'EEPROM'
		      THEN BEGIN
  	                   IF pCB^.who<>sysop THEN
                             BEGIN {* Geht nur bei TermWare *}
                             sArg := f_sh2AscOhneSSID(pCB^.toCall) + ' ' + sArg;
                             maxWriteSize := 3000;
                             END;
			   bPrompt := NOT DoWrite(pCB, sArg)
			   END
		      ELSE BEGIN {$I-}
  	                   IF pCB^.who=sysop THEN
                             BEGIN
			     Assign24c65(fEEPROM);
  			     ReWrite(fEEPROM);
			     wZwisp := IOResult;
			     bPrompt := (wZwisp <> 0);
			     Tx_EolSysinfo(pCB,SOFORT,'Write EEPROM: '+FStr(wZwisp)+EOL);
			     IF NOT bPrompt THEN pCB^.pInfoBox^.byLastCmd := cmWRITE;
                             END;
			   END;
	            END;
   cmSTATISTIK
         : IF bZwisp<>255 THEN DoListPaketStatistik (pCB,bZwisp)
                          ELSE IF pCB^.who=sysop THEN ClearPaketStatistik;
   cmCOUNT
         : BEGIN
           j := 0;
           IF (sUArg='-R') AND (pCB^.who=sysop)
             THEN FillChar(count,sizeof(count),#0)
             ELSE BEGIN
                  TX_Info (pCB,SPAETER, EOL);
                  FOR i := 1 TO MAXCOUNT DO
                    BEGIN
                    IF count [i] <> 0 THEN sZwisp := sCountDesc[i]+':'+f_Using(count[i],6)+'     '
                                      ELSE sZwisp := sCountDesc[i]+':'+'   ---'             +'     ';
                    IF (sArg='') OR (Pos(sArg,sZwisp)>0) THEN
                      BEGIN
                      Inc(j);
                      IF j MOD 4 = 0 THEN AddChar(sZwisp,eol);
                      TX_Info (pCB,SPAETER, sZwisp);
                      END;
                    END;
                  END;
           END;
   cmTECH: IF sArg <> ''
	      THEN BEGIN
		   TX_Info (pCB,SPAETER, EOL+csHeaderStatus2Str);
		   FOR wZwisp := 1 TO maxAXCB DO
		     IF cb[wZwisp] <> NiL THEN
		       BEGIN
		       sZwisp := f_AxcbStatus2Str(wZwisp);
		       IF Pos( f_Upper(sArg), f_Upper(sZwisp) ) > 0 THEN
			  TX_Info (pCB,SPAETER, EOL+sZwisp);
                       WatchDog;
		       END;
		   END
	      ELSE BEGIN
		   TX_Info (pCB,SPAETER, EOL+GetSysInfo4Beacon(pCB^.iface));
		   TX_Info (pCB,SPAETER, EOL+GetRemoteStatus);
		   END;

   cmPOKE: IF (pCB^.who=sysop) THEN DoPoke (pCB,sUarg)
			       ELSE bError := TRUE;
   cmDUMP: IF (pCB^.who=sysop) THEN DoDump (pCB,sUarg)
			       ELSE bError := TRUE;
   cmINPUT
         : IF (pCB^.who=sysop) THEN DoInput (pCB,sUarg)
			       ELSE bError := TRUE;
   cmOUTPUT
     	 : IF (pCB^.who=sysop) THEN DoOutput (pCB,sUarg)
	       		       ELSE bError := TRUE;
   cmERROR
         : DoError (pCB,(bZwisp=1));

{$IFDEF MitLocator *}
  cmLOCATOR,
  cmQTH:   IF sArg='' {* Kein Argument (also Locator) angegeben -> Benutzerhinweis senden *}
	       THEN  TX_EOLSysInfo (pCB, SPAETER,{***}
                            'usage: QTh locator [locator]'+EOL
                          + 'Beispiele:'+EOL
                          + ' QTH JO31LF dk65b'+EOL
                          + ' QT dk65B O6,57,30/N51,13,45'+EOL
                          + ' QTH jo31le')
	       ELSE CompQTH(pCB,sMArg1,sMArg2);
{$ENDIF}
  cmECHO  : BEGIN
	    TX_Info (pCB,SPAETER, EOL+BELL+'Echo '+UhrZeit(Systime.hour,Systime.min)+':');
	    TX_Info (pCB,SOFORT, EOL + sArg + EOL);
	    END;

  cmDIR   : BEGIN
	    fZwisp := FALSE;
	    FOR i := 1 TO MAXTXT DO
	      IF apText[i] <> NiL THEN WITH apText[i]^ DO
	       IF (NOT fHidden) OR (pCB^.who=sysop) THEN
		BEGIN
		IF NOT fZwisp THEN TX_EOLSysInfo( pCB, SPAETER,
			 'Vorhandene Texte (lesen mit  READ <name>):'+EOL+
			 ' Name     Laenge  Erstellt am   Wie oft gelesen'+EOL+
			 '-----------------------------------------------');
		fZwisp := TRUE;
		TX_Info( pCB, SPAETER, EOL + ' '
				       + StrUsing(Name,MAXTXTNAMELEN+1)
				       + f_Using(size,6) + '  '
				       + Time2StrTTMMHHMM( writeTime )+ ' '
                                       + Char (32+Ord(cdir   )*(Byte('C')-Byte(' ')) )
                                       + Char (32+Ord(fHidden)*(Byte('H')-Byte(' ')) )
				       + f_Using(ReadCount,5) + '  '
				       + sTitel );
		END;
	    IF NOT fZwisp THEN TX_EOLSysInfo( pCB, SPAETER, csNOTEXT);
	    END;
   cmDELETE
	  : IF pCB^.who<>sysop
	       THEN bError := TRUE
	       ELSE IF DelTxt (sArg) THEN TX_EOLSysInfo (pCB, SPAETER, 'deleted');

   cmRENAME
	 : IF pCB^.who<>sysop
	       THEN bError := TRUE
	       ELSE IF RenTxt(pCB, sMArg1,sMArg2) THEN TX_EOLSysInfo (pCB, SPAETER, 'renamed');

   cmREDIRECT
       	 : IF pCB^.who<>sysop
	     THEN bError := TRUE
             ELSE BEGIN
                  IF (lMArg1 > 0) AND (lMArg1 < maxAXCB) THEN
                    IF cb[lMArg1] <> NiL THEN
                      BEGIN
                      IF lMArg2 <= MAX_axIFACE THEN
                        BEGIN
	                cb[lMArg1]^.redirectIfNr := lMArg2;
                        END;
   		      TX_Info (pCB,SPAETER,EOL+FStr( lMArg1 ) +': P'+FStr(cb[lMArg1]^.redirectIfNr) );
		      END;
	          END;
   cmPUT : IF pCB^.who = sysop THEN
             BEGIN {*$TODO: analog etwas in den RX-Buffer reintuen (ENQueeu) *}
             bZwisp := f_val (sMArg1);
             IF (bZwisp > 0) AND (bZwisp <= maxAXCB) THEN
               IF cb[bZwisp] <> NiL THEN
                 BEGIN
                 CvMacro(pCB,sMArg2,sArg);
                 TX_Info(cb[bZwisp], SOFORT, sArg );
                 END;
             END;
   cmMYPACLEN
	   : BEGIN
	     IF (lZwisp <= MAXPACLEN) AND (lZwisp>10) THEN pCB^.PacLen := lZwisp;
	     TX_Info(pCB,SPAETER, FStr(pCB^.PacLen) );
	     END;
{$IFDEF FlexNet}
   cmDDEST,
   cmDESTLIST
         : DoDestList (pCB, sArg);
{$ENDIF}
   cmDQUEUE
         : BEGIN
             {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
             IF bZwisp=0 THEN
               BEGIN
               FOR w := 0 TO MAXSTATOC DO IF statoc[w] <> 0 THEN
                 BEGIN
                 TX_Info( pCB, SPAETER, f_Using(w,3)+':'+f_Using(statoc[w],5)+'       ');
                 END;
               END
             ELSE IF bZwisp=1 THEN
               BEGIN
               FOR w := 0 TO MAXSTATInuse DO IF statInuse[w] <> 0 THEN
                 BEGIN
                 TX_Info( pCB, SPAETER, f_Using(w,3)+':'+f_Using(statInuse[w],5)+'       ');
                 END;
               END
             ELSE IF bZwisp=2 THEN
               BEGIN
               FOR w := 0 TO MAXaDELTATIME DO IF aDELTATIME[w] <> 0 THEN
                 BEGIN
                 TX_Info( pCB, SPAETER, f_Using(w,3)+':'+f_Using(aDELTATIME[w],5)+'       ');
                 END;
               END
{$IFDEF brauchmer_nichmehr .... knock on wood *}
             ELSE IF (bZwisp < 100) AND (bZwisp > 0)
              THEN BEGIN {* 1-100: *}
                   IF cb[bZwisp] <> NiL THEN
                     FOR i := 0 TO 7 DO Tx_DebugPM (pCB, cb[bZwisp]^.txq[i],40);
                   I := 1; sZwisp:= '';
                   pm := axIFace[cb[bZwisp]^.iface].tx_root;
                   WHILE (pm <> NiL) AND (i<20) DO
                     BEGIN
                     sZwisp := sZwisp + HexAddrString(pm)+ ' ';
                     pm := pm^.next;
                     Inc(i);
                     END;
                   TX_Info (pCB, SOFORT, EOL+sZwisp);
                   END
             ELSE IF (bZwisp >= 101) AND (bZwisp <=102)
              THEN BEGIN
                   I := 1; sZwisp:= '';
                   pm := axIFace[bZwisp-100].tx_root;
                   WHILE (pm <> NiL) AND (i<20) DO
                     BEGIN
                     Tx_DebugPM (pCB, pm,40);
                     pm := pm^.next;
                     Inc(i);
                     END;
                   END
              ELSE IF (bZwisp = 100)
               THEN BEGIN
                    Tx_DebugPM (pCB, lstDel.Root,40 );
                    END
              ELSE IF (bZwisp >= 201) AND (bZwisp <= 240)
               THEN BEGIN
                    IF cb[bZwisp-200] <> NiL THEN
                      FOR i := 0 TO 7 DO Tx_DebugPM (pCB, cb[bZwisp-200]^.txq[i],255);
                    TX_Info (pCB, SOFORT, EOL);
                    END
               ELSE BEGIN
                    Tx_DebugPM (pCB, Scan4Adr(sUarg),255);
                    END;
{$ENDIF}
             {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
             END;
   cmTXQ : IF (bZwisp < 100) AND (bZwisp > 0)
              THEN IF cb[bZwisp] <> NiL THEN
                     FOR i := 0 TO 7 DO
                       IF cb[bZwisp]^.txq[i] <> NiL THEN
                         cb[bZwisp]^.txq[i]^.txed := TRANSMITTED;

   cmALDE : ALDEList(pCB);

   cmMSG,
   cmTALK: IF DoTalk ( pCB, sArg) THEN;

   cmPS  : BEGIN
           TX_Info(pCB,SPAETER,csPSHeader+EOL);
           FOR i := 1 TO MaxTask DO
             BEGIN
             sZwisp := PsZeile(i);
             IF sZwisp<>'' THEN TX_Info(pCB,SPAETER, sZwisp + EOL );
             END;
           TX_Info(pCB, SPAETER, F_UsingReal( nTaskSwitch / slowtick / 2, 8,2 ));
           EnD;
   cmBROADCAST:
           BEGIN
           pCB^.pInfoBox^.fIgnore := true;
           END;
{$IFDEF HostMode}
   cmCHAT,
   cmHOST: BEGIN
           bPrompt := NOT OpenHost (pCB, TRUE, TRUE, cSSIDEgal);
           END;
{$ENDIF}
{$IFDEF DCF}
   cmDCF: BEGIN
          IF (pCB^.who=sysop) THEN
            BEGIN
            IF (sUarg='OFF') AND to_do_dcf THEN
              BEGIN; {* DCF OFF *}
              to_do_dcf:=FALSE;
              sZeitZone:='Local';
              DCF_Error_Termination(4);
              END;
            IF (sUarg='ON' ) AND (NOT to_do_dcf) THEN
              BEGIN; {* DCF ON *}
              to_do_dcf:=TRUE;
              DCF_Error_Termination(4);
              END;
            IF (f_Upper(sMArg1)='SET') THEN
              BEGIN {* DCF SET MINUTEN -> wieoft soll die Uhr gestellt werden *}
              IF sMArg2<>'' THEN
                BEGIN;
                IF (f_val(sMArg2)>1) AND (f_val(sMArg2)<541) THEN DCF_Sync_Timer:=(f_val(sMArg2)*60)-70;
                Calc_DCF_SwBack
                END;
              END;
            END; {* ifSysop *}

          Tx_EoLSysInfo(pCB,SPAETER,
           'DCF-77 Status at '+l_Uhrzeit(Systime.hour,Systime.min,Systime.sec)+' '+sZeitZone
               + EOL + 'done Set   Nr.  : '+fStr(DCF_Set_Count)+' '+DCF_Last_Set
               + EOL + 'overall    Err. : '+fStr(DCF_Error)+' '+DCF_Last_Err
               + EOL + 'sequential Err. : '+fStr(DCF_Seq_Error)
               + EOL + 'max. seq.  Err. : '+fStr(DCF_Sw_Back)+EOL);
          IF NOT to_do_dcf
            THEN TX_Info(pCB,SPAETER,'DCF sync. disabled'+EOL)
            ELSE BEGIN;
                 TX_Info(pCB,SPAETER,'Set-Interval    : every '+fStr((DCF_Sync_Timer+70)DIV 60)+' Min.'+EOL);
                 TX_Info(pCB,SPAETER,'next Set        : ');
                 IF do_dcf
                   THEN BEGIN;
                        TX_Info(pCB,SPAETER,'in progress'+EOL
                                 +'Syncron Gap     : ');
                        IF DCF_Start THEN TX_Info(pCB,SPAETER,'found')
                                     ELSE TX_Info(pCB,SPAETER,'wait');
                        TX_Info(pCB,SPAETER,EOL+'Code Position   : '+fStr(DCF_Code_Count)+EOL);
                        END
                   ELSE TX_Info(pCB,SPAETER,fStr(((DCF_Sync_Timer+70)DIV 60)-(DCF_Count+70)DIV 60)+' '' '+
                                     fStr(59-((DCF_Count+60)MOD 60))+' "'+EOL);
                 END;
          END;
 {$ENDIF}


   255	 : ; {* nur Prompt ausgeben }

   ELSE BEGIN {* Direkt Laber Modus *}
        IF DoTalk (pCB, Info) THEN bPrompt := FALSE {* Prompt strt nur *}
                              ELSE bError := TRUE;
        END;
  END; {* CASE *}

  IF NOT bError
    THEN pCB^.pInfoBox^.InvalidCount := 0 {* Alles ok gewesen *}
    ELSE BEGIN
	 Inc (pCB^.pInfoBox^.InvalidCount);
	 IF pCB^.pInfoBox^.InvalidCount > 5
	   THEN BEGIN {* to many invalid commands entered *}
		DoQuit (pCB);
		bPrompt := FALSE;
		END
	   ELSE BEGIN {* Fehlerhaftes Kommando *}
		IF sOrgInfo = ''
		  THEN bPrompt := FALSE
		  ELSE BEGIN
                       IF length(sOrginfo) > 15 THEN
                          BEGIN
                          sOrgInfo[0] := #15;
                          AddString(sOrgInfo,'...');
                          END;
		       sArg := '';
		       FOR i := 1 TO Length(sOrgInfo) DO
			 IF sOrgInfo[i] < #32 THEN sArg := sArg + '^' + Char(64+Byte(sOrgInfo[i]))
					      ELSE sArg := sArg + sOrgInfo[i];
		       TX_EOLSysInfo (pCB, SPAETER, 'invalid command ("'+sArg+'")'+EOL);
		       END;
		IF (pCB^.pCv = NiL) AND (von_wo<>DIGISETUP) THEN TX_Info (pCB, SPAETER, EOL +
			       'Q)uit  H)elp  L)inks  M)ailbox  MH)eard  C)onnect  I)nfo  U)ser  C)onvers');
                               {* Quit als Erstes, das verkuerzt bei S+F-Abreissern die Qual der DieBox *}
		bPrompt := TRUE;
		END;
	 END;
l_eop_mitPrompt:
  IF bPrompt THEN DoPrompt (pCB);
l_eop:
END;


PROCEDURE Rx_InfoBox( VAR pCB : TP_AXCB );
 {* Wird aufgerufen, sobald in der RXQ eines pCB fr die Infobox was steht *}
 VAR sZeile : String;
     i,pidwrong : BYTE;
BEGIN
  IF pCB^.rxBufSize = 0 THEN Exit; {* oder auch nicht *}
  IF pCB^.pInfoBox^.fIgnore THEN Exit;

  {$IFDEF SLIP}
  IF pCB^.PID = PID_IP {OR pid8} THEN
    BEGIN
    DoAxIP(pCB);
    Exit;
    END;
  {$ENDIF}

  IF pCB^.PID <> PID_TEXT THEN
   IF pCB^.PID <> PID_PACKES THEN
    BEGIN {* InfoBox aktzeptiert nur PID_TEXT *}
    {$IFDEF SLIP}
       WHILE FrameInfo2String_CR (pCB) <>'' DO; {Puffer leeren}
       Exit; {* hmmmmmm *}
    {$ENDIF}
    pidWrong := pCB^.pid;
    {* Durchsuche PID-Call-Tabelle *}
    {* FOR i := 1 TO maxLinks DO
     * IF link[i].valid AND (link[i].redirectPID=pidWrong) THEN
        BEGIN *} {* Call gefunden *}
        {* QSO nach link[i] aufbauen *}
        {* IF DoAscConnect ( link[i].portNr, pCB, f_sh2asc (pCB^.fromCall),
         *                   WITHOUTVIA, FALSE ) THEN Exit;
         * Exit;
         *}
        {* END; *}

    {* Tja. Was sollen wir hiermit tun? Nix. Wegschmeissen. *}
    DoDisconnectImm (pCB);
    Exit;
    {* IF pidWrong = PID_NETROM THEN
     *   BEGIN
     *   {* Antworten?! wenn es ein L3RTT ist, dann dieses Frame zurckschicken *}{
     *   DoDisconnectImm (pCB);
     *   Exit;
     *   END;
     * pCB^.PID := PID_TEXT; {* Muss gesetzt werden, Text MUSS nun mal in PID_TEXT gesendet werden *}{
     * pCB^.fMsgHandler := fnMsgDefault;
     * TX_EOLSysInfo (pCB,SOFORT, 'sri, you must use PID F0h for the infobox. You are using PID '+
     *                            fstr(pidwrong)+' dec., so try VIA-connect next time');
     * DoDisconnect (pCB);
     * Exit;
     *}
    END;{* FremdPID behandlung *}
  StopTimer (pCB^.tTimeOut);

  IF pCB^.pPartnerCB <> NiL THEN
    BEGIN {* Neuer Befehl whrend LinkSetup, FIND, CQ oder so luft *}
    DoDisconnectImm (pCB^.pPartnerCB); {* der sendet auch die entsprechende Msg los *}
    pCB^.pPartnerCB := NiL;
    Exit; {Warten bis QSO(Connect-Versuch etc.) auch intern beendet ist}
    END;

  REPEAT {* Schleife wiederholen, solange komplette Zeile im Buffer UND nicht zuviel im Sendebuffer *}
    sZeile := FrameInfo2String_CR (pCB);   {* Get RXq-Zeile: *}
    IF sZeile <> '' THEN Infobox_Interpreter ( pCB, INFOBOX, sZeile );
  UNTIL (sZeile='') OR TxWindowUeberschritten(pCB);

  IF pCB^.pCv = NiL THEN
    BEGIN {* Im Conversmode gibtes keinen TimeOut, also wieder einschalten sonst *}
    {* Timer umprogrammieren - er knnte ja schon die gelbe Karte gekriegt haben *}
    pCB^.tTimeOut.TickInit := (facGelbeKarte-1) * LongInt(InfoBoxTimeOut) DIV facGelbeKarte;
    pCB^.pInfoBox^.TimeOutStufe := ibtNULL;
    StartTimer (pCB^.tTimeOut);
    END;
END;


PROCEDURE fnMsgInfoBox ( pCB : TP_AXCB; msg : T_Msg);
  {* Message-Handler fr QSOs mit der InfoBox *}
BEGIN
  CASE msg OF
    msgTx:	      {* In der TXQ ist wieder etwas Platz *}
       BEGIN
       {* Wieder unbusy werden, sobald was ausgesendet wurde *}
       IF pCB^.busy THEN
         IF pCB^.rxBufSize<pCB^.rxWind DIV 2 THEN Event_BecomeUnBusy(pCB);
       END;

    msgRx
     : {* Nur wenn noch Platz ist, sollen Daten erzeugt werden *}
       {* Wird aufgelst, wenn alle Pakete besttigt sind *}
       BEGIN
       {* Erst wieder Kommandos bearbeiten, wenn TX-Buffer frei *}
       IF TxWindowUeberschritten(pCB)
         THEN Event_BecomeBusy(pCB)
              {* der QSO-Partner soll nun stille schweigen, damit er nicht
               * durch einen weiteren Befehl die TXQ noch lnger macht *   }
         ELSE Rx_InfoBox (pCB);
       END;

    msgTimeOut
     : BEGIN
       DoInfoBoxTimeOut(pCB);
       END;

    msgRetryCountExceeded,
    msgRxDM,
    msgDiscReq,
    msgCBDel
     : CloseInfoBox(pCB);

    ELSE fnMsgDefault ( pCB, msg );
   END;
END;

{}


PROCEDURE CloseInfoBox (VAR pCB : TP_AXCB);
  {* Reihenfolge kritisch, da durch DoDisconnectImm div. Aktionen ausgelst *}
  {* werden knnen z.B. wenn noch ein Connectversuch anhngig ist           *}
BEGIN
  IF pCB = NiL THEN Exit;
  IF pCB^.pInfoBox = NiL THEN Exit;
  StopTimer (pCB^.tTimeOut);
  TraceInfo( '*Disc', pCB );
  IF pCB^.qsotype = qtCircuitMaster THEN DoDisconnectImm (pCB^.pPartnerCB);
  pCB^.fMsgHandler := fnMsgDefault;
  MemFree (Pointer (pCB^.pInfoBox), SizeOf (pCB^.pInfoBox^) );
END;



PROCEDURE OpenInfoBox (VAR pCB : TP_AXCB; mitCText : BOOLEAN;
  			   nCon : Word;   lnPakete : LongInt );
  VAR p : tp_ib;
      i : Byte;
      sZwisp : String;
      shc : T_shCall;
BEGIN
  TraceInfo( '*Connect', pCB );

  {$IFDEF UserWare}
    LogAddEntry ( pCB, leAutoComment , 'logged in' );
  {$ENDIF}

  pCB^.PID := PID_TEXT; {* Auf jeden Fall bei der Infobox..*}

{
AscCall2shift ( 'DG1KJD',shc);
    IF     CmpShCallSSID(@pCB^.fromCall,@shc)
       or CmpShCallSSID(@pCB^.  toCall,@shc) THEN
      BEGIN
      pCB^.PID := PID_IP;
      pCB^.fMsgHandler := fnMsgInfoBox;
      Exit;
      END;
}

  {* Spezial Botschaft fr den Connectenden - Hier damit auch "Dumm"user ne Chance hat *}
  IF pCB^.watchMode <> 0 THEN
    IF watch[pCB^.watchMode].pText <> NiL THEN
      TX_Info (pCB, SPAETER, EOL+BELL+String(watch[pCB^.watchMode].pText^)+EOL+EOL);


  IF upCallCheck THEN
    IF NOT ValidCall (f_sh2asc(pCB^.toCall)) THEN
      BEGIN
      TX_Info (pCB, SOFORT, EOL+BELL+
	  'Hello '+f_sh2asc(pCB^.toCall)+EOL+
	  'you can''t use '+axIFace[pCB^.iface].asMyCall+EOL);
      IF axiface[pCB^.iface].fLOOPBACK THEN {* Wenn wir per Loopback kommen isses egal *}
        BEGIN
        DoDisconnect (pCB);
        Exit;
        END;
      END;

  {* LinkTabelle berprfen *}
  IF useFlexNet THEN
    BEGIN
    i := CheckLinkPath (pCB); {* Testet, ob in pCB^ der Pfad eines Links eingetragen ist *}
    IF i > 0 THEN {* ja, ist ein Linkpartner aum richtigen weg *}
      IF link[i].lzMessen THEN
        BEGIN
	InitFlexRoutingQso ( pCB, FALSE {* WIR WURDEN connected *}, i );
        Exit; {* und nix wie weg hier! *}
        END;
    END;

{$IFDEF BroadCast}
  IF bcPort <> 0 THEN
    IF     CmpShCallSSID(@pCB^.fromCall,@BcShMyCall)
       AND CmpShCallSSID(@pCB^.  toCall,@BcShBoxCall) THEN
    BEGIN
    pCB^.qsoType := qtBC;
{   pCB^.who   := AUTO;   }
    pCB^.fMsgHandler  := fnBCHandler;
    QueueMsg( pCB, msgConnectSuccess ); {* Informieren,dass es losgeht *}
    Exit;
    END;
{$ENDIF}

  pCB^.qsotype := qtInfoBox;
  pCB^.fMsgHandler := fnMsgInfoBox;

  MemGet( Pointer(pCB^.pInfoBox), SizeOf(pCB^.pInfoBox^) );
  p := pCB^.pInfoBox;

  {* TTimeOut ist per Definition immer definiert s.CreateAx25 *}
  pCB^.tTimeOut.tickinit := (facGelbeKarte-1) * LongInt(InfoBoxTimeOut) DIV facGelbeKarte;
  p^.TimeOutStufe        := ibtNULL;
  StartTimer (pCB^.tTimeOut);

  p^.byLastCmd	  := 0;
  p^.privCount	  := 0;
  p^.InvalidCount := 0;
  p^.fIgnore      := FALSE;
  p^.fIntViaConnect := false;

{$IFDEF HostMode}
  IF HostModeDirektConnect(pCB,NOT cTESTEAUFFREIENKANAL) > 0 THEN
    BEGIN
    IF OpenHost(pCB,TRUE,false,NOT cSSIDEgal) THEN Exit;
    TX_EOLSysInfo(pCB, SPAETER, 'FALCon-InfoBox wird aktiviert'+EOL);
    END;
{$ENDIF}

  {* Ist es ein eingetragener Convers-Vernetzter ? *}
  IF Pos(f_sh2asc(pCB^.toCall)+' ',cvLINKCALL) > 0 THEN {* $OPT: *}
    BEGIN
    OpenConv( pCB, 32768 ); {* 2^15 = Zeichen, dass es ein ConversHost ist. *}
    mitCText := FALSE;
    END;

  i := GetLocalSubStationLinkNr( pCB, nil);  {* Schaue nach, ob das
  * "Dest"Call mit genau dieser SSID in der Linkliste steht. Wenn ja, dann
  * Index des Links zurckgeben, sonst 0 *}
  IF i > 0 THEN
    BEGIN {* Dann versuchen, es direkt durchzuschleifen *}
    p^.fIntViaConnect := true;
    IF DoAscConnect ( link[i].portNr, pCB,
                   f_sh2asc (pCB^.fromCall), WITHOUTVIA, FALSE ) THEN Exit;
    END;
  p^.fIntViaConnect := false; {19.6.97}

  {* strahle Connect Text aus *}
  IF mitCText THEN
    BEGIN
    TX_Info (pCB, SPAETER, hwName +'/'+ pgmVersion );
    CvMacro (pCB, sCText, sZwisp );
    TX_Info (pCB, SPAETER, sZwisp); {* Default *}

{$IFDEF Ctext3mal}
    IF nCon < 3 THEN
{$ENDIF}
      BEGIN
      IF ReadTxt( pCB, 'CTEXT',                   rtNODEFAULT) THEN;
      IF ReadTxt( pCB, 'CTEXT'+FStr(pCB^.iface), rtNODEFAULT) THEN;

      {* Anzeigen, dass Texte vorhanden sind *}
      FOR i := 1 TO MAXTXT DO IF apText[i] <> NiL THEN WITH apText[i]^ DO
	IF cdir THEN TX_Info( pCB, SPAETER, EOL +
			   + f_SetStrLength(' '+sTitel,MAXTXTTITELLEN+5)
			   + f_Using(size,6) + ' Zeichen, vom '
			   + DatumTTMM ( writeTime.day, writeTime.month )
			   );
      END;

{$IFDEF UserWare}
     FOR i := 1 TO MAXTXT DO
       IF apText[i] <> NiL THEN WITH apText[i]^ DO
         IF (NOT fHidden) THEN
  	   BEGIN
           IF Pos(f_sh2asc(pCB^.toCall), f_Upper(name+' '+sTitel))>0 THEN
             BEGIN
             TX_Info (pCB, SPAETER, EOL+BELL+'Message for you: '+sTitel
                                   +EOL+'Read with: READ '+name+EOL);
             END;
           END;
{$ENDIF}

    {* In lnPakete stehen die Anzahl InfoPakete/Minute mal 128, die die *}
    {* Station pCB, ueber alle Verbindungen gemittelt TRX hat/wurde *}
    IF (lnPakete > 128*nWarnMaxPakete) OR (nCon > nWarnMaxLogin) THEN
      BEGIN
      TX_EOLSysInfo(pCB, SPAETER,
			  'Dies ist Ihr '+FStr(nCon)
			  +'.Login gleichzeitig mit insges. ca.'
			  +fStr(lnPakete DIV 2)+' Paketen pro Stunde'+EOL+
			  '*** Bischen viel, nich''?'+BELL+EOL);
      {* Hier ist Platz fr gemeinheiten: Paclen 10,maxframe 1... *}
      END;

    IF sLoginAutoCMD <> ''
      THEN BEGIN
           sZwisp := sLoginAutoCMD;
           Infobox_Interpreter ( pCB, INFOBOX, sZwisp )
           END
      ELSE DoPrompt (pCB);
    END;{ mit CText }
END;


{}

END.
