UNIT FD_HOST; {* DigiWare/Termware HostMode Interface              *}
              {*    von DG9EP, erweitert von DL7GAI *}
              {*    Merge 25.12.96 dg9ep/dl7gai  *}
{$I FD_INCL.PAS}


INTERFACE
{$IFDef Hostmode}


USES FD_Def;

 FUNCTION EqualHostCalls(pm:tp_mbuf) : BOOLEAN;
PROCEDURE HostMonitor( pm:tp_mbuf; fDefekt : BOOLEAN);

    CONST cTESTEAUFFREIENKANAL=TRUE;
 FUNCTION HostModeDirektConnect(pCB:tp_axcb;fTestAufFreeChannel:BOOLEAN) : BYTE;

    CONST cKommtVonDigiWare = TRUE;
          cPrintConnectedToHost = TRUE;
          cSSIDEgal = TRUE;
 FUNCTION OpenHost (pCB : TP_AXCB; fKommtVonDigiWare,
                   fPrintConnectedToHost,fSSIDEgal : BOOLEAN ) : BOOLEAN;
PROCEDURE HostEverySecond;
{PROCEDURE HostUserList(pCB:TP_AXCB);}
 FUNCTION PCB2HostChannelStr( pCB:TP_AXCB ) : STRING;


TYPE T_HCB = RECORD  {* Daten fuer ein HostMode"Interface"  *}
               KanalNr : BYTE;  {* Kanalnr des letzten TerminalReq *}
               isInfo  : BOOLEAN;
               dataLen : WORD;
               data    : ARRAY [1..256] OF Byte;
               iData   : WORD;
               zustand : (cWaitChNr,ComOrData,waitLength,getData);
               fTermCommand : BOOLEAN; {* Zustand im Terminalmodus *}
              END;

TYPE T_RPS=RECORD {* Rounds per Second - Geschwindigkeitsmessung *}
           act, min, max : word;
           del : boolean; {* Loeschen, nur wenn true und neue sec *}
         end;

TYPE T_HstStatus = (
          hstCONNECTED,    {* CONNECTED to call via digipeaters *}
          hstDISCONNECTED, {* DISCONNECTED fm call via digipeaters *}
          hstLINKFAILURE,  {* LINK FAILURE with call via digipeaters *}
          hstBUSY,         {* BUSY fm call via digipeaters                  *}
	  hstLINKRESETfrom,{* LINK RESET fm call via digipeaters            *}
          hstLINKRESETto,  {* LINK RESET to call via digipeaters            *}
	  hstCONREQ    ,   {* CONNECT REQUEST fm call via digipeaters       *}
	  hstFRMRfrom  ,   {* FRAME REJECT fm call via digipeaters (x y z)  *}
	  hstFRMRto,       {* FRAME REJECT to call via digipeaters (x y z)  *}
          hstM4,           {* Kennzeichnung : Moni-Header ohne INFO TEIL *}
          hstM5,           {*      "        : Moni-Header mit  INFO TEIL *}
          hstM6            {*      "        : INFO-TEIL eines Moniframes *}
        );
     TP_HstStatusQueue = ^t_HstStatusQueue;
     T_HstStatusQueue = RECORD
                          next      : tp_HstStatusQueue;
                          hstStatus : t_HstStatus;
                          pMoniDaten : Pointer; {* Pointer auf daten fuer Monitor-ausgabe *}
                          laenge    : Word;      {* Laenge davon *}
                        END;

TYPE T_HostKanal = RECORD
         status : (free,      {* Kann belegt werden *}
                   used,      {* QSO luft normal *}
                   connecting,{* QSO im Aufbau *}
                   discing);  {* QSO im Abbau *}
         pSelfCB : TP_AXCB;   {* Verweis auf zugeh. pCB. ACHTUNG: Nicht notwendig, ob Verbindung besteht *}
         portNr  : byte; {* Fr fDRSI; muss wg DISCONNECTED FROM 3:DB0ME extra stehen *}
         sMyCall : STRING[15];
         shMyCall : T_ShCall;  {* MyCall in Shiftdarstellung, wg. Performance in EqualHostcalls *}
         sCallAndPath : STRING[85]; {* Pfad des lfd. QSOs *}
    	 QSORxBuf     : TP_Mbuf;  {* Der neueste steht vorne *}
         nHstMsgQueue,  {* Number of link status messages not yet displayed/requestet *}
         nHstDataFrame: WORD;  {* Number of receive frames not yet displayed *}
         pHstMsgRoot,
         pHstMsgTail : tp_HstStatusQueue;
       END;

      T_UI = record
        Target:string[9];
        via   :string[63];
        fPoll : BOOLEAN;
      end;


CONST MAXHOSTKANAL = 17;
      yCmdMAXHOSTKANAL : byte = MAXHOSTKANAL;
      {* Fr Parameter Y. Dies ist die Anzahl der maximal erlaubten
       * passiven Connects (z.B. um bei BBS Kanle fr SF freizuhalten) *}
      csNOCALL = 'NOCALL';
      fDRSI      : boolean=True; {* Variable fr @ESTAT bzw c 1:DG9EP auf port 1 *}
{*}   fVCallCheck: boolean=true; {* Callcheck Schalter*}

CONST
{*}   cChan : byte=1; {* current Channel (AX-<nr>; da wird auf Hostch 0 gesendet;
                       * bei FALC-TF auf alle HostCH's anwendbar;
                       * bei TW nur fuer Moni-CH!
                       *}
VAR
{*}  uiPara:array[1..MAX_AXIFACE] of T_UI; {* Index ist immer cChan, und damit ein AX-Interface... *}


TYPE  T_afPort = ARRAY [1..7] OF BOOLEAN;
      T_mmIUSC = RECORD n,  {* Keinerlei Monitor *}
                        i,  {* InfoFrames        *}
                        u,  {* UI-Frames         *}
                        s,  {* Supervisory Frames (RR,RNR,REJ)    *}
                        c,  {* Auch Monitoren wenn connected (ohne Funktion) *}
                        t,  {* Kein Text der UI/I-Frames ausgeben *}
                        p,  {* Protokolle dekodiert ausgeben      *}
                        d,  {* Info-Inhalt als Hexdump ausgeben   *}
                        z,  {* Zeit przise (10ms Schritte) ausgeben *}
                        g   {* Gammelmodos ala TAPR (nur logische Fehler) *}
                          : BOOLEAN; END;
      T_mmCall = RECORD pl,mi : boolean;
                        nCall : Byte;
                        call : array[1..8] of string[9];
                       END;
      T_moniMode = RECORD
                    iusc : T_mmIUSC;
                    afPort : T_afPort;
                    call : T_mmCall;
                   END;
      T_StampType= (ceNONE,ceSTAT,ceSTATMONI);

CONST eTimeStampMode:T_StampType=ceNONE;
      UText  : STRING  = '';
      fUMode : BOOLEAN = FALSE;
      nBufferLimitBusy = 200;

TYPE T_HOST= RECORD
      fValid : BOOLEAN;
      hostbindnr  : WORD; {* Index von self in bind[] *}
      HostSSIDMin : WORD;
      HostSSIDMax : WORD;
      moniMode    : T_moniMode;
      nHostPolls,
      nXHostPolls, nTurboEvents,
      timeLastRxHostModePoll : Longint;
      fTerminalAktiv : BoolEAN;  {* Bootzustand: Terminal *}
      fTurbo         : Boolean;  {* Turbohostmode JHOST2 nach DL1GJI (oder so) *}
      fTurboEventAllowed : Boolean;  {* Darf ein Event (PseudoINT) an das TermPGM gesendet werden?
                                  * Nur relevant wenn fTurbo=True*}
      fHayesAktiv    : BoolEAN;  {* Bootzustand: Terminal *}
      fHostModeAktiv : BOOLEAN;  {* Hostmode ist initialisiert *}
      fHostInAktivTextTxed : BOOLEAN;

      ProcRx1Char : TFN_RX1CHAR;
      ProcTx1Char : TFN_TX1CHAR;
      ProcNRxCHAR : TFN_NRXCHAR;
      ProcNTXChar : TFN_NTXChar;
      ProcLED     : TFN_LED;
      END;

CONST MAXHOST = 1; {* Anzahl Hostclients *}
  VAR host : ARRAY [1..MAXHOST] OF T_HOST;
      hostChannel : ARRAY [0..MAXHOSTKANAL] OF T_HostKanal;


{$ENDIF}
{}
IMPLEMENTATION{$IFDef Hostmode}

USES
     FD_Circ,   {* wg. Reconnected *}
     FD_Main,   {* fnMsgDefault *}
     FD_State,  {* wg. Try2Connect *}
     FD_Info,   {* wg. OpenInfoBox (ESC &p scc 1....) *}
     {$IFDEF scc}   FD_TNC,
     {$ELSE}        FD_CRT,DOS,
     {$ENDIF}
     FD_Log,
     FD_Sysop,
     FD_Moni,
     FD_AT,
     FD_Task,
     FD_Div,
     FD_AxCB,
     FD_AR,
     FD_Subr,
     FD_mBuf,
     FD_Mem,
     FD_TX
	;

CONST csMyName = 'HOST';

 VAR hostrps     : T_RPS;   {* Array fuer rps,min und max*}
     hostactrps  : word; {* counter rps *}



PROCEDURE CloseHost (pCB : TP_AXCB; grund : T_HstStatus ); forward;
PROCEDURE DelHost(kanalNr : BYTE);                         forward;

CONST
    csCHANNELNOTCONNECTED = 'CHANNEL NOT CONNECTED'; {0}
    csINVALIDCALLSIGN     = 'INVALID CALLSIGN';      {1}
    csMESSAGETOOLONG      = 'MESSAGE TOO LONG';
    csINVALIDPARAMETER    = 'INVALID PARAMETER';
    csINVALIDBAUDRATE     = 'INVALID BAUD RATE';     {4}
    csNOSOURCECALLSIGN    = 'NO SOURCE CALLSIGN';
    csINVALIDCOMMAND      = 'INVALID COMMAND: ';
    csNOTWHILECONNECTED   = 'NOT WHILE CONNECTED';   {7}
    csINVALIDVALUE        = 'INVALID VALUE: ';
    csNOMESSAGEAVAILABLE  = 'NO MESSAGE AVAILABLE';   {9}
    csINVALIDCHANNELNUMBER= 'INVALID CHANNEL NUMBER'; {10}
    csTNCBUSYLINEIGNORED  = 'TNC BUSY - LINE IGNORED';
    csCHANNELALREADYCONNECTED='CHANNEL ALREADY CONNECTED';
    csSTATIONALREADYCONNECTED='STATION ALREADY CONNECTED';
    csINVALIDEXTENDEDCOMMAND='INVALID EXTENDED COMMAND: '; {14}

    CONST fDAMALEDinUse : BOOLEAN = TRUE;

{}

Function EqualHostCalls(pm:tp_mbuf):boolean;
  VAR i : WORD;
      {* s : T_shCall; *}
BEGIN
  EqualHostCalls := false;
  IF pm^.ofsctl=cOFFVIRT THEN Exit; {* Virt. Addressierung untersttzen wir noch nit *}
  FOR i := 1 TO yCmdMAXHOSTKANAL DO
    BEGIN
    {* AscCall2shift ( hostchannel[i].sMyCall, s); *}
    IF EqualShCall ( pm, hostchannel[i].shMyCall) THEN
      BEGIN
      EqualHostcalls := true;
      Exit;
      END;
    END;
END;

PROCEDURE SetMyCall( kanalnr : BYTE; sCall : STRING);
  VAR sh: T_shCall;
BEGIN
  Trim(sCall);
  Upper(sCall);
  hostChannel[kanalnr].sMyCall:=sCall;
  AscCall2shift( sCall, sh );
  hostChannel[kanalnr].shMyCall:=sh;
END;

{}


PROCEDURE SendChar(ch:Char);
BEGIN
  WHILE host[1].ProcNTXCHAR = 0 DO
    BEGIN {* Warteschleife *}
    Inc(Count[cntV24OR]);
    TaskSwitch;
    END;
  host[1].ProcTx1Char(ch);
END;


PROCEDURE SendStr ( {$IFDEF VER70} CONST {$ENDIF} s : STRING );
  VAR i : BYTE;
BEGIN
  FOR i := 1 TO length(s) DO SendChar(s[i]);
END;


PROCEDURE SendPStr ( pS : Pointer; lenS : INTEGER; fAsciiZ : Boolean);
BEGIN
  IF NOT fAsciiZ THEN SendChar(char(lenS-1));
  Watchdog;
  WHILE lenS>0 DO
    BEGIN
    SendChar(char(ps^));
    Dec(lenS);
    Inc(Word(ps));
    END;
  IF fAsciiZ THEN SendChar(#0);
END;


PROCEDURE SendMsg (chnr, code : BYTE; msg : string );
BEGIN
  SendChar(char(chnr));
  SendChar(char(Code));
  CASE code OF
    0    : ; {* Nix *}
    1..5 : SendPStr( @msg[1] ,length(msg), true );  {* Null Terminiert *}
    6..7 : IF msg <> '' THEN
             BEGIN
             SendPStr( @msg[0],length(msg)+1, false); {* Len Format *}
             END;
    8    : ; {* Nix, ist RX-Event *}
   END;
END;


PROCEDURE SendPMsg (chnr,Code : BYTE; ps : Pointer; lenS : INTEGER);
BEGIN
  SendChar(char(chnr));
  SendChar(char(Code));
  CASE code OF
    0    : ; {* Nix *}
    1..5 : SendPStr( ps,lenS, true);  {* Null Terminiert *}
    6..7 : SendPStr( ps,lenS, false ); {* Len Format *}
   END;
END;


PROCEDURE SendPMMsg (chnr, code : BYTE; pm : tp_mbuf);
BEGIN
  SendPMsg( chNr, code, pm^.pData, pm^.inuse);
END;


{}


PROCEDURE SwitchHostLED;
{- Wird bei nderungen und jede Sekunde aufgerufen
 - Neue Bedeutungen:
 -  (*) = aktiviert
 -   * LED 1 ist an, wenn irgendeine Verbindung nach draussen besteht
 -   *     1 blinkt, wenn noch was Hostmode mssig nicht abgeholtes drin ist
 -   * LED 2 ist an, wenn wer (fremdes) in der Infobox drin ist.
 -   *       blinkt wenn in der IBox innerhalb der letzen 60 sek. etwas
 -           tracewrdiges ablief.
 -     LED 2 wird umgeschaltet wenn ein XHostmode Poll kam
 -     LED 3 ist an, wenn wer (fremdes) im Convers drin ist.
 -           blinkt bei nderung.
 -   * LED 3 ist an, wenn mind. 1 Port DAMA m8, und ein QSO luft
 -   * LED 3 blinkt, wenn ein Hostmode Poll kam, und kein QSO luft
 -   * LED 4 ist an, wenn in irgendeinem QSO unbest. Frames drin sind.
 -}
  VAR n,i,nQSO : WORD;
      nC,nI : WORD;

      ledtodo_QSO,
      ledtodo_IBox,
      ledtodo_DAMA,
      ledtodo_UnAck
                    : t_doLED;
BEGIN
  LEDtoDo_QSO := cAusschalten;
  LEDToDo_unAck := cAusSchalten;
  LEDToDo_DAMA := cAusSchalten;
  LEDToDo_Ibox := cAusSchalten;

  {* erstmal ein bischen zhlen *}
  nC := 0; nI := 0;  nQso := 0;
  FOR i := 1 TO maxAXCB DO
    IF cb[i]<>Nil THEN WITH cb[i]^ DO
      IF {cb[i]^.}iface<>ifLoopback THEN
        BEGIN
        IF      ({cb[i]^.}qsoType = qtInfoBox) THEN Inc(nI)
        {ELSE IF (qsoType = qtConvers) THEN Inc(nC)};
        IF ({cb[i]^.}nUnbest>0) OR ({cb[i]^.}txbufsize>0) THEN ledtodo_unAck := cANSCHALTEN;
        Inc(nQSO);
        END;

  {* DAMA-LED *}
  IF nQSO > 0 THEN
    BEGIN
    LEDtoDo_QSO := cANSCHALTEN;
    FOR i := 1 TO MAX_axiface DO
      IF axiface[i].dama.fSlave THEN LEDToDo_DAMA := cAnSchalten;
    END;
  {* QSO-LED *}
  fDAMALEDinUse := LEDToDo_DAMA = cAnSchalten;
  {* DAMA LED macht nur Sinn, wenn ein QSO luft *}


  FOR i := 1 TO {yCmd}MAXHOSTKANAL DO
    IF (hostChannel[i].nHstMsgQueue <> 0) OR (hostChannel[i].nHstDataFrame <> 0)
      THEN ledtodo_QSO := cUMSCHALTEN;

  {* IBox-LED *}
  IF nI > 0 THEN
    IF (fasttick-timLastTraceInfo) > 60*_Sekunden
      THEN LEDToDo_IBox := cAnschalten
      ELSE LEDToDo_IBox := cUmschalten {* Innerhalb der letzten 60 sekunden was eingegeben *};

  host[1].ProcLED( 1, LEDtoDo_QSO );
  host[1].ProcLED( 2, LEDToDo_IBox );
  host[1].ProcLED( 3, LEDtoDo_DAMA );
  {* Zustzlich wird weiter unten die 3er LED evtl.angestossen
   * (HostPoller). Suche nach ProcLED
   *}
  host[1].ProcLED( 4, LEDToDo_UnAck );
END;


{}


{$F+}
PROCEDURE msgHayes ( pCB : tp_axcb;  msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
  VAR info, s : STRING;
BEGIN
CASE msg OF
  msgConnectSuccess
    : BEGIN
      SendStr(CR+'Connected'+CR);
      host[1].fHayesAktiv := true;
      END;

  msgRX
    : BEGIN
      IF Not TxWindowUeberschritten(pCB) THEN
        BEGIN
        SendStr( FrameInfo2str( pCB ) );
        END;
      END;

  msgDiscReq, {* ein DisconectRequest traf ein *}
  msgRetryCountExceeded,
  msgRxDM,
  msgCBDel
        : BEGIN
          SendStr(CR+'NO CARRIER'+CR);
          host[1].fHayesAktiv := false;
          END;
  ELSE fnMsgDefault ( pCB, msg );
 END;
END;


{}

{$S-,R-,V-}

FUNCTION RPSAsString : STRING;
BEGIN
  RPSAsString := 'RpS:'+ fStr(hostrps.act) + ', '
                       + fStr(hostrps.min) + '-' + fStr(hostrps.max);
END;


PROCEDURE DelHostRPS;
BEGIN
  hostactrps:=0;
  WITH hostrps DO BEGIN
                  act:=0;
                  min:=65535;
                  max:=0;
                  END;
  hostrps.del:=false;
END;

PROCEDURE HostEverySecond;
BEGIN
  IF NOT host[1].fValid THEN Exit;
  WITH hostrps DO BEGIN
                  act:=hostactrps;
                  IF (hostactrps < min) THEN min:=act;
                  IF (hostactrps > max) THEN max:=act;
                  hostactrps:=0;
                  IF hostrps.del THEN DelHostRPS;
                  END;
  SwitchHostLED;
END;


{FUNCTION HostStampMode : Byte;
BEGIN
  CASE eTimeStampMode OF
   ceNONE    :  hoststampmode:=0;
   ceSTAT   :  hoststampmode:=1;
   ceSTATMONI:  hoststampmode:=2;
  END;
END;}


FUNCTION FrameTimeStamp : String;
BEGIN
  WITH systime DO
    BEGIN
    FrameTimeStamp := DatumTMJ(day,month,year) + ' '
                    + UhrzeitHMS(hour,min,sec);
    END;
END;


{}


FUNCTION GetFreeHstChannel : BYTE;
  VAR i : BYTE;
BEGIN
  GetFreeHSTCHannel:=0;
  IF yCmdMAXHOSTKANAL=0 THEN Exit; {* Heute hamma keine Sprechstunde !! *}
  i := 1;
  WHILE ( (i<yCmdMAXHOSTKANAL) AND ( hostChannel[i].status<>free ) ) DO Inc(i);
  IF hostChannel[i].status=free THEN GetFreeHstChannel:=i;
END;


PROCEDURE DelHstQ ( kanalnr : BYTE );
  VAR pHst : tp_HstStatusQueue;
BEGIN
  WITH hostChannel[KanalNr] DO
    BEGIN
    IF pHstMsgRoot = Nil THEN Exit;
    REPEAT
      pHst := pHstMsgRoot^.Next;
      MemFree ( Pointer(pHstMsgRoot), SizeOf(pHstMsgRoot^) );
      Dec(nHstMsgQueue);
      {*SwitchHostLED*};
      pHstMsgRoot := pHst;
    UNTIL pHstMsgRoot = NiL;
    END;
END;



PROCEDURE TurboEventWennNoetig(kanalnr:Byte);
BEGIN
  IF host[1].fTurbo AND host[1].fTurboEventAllowed THEN
    BEGIN {* RX-Event senden *}
    SendMsg (kanalnr, 8 , '' );
    host[1].fTurboEventAllowed := false;
    Inc(host[1].nTurboEvents);
    END;
END;


PROCEDURE AddHstQ ( kanalnr : BYTE; status : t_HstStatus );
  VAR pHst : tp_HstStatusQueue;
BEGIN
  MemGet ( Pointer(pHst), SizeOf(pHst^) );
  pHst^.next := NiL;
  pHst^.hstStatus := status;
  pHst^.pMoniDaten:=nil;
  phst^.laenge:=0;
  WITH hostChannel[KanalNr] DO
    BEGIN
    IF pHstMsgRoot = Nil THEN pHstMsgRoot := pHst
                         ELSE pHstMsgTail^.next := pHst;
    pHstMsgTail := pHst;
    Inc(nHstMsgQueue);
    {*SwitchHostLED*};
    END;
  TurboEventWennNoetig(kanalNr);
END;

{*$TODO: h, was denn? z.B. STATUS:BYTE --> t_HstStatzs *}
PROCEDURE AddMonitorToHstQ ( status : byte;  pMData : Pointer; lenArg:word );
  VAR pHst : tp_HstStatusQueue;
BEGIN
  MemGet ( Pointer(pHst), SizeOf(pHst^) );
  pHst^.next := NiL;
  CASE status OF
   4: pHst^.hstStatus := hstM4; {Monitor Header (null terminated) (no info follows)}
   5: pHst^.hstStatus := hstM5; {Monitor Header (null terminated)  (info follows)}
   6: pHst^.hstStatus := hstM6; {Monitor Information (preceeded by length-1)}
  END;
  MemGet(pHst^.pMoniDaten, lenArg);
  Move( pMData^, pHst^.pMoniDaten^, lenArg );
  pHst^.laenge:=lenArg;
  WITH hostChannel[0] DO { 0 = MoniDaten }
    BEGIN
   { pselfcb:=nil; }
    IF pHstMsgRoot = Nil THEN pHstMsgRoot := pHst
                         ELSE pHstMsgTail^.next := pHst;
    pHstMsgTail := pHst;
    Inc(nHstDataFrame);
    END;
  TurboEventWennNoetig(0);
END;


{}


PROCEDURE HstTxStatus (chNr : BYTE);
{* Sende naechste Meldung im Kanal CHNR an den Host *}
  VAR s : STRING;
      pHst : tp_HstStatusQueue;
      ph : Pointer; { Hilfsvariablen zum loeschen }
      l : Longint;
BEGIN
  WITH hostChannel[chNr] DO
    BEGIN
    IF pHstMsgRoot = Nil THEN Exit; {* gar keine da! Eigentlich Fatal *}
    pHst := pHstMsgRoot;
    {* Aushngen *}
    IF pHstMsgRoot = pHstMsgTail THEN pHstMsgTail := pHstMsgTail^.next;
    pHstMsgRoot := pHstMsgRoot^.next;
    Dec(nHstMsgQueue);

    {* Sende pHstMsgRoot an Host *}
    IF pHst^.pMoniDaten=nil
      THEN BEGIN {* Es ist 'ne Statusmeldung *}
           s := '';
           CASE pHst^.hstStatus OF
             hstCONNECTED    : s := 'CONNECTED to ';
             hstDISCONNECTED : s := 'DISCONNECTED fm ';
             hstLINKFAILURE  : s := 'LINK FAILURE with ';
             hstBUSY         : s := 'BUSY fm ';
             hstLINKRESETfrom: s := 'LINK RESET fm ';
             hstLINKRESETto  : s := 'LINK RESET to ';
             hstFRMRfrom     : s := 'FRAME REJECT fm ';
             hstFRMRto       : s := 'FRAME REJECT to ';
             hstCONREQ       : s := 'CONNECT REQUEST fm ';
           END;
           IF fDRSI THEN AddString(s,fstr(portnr)+':');
           AddString(s,sCallAndPath);

           IF eTimeStampMode <> ceNONE THEN AddString(s,' - '+FrameTimeStamp);

           IF pHst^.hstStatus = hstCONREQ  {* ConReq hat keine Kanalnr *}
             THEN SendMsg(chNr, 3, s )
             ELSE SendMsg(chNr, 3, '('+fStr(chnr)+') '+s ); {* Linkstatus senden *}
           END
      ELSE BEGIN {* Es sind Daten fuer CHNr. 0 : Monitor *}
           l  := pHst^.laenge;
           pH := pHst^.pMoniDaten;
           CASE pHst^.hststatus OF
             hstM4: SendPMsg(chnr, 4, pH, l);
             hstM5: SendPMsg(chnr, 5, pH, l);
             hstM6: SendPMsg(chnr, 6, pH, l);
           END;
           MemFree(ph,l); {* Moni-Daten sind gehostet-> ab ins (Abfall-)Koerbchen *}
           Inc(nHstMsgQueue);
           Dec(nHstDataFrame);
           END;
    {* Lsche grad' gesendetes ausm Speicher *}
    MemFree( Pointer(pHst), SizeOf(pHst^) );
    IF (chnr>0) AND (nHstMsgQueue = 0) AND (status = DiscIng) THEN DelHost(ChNr);
    END;
END;


PROCEDURE HstTxData (ChNr : BYTE);
{* Sende naechstes nichtleeres Paket in der RxQ an Host *}
  VAR pCB : TP_AXCB;
      pM : tp_mBuf;
      code:byte;
BEGIN
  pCB := hostChannel[chnr].pSelfCB;
  IF pCB = NiL THEN Exit;
  IF hostChannel[chnr].QSORxBuf = Nil THEN Exit;
  pm := GetMBufFromQueue (hostChannel[chnr].QSORxBuf);
  IF pm = NiL THEN Exit;
  IF hostChannel[chnr].nHstDataFrame > 0 THEN Dec(hostChannel[chnr].nHstDataFrame);
  Watchdog;
  SendPMMsg(chnr,7, pm ); {* Infos senden *}
  Del_mBuf(pm);
END;


{$F+}
PROCEDURE fnMsgHOSTConTry ( pCB : tp_axcb; msg : T_Msg);
  VAR kanalNr : BYTE;
BEGIN
  kanalNr := pCB^.divers.bHostKanal;
  IF hostChannel[KanalNr].pSelfCB = NiL THEN Exit; {* is wohl nix *}

  CASE msg OF
   msgConnectSuccess    {* Connect Versuch erfolgreich / ReConnected ! *}
     :  IF OpenHost (pCB, FALSE,false,NOT cSSIDEgal) THEN;

   msgDiscReq,	{* ein DisconectRequest traf ein *}
   msgCBDel,
   msgRetryCountExceeded,
   msgRxDM {* DM traf ein *}
     : BEGIN
       IF msg=msgRxDM THEN AddHstQ ({pCB^.divers.bHostKanal}kanalNr, hstBUSY)
                      ELSE AddHstQ ({pCB^.divers.bHostKanal}kanalNr, hstLINKFAILURE);
       pCB^.fMsgHandler := fnMsgDefault;
       hostChannel[kanalnr].status := DISCing;
       END;

    ELSE fnMsgDefault( pCB, msg );
  END {* case *};
END; {$IFNDEF AllFar} {$F-} {$ENDIF}


FUNCTION GetHstChannelUsed : BYTE;
{* Gibt die Anzahl der Verwendeten Kanle zurck (fr Y-Befehl *}
  VAR i,j : BYTE;
BEGIN
  i:=1;  j:=0;
  while i<={yCmd}MAXHOSTKANAL do
    BEGIN
    IF hostChannel[i].status<>free THEN Inc(j);
    Inc(i);
    END;
  GetHstChannelUsed := j;
END;


FUNCTION ConvertState(pCB:tp_axcb) : byte;
{- Krcke fr L-Kommando -}
  CONST caStat : ARRAY [T_State] OF Byte =
        ( {DISCONNECTED}   0,      	  {SETUP}          1,
	  {DISCPENDING}    3,      	  {CONNECTED}      4,
	  {FRAMEREJECT}    2,      	  {IGNORE}         0,
	  {INVALID}        0        );
  VAR res,nBusy : BYTE;
BEGIN
  res := caStat[pCB^.state];
  if (res=4) THEN
    BEGIN
    nBusy := 0;
    if pCB^.busy       THEN Inc(nBusy,1);
    if pCB^.remotebusy THEN Inc(nBusy,2);
    IF (nBusy>0) THEN res := 6+nBusy;
    END;
  ConvertState := res;
END;

{-------------------------------------------------------------------}

FUNCTION CmpMoniCall({$IFDEF VER70} CONST {$ENDIF} s:STRING) : BOOLEAN;
{* Gibt TRUE zurck, wenn Frame +/- gemonitort werden darf/soll *}
  VAR i : BYTE;
BEGIN
  CmpMoniCall := true;
  IF (host[1].moniMode.call.nCall=0) THEN Exit;
  IF NOT host[1].moniMode.call.pl AND NOT host[1].moniMode.call.mi THEN Exit;

  CmpMoniCall := host[1].moniMode.call.mi;
  FOR i := 1 TO host[1].moniMode.call.nCall DO
    IF Pos(host[1].moniMode.call.call[i], s)>0 THEN
      BEGIN
      CmpMoniCall := host[1].moniMode.call.pl;
      Exit;
      END;
END;


PROCEDURE HostMonitor(pm:tp_mbuf; fDefekt : BOOLEAN);
{* Man bergebe dieser Routine einen im Hostmode-Monitor auszugebenden String *}
  VAR s,sHeader : STRING;
      typ : T_FrameTyp;
      l   : LongInt;
      p   : Pointer;
BEGIN
  IF host[1].moniMode.iusc.n THEN Exit;
  IF (sysMemAvail DIV 256) < nBufferLimitBusy THEN Exit;

  typ := GetFrameTyp ( pm );
  IF host[1].moniMode.afPort[ pm^.ifnr ] THEN
    IF (host[1].moniMode.iusc.i AND (typ=INFO)) OR
       (host[1].moniMode.iusc.u AND (typ=UI)  ) OR
       (host[1].moniMode.iusc.s AND (typ in [SABM,UA,FRMR,DISC,DM,RR,RNR,REJ] )) OR
       (host[1].moniMode.iusc.g AND fDefekt)
       THEN
    BEGIN {* Ok, umwandeln *}
    sHeader := Pm2AxHeaderStr(pm, host[1].moniMode.iusc.z );
    IF NOT CmpMoniCall(sHeader) THEN Exit;

    IF fDRSI THEN sHeader := FStr(pm^.ifnr) + ':' + sHeader;
    IF eTimeStampMode=ceSTATMONI THEN AddString(sheader,' - '+FrameTimeStamp);

    l := 0; s := '';
    IF NOT host[1].moniMode.iusc.t THEN
      BEGIN {- Textkrper -}
      IF host[1].moniMode.iusc.p
        THEN BEGIN {* Protokolle dekodieren *}
             s := Pm2BodyStr ( pm );
             l := length(s);
             p := @s[1];
             END
        ELSE IF host[1].moniMode.iusc.d
        THEN BEGIN {* HexDump *}
             s := AsHexString ( pm^.pdata, pm^.inUse,true{ascii},false{beauty});
             l := length(s);
             p := @s[1];
             END
        ELSE BEGIN
             IF IsIUIFrameTyp(pm)
               THEN BEGIN {- U/I-Frame -}
                    p := pm^.pData;
                    Inc( word(p), pm^.ofsCtl + 1);
                    l := pm^.inUse - pm^.ofsCtl - 1;
                    END;
             END;
      END;
    IF l<=0 THEN AddMonitorToHstQ (4, @sHeader[1], length(sHeader) )
            ELSE BEGIN
                 AddMonitorToHstQ (5, @sHeader[1], length(sHeader) );
                 AddMonitorToHstQ (6, p,l )
                 END;
    END;
END;


FUNCTION MonitorModeString:STRING;
  VAR s : String;
      i : Byte;
BEGIN
WITH host[1].moniMode DO
  BEGIN
  s:='';
  IF iusc.n THEN AddChar(s,'N')
  ELSE BEGIN
       IF iusc.i THEN AddChar(s,'I');
       IF iusc.u THEN AddChar(s,'U');
       IF iusc.s THEN AddChar(s,'S');
       IF iusc.c THEN AddChar(s,'C');
       IF iusc.t THEN AddChar(s,'T');
       IF iusc.P THEN AddChar(s,'P');
       IF iusc.d THEN AddChar(s,'D');
       IF iusc.Z THEN AddChar(s,'Z');
       IF iusc.G THEN AddChar(s,'G');
       AddChar(s,' ');
       FOR i := 1 TO 7 DO
         IF afPort[i] THEN AddChar(s, Char(48+i));
       END;
  IF call.nCall > 0 THEN
    BEGIN
    IF call.pl THEN AddString(s,' +');
    IF call.mi THEN AddString(s,' -');
    FOR i := 1 TO call.nCall DO
      AddString(s,' '+call.call[i]);
    END;
  MonitorModeString:=s;
  END;
END;



PROCEDURE LeseMoniCall ( VAR moniMode : T_MoniMode;  sZeile : STRING);
 {* Extrahiert aus sZeile die zu berwachenden Calls *}
  VAR sErg : STRING;
         i : BYTE;
BEGIN
  moniMode.call.nCall := 0;
  FOR i := 1 TO 8 DO
    BEGIN {* Lscht auch gleichzeitig *}
    ScanForText (sZeile,sErg);
    moniMode.call.call[i] := f_Upper(sErg);
    IF sErg <> '' THEN moniMode.call.nCall := i;
    END;
END;

FUNCTION Connect( sTo: String; nr : word) : tp_axcb;
  VAR shPath : T_shPath;
      pCB,pNewCB : TP_AXCB;
      t,v : String;
      sInfo : STRING;
BEGIN
  Connect := nil;
  sTo := f_Upper(sTo);
  String2ShPath (sTo, shPath);
  pCB := CreateAXCB(1);
  String2tv (sTo, t,v);
  {* Asc2AXCB (t, hostchannel[nr].sMyCall, v, pCB ); *}
  Asc2AXCB (hostchannel[nr].sMyCall, hostchannel[nr].sMyCall, '', pCB );
  IF SearchForPath (shPath, pCB, cCONNECT, sInfo, pNewCB) {* Connected auch *}
    THEN BEGIN
         Connect := pNewcb;
	 END;
END;


FUNCTION MyHostCallValid ( hostchannel : T_HostKanal) : BOOLEAN;
BEGIN
  MyHostCallValid :=
    (hostChannel.sMycall<>'') AND (hostChannel.sMycall<>csNOCALL);
END;


PROCEDURE SetOrQuery( VAR sArg : STRING;
                     {$IFDEF VER70} CONST {$ENDIF} hWrk : T_HCB;
                     {$IFDEF VER70} CONST {$ENDIF} default, ofs : WORD;
                      size : longInt );
  VAR x : Longint;
      fOK : BOOLEAN;
      p : Pointer;
BEGIN
  p := hostChannel[hWrk.kanalnr].pSelfCB;
  x := default;
  fok := false;

  IF p <> NiL THEN
    BEGIN
    Inc(longint(p),ofs);
    IF sArg= ''
      THEN BEGIN {* Nur aktuellen Wert ausgeben *}
           IF size=1 THEN x := byte(p^);
           IF size=2 THEN x := word(p^);
           IF size=4 THEN x := longint(p^);
           fok := true;
           END
      ELSE BEGIN {* Neuen Wert setzen *}
           x := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
           IF x <> NOTANUMBER THEN
             BEGIN
             IF size=1 THEN byte(p^) := x AND 255;
             IF size=2 THEN word(p^) := x AND 65535;
             IF size=4 THEN longint(p^) := x;
             fok := true;
             END;
           END;
    END;
  IF fok THEN SendMSG(hWrk.kanalnr, 1, fStr(x))
         ELSE SendMSG(hWrk.kanalnr, 0, '');
END;



PROCEDURE Host_Main (VAR hWrk:T_HCB);
{* Auswerten eines Blocks vom PC/Host. Wird von HostMode_Handler aufgerufen *}
  VAR i : WORD;
      iv : BYTE;
      v : ARRAY [1..5] OF Longint;
      cTmp, cTrenn :char;
      nrport, c : byte;
      sLoc, sZeile,sArg1,sArg2,sArg3 : STRING;
      sXHost : STRING ABSOLUTE sLoc;
      pCBSys, pCB : TP_AXCB;
      mmWork : T_monimode;
      shPath : T_shPath;
      fChgIUSC,
      fPortChg : BOOLEAN;
      pNewCB : TP_AXCB;
      poll : T_KMPF;
      ch : Char;
  Label lExit;
BEGIN
  Inc(host[1].nHostPolls);

  IF host[1].fHostInAktivTextTxed THEN
    BEGIN
    {* Meldung an wartende Infoboxbenutzer *}
    DoTell ( nil,
        {$IFDEF Deutsch}
         'Terminal ist gestartet worden! CHAT eingeben um dieses zu connecten'
        {$ELSE}
         'Terminal has been started. Enter CHAR to connect to terminal'
        {$ENDIF}
         );
    host[1].fHostInAktivTextTxed := false;
    END;

  host[1].fTurboEventAllowed := true; {* Nach jedem Befehl oder Info vom PC ist ein Event erlaubt *}

  {- Extended Hostmode Poll? -}
  IF (hWrk.KanalNr=255) AND
     (NOT hWrk.isInfo)  AND
     (hWrk.datalen=1)   AND
     (upcase(char(hWrk.data[1]))='G')
     THEN BEGIN {- Extended Hostmode! -}
          Inc(host[1].nXHostPolls);
          host[1].timeLastRxHostModePoll := SlowTick;
          sXHost := '';
          FOR i := 0 TO {yCmd}MAXHOSTKANAL DO
            IF (hostChannel[i].nHstMsgQueue  <> 0) OR
               (hostChannel[i].nHstDataFrame <> 0) THEN
                  AddChar(sXHost, char(i+1));
          SendMsg(255,1, sXHost);
          Goto LExit;
          END;
  {- Ende Extended Hostmode -}

  IF hWrk.kanalnr > {yCmd}MAXHOSTKANAL THEN
    BEGIN
    SendMsg(hWrk.kanalnr,2, csINVALIDCHANNELNUMBER);
    Goto LExit;
    END;

  IF NOT fDAMALEDinUse THEN host[1].ProcLED( 3, cAnschalten);

  pCB := hostChannel[hWrk.kanalnr].pSelfCB;
  IF hWrk.isInfo THEN
    BEGIN {* Daten *}
    IF hWrk.kanalNr=0 THEN
       BEGIN {* UI-Tx *}
       IF uiPara[cChan].fPoll THEN poll := cPOLL
                              ELSE poll := cKOMM;
       TxUI( @hWrk.data[1], hwrk.DataLen, cChan{ifLoopback},
             hostChannel[hWrk.kanalnr].sMyCall,
             uiPara[cChan].target,
             uiPara[cChan].via,
             poll, PID_TEXT );
       SendMsg(hWrk.kanalnr,0, '');
       Goto LExit;
       END;
    {* Hostmodeanzeige schoenen *}
    {* if pCB^.tries=0 then inc(pCB^.tries);*}
    SendMsg(hWrk.kanalnr,0, ''); {- und besttigen -}
    Tx_MemBlock( pCB, SOFORT, @hWrk.data[1], hWrk.DataLen ); {- Info on Air -}
    Goto LExit;
    END;

  {* Kommando *}
  IF hWrk.datalen > 0 THEN
    BEGIN
    {* Die Kommandos G und L werden hufig gegeben, und sollten so schnell wie mglich bearbeitet werden *}
    ch := upcase(char(hWrk.data[1]));
    IF ch ='G' THEN
      BEGIN {* Mglich: G0, G1, G *}
      {* fSendData   :=hWrk.data[2] <> byte('1');}
      {* fSendStatus :=hWrk.data[2] <> byte('0');}
      IF hostChannel[hWrk.kanalnr].nHstMsgQueue <> 0
        THEN BEGIN
             HstTxStatus (hWrk.Kanalnr);
             END
        ELSE IF pCB = Nil
              THEN BEGIN
                   IF ((hwrk.kanalnr=0) and (hostChannel[hwrk.kanalnr].nhstDataFrame>0))
                     THEN HstTxStatus (hWrk.Kanalnr)
                     ELSE IF hostChannel[hwrk.kanalnr].nhstDataFrame=0
                            THEN SendMsg(hWrk.kanalnr,0, '' ) {* Auf dem Kanal ist keiner (mehr) *}
                            ELSE Inc(count[cntLHOST]);
                   END
              ELSE IF hostChannel[hWrk.kanalnr].nHstDataFrame > 0
                        THEN HstTxData(hWrk.Kanalnr) {* Info senden *}
                        ELSE SendMsg(hWrk.kanalnr,0, '' ); {* Nix Passiert *}
      Goto LExit; {* *}
      END;

    IF ch ='L' THEN
      BEGIN
      sLoc := fStr (hostChannel[hWrk.kanalnr].nHstMsgQueue)+' '+
              fStr (hostChannel[hWrk.kanalnr].nHstDataFrame);
      IF (hWrk.Kanalnr <> 0) THEN {* Monitor Kanal sendet nur "0 0" *}
        BEGIN
        IF pCB = Nil
          THEN BEGIN
               AddString(sLoc,' 0 0 0 0');
               END
          ELSE BEGIN
               {* IF NOT CheckAxCB(pCB,true) THEN Goto LExit;}
               AddString(sLoc,
                     ' ' + fStr (pCB^.txbufsize DIV (pCB^.paclen+1))
               {* Manchmal ist paclen=0: also.. es muss ne timingfrage des hostmode-prg's
                * sein... je nach dem wie lahm oder schnell das den l-befehl haben will..
                * wenn der pCB nach eintreten der Routine kurz vor der Division wech ist,
                * dann knallt's.. *}
                     + ' ' + fStr (pCB^.nUnbest)
                     + ' ' + fStr (pCB^.tries)
                     + ' ' + fStr (ConvertState(pCB))
               );
               END;
         END;
       SendMsg(hWrk.kanalnr,1,sLoc); {* Erfolg mit Info ASCIIZ *}
       Goto LExit; {* L ist nach G das 2.hauefigste CMD *}
     END;
  END;

  {* $TODO: HACK, muss auch 256 knnen, bei Kommandos aber nicht so schlimm... *}
  IF hWrk.datalen > 255 THEN BEGIN
                             hWrk.DataLen := 255;
                             {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
                             Inc(count[cntHCMD2Long]);
                             {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}
                             END;
  sZeile[0] := Char (hWrk.datalen);
  Move (hWrk.data[1], sZeile[1], hWrk.datalen);
  {*WHILE (sZeile[1]=' ') AND (Length(sZeile)>0) DO Delete (sZeile,1,1);*}
  LTrim(sZeile);
  IF sZeile='' THEN
    BEGIN
    SendMsg(hWrk.kanalnr,2, 'INVALID COMMAND');
    Goto LExit;
    END;

  WHILE (length(sZeile)>0) AND ( sZeile[1] = #$0d ) DO Delete(sZeile,1,1);
  WHILE (length(sZeile)>0) AND ( sZeile[1] = #$0a ) DO Delete(sZeile,1,1);

  host[1].timeLastRxHostModePoll := SlowTick;
  IF sZeile[1] = '@'
    THEN BEGIN {* Extended Kommando / HACK HACK *}
         sArg1 := char(byte(upcase(sZeile[2]))+128);
         Delete(sZeile,1,2);
         END
  ELSE IF sZeile[1] = '&' THEN
         BEGIN {* Sysopkommando durchfhren, z.B. ESC & p scc 1 baud 9600 init *}
         Delete(sZeile,1,1);
         pCBSys := CreateAXCB( 1 {MAX_IFACE} ); {* irgendwo einloggen *}
         IF pCBSys = NiL THEN
           BEGIN
           SendMsg(hWrk.kanalnr,2, 'Internal Error');
           Goto LExit;
           END;
         AscCall2shift (SysopCall, pCBSys^.toCall);
         OpenInfoBox (pCBSys,FALSE{mitCText},0,0 {Statistikzeug});
         pCBSys^.who := SysOp;
         Infobox_Interpreter (pCBSys, DIGISETUP, sZeile);
         Private_Del_Axcb(pCBSys);
         SendMsg(hWrk.kanalnr,1, sZeile);
         Goto LExit;
         END
    ELSE BEGIN
         sArg1 := sZeile[1];
         Delete(sZeile,1,1);
         END;

  ScanForText (sZeile,sArg2);
  sArg3 := sZeile; sZeile := '';

  CASE byte(upcase(sArg1[1])) OF {* Hufige Kommandos zuerst ! *}
   {* Extendeded Commands *}
   {* ESC @B   Anzeige der freien TNC-Buffer. *}
   Byte('B')+128 : SendMsg(hWrk.kanalnr,1, fStr({nHostBuffer}sysMemAvail div 256) );
                   {* Bei weniger als 200 Buffer will z.B. DieBox 1.8 nich mehr *}

{*}BYTE('C')+128 : {* @CCHAN = Current Channel, vorwiegend fuer CH0 verwendet..
                    * heisst beim TNC3 brigens #PORT
                    *}
                IF f_upper(sArg2)<>'CHAN'
                  THEN SendMsg(hWrk.kanalnr,2, csINVALIDEXTENDEDCOMMAND+char(ord(sarg1[1])-128)+f_upper(sArg2))
                  ELSE BEGIN {@CCHAN}
                       IF sArg3='' THEN SendMSG(hWrk.kanalnr,1, fstr(cChan))
                                   ELSE BEGIN{@CCHAN <arg>}
                                        i:=f_val(sArg3);
                                        {* macht ja erstmal nur sinn auf port 1-8 *}
                                        if (i<1) or(i>MAX_IFACE)
                                          then BEGIN
                                               SendMsg(hWrk.kanalnr,2, csINVALIDVALUE+sarg3);
                                               end
                                          else BEGIN
                                               cChan := i;
                                               SendMsg(hWrk.kanalnr,0, '' );
                                               END;
                                        Goto LExit;
                                        END;
                       END;

   BYTE('E')+128 : {* @ESTAT *}
                IF f_upper(sArg2)<>'STAT'
                  THEN SendMsg(hWrk.kanalnr,2, csINVALIDEXTENDEDCOMMAND+'@E'+f_upper(sarg2))
                  ELSE BEGIN {@ESTAT}
                       IF sArg3=''
                         THEN BEGIN
                              IF fDRSI then SendMSG(hWrk.kanalnr,1, '1')
                                       else SendMSG(hWrk.kanalnr,1, '0');
                              END
                         ELSE BEGIN {* @ESTAT <arg> *}
                              i:=f_val(sArg3);
                              if i>1 then i:=0;
                              fDRSI := i=1;
                              SendMsg(hWrk.kanalnr,0, '' );
                              Goto LExit;
                              END;
                       END;

   {ESC @K Einschalten des eingebauten KISS/SMACK-Modus.}
   Byte('K')+128 : SendMsg(hWrk.kanalnr,2, csINVALIDEXTENDEDCOMMAND+char(ord(sarg1[1])-128));
                   {*IF hw[hostportnr].valid THEN hw[hostportnr].fnDeInitCh(hostportnr);
                   *axIFace [hostportnr].Valid := FISS_Init (hostportnr,hostcomnr);
                   *hw[hostportnr].valid := hw[hostportnr].fnInitCh(hostportnr);
                   }

   {* ESC B  *Neu in TF2.7
             Anzahl der Hauptschleifendurchl"ufe in
             "Runden pro Sekunde". Diese Zahl erlaubt Rckschlsse
             auf die interne Verarbeitungsgeschwindigkeit der
             TNC-Software. *}
   BYTE('B')     : SendMSG(hWrk.kanalnr,1,fStr(hostrps.act));
   BYTE('R')+128 : {* @RPS *}
                IF f_upper(sArg2)<>'PS'
                  THEN SendMsg(hWrk.kanalnr,2, csINVALIDEXTENDEDCOMMAND+'@R'+f_upper(sarg2))
                  ELSE BEGIN
                       IF sArg3=''
                         THEN SendMSG(hWrk.kanalnr,1, RPSAsString)
                         ELSE BEGIN
                              i:=f_val(sArg3);
                              CASE i OF
                                0: BEGIN
                                   SendMsg(hWrk.kanalnr,0, '' );
                                   hostrps.del:=true;
                                   Goto Lexit;
                                   END;
                                ELSE SendMsg(hWrk.kanalnr,2, csINVALIDVALUE+sarg3);
                                END;
                              END;
                       END;
   {* ESC @T2  und  ESC @T3 *}
   Byte('T')+128 : IF sArg2 = ''
                     THEN SendMsg(hWrk.kanalnr,2, 'INVALID EXTENDED COMMAND: '+char(ord(sarg1[1])-128))
                     ELSE BEGIN
                          IF sarg2[0]=#1
                             THEN Case sArg2[1] of
                                    '2': SetOrQuery(sArg3, hWrk,   100, ofs(TP_axcb(nil)^.t2.tickinit), 4);
                                    '3': SetOrQuery(sArg3, hWrk, 10000, ofs(TP_axcb(nil)^.t3.tickinit), 4);
                                    ELSE SendMsg(hWrk.kanalnr,2, csINVALIDEXTENDEDCOMMAND
                                                                 +char(ord(sArg1[1])-128)+f_upper(sArg2[1]));
                                    END {* case *}
                             ELSE SendMsg(hWrk.kanalnr,0, '' );
                          END;
{//hack////////}
{*   byte('+') : DoTest; *}
{byte('*') :
    BEGIN
    fHackFlxComp := sArg2='1';
    SendMsg(hWrk.kanalnr,1, fstr(ord(fHackFlxComp)) ) {* Monitor UI PATH*}
{    END;}

   byte('C')
     : IF sArg2 = ''
         THEN BEGIN  {* Param.abfragen *}
              IF hostChannel[hWrk.kanalnr].status <> FREE
                THEN BEGIN  {* Ausgabe mit wem man connected ist (u.a. wegen GP/2 QRG Erkennung (Logbuch)) *}
                     {* DL7GAI 8-96 *}
                     sLoc := '';
                     IF fDRSI THEN sLoc := fStr(HostChannel[hWrk.kanalnr].portnr)+':';
                     AddString(sLoc,f_sh2Asc(pCB^.toCall));
                     IF pCB^.nDigi > 0 THEN
                       AddString(sLoc,' via '+ F_Digi2str ( pCB, 1 ) );
                     SendMsg(hWrk.kanalnr,1, sLoc );
                     Goto LExit;
                     END
                ELSE IF hWrk.kanalNr = 0
{*}                    THEN SendMsg(hWrk.kanalnr,1, uiPara[cChan].target+' '+uiPara[cChan].via ) {* Monitor UI PATH*}
                       ELSE SendMsg(hWrk.kanalnr,1, csCHANNELNOTCONNECTED )
              END
         ELSE BEGIN {* Param.setzen *}
              IF hWrk.kanalNr=0 THEN
                BEGIN {* Fr MonitorKanal *}
                uiPara[cChan].target:=f_upper(sArg2);
                uiPara[cChan].via   :=f_upper(sArg3);
                SendMsg(hWrk.kanalnr,0, '' );
                Goto LExit;
                END;
              IF (hostChannel[hWrk.kanalnr].status<>free)
                THEN SendMsg(hWrk.kanalnr,2, csCHANNELALREADYCONNECTED )
                ELSE BEGIN {* Auf freiem Kanal & mit Argument -> Connectversuch *}
                     nrPort := 0;
                     Trim(sArg2);
                     IF sArg2[2]=':' THEN
                       BEGIN
                       IF sArg2[1]>'0' THEN nrPort := Ord(sArg2[1])-Ord('0');
                       sArg2 := Copy(sArg2,3,255);
                       END;
                     IF (Copy(f_Upper(sArg2),1,6)='FALCON') OR ((sArg2 < '0') AND (sArg2 > ' '))
                       THEN BEGIN  {* TrytoConnect auf dem Loopback *}
                            hostChannel[hWrk.kanalnr].pSelfCb :=
                              Try2Connect (ifLoopback,
                                   axiface[ifLoopback].asMyCall,
                                   axiface[ifLoopback].asMyIdent, '',
                                   true{=(automatisches SSID erhhen} );
                            END
                       ELSE BEGIN
                            IF NOT MyHostCallValid (hostchannel[hwrk.kanalnr]) THEN
                              BEGIN
                              SendMsg(hWrk.kanalnr,2, csNOSOURCECALLSIGN);
                              Goto LExit;
                              END;
                            {* Hier ers ma testen, ob 'mer die sArg2 schon con haben *}
                            FOR c := 1 TO maxhostkanal DO
                              IF hostchannel[c].status<>free THEN
                                IF f_sh2asc(hostchannel[c].pSelfCB^.tocall)=sArg2 THEN
                                  IF hostchannel[hwrk.kanalnr].sMyCall=hostchannel[c].sMyCall THEN
                                    BEGIN
                                    SendMsg(hWrk.kanalnr,2, csSTATIONALREADYCONNECTED);
                                    Goto LExit;
                                    END;

                            IF (nrPort>0) AND (nrPort<8)
                              THEN BEGIN {* C 1:DB0ME *}
                                   sArg2 := f_Upper(sArg2);
                                   String2shPath (sArg2+' '+sArg3{Damit GAIt auch via!!! DANKE! Hans}, shPath);
                                   Move (shPath.Digi[0], shPath.Digi[1], (1+shpath.ilDigi)*Sizeof(shPath.Digi[2]));
                                   Inc(shpath.ilDigi);
                                   AscCall2shift (
                                     hostchannel[hwrk.kanalnr].sMyCall,
                                     shPath.Digi[0]
                                   );
                                   shPath.ifnr := nrPort;
                                   {* Baue einen Connect mit den in shPath stehenden Daten auf. Kein AR *}
                                   pNewCB := TryToConnectShPath (shPath);
                                   END
                              ELSE BEGIN {* Ohne Portnr:  C DB0ME *}
                                   pNewCB := Connect(sArg2+' '+sArg3,hWrk.kanalnr);
                                   END;
                            hostChannel[hWrk.kanalnr].pSelfCb := pNewCB;
                            END;

                     IF hostChannel[hWrk.kanalnr].pSelfCb = Nil THEN
                       BEGIN {* Kein Speicher mehr, oder Station schon connected *}
                       SendMsg(hWrk.kanalnr,2, csSTATIONALREADYCONNECTED);
                       Goto LExit;
                       END;
                     SendMsg(hWrk.kanalnr,0, ''); {* Ok, Erfolg *}
                     {WITH hostChannel[hWrk.kanalnr] DO}
                       BEGIN
                       hostChannel[hWrk.kanalnr].pSelfCb^.divers.bHostKanal := hWrk.KanalNr;
                       hostChannel[hWrk.kanalnr].pSelfCb^.QSOType           := qtHost;
                       hostChannel[hWrk.kanalnr].pSelfCB^.fMsgHandler       := fnMsgHOSTConTry;
                       hostChannel[hWrk.kanalnr].status                     := Connecting;
                       hostChannel[hWrk.kanalnr].sCallAndPath               := f_upper(sarg2+' '+sarg3);
                       hostChannel[hWrk.kanalnr].portnr                     := hostChannel[hWrk.kanalnr].pSelfCB^.iface;
                       END;
                     END;
{*}           END;

   byte('D') : BEGIN {* Disconnect *}
               IF hostChannel[hWrk.kanalnr].status<>free
                THEN BEGIN
                     SendMsg(hWrk.kanalnr,0, '');
                     CloseHost( pCB,hstDISCONNECTED);
                     END
                ELSE BEGIN
                    {* DISC auf 'nem LEEREN CHANNEL ist *}
                    {* VERBOTEN !!! -> ABSCHMIER..... PFFT..PENG*}
                    SendMsg(hWrk.kanalnr,1, csCHANNELNOTCONNECTED );
                    END;
               END;

   byte('I') : IF sArg2 = ''
                 THEN SendMsg(hWrk.kanalnr,1, hostChannel[hWrk.kanalnr].sMyCall )
                 ELSE BEGIN
                      IF hostchannel[hwrk.kanalnr].status<>free
                        THEN BEGIN
                             SendMsg(hWrk.kanalnr,2, csNOTWHILECONNECTED);
                             Goto LExit;
                             END
                        ELSE BEGIN {* Naechste 2 Zeilen wichtig wegen GP/2 Auto-SSID... *}
                             Trim(sArg2);
{*}                          IF fVCallCheck THEN sArg2:=fAsciiCallCheck(sArg2);
                             IF sArg2=''
                               THEN SendMsg(hWrk.kanalnr,2, csINVALIDCALLSIGN)
                               ELSE BEGIN
                                    SetMyCall( hWrk.kanalnr, sArg2 );
                                    SendMsg(hWrk.kanalnr,0, '');
                                    END;
                             Goto LExit;
                             END;
                      END;

   byte('J') : BEGIN {* peinlich... *}
               IF f_Upper(sarg2) = 'HOST'              THEN SendMsg(hWrk.kanalnr,1, '1' )
               ELSE IF Pos('HOST0',f_Upper(sarg2)) = 1 THEN
                      BEGIN {* zurck in den Terminalmode *}
                      SendMsg(hWrk.kanalnr,0, '');
                      host[1].fTerminalAktiv := true;
                      END
               ELSE IF Pos('HOST1',f_Upper(sarg2)) = 1 THEN
                      BEGIN {* 'Norm'Hostmode *}
                      SendMsg(hWrk.kanalnr,0, ''); {* Besttigen *}
                      host[1].fTurbo := false;
                      END
               ELSE IF Pos('HOST2',f_Upper(sarg2)) = 1 THEN
                      BEGIN {* 'Turbo'Hostmode *}
                      SendMsg(hWrk.kanalnr,0, ''); {* Besttigen *}
                      host[1].fTurbo := true;
                      host[1].fTurboEventAllowed := false;
                      END
               ELSE SendMsg(hWrk.kanalnr,2, csINVALIDCOMMAND+'J'+f_Upper(sarg2));
               END;

   {* ESC K [<n>]    Aktivierung der STAMP-Funktion und Parametrierung der ein
                     gebauten 24-Stunden-Uhr mit Kalender.
                     Beispiele:
                     K            -  Stamp und Datum/Zeit anzeigen
                     K 0          -  Stamp abschalten
                     K 1          -  Stamp Statusmeldungen einschalten
                     K 2          -  Stamp Status- und Monitormeldungen einschalten
                     K 20.02.88   -  Datum setzen, europaeische Form
                     K 02/20/88   -  Datum setzen, amerikanische Form
                     K 17:36:00   -  Uhrzeit setzen
    *}
   byte('K') : IF sarg2 = ''
                 THEN BEGIN
                      CASE eTimeStampMode OF
                       ceNONE     : SendMsg(hWrk.kanalnr,1, '0 '+FrameTimeStamp );
                       ceSTAT    : SendMsg(hWrk.kanalnr,1, '1 '+FrameTimeStamp );
                       ceSTATMONI : SendMsg(hWrk.kanalnr,1, '2 '+FrameTimeStamp );
                       END;
                      END
                 ELSE BEGIN
                      IF sarg2[0]=#1
                        THEN BEGIN
                             case sarg2[1] of
                                '0' : BEGIN
                                      eTimeStampMode:=ceNONE;
                                      SendMsg(hWrk.kanalnr,0, '');
                                      END;
                                '1' : BEGIN
                                      eTimeStampMode:=ceSTAT;
                                      SendMsg(hWrk.kanalnr,0, '');
                                      END;
                                '2' : BEGIN
                                      eTimeStampMode:=ceSTATMONI;
                                      SendMsg(hWrk.kanalnr,0, '');
                                      END;
                                ELSE SendMsg(hWrk.kanalnr,2, csINVALIDVALUE+sarg2);
                               END; {* of CASE *}
                             END
                        ELSE BEGIN { set DATE/TIME, parsen }
                             iv := 1; v[1] := 0; cTrenn := ' ';
                             FOR i := 1 TO length(sarg2) DO
                               BEGIN
                               cTmp := sarg2[i];
                               IF cTmp <= ' ' THEN
                               ELSE IF IsDigit(cTmp)
                                 THEN v[iv] := Ord(cTmp)-48 + 10 * v[iv]
                                 ELSE BEGIN
                                      Inc(iv);
                                      v[iv] := 0;
                                      IF cTmp > ' ' THEN cTrenn := cTmp;
                                      END;
                               END;
                             IF cTrenn = ':' THEN { HH:MM }    SetTimeDW( v[1],v[2],v[3],0);
                             IF cTrenn = '.' THEN { TT.MM.JJ } SetDateDW( v[3],v[2],v[1]);
                             IF cTrenn = '/' THEN { MM/DD/YY } SetDateDW( v[3],v[1],v[2]);
                             Gettime(systime.hour,systime.min,systime.sec,wdummy);
                             Getdate(systime.year,systime.month,systime.day,wdummy);
                             SendMsg(hWrk.kanalnr,0, '');
{*}                          Goto LEXIT;
                             END;
                      END;

   byte('M') : IF sArg2 = ''
                 THEN SendMsg(hWrk.kanalnr, 1, MonitorModeString )
                 ELSE BEGIN
                      Watchdog; {* Sicher ist Sicher ! *}
                      sZeile:=f_UPPER(sArg2+' '+sArg3);{*leerzeichen wichtig wg. miusc+dl7gai db0me*}
                      {* War nur Test: LogAddEntry ( NiL, leAutoComment, 'ESC M:'+sZeile ); *}
                      mmWork:=host[1].moniMode;  {* eingestellte Parameter ers mal sichern *}
                      Fillchar(mmWork.afPort,sizeof(mmWork.afPort),#0);
                      mmWork.iusc.n := true;
                      mmWork.iusc.i := false;
                      mmWork.iusc.t := false;
                      mmWork.iusc.d := false;
                      mmWork.iusc.p := false;
                      mmWork.iusc.z := false;
                      mmWork.iusc.g := false;
                      mmWork.iusc.u := false;
                      mmWork.iusc.s := false;
                      mmWork.iusc.c := false;
                      fChgIUSC := FALSE;
                      fPortChg := FALSE;
                      WHILE (sZeile<>'') DO
                        BEGIN
                        CASE sZeile[1] of
                          ' ' : ;
                          'N' : BEGIN
                                mmWork.iusc.n := true;
                                mmWork.iusc.i := false;
                                mmWork.iusc.t := false;
                                mmWork.iusc.p := false;
                                mmWork.iusc.d := false;
                                mmWork.iusc.g := false;
                                mmWork.iusc.u := false;
                                mmWork.iusc.s := false;
                                mmWork.iusc.c := false;
                                fChgIUSC := true;
                                END;
                          'I' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.i:=true;
                                END;
                          'U' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.u:=true;
                                END;
                          'S' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.s:=true;
                                END;
                          'C' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.c:=true;
                                END;
                          'T' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.t:=true;
                                END;
                          'P' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.p:=true;
                                mmWork.iusc.d:=false;
                                END;
                          'D' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.d:=true;
                                mmWork.iusc.p:=false;
                                END;
                          'Z' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.z:=true;
                                END;
                          'G' : BEGIN
                                fChgIUSC := true;
                                mmWork.iusc.g:=true;
                                END;

                          '+' : BEGIN
                                Delete(sZeile,1,1);
                                mmWork.call.pl:=true;
                                mmWork.call.mi:=false;
                                LeseMoniCall ( mmWork, sZeile );
                                sZeile := '';
                                END;
                          '-' : BEGIN
                                Delete(sZeile,1,1);
                                mmWork.call.mi:=true;
                                mmWork.call.pl:=false;
                                LeseMoniCall ( mmWork, sZeile );
                                sZeile := '';
                                END;
                          '1'..'7'
                              : BEGIN
                                fPortChg := true;
                                mmWork.afPort[Ord(sZeile[1])-ord('0')] := TRUE;
                                END
                           ELSE BEGIN {* Alles fehlerhafte Params *}
                                SendMsg(hWrk.Kanalnr,2,csINVALIDPARAMETER);
                                Goto LExit;
                                END;
                          END; {* Case *}
                        Delete(sZeile,1,1);
                        END; { while .. do BEGIN }
                      SendMsg(hwrk.kanalnr,0, '');
                      {* So, ArbeitsVariable in Echtvariable reintuen *}
                      IF fChgIUSC THEN host[1].moniMode.iusc:=mmWork.iusc;
                      IF fPortChg THEN host[1].moniMode.afPort := mmWork.afport;
                      IF mmWork.call.pl OR mmWork.call.mi THEN
                        BEGIN
                        host[1].moniMode.call := mmWork.call;
                        IF host[1].moniMode.call.pl THEN host[1].moniMode.call.mi := false;
                        IF host[1].moniMode.call.mi THEN host[1].moniMode.call.pl := false;
                        END;
                      host[1].moniMode.iusc.n := NOT (
                                host[1].moniMode.iusc.i
                             OR host[1].moniMode.iusc.u
                             OR host[1].moniMode.iusc.s
                             OR host[1].moniMode.iusc.c
                             OR host[1].moniMode.iusc.t
                             OR host[1].moniMode.iusc.g
                      );
                      END;

   byte('U') : IF sArg2 = ''
                 THEN SendMsg(hWrk.kanalnr,1, f_bool(fUMode)+' '+UText )
                 ELSE BEGIN {U-Text setzen}
                      fUMode := NOT (f_val(sArg2[1])=0);
                      IF sArg3 <> ''
                        THEN BEGIN
                             UText := sArg3;
                             SendMsg(hWrk.kanalnr,0, '' );
                             END
                        ELSE BEGIN  {* Wegen eingabe "u 1 testbetrieb" oder so *}
                             IF ord(sARG2[1]) in [48..49] THEN Delete(sarg2,1,1);
                             IF sarg2<> '' THEN UText := sArg2;
                             IF (fuMode and (utext='')) THEN
                               BEGIN
                               fumode:=false;
                               SendMsg(hWrk.kanalnr,2, csNOMESSAGEAVAILABLE);
                               Goto LEXIT;
                               END;
                              SendMsg(hWrk.kanalnr,0, '' );
                              END;
                      END;

   byte('V') : SendMSG(hWrk.kanalnr,1, copyright1);

   byte('Q') :  {- ESC QRES       Neustart der Firmware (Kaltstart) aus dem EPROM. -}
               IF sArg2='RES' THEN WHILE TRUE DO; {* Watchdog! Fass! *}

   {* Slottime etc. wird nicht hier eingestellt *}
   byte('F') : SetOrQuery(sArg2, hWrk, 4, ofs(TP_axcb(nil)^.t1.tickinit), 4);

   BYTE('P')+128 {* PacLen *}
             : SetOrQuery(sArg2, hWrk, 10, ofs(TP_axcb(nil)^.paclen), 2);
   BYTE('P') {Persistence/PID}
             : IF f_Upper(sArg2)='ID'
                 THEN SetOrQuery(sArg3, hWrk,111, ofs(TP_axcb(nil)^.pid), 1)
                 ELSE If sArg2 = '' THEN SendMSG(hWrk.kanalnr,1, '1')
                                    ELSE SendMSG(hwrk.Kanalnr,0, '');  {* Erfolg, keine Nachricht *}

{*}Byte('N') : SetOrQuery(sArg2, hWrk, 10, ofs(TP_axcb(nil)^.retry), 1);

   byte('O') : SetOrQuery(sArg2, hWrk, 7, ofs(TP_axcb(nil)^.maxframe), 1);


   byte('W') : If sArg2 = '' THEN SendMSG(hWrk.kanalnr,1, '10')
                             ELSE SendMSG(hwrk.Kanalnr,0, '');
   byte('I')+128 {* Ipollschwelle *}
             : If sArg2 = '' THEN SendMSG(hWrk.kanalnr,1, '40')
                             ELSE SendMSG(hwrk.Kanalnr,0, '');
   byte('P'),
   byte('R'),
   byte('T'),   {Transmitter delay (10ms)}
   byte('A'),   {Auto linefeed}
{*}Byte('X'),   {PTT disabled}
{ESC X [0..1]    Steuerung der PTT-Leitung des TNC. Falls erforderlich kann
                 hiermit das Einschalten des Senders unterdrueckt werden, wenn
                 man z.B. die Frequenz beobachten moechte, aber verhindern will,
                 dass der TNC bei einer Connect-Anfrage ein Busy-Paket zurueck
                 sendet.}
   BYTE ('Z') : {FlowControl}
                If sArg2 = '' THEN SendMSG(hWrk.kanalnr,1, '1')
                              ELSE SendMSG(hwrk.Kanalnr,0, '');  {* Erfolg, keine Nachricht *}

   Byte('U')+128
              : {* UI-poll *}
                IF sArg2=''
                  THEN BEGIN
                       IF uiPara[cChan].fPoll THEN SendMSG(hWrk.kanalnr,1, '1')
                                              ELSE SendMSG(hWrk.kanalnr,1, '0');
                       END
                  ELSE BEGIN{@U <arg>}
                       uiPara[cChan].fPoll := (f_val(sArg2)=1);
                       SendMsg(hWrk.kanalnr,0, '');
                       Goto LExit;
                       END;

   Byte('V')+128
              : {* Callsign-Check *}
                IF sArg2=''
                  THEN BEGIN
                       IF fVCallCheck THEN SendMSG(hWrk.kanalnr,1, '1')
                                      ELSE SendMSG(hWrk.kanalnr,1, '0');
                       END
                  ELSE BEGIN{@V <arg>}
                       i:=f_val(sArg2);
                       fVCallCheck := i=1;
                       SendMsg(hWrk.kanalnr,0, '');
                       Goto LExit;
                       END;

   BYTE('Y') : IF sArg2 = ''
                 THEN BEGIN {* Anzahl Kanle ausgeben *}
                      SendMsg(hWrk.Kanalnr,1,fStr(GetHstChannelUsed)
                                     + ' / '+fStr(yCmdMAXHOSTKANAL));
                      END
                 ELSE BEGIN
                      i:=f_val(sarg2);
{*}                   IF (i>MAXHOSTKANAL) OR (i<0)
                        THEN SendMsg(hWrk.kanalnr,2, csINVALIDVALUE+sarg2)
                        ELSE BEGIN
                             yCmdMAXHOSTKANAL:=i;
                             SendMsg(hWrk.kanalnr,0, '');  {* erfolg, keine NAchricht *}
                             END
                      END;

     ELSE {* Case *}
          BEGIN
          AndSelf( byte(sArg1[1]),127 ) ; {* Hack fr extended Kommando rckgngig machen *}
          sArg1 := AsTFString ( @sarg1[1], length(sarg1) );
          SendMsg(hWrk.kanalnr,2, csINVALIDCOMMAND + f_upper(sArg1) );
          END;
  END; {*case*}

  lExit:
    IF NOT fDAMALEDinUse THEN host[1].ProcLED( 3, cAusschalten);
END;

{}


FUNCTION CtrlChr(chara:char):byte;
BEGIN
  CASE ord(chara) of
    7       : ctrlchr:=0;
    1..6,
    8..31   : ctrlchr:=1;
    32..255 : ctrlchr:=2;
  END;
END;


      VAR sKommand:string[255];
PROCEDURE TermUserMain(hISR:T_HCB);
{* Verarbeitet das aktuelle Zeichen im Terminalmode *}
  CONST tbspace = chr(8)+' '+chr(8);
  VAR   lang : integer;
        ch   : char;
BEGIN
 WITH hISR DO
   BEGIN
{   IF host[1].fHayesAktiv THEN
     BEGIN
     ATRxChar;
     Exit;
     END;}

   ch := host[1].ProcRx1Char;

   IF (ch = ESC) AND NOT fTermCommand
     THEN BEGIN
          sKommand := '';
          Sendstr('* ');
          fTermCommand := TRUE;
          END
   ELSE IF ch =#$01 THEN host[1].fTerminalAktiv := false {* wg. Resync *}
   ELSE IF ch =#$10 THEN {* ignore mcut *}
   ELSE IF ch =#$11 THEN {* ignore ctrl q  xon *}
   ELSE IF ch =#$12 THEN {* ignore mcut *}
   ELSE IF ch =#$08 THEN BEGIN      { Backspace ^H }
                        IF length(sKOMMAND)>0
                          THEN BEGIN
                               CASE ctrlchr(skommand[length(skommand)]) of
                                   0 : ; {* nix tuen, war ctrl-G*}
                                   1 : SendStr(tbspace+tbspace);
                                   2 : SendStr(tbspace);
                                 END;
                                 delete(skommand,length(skommand),1);
                               END
                          ELSE IF fTermCommand THEN
                                 BEGIN
                                 Sendstr(tbspace+tbspace);
                                 fTermCommand:=false;
                                 END;
                         END
   ELSE IF (ch =#$18) OR (ch=#$15 ) THEN BEGIN         { delete line ^X oder strg/u}
                        IF length(skommand)>0 THEN
                          BEGIN
                          FOR lang:=1 to length(skommand) do
                            CASE ctrlchr(skommand[lang]) of
                                   0 : ; {* nix tuen, war ctrl-G*}
                                   1 : SendStr(tbspace+tbspace);
                                   2 : SendStr(tbspace);
                              END;
                          sKommand[0] := #0;
                          IF fTermCommand THEN SendStr(tbspace+tbspace); {* kill '* '}
                          fTermCommand := FALSE;
                          END;
                        END
   ELSE IF ch =#$0d THEN BEGIN
                        IF fTermCommand
                          THEN BEGIN
                               sKommand:=f_upper(sKommand);
                               IF (Pos ('JHOST1', sKommand) > 0) OR
                                  (Pos ('JHOST 1',sKommand) > 0)
                                  THEN host[1].fTerminalAktiv := false
                               ELSE IF
                                  (Pos ('JHOST2', sKommand) > 0) OR
                                  (Pos ('JHOST 2',sKommand) > 0)
                                  THEN BEGIN
                                       host[1].fTerminalAktiv := false;
                                       host[1].fTurbo := true;
                                       END
{******                        ELSE IF Pos('AT',sKommand)>0 THEN InitAT(host[1], sKommand)***}
                               ELSE IF Pos('@K',sKommand)>0 THEN
                               ELSE IF sKommand[1]=#0 THEN host[1].fTerminalAktiv := false
                               ELSE IF sKommand[0]=#0 THEN SendStr(cr)
                               ELSE IF Upcase(sKommand[1])<>'E' THEN
                                        Sendstr(CR+'* '+csINVALIDCOMMAND+f_UPPER(sKommand[1])+' *'+CR);
                               fTermCommand := FALSE;
                               END
                          ELSE BEGIN
                               SendStr(cr);
                               END;
                        sKommand := '';
                        END
   ELSE BEGIN
        AddChar(sKommand,ch);
        CASE ch OF
           #1..#6,#8..#31 : Sendstr('^'+char(ord(ch)+64) );
           #7, #32..#255  : Sendstr(char(ch));
          END;
        END;
  END;
END;

{}


{$F+}
PROCEDURE fnMsgHOST ( pCB : tp_axcb; msg : T_Msg);
  VAR kanalNr : BYTE;
BEGIN
  IF pCB = nil THEN Exit;
  kanalNr := pCB^.divers.bHostKanal;
  IF kanalNr = 0 THEN Exit;
  IF hostChannel[KanalNr].pSelfCB = NiL THEN Exit; {* is wohl nix *}

  CASE msg OF
   msgRx {* in der RxQueue steht (wieder) was gltiges *}
     : BEGIN
       IF hostChannel[kanalnr].nHstDataFrame < 50
         THEN BEGIN {* Einhngen *}
              EnQueue2( hostChannel[Kanalnr].QSORxBuf, pCB^.RxBuf );
              pCB^.RxBufSize := 0; {* pCB^.RxBuf ist schon umgehngt *}
              {* Event_BecomeUnBusy(pCB);}
              hostChannel[Kanalnr].nHstDataFrame := CountQueue(hostChannel[Kanalnr].QSORxBuf);
              TurboEventWennNoetig(kanalNr);
              END
         ELSE Inc( count[cntHostRxOverfl] );
       END;

   msgReconnect,
   msgConnectSuccess    {* Connect Versuch erfolgreich / ReConnected ! *}
     : IF hostChannel[KanalNr].status = connecting
         THEN BEGIN
              AddHstQ (KanalNr, hstCONNECTED );
              hostChannel[KanalNr].status := used;
              END
         ELSE AddHstQ (KanalNr, hstLINKRESETfrom );

   msgDiscReq	{* ein DisconectRequest traf ein *}
     : BEGIN
       CloseHost(pCB, hstDISCONNECTED);
       END;

   msgCBDel
     : CloseHost(pCB, hstLINKFAILURE);

   msgRetryCountExceeded
     : CloseHost(pCB, hstLINKFAILURE);

   msgRxDM	{* DM traf ein *}
     : CloseHost(pCB, hstBUSY);

    ELSE fnMsgDefault( pCB, msg );
  END {* case *};
  {*  IF msg <> msgTX THEN SwitchHostLED;*}
END; {$IFNDEF AllFar} {$F-} {$ENDIF}



FUNCTION HostModeDirektConnect(pCB:tp_axcb;fTestAufFreeChannel:BOOLEAN) : BYTE;
{* Gibt TRUE zurck, wenn ein "externer" Connect hier, und nicht in der
 * InfoBox landen soll. Mit I-Call Vergleich...
 * Gibt die Nr des Kanals zurck oder 0 wenn keiner da *}
  VAR i,SSID : BYTE;
      shMy : T_shCall;
BEGIN
  HostModeDirektConnect := 0;
  {* Suche alle I-Calls ab, ob eins mit ZielCall bereinstimmt *}
  FOR i := 1 TO MAXHOSTKANAL DO
    BEGIN
    {* AscCall2shift( hostchannel[i].sMyCall, shMy ); *}
    shMy := hostchannel[i].shMyCall;
    IF CmpShCallSSID( @shMy,@pCB^.fromcall ) THEN
      BEGIN
      {* Passendes Call gefunden; passt auch der HOST-SSID Bereich? *}
      ssID := FSh2SSID(pCB^.fromcall);
      IF (ssid>=host[1].HostSSIDmin) AND (ssid<=host[1].HostssidMax) THEN
        IF (NOT fTestAufFreeChannel) OR (hostChannel[i].status=free) THEN
           BEGIN
           HostModeDirektConnect := i;
           Exit;
           END;
      END
    END;
END;


FUNCTION OpenHost (pCB : TP_AXCB; fKommtVonDigiWare,
                   fPrintConnectedToHost,fSSIDEgal : BOOLEAN ) : BOOLEAN;
{* Ab jetzt wird pCB vom HOSTMODE behandelt.
 * fKommtVonDigiWare = TRUE: Es war eine ankommende Connectaufforderung
 * fPrintConnectedToHost = TRUE: CONNECTED TO HOST ausgeben
 *}
  VAR sZwisp : STRING;
BEGIN
  OpenHost := FALSE;
  IF (NOT host[1].fHostModeAktiv) OR (SlowTick - host[1].timeLastRxHostModePoll > 8) THEN
    BEGIN
    Tx_EolSysInfo (pCB, SOFORT,
                  UText+EOL
                + 'Host ist vermutlich seit '
                + Sekunden2RelString( (SlowTick-host[1].timeLastRxHostModePoll) DIV 2)
                + ' nicht mehr aktiv'+EOL
                + 'CHAT  eingeben, um es (spaeter) noch einmal zu versuchen'
                 );
    host[1].fHostInAktivTextTxed := true;
    Exit;
    END;

  IF fKommtVonDigiWare THEN
    BEGIN {* Freien Kanal suchen etc. - kam der ConReq VOM Hostmode so ist
           * ein Kanal ja schon zugewiesen *}

    pCB^.divers.bHostKanal := 0;
    IF (GetHstChannelUsed < yCmdMAXHOSTKANAL) THEN
      BEGIN {* Y beschrnkte die Anzahl der passiven Connects nicht *}
      pCB^.divers.bHostKanal := HostModeDirektConnect(pCB,cTESTEAUFFREIENKANAL);
      IF (pCB^.divers.bHostKanal = 0) AND fSSIDEgal THEN pCB^.divers.bHostKanal := GetFreeHstChannel;
      END;

    IF (pCB^.divers.bHostKanal = 0) THEN
      BEGIN {* kein freier Kanal mehr *}
      WITH hostChannel[ 0 {pCB^.divers.bHostkanal}] do
        BEGIN
        sCallAndPath := f_sh2asc(pCB^.tocall);
        IF pCB^.nDigi>0 THEN AddString(sCallAndPath,' via ' + f_digi2str (pCB,1));
        END;
      AddHstQ(0,hstCONREQ); {* "CONNECT REQUEST" an KANAL 0 SENDEN *}
      Tx_EolSysInfo (pCB, SOFORT, 'busy from Host:' + f_sh2Asc(pCB^.fromCall)
                                   {+axiface[ifLoopback].asMyCall});
      Exit;
      END;
    IF fUMode THEN Tx_Info (pCB, SOFORT, EOL+UText+EOL); {* U Befehl *}
    END;

  WITH hostChannel[pCB^.divers.bHostKanal] DO
    BEGIN
    pSelfCB := pCB;
    sCallAndPath := f_sh2asc(pCB^.toCall);
    portnr:=pSelfCB^.iface;

    sZwisp := f_digi2str (pCB,1);
    IF sZwisp <> '' THEN sCallAndPath := sCallAndPath + ' via ' + f_digi2str (pCB,1);
    QSORxBuf := NiL;
    nHstMsgQueue := 0;
    nHstDataFrame := 0;
    pHstMsgRoot := NiL;
    status := connecting; {* u.a. zur Erkennung von Reconnects *}
    IF fPrintConnectedToHost THEN Tx_EolSysInfo (pCB, SOFORT,
                                  'connected to Host:'+ sMyCall + EOL );

    {*SwitchHostLED*};
    END;
  pCB^.QSOType := qtHost;
  pCB^.fMsgHandler := fnMsgHost;

  {* Kontakt mit Hostmode aufnehmen: oeffnen = ConnectSucess *}
  pCB^.fMsgHandler (pCB,msgConnectSuccess);
  OpenHost := TRUE;
END;


PROCEDURE DelHost(kanalNr:BYTE);
  {* Gibt einen benutzten HOST-Kanal wieder frei *}
BEGIN
  WITH hostChannel[KanalNr] DO
    BEGIN
    pSelfCB := NiL;
    sCallAndPath := '';
    nHstMsgQueue := 0;
    nHstDataFrame := 0;
    DelHstQ (KanalNr);
    pHstMsgRoot := NiL;
    status := free;
    END;
  FillChar ( hostChannel[KanalNr], sizeof(hostChannel[1]), #0);
END;


PROCEDURE CloseHost (pCB : TP_AXCB; grund : T_HstStatus );
{* legt pCB wieder auf die InfoBox
 * Achtung ! hostChannel darf noch nicht gelscht werden *}
BEGIN
  AddHstQ (pCB^.divers.bHostKanal, grund );
  hostChannel[pCB^.divers.bHostKanal].status := discing; {* Kennzeichnen, dass der Kanal demnaecht ungltig wird *}
  hostChannel[pCB^.divers.bHostKanal].pSelfCB := NiL; {* Kennzeichnen, dass der Kanal demnaecht ungltig wird *}
  pCB^.divers.bHostKanal := 0;
  pCB^.fMsgHandler := fnMsgDefault; {* Auf jeden Fall *}
  IF (pCB^.pInfoBox <> NiL) {AND NOT pCB^.pInfoBox^.fIntViaConnect}
    THEN BEGIN
         TX_EolSysInfo (pCB, SPAETER, axIFace[1].asMyCall
               +': Disconnect received from HOST:'+axIFace[ifLoopback].asMyCall+EOL
               +'*** reconnected to '+f_sh2asc(pCB^.fromCall)+EOL);
         ReConnected (pCB);
         END
    ELSE DoDisconnectImm(pCB);
END;


FUNCTION PCB2HostChannelStr( pCB:TP_AXCB ) : STRING;
{* Wird von FD_Info gerufen *}
  VAR i : WORD;
      s : STRING;
BEGIN
  PCB2HostChannelStr := '';
  FOR i := 1 TO {yCmd}MAXHOSTKANAL DO WITH hostChannel[i] DO
    IF status <> free THEN
      IF pSelfCB=pCB THEN
        BEGIN
        PCB2HostChannelStr := f_Using(i,2);
        Exit;
        END;
END;



{ROCEDURE HostUserList(pCB:TP_AXCB);}
{* Wird von FD_Info gerufen *}
{ VAR i : WORD; s : STRING;
BEGIN
  TX_Info(pCB, SPAETER, EOL+'Hostmode-List:');
  FOR i := 1 TO {yCmd}{MAXHOSTKANAL DO WITH hostChannel[i] DO
    IF status <> free THEN
      BEGIN
      s := ' Ch.' + f_Using(i,2)
         + ' AX-' + fStr(portnr)
         + '  '   + fStr(nHstMsgQueue)+'/'+fStr(nHstDataFrame)
         + '   '  + sMyCall + ' ('+sCallAndPath+')'
         ;
      TX_Info(pCB, SPAETER, EOL+s);
      END;
END;}




{}

VAR hISR  : T_HCB;

{$F+}
PROCEDURE HostModeHandler;  (*$F-*)
(* Mu regelmssig aufgerufen werden! (oder wenn RX-Zeichen vorliegen *)
  LABEL l_EoP;
  VAR  inbyte : Byte;
       n : WORD;
BEGIN
  IF NOT host[1].fValid THEN Goto l_EoP;
  Inc(hostActRPS,1);
  IF host[1].fTerminalAktiv THEN
    BEGIN
    IF host[1].ProcNRXCHAR>0 THEN TermUserMain(hISR); {* Daten da -> Terminal *}
    Exit;
    End;
  IF NOT host[1].fHostModeAktiv THEN Goto l_EoP;
  WatchDog;

  REPEAT
    n := host[1].ProcNRxChar;
    IF n>0 THEN  {* Daten da *}
      BEGIN
      WITH hISR DO
        BEGIN
        inbyte := byte(host[1].ProcRX1Char);
        CASE Zustand OF
          cWaitChNr : BEGIN (* Kanalnr *)
                      Kanalnr := inByte;
                      Zustand := ComOrData;
                      END;
          ComOrData : BEGIN
                      isInfo := (inByte = 0);
                      zustand := waitLength;
                      END;
         waitLength : BEGIN
                      datalen := inbyte + 1 ;
                      iData := 1;
                      zustand := GetData;
                      END;
         GetData :    BEGIN
                      data[iData] := inByte;
                      Inc(iData);
                      IF iData > dataLen THEN
                        BEGIN
                        Zustand := cWaitChNr;
                        Host_Main(hISR);
                        END;
                      END;
         END; {CASE}
        END; (* WITH  *)
      END;{if}
  UNTIL {$IFDEF userware}
            n = 0;   {* Solange Daten da sind loopen *}
          {$ELSE}
            true;    {* Bei DigiWare nur ein Durchlauf *}
        {$ENDIF}

l_EoP:
{  TaskDelay(10); }
END;


{}

PROCEDURE InitHost;
  VAR i : BYTE;
      sCall : Str15;
BEGIN
  FillChar(hostChannel, sizeof(hostChannel), #0);

  sCall := axiface[1].asMyCall;
  IF NOT ValidCall(sCall) THEN sCall := csNOCALL;
  FOR i := 0 TO MAXHOSTKANAL DO
    BEGIN
    {* hostchannel[i].sMyCall := sCall ; *}
    SetMyCall( i, sCall );
    END;
  hISR.Zustand := cWaitChNr;

  host[1].moniMode.iusc.n  := True;
  host[1].moniMode.iusc.i  := false;
  host[1].moniMode.iusc.u  := false;
  host[1].moniMode.iusc.t  := false;
  host[1].moniMode.iusc.s  := false;
  host[1].moniMode.iusc.c  := false;
  host[1].moniMode.call.pl := false;
  host[1].moniMode.call.mi := false;
  host[1].moniMode.call.nCall := 0;
  FOR i := 1 TO 7 DO
    BEGIN
    host[1].moniMode.afPort[i] := TRUE;
{*} uiPara[i].target:='ALL';
{*} uiPara[i].via:='';
    uiPara[i].fPoll := true;
    END;
  {*SwitchHostLED*};
  Host[1].fValid := true;

  host[1].fTerminalAktiv:= true;
  host[1].fTurbo        := false;
  host[1].fTurboEventAllowed := false;
  sKommand:='';
  hisr.fTermCommand:=false;
  SendStr(cr+lf+Copyright1
         +cr+lf+'Hostchannels: '+fstr(MAXHOSTKANAL)
         +cr+lf);
  hostrps.del:=true;
END;


{---------------------------------------------------------------------}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 ={ 1}  'INIT BIND SSIDMIN SSIDMAX ';
        cmINIT=1; cmBIND=2; cmSSIDMin=3; cmSSIDMAX=4;
        cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   res,x,devNrDn : BYTE;
        sDn : STRING;
        p : Pointer;
        para : Longint;
BEGIN
WITH host[devnr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT    : InitHost;
      cmSSIDMin : HostSSIDMin := para;
      cmSSIDMax : HostSSIDMax := para;
      cmBIND : BEGIN  { z.B. BIND v24 2 }
               ScanForText (sArg, sDn );
               devNrDn := ScanforNum(sArg);
               res := DoBind( csMyName,devnr, sDn, devNrDn );
               hostbindnr := res;
               IF res > 0 THEN
                 BEGIN
                 fHostModeAktiv := true;
                 {* Hole die Routinen *}
                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpRX1CHAR) )
                 );
                 ProcRx1Char :=  TFN_RX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC,  ord(hpNRXCHAR) )
                 );
                 ProcNRXCHAR :=  TFN_NRXCHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpTX1CHAR) )
                 );
                 ProcTx1Char := TFN_TX1CHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpNTXCHAR) )
                 );
                 ProcNTXCHAR :=  TFN_NTXCHAR(p);

                 p := Pointer( Register[bind[res].regNrDn].procSetPara (
                      bind[res].devNrDn, spHOLEPROC, ord(hpLED) )
                 );
                 ProcLED :=  TFN_LED(p);
                 END;
               END;
      END {Case}
  UNTIL x=0;
END;


CONST sReturn : STRING='';
{$F+}
FUNCTION HOST_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR i, loknr : BYTE;
      p : Pointer;
BEGIN
  HOST_SetPara := speOK;
WITH host[devnr] DO
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        IF fTerminalAktiv THEN sReturn := 'Termmode'
                          ELSE sReturn := 'Hostmode';
        sReturn := sReturn
                 +       ' ssid:'+ FStr(HostSSIDMin)
                 +            '-'+ FStr(HostSSIDMax)
                 +      ' polls:'+ fStr(host[1].nXHostPolls)
                 +            '/'+ fStr(host[1].nHostPolls)
                 +   ' lastPoll:'+ Sekunden2RelString(
                    (SlowTick-host[1].timeLastRxHostModePoll) DIV 2)
                                 + ' ago'
                 + EOL_HOLEPARAMSTRING
                 +                 RPSAsString
                 +  ' turboMode:'+ F_Bool2OnOff(host[1].fTurbo)
                 +' turboEvents:'+ fStr(host[1].nTurboEvents)
                 ;
        HOST_SetPara := Longint(@sReturn);
        END;
    spHoleVAL
      : IF wert = ord(hvBINDNR) THEN HOST_SetPara := hostbindNr;
    ELSE {* case *} HOST_SetPara := speNNCMD;
  END;
END;


BEGIN
  FillChar ( hostChannel, sizeof(hostChannel), #0);
  FillChar ( host       , sizeof(host       ), #0);
  DoRegister(csMyName, 1,1, HOST_SetPara);
  DoRegisterPoller(HostModeHandler);
{$ENDIF}
END.
