UNIT FD_Flex;
{$I fd_incl.pas}

{$IFnDEF scc}
  { $DEFINE dbout}
{$ENDIF}

{* Routinen zur Verwaltung der FlexNet-Kompatiblen Routingtabelle, incl.
 * Aufbau und Entgegennahme von FlexNet-RoutingQSOs und Messung der
 * Flexnet-Partner Laufzeiten.
 * Den allerersten Connectversuch bernimmt FD_Link. Ist das erste Info-
 * frame, was vom Partner kommt mit FLEXNET-PID, so wird das QSO als
 * FlexNet-QSO initialisiert. Als erstes wird dabei ein 2er-Frame
 * losgeschickt.
 *}

{$IFNDEF scc}{$O+,F+}{$ENDIF}

INTERFACE

USES fd_def;

PROCEDURE InitFlexRoutingQso (VAR pCB : tp_axcb; Master : BOOLEAN; index : WORD );
PROCEDURE LinkStelle3FramesZusammen ( iLink : BYTE );
                                                {* Master: wenn der Connect von mir ausging *}
 FUNCTION FlexSucheZiel ( VAR shCall : T_ShCall; ssid : BYTE; fSSIDMatch : BOOLEAN ) : Integer;
PROCEDURE DeleteFlexRoutingQso ( pCB : tp_axcb );
PROCEDURE SendTestPacket( pCB : TP_AXCB );
PROCEDURE SetzeNachbarLinkZeit ( iLink : WORD; t : T_LZ );

PROCEDURE ReorgZiele;
PROCEDURE EntryDest ( pCB : TP_AXCB;      {* ber dieses Routing QSO kam der Eintrag (Also Pcb^tocall = Nachbar *}
                      shCall : T_ShCall;  {* Call des einzutragenden *}
                      s_von,s_bis : T_SSID;  {* die SSIDs    *}
                      laufzeit : T_LZ);     {* die Laufzeit *}
PROCEDURE EntryDest2
    ( iLink : WORD; {* ber dieses Link kam der Eintrag (Entweder als direkte LZ-Messung *}
                    {* zum Nachbar (auch DummDigis) oder als 3erMeldung *}
     shCall : T_ShCall;  {* Call,*}
     s_von,
     s_bis  : T_SSID;    {* SSIDs,    *}
     laufzeit : T_LZ );  {* und Laufzeit des Einzutragenden *}


{}

IMPLEMENTATION

USES fd_Subr,
     FD_mBuf,
     fd_Mem,
     fd_Axcb,
     FD_Main,
     fd_Tx,
     fd_Log,
     fd_Timer,
     fd_Beacon,
     fd_Error,
     {$IFDEF SCC} fd_TNC,
     {$ELSE}      fd_crt,
     {$ENDIF}
     fd_Link, {* wg. MAXLINKS *}
     fd_State, {* DoDiscImm    *}
     fd_Div;


CONST LZ_DELAY = 1; {* Damit kann man seinen Knoten virtuell lhmen *}


PROCEDURE ReorgZiele;
  {* Entfernt alle ungltigen Eintrge aus der ZieleTabelle *}
  VAR iUsed,
      iTest : WORD;
BEGIN
  WatchDog;
  iUsed := 1;
  FOR iTest := 1 TO nZiel DO {* ALLES! muss durchsucht werden *}
    BEGIN
    IF paZiel^[iTest].lkUsed <> 0 THEN
      BEGIN {* Dieser Eintrag wird noch gebraucht, also runter kopieren *}
      IF iUsed <> iTest THEN paZiel^[iUsed] := paZiel^[iTest];
      Inc (iUsed); {* invariante: iUsed <= nZiel *}
      END;
    END;
  nZiel := iUsed-1;
END;

{}

FUNCTION DiffProz(a,b : T_LZ) : Longint;
BEGIN
  IF a>b THEN BEGIN
              IF b = 0 THEN diffProz := 250 {* Sollte hinreichend gross sein *}
                       ELSE diffProz := 100*longint(a) DIV b - 100;
              END
         ELSE BEGIN
              IF a = 0 THEN IF b=0 THEN diffProz := 0
                                   ELSE diffProz := 250
                       ELSE diffProz := 100*longint(b) DIV a - 100;
              END;
END;

FUNCTION LZGT(a,b : T_LZ) : BOOLEAN;
  {* Ist Laufzeit a > b ? *}
BEGIN
  IF      a<=0 THEN LZGT := FALSE
  ELSE IF b<=0 THEN LZGT := TRUE
  ELSE              LZGT := a>b;
END;


PROCEDURE LinkStelle3FramesZusammen ( iLink : BYTE );
{* Zum Routenaustausch ber Link "iLink". Wird oft fr *}
{* jeden Link aufgerufen. Ausserdem auch, wenn 3- eintraf.     *}
{* Und bei schlechten Nachrichten.                             *}
  VAR zi    : WORD;
      i, is : BYTE;
      s     : STRING;
      lzCalc: T_LZ;
      tlink : T_Lz;
      fWeiterGeben : BOOLEAN;
BEGIN
IF NOT useTxDest THEN Exit; {* und Tschuess *}
{$IFDEF dbout}Write(' ***Frame3:',ilink,'**'); xx {$ENDIF}
WITH Link[iLink] DO
  BEGIN
  IF (NOT valid) OR
     (NOT lzMessen) OR
     (NOT fLinkTxDest) OR
     (system <> dsFLEXNET) THEN Exit;
  IF pCBRout = NiL THEN Exit; {* ist gar kein RoutingQso *}
  IF pCBRout^.TxBufSize > 2*256 THEN BEGIN
                                     Inc(count[cntFlxBuf]);
                                     Exit; {* Buffer is noch zu voll! *}
                                     END;
  tLink := tSchnitt;
{$IFDEF dbout}Writeln(' ***F3x:',tLink);{$ENDIF}
  s := '';
  FOR zi := 1 TO nZiel DO WITH paZiel^[zi] DO  {* Schleife ber alle Dests *}
    IF (bfChange AND (1 SHL iLink) = 0) AND   {* hat sich gendert *}
       (holdDownFTick<=fastTick) AND            {* holddown is auch vorbei *}
       {* $TODO: SSID muessen verglichen werden!, ansonsten kann man nicht zu MYCALL mit anderen SSID Linken *}
       (link[ilink].call <> paZiel^[zi].call) THEN {* Linkpartner darf sich nicht selber gemeldet werden *}
                                            {* knnte aber passieren, wenn Umwege schneller sind. DG6MAY sei dank! *}
      BEGIN {* Updatekandidat *}
      fWeitergeben := FALSE; lzCalc := 0;
      IF lz[iLink] < 0 THEN
        BEGIN {* UpStreamer: Linkzeit neu berechnen und gucken, ob update notwendig ist *}
        IF lkUsed > 0 THEN  lzCalc := (9*(lz[lkUsed]+tlink)) DIV 8 + 1;
        IF (lzCalc=0) OR   {* Das wuerde heissen, dass der DS weg ist - ohne Alternativen -> Hilfe schreien *}
           (DiffProz( lzCalc, abs(lz[iLink])) > 10)
          THEN fWeitergeben := True
          ELSE bfChange := bfChange OR (1 SHL iLink); {* erledigt *}
        END;
      IF lz[iLink] = 0 THEN IF lkUsed > 0 THEN
        BEGIN {* Neu-UpStreamer oder gestorbener SubOptim: Linkzeit neu berechnen *}
        lzCalc := (9*(lz[lkUsed]+tlink)) DIV 8 + 1;
        fWeitergeben := (lzCalc<3000); {* Chg.sorgte dafuer dass kein Unsinn entsteht *}
        END;
      IF lz[iLink] > 0 THEN
        BEGIN {* DownStream/Suboptimaler darf nie was kriegen, es sei denn, wir haben wesentlich besseren downstream *}
        IF lkUsed<>0 THEN        {* Vergleichswert fr Subopt *}
          IF lkUsed<>iLink THEN lzCalc := (9*(lz[lkUsed]+tlink)) DIV 8 + 1;
        IF (lzCalc<>0) AND
           (lzCalc<abs(lz[iLink])) AND
           (DiffProz( lzCalc, abs(lz[iLink])) > 25)
          THEN BEGIN {* Suboptimaler Weg iLink wird zum Upstream *}
               fWeitergeben := True;
               END
          ELSE bfChange := bfChange OR (1 SHL iLink); {* erledigt *}
        END;

      IF fWeitergeben THEN
        BEGIN {* Jetzt wollen wir wirklich was senden *}
        {* Test auf Tokenstatus, ggf. anfordern *}
        IF TokenStat = TOK_ER THEN
          BEGIN {* Der Partner hat den Token! *}
          TX_InfoOneFrame ( link[iLink].pCBRout, SOFORT, '3+'+EOL); {* Haben wollen! *}
          TokenStat := TOK_ICH_REQ; {* BTW: Verkrzen ist hier nicht mglich *}
          END;
        IF (TokenStat = TOK_ICH_REQ) OR (TokenStat = TOK_ER) THEN Exit; {* Wir haben das Token (noch) nicht *}
        IF length(s) > 215 THEN
          BEGIN {* ...und raus mit dem vollen Frame *}
          TX_InfoOneFrame (pCBRout,SOFORT,'3'+s+EOL);
          s := '';
          END;
        {* Call in lokalen Frame-Puffer kopieren *}
        is := length(s)+1;
        FOR i := 1 TO 6 DO
          BEGIN
          byte(s[is]) := byte(paZiel^[zi].call[i]) DIV 2; {* dabei in ASCII umwandeln *}
          Inc (is);
          END;
        Byte (s[0]) := is-1;

        {* Sind Linkzeiten ZU mies, werden sie zwar gespeichert, aber als 0 ausgegeben - BayCom m8 das auch so *}
        lzCalc := Abs(lzCalc); {* err-hack *}
        IF lzCalc > 3000 THEN lzCalc := 0;  {* Obergrenze: Zu schlecht! *}
        {* 31.8.93 kw  ^^^vvvv vertauscht! *}
        lz[iLink] := -lzCalc; {* wir haben das gesendet -> nu isser upstream *}

        {* Der SSID-Bereich, die Zeit und das Blank *}
        s := s + char($30+ssid_von)
               + char($30+ssid_bis)
               + fStr(lzCalc) + ' ';
        bfChange := bfChange OR (1 SHL iLink); {* Ist gendert worden *}
        END; {* Weitergeben *}
      END {* for/if ber alle Dests *};

  IF TokenStat = TOK_ER_REQ THEN
    BEGIN
    s := s + '-'; {* jetzt kriegt ers *}
    TokenStat := TOK_ER;
    END;
  IF s<> '' THEN
    BEGIN {* und raus mit dem Rest *}
    TX_InfoOneFrame (pCBRout,SOFORT,'3'+s+EOL);
    END;
   END;
END;


PROCEDURE SucheOpt ( iZiel, iLink : WORD );
  {* Whle fr paZiel^[iZiel] neues Optimum aus - Und auch andere Sachen *}
  {* werden gemacht. Dazu braucht man auch den Initiator iLink        *}
VAR zMin : T_LZ;
    i, neuIBest : WORD;
BEGIN
{$IFDEF dbout} Writeln('**SucheOpt d',iZiel); {$ENDIF}
WITH paZiel^[iZiel] DO
  BEGIN
  neuIBest := 0; zMin := MaxInt;
  FOR i := 1 TO maxFLEXNBAR DO IF lz[i] > 0 THEN
    BEGIN
    IF lz[i] < zMin THEN
      BEGIN
      zMin := lz[i];
      neuIBest := i;
      END;
    END;

  IF neuIBest = 0 THEN
    BEGIN {* Kein Weg mehr bekannt - An alle 0 melden! (Das erledigt 3er-Sender) *}
    lkUsed := 0;
    bfChange := 0; {* Alle sind nderungskanidaten! *}
    holdDownFTick := fastTick; {* Schlechte Nachricht *}
    {* Vorgang: Dieses Dest hat nun nur noch (wenn berhaupt) neg.LZ. Daher *}
    {* ist LKUSED=0. Das wird in S3erFrame dann automatisch beachtet, so    *}
    {* da 0 ausgesendet und gespeichert wird. *}
{stelle3erzusammen anwerfen?}
    Exit;
    END;

  IF (lkUsed=0) {* Implizit: AND (neuibest <>0) *} THEN
    BEGIN {* Vorher war kein Weg bekannt - jetzt schon! *}
    lkUsed := neuIBest; {* Der neue Weg! *}
    bfChange := 0; {* Alle sind nderungskanidaten! *}
    holdDownFTick := fastTick+10*lz[lkUsed]; {* Gute Nachricht *}
    Exit;
    END;

  {* also kann man % Vergleiche machen *}
  IF (NeuIBest <> lkUsed) THEN {* Ein neuer Bester ist gefunden *}
    IF DiffProz(lz[neuIBest],lz[lkused]) > 25 THEN {* nderung hinreichend gross *}
      BEGIN {* RoutenWechsel *}
      bfChange := 0; {* Alle sind nderungskanidaten! *}
      IF lzgt( lz[neuIBest], lz[lkused] )
        THEN holdDownFTick := fastTick {* schlechte Nachricht *}
        ELSE holdDownFTick := fastTick+10*lz[NeuIBest]; {* Gute Nachricht *}
      lkUsed := neuIBest; {* Der neue Weg! *}
      Exit;
      END;

  IF iLink=lkUsed THEN {* Der DownStream hat sich entscheidend gendert *}
    BEGIN
    bfChange := 0; {* Alle knnten sich gendert haben *}
    holdDownFTick := fastTick+10*lz[lkUsed]; {* Gute Nachricht *}
    Exit;
    END;

  IF (lz[iLink] = 0) AND (lkUsed <>0) THEN
    BEGIN {* Ein Suboptimaler ist tot - wir haben fr ihn eine Alternative! *}
    bfChange := bfChange AND NOT (1 SHL iLink); {* nur der! *}
    holdDownFTick := fastTick+10*lz[lkUsed]; {* Gute Nachricht *}
    Exit;
    END;

  END;{With}
END;{Proc}



{}

FUNCTION FlexSucheZiel ( VAR shCall : T_ShCall; ssid : BYTE; fSSIDMatch : BOOLEAN ) : Integer;
 {* Suche "shCall" in der Zieltabelle. RETURN Index der Tabelle, wenn        *}
 {* gefunden, ansonsten der Index mal -1 des alphabetisch folgenden Eintrag. *}
 {* Wenn fSSIDMatch, dann mu SSID genau mit der Lower-Ziel SSID   *}
 {* uebereinstimmen, ansonsten muss es nur im SSID-Bereich liegen. *}
 {* Existieren zwei Eintrge fr dasselbe Ziel, aber mit unterschiedlichen *}
 {* SSID, so wird IMMER das Ziel mit der "am besten" passenden SSID *}
 {* ausgewhlt (s. wSubOptimal) *}
 {* ACHTUNG: In der Liste sind auch Ziele mit Wert=0 ! (wg. Opt.)  *}
  VAR zi,
      wSubOptimal : WORD;
      ende : BOOLEAN;
      ret  : ShortInt;
BEGIN
  ende := FALSE; zi := 0; ret := 1; wSubOptimal := 0;
  WHILE (zi<nZiel) AND (ret = 1) DO  {* Suche solange Werte grer sind als in der Tabelle *}
    BEGIN {* $OPT: Binres Suchen, da Liste ja sortiert *}
    Inc (zi);
    ret := MemCmp ( @shCall, @paZiel^[zi].call, 6);
    {* wenn Call stimmt, aber SSID nicht, so muss weitergesucht werden *}
    IF ret = 0 THEN {* Call stimmt, wenn jetzt noch die SSID stimmen wuerde... *}
      IF paZiel^[zi].ssid_von <> SSID THEN {* SSID stimmt nicht genau... hmmm *}
        BEGIN
        ret := 1; {* Meistens muss hier weitergesucht werden *}
        IF fSSIDMatch
          THEN IF (paZiel^[zi].ssid_von < SSID)
                 THEN {* Gefundene SSID zu klein, weitersuchen *}
                 ELSE ret := -1 {* zu weit gesucht, abbrechen *}
          ELSE BEGIN {* NOT fSsidMatch *}
               {* weitersuchen, vielleicht gibt es noch einen besseren... *}
               IF (paZiel^[zi].ssid_von <= SSID) AND (SSID <= paZiel^[zi].ssid_bis)
                 THEN wSubOptimal:= zi; {* Sie liegt schon mal im interessanten Bereich, also schon ma zwischenspeichern... *}
               END;
        END;
    END;
  IF NOT fSSIDMatch AND (ret<>0) AND (wSubOptimal<>0) THEN
    BEGIN {* zweitbeste Lsung verwenden *}
    zi := wSubOptimal;
    ret := 0;
    END;

  CASE ret OF
     0 : FlexSucheZiel :=  zi;     {* gefunden *}
    -1 : FlexSucheZiel := -zi;     {* nicht gefunden *}
     1 : FlexSucheZiel := -nZiel-1 ; {* nicht gefunden: grer als der grte, *}
                                     {* also auch die groestmoeglichste Nummer zurueckgeben *}
   END;
END;

{}

PROCEDURE EntryDest2
    ( iLink : WORD; {* ber dieses Link kam der Eintrag (Entweder als direkte LZ-Messung *}
                    {* zum Nachbar (auch DummDigis) oder als 3erMeldung *}
     shCall : T_ShCall;  {* Call,*}
     s_von,
     s_bis  : T_SSID;    {* SSIDs,    *}
     laufzeit : T_LZ );  {* und Laufzeit des Einzutragenden *}

 {* Eintragen eines DEST in die Routingtable. Auch neue oder zu lschende Dest *}
 VAR iZiel : INTEGER;
     err   : BOOLEAN;
 VAR LZvorher : T_LZ;
BEGIN {* Zunchst Tausend bunte Plausis *}
{$IFDEF dbout} WriteLn('ED2:',f_sh2asc(shCall),laufzeit:5); {$ENDIF}

  IF (laufzeit<0) THEN Exit; {* negative Laufzeiten werden nur intern verwendet *}
  Watchdog; {* ist nie falsch *}
  StripShSSID(shCall); {* SSID wird nicht im Call gespeichert *}
  IF NOT ValidShCall(shCall) THEN Exit; {* mhhh, kein Call das *}
  IF iLink > maxFLEXNBAR THEN Exit; {* Auch fatal *}

  {* Sucht shCall in der ZielTabelle, kehrt mit Index, null oder negativZahl zurck *}
  iZiel := FlexSucheZiel ( shCall, s_von, TRUE ); {* TRUE=SSID s_von muss genau stimmen *}
  {* -nZiel-1 <= iZiel <= nZiel *}
  IF iZiel <= 0
    THEN BEGIN  {* Ziel nicht gefunden --> Neues Ziel erzeugen *}
         {* Ein Ziel mit LZ 0 braucht nicht neu erzeugt werden. Auch muessen keine Infos an die Nachbarn upgedatet werden *}
         IF (laufzeit=0) THEN Exit;
  {* -nZiel-1 <= iZiel <= 0 *}
         IF (nZiel+1 >= maxZiel) THEN {* Fatal: kein Platz mehr frei, Reorganisieren *}
           BEGIN
           Inc(count[cntDestAutoReorg]);
           ReorgZiele;
           IF (nZiel+1 >= maxZiel)
             THEN Exit;
             {* $TODO: Immer noch kein Platz frei: Groesste Laufzeit
              * suchen + entfernen & Choken indem die Wegschmeissgrenze sinkt *}

           {* Da sich durch Reorg die Indizes der Tabelle gendert haben, mu man jetzt iZiel nochmal neu bestimmt werden}
           iZiel := FlexSucheZiel ( shCall, s_von, TRUE ); {* 19.2.94 *}
           {iZiel ist hier wieder <=0, denn es hat sich ja sonst nix gendert in der DestTablle *}
           END;
         {* Platz freischieben *}
         Inc(nZiel);
      {* -nZiel <= iZiel <= 0 *}
         {* iZiel ist hier noch <= 0 *}
         iZiel := -iZiel;  {* iZiel ist nun >= 0 *}
      {* nZiel >= iZiel >= 0 *}
         IF iZiel <= 0 THEN iZiel:=1; {* Sonderfall: Neuer Platz ist ganz am Anfang *}
      {* nZiel >= iZiel >= 1 *}
         {* $TODO hier knallt es manchmal: immer noch 11.11.93 (KAMELLE!) *}
         IF nZiel<iZiel
           THEN BEGIN {19.2.94 DB0ME 354 400   bei 399 vorhandenen Zielen}
                LogAddEntry ( NiL, leAutoComment, 'FlxMove fail:'+FStr(nZiel)+' '+FStr(iZiel) );
                Exit;
                END
           ELSE Move( paZiel^[iZiel], paZiel^[iZiel+1], (nZiel-iZiel)*sizeof(paZiel^[1]) );

         WITH paZiel^[iZiel] DO
           BEGIN {* Initial-Werte eintragen *}
           call := shCall;
           SSID_von := s_von;
           SSID_bis := s_bis;
           FillChar( lz, sizeof(paZiel^[1].lz), #0 );
           lkUsed := 0; {* Noch kein bester gefunden *}
           {* sSymbName :=''; *}
           bfChange := 0; {* Bei allen testen *}
           holdDownFTick := 10*longint(laufzeit)+Fasttick; {* gute Nachricht *}
           END;
         END
    ELSE BEGIN {* Ziel bestand schon *}
         IF  paZiel^[iZiel].SSID_bis <> s_bis THEN
           BEGIN {* bis-SSID hat sich gendert *}
           paZiel^[iZiel].SSID_bis := s_bis;
           {* Diese Info muss auf jedenfall weitergegeben werden: *}
           paZiel^[iZiel].lkused := 0 {* so tun als wenn er neu waer *}
           END;
         END;

   {* iZiel zeigt hier immer auf den Ziel Eintrag,  *}
{$IFDEF dbout}Writeln('SetzeDst: d',iZiel,iLink:3,laufzeit:5);{$ENDIF}

  lzVorher := paZiel^[iZiel].lz[iLink];
  IF (laufzeit = 0) AND (lzVorher = 0) THEN Exit; {* War und ist nicht zu erreichen; Also was solls? *}
  paZiel^[iZiel].lz[iLink] := laufzeit;
  SucheOpt (iZiel, iLink);
  {* das wars schon....*}
END; {* EntryDest2 *}


PROCEDURE EntryDest ( pCB    : TP_AXCB;   {* ber dieses Routing QSO kam der Eintrag (Also pCB^.ToCall = Nachbar) *}
                      shCall : T_ShCall;  {* Call,*}
                      s_von,
                      s_bis  : T_SSID;    {* SSIDs,    *}
                      laufzeit : T_LZ );  {* und Laufzeit des Einzutragenden *}
 {* Eintragen eines DEST in die Routingtable. Auch neue oder zu lschende Dest *}
 VAR iZiel : INTEGER;
     iLink   : WORD;
     err   : BOOLEAN;
BEGIN {* "Tausend bunte Plausis, die gibt es berall zu sehen, *}
      {*  manchmal mu man denken, um sie zu verstehen.... DER. DIE. DAS...." *}
{$IFDEF dbout} WriteLn('ED:',f_sh2asc(shCall),laufzeit:5); {$ENDIF}
  IF laufzeit < 0 THEN Exit; {* negative Laufzeiten werden nur intern verwendet *}
  Watchdog; {* ist nie falsch *}
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
  iLink := pCB^.Divers.pLink^.id; {* Ist auf jeden Fall handlicher *}
  {* $OPT  pLink := @Link[iLink] *}
  IF pCB^.Divers.pLink <> @link[iLink] THEN
    BEGIN
    StoreStack('L',f_sh2Asc(pCB^.toCall)+' '+f_sh2Asc(shCall));
    Exit; {* FATAL!!! *}
    END;
  EntryDest2 ( iLink, shCall, s_von,s_bis,laufzeit );
END; {* EntryDest *}



PROCEDURE SetzeNachbarLinkZeit ( iLink  : WORD; t : T_LZ );
  {* Hierber werden IMMER alle nderungen aller LinkMessZeiten gemeldet *}
  {* ndere ALLE Routen BER Link[iLink] hinsichtlich ZIEL *}
  VAR iZiel, maske : WORD;
      i : INTEGER;
BEGIN
{$IFDEF dbout}Writeln('NbZeit: l',iLink, '  t',t);{$ENDIF}
WITH link[iLink] DO
 BEGIN
 IF (iLink < 1) OR (iLink > maxFlexNBAR) THEN Exit;
 IF t>3000 THEN t:=0; {* zu Schlecht ist zu schlecht *}

 {* In Dest.Tbl. eintragen *}
 i := FlexSucheZiel ( call, ssid_von, TRUE); {* $OPT: in EntryDest wird auch nochmal gesucht :( *}
 {* Wenn gefunden, testen, ob nderung hinreichend ist: *}
 IF i>0 THEN
   BEGIN
   IF DiffProz(t, abs(paZiel^[i].lz[iLink])) < 10 THEN Exit;
   END;
 {* Wenn nicht gefunden, so muss auf jeden Fall eingetragen werden *}
 EntryDest2 ( iLink, call, ssid_von, ssid_bis, t ); {* Damit werden auch Dumm-Nachbarn wie normale DESTs behandelt *}

 IF system = dsFLEXNET
   THEN BEGIN
        maske := NOT (1 SHL iLink);
        FOR iZiel := 1 TO nZiel DO With paZiel^[iZiel] DO
          BEGIN
          IF t=0
            THEN BEGIN {* Upstream kann die nderung nicht mehr melden... *}
                 lz[iLink] := 0;
                 SucheOpt(iZiel,iLink); {* evtl. Neuer muss gesucht werden *}
                 END
            ELSE IF lz[iLink] <= 0 THEN
                   {* <0: Ziel d wurde schon mal an diesen NB gemeldet --> ggf. updaten *}
                   {* =0: Ziel d wurde noch nicht an diesen NB gemeldet --> immer updaten *}
                   {* Fr alle anderen Flle ist der dem Ziel nhere Linkpartner zustndig *}
                   IF lkUsed <> 0 THEN {* Muss brauchbares Ziel sein *}
                     BEGIN
                     bfChange := bfChange AND Maske;
                     holdDownFTick := fastTick+10*lz[iLink]
                     END;
          END;
        END;
 END; {with}
END;


{}


PROCEDURE RxEntry (pCB : TP_AXCB; p : POINTER; len : Integer );
  {* Updaten der InfoTabelle nach Erhalt eines 3er Frames. P zeigt auf
   * das erste Zeichen nach der 3, und LEN enthlt die Lnge der Info.
   * Format: [CCCCCCLHTTTT<Blank>][+|-]
   *                      ^oder nonZiffer-nonBlank
   *   C  Call, stets 6stellig (wird mit Blanks aufgefllt)
   *   L  untere SSID-Grenze (0..?)
   *   H  obere SSID-Grenze  (0..?)
   *   TTTT  Zeit (Dezimal) in 1/10-sec Intervallen
   * Zwischen TTTT und dem BLANK knnen in zuknftigen Versionen weitere
   * Infos folgen!
   *}
 VAR Call : STRING;
     shCall : T_shCall;
     h : T_LZ;
     s_von, s_bis : BYTE;
     err    : BOOLEAN;
BEGIN
  WHILE len>=7 DO
    BEGIN
    Watchdog; {* ist nie falsch *}
    err := FALSE;
    {* "DB0IE 0?928 DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
    Move ( p^, Call[1], 6 ); call[0]:=#6;
    AscCall2shift ( call, shCall);
    Inc (word(p),6);
    {* "0?928 DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
    IF (Byte(p^) >= byte ('0')) AND
       (Byte(p^) <= byte ('0')+15) THEN s_von := Byte (p^)-byte ('0')
                                   ELSE err := TRUE;
    Inc (word(p),1);
    {* "?928 DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
    IF (Byte(p^) >= byte ('0')) AND
       (Byte(p^) <= byte ('0')+15) THEN s_bis := Byte (p^)-byte ('0')
                                   ELSE err := TRUE;
    Inc (word (p)); Dec ( len, 8 );

    {* "928K1A DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
    {* "928 DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
    IF NOT Err THEN
      BEGIN  {* Laufzeit *}
      h := 0;
      WHILE (Char(p^) IN ['0'..'9']) AND (len>0) DO
        BEGIN
        h := 10*h + byte(p^)-byte('0');
        Inc (word (p));
        Dec( len );
        END;

      {* und nun nchstes Leerzeichen suchen (Nach der Laufzeit mu nicht sofort das Blank kommen) *}
      {* "K1A DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
      {* " DB0KT 07573 DB0LX 77482 DB0ODW07725 DB0SAA071362" *}
      WHILE (Char(p^) <>' ') AND (len>0) DO
        BEGIN
        Inc (word (p));
        Dec( len );
        END;
      IF len>0 THEN BEGIN {* und Leerzeichen berlesen *}
                    Inc (word (p));
                    Dec( len );
                    END;
      END;

    IF NOT Err THEN EntryDest ( pCB, shCall, s_von,s_bis, h ); {* und eintragen *}
    END; {WHILE len >=7}

  IF len > 0 THEN
    BEGIN {* Untersuche 3er Token *}
    {* In einem 3er Kommando erfolgt auch die Tokenbergabe. Dabei wird dem *}
    {* Routingframe ein durch ein Blank abgetrenntes - nachgestellt. Danach *}
    {* folgen keine Routen mehr.                                            *}
    {* Es gibt auch 3er Frames in denen das - alleine steht. Fr das + gibt *}
    {* es eh' keine andere Mglichkeit als ein "3+<CR>"-Frame. Auf jeden    *}
    {* Fall ist hinter einem + oder - evtl.noch ein CR und dann ist das     *}
    {* Frame zuende *}
    IF char (p^) = '+'
      THEN BEGIN {* Gegenstation fordert Token an *}
           pCB^.Divers.pLink^.TokenStat:=TOK_ER_REQ;
           {* Schnell noch mal durchgugen: *}
           IF useTxDest AND (pCB^.Divers.pLink^.fLinkTxDest)
             THEN LinkStelle3FramesZusammen ( pCB^.Divers.pLink^.id ) {* Der bergibt dann auch das Token *}
             ELSE BEGIN  {* Immer geben - denn an den senden wir keine DESTS *}
                  TX_InfoOneFrame (pCB,SOFORT,'3-'+EOL);
                  pCB^.Divers.pLink^.TokenStat := TOK_ER;
                  END;
           END
      ELSE IF char (p^) = '-' THEN
           BEGIN {* Gegenstation bergibt uns das Token *}
           pCB^.Divers.pLink^.TokenStat:= TOK_ICH;
           {* Und auf diesem Flexlink losnudeln: *}
           LinkStelle3FramesZusammen ( pCB^.Divers.pLink^.id );
           END;
    END;
END;


FUNCTION GetResetTokenStatus( pCB:TP_AXCB ) : T_TokenStat;
  {* Wer hat dat Token nachm Reset? Ich oder Er? Oder Frau Doerie? Nein! Der, *}
  {* der in der lexografischen Ordnung niedriger ist (DB0AAA hat es gut...) *}
BEGIN        {meincall}          {* partner*}
  IF MemGE (@pCB^.fromCall, @pCB^.toCall, 7)
    THEN GetResetTokenStatus := TOK_ER
    ELSE GetResetTokenStatus := TOK_ICH;
END;


PROCEDURE SendTestPacket( pCB : TP_AXCB );
  {* Hiermit wird ein Testpaket von insgesamt 240 Byte                 *}
  {* losgeschickt, in dem auch IDs bertragen werden knnten (BayCom!) *}
  VAR s : string;
BEGIN
WatchDog;
WITH pCB^.Divers.pLink^ DO
  BEGIN
  lastLZat := SlowTick;
  IF startZeit = 0 THEN
    BEGIN  {* nur wenn Messung nicht schon luft! *}
    {*  Eigens BayCom-Ident weitergeben *}
    s := f_sh2ascUsing(pCB^.fromCall,false,6)+Char(fsh2SSID(pCB^.fromCall)+48)+
         '='+f_Upper(MYBAYCOMIDENT);
    startZeit := FastTick;
    WatchDog;
    Tx_InfoOneFrame (pCB,SOFORT,'2'+s+f_RepChar (240-length(s),' ')+CR);  {* Kein Problem, wenn Paclen < 240.... *}
    StartTimer(pCB^.tTimeOut);
    END;
  END;
END;


{PROCEDURE FilterHack(VAR s : String);
BEGIN
  WHILE DelWord( ' db0me-11', s) DO;
  WHILE DelWord( ' db0me-12', s) DO;
END;}


PROCEDURE DoFlexRx ( pCB : TP_AXCB; pm : TP_MBUF );
  {* Fr das FlexNet-QSO auf pCB ist grade ein Frame PM^ angekommem *}
  LABEL l_7erLoop;
  VAR p     : POINTER;
      linknr,
      qsonr : WORD;
      lz    : t_lz;
      firstOcc,
      i,i2     : BYTE;
      fTrace : BOOLEAN;
      sMyCall,sZwisp, sZiel, sTuRein,
      sFehler, sTrace, s, s2 : STRING;
      shZiel: T_ShCall;
      zielSSID : T_SSID;
      pCBZiel : TP_AXCB;
      zi : integer;
BEGIN
  StopTimer(pCB^.tTimeOut);
  p := pm^.pData; {* die Lnge von pm^.inuse muss noch kontrolliert werden ! *}
  {* p zeigt ab jetzt immer auf das nachste zu interpretierende Zeichen *}
  CASE char (p^) OF

    '0' : BEGIN {* L3-Reset angekommen. UNSER "0" ist hier schon abgeschickt *}
{****Move (p^,  pCB^.Divers.pLink^.RxInit, sizeof(link[1].rxinit) );***}
          Inc(word(p));
          {* Oberes SSID der Link Tabelle kontrolliern + korrigieren: *}
          IF (byte(p^) <= 15+byte('0')) AND (byte(p^) >= byte('0'))
            THEN pCB^.Divers.pLink^.ssid_bis := byte(p^)-byte('0');
          {* so, der andere kann also FlexNet: *}
          pCB^.Divers.pLink^.system := dsFlexNet;
          {* Ab hier auswerten: Softwarekennung, *}
          Inc(word(p));
          CASE byte(p^) AND 7 OF
            $00 : pCB^.Divers.pLink^.art := daFlexNet;
            $01 : pCB^.Divers.pLink^.art := daBayCom;
            $02 : pCB^.Divers.pLink^.art := daDigiWare;
            $03 : pCB^.Divers.pLink^.art := daTNN;
            $04 : pCB^.Divers.pLink^.art := daSNet;
            ELSE  pCB^.Divers.pLink^.art := daANDERE;
            END; {*case*}
          {* Interne Verionsnr.,es sind nur druckbare Werte ($20 .. $7F) *}
          Inc(word(p));
          {* Nochmal! *}
          pCB^.Divers.pLink^.TokenStat := GetResetTokenStatus(pCB);
          {* Eigene Messung starten: *}
          SendTestPacket(pCB);
          END;

    '1' : BEGIN {* Das ist die Beantwortung meines 2er Testpakets *}
          Inc (word (p)); {* zeigt jetzt auf das Zeichen nach "1" *}
          WITH pCB^.Divers.pLink^ DO IF startZeit > 0 THEN
            BEGIN
            tOur := (FastTick-startZeit) DIV 10;
            IF tOur < 1 then tOur := 1;
            startZeit := 0;   {* Diese Messung ist jetzt beendet *}
            lz := 0;
            WHILE (Char(p^) IN ['0'..'9']) AND (lz<100000) DO
              BEGIN
              lz := 10*lz+(byte(p^)-byte('0'));
              Inc (word (p));
              END;
            {* IF lz=0 THEN SendTestPacket();  $TODO  *}
            IF lz=0 THEN tThem := tOur
                    ELSE tThem := lz;
            SetAndCalcLZ (pCB, tOur, cNEU); {* tOur + TLZ[..] --> tSchnitt *}
            tOur := tSchnitt;
            tSchnitt := (tOur+tThem) DIV 2; {* Flex-Schnitt wird anders *}
                                            {* berechnet, als bei dummen *}
            {* Damit der Nachbar auch selber in der Dest-Liste auftaucht: *}
            SetzeNachbarLinkZeit ( id, tSchnitt );
            {* Zeitpunkt nchste Messung festlegen *}
            IF      lz < 100 THEN sekBisMess := 0
            ELSE IF lz < 1000 THEN sekBisMess := (50 + lz DIV 3 ) {*Mindestens eine Minute *}
            ELSE sekBisMess := sekInit; {* Maximale Messrate *}
            END;
          END;

    '2' : BEGIN {* Der Partner schickte Testpaket, ich antworte mit meiner Laufzeit (1) *}
          WITH pCB^.Divers.pLink^ DO
            BEGIN
            TX_InfoOneFrame (pCB,SOFORT, '1'+FStr(tOur)+CR);
            {* Frher war hier eine Erkennung von BayCom via dessen Name-Routing drin. *}
            {* Das kann DigiWare aber auch; auerdem sollte dies ja beim L3-Reset erkannt werden. also lassen wir das nun! *}
            END;
          END;

    '3' : BEGIN  {* Routinginfo / Tokenbergabe *}
          {* "3DB0LX 77690 HB9KNB051477 HB9P  071379 HB9PD <=1539 -<CR> *}
          {* "3+"CR *}
          Inc (word (p)); {* zeigt jetzt auf das Zeichen nach "3" *}
          RxEntry ( pCB, p, pm^.inUse-1 );{* Updaten der InfoTabelle *}
          END;

    '4' : BEGIN {* 4xxxx sagt dem Nachbarn die maximal erlaubte
                 * Ziel-Laufzeit fuer Updates d.h. wenns kleiner wird
                 * musste groessere Zeiele austragen
                 * 4xxxx! bedeutet dass der Absender schon was verschusselt
                 * hat, dann sollten alle Ziele neu gemeldet werden
                 *}

          END;

    {* 4 und 5 gibbet nich *}

    '6' : BEGIN
          Inc(Count[cnt6ERPAKETE]);
          {* Routentest weiterleiten Format: 6HQQQQQSSSSSS XXXXXX DDDDDD
             *   H TTL-Zhler. Beginnt bei ! (ASCII $21) und zhlt hinauf !"#$%&/()
             *   Q QSO-Nummer (ist erstes Zeichen davon = ` (96dez) / ODER entsprechendes Bit gesetzt
             *                so wird zustzlich ein 7er Frame zurck erzeugt (3.3d)
             *   S Source-Digi
             *   X Digipeater ....
             *   D Ziel-Digi *}
          Inc (word (p)); {* zeigt jetzt auf H *}
          IF byte(p^) < 32+20 THEN {* Hopcounter - berlauf $TODO (Log eintragen) *}
            BEGIN
            {* String schon mal soweit kopieren *}
            sMyCall := f_sh2Asc(pCB^.fromcall);
            byte(s[0]) := Min(255,pm^.inuse);
            Move(pm^.pData^, s[1], pm^.inuse);
            IF routBeaconPort <> 0 THEN TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'I'+s+Eol, cMELD);
            {6" 1542DB0END DB0WST db0me-11 DB0ME DB0EAM}
            Inc(byte(s[2])); {* Hopcounter hoch *}
            {6# 1542DB0END DB0WST db0me-11 DB0ME DB0EAM}
            fTrace := s[3] = #$60; {" TraceRouting "}
            i := 0; s2 := s; firstOcc:=0;
            REPEAT {* MYCALL suchen; knnte ja mehrfach drin sein!!!-> letztes Suchen *}
              i2 :=i;
              i := Pos(sMyCall+' ', s2);
              IF (firstOcc=0) AND (i<>0) THEN firstOcc := i;
              s2[i] := #0; {* Hack, String wird so verndert, dass erkennung des grade erkannten unmglich ist *}
            UNTIL i=0;
            i:= i2;
            IF i = 0 THEN Exit;  {* MyCall ist gar nicht drin! *}
            sFehler := '';
            sZwisp := Copy(s,i,255);
            sZiel := sZwisp;
            {DB0ME DB0EAM}
            ScanForText ( sZwisp, sZiel );
            {DB0EAM}
            ScanForText  (sZwisp, sZiel );
            IF pm^.inUse >240
              THEN sFehler := '>>>' {* zulang *}
              ELSE IF i<>firstOcc THEN
                   BEGIN {* Schleife ala DB0WST DB0ME DB0END DB0ME DB0DA *}
                   sFehler := '?Loop?' {* Schleife *}
                   END
              ELSE BEGIN
                   AscCall2shift (sZiel,shZiel);
                   zielSSID := ( byte(shZiel[7]) AND 30 ) SHR 1;
                   zi := FlexSucheZiel ( shZiel, zielSSID, FALSE);
                   IF zi <= 0 THEN sFehler := '???'
                     ELSE BEGIN {* Ziel ist bekannt *}
                     {* Stelle nun den Weg zusammen *}
                     linkNr := paZiel^[zi].lkUsed;  {* NachbarIndex (Link) *}
                     IF LinkNr <= 0
                       THEN sFehler := '??' {* es gibt keine Route (mehr) *}
                       ELSE BEGIN
                            IF CmpShCall(link[linkNr].call,shZiel)
                               AND (link[linkNr].ssid_von <= zielSSID)
                               AND (link[linkNr].ssid_bis >= zielSSID)
                              THEN BEGIN {* Ziel = LinkPartner -> Frame reflektieren *}
                                   sTuRein := LinkPort2Via ( linknr , cTOKEN6Rx );
                                   {* Sonderbehandlung ntig, damit SSID mit reinkommt *}
                                   s := Copy(s,1,i-1)+sMyCall+' '+sTuRein+' '+sZiel;
                                   s[1] := '7';
                                   {FilterHack(s);}
                                   Tx_InfoOneFrame(pCB,Sofort,s); {* und zurck *}
                                   IF routBeaconPort <> 0 THEN
					TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'R'+s+Eol, cMELD);
                                   END
                              ELSE BEGIN {* Weiterleiten *}
                                   sTuRein := LinkPort2Via ( linknr , cTOKEN6Tx ); {* Mit FlexNachBar *}
                                   IF fTrace THEN
                                     BEGIN {* DebugTrace *}
                                     sTrace := Copy(s,1,i-1)
                                              +sMyCall+' ('
                                              +fStr(link[linkNr].tOur)
                                              +') '+sTuRein;
                                     sTrace[1] := '7';
                                     {FilterHack(sTrace);}
                                     Tx_InfoOneFrame(pCB,Sofort,sTrace); {* und zurck *}
                                     IF routBeaconPort <> 0 THEN
				        TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'r'+sTrace+Eol, cMELD);
                                     END;
                                   s := Copy(s,1,i-1)+sMyCall+' '+sTuRein;
                                   {FilterHack(s);}
                                   Tx_InfoOneFrame(link[linkNr].pCBRout,Sofort,s+' '+sZiel);
                                   IF routBeaconPort <> 0 THEN
                                      TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'W'+s+' '+sZiel+Eol, cMELD);
                                   END;
                            END;
                   END;
              END;

            IF sFehler <> '' THEN
              BEGIN {* Reflektieren *}
              {Insert(' '+sFehler,s, i+length(sMyCall));}
              s := Copy(s,1,i-1)+sMyCall+' '+sFehler+' '+sZiel;
              s[1] := '7';
              {FilterHack(s);}
              Tx_InfoOneFrame(pCB,Sofort,s+EOL);
              IF routBeaconPort <> 0 THEN
                  TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'D'+s+Eol, cMELD);
              END;

            END;
          END;

    '7' : BEGIN
          Inc(Count[cnt7ERPAKETE]);
          {* Routentest weiterleiten Format: 7HQQQQQSSSSSS XXXXXX DDDDDD
                                             12345678
             *   H TTL-Zhler. Beginnt bei ! (ASCII $21) und zhlt hinauf !"#$%&/()
             *   Q QSO-Nummer
             *   S Source-Digi
             *   X Digipeater ....
             *   D Ziel-Digi *}
          sMyCall := f_sh2Asc(pCB^.fromcall);
          {* String schon mal soweit kopieren *}
          byte(s[0]) := Min(255,pm^.inuse);
          Move(pm^.pData^, s[1], pm^.inuse);

          {* Spiegeln *}
          IF routBeaconPort <> 0 THEN
              TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', 'I'+s+EOL, cMELD);

          Inc (Byte(s[2])); {* HopCounter erhhen *}
          IF byte(s[2]) > 32+30 THEN Exit; {* Hopcounter - berlauf $TODO (Log eintragen) *}
          i := Pos(sMyCall+' ', s);
{$IFDEF alt}
          IF i = 0 THEN Exit;  {* MyCall ist gar nicht drin *}
{$ENDIF}
          IF i = 8 {* MyCall=Absender *}
            THEN BEGIN {* Es ist fr uns bestimmt - wir sch...... auf die SSIDs *}
                 qsoNr := f_Val( Copy(s,3,5) );
                 pCBZiel := Id2CB (qsoNr);
                 IF pCBZiel <> NiL THEN
                   IF pCBZiel^.qsotype = qtInfoBox THEN
                      BEGIN
                      Tx_EOLSysInfo (pCBZiel, SOFORT,'route: '+copy(s,8,255)+EOL);
                      END;
                 END
            ELSE BEGIN {* Weiterrouten *}
                 {* 7"  925DB0GE db0ona db0me-12 db0me-11 DB0ME db0me-11 DB0END DB0ACC *}
                 {* suche davorliegendes Call (oder Absender?) und route dahin *}
                l_7erLoop:
{$IFDEF alt}
                 Dec(i,2);
                 WHILE (i>8) AND (s[i]<>' ') DO Dec(i);
                 sZwisp := Copy(s,i,255);
                 ScanForText ( sZwisp, sZiel );
                 IF (sZiel<>'') AND (sZiel[1]>='a') THEN GOTO l_7erLoop; {kleinbuchstaben knnen nicht flexen!}
{$ENDIF}
{neu}            sZwisp := Copy(s,8,25);
{neu}            ScanForText ( sZwisp, sZiel ); {sZiel ist der Absender des 6er Frames}
                 AscCall2shift (sZiel,shZiel);
                 zi := FlexSucheZiel ( shZiel, ( byte(shZiel[7])  AND 30 ) SHR 1, FALSE);
                 IF zi <= 0 THEN Exit; {* Rckweg unbekannt $TODO (Log eintragen) *}
                 {* Suche LinkQSO fr dieses Ziel *}
                 linkNr := paZiel^[zi].lkUsed; {* NachbarIndex (Link) *}
                 IF LinkNr <= 0 THEN Exit; {* es gibt keine Route! $TODO (Log eintragen) *}
                 IF s[length(s)] <> EOL THEN AddChar(s,EOL);
                 Tx_InfoOneFrame(link[linkNr].pCBRout,Sofort,s); {* und zurck *}
                 {* Spiegeln *}
                 IF routBeaconPort <> 0 THEN
                     TxBeacon ( RoutBeaconPort, sMyCall,'ROUTE','', fstr(linkNr)+':'+s+EOL, cMELD);
                 END;
          END;
{$ifdef alt}
    '7' : BEGIN {* Routentest zurck *}
          Inc(Count[cnt7ERPAKETE]);
          Inc(word(p), 7); {* Zeigt auf das AbsenderCall *}
          IF MemEq ( @axIFace[pCB^.iface].asMyCall[1], p , length(axIFace[pCB^.iface].asMyCall) )
            THEN BEGIN {* Es ist fuer uns bestimmt - wir sch...... auf die SSIDs *}
                 Dec( word(p),5 ); {* Zeigt auf die QSONr *}
                 {* nicht sehr robust... *}
                 qsoNr := 0;
                 FOR i := 1 TO 5 DO
                   BEGIN
                   IF Byte(p^) >= byte('0') THEN
                     qsoNr := 10*qsoNr+ Byte (p^) - Byte('0');
                   Inc (word(p));
                   END;
                 {* p zeigt nun aufs Textfeld *}
                 pCBZiel := Id2CB (qsoNr );
                 IF pCBZiel <> NiL THEN
                   IF pCBZiel^.qsotype = qtInfoBox THEN
                      BEGIN
                      Tx_EOLSysInfo (pCBZiel, SPAETER,'route: ');
                      Tx_MemBlock( pCBZiel, SPAETER, p, pm^.inUse-7 );
                      Tx_Info (pCBZiel, SOFORT,EOL);
                      END;
                 END
            ELSE ; {* Weiterrouten is noch nich *}
          END;
{$ENDIF}

      ELSE BEGIN{* CASE *}
           Inc( Count[cntWrongToken]);
           END;

   END;
END;

{}

PROCEDURE DeleteFlexRoutingQso ( pCB : tp_axcb );
  {* Muss nach dem Ende eines FLXNET-QSOs aufgerufen *}
  {* werden (Destruktor auf neudeutsch)              *}
BEGIN
  IF pCB^.Divers.pLink = NiL THEN Exit; {* hm, sollte nicht passieren *}
  WITH pCB^.Divers.pLink^ DO
    BEGIN
    WatchDog; {* ...denn das folgende kann dauern *}
    {* Lsche alle Eintrge, die ber diesen Partner kamen und auch ihn selber *}
    SetzeNachbarLinkZeit ( id, 0 );
    tSchnitt := lzERROR; tOur := lzERROR; tThem := lzERROR;
    pCBRout := NiL;  {* Verweis im Linkblock lschen *}
    pCB^.qsoType := qtNULLQSO; {* und AX25-Block normal machen *}
    system := dsANDERE;
    startZeit := 0;
    {* TryToStartLZMess - Sofort wieder versuchen geht nicht immer...  *}
    sekBisMess := 0; {* Sobald wie mglich wieder versuchen *}
    StopTimer(pCB^.tTimeOut);
    pCB^.fmsgHandler := fnMsgDefault;
    END;
  pCB^.Divers.pLink := NiL;  {* am Ende, wg. WITH - s.o. *}
END;

{}

{$F+} PROCEDURE fnMsgFlexNet ( pCB : tp_Axcb; msg:T_MSG); FORWARD; {$IFNDEF AllFar} {$F-} {$ENDIF}


PROCEDURE AckWith0Token (pCB:TP_AXCB);
BEGIN
  Tx_InfoOneFrame (pCB,SOFORT,
            '0'+                            {* Byte 0: Token *}
            char(byte('0')+MyFlexMaxSSID)+  {* Byte 1: MaxSSID *}
            {* Byte 3: Softwarekennung: *}
            {*  Bit 0..2  Software-Art  *}
            {*       000  FlexNet       *}
            {*       001  BayCom-Node   *}
            {*       010  DigiWare      *}
            {*       011  TheNetNode (falls je vorhanden)
            {*       100  SNet (von DL2RBI) *}
            {*       101 .. 111    vorerst frei *}
            {*  Bit 3     Virtuelle Adressierung 1=enable 0=disable *}
            {*  Bit 4     frei (vorerst stets auf 0 gesetzt)        *}
            {*  Bit 5     bleibt stets auf 1 (damit es ASCII-lesbar bleibt) *}
            {*  Bit 6     frei (vorerst stets auf 0 gesetzt)                *}
            {*  Bit 7     bleibt stets auf 0 (damit es ASCII-lesbar bleibt) *}
            {* hier: DG9EP-Soft, keine virtuelle Adressierung *}
            char($02+$20)+

            {* Interne Verionsnr.,es sind nur druckbare *}
            {* Werte ($20 .. $7F) zugelassen. DigiWare z.Zt: 0 *}
            Char($20)+
            CR);
  StartTimer (pCB^.tTimeOut);
  {* In Rx ist ja (evt.) noch was unausgewertetes nmlich "0xyNAME<cr>" *}
  QueueMsg (pCB, msgRx );
END;


{$F+}
PROCEDURE fnMsgFlexNet ( pCB : tp_Axcb; msg:T_MSG); {$IFNDEF AllFar} {$F-} {$ENDIF}
  {* Msg-Handler fr Msg fr FlexNet-InterNode-QSOs *}
  VAR pm : TP_mBuf;
      fEnde : BOOLEAN;
BEGIN
Watchdog;
CASE msg of
  msgReconnect,
  msgConnectSuccess : AckWith0Token (pCB);

  msgRx :
     BEGIN
     IF pCB^.pID <> PID_FlexNet THEN
       BEGIN {* Wasn nu ? Der andere benutzt nicht (mehr) das Flexnet PID? *}
       DoDisconnectIMM ( pCB );   {* Also Schluss und aus! *}
       Exit;
       END;
     fEnde := FALSE;
     REPEAT
       {* Hole GENAU EINEN Buffer aus der Rx-Queue - Dies ist ein Internode-
        * QSO, und das ist von Framegrenzen abhngig! *}
       pm := GetMBufFromQueue (pCB^.RxBuf);
       fEnde := pm=NiL;
       IF NOT fEnde THEN
         BEGIN {* Da ist auch was drin gewesen *}
         Dec (pCB^.RxBufSize, pm^.inUse);
         IF pm^.pData <> Nil THEN DoFlexRx (pCB,pm)
                             ELSE StoreStack('m','f'+FStr(pm^.len));
         Del_mBuf (pm);  {* GetMBufQueue schreibt vor, dass *wir* den Buffer freigeben muessen *}
         END;
     UNTIL fEnde;
     END;

  msgSpecialT1Out,      {* T1 ist abgelaufen - nur im Status Disconnected - fuer CQ usw. *}
  msgRetryCountExceeded {* Darf nicht reagieren !!! }
    : ;

  msgTimeOut : {* 3 Minuten lang ist keinerlei Antwort auf '0' oder '2' eingegangen *}
      BEGIN
      DeleteFlexRoutingQso ( pCB ); {* Sofort alle Messwerte entsprechend setzen *}
      DoDisconnectImm (pCB);        {* Muss Imm sein, da durch DCD-abhngiges FRACK ein QSO hngen kann *}
      END;

  msgRxDM,        {* DM traf ein *}
  msgDiscReq,     {* ein DisconectRequest traf ein *}
  msgCBDel        {* CB der Verbindung wird gerade gelscht *}
                  {* (z.B. wenn eine DISC vom Partner mit UA besttigt wurde) *}
    :     DeleteFlexRoutingQso ( pCB );
  END{case};

END; {$IFNDEF AllFar} {$F-} {$ENDIF}

PROCEDURE InitFlexRoutingQso ( VAR pCB : tp_axcb; Master : BOOLEAN; index : WORD );
  {* Wird von der Infobox aufgerufen, wenn                         *}
  {* - ein Infobox-QSO das PID_FLEXNET hat, und der Partner in der *}
  {*   Link-Tabelle eingetragen ist.                               *}
  {* - bei der Messung der Laufzeit per SABM der Partner           *}
  {*   im I-Frame mit PID_FLEXNET antwortet.                       *}
  {* Index zeigt auf Link Eintag                                   *}
  VAR i : WORD;
BEGIN
  pCB^.divers.pLink := @Link[index];  {*  Handle Init *}
  WITH Link[index] DO
    BEGIN
    pCBRout := pCB; {* Nimm das denn kein Ende mit der Zeigerei ??? *}
    TokenStat := GetResetTokenStatus(pCB);
    startZeit := 0; {* Sonst wird unser 2er Paket nicht ausgesendet *}
    IF master THEN tOur := tSchnitt
              ELSE tOur := 0; {* Fred meint, dat muesste so :-S *}
    tSchnitt := lzError;
    tThem := lzError;
    END;
  pCB^.qsoType := qtFlexRouter;
  pCB^.who   := AUTO;
  pCB^.PID   := PID_FLEXNET;
  pCB^.retry := axIFace[pCB^.iface].retry_init;
  pCB^.fMsgHandler  := fnMsgFlexNet;
  pCB^.tTimeOut.tickinit := 180 * 100; {* 3 Minuten *}
  AckWith0Token(pCB);
END;

{}

{$IFDEF neverdef}
{$F+}
PROCEDURE _fnMsgFlexTest (pCB : TP_AXCB; msg:T_MSG);
  VAR wZwisp : Word;
      pm : tp_mbuf;
BEGIN
  CASE msg OF
    msgConnectSuccess {* Connect Versuch erfolgreich / Reconnect *}
     :  BEGIN
        pCB^.PID := PID_FLEXNET;
        Tx_InfoOneFrame (pCB,SOFORT,'0?  '); {* Token,MaxSSID,Version *}
        END;

    msgRX
     : REPEAT
          pm := GetMBufFromQueue (pCB^.RxBuf);
          IF pm <> NiL THEN BEGIN
                            Dec (pCB^.RxBufSize, pm^.inUse);
                            DoFlexRx(pCB,pm);
                            END;
       UNTIL pm = Nil;

    END{case};
END;



PROCEDURE TryToConnectFlexNet (  ifnr : T_IFNR; f,t,v : String );
  VAR pCB : tp_axcb;
BEGIN
  pCB := Try2Connect (ifnr, f,t,v,cNOINCSSID );
  IF pCB = NiL THEN Exit;
  pCB^.Pid := PID_FLEXNET; {* muss nicht sein, soll ein Hinweis auf die Mglichkeit sein *}
  pCB^.fMsgHandler := _fnMsgFlexTest;
END;

{$ENDIF}
{}

{$IFDEF sdlfjkhnsdjf}
PROCEDURE SendMH (pCB : TP_AXCB);
  Fr Tests
  VAR s : STRING;
      i,j :BYTE;
BEGIN
  FOR i := 1 TO 20 DO IF i < nMHeard THEN
   BEGIN
   s := '';
   FOR j := 1 TO 6 DO
     IF j<=length(mheard[i].call) THEN s:=s+char(byte(mheard[i].call[j]) DIV 2)
                                  ELSE s:=s+' ';
   s:= '3'+s+char(ord('0')+0)+char(ord('0')+1)+f_LeftUsing(random(5000)+100,4);
   Tx_infoOneFrame (pCB, SOFORT, s );
   END;
END;

PROCEDURE SendEntry (pCB : TP_AXCB; i : WORD;  bSofort : BOOLEAN );
 {* sendet genau einen Eintrag aus der Dest.Table *}
  VAR s : STRING;
BEGIN
  {* Damit der vorherige Text auch als ein Frame ausgesendet wurde *}
  IF pCB^.rxBufSize = 0 THEN WITH dest[i] DO
  {*BUG*}
  IF Laufzeit <> ENTRY_INVALID THEN
    BEGIN
    Shift2ascCall ( call, s );
    s:= '3'+s+char(ord('0')+ssid_von)+char(ord('0')+ssid_bis)+f_LeftUsing(laufzeit,4);
    Tx_infoOneFrame (pCB, bSofort, s );
    END;
END;
{$ENDIF}


{* kein Init *}
END.
