UNIT FD_Error;
{* Routinen fuer Speichern und Lesen aus dem RAM nach Reset *}
{* und Abspeichern von Fehlerzustnden                      *}

{$I FD_INCL.PAS}

INTERFACE
{$IFNDEF scc}{$O+,F+}{$ENDIF}

USES FD_Def;

{ PROCEDURE BackUpFatal; }
 PROCEDURE BackUpStartTime;
 PROCEDURE InitSoftWatchdog;  {* Platz !!! *}
 PROCEDURE StoreIntTable;
 PROCEDURE CheckIntTable;

{}

IMPLEMENTATION


USES FD_Div,     {* Hex_String *}
     FD_Subr,    {* MemEq *}
     {$IFDEF SCC} fd_TNC,
     {$ELSE}      fd_crt, dos,
     {$ENDIF}
     FD_Log
     ;

{}

PROCEDURE BackUpFatal;
  VAR i : BYTE;
BEGIN
  FOR i := MAXRESET-1 DOWNTO 1 DO Backup.Err[i+1] := Backup.Err[i];
  Backup.Err[1].Zeit := sysTime;
  Backup.Err[1].Adr := ErrorAddr;
  Backup.Err[1].Code := ExitCode;
  Inc (backup.nError);
END;

PROCEDURE BackUpStartTime;
 VAR i : BYTE;
BEGIN
  FOR i := MAXRESET-1 DOWNTO 1 DO Backup.StartTime[i+1] := Backup.StartTime[i];
  Backup.StartTime[1] := sysTime;
END;


{}

PROCEDURE StoreIntTable;
BEGIN
{$IFDEF OS2} Exit; {$ENDIF}
{$IFnDEF DPMI} 
  Move ( Ptr(0,0)^, IntTable , sizeof(intTable) );
{$ENDIF}
END;

PROCEDURE CheckIntTable;
  VAR i : WORD;
      s : STRING;
BEGIN
{$IFDEF DPMI} Exit; {$ENDIF}
{$IFDEF OS2} Exit; {$ENDIF}
  IF NOT MemEq ( ptr(0,0), @intTable , sizeof(intTable) ) THEN
    BEGIN
    Inc( Backup.IntTableChged );
    s := '';
    FOR i := 0 to 1023 DO
      IF mem[0:i] <> intTable[i] THEN
        BEGIN
        Backup.IntTbl_adr := i;
        Backup.IntTbl_dat := mem[0:i] ;
        s := s + HexString(i)+':'+HexByteString(mem[0:i])+' ';
        END;
    LogAddEntry (NiL, leIntTbl, s);
    StoreIntTable;
    END;
END;

{}
{$IFDEF sdlkfjsdlkjf lsdjfsldkjf } Ist jetzt in FD_Def
PROCEDURE StoreStack ( cGrund : CHAR; sText : STR20 );
  {* Fehlerquelle:
   * C = CheckAXCB.pid=0
   * c = CheckAXCB.Ifacenr falsch
   *     entfernt: D = DelAxcb
   * d = FD_Info.mhcircuit
   * E = Runtime - Error
   * F = Freemem  mit NIL
   * I = UnknownQso.IFace falsch
   * i = fd_tx.  inUse = 0
   * L = EntryDest
   * m = DelMbuf
   * N = fd_info.mhcircuit: pPartnerCB nicht vorhanden (bei cbdel)
   * n = fd_info.mhcircuit: pPartnerCB nicht vorhanden
   * r = fd_tx.RepeatPM
   * R = Startup-Restart-Timer
   * T = FD_TX.TxQueue_mBuf_chain-Falsche Parameter
   * U = UserListe: Falsche ID
   * W = Watchdog,
   * w = 2.HWD
   * 0 = CheckAXCB -> pCB = NiL
   * 1,2,3 = FD_SCC.sendPacket
   *}
  VAR i : BYTE;
BEGIN
  FOR i := MAXRESET-1 DOWNTO 1 DO  backup.caller[i+1] := backup.caller[i];
  FOR i := MAXRESET-1 DOWNTO 1 DO  backup.grund[i+1]  := backup.grund[i];
  FOR i := MAXRESET-1 DOWNTO 1 DO  backup.sData[i+1]  := backup.sData[i];
  FillChar ( backup.caller[1], sizeof(backup.caller[1]), #0 ) ;
  ASM
     PUSH BP
     MOV  AX,fdcs
     MOV  SI,offset backup.caller
     MOV  CX,nCaller
  @@1:
     LES  DI,[BP+02] {* Ret Adresse des Aufrufers *}
     MOV  BP,[BP+00] {* BP          des Aufrufers (zeigt immer insStackSegment) *}
     MOV  WORD PTR [SI+2],ES
     MOV  WORD PTR [SI+0],DI
     SUB  WORD PTR [SI+2],ax {* Abziehen, damit man fuer MAP-File nicht umrechnen muss *}
     ADD  si,4
     DEC  CX
     JNZ  @@1
     POP  BP
  END;
  backup.grund[1] := cGrund;
  backup.sData[1] := sText;
END;
{$ENDIF}

{}
 {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}


VAR semErrHdl: WORD; {* keine Konsatante, da---- *}
    exitSave : Pointer;

PROCEDURE ErrHdl; FAR;
  VAR i : BYTE;
BEGIN
  IF (semErrHdl = 0) AND (ExitCode>0) THEN
    BEGIN
    Inc (semErrHdl);
    FOR i := MAXRESET-1 DOWNTO 1 DO backup.stack[i+1] := backup.stack[i];
    FillChar ( backup.stack[1], sizeof(backup.stack[1]), #0 ) ;
    ASM
       PUSH BP
       MOV  AX,fdcs
       MOV  SI,offset backup.stack
       MOV  CX,nCaller
    @@1:
       LES  DI,[BP+02]       {* Ret Adresse *}
       MOV  WORD PTR [SI+2],ES
       MOV  WORD PTR [SI+0],DI
       SUB  WORD PTR [SI+2],AX {* Abziehen, damit man fuer MAP-File nicht umrechnen muss *}
       ADD  si,4
       MOV  BP,[BP+00] {* BP des Aufrufers laden *}
       DEC  CX
       JNZ  @@1
       POP  BP
    END; {asm}
    backup.stack[1].grund := 'E';
    backup.stack[1].tick  := FastTick;
    backup.stack[1].sData := FStr(ExitCode);
    Inc(backup.nStackStore);
{$IFDEF VER70x}
    IF ExitCode=201 THEN
      BEGIN
      backup.stack[1].sData := backup.stack[1].sData +
      {* Diese beiden sind in der RTL einzubauen; Ansonsten kann man diese
       * Zeile auch streichen *}
                                  ' ' + FStr(WrongValHi) +
  			          ' ' + FStr(WrongValLo)   ;
      END;
{$ENDIF}
    IF ExitCode=203 THEN
      BEGIN
      backup.stack[1].sData:=backup.stack[1].sData +
                          ' ' + fStr(sysMemAvail) +
                          ' ' + fStr(sysMaxAvail);
      END;
    BackupFatal;
    END;
  WriteLn (      ' RUNTIME ERROR:', ExitCode,  ' ', HexAddrString ( erroraddr ) );
  WriteLn (con2, ' RUNTIME ERROR:', ExitCode,  ' ', HexAddrString ( erroraddr ) );
END;
{$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}




{$IFDEF scc}
PROCEDURE PortViolation(Flags, CS, IP, AX, BX, CX, DX,
                               SI, DI, DS, ES, BP: Word); Interrupt;
BEGIN
  {* IBREAK setzen (I/O erlauben). Wird von irgendeiner    *}
  {* Routine bestimmt mal irgendwann wieder zurckgesetzt (I/O verboten). *}
  {* Hier kein "Portena" verwenden! denn das schreibt direkt ins Register *}
  {* und das wird ja am Ende wieder verpopt...                            *}
  Flags := Flags OR $02;

  StoreStack('V',      ' '+hexString(cs-fdcs)+':'+hexstring(ip));
{$IFDEF UserWare} {1.6.97}
  Writeln(con2, 'PortVio:',hexString(cs-fdcs)+':'+hexstring(ip));
  Writeln(      'PortVio:',hexString(cs-fdcs)+':'+hexstring(ip));
{$ENDIF}
  StoreStack('V',' F:'+HexString(Flags)
               + ' CS:'+HexString(CS)
               + ' IP:'+HexString(IP)
               + ' AX:'+HexString(AX)
               + ' BX:'+HexString(BX)
               + ' CX:'+HexString(CX)
               );
  StoreStack('V',' DX:'+HexString(DX)
               + ' SI:'+HexString(SI)
               + ' DI:'+HexString(DI)
               + ' DS:'+HexString(DS)
               + ' ES:'+HexString(ES)
               + ' BP:'+HexString(BP)
               );
  {* Eigentlich msste cs:ip korrigiert werden; er zeigt auf den I/O *}
  {* aber egal - wozu haben wir BRK ausgemacht?                      *}
END;
{$ENDIF}

{}

PROCEDURE InitSoftWatchdog;  {* Platz !!! *}
BEGIN
  IF NOT fEisKaltStart THEN backup.swd_tick := swd_Tick;
  SWD_Init := (0700 DIV _clktick);  {* 0,7 Sek. *}
  SWD_Tick := SWD_Init;
END;

{}

BEGIN
  WriteLn ('- Error-Init');

  exitSave := exitProc;
  exitproc := @ErrHdl;

  semErrHdl := 0;
  WatchDog;
  Inc (backup.nReset);
  IF fEiskaltstart THEN
    BEGIN
    FillChar ( Backup, sizeof (Backup), #0);
    {nIntDis := 0;}
    Backup.magic := MAGIC;
    END;
 {$IFDEF scc}
   Setintvec(19,@PortViolation);  {* I/O Port-Access-Tracking *}
 {$ENDIF}
END.
