UNIT FD_Dump;
{$I FD_INCL.PAS}

INTERFACE

USES FD_def;


CONST DisplayAlle : BOOLEAN = TRUE;

     TYPE T_dumpMode = (andere,debugdump,myRx,myRxDigi,myTx,fehler);
PROCEDURE Dump_ax25 ( pm : tp_mbuf; mode : T_dumpMode );
PROCEDURE DumpIP ( p1 : Pointer; gesamtLen : WORD);
PROCEDURE TestKey;

{}

IMPLEMENTATION


USES
     FD_Div,
     FD_AxCb,
     FD_Main,
     FD_PROM,
     FD_Subr,
     FD_mBuf,
     FD_TX,            {* wg. Tx_Info *}
     FD_Task,
     FD_Timer,
     FD_KISS,
     {$IFDEF SCC}
         FD_SCC,
         FD_TNC,
      {$ELSE}
         FD_CRT,
         DOS,
     {$ENDIF}
     FD_Host,     {* Anzeige HostDaten *}
     FD_Beacon,
     FD_Conv,
     FD_Link,
     FD_Log,
     FD_State,
     FD_AR,
     FD_Error,
     FD_Moni, {*Call2Str *}
     FD_Netrom,
     FD_Sysop,
     FD_Flex, {* wg. InitFlexRoutingQso etc. *}
     FD_MH,
     FD_Mem ;



CONST faDump : ARRAY[1..6] OF BOOLEAN = (TRUE,TRUE,TRUE,TRUE,TRUE,TRUE);    {* Kennzeichnet nicht darzustellende IFaces *}
      fNoTx       : BOOLEAN = FALSE; {* PCSIO-SendeVerbot *}
      fPID0f0     : BOOLEAN = TRUE;  {* plainText-Pakete dumpem *}
      iTxCB : BYTE = 1;
      iRxCB : BYTE = 1;
      sAltSendStr : STRING = '';
      bDiscardAll   : BOOLEAN = FALSE;
      sSendStr : STRING = '';
{$IFDEF FileDump}
VAR   hDump : TEXT;
{$ENDIF}

{}

FUNCTION DebugPM (pm : TP_MBUF; byNDataBytes : BYTE) : STRING;
  VAR pSrc : POINTER;
      i : BYTE;
      s : STRING;
BEGIN
  IF pm = Nil
    THEN s := EOL+'NIL'
    ELSE BEGIN
         s := EOL+
           HexAddrString (pm)+
           ': N:'+HexAddrString (pm^.next)+
           ' D:'+HexAddrString (pm^.pData)+
		{ bufl	: longint;  {* TX/RX: pData als 20 Bit Addresse *}
	   ' inU:'+FStr(pm^.inUse)+
           ' t:'+fStr(pm^.time)+
	   ' i:'+FStr(pm^.Ifnr)+
	   ' tx:'+char(48+ord(pm^.txed))+
           ' pT:'+HexAddrString (pm^.ptTimer)+
	   ' disc:'+char(48+ord(pm^.discard))+
	   ' len:'+FStr(pm^.len)+
	   ' ofs:'+FStr(pm^.ofsctl)+
 	   ' nMy:'+FStr(pm^.nMyCall )+
	   ' nH:'+FStr(pm^.nHeard)+
           ' pData:';
         IF pm^.pData <> NiL THEN
           BEGIN
           IF (byNDataBytes > pm^.inUSe) OR (byNDataBytes=255) THEN byNDataBytes := pm^.inUSe;
           pSrc := pm^.pData;
           FOR i := 1 TO byNDataBytes DO
             BEGIN
             IF char(pSrc^) < #32 THEN s := s + ''
                                  ELSE s := s + Char(pSrc^);
             Inc( Word(pSrc) );
             END;
           s := s + '<<--'+EOL;
           END;
         END;
  DebugPM := s;
END;


{}

VAR globalResultProtocol : Longint;
CONST
    grp_NIL                 =    -1;
    grp_ax25_seg            =     9;
    grp_IP                  =     1;
      grp_ICMP              =     2;
      grp_UDP               =    12;
      grp_IP_unknownVersion =     8;
      grp_TCP               =        1 * 65536;
      grp_PPCONVERS         =$10E10;
    grp_ARP                 =    10;

    grp_NETROM              =        2 * 65536;
      grp_NODES             =     3;
      grp_NETROM_L3RTT      =     7;

    grp_BCHEAD              =     5;
    grp_BC                  =     6;

PROCEDURE WriteIncPas(VAR hdl:TEXT; VAR p : Pointer);
  VAR s : STRING;
BEGIN
  Write(hdl, string(p^));
  p := Incp(p,byte(p^)+1);
END;



PROCEDURE DumpTCP (p1 : Pointer; dlen : WORD);
  VAR p : tp_by1Array;
      len,wor,i : WORD;
BEGIN
  p := p1;
  IF p^[14] AND  1 =  1 THEN Write ('FIN ');
  IF p^[14] AND  2 =  2 THEN Write ('SYN ');
  IF p^[14] AND  4 =  4 THEN WRITE ('RST ');
  IF p^[14] AND  8 =  8 THEN WRITE ('PSH ');
  IF p^[14] AND 16 = 16 THEN WRITE ('ACK ');

  Write ('seq:');
  FOR wor := 5 to 8 DO  Write (HexByteString (p^[wor]) ); {*Sequenznr.*}
  Write (' ack:' );
  FOR wor := 9 to 12 DO Write ( HexByteString ( p^[wor] )); {*Ack.Nr.*}

  WRITE (
         ' Ports:', StrML (p,1),
               '', StrML (p,3),
        ' Window:', StrML (p,15) );

  IF p^[14] AND 32 = 32 THEN WRITE (' Urg.P.:', StrHexML (p,39) );
  len := (p^[13] SHR 4)*4;
  IF len <> 20 THEN Write (' tcp-len:',len);
  IF dLen > len THEN WriteLn;

  Inc (word(p1), len);
  DumpText (p1, dLen-len);
END;

PROCEDURE DumpDomainNameServer (VAR hdl:TEXT; p1 : Pointer; dlen : WORD);
  TYPE T_DNS = RECORD id, parameter,
                      nQuest, nAnswers,
                      nAuth,nAdd : WORD;
                      data : Byte;
                      END;
  VAR pdns : ^T_dns;
BEGIN
  pdns := p1;
  WITH pdns^ DO
    BEGIN
    Write(hdl, 'DNS',
                  swap(nQuest),' Fragen    ',
                  swap(nAnswers),' Antworten  '
                );
    IF swap(Parameter) AND  $20 <> 0 THEN Write(Hdl, ' Autho.' );
    IF swap(Parameter) AND  $40 <> 0 THEN Write(Hdl, ' Trunc.' );
    IF swap(Parameter) AND  $80 <> 0 THEN Write(Hdl, ' recurs.desir.' );
    IF swap(Parameter) AND $100 <> 0 THEN Write(Hdl, ' recurs.avail.' );
    Write(hdl,'   ');
    p1:= IncP(p1,sizeof(T_DNS)-1);
    WHILE Byte(p1^) in [1..63] DO
      BEGIN
      WriteIncPas(hdl, p1);
      Write(hdl,'.');
      END;
    WriteLn(hdl);
    END
END;



PROCEDURE DumpUDP (VAR hdl:TEXT; p1 : Pointer; dlen : WORD);
  TYPE T_UDP = RECORD sourceportHL,
                      destportHL,
                      lenHL,
                      crcHL : WORD;
                      data : BYte
                      END;
  VAR p : tp_by1Array;
      pudp : ^T_UDP;
BEGIN
  globalResultProtocol := grp_UDP;
  p := p1;
  pudp := p1;
  WITH pUDP^ DO
    BEGIN
    WriteLn(hdl, swap(sourceportHL), '', swap(destportHL),
                 '   Len: ',swap(lenHL));
    IF swap(destportHL) = 53
      THEN DumpDomainNameServer(hdl,@data,dlen-(sizeof(t_udp)-1) )
      ELSE DumpHex (hdl,@data,dlen-(sizeof(t_udp)-1) );
    END
END;


PROCEDURE DumpICMP (p1 : Pointer; dlen : WORD);
  VAR p : tp_by1Array;
      i : WORD;
BEGIN
  p := p1;
  CASE p^[1] OF  {* Message Typ *}
     0 : Write( 'Echo Reply');
     3 : Write( 'Destination unreachable');
     4 : Write( 'Quench');                  {* Source Quench *}
     5 : Write( 'Redirect');                {* Redirect *}
     8 : Write( 'Echo');                    {* Echo Request *}
    11 : Write( 'Time Exceed');             {* Time-to-live Exceeded *}
    12 : Write( 'Param Prob');              {* Parameter Problem *}
    13 : Write( 'Timestamp');               {* Timestamp *}
    14 : Write( 'TIME_REPLY');              {* Timestamp Reply *}
    15 : Write( 'Info Request');            {* Information Request *}
    16 : Write( 'Info Reply');              {* Information Reply *}
    ELSE Write( '-Unknown type-' + HexByteString (p^[21]));
    END;
  Write( ' Code:'+HexByteString (p^[2]));
  Write( ' chksum:' + strML (p,3));
  Write( ' id:' + strML (p,5));
  Write( ' seq:'+ StrHexML (p,7));
{*  WriteLn;
{* DumpText (p1,dlen); *}
END;



PROCEDURE DumpRSPF (p1 : Pointer; dlen : WORD);
  VAR i : WORD;
      p : Pointer;
BEGIN
  WriteLn; p := p1;
  FOR i := 1 TO dlen DO
    BEGIN
    IF byte (p1^) = 44 THEN WriteLn;
    Write (byte (p1^):4);
    Inc (word (p1));
    END;
  WriteLn;
  DumpText ( p, dLen );  {* Damit das RouterHello auch zu sehen ist *}
END;


PROCEDURE DumpPIDSegment (VAR hdl:TEXT;  p1 : Pointer; gesamtLen : WORD);
  Type t_c = record b1,b2:BYTE;END;
  VAR seg,pid : byte;
BEGIN
  globalResultProtocol := grp_ax25_seg;
  SetTextAttr (_yellow_black);
  Write(hdl,'AX25-Segment ');
  seg := t_C(p1^).b1;
  IF (seg and $80) <> 0
    THEN BEGIN
         pid := t_C(p1^).b2;
         WriteLn(hdl,'First segment; ',seg and $7f,' remaining segments',pid);
         {Dump_AX25 (pid, IncP(p1,2), gesamtLen-2);}
         END
    ELSE BEGIN
         Writeln(hdl,seg and $7f,' remaining segments');
         END;
  SetTextAttr (_White_Black);
  DumpText ( IncP(p1,1), gesamtLen-1);
END;




PROCEDURE DumpIP ( p1 : Pointer; gesamtLen : WORD);
  VAR i, wor,
      ipLen,
      fOffSet,
      headerLen : WORD;
      p         : ^by1Array;
      p2        : POINTER;
      s : STRING;
BEGIN
  p := p1;
  SetTextAttr (_yellow_black);
  s := '';
  IPHead2Str ( p1, gesamtLen, s);
  Write(s);

  Inc (word (p1),headerLen);
  CASE by1Array (p^) [10] OF
     IPID_TCP  : DumpTCP(p1,ipLen-Headerlen);
     IPID_RSPF : DumpRSPF(p1,ipLen-Headerlen);
     IPID_ICMP : DumpICMP(p1,ipLen-Headerlen);
     IPID_UDP  : DumpUDP (output, p1, ipLen-Headerlen);
     ELSE BEGIN
          FOR i := headerlen+1 TO iplen DO
            BEGIN
            CASE char (p1^) OF
                   LF : WriteLn;
                   #00..#31 : BEGIN
                              SetTextAttr (_Green_Black);
                              Write (char(byte(p1^)+64));
                              END;
                   ELSE BEGIN
                        SetTextAttr ( _White_Black );
                        Write (char (p1^));
                        END;
                   END; {*case*}
            Inc (word (p1));
            END; {for}
          END; {ELSE}
     END; {CASE}
END;


PROCEDURE DumpNodes ( p1 : Pointer; gesamtLen : WORD);
{*************************************************************
  *  Format:						    *
  *	  Offset/Elw Lnge				    *
  *	     08 01    7    Call eines Knotens (AX25Call)    *
  *	     15 08    6    ID dieses Knotens (ASCII !)	    *
  *	     21 14    7    via zu diesem Knoten (AX25Call)  *
  *	     28 21    1    Qualitt der Verbindung	    *
**************************************************************}
  VAR TheNetHeader   : STRING;
      Ident,ZielCall,ViaCall : STRING;
      i,len,quali      : WORD;
BEGIN
  SetTextAttr(_yellow_black);
  TheNetHeader := 'NODES ';
  Inc(word(p1));
  FOR i := 1 TO 6 DO
    BEGIN  {* Ident des sendenen Knotens *}
    Addchar(TheNetHeader,char(p1^));
    Inc(word(p1));
    END;
  WriteLn(TheNetHeader);

  len := 7;
  WHILE (len+21 <= gesamtlen)  DO
    BEGIN
    ZielCall:= ''; DecodeAX25Call ( p1, ZielCall);
    Ident := '';
    FOR i := 1 TO 6 DO
      BEGIN  {* Ident des sendenen Knotens *}
      Addchar(IDent,char(p1^));
      Inc(word(p1));
      END;
    viaCall := ''; DecodeAX25Call( p1, viaCall);
    quali   := byte(p1^);  Inc(word(p1));

    Write ( Ident+':'+ZielCall+' v. '+viaCall+' >'+F_Using(quali,5)+'     ' );
    IF (len MOD 2) = 0 THEN WriteLn;
    Inc (len,21);
    END; 
END;


PROCEDURE DumpNetRom ( p1 : Pointer; gesamtLen : WORD);
  VAR OpCode         : Byte;
      z_Str	     : STRING;
      TheNetHeader   : STRING;
      pBegin : POINTER;
      i      : WORD;
BEGIN
  pBegin := p1;
  IF byte(p1^)=$FF THEN BEGIN
                        DumpNodes(p1,gesamtLen);
                        Exit;
                        END;
  IF gesamtlen < 20 THEN exit; {* Mindestlnge NetRom Header *}
  TheNetHeader := '';
  DecodeAX25Call ( p1, TheNetHeader );
  TheNetHeader  := 'Net/ROM' + TheNetHeader + '  ';
  DecodeAX25Call ( p1, TheNetHeader );
  OpCode := ( t1ba(pBegin^)[20] and $0f );
    CASE OpCode of
	   0: z_str := 'extPID'; {* beispielsweise zum Transport VON IP-Packets *}
	   1: z_str := 'ConReq' {Connect Request} ;
	   2: z_str := 'ConAck' {Connect Acknowledge} ;
	   3: z_str := 'DisReq' {Disconnect Request} ;
	   4: z_str := 'DisAck' {Disconnect Acknowledge} ;
	   5: z_str := ' Info ' {Information} ;
	   6: z_str := 'InfAck' {Information Acknowledge} ;
 	  ELSE z_str := ' OPCode: '+FStr (t1ba(pBegin^)[20]);
        END ;{case}
    TheNetHeader := TheNetHeader + ' <' + z_str + '>' ;

    z_Str := '' ;
    IF ( (t1ba(pBegin^)[20]) and $80 ) <> 0 THEN z_str := ' [Choke]';
    IF ( (t1ba(pBegin^)[20]) and $40 ) <> 0 THEN z_str := ' [NAK]';
    IF ( (t1ba(pBegin^)[20]) and $20 ) <> 0 THEN z_str := ' [More]';

  {$IFDEF gahn}
    TheNetHeader := TheNetHeader + ' ' + z_str + '  ttl:' + FStr (t1ba(pBegin^)[15]))  {* LifeTime *};
    IF OpCode = 1 THEN BEGIN {* InfoBlock des ConReq auswerten *}
		       TheNetHeader := TheNetHeader + CRLF + ' ';
		       DecodeAX25Call ( @w[29], TheNetHeader);
		       TheNetHeader := TheNetHeader + ''  ;
		       DecodeAX25Call ( @w[22], TheNetHeader);
		       DelLen := 20+15 ;
		       END ;
    IF OpCode = 2 THEN DelLen := 20+1;  {ConAck}

    IF (OpCode = 1) OR (OpCode = 2)
  	          THEN TheNetHeader := TheNetHeader + ' L4-Gre:'+ FStr(Byte(w[21])) + ' ' ;

    IF ( OpCode >= 3 ) AND ( OpCode <= 6 ) OR ( OpCode  = 1 )
      THEN BEGIN {* opcodes 1,3,4,5,6 *}
	   TheNetHeader := TheNetHeader + ' Ind:' + FStr(Byte(w[16]))
				        + ' ID:'  + FStr(Byte(w[17]));
	   END ;

    IF   (OpCode = 5)	      {* Info *}
      OR (OpCode = 6) THEN
        BEGIN {* InfoAck *}
	TheNetHeader := TheNetHeader + ' R:'+ FStr(Byte(w[19])) ;
	IF  OpCode = 5 THEN TheNetHeader := TheNetHeader
				        + ' S:' + FStr(Byte(w[18]));
	END;
  {$ENDIF}
    SetTextAttr (_yellow_black);
    WriteLn (TheNetHeader);
    IF (Opcode = 0) {* extPid *}
      THEN BEGIN
           p1 := pBegin;
           Inc( word(p1),21);
           IF ((t1ba(pBegin^)[16] AND $3f)=PID_IP) THEN DumpIP ( p1, gesamtlen-20 );
           END
      ELSE Write(CRLF + '  unbekannter ePID?:'
                      + FStr(t1ba(pBegin^)[16])+'/'
                      + FStr(t1ba(pBegin^)[17])
                      );
    p1 := pBegin;
    inc(word(p1),20);
    FOR i := 20 TO gesamtLen DO
      BEGIN
      CASE char (p1^) OF
             LF : WriteLn;
             #00..#31 : BEGIN
                        SetTextAttr (_Green_Black);
                        Write (char(byte(p1^)+64));
                        END;
             ELSE BEGIN
                  SetTextAttr ( _White_Black );
                  Write (char (p1^));
                  END;
             END; {*case*}
      Inc (word (p1));
      END; {for}
END;


{
ARP = ADRESS Resolution Protokoll:

Beispiel 1:
 1  2  3  4  5  6  7  8    9 10 11 12 13 14 15 16 17 18 19 20 21 22
00 03 00 cc 07 04 00 01   88 8c 6a 96 9e 40 60 2c 82 20 0A 00 00 00 00 00
                          88 8e 72 8a a0 40 60 2c 82 13 32
 AX25  Prot.!   ! REQUEST  D F  5   K  O       44 130 32 10
        lenAX25 ip-Len                           ProtAddr

Byte     bedeutung

01,02    int16 hardware;                 /* Hardware type */  ( MSB,LSB ! )
03,04    int16 protocol;                 /* Protocol type */
05       char hwalen;                    /* Hardware address length, bytes */
06       char pralen;                    /* Length of protocol address */
07,08    int16 opcode;                   /* ARP opcode (request/reply) */
9-       uchar shwaddr[hwalen];          /* Sender hardware address field */
[4]      int32 sprotaddr;                /* Sender Protocol address field */
         char thwaddr[hwalen]            /* Target hardware address field */
[4]      int32 tprotaddr;                /* Target protocol address field */

/* ARP opcodes */
        ARP_REQUEST     1
        ARP_REPLY       2

/* Hardware types */
        ARP_NETROM     = 0       /* Fake for NET/ROM (never actually sent) */
        ARP_ETHER      = 1       /* Assigned to 10 megabit Ethernet */
        ARP_EETHER     = 2       /* Assigned to experimental Ethernet */
        ARP_AX25       = 3       /* Assigned to AX.25 Level 2 */
        ARP_PRONET     = 4       /* Assigned to PROnet token ring */
        ARP_CHAOS      = 5       /* Assigned to Chaosnet */
        ARP_ARCNET     = 7
        ARP_APPLETALK  = 8
}



PROCEDURE DumpARP ( p1: pointer; len : WORD );
CONST ofsHWALEN = 5; {offset der Hardware-Adressen-Lnge }
  VAR p : ^by1Array;
      Wor,
      hardware : Word;
      s : STRING;
BEGIN
  SetTextAttr ( _yellow_black );
  p := p1; {* Konvertieren *}
  hardware := wordML(p,1);
  s := 'ARP  bind:';
  IF hardware = 3 THEN S:=S+' AX25'
                  ELSE S:=S+FStr (hardware);
  s := s + ' Prot:' + STRML (p,3) +'  Opcode:';

  CASE p^[8] OF
     1 : s := s + 'request';
     2 : s := s + 'reply'
    ELSE s := s + StrML (p,7);
  END;
  IF Hardware = 3 THEN
    BEGIN
    s := s + CRLF + ' [';
    FOR wor := 16 TO 19 DO  s := s + FStr(p^[wor]) + '.';
    Dec ( Byte (s[0]) ); {* Letzten Punkt entfernen *}
    s := s+'], ';
    FOR wor := 9 TO 14 DO   s := s + char ( Byte (p^[wor]) DIV 2);
    s := s + CRLF + ' [';
    FOR wor := 27 TO 30 DO  s := s + FStr(p^[wor]) + '.';
    Dec ( Byte (s[0]) ); {* Letzten Punkt entfernen *}
    s := s+'], ';
    FOR wor := 20 TO 25 DO  s := s + char ( Byte (p^[wor]) DIV 2);
    END;
  Write (s);

END; {* arp *}


PROCEDURE BC2Str ( p1: pointer; len : WORD;  VAR sHead,sDat : String );
  TYPE T_BCHEADER = RECORD
         flag : BYTE;
         fileid : Longint;
         filetyp: Byte;
         offset : WORD;
         offsetH: Byte;
       END;
       T_BCPaket = RECORD
         h : t_BCHeader;
         data : Array [1..250] OF byte;
       END;
  VAR p : ^t_bcPaket;
      i,l: Longint;
BEGIN                                                     {$R-}
  p := p1; {* Konvertieren *}
  sHEad := 'BC ID:' + HexLIString(p^.h.fileid)
         + '  offset:' + fStr(longint(p^.h.offset)+65536*p^.h.offsetH)+
           '  type:'  + fstr(p^.h.filetyp)+
           '  vers.'  + fstr((p^.h.flag AND $0c) SHR 2)
       ;
  l := longint(len)-2-sizeof(p^.h);
  sHead := sHead + '  CRC:'+HexString(word(p^.data[l+1])+256*(p^.data[l+2]));
  IF p^.h.flag AND $20 <> 0 THEN sHead := sHead + ' (last)';

  IF (p^.data[1]=$aa) AND (p^.data[2]=$55) THEN
    BEGIN
    sHead := sHead + ' FileHeader:.. ';
    END;

  sDat := '';
  FOR i := 1 TO l DO sDat := sDat + char(p^.data[i]);
END; {* bc *}


{}

PROCEDURE Tx_ARP;
  VAR pcb : tp_Axcb;
BEGIN
  pcb := CreateAxcb(1);
  IF pcb <> NiL THEN BEGIN
                     Asc2axcb ( 'TC1IP','DG9EP','', pCB );
                     pcb^.pf := cMELD;
                     pcb^.pid := PID_ARP;
                     pcb^.iFace := 5;
                     Tx_UInfo ( pCB, cMELD,
                        #$00#$03#$00#$cc#$07#$04#$00#$01 +
                        #$88#$8e#$72#$8a#$a0#$40#$60 + #44#130#19#50 +
                        #0#0#0#0#0#0#0               + #44#130#19#47
                     );
                     Del_axcb ( pCB );
                     END;
END;



PROCEDURE TX_Nodes;
  VAR pcb : tp_Axcb;
{*          01            $FF
 *          02 --    6    IDENT des Absenders (ASCII!)
 *          08 01    7    Call eines Knotens (AX25Call)
 *          15 08    6    ID dieses Knotens (ASCII!)
 *          21 14    7    via zu diesem Knoten (AX25Call)
 *          28 21    1    Qualitt der Verbindung
 *}
BEGIN
  pCB := createaxcb(1);
  IF pcb <> NiL THEN
    BEGIN
    Asc2axcb (
    {* 'DB0ME-1','NODES','DB0ME',      *}
    {* 'XA9EP','DG9EP','',             *}
       'DG9EP-9','DB0II','DG9EP,DB0ME',
                pCB );
    pcb^.pf := cMELD;
    pcb^.pid := PID_NETROM;
    pcb^.iface := 1;
    TX_UInfo ( pCB, cMELD,
#$FF'ME    ' +
#$88#$82#$62#$92#$92#$40#$00 + 'ABCDE ' + #$88#$84#$60#$9a#$8a#$40#$00 + char(239)

{$IFDEF sfkhsdf}
#$88#$84#$60#$92#$92#$40#$65 + 'MG    ' + #$88#$84#$60#$9a#$8a#$40#$00 + char(1) +
+#$88#$84#$60#$92#$92#$40#$00 + 'MG    ' + #$88#$84#$60#$9a#$8a#$40#$00 + char(MyRandom(200)+11)
#$88#$84#$60#$9A#$8A   + char( 2*(random(25)+65) ) + #$08
            + 'TESCHT' + #$88#$88#$60#$9A#$8A#$40#$02 + char(Random(200)+11)
+#$86#$86#$68#$88#$8c#$40#$00 + 'A     ' + #$88#$84#$60#$84#$84#$40#$00 + char(Random(200)+11) +
+#$86#$84#$60#$92#$92#$92#$18 + 'AGLONG' + #$88#$84#$60#$92#$92#$94#$18 + char(Random(200)+11) +
+#$86#$88#$64#$92#$92#$40#$00 + 'AEL   ' + #$88#$84#$60#$92#$92#$40#$00 + char(Random(200)+11) +
+#$86#$88#$60#$92#$92#$40#$00 + 'ABC   ' + #$88#$84#$60#$92#$92#$40#$00 + char(Random(200)+11) +
+#$88#$86#$68#$88#$8c#$40#$00 + '      ' + #$88#$84#$60#$84#$84#$40#$00 + char(Random(200)+11) +
+#$88#$84#$60#$92#$92#$92#$18 + 'MGLONG' + #$88#$84#$60#$92#$92#$94#$18 + char(Random(200)+11) +
+#$88#$88#$64#$92#$92#$40#$00 + 'DEL   ' + #$88#$84#$60#$92#$92#$40#$00 + char(Random(200)+11) +
*#$88#$86#$68#$88#$8c#$92#$18 + 'TEST  ' + #$88#$84#$60#$84#$84#$94#$18 + char(Random(200)+11)
{$ENDIF}
);
    Del_axcb ( pCB );
    END;
END;


{#$88#$88#$60#$92#$92#$40#$00 + 'ABC   ' + #$88#$84#$60#$92#$92#$40#$00 + char(Random(200)+11) +
}
PROCEDURE DumpQueue ( pm : tp_mbuf; mit : BOOLEAN );
  VAR n : WORD;
BEGIN
  n := 0;
  WriteLn;
  WHILE pm <> Nil DO
    BEGIN
    IF Mit THEN DUMP_AX25( pm, DebugDump )
           ELSE Write ( HexAddrString( pm ), ' ');
    pm := pm^.nexT;
    Inc(n);
    END;
  Write (' ## ',n,' ##');
END;



PROCEDURE Dump_AX25 ( pm : tp_mbuf; mode : T_dumpMode );
  VAR i, len,coff : WORD;
      control,pid,
      ta,bZwisp   : BYTE;
      p           : TP_Data;
      Command     : BOOLEAN;
{*      sTyp        : STRING [10]; }
      sHead,sDat,
      sHeader     : STRING;
BEGIN
  {$IFDEF V24LIFE}
{ dumpdelay := (FastTick-pm^.Time); }

  {$IFnDEF scc}
  IF pm^.ofsctl=cOFFVIRT THEN
    BEGIN
    IF      Mode = myRx      THEN SetTextAttr (_black_Cyan)
    ELSE IF Mode = myRxDigi  THEN SetTextAttr (_LightGreen_Cyan)
    ELSE IF Mode = myTx      THEN SetTextAttr (_white_Cyan)
    ELSE IF Mode = Fehler    THEN SetTextAttr (_yellow_Red)
    ELSE IF Mode = debugDump THEN SetTextAttr (_white_Red)
    ELSE IF Mode = andere    THEN SetTextAttr (_yellow_Cyan);
    Writeln(Pm2AxHeaderStr(pm,true));
    SetTextAttr (_White_Black);
    WriteLn( Pm2BodyStr ( pm ) );
    Exit;
    END;
  {$ENDIF}

  WatchDog;

  IF NOT fDumpMyTx THEN IF mode = MyTx THEN Exit;
  IF (axiface[pm^.ifnr].fLOOPBACK) THEN
    BEGIN
    IF mode = myTX THEN Exit; { damit nicht alles 2 * erscheint }
    END;
  IF NOT faDump[pm^.ifnr] THEN Exit;

  SetCrtMoni(prim);
  p := pm^.pData;
{  pr := p; }
  len := pm^.inUse;

  coff := pm^.ofsCtl;

  IF (coff<14) OR (coff>72) THEN
    BEGIN
    IF Byte(p^) = $45 THEN
      BEGIN
      WriteLn;
      DumpIP (pm^.pData, pm^.inUse);
      Exit;
      END;
    WriteLn (CRLF,'Lngenfehler: coff= ',coff);
{$IFDEF scc}
    Exit;
{$ELSE}
    WriteLn(DebugPM (pm,255));
    WriteLn (CalcOfsCtl(pm)+1);
{$ENDIF}
    END;
  IF NOT fDisplayFrames THEN Exit;

  control := by1Array (p^)[cOff];
  Inc (cOff);
  Command := (by1Array (p^)[7] AND $80 <> 0);

  IF NOT fPID0f0 THEN
    IF (control AND $01 = $00) OR   {* I-Frame oder *}
       (control AND $ef = $03) THEN {* UI-Frame *}
         IF by1Array (p^)[cOff] = PID_TEXT THEN Exit; {* bei PlainText nix tuen *}
  IF bDumpMode = dmONLYI THEN
    IF (control AND $01 <> $00) AND {* kein I-Frame *}
       (control AND $ef <> $03) THEN {* auch kein UI-Frame *}
        Exit;
  IF bDumpMode = dmNORR THEN
    IF (control AND $0f = $01) OR   {* ein RR-Frame *}
       (control AND $0f = $05) OR   {* ein REJ *}
       (control AND $0f = $09) THEN {* ein RNR *}
        Exit;

{  IF      Control and $0f =   1 THEN sTyp := '  RR '
  ELSE IF Control and $01 =   0 THEN sTyp := '   I '
  ELSE IF Control and $0f =   5 THEN sTyp := ' RNR '
  ELSE IF Control and $0f =   9 THEN sTyp := ' REJ '

  ELSE IF Control and $ef = $03 THEN sTyp := '  UI '
  ELSE IF Control and $ef = $0f THEN sTyp := '  DM '
  ELSE IF Control and $ef = $2f THEN sTyp := ' SABM'
  ELSE IF Control and $ef = $43 THEN sTyp := ' DISC'
  ELSE IF Control and $ef = $63 THEN sTyp := '  UA '
  ELSE IF Control and $ef = $87 THEN sTyp := ' FRMR'
  ELSE                               sTyp := ' ?? ';
}

  WriteLn;
  {$IFnDEF scc}
  IF      Mode = myRx      THEN SetTextAttr (_black_Cyan)
  ELSE IF Mode = myRxDigi  THEN SetTextAttr (_LightGreen_Cyan)
  ELSE IF Mode = myTx      THEN SetTextAttr (_white_Cyan)
  ELSE IF Mode = Fehler    THEN SetTextAttr (_yellow_Red)
  ELSE IF Mode = debugDump THEN SetTextAttr (_white_Red)
  ELSE IF Mode = andere    THEN SetTextAttr (_yellow_Cyan);
  {$ELSE}
  Write ('===');
  {$ENDIF}

  sHeader :=  '';
  IF      Mode = myRx      THEN AddChar(sHeader,'>')
  ELSE IF Mode = myRxDigi  THEN AddChar(sHeader,'>')
  ELSE IF Mode = myTx      THEN AddChar(sHeader,'<')
  ELSE IF Mode = Fehler    THEN AddChar(sHeader,'=')
  ELSE IF Mode = debugDump THEN AddChar(sHeader,'/')
  ELSE {IF Mode = andere    THEN} AddChar(sHeader,'!');


{$IFDEF alt-xxx}
  {* Calls ausgeben *}
 { Call2Str2 (p,8,sHeader);
  AddChar(sHeader,'');
  Call2Str2 (p,1,sHeader);
  ClrEol;
  i := 15;
  IF by1Array (p^)[14] AND 1 = 0 THEN
     BEGIN }{Digis}{
     REPEAT
       AddChar(sHeader,',');
       Call2Str (p,i,sHeader);
       IF (by1Array (p^)[i+6] and $80 <>0) then AddChar(sHeader,'*');
       Inc (i,7);
     UNTIL (by1Array (p^)[i-1] AND 1) = 1;
     END;

  sHeader := sHeader+styp;

  IF (by1Array (p^)[14] AND 128) <> (by1Array (p^)[7] AND 128)
    THEN IF Control and $10 >0  THEN  IF command THEN AddString (sHeader,'p ')
                                                 ELSE AddString (sHeader,'f ')
                                ELSE  IF Command THEN AddString (sHeader,'C ')
                                                 ELSE AddString (sHeader,'R ')
    ELSE AddString (sHeader,'v1') ;

  AddString (sHeader,' - ');
  IF (Control and $03 = 1) OR (Control and $01 = 0) THEN AddString (sHeader,' R'+FStr ((Control AND $e0) SHR 5 ));
  IF  Control and $01 = 0 THEN AddString (sHeader,'  S'+FStr ((Control AND $0e) SHR 1 ));
  }
{$ENDIF}
  sHeader := sHeader + Pm2axHeaderStr ( pm, false );
  Write(sHeader);
  ClrEol;

  {$IFDEF FileDump}{$IFnDEF scc}
  Write(hDump,sHeader);
  WriteLn (hDump,'    ',pm^.Time DIV 100,',',pm^.Time MOD 100:2, 's ');
  {$ENDIF}{$ENDIF}

  GotoXY (55,WhereY);
  ta:=GetTextAttr;
  IF      pm^.ifnr = 1   THEN SetTextAttr( 31 )
  ELSE IF pm^.ifnr = 2   THEN SetTextAttr( 79 )
  ELSE IF pm^.ifnr = 4   THEN SetTextAttr( 91 )
  ELSE IF pm^.ifnr = 5	 THEN SetTextAttr( 46 )
                         ELSE SetTextAttr( 43 );
  Write (' if', pm^.iFnr:1);
  SetTextAttr ( ta );

  Write (' ',pm^.Time DIV 100,',',pm^.Time MOD 100:2, 's ');

 { IF Write('  txd=',TxDelay(pm):1:2,'ms'); }

  Inc (word (p),cOff-1);
  IF Control AND $EF = $87
    THEN BEGIN {* FRMR *}
         SetTextAttr ( _Yellow_Black );
         WriteLn;
         Write ( ' Controllfeld: $',HexByteString (Byte(p^)) );
         Inc (word (p));
         bZwisp := Byte(p^);
         IF (bZwisp AND $10) = 0 THEN Write (' Command')
                                 ELSE Write (' Response');
         Write (CRLF,' V(R):', bZwisp div $20,
                 ' V(S):', (bZwisp DIV $02) AND 7 );
         Inc (word (p));

         bZwisp := Byte(p^);
         IF (bZwisp AND $01) <> 0 THEN Write (CRLF+' inv.Ctl-Field');
         IF (bZwisp AND $02) <> 0 THEN Write (CRLF+' I-Field not allowed');
         IF (bZwisp AND $04) <> 0 THEN Write (CRLF+' I_Field to long');
         IF (bZwisp AND $08) <> 0 THEN Write (CRLF+' inValid N(R)');
         END
  ELSE IF    ( control AND   1 = 0)    {* I-Frames *}
          OR ( control AND $EF = $03 ) {* UI-Frame *} THEN
         BEGIN
         Write (pm^.inUse-pm^.Ofsctl-1);

         pid := Byte (p^);
         Inc (cOff); Inc (word (p));
         CASE Pid OF
           PID_Text    : WRITE ('Text');
           PID_IP      : WRITE ('IP');
           PID_ARP     : WRITE ('ARP');
           PID_NetRom  : WRITE ('NetROM');
           PID_BC      : WRITE ('PacSat-BC');
           PID_FlexNet : BEGIN
                        {$IFnDEF SCC} SetTextAttr (GetTextAttr OR BLINK); {$ENDIF}
                         WRITE ('FlexNet');
                         END;
           ELSE write ('pid',pid:4);
          END;
         IF fDumpText THEN
           BEGIN
           SetTextAttr (_White_Black );
           WriteLn;
          {$IFnDEF PID_DUMP}
            DumpText (p, len+1-cOff) ;
          {$ELSE}
           CASE Pid OF
             PID_Text ,
             PID_FlexNet :DumpText (p, len+1-cOff);
             {$IFDEF NETROMDUMP}
             PID_NetROM : DumpNetROM (p, len-cOff+1);
             {$ENDIF}
              8         : DumpPIDSegment (output,p, len-cOff+1);
             PID_IP     : DumpIP (p, len-cOff+1);
             PID_ARP    : DumpARP (p, len-cOff+1);
             PID_BC     : BEGIN
                          BC2Str (p, len-cOff+1, sHead, sDat);
                          SetTextAttr ( _yellow_black );
                          WriteLn(sHEad);
                          DumpText(@sDat[1], length(sDat));
                          END;
             ELSE DumpText (p, len-cOff+1) ;
            END; {* CASE *}
           {$ENDIF}
           END;
         END;
  {$ENDIF}
END;


{}

CONST myCBBlocked : BOOLEAN = FALSE;
      xCursor : BYTE = 1;
      yCursor : Byte = 15;


{$F+}
PROCEDURE fnMsgLocalLoopback (pCB : TP_AXCB; msg : T_Msg);
 {* wird jedesmal aufgerufen, wenn ein korrektes Frame eintrifft *}
 {* in einer Verbindung, die manuell von mir ausgelst wurde     *}
  VAR is  : Byte;
      i,wZwisp : Word;
      s : String;
      p : tp_mbuf;
BEGIN
  IF myCBBlocked THEN BEGIN
                      Event_BecomeBusy(pcb);
                      Exit;
                      END;
{ Event_BecomeunBusy(pcb); }
 {$IFnDEF SCC      Speicher sparen ! *}
  IF msg =  msgTX THEN Exit;
  IF msg <> msgRX THEN
    BEGIN
    s := '';
    CASE msg OF
      msgConnectSuccess : s := 'ConSuccess';
      msgReconnect : s := 'Reconnect';
      msgRetryCountExceeded : s:= 'RetryCountExceeded';
      msgDiscReq : s := 'DiscReq';
      msgCBDel : s := 'CB Del';
      msgRxDM : s := 'RxDM';
      msgSpecialT1Out : s := 'Special T1 Out'
      ELSE fnMsgDefault ( pCB, msg );
      END; {* CASE *}
    IF (pCB = cb[iRxCB]) AND (s<>'') THEN
      BEGIN  {* StatusMeldung schreiben *}
      SetCrtMoni ( Sek );
      Gotoxy (xCursor,yCursor);
      ClrEol;
      WriteLn;
      SetTextAttr (31);
      WriteLn (con2, EOL,'=====',s);
      xCursor := WhereX; yCursor := WhereY;
      END;
    Exit;
    END;
  {$ENDIF   scc}

  IF (pCB <> cb[iRxCB]) THEN
    BEGIN {* Wenn keiner guckt -> wegwerfen *}
    p := pCB^.RxBuf;
    pCB^.RxBuf := Nil;
    pCB^.RxBufSize := 0;
    Del_mBuf_chain(p);
    Exit;
    END;
  SetCrtMoni ( Sek );
  {$IFDEF SCC} SetTextAttr (112); {$ENDIF}

  REPEAT
    WatchDog;
    wZwisp := GetQueueData (pCB^.RxBuf, pCB^.RxBufSize, @s[1], sizeOf (s)-1, #0);
    IF wZwisp < 256 THEN byte(s[0]) := wZwisp
                    ELSE byte(s[0]) := 255;

    IF (pCB = cb[iRxCB]) THEN
      BEGIN
      Gotoxy (xCursor,yCursor);
      FOR is := 1 TO length (s) DO
        IF s[is] = EOL THEN WriteLn (con2)
                       ELSE IF s[is] <> LF THEN Write (con2,s[is]);
      xCursor := WhereX;
      yCursor := WhereY;
      END;
  UNTIL wZwisp = 0;
END;


FUNCTION F_ManTryToConnect (  ifnr : T_IFNR; f,t,v : String ) : WORD;
  VAR pCB : tp_axcb;
      i   : WORD;
      sh  : T_ShCall;
BEGIN
  AscCall2shift ( t, sh );
  IF AR_SearchRoute ( sh, FALSE,ifnr, v ) = 0 THEN ;
  pCB := Try2Connect ( ifnr, f,t,v, cNOINCSSID );
  IF pCB = NiL THEN Exit;
  pCB^.Pid := PID_TEXT; {* muss nicht sein, soll ein Hinweis auf die Mglichkeit sein *}
  pCB^.Pid := PID_PACKES; {* muss nicht sein, soll ein Hinweis auf die Mglichkeit sein *}
  pCB^.fMsgHandler := fnMsgLocalLoopback;
  F_ManTryToConnect := pCB^.id;
END;

PROCEDURE ManTryToConnect (  ifnr : T_IFNR; f,t,v : String );
BEGIN
  IF F_ManTryToConnect (  ifnr,f,t,v ) = 0 THEN ;
END;


FUNCTION F_ManTryToConnect_NoAR (  ifnr : T_IFNR; f,t,v : String ) : TP_AXCB;
  VAR pCB : tp_axcb;
BEGIN
  pCB := Try2Connect ( ifnr, f,t,v, cNOINCSSID );
  F_ManTryToConnect_NoAR := pCB;
  IF pCB = NiL THEN Exit;
  pCB^.Pid := PID_TEXT; {* muss nicht sein, soll ein Hinweis auf die Mglichkeit sein *}
  pCB^.fMsgHandler := fnMsgLocalLoopback;
END;

PROCEDURE ManTryToConnect_NoAR (  ifnr : T_IFNR; f,t,v : String );
BEGIN
  IF F_ManTryToConnect_NoAR ( ifnr, f,t,v ) = NIL THEN;
END;


{}

CONST fShowCB : BOOLEAN = {$IFDEF scc} FALSE; {$ELSE} TRUE; {$ENDIF}
      cbStartIndex : WORD = 0;

PROCEDURE Beenden;
BEGIN
  Nosound;
  HALT(0);
END;


PROCEDURE DumpTimer ( VAR t : t_timer );
  VAR s : STRING;
BEGIN
  s := '';
  AppendTimer2Str( t , s);
  Write (con2,s);
END;


PROCEDURE ShowCBs;
  VAR i,j : WORD;
      s   : STRING;
      ch,ch2  : CHAR;
      isr,
      irr : BYTE;
      fHEader : BOOLEAN;
BEGIN
  NoSound;
  {$IFDEF V24LIFE}
  {$IFnDEF scc}   SetTextAttr (15);  {$ENDIF}
  IF NOT fShowCB THEN EXIT;
  SetCrtMoni (sek);

  {$IFnDEF scc}
  IF fNoTx THEN BEGIN
                GOTOXY (30,20);
                SetTextAttr ( 120 + Blink );
                Write (con2, 'NO TX TODAY');
                SetTextAttr (15);
                END;
  GotoXY  (1,1);
  {$ENDIF}

  Watchdog;
  IF NOT fDisplayFrames
    THEN BEGIN
         GOTOXY (1,1);
         Write (con2,'No Monitor-');
         Write (sSendStr); ClrEol;
         END
    ELSE BEGIN
         IF DisplayAlle THEN Write (con2,'All')
                        ELSE Write (con2,'Ich');
         IF      bDumpMode = dmALL   THEN Write (con2,' RR')
         ELSE IF bDumpMode = dmONLYI THEN Write (con2,' I')
                                     ELSE Write (con2,' SB');
         IF NOT fPID0f0 THEN Write (con2,' PID');
         IF NOT fDumpMyTx THEN Write (con2,' mTX');
         SetTextAttr (GetTextAttr OR BLINK);
         IF myCBBlocked THEN Write (con2,' myCBBlocked');
         SetTextAttr (GetTextAttr AND NOT BLINK);
         END;

  Watchdog;
  Write (con2,
   ' FT:',FastTick,
   ' Mem:',sysMemAvail,
{* ' o/e:',HexAddrString(heaporg),' ',HexAddrString(Heapptr), *}
{* ' tf:',HexAddrString(@timRestart.TimerFunction), *}
   ' dmpIf:' );
  FOR i := 1 TO sizeof(faDump) DO IF faDump[i] THEN Write(con2,i:1);
  WRITE (con2,'  ');

  IF SABMmode <> smUA THEN WRITE (con2,'SABMmode:',SABMmode);
  ClrEol;

  GOTOXY (9,2);
  SetTextAttr (120); Write (con2,sSendStr); SetTextAttr (15);
  {$IFDEF SCC} WriteLn (con2); {$ENDIF}
  ClrEol;

  GOTOXY (1,3);
  WriteLn (con2, cbStartIndex:2,' st MaxF RxSz TxSz la ua TX POOL  from  to tri  t1 t2 t3 busy');
  ClrEoL;

  {$IFDEF SCC}
   WriteLn (con2);
   FOR i := 1 TO 20 DO
  {$ELSE}
   FOR i := cbStartIndex+1 to cbStartIndex+10 DO
  {$ENDIF}
   IF cb[i] <> Nil THEN
    BEGIN
    WatchDog;
    ch := ' '; ch2 := ' ';
    IF i = iTxCB THEN ch := 'T';
    IF i = iRxCB THEN ch2 := 'R';
    Write (con2,i:2,ch,ch2);
    IF cb[i] = Nil
      THEN {$IFnDEF SCC} Write (con2, ' -') {$ENDIF}
      ELSE WITH cb[i]^ DO
        BEGIN
        Write (con2, ORD (state):2, maxframe:2, rxBufSize:5, txBufSize:5);
        WatchDog;
        s[0] := #8;
        FOR j := 0 TO 7 DO
          IF txq[j] = Nil THEN s[j+1] := ''
          ELSE IF txq[j]^.ptTimer = Nil THEN s[j+1] := '?'
          ELSE IF txq[j]^.ptTimer^.pbEnabled = Nil THEN s[j+1] := 'N'
	  ELSE CASE txq[j]^.txed OF
     TRANSMITTED : IF txq[j]^.ptTimer^.pbEnabled^ THEN s[j+1] := ''
						  ELSE s[j+1] := '+';
	 WAITING : BEGIN
                   IF txq[j]^.ptTimer^.pbEnabled^ THEN s[j+1] := ''
						  ELSE s[j+1] := '*';
                   END

{*
 *      SUSPENDED : IF txq[j]^.ptTimer^.pbEnabled^ THEN s[j+1] := ':'   jfhsdkjfhsdjfsdf
						  ELSE s[j+1] := '-';
 *
 *}
       ELSE        IF txq[j]^.ptTimer^.pbEnabled^ THEN s[j+1] := 'O'
						  ELSE s[j+1] := 'o';
       END; {* CASE *}
        Write (con2,lastAck:3, nUnbest:2);
        WatchDog;
        Write (con2,s, tries:2,
              ' ', f_sh2asc (fromCall), '', f_sh2asc (toCall) );
        IF nDigi > 0 THEN  Write (Con2,',', f_sh2asc (digi[1]) );

        DumpTimer (t1);
        DumpTimer (t2);
        DumpTimer (t3);
        IF tTimeOut.state = running THEN DumpTimer(tTimeOut);
        WatchDog;

{* IF t1.state = running THEN Write (con2,' t1-', t1.TicksRemaining); }
{* IF messFrack > 0 THEN  Write (con2, messFrack,' ');  }
{* IF minFrack < MAXLONGINT THEN Write (con2, minFrack,' '); }

        IF busy THEN Write (con2, ' bsy');
        WriteLn (con2, '|',t1.TickInit,'|',iface);
        END;
    ClrEoL;
    END;
{$IFDEF HostMode}
  fHeader := FALSE;
  FOR i := 0 TO ycmdMAXHOSTKANAL DO WITH HostChannel[i] DO
    IF pselfcb <> nil THEN
      BEGIN
      IF NOT fHeader THEN
        BEGIN
        fHeader := TRUE;
        WriteLn(con2,'ChNr Stat QSOID  nPack');
        END;
      WriteLn(con2,  i:5,
                   ord(status):5,
                   pSelfCB^.id:6,
                   nHstMsgQueue:5,
                   '  ',sMyCall,'-->',sCallAndPath);
      ClrEoL;
{*	 QSORxBuf     : TP_Mbuf;     {* Der neueste steht vorne *
 *        nHstDataFrame: WORD;  {* Number of receive frames not yet displayed *
 *        pHstMsgRoot,
 *        pHstMsgTail : tp_HstStatusQueue;
 *}
      END;
{$ENDIF HostMode}
{$ENDIF V24LIFE}
END;


PROCEDURE DumpTxQ (nr : BYTE);
  VAR p : tp_mBuf;
BEGIN
{  $TODO:z
  _DI; p := iface[nr].tx_root; _EI;
  WHILE (p <> Nil) OR KeyPressed DO
    BEGIN
    WriteLn (Con2,HexAddrString(p),
                   ' len',p^.len,
                   ' inUse',p^.inUse,
                   ' ofsc', p^.ofsCtl,
                   ' txd',ord(p^.txed),
                   ' dsc',ord(p^.discard),
                   ' tim',p^.time,
                   ' nh',p^.nHeard,
                   ' n',HexAddrString(p^.next)
                   );
    _DI; p := p^.Next;  _EI;
    END;  }
END;


PROCEDURE DumpIFaceTx (nr : BYTE);
  VAR i : BYTE;
BEGIN
{* $TODO:z
  _DI; i := iface[nr].l1_state; _EI;
  Write (con2,'iFace', nr);
  Write (con2,' ZUST.:', i);
  Write (con2,' CH_FREE:',ord(iface[nr].ch_free));
  Write (con2,' TIMER:',iface[nr].chan_TIME);
  IF iface[nr].tx_root = NiL
    THEN WRITE (Con2, ' Root=NIL' )
    ELSE BEGIN
         WRITE (Con2, ' ROOTnUse:',iface[nr].tx_root^.inUse);
         IF iface[nr].tx_root^.next=NiL
           THEN WRITE (Con2, ' Root^.next=NIL' )
           ELSE WRITE (Con2, ' ROOTnextinUse:',iface[nr].tx_root^.next^.inUse);
         END;
  IF iface[nr].tx_tail = NiL
    THEN WRITE (Con2, ' TX_Tail=NIL' )
    ELSE WRITE (Con2, ' TailinUse:',iface[nr].tx_Tail^.inUse);
  WriteLn (con2); }
END;

{$IFnDEF SCC}
   PROCEDURE PutRxBuffer (pCB:TP_axcb; CONST sText:STRING);
     VAR  pm : TP_mBuf;
          wZwisp : WORD;
   BEGIN
   pm := Get_MBuf ( length (sText) );
   Move ( sText[1], pm^.pData^, length (sText) );
   wZwisp := EnQueue (pCB^.RxBuf, pm);
   Inc (pCB^.RxBufSize, wZwisp);
   END;
{$ENDIF}


CONST caFLEXKOMPR : ARRAY [1..38] of byte = (
       $04,$7F,$92,$34,$70,$86,$1B,$E6,$F0,$0D,$2A,$2A,$2A,$20,$72,$65,
       $63,$6F,$6E,$6E,$65,$63,$74,$65,$64,$20,$74,$6F,$20,$44,$42,$30,
       $43,$50,$55,$0D,$3D,$3E ); {
                           [1..8] of byte = (
            $04,$7D ,$92 ,$34 ,$70 ,$86 ,$1B ,$E1
     );                            }
  caTxDATA      {caSABMF} : ARRAY [1..17] OF Byte = (
       $88,$8E,$72,$8A, $A0,$40,$E0,$90,
       $9E,$86,$90,$64 ,$40,$63,$3F,$01,
       $02
      );

     caAXSEGIP : ARRAY [1..42] OF BYTE = (
            $81, $cc, $45 ,$10 ,$00 ,$28 ,$23 ,$8C ,$40 ,$00 ,$3F,
            $06 ,$95 ,$92 ,$2C ,$82 ,$14 ,$4E ,$2C ,$82 ,$15 ,$50 ,
            $54 ,$B7 ,$00 ,$17 ,$A4 ,$0C ,$7E ,$8E ,$1C ,$5D ,$38 ,
            $B1 ,$50 ,$10 ,$7C ,$00 ,$E4 ,$BA ,$00 ,$00
            );
     caDATA : ARRAY [1..3] OF BYTE = ( $81, $cc, $e5 );


PROCEDURE TestKey;
  VAR ch      : CHAR;
      i,len       : WORD;
      p       : Pointer;
      tocall, s,
      via     : STRING;
      by1,by2: BYTE;
      fh1,fh2,
      li, li2 : LONGINT;
      shCall  : T_shcall;
       shPath : T_ShPath;
      xx      : Array[1..1024] OF CHAR;
      pCB     : TP_AXCB;
      pm      : TP_mBuf;
      {$IFnDEF SCC} f : TEXT; {$ENDIF}

BEGIN
  ch := Readkey;
  {$IFDEF V24LIFE}
  CASE ch OF
      #0 : BEGIN
	   {$IFDEF SCC}
	     IF Readkey = '' THEN; {* Readkey weglesen, sonst beisst die bind-Watchdog *}
           {$ELSE}
           ch := Readkey;
           CASE ch of
            key_ctrl_enter
                   : AddChar(sSendStr,EOL);
            key_up : sSendStr := sAltSendStr;
            key_f1..key_f10
                   : iTxCB := Ord(ch) - ord(key_f1) + 1 + cbStartIndex;
            key_shift_f1..key_shift_f10
                   : BEGIN
                     iRxCB := Ord(ch) - ord(key_shift_f1) + 1 + cbStartIndex;
                     END;
            key_ctrl_f1..key_ctrl_f10
                   : BEGIN
                     cbStartIndex := 10 * (Ord(ch) - ord(key_ctrl_f1) + 1 -1 );
                     END;
            key_alt_f1..key_alt_f10
                   : BEGIN
                     iTxCB := Ord(ch) - ord(key_alt_f1) + 1 + cbStartIndex;
                     iRxCB := Ord(ch) - ord(key_alt_f1) + 1 + cbStartIndex;
                     END;
            key_alt_1 : TX_ARP;
            key_alt_2 : TX_Nodes;
            key_alt_5 : cb[iTxCB]^.who := sysop;
            key_alt_6 : sSendStr := '6!12345TT5TT DG9EP DD9JN';
            key_alt_9 : BEGIN {* DM ausloesen *}
                        pCB := Createaxcb (1);
                        Asc2axcb ( axIFace[ifLoopback].asMyCall,'DG6KAS','DB0WST', pCB );
                        pcb^.pf := cMELD;
                        pcb^.pid := PID_Text;
                        {* TX_Ctrl ( pCB, RR, TRUE, FALSE, NiL );*}
                        TX_FRMR ( pCB, NiL, 0,0,0,0);
                        Del_axcb(pCB);
			END;
	    key_alt_a : tx_Ctl (cb[iTxCB], cV1, $ff ); {* FRMR auslsen *}
            key_alt_d : FOR i := 1 TO maxAXCB DO
                          IF cb[i] <> NiL THEN DoDisconnectImm( cb[i] );
            key_alt_i : {TxBeacon ( 5, 'von','INFO','DG9EP,DB0RWI', '',cMELD);}
                        {TX_Info( CB[iTxCB], SOFORT, '' );}
                        TxTestInfo ( ifloopBack, 'DG9EP-9','HO2HD-1','DG9EP', '', cPOLL);

            key_alt_k : CB[iTxCB]^.pid := PID_PACKES;
            key_alt_m : fDumpMyTx := NOT fDumpMyTx;

            key_alt_o : FOR i := 1 TO 15 DO
                           tx_Info ( CB[i], SOFORT, sSendStr+EOL );
            key_alt_p : Tx_Info ( CB[iTxCB], SOFORT, sSendStr );
            key_alt_r : PutRxBuffer( CB[iRxCB], sSendStr );
            key_alt_q : BEGIN
                        {cvLINKCALL := 'DG9EP-15 '; {* Leerzeichen MUSS sein! *}
			Tx_Info ( CB[iTxCB], SOFORT, '/'#$FF#$80+sSendStr+EOL );
                        END;
            key_alt_t : BEGIN
                        fNoTx := NOT fNoTx;
			ClrScr;
                        END;
            key_alt_v : BEGIN
                        TX_Info (cb[5],SOFORT,'/'#$ff+#$80+'USER dd1jk tjaWeitHost 0 -1 1'+EOL+
                                     '/'#$ff+#$80+'USER dl9ll der_andere 0 -1 1'+EOL);
                        END;
            key_alt_u : BEGIN
                        sSendStr := '/'#$ff+#$80+'UMSG';
			{sSendStr := 'c dg9ep v dg9ep-3';}
                        {iface[3].ch_free := TRUE;}
                        { setintvec($F0,@TestKey); CheckIntTable; }
                        { cb[iTxCB]^.t1.pbenabled := @FOREVER_TRUE; }
                        { * SendCom(fiss[3],3);  Tx_interupt simulieren}
                        END;
            key_alt_w : bDiscardAll := NOT bDiscardAll;
            key_alt_x : Beenden;
            key_alt_y : BEGIN
                        IF sSendStr= '' THEN Assign (f,'flex.seq')
                                        ELSE Assign (f,sSendStr);
                        Reset (f);
			WHILE NOT EOF(F) DO
                          BEGIN
                          Readln (f,s);
                          s := s + CR;
                          TX_INFO( cb[iTxCB], SOFORT, s);
                          END;
                        Close (f);
                        END;
            key_alt_z : BEGIN
                        InitFlexRoutingQso
			      ( cb[F_ManTryToConnect (5,axIFace[ifLoopback].asMyCall,'HOCHD','')],
                                FALSE, 1 );
                        END;

            END;
          {$ENDIF  not scc *}
           END; {* #0 *}
{*  ESC darf nicht verwendet werden !!! *}
      CR : BEGIN
           IF Length(sSendstr) = 0 THEN Fillchar(sSendstr[1],10,' ');
	   IF (sSendStr[1] = '&')
            THEN BEGIN
                 i := f_Val (Copy (sSendStr,2,4));
                 IF i IN [1..10]
                    THEN BEGIN
                         iTxCB := cbStartIndex+i;
                         iRxCB := iTxCB;
                         END
                    ELSE IF i>100
                           THEN iTxCB := cbStartIndex+i-100
                           ELSE cbStartIndex := i;
                 WriteLn(con2,'***',cbStartIndex,' T',iTxCB, ' R',iRxCB);
                 END
            ELSE IF sSendStr[1] = ':' THEN
                  BEGIN
                  String2tv ( Copy (sSendStr, 4, 255), toCall, via );
                  CASE upCase (sSendStr[2]) OF
                    '-',
                    '+' : WHILE Length(sSendStr)>=3 DO
                            BEGIN {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
			    faDump [ord(sSendStr[3])-ord('0')] := sSendStr[2] = '+';
                            Delete (sSendStr,3,1);
                            END; {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
                    '1' : ManTryToConnect  (1,axIFace[ifLoopback].asMyCall+'-1', toCall, via);
                    '2' : ManTryToConnect  (2,axIFace[ifLoopback].asMyCall+'-2', toCall, via);
                    '3' : ManTryToConnect  (3,axIFace[ifLoopback].asMyCall+'-3', toCall, via);
                    '4' : ManTryToConnect  (4,axIFace[ifLoopback].asMyCall+'-4', toCall, via);
                    '6' : ManTryToConnect  (6,axIFace[ifLoopback].asMyCall+'-6', toCall, via);
                    '7' : cb[iTxCB]^.paclen := MAXPACLEN;
                    'F' : FOR i := 1 TO 128 DO
                            BEGIN
                            SetTextAttr(i);
                            Write (con2, i:4);
                            END;
                    'I' : BEGIN {* Mehrfach Connect - fr Convers-Test -}
                          iTxCB := 1;
                          WHILE (iTxCB < 10) AND (cb[iTxCB] <> Nil) DO inc (iTxCB);
                          iRxCB := iTxCB;
			  ManTryToConnect_NOar  (ifloopBack, axIFace[ifLoopback].asMyIdent,axIFace[ifLoopback].asMyCall+'-8','');
			  ManTryToConnect  (ifloopBack, axIFace[ifLoopback].asMyCall+'-13',axIFace[ifLoopback].asMyIdent,'');
			  ManTryToConnect  (ifloopBack, axIFace[ifLoopback].asMyCall+'-11',axIFace[ifLoopback].asMyIdent,'');
			  ManTryToConnect  (ifloopBack, axIFace[ifLoopback].asMyCall+'-10',axIFace[ifLoopback].asMyIdent,'');
			  ManTryToConnect  (ifloopBack, axIFace[ifLoopback].asMyCall+'-12',axIFace[ifLoopback].asMyIdent,'');
                          END;
                    'K' : BEGIN
                          iTxCB := 1;
                          WriteLn (' K-Command');
                          WHILE (iTxCB < 50) AND (cb[iTxCB] <> Nil) DO Inc (iTxCB);
                          iRxCB := iTxCB;
                          i := 0;
			  WHILE (i<15) AND (F_ManTryToConnect_NoAR
                                              (ifloopBack,
                                               axIFace[ifLoopback].asMyIdent+'-'+FStr(i),
                                               axIFace[ifLoopback].asMyCall+'-'+FStr(MyFlexMinSSID) ,
                                               '') = NIL)
                               DO Inc(i);
			  END;
{$IFnDEF scc}
		    'L' : BEGIN
                          CASE sSendStr[3] OF
'0' : TxCtrl( SABM, ifloopBack, 'DG9EP', 'HOCH2', '', cPOLL);
'1' : TxCtrl( SABM, ifloopBack, 'HOCH2', 'DG9EP', '', cPOLL);
'2' : TxBeacon(ifloopBack, 'DF1JC','MAIL', 'DG9EP',  'test' ,cMELD);
'3' : TxBeacon(ifloopBack, 'DF1JC','M', 'DG9EP,AA',  'test' ,cMELD);
'4' : TxBeacon(ifloopBack, 'DF1JC','M', 'DG9EP,DG9EP',  'test' ,cMELD);
'5' : TxBeacon(ifloopBack, 'DF1JC','CQ', '',  'test' ,cPOLL);
{'1' :  BEGIN
       AscCall2shift ( 'TE1ST', shCall);
       EntryDest2 ( 1, shcall, 0,15,300 )  ;
       END;
'1' : TxTestInfo ( ifloopBack, 'DF1JC', 'DG9EP-10', '11111*,22222*,33333*,44444*,HOCHD*,DG9EP*,DG9EP-10', 'laber', cFINAL);
'2' : TxCtrl( SABM, ifloopBack, 'DB0WST', 'DF1JC', 'HOCHD*,DG9EP*,DG9EP', cFINAL);
'4' : ManTryToConnect  (1,'HOCH2-1', 'DF1KC' ,'');
      BEGIN
      Ax25Body2Str( 08, @caAXSEGIP, sizeof(caAXSEGIP), s );
      END;
}
'b' : BEGIN
      len := sizeof( caTxDATA);
      pm := Get_mBuf (len);
      Move (caTxDATA, pm^.pData^, len);
      pm^.inuse := len;
      pm^.ofsCtl := CalcOfsCtl ( pm );
      pm^.ifnr := 5;
      SendPaket ( pm, nil );
      END;
{
'1' : IF Connect_Test( 'df1jc v db0me') = nil then;
'2' : IF Connect_Test( 'DB0ME') = nil then;
'3' : TxBeacon(ifloopBack, 'DF1JC', 'DB0WST', 'DG9EP,DB0ME', 'test'+EOL ,cMELD);
'4' : IF Try2Connect ( ifLoopback, 'DG9EP', 'DB0IZ-9', 'DB0ME', cNOINCSSID) = NiL THEN ;
'c' : IF Try2Connect ( ifLoopback, 'HALLO', 'DB0ME', 'DG9EP-13', cNOINCSSID) = NiL THEN ;
'a' : BEGIN
      pm := Get_mBuf (0);
      TxQueue_mBuf_chain ( cb[iTxCb], Sofort, pm );
      END;
'c' : TxBeacon(ifloopBack, 'DF1JC', 'BL0BB', 'DG9EP,DB0BM',  'test'+EOL ,cMELD);
'd' : TxBeacon(ifloopBack, 'DF1JC', 'DD9JN', 'DG9EP', 'test'+ EOL ,cMELD);
'e' : TxCtrl( DM, ifloopBack, 'DF1JC', 'DB0WST', 'HOCHD*,DG9EP*,DG9EP', cFINAL);
'f' : TxTestInfo ( ifloopBack, 'DF1JC', 'DG9EP', '','testbla', cPOLL);
'g' : TxCtrl( RR, ifloopBack, 'DF1JC', 'DB0WST', 'HOCHD*,DG9EP*,DG9EP', cKOMM);
'h' : TxCtrl( UA, ifloopBack, 'DF1JC', 'DB0WST', 'HOCHD*,DG9EP*,DG9EP', cFINAL);}
                           END; {case}
                         END;
{$ENDIF}
                  {$IFnDEF SCC}
		    'S' : BEGIN
                          Assign (f,Copy (sSendStr, 4, 255));
                          Reset (f);
                          WHILE NOT EOF(F) DO
                            BEGIN
                            READLN (f,s);
                            s := s + CR;
                            TX_INFO( cb[iTxCB], SPAETER, s);
                            END;
                          TX_Trigger(pCB);
                          Close (f);
                          END;
                  {$ENDIF}

                    END;
                  END
             ELSE BEGIN
                  IF Length(sSendStr) > 254 THEN Dec( Byte(sSendStr[0]));
                  Tx_Info ( CB[iTxCB], SOFORT, sSendStr+EOL );
                  {$IFDEF SCC} WriteLn (con2); {$ENDIF}
		  END;
           sAltSendStr := sSendStr;
           sSendStr := '';
           END;
     ^A  : DisplayAlle := NOT DisplayAlle;
     ^B  : BEGIN
           IF cb[ iTxCB ]^.busy
             THEN Event_BecomeUnBusy(cb[iTxCB])
             ELSE Event_BecomeBusy(cb[iTxCB]);
           END;
     ^C  : fDestroy := 1;
     ^D  : BEGIN
	   DoDisconnect ( cb[iTxCB] );
	   END;
     ^E  : BEGIN
           ShowMonitor (Prim);  {* Monitor einschalten *}
           END;
     ^F  : BEGIN
           ShowMonitor (SEK);
	   ShowCBs;
           END;
  {*  ^G  bleibt zum Krachmachen frei *}
     ^H  : IF Length (sSendStr) > 0 THEN Dec (Byte(sSendStr[0]));
     ^I  : IF bDumpMode = dmONLYI THEN bDumpMode := dmALL
                                  ELSE bDumpMode := succ(bDumpMode);
     ^J  : sSendStr := sSendStr + EOL;
     ^K  : fPID0f0 := NOT fPID0f0;
  {* ^M  = ENTER... *}
     ^N  : BEGIN
           fDisplayFrames := NOT fDisplayFrames;
           WriteLn (EOL+'** DispMode:',fDisplayFrames);
           END;
     ^P  : BEGIN
      {* Loopbackinterface BRUTAL anmachen, als Notnagel *}
{           IF bind[5].valid THEN bind[5].fnDeInitCh(5);
           iface [5].Valid := Loop_init (5,0);
           bind[5].valid := bind[5].fnInitCh(5);
           axIFace[5].asMyIdent:= axIFace[5].asMyCall;
 }          END;
     ^R  : IF cb[iTxCB] <> NiL THEN t1Out (CB[iTxCB]);
     ^S  : fShowCB := NOT fShowCB;
     ^T  : fDumpText := NOT fDumpText;
     ^U  : BEGIN
     {$IFDEF scc}
     {$ENDIF}
{$IFDEF Diverses_zum_Testen}
{$ENDIF}
           END;
     ^V  : BEGIN
	   myCBBlocked := NOT myCBBlocked;
	   IF NOT myCBBlocked THEN
	     IF cb[iTxCB] = Nil THEN ShowCBs;
	   END;
     ^W  : BEGIN {Watchdog auslsen}
	   FillChar ( Backup, sizeof (Backup), #0);
	   Backup.magic := MAGIC;
	   li := FASTTICK+30000;
	   Watchdog;
	   asm cli END;
	   WHILE FASTTICK<li DO;
	   asm STI END;
	   WHILE TRUE DO;
	   END;
     ^X  : IF sSendStr='x' THEN RunError(42);
     ^Y  : sSendStr := '';
    {^Z  : wird fr WRITE gebraucht}
     ELSE sSendStr := sSendStr + ch;
    END;

  {$IFDEF scc} WatchDog; {$ENDIF}
  IF ch IN [^H,CR,#32..#255] THEN
    BEGIN
    SetCrtMoni (sek);
    SetTextAttr (104);
    Write (con2,ch);
    END;
  {$IFnDEF SCC} ShowCBs; {$ENDIF}
  {$ENDIF V24LIFE}
  {$IFDEF scc}  fShowCB := TRUE;  {$ENDIF}
END;

{}

  VAR i : Integer;
BEGIN
  DoRegisterPoller(ShowCBs);

 {$IFnDEF scc} {$IFDEF V24LIFE}
   SetCrtMoni (prim); SetTextAttr (15);
   SetCrtMoni (sek);  SetTextAttr (15); ;

   {$IFDEF FileDump}
   Assign (hDump,'monitor.dmp'); Rewrite (hDump);
   {$ENDIF}
 {$ENDIF V24LIFE} {$ENDIF}
END.
