UNIT FD_Div;   {* enthlt alle sprachlichen Hilfskonstrukte und *}
	       {* Routinen, die nicht ax25 / DigiWare spezifisch sind *}
{$I FD_INCL.PAS}

INTERFACE

 USES FD_Def;

 PROCEDURE Proc_RETI;
 PROCEDURE _NOP;   INLINE ($90);
 PROCEDURE _PUSHF; INLINE ($9c);
 PROCEDURE __CLI;   INLINE ($FA);      {* CLI *}
 PROCEDURE __STI;   INLINE ($FB);      {* STI *}

 PROCEDURE _DI;    INLINE ($9c/$FA);  {* PushF ; CLI *}
 PROCEDURE _EI;    INLINE ($9d);      {* PopF *}

 PROCEDURE AssignNul(VAR F: Text);
     CONST MyRandSeed : LongInt = 0;
 procedure MyRandomize;
  FUNCTION MyRandom(arg:word):word;

 PROCEDURE RevStr ( VAR s : STRING ); {* Drehe einen STRING um *}
  FUNCTION Scan4Adr ( VAR s: STRING ) : POINTER;
 PROCEDURE ScanForText ( VAR sArg, sErg : String );

 PROCEDURE AddString ( VAR s:STRING; {$IFDEF ver70} CONST {$ENDIF} s2 : STRING);
 PROCEDURE AddChar ( VAR s:STRING; c : Char);

  FUNCTION F_LeftUsing ( x,n:Word ) : STRING;   {*entspricht Str (x:n) *}
  FUNCTION F_Replace (x,y : STRING; VAR s : STRING) : BOOLEAN;
 PROCEDURE ReplaceCh (x,y : Char; VAR s : STRING);
 PROCEDURE Replace (x,y : STRING; VAR s : STRING);
 PROCEDURE DelStr ( VAR s:STRING; von,bis : Byte);

  FUNCTION LoCase ( ch : Char ) : Char;
  FUNCTION F_Upper ( s : STRING ) : STRING;
  FUNCTION F_Lower ( s : STRING ) : STRING;
 PROCEDURE Upper ( VAR s : STRING );
 PROCEDURE Lower ( VAR s : STRING );

 PROCEDURE LTrim (VAR s : STRING );  {* Entfernt alle Leerzeichen am Anfang eines STRING *}
 PROCEDURE RTrim (VAR s : STRING );  {* Entfernt alle Leerzeichen am Ende eines STRING *}
 PROCEDURE REolTrim (VAR s : STRING );

 PROCEDURE Trim (VAR s : STRING );   {* Entfernt alle Leerzeichen aus dem gesamten STRING *}
 FUNCTION  F_Trim ( s : STRING ) : STRING; {*  TRIM als Funktion *}
 FUNCTION  DelWord ( {$IFDEF ver70} CONST {$ENDIF} w : STRING; VAR s : STRING ) : BOOLEAN;
 FUNCTION  StrUsing ( {$IFDEF ver70} CONST {$ENDIF} s : STRING; n : Byte ) : STRING;
 PROCEDURE SetStrLength ( VAR s : STRING; n : Byte );
 FUNCTION  F_SetStrLength (  s : STRING;  n : Byte ) : STRING;

 FUNCTION  Linksbuendig ({$IFDEF ver70} CONST {$ENDIF}  s : STRING; n : Byte ) : STRING;
 FUNCTION  StrZentriert ( s : STRING; n : Byte ) : STRING;
 FUNCTION  StrRechtsBuendig ( {$IFDEF ver70} CONST {$ENDIF} s : STRING; n : Byte ) : STRING;
 FUNCTION  Left (  s : STRING; n : Byte ) : STRING;

 FUNCTION  IsDigit ( c : Char ) : BOOLEAN;
 FUNCTION  IsLetter ( c : Char ) : BOOLEAN;
 FUNCTION  ChkString ( VAR s : STRING ) : BOOLEAN;

 PROCEDURE TabExpand (VAR s : STRING );
 PROCEDURE TabCompress (VAR s:STRING);

 PROCEDURE String2AsciiZ (VAR s : STRING);
 FUNCTION  AsciiZ2String (p1 : Pointer) : STRING;

 FUNCTION  FStr ( x: Longint ) : STRING;
 FUNCTION  FStrReal ( x:REAL ) : STRING;
 FUNCTION  F_Using ( x : Longint;n:Word ) : STRING;   {*entspricht Str (x:n) *}
{ FUNCTION  F_liUsing ( x : LongInt; n:Byte ) : STRING;   {*entspricht Str (x:n) *}
 FUNCTION  F_UsingReal ( x:REAL; m,n : Byte ) : STRING;

 FUNCTION F_Bool ( f:BOOLEAN ) : CHAR;
 FUNCTION F_Bool2OnOff ( f:BOOLEAN ) : String;
 FUNCTION F_Val ( {$IFDEF ver70} CONST {$ENDIF} s:STRING ) : LongInt;
 FUNCTION F_ValWord ( {$IFDEF ver70} CONST {$ENDIF} s:STRING ) : Word;
 FUNCTION F_RepChar ( n : INTEGER; ch : Char ) : STRING;
 PROCEDURE RepChar (VAR s : STRING; n : INTEGER; ch : Char );
 FUNCTION nChar (c : Char; {$IFDEF ver70} CONST {$ENDIF} s: STRING ) : Byte;
 FUNCTION ExistChar (c : Char; {$IFDEF ver70} CONST {$ENDIF} s: STRING ) : BOOLEAN;

 FUNCTION StrHexML (p : Pointer; offset : BYTE ) : STRING;
 FUNCTION StrML (p : Pointer; offset : BYTE ) : STRING;
 FUNCTION WordML (p : Pointer; offset : BYTE ) : Word;

 FUNCTION BinString(Number: Byte ): STRING;
 FUNCTION HexByteString(Number: Byte): STRING;
 FUNCTION HexString    (Number: Word): STRING;
 FUNCTION HexLIString  (Number: LongInt): STRING;
 FUNCTION HexAddrString ( p: Pointer): STRING;
 FUNCTION AsHexString (p : Pointer; len : Longint; fWithAscii,fBeauty:BOOLEAN) : STRING;
 FUNCTION AsTFString (p : Pointer; len : Longint) : STRING;

 PROCEDURE SetTimeDW(Hour, Min, Second, Sec100:Word);
 PROCEDURE SetDateDW(Year, Month, Day {**, DayofWeek ***} :Word);
 FUNCTION UnixZeit (tt,mm : BYTE; jj:WORD; hh,min,ss: BYTE): Longint;
 FUNCTION UnixZeitNow: Longint;
 FUNCTION Sekunden2RelString (sek:Longint):STRING;
 FUNCTION CurrentDatum : STRING;
 FUNCTION CurrentUhrZeit (delta:shortint) : STRING;
 FUNCTION CurrentDatumUhrZeitDieBox : STRING;
 FUNCTION DiffUhrzeit (h1,m1,h2,m2 : Byte ) : WORD;

 FUNCTION UhrzeitHMS (h,m,s : Byte ) : String;
 FUNCTION DatumTMJ (t,m,j : Word ) : String;
 FUNCTION Datum (t,m,j : Word ) : STRING;
 FUNCTION DatumTTMM (t,m : Word ) : STRING;
 FUNCTION Uhrzeit (h,m : Byte ) : STRING;
 FUNCTION L_Uhrzeit (h,m,s : Byte ) : STRING;
 FUNCTION Time2StrTTMMHHMM ( x : T_TIME ) : STRING;


 FUNCTION IncP(p:POINTER;n:WORD):POINTER;
 PROCEDURE IncP1(Var p : Pointer);
 PROCEDURE IncPn(Var p : Pointer; n : Longint);
 FUNCTION SNibble2Byte (c:char) : BYTE;

  FUNCTION Min( a,b :LONGINT ) : Longint;
 PROCEDURE Tausche( pa,pb : POINTER; size:WORD);
 PROCEDURE ORself ( VAR a : BYTE; b : BYTE);
 PROCEDURE ANDself ( VAR a : BYTE; b : BYTE);
 PROCEDURE XORself ( VAR a : BYTE; b : BYTE);
 PROCEDURE MULself ( VAR a:word; b:word );
 PROCEDURE DIVself ( VAR a:word; b:word );

 PROCEDURE Sirene;



CONST
	       _Black_Black =  0;		       _Black_Blue = 16;
		_Blue_Black =  1;			_Blue_Blue = 17;
	       _Green_Black =  2;		       _Green_Blue = 18;
		_Cyan_Black =  3;			_Cyan_Blue = 19;
		 _Red_Black =  4;			 _Red_Blue = 20;
	     _Magenta_Black =  5;		     _Magenta_Blue = 21;
	       _Brown_Black =  6;		       _Brown_Blue = 22;
	   _LightGray_Black =  7;		   _LightGray_Blue = 23;
	    _DarkGray_Black =  8;		    _DarkGray_Blue = 24;
	   _LightBlue_Black =  9;		   _LightBlue_Blue = 25;
	  _LightGreen_Black = 10;		  _LightGreen_Blue = 26;
	   _LightCyan_Black = 11;		   _LightCyan_Blue = 27;
	    _LightRed_Black = 12;		    _LightRed_Blue = 28;
	_LightMagenta_Black = 13;		_LightMagenta_Blue = 29;
	      _Yellow_Black = 14;		      _Yellow_Blue = 30;
	       _White_Black = 15;		       _White_Blue = 31;


	   _Black_Green	= 32;		      _Black_Cyan = 48;
	    _Blue_Green	= 33;		       _Blue_Cyan = 49;
	   _Green_Green	= 34;		      _Green_Cyan = 50;
	    _Cyan_Green	= 35;		       _Cyan_Cyan = 51;
	     _Red_Green	= 36;			_Red_Cyan = 52;
	 _Magenta_Green	= 37;		    _Magenta_Cyan = 53;
	   _Brown_Green	= 38;		      _Brown_Cyan = 54;
       _LightGray_Green	= 39;		  _LightGray_Cyan = 55;
	_DarkGray_Green	= 40;		   _DarkGray_Cyan = 56;
       _LightBlue_Green	= 41;		  _LightBlue_Cyan = 57;
      _LightGreen_Green	= 42;		 _LightGreen_Cyan = 58;
       _LightCyan_Green	= 43;		  _LightCyan_Cyan = 59;
	_LightRed_Green	= 44;		   _LightRed_Cyan = 60;
    _LightMagenta_Green	= 45;	       _LightMagenta_Cyan = 61;
	  _Yellow_Green	= 46;		     _Yellow_Cyan = 62;
	   _White_Green	= 47;		      _White_Cyan = 63;


	   _Black_Red =	64;		   _Black_Magenta =  80;
	    _Blue_Red =	65;		   _Blue_Magenta  =  81;
	   _Green_Red =	66;		  _Green_Magenta  =  82;
	    _Cyan_Red =	67;		   _Cyan_Magenta  =  83;
	     _Red_Red =	68;		    _Red_Magenta  =  84;
	 _Magenta_Red =	69;		_Magenta_Magenta  =  85;
	   _Brown_Red =	70;		  _Brown_Magenta  =  86;
       _LightGray_Red =	71;	      _LightGray_Magenta  =  87;
	_DarkGray_Red =	72;	       _DarkGray_Magenta  =  88;
       _LightBlue_Red =	73;	      _LightBlue_Magenta  =  89;
      _LightGreen_Red =	74;	     _LightGreen_Magenta  =  90;
       _LightCyan_Red =	75;	      _LightCyan_Magenta  =  91;
	_LightRed_Red =	76;	       _LightRed_Magenta  =  92;
    _LightMagenta_Red =	77;	   _LightMagenta_Magenta  =  93;
	  _Yellow_Red =	78;		 _Yellow_Magenta  =  94;
	   _White_Red =	79;		  _White_Magenta  =  95;


	   _Black_Brown	=  96;		   _Black_LightGray = 112;
	    _Blue_Brown	=  97;		    _Blue_LightGray = 113;
	   _Green_Brown	=  98;		   _Green_LightGray = 114;
	    _Cyan_Brown	=  99;		    _Cyan_LightGray = 115;
	     _Red_Brown	= 100;		     _Red_LightGray = 116;
	 _Magenta_Brown	= 101;		 _Magenta_LightGray = 117;
	   _Brown_Brown	= 102;		   _Brown_LightGray = 118;
       _LightGray_Brown	= 103;	       _LightGray_LightGray = 119;
	_DarkGray_Brown	= 104;		_DarkGray_LightGray = 120;
       _LightBlue_Brown	= 105;	       _LightBlue_LightGray = 121;
      _LightGreen_Brown	= 106;	      _LightGreen_LightGray = 122;
       _LightCyan_Brown	= 107;	       _LightCyan_LightGray = 123;
	_LightRed_Brown	= 108;		_LightRed_LightGray = 124;
    _LightMagenta_Brown	= 109;	    _LightMagenta_LightGray = 125;
	  _Yellow_Brown	= 110;		  _Yellow_LightGray = 126;
	   _White_Brown	= 111;		   _White_LightGray = 127;

			   _Black_White	 = 112;
			    _Blue_White	   = 113;
			   _Green_White	   = 114;
			    _Cyan_White	   = 115;
			     _Red_White	   = 116;
			 _Magenta_White	   = 117;
			   _Brown_White	   = 118;
		       _LightGray_White	   = 119;
			_DarkGray_White	   = 120;
		       _LightBlue_White	   = 121;
		      _LightGreen_White	   = 122;
		       _LightCyan_White	   = 123;
			_LightRed_White	   = 124;
		    _LightMagenta_White	   = 125;
			  _Yellow_White	   = 126;
			   _White_White	   = 127;

key_ctrl_a  =  ^a;	    key_alt_a  =  #30;	   key_alt_1	 =  #120;
key_ctrl_b  =  ^b;	    key_alt_b  =  #48;	   key_alt_2	 =  #121;
key_ctrl_c  =  ^c;	    key_alt_c  =  #46;	   key_alt_3	 =  #122;
key_ctrl_d  =  ^d;	    key_alt_d  =  #32;	   key_alt_4	 =  #123;
key_ctrl_e  =  ^e; 	    key_alt_e  =  #18;      key_alt_5	 =  #124; 
key_ctrl_f  =  ^f; 	    key_alt_f  =  #33;      key_alt_6	 =  #125; 
key_ctrl_g  =  ^g; 	    key_alt_g  =  #34;
key_ctrl_h  =  ^h; 	    key_alt_h  =  #35;      key_alt_7	 =  #126;
key_ctrl_i  =  ^i; 	    key_alt_i  =  #23;      key_alt_8	 =  #127; 
key_ctrl_j  =  ^j; 	    key_alt_j  =  #36;      key_alt_9	 =  #128; 
key_ctrl_k  =  ^k; 	    key_alt_k  =  #37;      key_alt_0	 =  #129; 
key_ctrl_l  =  ^l; 	    key_alt_l  =  #38;
key_ctrl_m  =  ^m; 	    key_alt_m  =  #50;
key_ctrl_n  =  ^n; 	    key_alt_n  =  #49;
key_ctrl_o  =  ^o; 	    key_alt_o  =  #24;
key_ctrl_p  =  ^p; 	    key_alt_p  =  #25;
key_ctrl_q  =  ^q; 	    key_alt_q  =  #16; 
key_ctrl_r  =  ^r; 	    key_alt_r  =  #19; 
key_ctrl_s  =  ^s; 	    key_alt_s  =  #31;
key_ctrl_t  =  ^t; 	    key_alt_t  =  #20; 
key_ctrl_u  =  ^u; 	    key_alt_u  =  #22; 
key_ctrl_v  =  ^v; 	    key_alt_v  =  #47;
key_ctrl_w  =  ^w; 	    key_alt_w  =  #17; 
key_ctrl_x  =  ^x; 	    key_alt_x  =  #45;
key_ctrl_y  =  ^y; 	    key_alt_y  =  #21;
key_ctrl_z  =  ^z; 	    key_alt_z  =  #44;

key_f1 =  #59;      key_shift_f1     =	#84;
key_f2 =  #60;      key_shift_f2     =	#85; 
key_f3 =  #61;      key_shift_f3     =	#86; 
key_f4 =  #62;      key_shift_f4     =	#87;
key_f5 =  #63;      key_shift_f5     =	#88; 
key_f6 =  #64;      key_shift_f6     =	#89; 
key_f7 =  #65;      key_shift_f7     =	#90;
key_f8 =  #66;      key_shift_f8     =	#91; 
key_f9 =  #67;      key_shift_f9     =	#92;
key_f10=  #68;      key_shift_f10    =	#93;

key_f11=  #133;     key_shift_f11    =	#135;
key_f12=  #134;     key_shift_f12    =	#136;

key_ctrl_f1 =  #94;  	  key_alt_f1	 =  #104;
key_ctrl_f2 =  #95;  	  key_alt_f2	 =  #105;
key_ctrl_f3 =  #96;  	  key_alt_f3	 =  #106;
key_ctrl_f4 =  #97;  	  key_alt_f4	 =  #107;
key_ctrl_f5 =  #98;  	  key_alt_f5	 =  #108;
key_ctrl_f6 =  #99;  	  key_alt_f6	 =  #109;
key_ctrl_f7 =  #100; 	  key_alt_f7	 =  #110;
key_ctrl_f8 =  #101; 	  key_alt_f8	 =  #111;
key_ctrl_f9 =  #102; 	  key_alt_f9	 =  #112;
key_ctrl_f10=  #103; 	  key_alt_f10	 =  #113;

key_ctrl_f11=  #137; 	  key_alt_f11	 =  #139;
key_ctrl_f12=  #138; 	  key_alt_f12	 =  #140;

key_up	       =  #72;
key_down       =  #80;
key_links      =  #75;   key_ctrl_links    =  #115;
key_rechts     =  #77;   key_ctrl_rechts   =  #116;

key_ins        =  #82;	    key_ctrl_ins = #146;
key_del        =  #83;

key_home       =  #71;    key_ctrl_home = #119;
key_end        =  #79;    key_ctrl_end =  #117;
key_pgdn       =  #81;    key_ctrl_pgup = #132;
key_pgup       =  #73;    key_ctrl_pgdn = #118;

key_cr	       =  #13;
key_enter      =  #13;    key_ctrl_enter = #10;
key_bs	       =  #08;    key_ctrl_bs    = #127;
key_tab        =  #09;    key_shift_tab  = #15;
key_esc        =  #27;


{}

IMPLEMENTATION
USES FD_Log,
     {$IFDEF SCC} FD_TNC
     {$ELSE}      FD_Crt, Dos
     {$ENDIF}
     ;
{}

{$F+}PROCEDURE Proc_RETI; ASSEMBLER;
ASM
  STC
  IRET
END;
{$F-}

FUNCTION NulOutput( VAR F: TextRec ): INTEGER;  FAR;  {* puffer voll *}
BEGIN
  NULOutput := 0;
  f.bufpos := 0;
END;

FUNCTION NULClose (VAR F: TextRec): INTEGER;  FAR;
BEGIN
  NULClose:=0;
END;


FUNCTION NULOpen(VAR F: TextRec): INTEGER;  FAR;
BEGIN
  WITH F DO
    BEGIN
    IF Mode=fmInput
      THEN NULOpen := 1
      ELSE BEGIN
	   Mode:=fmOutput;
	   InOutFunc:=@NULOutput;
	   FlushFunc:=@NULOutput;
	   CloseFunc:=@NULClose;
	   Bufpos := 0;
	   bufptr := @Buffer;
	   bufSize := SizeOf(Buffer);
	   NULOpen:=0;
	   END;
    END;
END;


PROCEDURE AssignNul(VAR F: Text);
BEGIN
  WITH TextRec(F) DO
    BEGIN
    Handle:=$FFF1;
    Name[0] := #0;
    Mode:=fmClosed;
    OpenFunc:=@NULOpen;
    END;
END;

PROCEDURE MyRandomize;
{* kw 7.6.98 *}
BEGIN
  Randomize;
  MyRandSeed := RandSeed;
END;

{* Eigener Random Generator - Der von Pascal 6 und 7 unterscheiden sich voneineander *}
FUNCTION MyRandom(arg:word):word;
BEGIN
  {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
  {$IFDEF Ver70} {$IFOPT Q+} {$Q-} {$DEFINE Qplus} {$ENDIF} {$ENDIF}
  MyRandSeed := $8088405 * MyRandSeed + 1;
  {$IFDEF Rplus} {$R+} {$UNDEF Rplus} {$ENDIF}
  {$IFDEF Qplus} {$Q+} {$UNDEF Qplus} {$ENDIF}
   ASM
     mov    ax, word ptr MyRandSeed+2
     xor    dx,dx
     div    arg
     mov    @Result,dx
   END;
END;

FUNCTION IncP(p:POINTER;n:WORD):POINTER;
BEGIN
 Inc(word(p),n);
 IncP := p;
END;

PROCEDURE IncP1(Var p : Pointer);
BEGIN
  Inc(tp_byte(p));
END;

PROCEDURE IncPn(Var p : Pointer; n : Longint);
BEGIN
  Inc(tp_byte(p),n);
END;

FUNCTION SNibble2Byte (c:char) : BYTE;
BEGIN
  {$R-}
  IF c>'9' THEN SNibble2Byte := ord(upcase(c))-55
           ELSE SNibble2Byte := ord(upcase(c))-48;
END;


FUNCTION Min( a,b :LONGINT ) : Longint;
BEGIN
   IF a<b THEN min := a
          ELSE min := b;
END;



PROCEDURE Tausche( pa,pb : POINTER; size:WORD);
 {* generische Tauschroutine fr jede Art von Daten  Tausche(@a,@b,sizeof(a));*}
 VAR bz    : BYTE;
     i     : WORD;
BEGIN
  FOR i := 1 TO size DO
    BEGIN
    bz := Byte(pa^);
    byte(pa^) := byte(pb^);
    byte(pb^) := bz;
    Inc(word(pa));
    Inc(word(pb));
    END;
END;

{* An alle C-Fans: Bitte nicht grinsen! =:-) *}
PROCEDURE ORself ( VAR a : BYTE; b : BYTE);
BEGIN
  a := a OR b;
END;
PROCEDURE ANDself ( VAR a : BYTE; b : BYTE);
BEGIN
  a := a AND b;
END;
PROCEDURE XORself ( VAR a : BYTE; b : BYTE);
BEGIN
  a := a XOR b;
END;
PROCEDURE MULself ( VAR a:word; b:word );
BEGIN
  a := a * b;
END;
PROCEDURE DIVself ( VAR a:word; b:word );
BEGIN
  a := a DIV b;
END;


{}

PROCEDURE ScanForText ( VAR sArg, sErg : String );
{* liest das nchste Argument als Text (mit " als MetaZeichen) *}
{* wird aus sArg geloescht und zurckgegeben *}
  VAR i      : BYTE;
      ende   : BOOLEAN;
      SkipSpace : BOOLEAN;
BEGIN
  sErg := '';  i := 1;
  WHILE  (sArg[i] = ' ') AND ( i < Length(sArg) ) DO Inc (i);
  {* ab sArg[i] steht das nchste Argument oder Stringende *}
  skipSpace := (sArg[i] = '"');
  IF skipSpace THEN Inc (i);
  ende := FALSE;
  WHILE (NOT ende) AND ( i <= Length(sArg) ) DO
    BEGIN
    IF skipSpace THEN ende :=  sArg[i] = '"'
                 ELSE ende :=  sArg[i] <= ' ';
    IF NOT ende THEN BEGIN
                     AddChar(sErg,sArg[i]);
                     Inc (i);
                     END;
    END;
  Delete (sArg, 1,i);
END;

FUNCTION Scan4Adr ( VAR s: STRING ) : POINTER;
 {* Sucht s nach "oooo:ssss" ab, und gibt es zurck. kann auch o s sein *}
  VAR zw,i,n : BYTE;
      segm,
      offset : LONGINT;
BEGIN {* $OPT Algorithmus *}
  segm:=0;  i := 1;  {* Segment *}
  WHILE (i<=length (s)) AND
        (i<=4) AND   {* SSSS:OOOO *}
        (s[i] IN ['0'..'9','A'..'F'])  DO
    BEGIN
    zw := byte(s[i])-byte('0');
    IF zw>9 THEN Dec (zw,7);
    segm := $10*segm+zw;
    Inc (i);
    END;
  offset:=0; n :=1; {* Offset *}
  Inc (i);
  WHILE (i<=length (s)) AND
        (n<=4) AND   {* SSSS:OOOO *}
        (s[i] IN ['0'..'9','A'..'F']) DO
    BEGIN
    zw := byte(s[i])-byte('0');
    IF zw >9 THEN Dec (zw,7);
    offset := $10*offset+zw;
    Inc (i); inc(n);
    END;
  Delete (s,1,i-1);
  Scan4Adr := Ptr (segm,offset);
END;


FUNCTION F_LeftUsing ( x,n:Word ) : STRING;   {*entspricht Linksbndig Str (x:n) *}
   VAR z : STRING;
BEGIN
  Str (x,z);
  WHILE Length(z) < n DO AddChar(z,' ');
  F_LeftUsing := z;
END;

PROCEDURE ReplaceCh (x,y : Char; VAR s : STRING);
  VAR bPos : Byte;
BEGIN
  bPos := Pos(x,s);
  IF bPos > 0 THEN s[bPos] := y;
END;

PROCEDURE Replace (x,y : STRING; VAR s : STRING);
  VAR bPos : Byte;
BEGIN
  bPos := Pos(x, s);
  IF bPos > 0 THEN
    BEGIN
    Delete ( s, bPos, Length(x) );
    Insert ( y, s, bPos );
    END;
END;


FUNCTION F_Replace (x,y : STRING; VAR s : STRING) : BOOLEAN;
  VAR bPos : Byte;
BEGIN
  bPos := Pos ( x, s);
  F_Replace := bPos <> 0;
  IF bPos <> 0 THEN BEGIN
                    Delete ( s, bPos, Length(x) );
                    Insert ( y, s, bPos );
                    END;
END;

PROCEDURE DelStr ( VAR s:STRING; von,bis : Byte);
BEGIN
  IF von<=bis THEN Delete (s,von,bis-von+1);
END;

PROCEDURE RevStr ( VAR s : STRING );
  VAR i : BYTE;
      sn : STRING;
BEGIN
  sn := '';
  FOR i := 1 TO Length (s) DO 
    sn := s[i] + sn;
  s := sn;
END;


PROCEDURE AddChar ( VAR s:STRING; c : Char);
  VAR len : BYTE ABSOLUTE s;
BEGIN
  IF len<255 THEN
    BEGIN
    Inc(Len);
    s[len] := c;
    END;
END;

PROCEDURE AddString ( VAR s:STRING;
     {$IFDEF ver70} CONST {$ENDIF} s2 : STRING);
BEGIN
  s := s + s2; {* $OPT *}
END;
{$IFDEF is_besser 20% schneller -> noch ma testen....}
  VAR von,bis : WORD;
BEGIN
  von := length(s);
  bis := von+length(s2);
  IF bis>255 THEN bis:=255;
  Move (s2[1], s[von+1], bis-von+1);
  s[0] := char(bis);   gefhrlich! Wenn s beim Aufruf STRING[nn] ist
END;
{$ENDIF}


FUNCTION ChkString ( VAR s : STRING ) : BOOLEAN;
  CONST stc = ['A'..']','_','a'..'~','','','','','','',''];
  VAR   i : BYTE;
        ende : BOOLEAN;
BEGIN
  i := 1; ende := FALSE;
  WHILE (i<=length(s)) AND ( NOT ende) DO
    BEGIN
    IF NOT (s[i] IN stc) THEN ende := TRUE;
    Inc(i);
    END;
  chkString := NOT ende;
END;


{}

PROCEDURE Wort_links ({$IFDEF ver70} CONST {$ENDIF}  s : STRING;  VAR p : Byte );
 {* sucht im STRING s von Position p aus das erste Wortende bzw. wenn
  * in einem Wort schon drin, dann den Wortanfang und gibt die
  * Position in p zurck *}
BEGIN
  IF s[p] = ' ' THEN  WHILE ( p > 1 ) AND ( s [p] = ' ' ) DO    Dec (p)
                ELSE  WHILE ( p > 1 ) AND ( s [p] <> ' ') DO    Dec (p);
END;

PROCEDURE Wort_rechts ({$IFDEF ver70} CONST {$ENDIF}  s : STRING;  VAR p : Byte );
BEGIN
  WHILE ( p < Length(s) ) AND ( s [p] = ' ') DO    Inc (p);
  WHILE ( p < Length(s) ) AND ( s [p] <> ' ') DO   Inc (p);
END;

FUNCTION isDigit ( c : Char ) : BOOLEAN;
BEGIN
  isDigit :=  ( c >= '0' ) AND (c <= '9');
END;

FUNCTION isLetter ( c : Char ) : BOOLEAN;
BEGIN
  isLetter:= (( c >= 'A' ) AND (c <= 'Z') )
	  OR (( c >= 'a' ) AND (c <= 'z') );
END;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

PROCEDURE LTrim (VAR s : STRING );
{* Entfernt alle Leerzeichen am Anfang eines STRING *}
  VAR i : BYTE;
BEGIN
  i := 1;
  {* Leerzeichen zhlen *}
  WHILE (s[i] = ' ') AND ( i<Length(s) ) DO Inc(i);
  IF i>1 THEN BEGIN
              Move( s[i],s[1], length(s)-i+1 );
              byte(s[0]) := length(s)-i+1;
              {* Oder Delete(s,1,i) *}
              END;
{* Diese ursprngliche Version ist ca. 3 - 8 mal langsamer!:      *}
{* WHILE_ (s[1] = ' ') AND ( Length(s) >= 1 ) DO Delete (s,1,1); *}
END;

PROCEDURE RTrim (VAR s : STRING );
{* Entfernt alle Leerzeichen am Ende eines STRING *}
BEGIN
  WHILE (s[Length(s)]=' ') AND (Length(s)>0) DO
    Dec (s[0]); {* Schneller gehts wohl kaum *}
END;
PROCEDURE REolTrim (VAR s : STRING );
{* Entfernt alle Leerzeichen am Ende eines STRING, sofern am Ende der *}
{* Zeile mindestens ein EOL ist. Die EOL werden nicht beachtet, aber  *}
{* beibehalten *}
  VAR i,nEoL : BYTE;
BEGIN
  nEol := 0;
  WHILE (s[Length(s)]=EOL) AND (Length(s)>0) DO
    BEGIN {* EOL ganz hinten zhlen + entfernen *}
    Dec (s[0]); {* Schneller gehts wohl kaum *}
    Inc (nEOL);
    END;
  IF nEol = 0 THEN Exit;
  WHILE (s[Length(s)]=' ') AND (Length(s)>0) DO
    Dec (s[0]);
  FOR i := 1 TO nEol DO
    BEGIN {* EOL wieder dranhngen *}
    Inc (s[0]); {* Schneller gehts wohl kaum *}
    s[byte(s[0])] := EOL;
    END;
END;

PROCEDURE Trim (VAR s : STRING );
{* Entfernt alle Leerzeichen aus dem STRING *}
  VAR i,j : Byte;
BEGIN
  i := 1;  j := 1; 
  FOR i := 1 TO Length (s) DO
     IF s [i] <> ' ' THEN BEGIN
			  s[j] := s[i]; 
			  Inc (j);
			  END; 
  Byte(s[0]) := j-1;
END;
FUNCTION f_Trim ( s : STRING ) : STRING;
  VAR i,j : Byte;
BEGIN
  i := 1;  j := 1; 
  FOR i := 1 TO Length (s) DO
     IF s [i] <> ' ' THEN BEGIN
			  s[j] := s[i]; 
			  Inc (j);
			  END; 
  Byte(s[0]) := j-1;
  f_Trim := s; 
END;




FUNCTION DelWord ( {$IFDEF ver70} CONST {$ENDIF} w : STRING;  VAR s : STRING ) : BOOLEAN;
  VAR z : Byte;
BEGIN  {* Wenn das "wort" w in S auftaucht lsche es *}
  z := Pos (w,s);
  IF z > 0 THEN Delete (s,z,length(w));
  DelWord := z > 0;
END;


FUNCTION f_RepChar ( n : INTEGER; ch : Char ) : STRING;
  VAR z : STRING;
BEGIN
  z := '';
  IF n > 0 THEN
    BEGIN
    FillChar( z[1], n, ch);
    Byte(z[0]) := n;
    END;
  F_Repchar := z;
END;

PROCEDURE RepChar (VAR s : STRING; n : INTEGER; ch : Char );
BEGIN
  IF n > 0
    THEN BEGIN
         FillChar( s[1], n, ch);
         Byte(s[0]) := n;
         END
    ELSE Byte(s[0]) := 0;
END;




FUNCTION nChar (c : Char; {$IFDEF ver70} CONST {$ENDIF} s: STRING ) : Byte;
  VAR i :INTEGER;
      n : Byte;
BEGIN
 n := 0;
 FOR i := 1 TO Length (s) DO
   IF c = s[i] THEN Inc(n);
 nchar := n;
END;


FUNCTION ExistChar (c : Char; {$IFDEF ver70} CONST {$ENDIF} s: STRING ) : BOOLEAN;
  VAR i:INTEGER;
BEGIN
  IF Length(s) = 0
    THEN EXISTChar := FALSE
    ELSE BEGIN
         i := 1;
	 WHILE (s[i]<>c) AND (i < Length (s)) DO Inc (i);
	 ExistChar := (s[i]=c);
	 END;
END;


FUNCTION StrUsing ( {$IFDEF ver70} CONST {$ENDIF} s : STRING;  n : Byte ) : STRING;
  {* Setzt die Stringlnge garantiert auf GENAU n Zeichen *}
BEGIN
 IF Length (s) < n THEN StrUsing := s + F_RepChar (n-length(s), ' ')
		   ELSE StrUsing := Copy (s,1,n);
END;


PROCEDURE SetStrLength ( VAR s : STRING;  n : Byte );
  {* Setzt die Stringlnge auf MINDESTENS n Zeichen *}
BEGIN
 IF Length (s) < n THEN AddString(s,F_RepChar ( n-length(s), ' ') );
END;

FUNCTION F_SetStrLength (  s : STRING;  n : Byte ) : STRING;
  {* Setzt die Stringlnge auf MINDESTENS n Zeichen *}
BEGIN
 IF Length (s) < n THEN AddString(s, F_RepChar ( n-length(s), ' ') );
 F_SetStrLength := s;
END;


FUNCTION Left ( s : STRING;  n : Byte ) : STRING;
BEGIN
  IF Length (s) > n THEN s[0] := Char (n);
  Left := s;
END;


FUNCTION Linksbuendig ( {$IFDEF ver70} CONST {$ENDIF} s : STRING; n : Byte ) : STRING;
BEGIN
  Linksbuendig := s + F_RepChar ( n-length (s), ' ' );
END;

FUNCTION StrZentriert ( s : STRING; n : Byte ) : STRING;
  VAR z : STRING;
BEGIN
  RepChar ( z, (n - Length (s)) DIV 2 , ' ' );
  StrZentriert := z + s + z;
END;

FUNCTION StrRechtsBuendig ( {$IFDEF ver70} CONST {$ENDIF} s : STRING; n : Byte ) : STRING;
  VAR z : STRING;
BEGIN
  RepChar ( z, n - Length (s) , ' ' );
  StrRechtsBuendig := z + s;
END;

PROCEDURE TabExpand (VAR s:STRING);
 {* ersetzt vorhanden TAB-Zeichen durch max. 8 Spc *}
  VAR i : Byte;
BEGIN
  REPEAT
    i := Pos ( TAB, s );
    IF i > 0 THEN BEGIN
		  s [i] := ' ';
		  IF i mod 8 <> 0 THEN Insert ( F_RepChar ( 8-(i mod 8), ' '), s, i );
		  END;
  UNTIL i = 0;
END;


PROCEDURE TabCompress (VAR s:STRING);
 {* ersetzt vorhanden Spc evt durch TAB-Zeichen *}
  VAR ii,io,nSpc,spcPos : Byte;
BEGIN
io := 1;
nSpc := 0; spcPos:= 0;
FOR ii := 1 TO Length (s) DO  {* Extravariable ist nicht ntig: Lngenbyte wird ja nicht angetastet *}
  BEGIN
  IF s[ii] = ' '
    THEN BEGIN
         IF nSpc = 0 THEN spcPos := io;
         Inc (nSpc);
         END
    ELSE BEGIN
         nSpc := 0;
         END;
  IF (ii MOD 8 = 0) AND (nSpc > 0)
    THEN BEGIN {* TAB einsetzen *}
         io := SpcPos;
	 s [io] := TAB;
	 nSpc := 0;
	 END
    ELSE BEGIN {* Zeichen kopieren *}
	 s[io] := s[ii];
	 END;
  Inc (io);
  END;
  s[0] := Char (io-1);
END;


FUNCTION FStr ( x:Longint ) : STRING;
  VAR z : STRING;
BEGIN
  Str(x,z);
  Trim (z);
  FStr := z;
END;
{$IFDEF zeithaben}
    Grauenhaft. Anstze fr Optimierung:
    1. Str nicht verwenden. Da der Typ Word fest ist, braucht man weder
       negative noch Real zu brcksichtigen. Einfache Schleife  la DIV 10
       reicht. Dann kann auch TRIM wegfallen.
    2. Direkt in das Funktionergebniss reinschreiben per Pointer:
    function xx(VAR s : string):STRING; far;
     VAR i : BYTE;
         p : POINTER;
BEGIN
  ASM
    LES  DI,[bp+8]      ; +10 bei FAR :-(
    MOV  word ptr p+2,es
    MOV  word ptr p,  di
  END;
  byte(p^) := byte(s[0]);
  FOR i := 1 TO length(s) DO
    BEGIN
    Inc(Word(p));
    char(p^) := ...;
    END;
END;
{$ENDIF}
 

{FUNCTION F_liStr ( x:longint ) : STRING;
  VAR z : STRING;
BEGIN
  Str (x,z);
  Trim (z);
  f_liStr := z;
END;}

FUNCTION FStrReal ( x:REAL ) : STRING;
 VAR z : STRING;
BEGIN
 Str (x:20:8,z);
 Trim (z);
 WHILE z[1] = '0' DO Delete (z,1,1);
 WHILE z[length(z)] = '0' DO Dec ( Byte(z[0]) );
 fStrReal := z;
END;

FUNCTION F_Using ( x : Longint; n:Word ) : STRING;   {*entspricht Str (x:n) *}
  VAR z : STRING;
BEGIN
  Str (x:n,z);
  F_Using := z;
END;



FUNCTION F_UsingReal ( x:REAL; m,n : Byte ) : STRING;
  VAR z : STRING;
BEGIN
  Str (x:m:n,z);
  f_UsingReal := z;
END;


FUNCTION F_Val ( {$IFDEF ver70} CONST {$ENDIF} s:STRING ) : LongInt;
  VAR z     : LongInt;
      error : INTEGER;
BEGIN
  Val (s,z,error);
  f_Val := z;
END;

FUNCTION F_Bool ( f:BOOLEAN ) : CHAR;
BEGIN
  IF f THEN f_Bool := '1'
       ELSE f_Bool := '0';
END;

FUNCTION F_Bool2OnOff ( f:BOOLEAN ) : String;
BEGIN
  IF f THEN f_Bool2OnOff := 'on'
       ELSE f_Bool2OnOff := 'off';
END;


FUNCTION F_ValWord ( {$IFDEF ver70} CONST {$ENDIF} s:STRING ) : Word;
   VAR     l : LongInt;
       error : INTEGER;
BEGIN
  Val (s,l,error);
  IF (l > 65535) OR (l < 0 )
    THEN f_ValWord := 0
    ELSE f_ValWord := l;
END;


PROCEDURE String2AsciiZ (VAR s : STRING);
  VAR i : Byte;
BEGIN
  FOR i := 0 TO Length (s) - 1 DO
    s[i] := s[i+1];
  s [i+1] := #0;
END;

FUNCTION AsciiZ2String (p1 : Pointer) : STRING;
  VAR i : Byte;
      s : STRING;
      p : ^t_chArray; {* Dieser Typ ist in DEFS als grtmglichstes CHAR-ARRAY definiert *}
BEGIN
  s := ''; p := p1; i := 0;
  WHILE (i<255) AND (p^[i] <> #0) DO
    BEGIN
    s:=s+p^[i];
    Inc(i);
    END;
  AsciiZ2String := s;
END; 


FUNCTION LoCase ( ch : Char ) : Char;
BEGIN
IF ch IN ['A'..'Z'] THEN LoCase := Char( Byte(ch) + 32)
		    ELSE LoCase := ch;
END;


FUNCTION F_Upper ( s : STRING ) : STRING;
 {* Diese Lsung ist fast doppelt so schnell als UpCase *}
  VAR i : Byte;
      c : CHAR;
BEGIN
  FOR i := 1 TO Length (s) DO
    BEGIN
    c := s[i];
    IF (ord(c) >= ord('a')) AND (ord(c) <= ord('z'))
      THEN s[i] := char(ord(c) - 32)
      ELSE CASE c OF
             '' : s[i] := '';
             '' : s[i] := '';
             '' : s[i] := '';
           END;
    END;
  f_upper := s;
END;

PROCEDURE Upper ( VAR s : STRING );
  VAR i : Byte;
      c : CHAR;
BEGIN
  FOR i := 1 TO Length (s) DO
    BEGIN
    c := s[i];
    IF (ord(c) >= ord('a')) AND (ord(c) <= ord('z'))
      THEN s[i] := char(ord(c) - 32)
      ELSE CASE c OF
             '' : s[i] := '';
             '' : s[i] := '';
             '' : s[i] := '';
           END;
    END;
END;


PROCEDURE Lower ( VAR s : STRING );
  VAR I : Byte;
BEGIN
FOR i := 1 TO Length (s) DO
    CASE s[i] OF
      '' : s[i] := ''; 
      '' : s[i] := '';
      '' : s[i] := ''; 
      ELSE  s[i] := locase (s[i]);
    END;
END;

FUNCTION F_Lower ( s : STRING ) : STRING;
VAR I : Byte;
BEGIN
FOR i := 1 TO Length (s) DO
    CASE s[i] OF
      '' : s[i] := '';
      '' : s[i] := '';
      '' : s[i] := '';
      ELSE  s[i] := locase (s[i]);
    END;
  f_lower := s;
END;


{}


FUNCTION StrHexML (p : Pointer; offset : BYTE ) : STRING;
BEGIN
  Inc (word(p),offset-1);
  strHexML := HexString ( Swap(Word(p^)) );
END;

FUNCTION StrML (p : Pointer; offset : BYTE ) : STRING;
BEGIN
  Inc (Word(p),offset-1);
  strML := FStr ( Swap(Word(p^)) );
END;

FUNCTION WordML (p : Pointer; offset : BYTE ) : Word;
BEGIN
  Inc (Word(p),offset-1);
  WordML := Swap(Word(p^));
END;




FUNCTION HexChar(Number: Word): Char;
BEGIN
  IF Number<10 THEN HexChar:=Char(Number+48)
	       ELSE HexChar:=Char(Number+55);
END; { Hex_Char }


FUNCTION HexString(Number: Word): STRING;
 {* Konvertiert den bergebenen Wert (Typ Word) in einen STRING mit vier*}
 {* Hexadezimalzeichen (und ntigenfalls fhrenden Nullen) *}
  VAR s: STRING;
BEGIN
  s:=HexChar( (Number shr 1) div 2048);
  Number:=( ((Number shr 1) mod 2048) shl 1)+ (Number and 1);
  s:=s+HexChar(Number div 256);
  Number:=Number mod 256;
  s:=s+HexChar(Number div 16);
  Number:=Number mod 16;
  s:=s+HexChar(Number);
  HexString:=S{+'h'};
END; { Hex_String }

FUNCTION HexLIString(Number: LongInt): STRING;
 {* Konvertiert den bergebenen Wert (Typ LONGINT) in einen STRING mit
  * Hexadezimalzeichen (und ntigenfalls fhrenden Nullen) *}
BEGIN
  HexLIString:= HexString(Word(Number DIV 65536) ) + HexString (word(Number MOD 65536 ));
END;

FUNCTION HexByteString(Number: Byte): STRING;
BEGIN
  HexByteString := HexChar(Number div 16) + HexChar(Number mod 16) {+'h'};
END;

FUNCTION HexAddrString( p : Pointer): STRING;
 {* Konvertiert den in p bergebenen Wert in einen STRING in *}
 {* Hexa-AdresssFormat (ssss:oooo) *}
{ VAR s: STRING; }
BEGIN
  HexAddrString:= HexString ( l2w(p).Seg ) +':'+ HexString ( l2w(p).Ofs );
END;

FUNCTION BinString(Number: Byte): STRING;
VAR s : STRING;
    i : Byte;
BEGIN
  s:='';
  FOR i := 0 TO 7 DO
    BEGIN
    s := Char(number MOD 2+byte('0')) + s;
    number := number DIV 2;
    END;
BinString:= S + 'b';
END;


FUNCTION AsHexString (p : Pointer; len : Longint; fWithAscii,fBeauty:BOOLEAN) : STRING;
  VAR i : WORD;
      sRes,sAscii : STRING;
BEGIN
  sRes := '';
  sAscii := '';
  FOR i := 1 TO len do
    BEGIN
    AddString( sRes, HexByteString(BYTE (p^)) + ' ' );
    IF fWithAscii THEN
      BEGIN
      IF byte(p^) >= 32 THEN AddChar(sAscii,char(p^))
                        ELSE AddChar(sAscii,'.');
      END;
    IF i MOD 16 = 0
      THEN BEGIN
           IF fWithAscii THEN AddString( sRes,'  '+sAscii);
           sAscii := '';
           AddChar(sRes,EOL);
           END
      ELSE IF fBeauty AND (i MOD 8 = 0) THEN
             BEGIN
             AddChar(sAscii,' ');
             AddString(sRes,'  ');
             END;

    Inc (word (p));
    END;
  IF fWithAscii THEN AddString(sRes,'  '+sAscii);
  AsHexString := sRes;
END;


FUNCTION AsTFString (p : Pointer; len : Longint) : STRING;
{* Gibt den Speicher ab p^ als String zurck. Ctrl-Zeichen werden
 * mit vorangestellten ^ zurckgegeben (wie bei TheFirmware) *}
  VAR i : WORD;
      sRes : STRING;
BEGIN
  sRes := '';
  FOR i := 1 TO len do
    BEGIN
    IF BYTE (p^)>31 THEN AddString( sRes, char(p^) )
                    ELSE AddString( sRes, '^'+ char( 64+ord( BYTE(p^) )) );
    Inc (word (p));
    END;
  AsTFString := sRes;
END;



{}
CONST cDaysInYear : ARRAY [1..12] OF WORD = (0,31,59,90,120,151,181,212,243,273,304,334);
      cTage010170=25568;


FUNCTION UnixZeit (tt,mm : BYTE; jj:WORD; hh,min,ss: BYTE): Longint;
{* Wandle eine diskrete Zeitangabe (TTMMJJHHMMSS) in einen Long um (sekunden
 * seit 1.1.70 *}
  VAR tageSeit1901 : LongInt;
BEGIN
  IF JJ>1900 THEN jj := jj-1900;
  tageSeit1901 := tt
                + cDaysInYear[mm] + byte(jj MOD 4 = 1)
                + jj * 365 + (jj-1) DIV 4;
  UnixZeit :=  (tageseit1901-cTage010170) * 86400
               +            longint( hh) *  3600
               +            longint(min) *    60
               +                              ss;
END;


CONST slowOffset : Longint = -1;

FUNCTION UnixZeitNow: Longint;
  VAR yy,mm,dd,ww, h,m,s,d : Word;
BEGIN
  IF slowOffset = -1 THEN
    BEGIN
    GetDate(yy,mm,dd,ww);  GetTime(H,m,s,d);
    slowOffset := UnixZeit (dd,mm,yy,h,m,s) - slowtick DIV 2;
    END;
  UnixZeitNow := slowOffset+(SlowTick DIV 2);
END;


FUNCTION DiffUhrzeit (h1,m1,h2,m2 : Byte ) : WORD;
{* gibt die Differenz in Minuten zurck *}
  Var x : Integer;
BEGIN
  x := (h1*60+m1)-(h2*60+m2);
  IF x < 0 THEN Inc(x,1440);
  DiffUhrZeit := x;
END;


PROCEDURE SetTimeDW(Hour, Min, Second, Sec100:Word);
BEGIN
  slowOffSet := -1;
  Settime(Hour, Min, Second, Sec100);
END;
PROCEDURE SetDateDW(Year, Month, Day {**, DayofWeek ***} :Word);
BEGIN
  slowOffSet := -1;
  if( year < 50 )        THEN year := year + 2000
  else if( year < 1000 ) THEN year := year + 1900;
  SetDate(Year, Month, Day {**, DayofWeek ***});
END;


FUNCTION Sekunden2RelString (sek:Longint):STRING;
{* Wandle Anzahl Sekunden in einen relativen String um (2d,17h) oder (45s) *}
  VAR i : BYTE;
      s : STRING;
BEGIN
  s := '';
  FOR i := 1 TO 2 DO {* max 2 Angaben: "ss" oder "mm,ss" oder "hh,mm" oder "dd,hh" *}
    BEGIN
    IF      sek > 86400 then BEGIN AddString(s,fStr(sek DIV 86400)+'d.'); sek := sek mod 86400; END
    ELSE IF sek > 3600  then BEGIN AddString(s,fStr(sek DIV 3600 )+'h.'); sek := sek mod 3600 ; END
    ELSE IF sek > 60    then BEGIN AddString(s,fStr(sek DIV 60   )+'m.'); sek := sek mod 60   ; END
    ELSE IF sek >= 0    THEN BEGIN AddString(s,fStr(sek          )+'s.'); sek := -1; END;
    END;
  Delete(s,length(s),1); {* Letztes Komma weg *}
  Sekunden2RelString := s;
END;


FUNCTION CurrentUhrZeit (delta:shortint) : STRING;
{* Gibt die aktuelle Uhrzeit als String der Form HH:MM.SS zurck
 * Delta ist ein Offset in +-Stunden *}
   VAR h,m,s,d : Word;        st1,st2,st3 : STRING [10];
BEGIN
  GetTime(H,m,s,d);   h := (h+48+delta) mod 24;
  Str( h:2 ,st1);  str (m:2, st2);  str (s:2, st3);
  CurrentUhrZeit := st1+':'+st2+'.'+st3;
END;

FUNCTION CurrentDatum : STRING;
   VAR y,m,d,w : Word;
       st1,st2,st3 : STRING [10];
BEGIN
  GetDate(y,m,d,w);
  str ( d:2 ,st1);  str (m:2, st2);  str (y:2, st3);
  CurrentDatum := st1+'.'+st2+'.'+st3;
END;

PROCEDURE Str20 (x:WORD; VAR sRet : STRING);
BEGIN
  x := x MOD 100;
  sRet := chr((x DIV 10)+48) + chr((x MOD 10)+48);
END;


FUNCTION CurrentDatumUhrZeitDieBox : STRING;
   VAR y,m,d,w, h,mi : Word;
       st1,st2,st3 : STRING;
       s : STRING;
BEGIN
  h := systime.hour;   mi := systime.min;
  y := systime.year;   m := systime.month;  d := systime.day;
  IF y>1900 THEN Dec(y,1900);
  IF y>=100 THEN Dec(y,100);
  Str20 ( d ,st1);  Str20 (m, st2);  Str20 (y, st3);
  s := st1+'.'+st2+'.'+st3;
  Str20 ( h ,st1);  Str20 (mi, st2);
  CurrentDatumUhrZeitDieBox := s + ' ' + st1+':'+st2;
END;


FUNCTION Datum (t,m,j : Word ) : STRING;
   VAR  st1,st2,st3 : STRING [4];
BEGIN
  str ( t:2, st1);
  str ( m:2, st2);
  str ( j:4, st3);
  Datum := st1+'.'+st2+'.'+st3;
END;

FUNCTION DatumTTMM (t,m : Word ) : STRING;
   VAR  st1,st2 : STRING [2];
BEGIN
  str ( t:2, st1);
  str ( m:1, st2);
  IF m < 10 THEN st2 := st2 + ' ';
  DatumTTMM := st1+'.'+st2{+'.'};
END;

FUNCTION Uhrzeit (h,m : Byte ) : STRING;
   VAR  st1,st2 : STRING[2];
BEGIN
  str ( h:2, st1);
  str ( m:2, st2); IF st2[1] = ' ' THEN st2[1] := '0';
  UhrZeit := st1+':'+st2;
END;

FUNCTION UhrzeitHMS (h,m,s : Byte ) : String;
  VAR st1,st2,st3 : String [2];
BEGIN
  str ( h:2, st1); IF st1[1] = ' ' THEN st1[1] := '0';
  str ( m:2, st2); IF st2[1] = ' ' THEN st2[1] := '0';
  str ( s:2, st3); IF st3[1] = ' ' THEN st3[1] := '0';
  UhrZeitHMS := st1+':'+st2+':'+st3;
END;

FUNCTION DatumTMJ (t,m,j : Word ) : String;
  VAR  st1,st2,st3 : String [2];
BEGIN
  str ( t:2, st1); IF st1[1] = ' ' THEN st1[1] := '0';
  str ( m:2, st2); IF st2[1] = ' ' THEN st2[1] := '0';
  {* j:=j-1900; *}
  j := j mod 100; {* kw 3.1.2000 *}
  str ( j:2, st3); IF st3[1] = ' ' THEN st3[1] := '0';
  DatumTMJ := st1+'.'+st2+'.'+st3;
END;

FUNCTION L_Uhrzeit (h,m,s : Byte ) : STRING;
   VAR  st1,st2,st3 : STRING[2];
BEGIN
  str ( h:2, st1);
  str ( m:2, st2); IF st2[1] = ' ' THEN st2[1] := '0';
  str ( s:2, st3); IF st3[1] = ' ' THEN st3[1] := '0';
  l_UhrZeit := st1+':'+st2+':'+st3;
END;



FUNCTION Time2StrTTMMHHMM ( x : T_TIME ) : STRING;
   VAR  st,sm,sh,sMi : STRING[2];
BEGIN
  str ( x.day:2, st);
  str ( x.month:1, sm); IF x.month < 10 THEN sm := sm + ' ';
  str ( x.hour:2, sh);
  str ( x.Min:2, sMi);  IF sMi[1] = ' ' THEN sMi[1] := '0';
  Time2StrTTMMHHMM := st+'.'+sm+' '+sh+':'+sMi;
END;


{}


PROCEDURE Sirene;
  VAR i : WORD;
BEGIN
{$IFnDEF scc}
    FOR i := 1 TO 10 DO
      BEGIN
      Sound (100*i);
      Delay (5);
      END;
    NoSound;
{$ENDIF}
END;


{}

END.
