UNIT FD_Def;

{$I FD_INCL.PAS}

INTERFACE

  CONST {$IFDEF SCC} hwName = 'FALCon';
	 {$ELSE}     hwName = 'PC';
	{$ENDIF}
	pgmName  =  {$IFDEF Userware} 'TermWare'
                      {$ELSE}         'DigiWare'
                    {$ENDIF}
		    {$IFDEF WINDOWS}   + '4Win'  {$ENDIF}
		    {$IFDEF OS2}       + '/2'	 {$ENDIF}
		    {$IFDEF Linux}     + 'iX'	 {$ENDIF}
		    ;
	pgmNr	 = '0.96h';   {* Keine Leerzeichen erlaubt! (wg. Convers) *}
	__date__ = '3.1.00';
	pgmVersion = pgmName+' '+pgmNr;
	copyright1 = hwName+'/'+pgmVersion
		     {$IFDEF VER60} + '.6'    {$ENDIF}
		     {$IFDEF DPMI}  + '.DPMI' {$ENDIF}
		     + ' vom ' + __date__
		     + ' (c) 1991-99 DG9EP, DL7GAI et al.'
		     ;
	copyright2 = 'Die Verwendung d.Programms ist nur unter Anwendung der MALAS gestattet';

        cPgmKuerzel =  {$IFDEF Userware} 'TW' {$ELSE} 'DW' {$ENDIF};
	cDTW        =  '<'+cPgmKuerzel+'>';

{}
CONST
      csOS=
          {$IFDEF SCC}          'FALCon-OS'
          {$ELSE}
           {$IFDEF DOS}          'DOS'
           {$ELSE}
              {$IFDEF DPMI}      'DOS-DPMI'
              {$ELSE}
                 {$IFDEF MSDOS}  'MSDOS'
                 {$ENDIF}
              {$ENDIF}
          {$ENDIF}
          {$ENDIF}
          {$IFDEF OS2}       'OS/2'     {$ENDIF}
          {$IFDEF Linux}     'Linux'    {$ENDIF}
          {$IFDEF Windows}   'Win'      {$ENDIF}
          {$IFDEF PMVersion} 'PM'       {$ENDIF}

      ;
      csCPU=  {$IFDEF m68k}     'm68000'      {$ELSE}
              {$IFDEF alpha}    'alpha'       {$ELSE}
              {$IFDEF FPK}      'i386'        {$ELSE}
              {$IFDEF BP}
                    {$IFDEF SCC} 'V25+'
                    {$ELSE}
                     {$IFOPT G+} 'i286'
                         {$ELSE} 'i86'
                     {$ENDIF}
                    {$ENDIF}                {$ELSE}
              {$IFDEF OS2}      'i386'        {$ELSE}
                                'unknown CPU'
              {$ENDIF} {$ENDIF} {$ENDIF} {$ENDIF} {$ENDIF}
      ;
      csCOMPILER=
          {$IFDEF FPK} 'FPK'   {$ENDIF}
          {$IFDEF BP}  'BP'    {$ENDIF}
          {$IFDEF BP2} 'BP/2'  {$ENDIF}
          {$IFDEF VP}  'VP'    {$ENDIF}
      ;

      csPLATTFORM=csOS+'/'+csCPU+'/'+csCompiler;

TYPE LInteger = {$IFDEF FPK_VP} LongInt{$ELSE}InTeger{$ENDIF};
     LWord    = {$IFDEF FPK_VP} LongInt{$ELSE}Word{$ENDIF};

     {$IFDEF VP}     USHORT   = APIRet16;     {$ENDIF}

     T_valres   = {$IFDEF FPK} WORD {$ELSE}
                  {$IFDEF VP} LongInt {$ELSE}
                              INTEGER
                  {$ENDIF} {$ENDIF};
     T_GetDate = {$IFDEF VP} Longint {$ELSE} Word {$ENDIF};
     T_GetTime = T_GetDate;
{}

  CONST  CRLF = #$0d+#$0a;
	 CR   = #$0d;		   LF	= #10;
	 EOL  = CR;		   ESC	= #27;
	 BELL = #7;		   BS	= #8;
	 TAB  = #9;		   FF	= #12; {* Formfeed *}
	 MAXWORD = 65535;
CONST    byte0:BYTE=0;     {* Fr Pointerisierung ala @byte0 fr Parameter *}
         word0:WORD=0;
         longint0:longint=0;
         sSpace : STRING = '          ';

TYPE  TP_BOOLEAN = ^Boolean;
      TP_BOOL    = TP_BOOLEAN;
      TP_CHAR	 = ^Char;
      TP_STRING  = ^String;
      TP_WORD    = ^WORD;
      TP_BYTE	 = ^Byte;
      T_chArray  = ARRAY [0..65520] OF Char;
      T0ca       = ARRAY[0..65520] OF Char;
      T1ca       = ARRAY[1..65520] OF Char;
      T0ba       = ARRAY[0..65520] OF Byte;
      T1ba       = ARRAY[1..65520] OF Byte;
      T_0to7     = 0..7;
      T_0to16    = 0..16;
      str120= STRING[120];
      str80 = STRING [80];  str64 = STRING [64];  str60 = STRING [60];
      str50 = STRING [50];
      str40 = STRING [40];  str35 = STRING [35];  str30 = STRING [30];
      str28 = STRING [28];  str21 = STRING [21];  str20 = STRING [20];
      str15 = STRING [15];  str12 = STRING [12];  str10 = STRING [10];
      str9  = STRING  [9];  str8  = STRING  [8];  str6	= STRING  [6];
      str5  = STRING  [5];  str4  = STRING  [4];  str3	= STRING  [3];

      l2w = RECORD {* Long2Word; nur zum Casten von Longs und Pointer *}
	      ofs,
	      seg : Word;
	    END;
      T_TIME = RECORD
		 Year, Month, Day : Word;
		 Hour, Min, Sec  : Word;
	       END;
      T_UnixTime=LongInt;


{---- DOS-Unit-Constanten ----}
{* Dadurch brauchen wir DOS nicht zu importiern - was wir auch nicht knnten *}
CONST  fmClosed = $D7B0;
       fmInput	= $D7B1;
       fmOutput = $D7B2;
       fmInOut	= $D7B3;
TYPE
  Registers = RECORD
		CASE INTEGER OF
		  0: (ax,bx,cx,dx,bp,si,di,ds,es,flags:Word);
		  1: (al,ah,bl,bh,cl,ch,dl,dh:Byte);
	      END;
  { typisierte / untypisierte Dateien }
  FileRec = record
	      Handle   : Word;
	      Mode     : Word;
	      RecSize  : Word;
	      Private  : array[1..26] of Byte;
	      UserData : array[1..16] of Byte;
	      Name     : array[0..79] of Char;
	    end;

  { Textdateien }
  TextBuf = array[0..127] of Char;
  TextRec = record
	      Handle	: Word;
	      Mode	: Word;
	      BufSize	: Word;
	      Private	: Word;
	      BufPos	: Word;
	      BufEnd	: Word;
	      BufPtr	: ^TextBuf;
	      OpenFunc	: Pointer;
	      InOutFunc : Pointer;
	      FlushFunc : Pointer;
	      CloseFunc : Pointer;
	      UserData	: array[1..16] of Byte;
	      Name	: array[0..79] of Char;
	      Buffer	: TextBuf;
	    end;

{---- End of "DOS.TPU" ---}

{$IFDEF VER60}	 {* wg. Kompatibilitt zu BP 7.0 *}
CONST segB000 : Word = $B000;
      segB800 : Word = $B800;
{$ENDIF}


  CONST constFOREVER_TRUE  : BOOLEAN = TRUE;  {* Da kann man wunderbar Zeiger drauf zeigen lassen ! *}
	constFOREVER_FALSE : BOOLEAN = FALSE; {* ...und hier erst *}
	pf_FOREVER_TRUE    : TP_BOOLEAN = @constFOREVER_TRUE;  {* und hiermit kann man dann sogar Typgerft vorgehen *}
	pf_FOREVER_FALSE   : TP_BOOLEAN = @constFOREVER_FALSE;

{}

CONST  {* Laufzeitmessungen an/aus *}
       fLZMessungen {$IFDEF lzm}:BOOLEAN=true{$ELSE}=FALSE{$ENDIF};
      {$IFnDEF flexnet}
       useFlexNet     = FALSE;
       useTxDest      = FALSE;
       useTheNet      = FALSE;
      {$ELSE}
       useFlexNet     : BOOLEAN = TRUE;	{* Flexnet generell an/aus *}
       useTxDest      : BOOLEAN = {$IFDEF scc} FALSE;  {* Flexnet gibt auch Routen weiter *}
				  {$ELSE}      TRUE;
				  {$ENDIF}

       useTheNet      : BOOLEAN = TRUE;	{* NetRoms annehmen und ggf. Hinweis, dass Routen ueber NETROM machbar ist *}
      {$ENDIF}

      fSysMemLow     : BOOLEAN = FALSE; {* Wird bei Speicherkanppheit auf TRUE gesetzt *}
      useFIND	     : BOOLEAN = TRUE;
{*    useSmoothFrack : BOOLEAN = FALSE;  * erstmals entfernt *}
      useStopfen     : BOOLEAN = FALSE;	{* Frames stopfen bis zur PACLEN ? *}
      useCvConnect   : BOOLEAN = TRUE;	{* Conversconnect erlaubt *}
      fGlobMessTxd   : BOOLEAN = FALSE;

      axifEcho : BYTE = 0;


TYPE  T_trace = RECORD
        idLauscher        : WORD ; {* Der erhlt die Trace-Ergebnisse *}
        srcPort       : BYTE ; {* Port Src KOMPLETT in DEST-QSO kopieren *}
        idTraced      : Integer; {* Alternativ: Nur das QSO mit dieser ID tracen *}
        fBody         : BOOLEAN ; {* wenn TRUE wird der Inhalt der I's mit ausgegeben *}
        fBodyHexDump  : BOOLEAN ;
        fBodyOnlyInfo : BOOLEAN ; {* TRUE: Nur Infopakete werden getracet *}
        fInfo         : BOOLEAN ; {* TRUE; gibt alle Eingaben in die Infobox weiter an QSO TraceDstAXCBID *}
        fExclFilter   : BOOLEAN;  {* TRUE: sFilter wirkt invertierend: Begriff darf nicht vorkommen *}
        sFilter       : STRING ;
      END;
CONST trace : T_Trace = ( idLauscher    : 0;
                          srcport       : 0;
                          idTraced      : 0;
                          fBody         : false;
                          fBodyHexDump  : false;
                          fBodyOnlyInfo : false;
                          fInfo         : false;
                          fExclFilter   : false;
                          sFilter       : ''
                        );

CONST RoutBeaconPort: BYTE = 0;   {* Dorthin werden alle Flex 6er+7er frames gespiegelt *}

CONST fDisplayFrames: BOOLEAN = {$IFDEF SCC} FALSE; {$ELSE} TRUE; {$ENDIF}
      bDumpMode     : (dmALL,dmNORR,dmONLYI) = dmALL; {* Was soll alles angezeigt werden *}
      fDumpText     : BOOLEAN = TRUE;  {* Bei I und UI Frames wird der Text mit angezeigt *}
      fDumpMyTx     : BOOLEAN = TRUE;  {* Alles was ich sende wird auch angezeigt *}
{     fRouteUnknown : BOOLEAN = truE; {* Nicht zu einem QSO gehrige Pakete werden gerotet *}
      fHackFlxComp  : BOOLEAN = false;


{* allg. Flags *}
   CONST iusFlensburg    = 1;
         iusRouteUnknown = 2;
         iusLOGAFRACK    = 3;

         MAXUSEFLAGS = 3;
         scUseDesc : ARRAY [1..MAXUSEFLAGS] OF STR10= (
		 'Flensburg','RouteUnkno','LogaFrack'
         );
VAR use : ARRAY [1..MAXUSEFLAGS] OF BOOLEAN;


{* ASM DEBUG: *}
CONST fDestroy : BYTE = 0;

{* ALLGEMEINER DEBUGZHLER-Mechanismus *}
      cnt6ERPAKETE   =  1;
      cnt7ERPAKETE   =  2;
      cntErrGetData  =  3;
      cntTimLoop     =  4; {* Test: wie oft sind NEXT=PREV<>NIL bei Timer vor *}
      cntErrDelQueue =  5; {* Test: Anzahl Fehler beim Lschen in SendPacket *}
      cntUnderrun    =  6; {* Zhlt die Underruns, wird in scc_io.asm gesetzt *}
      cntNWorkTx     =  7; {* Anzahl WorkTX Aufrufe *}
      cntAckDiscard  =  8; {* Aus FD_STATE *}
      cntNoTimerProc =  9;
      cntFISSKEnnung = 10;
      cntBusyResolve1= 11;
      cntBusyResolve2= 12;
      cntIWait       = 13;
      cntWrongToken  = 14;
      cntDestAutoReorg=15;
      cntEveryMinute = 16;
      cntKickError   = 17;
      cntTailNil     = 18;  {* FD_SCC.FSCC_TxPacket *}
      cntUNKNOWNFRAMERX=19; {* unbekanntes Frame RXt, FD_STATE *}
      cntTXQW1       = 20;  {* Spezielle Warte Situation in fd_tx.TX_fromTXq *}
      cntUnNew       = 21;  {* UnAcknolwedged Frames vorhanden, trotzdem werden neue gesendet... *}
      cntFlxBuf      = 22;
      cntTailNil2    = 23;  {* FD_SCC.FSCC_TxPacket *}
      cntNilFN       = 24;  {* FD_Timer. *}
      cntLHOST       = 25;
      cntV24OR       = 26;
      cntBigBusy     = 27;
      cntRxFRMR      = 28;
      cntTxFRMR      = 29;
      cntHCMD2Long   = 30;
      cntAXCBCmp1    = 31;
      cntAXCBCmp2    = 32;
      cntAXCBCmp3    = 33;
{      cntEqCall      = 34;}
      cntHostRxOverfl= 34;
       {$IFOPT R+} {$R-} {$DEFINE Rplus} {$ENDIF}
       {  Inc(count[cnt.....]); }
       {$IFDEF Rplus} {$R+}  {$ENDIF} {$UNDEF Rplus}

      MAXCOUNT=34;
      sCountDesc : ARRAY [1..MAXCOUNT] OF STR5= (
		 '6erTk', '7erTk', 'GtDat', 'TimLp', 'DelQu',
		 'UndrR', 'WrkTX', 'AckDs', 'NoTim', 'FISKe',
                 'BsyR1', 'BsyR2', 'IWait', 'wrgTk', 'Reorg',
                 'EvyMi', 'KickE', 'TailN', 'UFrRX', 'TXQW1',
                 'UnNew', 'FlxBu', 'Tail2', 'WrTim', 'LHOST',
                 'V24OR', 'BgBsy', 'FrmrR', 'FrmrT', 'HCmdL',
                 'CBCm1', 'CBCm2', 'CBCm3', {EqCal,} 'HRxOv'
		 );
 VAR  count : ARRAY [1..MAXCOUNT] OF Longint;
 CONST nTaskSwitch : Longint = 0;

{------------------------------------------------------------}

  CONST nBuffer = {$IFDEF Userware}18{$ELSE}60{$ENDIF};
	MAXPACLEN = 256;

      BuffSize =  2*7	      {* From/to Adresse *}
		 +8*7	      {* Digifeld *}
		 +1	      {* Controllfeld *}
		 +1	      {* PID *}
		 +MAXPACLEN   {* Daten *}
		 +2	      {* CRC *}
		 ;

{     nTxTailBytes   : WORD = 3;       {* Anzahl der Bytes, die als TXTail ausgesendet werden *}
      nChWeg	     : Word = 0;       {* Spezial Debug Zhler fr ASM *}


TYPE  ch1Array = ARRAY [1..BuffSize+4] OF CHAR;
      by1Array = ARRAY [1..BuffSize+4] OF BYTE;
      TP_by1Array = ^by1Array;

CONST MAXSTATOC=400;
  VAR statoc : ARRAY [0..MAXSTATOC] OF longint;
CONST MAXSTATinuse=400;
  VAR statinuse : ARRAY [0..MAXSTATINUSE] OF longint;
CONST MAXaDELTATIME=500;
  VAR aDELTATIME : ARRAY [0..MAXaDELTATIME] OF WORD;

 TYPE t_doLED = (cAUSSCHALTEN, cANSCHALTEN, cUMSCHALTEN);
 CONST cvLed : ARRAY [FALSE..TRUE] OF T_DoLED = (cAUSSCHALTEN, cANSCHALTEN);
{}

 {* SoftwareWatchDog, wird in der ISR08 bearbeitet *}
  VAR SWD_Tick : LongInt;
      SWD_Init : LongInt;
      HWatch2_Tick : Word;


CONST lenPatch : Word = 0;
      fBigEEPROM {$IFDEF scc}: BOOLEAN{$ENDIF} = FALSE; {* wird beim Starten gesetzt *}

TYPE  TF_TimerFunction = PROCEDURE ( p : Pointer );
      TP_timer = ^T_Timer;
      T_timer = RECORD
		  pbEnabled	 : TP_BOOLEAN; {* Zeiger auf eine Boolsche Variable (z.B. DCD oder Flag) *}
					       {* pbEnabled^ darf nur gelesen werden, NIEMALS BESCHREIBEN! *}
					       {* pbEnabled^ darf nie NIL sein! *}
{*****************^^^^^ BIS HIERHIN NICHT NDERN WG.  SCC_IO.ASM *******}
		  next,
		  prev		 : TP_Timer;   {* PREV ist wichtig zum Aushngen *}
		  state 	 : (RUNNING,   {* timer is still running and is in the list *}
				    STOPPED,   {* timer is invalid and not in the list *}
				    EXPIRED    {* timer has just expired, is still in the list and waiting for servicing *}
				    );
		  TicksRemaining : LongInt;
		  TickInit	 : LongInt;
		  useFast	 : BOOLEAN;    {* TRUE = Verwendet die FastChain *}
		  TimerFunction  : TF_TimerFunction;
		  Arg		 : POINTER;  {* Fr die TimerFunction *}
		 END;

VAR   NULLTIMER : T_TIMER ABSOLUTE 0:0; {* Trick um auch NIL typgeprft bergeben zu knnen - @NULLTIMER = NiL *}
CONST _clktick = 10;	  {* in ms *}
      _clkSlowTick = 500; {* in ms *}
      _Sekunden = 1000 DIV _clkTick;  {* 15 * _Sekunden = 15 s *}
      _Minuten	=   60 * _Sekunden;   {* 5 * _Minuten = 5 min *}

CONST FastTick : LONGINT = 0;
      SlowTick : LongInt = 0;

{}
CONST ANZ_SCCPORTS = 4;
      MAX_IFACE = ANZ_SCCPORTS {* SCCs *}
		+ 1 {* LOOPBACK *}
		+ 2 {* V24 *}
	      	+ 1 {* SCSI *}
		;
TYPE  T_IFNr = 0..MAX_IFACE;		  {* Range of Interface-Number *}
{CONST txzust0 : ARRAY [0..3] OF Byte = (37,37,37,37); {* Debug: Zustandstabelle *}
{VAR txzust1 : ARRAY [1..4] OF Byte ABSOLUTE txzust0; {* Debug: Zustandstabelle *}

TYPE T_Zweck = (zTXBuff,   {* Verwendung als SendeBuffer (mit und ohne Header) *}
		zRXBuff,   {* Verwendung als RxBuffer (mit und ohne Header) *}
		zOTHER);   {* Alles andere. Z.B. Texte ... *}
     TP_Data = POINTER;
     TP_mbuf = ^T_mbuf;
     T_Mbuf = RECORD
{0}		Ifnr	: BYTE;     {* Nr. des Interfaces, bei Sende und Empfangsinhalten. 1-4 ist zur Zeit ne stille Voraussetzung *}
{1}		time	: longint;  {* Zeitmarke in 10ms seit PgmStart *}
				    {* beim Rx wird die Zeit nach Empfang gesetzt *}
				    {* beim Tx wird die Zeit vor dem Einhngen in die Queue gesetzt *}
{5}		next	: TP_mbuf;  {* ALL: Verkettungszeiger *}
{9}		discard : BOOLEAN;  {* Buffer darf nach dem Senden weggeschmissen werden *}
{10}		pdata	: TP_Data;  {* Zeiger auf Datenbereich *}
{14}		nMyCall : Byte;     {* Welches ist MYCALL ? 0 = TOCall, sonst Index des Digis *}
{15}		bufl	: Longint;  {* TX/RX: pData als 20 Bit Addresse *}
{19}		txed	: (WAITING,	{* Frher: False. Steht in der Queue. Noch nicht gesendet. *}
			   TRANSMITTED, {* Frher: TRUE . Steht nicht mehr in der Queue, ist schon gesendet worden. *}
			   SUSPENDED);  {* Neu: Steht noch in der TXQ, soll aba nicht mehr gesendet werden *}
{20}		inUse	: Word;     {* benutzte Lnge des Datenbereich; muss <= len *}
				    {* sein, wenn 0, so ist der Inhalt nicht gltig *}
		nHeard	: Byte;     {* Wo steht das letzte Heard-Bit?
                                     * 0 = Keins,
                                     * 1..8 = sonst Index des Digis
                                     * gleichzeitig Antifragmentflag beim TXBuffer
                                     *}
		ptTimer : TP_Timer; {* Zeiger auf den assozierten Timer (kann auch NIL sein)*}
                                    {* Bei RXten Frames ist da u.U. Txd-Werte drin *}
{*****************^^^^^ BIS HIERHIN NICHT NDERN WG.  SCC_IO.ASM *******}
		ofsCtl	: Word;     {* Offset des Controlfeldes im Paket::=14+7*nDigi+1
				     * Also 15,22,29,...64,71
                                     * ...oder 8 bei Flex. virt. Adressierung ->
                                     * Kennzeichnung des Frames
                                     * Bei DB0GIS sind auch schon Werte=1 gesichtet worden...
                                     *}
		len	: Word;     {* Lnge des Bereichs auf den pData zeigt *}
	       END;
CONST cANTIFRAGMENTFLAG = 219; {* Missbrauch von mbuf.nheard *}
TYPE TP_Liste = RECORD
		  Root,
		  Tail : TP_MBuf;
		END;
{* Das gleiche wie tp_liste, aber nur mit ROOT, wg. Kompatib. mit L1 *}
TYPE TP_1Liste = RECORD
		  Root : TP_MBuf;
		END;
CONST lstDel	 : TP_Liste= (Root:NiL;Tail:Nil); {* Liste der zu lschenden Puffer. Tail wird wohl gar nicht verwendet *}
  VAR lstRxInUse : TP_Liste; {* Liste Rxter, aber noch nicht verarbeiteter Frames *}
			     {* vormals RootRxinUse und RootRXTail genannt *}


{}
CONST cOFFVIRT = 8; {* Offset des Controllfeldes bei virt.Adress ala FlexNet *}
      POLL = TRUE;	FINAL = TRUE;	   NO_PF = FALSE;
      MELDUNG = TRUE;	KOMMANDO = FALSE;
      cNULL=0;      cPFBIT=4;

      cKOMM  = 1;
      cMELD  = 2;
      cPOLL  = cKOMM OR cPFBIT;  {5}
      cFINAL = cMELD OR cPFBIT;  {6}
TYPE T_KMPF=0..cFINAL;
CONST reply : ARRAY[cNULL..cFINAL] OF T_KMPF = (cNULL,
						cMELD,
						cMELD,0,0,
						cFINAL,
						cMELD);
TYPE T_ssID = 0..15;
     T_Call = RECORD
		 Call : Str10;	 {* 10 ? Sechs muesste doch reichen ??? *}
		 SSID : T_SSID;
		END;
     TP_shCall = ^T_ShCall;
     T_ShCall = Array [1..7] OF CHAR;

TYPE T_LZ = INTEGER; {* in 10 ms *}

{$IFDEF BroadCast}
VAR   BcShMyCall,             {* z.B. DB0ME *}
      BcShBoxCall : T_shCall; {* z.B. DB0IZ *}
{$ENDIF}
CONST BcPort : Byte = 0; {* 0=kein BC *}
      nBCUI : Word = 0;



{}

CONST MAXBIND = MAX_IFACE;
      ifloopBack : BYTE = 0; {* enthlt die Nr. des 1.Interfaces des Loopbacks, wird vor allem in FD_Dump benutzt *}

      {* Definitonen SetParameterErrors. >=0 Ok,  <0 Error *}
CONST speOK = 0;      {* Kommando erfolgreich durchgefhrt *}
      speERROR = -1;   {* Fehler bei Kommandoausfhrung ! (allgemeinste Form) *}
      speNNCMD = -255; {* Kommando ist in diesem Treiber nicht eingebaut *}
TYPE T_setPara = (
      spINIT,	  {* Generelle Init-Funktion fr Zustze Z.B. TNC umschalten *}
      spREINIT,   {* Generell: nochmal alle Parameter einlesen, im einfachsten FALL DEINITCH,INITCH *}
      spDEINIT,   {* Generelle DeInit-Funktion zum Ausschalten der Dev. Wert=undef *}
      spGETVALUE,  {* Werte des Treibers abfragen   *}
      spTXPacket,  {* ????? *}
      spSETZEWertIFACENr, {* s. FD_AX *}
      spBIND_DN,   {* Binde ein Protokoll an eine bind oder umgekehrt  Du bist als DN drin *}
      spBIND_UP,   {* Binde ein Protokoll an eine bind oder umgekehrt. Du Bist als UP drin *}
      spUNBIND,   {* Bindung wird aufgehoben *}
      spHOLEPROC,  {* Hole einen Prozedur, s. T_hp *}
      spHOLEVAL,  {* Hole einen Wert, s. T_HV *}
      spKOMMANDOZEILE,  {* bergabe von P - Daten *}
      spHOLEPARAMSTRING,{* Gebe eine Zeile fr das PARA - Kommand zurck *}
      spSETZEDAMAPARA {* Also: Stelle auf Duplex um; Dwait = 0 ... *}
      );

     T_HV = ( hvBINDNR  {* kennzeichnet u.a. TopLevel Service *}
     );

     T_HP = ( {* Richtung Call von oben nach unten: *}
              hpLED,       {Lmpchen o.. steuern}
              hpRX1CHAR,   { Empfangen 1 Zeichen }
              hpNRXCHAR,   { Anzahl vorhandenen RX-Zeichen }
              hpTX1CHAR,   { Senden 1 Zeichen }
              hpNTXChar,   { Platz im Sendebuffer }
              hpTxPacket,  { Sende ein ganzes Paket }
              {* Richtung Call von unten nach oben (asyncron) *}
              hpRXPacketUp,  { Wer soll gerufen werden, wenn RX was vorliegt (und adresse einen mbuf is das Argument) }
              hpTXNotify   { Wer soll gerufen werden, wenn TX-Platz frei ist, keine Argumente }
              );
     TFN_TX1CHAR  = PROCEDURE(c:char);
     TFN_RX1CHAR  = FUNCTION : char;
     TFN_NRXCHAR  = FUNCTION : WORD;
     TFN_NTXCHAR  = FUNCTION : WORD;
     TFN_RXPacketUp = PROCEDURE (pm:tp_mbuf);

     TFN_LED      = PROCEDURE(ifNr:t_ifnr; mode : t_doLED);

     TFN_TxPacket = PROCEDURE( pm : TP_Mbuf );
     TFN_SetPara = FUNCTION( devnr : BYTE; what:T_SetPara; val:longint ): LongInt;
      {* Return abhngig vom Parameter *}

     T_bind = RECORD
	     valid	: BOOLEAN;
             {Regnr* ist der Index in dem Array Register; devNr ist die
              Untergertenummer der entsprechenden Treiber; *Dn ist der
              Treiber der mehr in Richtung HArdware liegt; *Up ist der
              Treiber der mehr in Richtung Software/Anwendung liegt *}
             regNrUp,devNrUp,
             regNrDn,devNrDn : BYTE;
	    END;
VAR bind : ARRAY [1..MAXBIND] OF T_BIND;

CONST sGlobReturn : STRING=''; {* Puffer zur Rckgabe von Stringwerten... nicht sehr reentrant :-) *}


CONST
  DUPLEX = 0; SIMPLEX = 1; SIMPLEXSPEZ = 2;
  casSIMPDUP : ARRAY [0..2] OF STRING[5]=('Dupl','Simpl','SSpez');
  casNRZI : ARRAY [0..1] OF STR4= ('NRZ','NRZI');

{$IFDEF scc}
  ZUST_NOP  =	  0;
  ZUST_DCD  =	  1; {* DCD ist an *}
  ZUST_DWAIT=	  2; {* DWAIT luft *}
  ZUST_FREE =	  3; {* DWAIT is abgelaufen, und DCD ist auch noch aus *}
  ZUST_TXD  =	  4; {* Sender ist an, FLAGS werden gesendet *}
  ZUST_DAT  =	  5; {* Sender ist an, Daten werden gesendet *}
{  ZUST_TAIL =     6; }

{  ZUST_HOLD =	  16; {* Pseudo-Zustand in KICK_Tx *}
{$ENDIF}

{----------------------------------------------------------}
TYPE  T_AxIfArt = (aUSER,  {* Usereinstieg *}
	       aINTERLINK, {* Interlinkstrecke *}
	       aTERMINAL); {* Box, TFPCR, per LoopBack oder sonstiges Terminal *}
CONST asAXIFART : ARRAY [t_AxifArt] OF String[9] =
                        ('Userport','Interlink','Terminal');

CONST MAX_AXIFACE = MAX_IFACE;
TYPE T_LinkId = 0..240; {* zur Typprfung *}
     T_UIMODE = (uiAlle,uiNoAX25,uiTXD,uiKeine);
TYPE T_DAMA_INTERFACE = RECORD
{$IFDEF DAMA_SLAVE}
       ftLastRxDAMABit : Longint; {* Fasttick, nur bei SLAVE *}
       fSlaveAllowed, {* Auf dem Kanal darf ich Slave werden *}
       fSlave         {* Auf dem Kanal bin ich Slave *}
         : BOOLEAN;
{$ENDIF}
     END;

TYPE
  T_Axiface= Record  {- s.a. fd_ax.ax -}
        valid   : BOOLEAN;
        sNameDn : STRING[8]; {* Name der drunterliegennden Schicht *}
        devNrDn : BYTE; {* DevNr der drunterliegennden Schicht *}
        bindNr  : BYTE; { nr des angebundenen Protokolls bzw. Hardware }
        procTXPacket : TFN_TxPacket;
        fLoopBack : BOOLEAN;  {* Dies ist ein Loopback Device *}
        DAMA      : T_DAMA_INTERFACE;
	Call,
	IDent	  : T_ShCall;
	asMyCall  : STR9;
	asMyIdent : STR6;

	mapIfnr   : BYTE; {* kommt ein QSO ber dieses IFACE, so wird bei
                           * Connect nach unbekanntem Ziel in dieses umgemappt
                           *}
	minSSID,	  {* SSID des Ports *}
	maxSSID   : BYTE;
	art       : T_AXifart; {* Usereinstieg etc. *}
	ptt_mode  : (pttNORMAL,{*pttINV,pttON,*} pttOFF);
	l2DigiOn  : BOOLEAN;
	UIMode	  : T_UIMode;
	t1_init   : Word;
	t2_init   : Word;
	t3_init   : Word;
	retry_init   : Word;
	paclen_init  : Word;
	maxFrame_init: Word;
	txWindowInit    : Word;  {* wird die TX-Queue lnger, so mu die Datenquelle pausieren *}
	rxWindowInit    : Word;  {* wird die RX-Queue lnger, so geht der DIGI lokal in RNR    *}
	iPollSchwelle: Word;  {* muss letzter vor Statistik sein (wg. CRC-Test) *}
	{* Statistik: *}
	brChBytes,
	brChAvg,	   {* Alle RXten-Frames auf dieser QRG *}
	brmax	: LongInt;
	nTxInfoNetto,	   {* Insgesamt netto gesendeten Bytes (ohne Protos,ohne Header,ohne Wiederholungen) *}
	nTxBrutto,	   {* Alle insgesamt gesendeten Bytes, incl. Protos, Header und Wiederholungen *}
	nRxInfoNetto,	   {* Dto. RXed *}
	nRxBrutto,
	nITxBrutto, nITxNetto,
	nRRtx,
	nRNRtx,
	nREJtx, 	   {* Zhler gesendete Paketarten *}
	nIrx,
	nRRrx,
	nRNRrx,
	nREJrx, 	   {* Zhler empfangene Paketarten *}
	nRxPolls,
	nTXSvPolls	    {* Zhler fr Supervisor-Polls *}
	 : LONGINT; {* Zhler Besttigungen  *}
     END;
 VAR  axiface  : ARRAY [1..MAX_axiface] OF T_axiface;


{$IFDEF DG5MPQ_STA}
Type T_sta10min = Record
        old_TxByte,   old_RxByte,
        old_nAnzBest,
        old_nITx,     old_nIRx
          : Longint;  {* Hier werden alle alten Werte gemerkt  fuer do_every_minute *}
        TxKByte,  RxKByte,
        AnzBest,
        ITx,      IRx
          : Longint;      {* aktuelle 10 Min Werte* }
        min_TxKByte,
        min_RxKByte,
        min_nAnzBest,
        min_nITx,
        min_nIRx : Array [1..10] of WORD; {longInt; {* hier werden die minutenwerte gespeichert *}
        min_Pointer: Integer;                   {* zeiger auf aktuellen array eintrag* }
        IfaceUser  : Integer;                 {* Zum zaehlen der User am Port *}
        Links      : Byte;                    {* Bei der Ausgabe der Links mitzaehlen format *}
       end;
  const
       fSta10minMustBeInit : Boolean = True;
  VAR
      sta10min : Array [1..MAX_iface] of T_sta10min;
{$ENDIF}
{     crcif : ARRAY [1..MAX_iface] OF Word; }
{     sizeof_one_iface : Word;	{* Zum Versionsabgleich PAS./. ASM, wird von der Level 1 Routine init.*}


CONST upCallCheck : BOOLEAN = {$IFDEF SCC} TRUE; {$ELSE} FALSE; {$ENDIF}
      dnCallCheck : BOOLEAN = FALSE;

      {* Eigentlich nicht Flexnet sondern LZM abhngig ... *}
      MyFlexMinSSID  : T_SSID = 0;  {* Damit startet die LZ-Messerei *}
      MyFlexMaxSSID  : T_SSID = 10; {* myMaxSSID *}

      FindSSID	     : T_SSID = 14;
      SSIDCvConnect  : T_SSID = 0;
      SysopCall : STRING{15} = 'SY5OP';

      {* Ident-Name 0..9stellig, fr Internodekommunikation.  *}
      {* Der Name darf als Sonderzeichen nur '.' '_' und '/'  *}
      {* enthalten, ansonsten nur Grossbuchstaben und Ziffern.*}
      MYBAYCOMIDENT : STRING{9} = '';

CONST MYQTH : STR6 = '';
      {* Wenn die hier eingetragenen Calls connecten, landen sie automatisch *}
      {* im Convers und kriegen HOST + USER automatisch um die Ohren gehauen *}
      cvLINKCALL : STR60 = '';

CONST boxIFACE : T_IFNR = 5;
      boxPfad  : STR64 = 'NOBOX';

{ WATCH }

TYPE T_WatchAction = BYTE;

CONST INVALIDNCONNECTS=255;
{* Kostanten fr das BitFeld T_WatchAction *}
CONST bgNULL	    =	0;	{* Nix unternehmen *}
      bgSilent	    = $01;	{* gar nicht auf SABM antworten *}
      bgDM	    = $02;	{* busy senden bei SABM 	*}
      bgEntryLog    = $04;	{* ins Logbuch eintragen  *}
      bgNoExtConnect= $08;	{* Er kann nicht weiterconnecten *}
      bgAutoRedirect= $10;	{* Es wird automatisch ein RED ausgelst *}
      bgBeamter     = $20;	{* Betrieb wird verlangsamt *}
{*    bgStatistic		{* Die QSO Statisik wird ins Logbuch geschrieben *}

      bgNoIntConnect = bgSILENT OR bgDM; {* Hilfswert *}
      bgNoOutConnect = bgSILENT OR bgDM OR bgNoExtConnect; {* Hilfswert *}

TYPE T_watch = RECORD
		  call	  : T_shCall;	  {* Wer? Wildcards mglich  *}
		  pText   : POINTER;	  {* Text ausgeben, wenn nicht NiL *}
		  typ	  : T_WatchAction; {* s. bg-Konstanten *}
                  nConnect: BYTE ; {* Maximale Anzahl Connects *}
		  data : RECORD  {* zustzliche Daten *}
                         CASE BYTE of
                           1: (ifRedirect : BYTE ); {T_Ifnr wr zwar besser, aber das ist einfacher zu hndeln}
                                                    {* bei Redirect: dahin gehts *}
                          END;
		  {* inPort: Wenn definiert, so gelten diese Beschrnkungen *}
		  {* nur, wenn das QSO ber diesen Port kommen		    *}
		 END;

CONST MAXWATCH = 14;
TYPE T_bgIndex	= 1..MAXwatch;
     T_bg0Index = 0..MAXwatch;
CONST nWatch : T_bg0Index = 0; {* Anzahl der benutzten Watches *}
  VAR watch : ARRAY [T_bgIndex] OF T_watch;

{}

CONST {ax25_paclen_max : Word = 256;}
      FindRetry : BYTE = 2;

TYPE T_FrameTyp = (unknown,  RmR,      {* REIHENFOLGE WICHTIG wg. FRAMECODE *}
		   SABM,     DISC,
		   DM,	     UA,
		   RR,	     RNR,
		   REJ,      FRMR,
		   INFO,     UI     );
CONST cSABM =	$2f;   cDISC =	 $43;
      cDM   =	$0f;   cUA   =	 $63;
      cRR   =	$01;   cRNR  =	 $05;
      cREJ  =	$09;   cFRMR =	 $87;
      cINFO =	$00;   cUI   =	 $03;

      FrameCode : ARRAY [unknown..UI] OF BYTE = (
		 0,0,
		 cSABM, cDISC,
		 cDM,	cUA,
		 cRR,	cRNR,
		 cREJ,	cFRMR,
		 cINFO, cUI );

TYPE T_L2State=(l2disc,
                l2setup,
                l2frmr,
                l2discReq,
                l2inf,
                l2rejSent,         {* REJ Sent *}
                l2wAck,            {* WaitingForAck *}
                l2bsy,             {* device busy *}
                l2rBsy,            {* remote busy *}
                l2bothBsy,         {* both busy   *}
                l2wAckBsy,         {* WaitingForAck and device busy*}
                l2wAckRBsy,        {* WaitingForAck and remote busy*}
                l2wAckBothBsy,     {* WaitingForAck and both busy  *}
                l2rejSentBsy,      {* REJ Sent and device busy*}
                l2rejSentRBsy,     {* REJ Sent and remote busy*}
                l2rejSentBothBsy   {* REJ Sent and both busy  *}
               );
     T_STate = (DISCONNECTED,
		SETUP,
		DISCPENDING,
		CONNECTED,
		FRAMEREJECT,
		IGNORE,   {* fr Digimigen connectaufbau *}
		INVALID   {* der zughrige CB ist gelscht - also keine pCB^ operationen mehr erlaubt *}
		);

CONST maxDigis = 8;	{* max. Number of DigiCalls in AX25-Header *}
TYPE T_DIGIS = ARRAY [1..maxDigis] OF T_ShCall;

TYPE T_PID   = 0..255;
CONST PID_X25       = $01 ; {001} {* CCITT X.25 PLP *}
      PID_PACKES    = $05 ; {005} {* dg9ep's Textkompressionsprotokoll (Test) *}
      PID_VJIP1     = $06 ; {006} {* TCP/IP mit VJ-Kompression (FlexNet) *}
      PID_VJIP2     = $07 ; {007} {* TCP/IP mit VJ-Kompression (FlexNet) *}
      PID_AXSEG     = $08 ; {008} {* AX25-Segmentierung *}
      PID_BC        = $BB ; {187} {* Broadcast Protocol der Pacsat Satelitten *}
      PID_TEXNET    = $c3 ; {195} {* TEXNET datagram protocol *}
      PID_LQ        = $c4 ; {196} {* Link quality protocol *}
      PID_APPLETALK = $ca ; {202} {* Appletalk *}
      PID_APPLEARP  = $cb ; {203} {* Appletalk ARP *}
      PID_IP	    = $CC ; {204} {* ARPA Internet Protocol *}
      PID_ARP	    = $CD ; {205} {* ARPA Adress Resulution Protokoll *}
      PID_FlexNet   = $CE ; {206} {* RMNC-FlexNet Internodeprotocol *}
      PID_NetRom    = $CF ; {207} {* NET/ROM, TheNet(Node) *}
      PID_Text	    = $F0 ; {240} {* Kein L3 Protokoll *}

CONST AXSEG_FIRST = $80;  {* First segment of a sequence *}
      AXSEG_REM   = $7f;  {* Mask for # segments remaining *}

CONST IPID_ICMP =    1;   {/* Internet Control Message Protocol */}
      IPID_TCP  =    6;   {/* Transmission Control Protocol */}
      IPID_UDP  =   17;   {/* User Datagram Protocol */}
      IPID_RSPF =   73;   {/* Radio Shortest Path Find */}

{}
CONST MAXTXT	     = 20;   {* Maximale Anzahl abspeicherbarer Texte *}
      MAXTXTNAMELEN  =	8;   {* Maximale Lnge eines Testnamens *}
      MAXTXTTITELLEN = 45;   {* Maximale Lnge einer Beschreibung *}
CONST maxWriteSize : WORD = 0;
TYPE T_txtName = String[MAXTXTNAMELEN];
     TP_TEXT = ^T_Text;
     T_Text = RECORD
		name	  : T_txtname;
		sTitel	  : String[MAXTXTTITELLEN];
                pMem      : Pointer;    {* Wenn <> nil zeigt er auf EPROM, wo der Text steht, dann ist pMText irrelevant *}
		pmText	  : TP_mBuf;	{* Zeiger auf den ersten mBuf des Textes *}
		writeTime : T_TIME;
		size	  : Word;	{* Gesamtlnge der Botschaft *}
		cDir	  : BOOLEAN;	{* Dieser Eintrag soll zusammen mit CTEXT als DIR erscheinen *}
		fHidden   : BOOLEAN;	{* Wird bei DIR nicht angezeigt *}
		readCount : Word;
	       END;
VAR  apText : ARRAY [1..MAXTXT] OF TP_Text;

CONST csBye    = 'vy 73!'+EOL;
      csNOTEXT = 'z.Zt. kein Text geladen' +EOL;
      sPromptTemplate : STRING = '%0';  {* Prompt aus!-> sonst gibt es zuviele Fehlermeldungen beim Init! *}
      sLoginAutoCMD : STRING = '';
      sCText : STRING = '';
      sZeitZone:str5='Local'; {* vormals dcf_prompt; Fr Macro %z 'Local','MEZ' oder 'MESZ' *}
      cCQCALL = 'CQ';
VAR   shCQCall : T_ShCall;

CONST InfoBoxTimeOut : LONGINT = {$IFDEF HostMode}30*24{$ELSE}4{$ENDIF}*60*(60*(1000 div _ClkTick)) {* 4 h *};
      facGelbeKarte = 3;
      CQ_Retry : Byte = 5;

{  Konstanten fr den Logtransfer }
CONST MaxLog		: Word = 150;  {* maximal mgliche Anzahl von Eintrgen *}
      nLogTransferGT	: Word = 75; {* wenn mehr als soviele Logeintrge vorliegen, wird die Box angewhlt *}
      logIfNr		: BYTE = 2;
      logTo		: STR9 = 'DB0IZ';
      logVia		: STR30  = '';
      logWaitForConnect : STR30 = 'Logins:';
      logSendCmd	: STR40 = 'SEND DG9EP @ DB0IZ DigiWare-LogBuch'+EOL;
      logWaitForSend	: STR20 = 'Text';
      logClose		: STR15 = ^Z + EOL;
      logWaitForDisc	: STR20 = 'Text';
      {* $TODO pCB.ttimeout verwenden+Konfigurierbar machen *}

CONST wieLog : word = 180;   (* dg6may: fr statistik im logbuch *)

CONST nWarnMaxLogin = 6;    {* Tadelmeldungen der Infobox, wenn mehr Logins gleichzeitig erfolgen *}
      nWarnMaxPakete = 40;  {* Tadelmeldungen der Infobox, wenn mehr Pakete pro Minute verschickt werden *}

{Pfoertner Kram }

  VAR PfoertPort :T_IFNR;
      sPfoertFm, sPfoertTo :  Str15;
      sPfoertVia : STRING;

{}

CONST maxLZMESS = 16; {* Groesse des LZ-Arrays / Anzahl der Lzm-Ergebnisse *}
      lzERROR = 2000; {* Nicht ndern! *}
      lzANZEIG= 1999; {* Werte oberhalb werden in LinkListe nicht mehr angezeigt *}
      {* sollte immer < lzError sein! *}

TYPE TP_Axcb = ^T_axcb;
     TP_link = ^T_link; {* wird fr CASTING gebraucht *}
     TP_IB = ^T_IB;	{* InfoBox *}
     T_IB = RECORD
	      timeOutStufe : (ibtNULL, ibtGELB,ibtSCHLUSS);
	      byLastCmd,  {* BitFeld, der verhindert dass bestimmte Befehle *}
			  {* mehrfach gegeben werden (info,,help)	    *}
	      PrivCount,  {* Zhler, wie oft ein PRIV Befehl gegeben wurde *}
	      InvalidCount : BYTE; {* Zhler wie oft hintereinander ein ungltiger Befehl gegeben wurde *}
              fIntViaConnect : BOOLEAN; {* = Durchgeschleift auf Mycall-Link *}
              fIgnore : BOOLEAN; {* Fr den MACHE MICH TRANSPARENT-Befehl ..BROADCAST (Flexnet 3.3f) *}
	      END;
     T_sCvName	   = STR20;
     T_sCvHostName = STR20;
     T_CvCh	   = INTEGER;
     TP_cv	   = ^T_CV;
     T_Cv = RECORD {* Convers *}
	       next  : TP_cv;	      {* Zeiger auf nchsten Record *}
	       typ   : (cvUSER,       {* Normaler, lokaler User     *}
			cvREMOTEUSER, {* Normaler, angeschlossenen User *}
			cvLINK,       {* LinkQSO mit Nachbar *}
			cvLINKINIT);  {* Der wird noch zum CVLink (nach Empfang von /..HOST) *}
		     {* ^^^^^^^ !Reihenfolge WICHTIG! *}
	       pCB   : TP_axcb;       {* cvUSER: zugeh. QSO *}
				      {* cvREMOTEUSER: zugeh. LINK-QSO *}
				      {*   Der Server-Nachbar, der uns diesen *}
				      {*   Teilnehmer MELDETE *}
				      {* cvLINK: zugeh. LINK-QSO *}
	       kanal : T_CvCh;	      {* Kanalnr. *}
	       name  : T_sCvName;     {* Call und evt. Alias. Wird bei jeder Message angezeigt *}
				      {* Bei LINK, das Call des Nachbarn *}
	       sPersData
		     : STR35;	      {* fr PERSONAL; Also Vorstellung etc. *}
	       hostname
		     : T_sCvHostName; {* Name des Hosts, wo ein Remoteuser drin SITZT *}
				      {* Bei CV-Links der per /HOST angemeldete Name *}
	       fTX   : Boolean;       {* Interne Verwendung, fr Aussendung auf den Links *}
	       nByteTx, 	      {* Statistik ffentlich gesendetete Zeichen *}
	       nBytePrivateTx         {* Statistik private Message *}
		     : LongInt;
               {tilast {letzte Aktion des Users : unixtime
               }
	       time  : T_Time;	    {* Seit wann isser drinnen? *}
	       fAway : BOOLEAN;     {* User ist weggegangen *}
               { union: tiunAwaySince }
	       fChOp : BOOLEAN;     {* Dieser User ist der Channel OP *}
	   {*  Shoot : BOOLEAN;     {* Antwort auf Shoot wurde gegeben *}

	   {*  shRxPri,shTxPri:T_ShCall; *} {* Default Calls fr /, und /. *}

	       fBell	 : BOOLEAN;  {* Es klingelt -  la 6iq	*}
	       sANSI	 : STRING[8];  {* <> 0 User wnscht bunten Convers: bit 7-4 Vordergrund, 3-0 Hintergrund *}
               sFilter   : STR30;    {* Zum Ausfiltern von Leuten *}

	       fBayStyle : BOOLEAN;  {* Ausgabe  la BayCom-Convers *}
	       pCvLast	 : TP_CV;    {* Der letzte, der was schrieb steht dadrin
                                      * (zum feststellen, bei BayCom, ob der Absender gedruckt werden muss
                                      *}
	      END;
{* Enthlt Kanaleigenschaften *}
     TP_CvChAttr = ^T_CvChAttr;
     T_CvChAttr=RECORD
    {0}       next     : TP_cvchAttr;
    {4}       chnr     : T_CvCh;  {* Kanalnr. Nur einmal vorhanden. Aufteigend sortiert! *}
    {6}       topic    : STR50;   {* Thema des Kanals. Setzen nur durch ChOp oder Remote *}
    {42}      fPrivate : BOOLEAN; {* kann keiner mehr rein, ausser denen die drin sind *}
	  {*  fHidden: BOOLEAN;   {* User erscheinen in keiner Liste mehr *}
    {43}      nUser,		   {* derzeitige Anzahl der User *}
	      nUserLoc, 	   {* davon lokale User *}
	      nMaxUser : BYTE;	   {* Maximale Anzahl User aum Kanal; 0 = beliebig viele *}
    {46}  {    banned	: T_shCall; k.w. {* Dieses Call darf hier nicht rein *}
    {53}      tLastLogout,
	      tCreated : T_Time;
              tlTopic  : T_UnixTime; {* Zeit des Themas *}
	      END;


     T_Msg = (msgNULL,		{* ohne Bedeutung *}
	      msgTimeOut,	{* Spezieller TimeoutTimer ist abgelaufen, z.B. fr LZ-Timeout *}
	      msgSpecialT1Out,  {* T1 ist abgelaufen - nur im Status Disconnected - fuer CQ usw. *}
	      msgConnectSuccess,{* Connect Versuch erfolgreich *}

	      msgTx,		{* in der TxQueue ist wieder etwas Platz *}
 	      msgNoMoreTxOutstanding, {* alle ausgesendeten Frames sind besttigt (TXQUE aber nicht unbedingt leer }
	      msgRx,		{* in der RxQueue steht (wieder) was gltiges *}

	      msgRetryCountExceeded,
	      msgDiscReq,	{* ein DisconectRequest traf ein *}
	      msgRxDM,		{* DM traf ein *}
	      msgCBDel, 	{* CB der Verbindung wird gerade gelscht *}
				{* (z.B. Wenn eine DISC vom Partner mit UA besttigt wurde) *}
				{* nur fuer Spezialzwecke *}
              msgReconnect,     {* Reconnect (SABM im laufenden QSO) *}
              msgDUMMYLAST    {alles was hiernach kommt wird nur in Main erzeugt}
	     );
     TF_Msg = PROCEDURE ( pCB:TP_axcb; msg:T_MSG );

     T_axcb = RECORD			  {* AX25 Control Block *}
     		state	      : T_state;
                setMsg        : Set of t_Msg;
		fMsgHandler   : TF_Msg; {* Msg.Handler UpCall *}
         	TxBuf,
     		TxBufTail     : TP_Mbuf;
     		TxBufSize     : LongInt;
                fDoTxBuf      : BOOLEAN;     {* Freigabeflag frs Senden *}
     		RxBuf	      : TP_Mbuf;     {* Der neueste steht vorne *}
     		RxBufSize     : Longint;     {* Anzahl Bytes die noch drin sind *}
{$IFDEF sammler}
      		sammler       : Array [0..7] OF TP_mbuf;
{$ENDIF}
      	        id	      : Word;	     {* eindeutiger Index zum Killen & Plausi, VirtAdress etc. *}
                                             {* Ist einfach der Index des Arrays *}
					     {* ID darf wg. Speicherverwaltung von TP6ff nicht *}
					     {* in den ersten 8 Byte der Struktur stehen (-->FD_Error) *}

     		paclen	      : Word;
                maxFrame      : BYTE;
                flensburg     : Integer;     {* Strafkonto, fr dyn. Maxframe etc. *}
     		PID	      : T_PID;	     {* offset>8 wg. Heap-Framentliste *}
     		txq	      : Array [0..7] OF TP_mbuf; {* Transmit queue, dort stehen reine Infos drin  *}
		t1,t2,t3      : T_Timer;
                frameToSendT2 : T_FrameTyp;
		retry, tries  : BYTE;
		nr,			  {* Our receive state variable  *}
		nUnbest,		  {* Anzahl unbesttigter Frames *}
		lastack       : 0..7;	  {* Nr. des letzten I-Frames, das uns besttigt wurde *}
                fDama         : BOOLEAN;  {* 0=Keins, 1=Ich bin DAMA-Slave *}
		pf	      : T_KMPF;
		fIvePolled  : BOOLEAN;      {* Ich hab gepollt - braucht man nicht mehr?  kw 4.1.97 *}
	        txWind      : Word;  {* wird die TX-Queue lnger, so mu die Datenquelle pausieren *}
	        rxWind      : Word;  {* wird die RX-Queue lnger, so geht der DIGI lokal in RNR    *}
		rejSent,		  {* REJ frame has been sent  *}
		busy,                     {* wir sind busy *}
                RNRsent,                  {* wir sind nichtnur busy, sondern haben das auch gemeldet! *}
		remoteBusy : BOOLEAN;	  {* Remote sent RNR  *}
		QSOType       : (qtNULLQSO,
				 qtInfoBox,
				 qtConvers,
				 qtFlexRouter,
				 qtCircuitMaster, qtCircuitSlave,
				 qtBake,	  qtCQ,
				 qtBC, qtHOST
                                 );
		who	      : (user,sysop,auto);
		watchMode     : T_bg0Index; {* Querverweis auf WatchIndex *}
                fBeamt        : BOOLEAN;
		pPartnerCB    : TP_axCB;
		 {* CIRCUIT:	Controlblock des (versuchten) LinkPartners
		  *		wird auch zu erkennung des laufenden
		  *		Connectversuchs verwendet
		  * CONVERS:	ConnectversuchCB (nach /CON)
		  * CQ; 	CB des CQ-Ruf Auslsenden.
		  *}
	{* Adress-Informationen: *}
		iface	 : T_IFNr;   {* AX-Interface *}
		toCall, 	     {* so wie es vom DIGI rxed wurde *}
		fromCall : T_shCall; {* vom Digi aus gesehen, also meistens MYCALL *}
		Digi	 : T_Digis;
		nDigi	 : 0..8;     {* Anzahl Digis im Header *}
		nMyCall  : 0..8;     {* Digipeater Nr des eigenen Calls in .Digi; 0=Nycall=ToCall *}
	{* ^^^Darf nicht gendert werden, da fuer Autorouter relevant *}
                virtAdr  : WORD;     {* >0 -> virtuelleAdresse ala Flexnet. Dies ist dann die QSONr beim Partner *}
                fVirtAdr : BOOLEAN;  {* Ich sende in FlexCompress *}

		aktIfNr   : T_IFNR;  {* Default AX-IFaceNr, z.B.fr Infobox, wird gendert bei C Mycall *}
                nHeard    : BYTE;    {* Position des HeardBits inner Adresse *}
		pInfoBox  : TP_ib;
		pCv	  : TP_cv;    {* <> NIL ---> er ist im CONVERSmodus *}

		Divers : RECORD {* fr universelle Anwendungen: *}
		     CASE byte of
		     {*0 : (pDiv  : POINTER );*}
		      1 : (pLink : TP_Link ); {* Laufzeitmessung/FlexnetQSO : Zeiger auf Linkeintrag der gemessen wird *}
		      2 : (pText : TP_Text ); {* WRITE: Zeiger auf den T_Text, der geschrieben wird *}
		      3 : (pCqText : TP_STRING ); {* CQ: Zeiger auf den CQ-Text (PASCALSTRING) *}
                      {$IFDEF HostMode}
		      4 : (bHostKanal : BYTE ); {* Hostmodus: HostKanalnr *}
                      {$ENDIF}
		     END;

		redirectIfNr : BYTE; {* wenn<>0, dann wird dieses QSO dorthin umgeleitet *}

		wItx,wRRtx,wRNRtx,wREJtx,        {* Zhler gesendete Paketarten *}
		wIrx,wRRrx,wRNRrx,wREJrx,        {* Zhler empfangene Paketarten *}
		wRxPolls, wTXPolls	 : LongInt; {* Zhler fr Polls *}
		loginH,LoginM		 : BYTE; {* Login Zeit *}

                {* Spezial Timer. Arg und fnMsg drfen nie gendert werden.
                 * Es wird nach Ablauf immer die Message msgTimeOut versendet.
                 * Beispiele: LZM; Infoboxtimeout *}
		tTimeOut	      : T_Timer;

                {* Fr Messung vom Frack: *}
		tlastPoll,	     {* wenn der letzte RX-Paket mit Poll war, *}
				     {* steht hier die absolute Zeit, wann das *}
				     {* war, drin. Fr Dynamisches Frack *}
		minFrack,	     {* kleinstes gemessene FRACK *}
		messFrack : LongInt; {* das errechnette Frack *}
                {* Fr Messung vom TXDelay: *}
                txdn, txdsum,
	        txdmin,txdmax : Longint;
             END;


     T_DigiSystem = (dsNIL,dsANDERE,dsFLEXNET,dsNETROM,dsTCPIP,dsBOX); {* wird eingetragen und automatisch gendert *}
     T_DigiArt	  = (daUNKNOWN,daANDERE,daFLEXNET,daBAYCOM,daDIGIWARE,daSNET,daTNN); {* wird nur automatisch ermittelt *}
     T_TokenStat =(TOK_ICH, {* Ich habe das Token und darf Eintrge senden *}
		   TOK_ER,  {* Der Linkpartner hat das Token *}
		   TOK_ICH_REQ, {* Der Linkpartner hat das Token, aber ich habe es schon angefordert *}
		   TOK_ER_REQ);{* Ich habe es, aber der Linkpartner hat es schon angefordert *}
     T_Link = RECORD
       valid	: BOOLEAN;  {* ist die Satz berhaupt gltig ? *}
       id	: T_LinkID; {* Index der Tabelle, wird vom Flexrouter gebraucht *}
       direkt	: BOOLEAN;  {* wenn TRUE: Direkter LinkPartner *}
			    {* wenn FALSE: via-Linkpartner, der in *}
			    {* LINK[PORTNR] eingetragen ist *}
       PortNr	: BYTE;     {* logisches Port:		   *}
			    {* DIREKT=TRUE  Interfacenr. *}
			    {* DIREKT=FALSE Index der Linkeintrags des Nachbarn *}
       call	: T_shCall; {* Das Rufzeichen ohne SSID *}
       ssid_von,
       ssid_bis : 0..15;    {* Der SSID-Bereich *}
       system	: T_DigiSystem; {* Das wird manuell eingegeben *}
       art	: T_DigiArt;  {* "Hersteller" (wird gemessen) *}
       text	: STR30;    {* Info Text *}
       redirectPID : BYTE;  {* Wenn <> 0 werden Connects und UIs, die an den
                             * Digi (uns) selber gehen wrden, automatisch
                             * dorthin rerouted (experimentel) *}
       hidden	: BOOLEAN;  {* Eintrag nur fr Sysops sichtbar *}
       lzMessen : BOOLEAN;  {* Laufzeitmessen zu diesem Call durchfhren *}
       {* FlxRouter-Kram *}
       fLinkTxDest:BOOLEAN;  {* Destinations auf diesem Link weiterleiten *}
       {* flags: dieses Ziel weiterleiten; zu diesem Ziel weiterleiten; von diesem Ziel weiterleiten *}
       pCBRout	: TP_AXCB;  {* Zeiger aufs Flex-QSO, falls vorhanden, sonst NIL *}
       isOpt	: BOOLEAN;  {* Dieser direkt Weg ist auch der Optimale *}
       lastLZat : LongInt;  {* DEBUG:Letzte Laufzeitmessung startete um (slowTick). Wird nicht auf 0 gesetzt *}
       sekBisMess: integer; {* soviele Sekunden sind es noch bis zur nchsten Messung *}
       sekInit	 : Integer; {* Initialwert fr sekBisMess *}
       startZeit : longint; {* whrend der Messung: enthalt Fasttick der Messung, sonst immer 0*}
       {* Fr Flexnetpartner *}
       TokenStat : T_TokenStat;
       tSchnitt,	    {* enthlt immer den Schnitt, sowohl bei Dummis als auch bei FLEXNET *}
       tOur,		    {* Das haben wir gemessen... (nur FLEXNET) *}
       tThem	: T_LZ;     {* ...und das unser Gegenber (nur FLEXNET) *}
       tLz	: ARRAY [1..maxLZMESS] OF T_lz; {* Laufzeiten, tLz[1] ist immer das aktuellste *}
       t_max    : t_lz      {* Die per 4er Token erhaltene Maxzeit *}
  {*** RxInit : ARRAY [1..9] OF BYTE; {* bei Flex: Bytes des 0er Frame *}
       END;

CONST  maxLinks = 15;
VAR    nLinks : BYTE; {* Alle Saetze zwischen 1 und NLINKS MSSEN aufgefllt sein *}
       link : ARRAY [1..maxLinks] OF T_Link;

CONST  maxAXCB = 290;
VAR    cb : ARRAY [1..maxAXCB] OF TP_axcb;

{}
CONST nShPathDIGIS = 10;
      shpINVALID = 1+nShPathDIGIS; {* Inhalt der Felder Digis ist ungltig *}
TYPE T_shPath = RECORD
		  ifNr	  : T_IFnr;  {* 0 = Soll Autorouten *}
		  ilDigi  : 0..nShPathDIGIS+1;
		  {* Index des letzten Digis in Digi 0..nShPATHDIGIS *}
		  {* sowie Sonderwert: InValid *}
		  nMyCall : BYTE;	       {* Bei Bedarf... *}
		  Digi	  : ARRAY [0..nShPathDIGIS] OF T_ShCall;
		  {* 0 ist immer das from   Call *}
		END;

{}

 CONST	Busy = FALSE; {* ganzes TeilDigi-System ist busy (NoMem,reset) *}

	{* Eigene Laufzeitfehler *}
 CONST	RUNTIME_ERROR_OWN_OFFSET = 220; {* MAN SIND WIR STRUKTURIERT... *}
	ERR_LINK_TBL_LOOP = 1+RUNTIME_ERROR_OWN_OFFSET; {* Linkliste hat ne Schleife *}
	ERR_SEMA_MEM	  = 2+RUNTIME_ERROR_OWN_OFFSET;
	ERR_NO_MEM	  = 3+RUNTIME_ERROR_OWN_OFFSET;
	ERR_WRONG_HW	  = 4+RUNTIME_ERROR_OWN_OFFSET;
	ERR_NO_CONNECT	  = 5+RUNTIME_ERROR_OWN_OFFSET;
	ERR_IFACE_NE	  = 6+RUNTIME_ERROR_OWN_OFFSET; {* IFACE Strukturen verschieden gross *}
	ERR_TXROOT_NIL	  = 7+RUNTIME_ERROR_OWN_OFFSET; {* s. FD_PCSIO.PAS *}
	ERR_NO_ARGS	  = 8+RUNTIME_ERROR_OWN_OFFSET; {* s. FD_MAIN	  *}
	ERR_NO_RESOURCE   = 9+RUNTIME_ERROR_OWN_OFFSET;
	ERR_NO_INIBUFF	  =10+RUNTIME_ERROR_OWN_OFFSET; {* s. FD_SCC	  *}

{}

CONST everSysMinMaxAvail : LongInt = MAXLONGINT;
      everSysMaxMaxAvail : LongInt = 0;
VAR   sysMemAvail : LongInt;
      sysMaxAvail : LongInt;

VAR   SysTime : T_TIME;

CONST brStartTime : LongInt = -1;  {* Startzeit (SLOWTICK) der Messung *}
      brBytes	  : Longint = 0;   {* Anzahl der Bytes *}
{      brAvg	  : Longint = 0;   {* RX+TX-I-Frames von/an/ber uns *}

CONST smUA   =0;   {* Alle SABM werden auf allen Ports entgegengenommen *}
      smDMall=255; {* Alle SABM werden auf allen Ports zurckgewiesen *}
		   {* Werte 1..MAX_IFACE: SABM auf diesem Port zurckweisen *}
      SABMmode : BYTE = smUA; {* verhindert weitere UpLinks SABM-->DM *}

VAR  {* Nach dieser Zeit geht NoMoreUplink wieder auf OFF, *}
     {* nachdem ein SYSOP es angestellt hatte		   *}
      timSABMmode : T_Timer;
      timRestart  : T_Timer;
     {* Wird beim Hochfahren gestartet. Kommt innerhalb von 15 Minuten kein *}
     {* Connect zustande, wird Halt ausgelst, und EPROM Inhalt gestartet.  *}

{}

 CONST StandByStartUp : BOOLEAN = TRUE; {* Enthlt den Stand des StandByFlag, wie es beim Hochfahren stand *}

 CONST MAGIC = $a7e4;  {*$TODO Durch CRC ersetzen *}
       MAXRESET = 15;  {* Sooft werden Reset-Daten gespeichert; muss > 2 sein *}
       nCaller = 9;   {* Tiefe des Stack, wenn zwischengespeichert *}

       fEisKaltStart : BOOLEAN = TRUE;

 TYPE T_MEMDEBUG = RECORD
	  dontuse : ARRAY[1..8] OF Byte; {* Platzhalter fr Fragment-Pointer *}
	  pOrg : POINTER;
	  size : Word;
	  pCaller : pointer;
	  pCaller2: pointer;
	  END;
      T_sGrund = STRING[50];

 CONST {showLastProc : Word=0;}
       showLastISR  : Word=0;
       showPNilFN  : POINTER=NiL;
       showLastCmd : STRING='';

 VAR semL1 : RECORD {mit fd_sdlc.inc abgleichen}
	       {* ASM DEBUG - Nicht ndern zwischen diese Zeilen: *}
		asmCntRxErr,
		asmCntRxCrcErr,
		semExtInt2,
		semExtInt3,
		nExtIntSemErr    : WORD;
 	        semSpecInt0,
	        semSpecInt1,
	        semSpecInt2,
	        semSpecInt3,
	        nSpecIntSemErr : WORD;
                nPTTWatchDog0,
                nPTTWatchDog1,
                nPTTWatchDog2,
                nPTTWatchDog3 : WORD;
                nTxTail,
                nSendInt, nSendInt2,
                nAbort        : WORD;

                nDeb1, nDeb2  : WORD;

                fTail0,fTail1,fTail2,fTail3 : BYTE; {* =1 Tail luft *}
	       {* ASM DEBUG - ^Nicht ndern zwischen diese Zeilen^ *}
	       END ;
 VAR backup : RECORD
		{LastProc : Word;}
		LastISR  : Word;
		{MemDebug : T_MEMDEBUG;}
		pNilFN	 : POINTER;
		StartTime: ARRAY [1..MAXRESET] OF T_Time;
		nStackStore : WORD; {* Anzahl Stackspeicherung *}
		stack	 : ARRAY [1..MAXRESET] OF
			     RECORD
			       Caller	 : ARRAY [1..nCaller] OF pointer;
			       {*^^^^^ muss erstes Element im RECORD sein! *}
			       Grund	 : CHAR;
			       sData	 : T_sGrund;
			       tick	 : LongInt;
			       END;
		Err :  ARRAY [1..MAXRESET] OF
			 RECORD
			   Zeit : T_Time;
			   Adr : Pointer;
			   Code : Integer;
			   END;
		nReset	  : Word;
		nError	  : Word;
		nSoftWatchDogBite : Word;
		SWD_TICK : LongInt;
		last_Cmd  : STRING;
		semem  : Word;
		IntTableChged : Word;
		IntTbl_adr : Word;
		IntTbl_dat : Byte;
		magic : Word;  {* ganz hinten, damit auch struktur-ndrungen tdlich sind *}
	       END;

 CONST fdCS : Word = 0;   {* MainCodeSegment *}
       fdDS : Word = 0;   {* DataSegment *}
       {* Muessen auf 0 gesetzt werden, ansonsten sind bei Fehlern in den
        * Init-Teilen der Units keine (Fehler-)Adressen mehr rckrechenbar}

TYPE  T_IntTable = ARRAY [0..1023] OF Byte;
 VAR  intTable : T_intTable;


{}

VAR   bDummy : BYTE; {* Globale Variable in der Funtionsergebnisse, die *}
      wDummy : Word; {* nicht gebraucht werden, verschwinden knnen. *}
CONST LEERSTRING  = '';
      EOL_HOLEPARAMSTRING = EOL + '           ';


VAR pCBGlob : TP_AXCB;  {Test fr FD_IP}



{ Und es werden tatschlich auch Routinen "implementiert" ! }

 {* MauseFallen *}
 PROCEDURE New;
 PROCEDURE Dispose;
 PROCEDURE GetMem;
 PROCEDURE FreeMem;

 FUNCTION  NULL_InitCh_TRUE  (x:Byte) : BOOLEAN;
 FUNCTION  NULL_InitCh_FALSE  (x:Byte) : BOOLEAN;
 PROCEDURE NULL_Deinit	( x:Byte );
 FUNCTION  NULL_SetPara ( lokal_nr : BYTE;what:T_setPara;val:longint) : LONGINT;
 PROCEDURE NULL_TxPacket( pm : TP_Mbuf );
 PROCEDURE StoreStack ( cGrund : CHAR; sText : T_sGrund );

{}

IMPLEMENTATION

 FUNCTION  NULL_InitCh_TRUE  (x:Byte) : BOOLEAN;
 BEGIN
   NULL_InitCh_TRUE := TRUE;
 END;

 FUNCTION  NULL_InitCh_FALSE  (x:Byte) : BOOLEAN;
 BEGIN
   NULL_InitCh_FALSE := FALSE;
 END;

 PROCEDURE NULL_Deinit	( x:Byte);
 BEGIN
 END;

 FUNCTION NULL_SetPara ( lokal_nr:BYTE; what:T_setPara; val:longint) : LONGINT;
 BEGIN
   NULL_SetPara := speNNCMD; {* NULL is nix und kann nix *}
 END;

 PROCEDURE NULL_TxPacket( pm : TP_Mbuf );
 {* Paket sollte vernichtet werden !*}
 BEGIN
 END;

{* Vorsicht Falle! Nibbles, Schalter, Compilerfehler! *}
{* Falls jemand NEW oder DISPOSE verwendet, wird er   *}
{* hierdurch von Ede Compiler gefasst                 *}
PROCEDURE GetMem;  BEGIN END;
PROCEDURE FreeMem; BEGIN END;
PROCEDURE New;     BEGIN END;
PROCEDURE Dispose; BEGIN END;

{}

{$F+}
PROCEDURE StoreStack ( cGrund : CHAR; sText : T_sGrund );
  {* Fehlerquelle:
   * B,b = TxBufferSizeberlauf
   * C = CheckAXCB.pid=0
   * c = CheckAXCB.Ifacenr falsch
   *	 entfernt: D = DelAxcb
   * d = FD_Info.mhcircuit
   * E = Runtime - Error
   * F = Freemem, diverse
   * g = Get_mbuf-size = 0;
   * I = UnknownQso.IFace falsch
   * i = fd_tx.  inUse = 0
   * L = EntryDest
   * m = DelMbuf
   * N = fd_info.mhcircuit: pPartnerCB nicht vorhanden (bei cbdel)
   * n = fd_info.mhcircuit: pPartnerCB nicht vorhanden
   * r = fd_tx.RepeatPM
   * R = Startup-Restart-Timer
   * T = FD_TX.TxQueue_mBuf_chain-Falsche Parameter
   * U = UserListe: Falsche ID
   * W = Watchdog,
   * w = 2.HWD
   * 0 = CheckAXCB -> pCB = NiL
   * 1,2,3 = FD_SCC.sendPacket
   *}
  VAR i : BYTE;
BEGIN
  {* riteLn(cGrund,'  ', sText); *}
  FOR i := MAXRESET-1 DOWNTO 1 DO backup.stack[i+1] := backup.stack[i];
  FillChar ( backup.stack[1], sizeof(backup.stack[1]), #0 ) ;
  ASM
     PUSH BP
     MOV  AX,fdcs
     MOV  SI,offset backup.stack
     MOV  CX,nCaller
  @@1:
     LES  DI,[BP+02] {* Ret Adresse des Aufrufers *}
     MOV  WORD PTR [SI+2],ES
     MOV  WORD PTR [SI+0],DI
     SUB  WORD PTR [SI+2],AX {* Abziehen, damit man fuer MAP-File nicht umrechnen muss *}
     ADD  si,4
     MOV  BP,[BP+00] {* BP  des Aufrufers (zeigt immer insStackSegment) *}
     DEC  CX
     JNZ  @@1
     POP  BP
  END;
  backup.stack[1].grund := cGrund;
  backup.stack[1].tick	:= FastTick;
  backup.stack[1].sData := sText;
  Inc(backup.nStackStore);
END;

{}
BEGIN
  {$IFDEF wirdnichmehrgebraucht}
  {* Korrektur Loader 12/92. Muss hier erfolgen, da Heap noch nicht angetastet sein darf *}
  Writeln('--PreHeapPatch..', seg(Heapend^),':',ofs(HeapEnd^));
  IF seg(HeapEnd^) < $2000 THEN
    BEGIN
    Writeln('--InHeapPatch..');
    Inc (l2w(heapend).seg,$2000); {* heapend += 128k *}
    Mem[$FF00:$0F10] := Mem[$FF00:$0F10] AND NOT 8; {* p2 vom v25: Bit 3 auf 0 *}
    END;
  Writeln('--PostHeapPatch..');
  {$ENDIF}

{$IFDEF scc}

  {* SCC darf nicht im PC starten *}

  IF CSeg < $A000 then RunError(ERR_WRONG_HW);

  {* s. FD_INCL, ifdef scc *}


{$ENDIF}
  showLastCmd  := Backup.Last_Cmd;
{  showLastProc := Backup.LastProc;}
  showLastISR  := Backup.LastISR;
  showPNilFN   := Backup.PNilFN;

  FillChar(count,sizeof(count),#0);
  FillChar(semL1,sizeof(semL1),#0);
  FillChar(aDELTATIME,sizeof(aDELTATIME),#0);

  FillChar(use,  sizeof(use),#0);
  {use[iusFlensburg] := false;}
  use[iusrouteunknown] := true;


  fEisKaltStart := Backup.magic <> MAGIC;
  IF backup.nReset > 200 THEN fEisKaltStart := TRUE;
  everSysMaxMaxAvail := MaxAvail;
  Writeln( '--Mem:', everSysMaxMaxAvail );
END.



TNN-Auszug

I. Stati:

      0 L2SDSCED  -  disconnected
      1 L2SLKSUP  -  link setup
      2 L2SFRREJ  -  frame reject
      3 LS2DSCRQ  -  disconnect request
      4 L2SIXFER  -  information transfer

      5 L2SRS     -      REJ sent
      6 L2SWA     -  waiting acknowledge
      7 L2SDBS    -                  device busy
      8 L2SRBS    -                              remote busy
      9 L2SBBS    -                                           both busy
     10 L2SWADBS  -  waiting ack and device busy
     11 L2SWARBS  -  waiting ack and             remote busy
     12 L2SWABBS  -  waiting ack and                          both busy
     13 L2SRSDBS  -     REJ sent and device busy
     14 L2SRSRBS  -     REJ sent and             remote busy
     15 L2SRSBBS  -     REJ sent and both                     busy



                     Rej Sent   Wait Ack   device busy  remote busy
      5 L2SRS     -      x
      6 L2SWA     -                 x
      7 L2SDBS    -                              x
      8 L2SRBS    -                                           x
      9 L2SBBS    -                              x            x
     10 L2SWADBS  -                 x            x
     11 L2SWARBS  -                 x                         x
     12 L2SWABBS  -                 x            x            x
     13 L2SRSDBS  -      x                       x
     14 L2SRSRBS  -      x                                    x
     15 L2SRSBBS  -      x                       x            x



II. Ereignisse.

 RX: I    WITH POLL    (COMMAND)
 RX: I    WITH POLL    (COMMAND), DAMA-Mode
 RX: I    WITHOUT POLL (COMMAND)
 RX: I    WITHOUT POLL (COMMAND), DAMA-Mode
 RX: RR   WITH POLL    (COMMAND)
 RX: RR   WITHOUT POLL (COMMAND)
 RX: RNR  WITH POLL    (COMMAND)
 RX: RNR  WITHOUT POLL (COMMAND)
 RX: SABM EITHER       (COMMAND)
 RX: DISC EITHER       (COMMAND)
 RX: RR   WITH FINAL   (RESPONSE)
 RX: RNR  WITH FINAL   (RESPONSE)
 RX: UA   EITHER       (RESPONSE)
 RX: DM   EITHER       (RESPONSE)
 RX: FRMR EITHER       (RESPONSE)

 INVALID N(S) RECEIVED WITHOUT POLL
 INVALID N(S) RECEIVED WITH POLL

 T1 EXPIRES (VERSION 2)
 T3 EXPIRES

 STATION BECOMES BUSY
 BUSY CONDITION CLEARS

III Aktionen:
  xdm();  xnull();  xfrmr();  xrrr();  xrnrr();  t2rrr();  t2rnrr();
  xua();  xsabm();  xdisc();  xrrc();  xrnrc();  t2rejr();  xrejr();

