UNIT FD_DCF; {* DCF-77 Unit fuer FALCon/DigiWare   *}
             {* Mrz  1992 DL7GAI (PC-DigiWare)    *}
             {* 06/07 1993 DL7GAI (FALCon/DigiWare *}
{$I fd_incl.pas}
INTERFACE
USES FD_Def;
{$IFnDEF dcf} #### Huch! da stimmt was mit $DCF nicht! #### {$ENDIF}

{DCF-77}

CONST DCF_Code_Count :INTEGER=0;      {* Zaehler Zeitcode Position *}
      DCF_Seq_Error  :LongInt=0;      {* Zaehler fr aufeinanderfolgende Fehler (wg.Prompt) *}
      DCF_Sw_Back    :INTEGER=10;     {* Nach soviel dcf_seq_err's wird sZeitZone auf 'LOCAL' gesetzt *}
      dcf_start_count:INTEGER=0;      {* Zaehler fuer das 'Start-Loch' *}
      DCF_Count      :INTEGER=15;     {* Zaehler (sec) wann naechste decodierung Startet *}
      DCF_Sync_Timer :INTEGER=50;     {* alle dcf_sync_timer+10+60 sec wird Systime synchronisiert *}
      DCF_Set_Count  :LongInt=0;      {* Zaehler wieoft dcf-zeit gesetzt wurde*}
      DCF_Last_Set   :String[40]='';
      DCF_Last_Err   :String[40]='';
      to_do_dcf      :BOOLEAN=TRUE;   {* DCF-Auswertung an oder aus schalten *}
      dcf_set        :BOOLEAN=FALSE;  {* DCF-Time kann gesetzt werden *}
      DCF_Error      :LongInt=0;      {* DCF-Auswerte-Fehler insgesamt*}
      DCF_Start      :BOOLEAN=FALSE;  {* True wenn Start gefunden *}
      dcf_ok         :BOOLEAN=FALSE;  {* true wenn 59 sec gelesen wurde *}
      do_dcf         :BOOLEAN=TRUE;   {* true wenn decodierung laeuft *}
{*      dcf_prompt  ist nun fd_def.sZeitZone *}
      dcf_time_code  :ARRAY[0..59]    {* 60 wegen schaltsekunde ??}
                      OF INTEGER=(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
      dcf_sec              =0;    {* Sec. *}
      dcf_min         :Byte=0;    {* Minute *}
      dcf_std         :Byte=0;    {* Stunde *}
      dcf_wot         :Byte=0;    {* Wochentag *}
      dcf_tag         :Byte=0;    {* Tag *}
      dcf_mon         :Byte=0;    {* Monat *}
      dcf_jah         :Byte=0;    {* Jahr *}

{DCF-77}

PROCEDURE DCF_Init;
PROCEDURE DCF_Stop;
FUNCTION  DCF_Puls:BOOLEAN;

PROCEDURE DCF_inc;             {* jede sec DCF_count erhoehen *}
PROCEDURE DCF_check;           {* prefen, ob decodierung angeworfen werden soll *}
{$F+}PROCEDURE DCF_pulse_dedection;{$F-} {* wird von fd_timer.new_int_08 aufgerufen *}
{$F+}PROCEDURE DCF_compute_time;   {$F-} {* decoder fr dcf *}
{$F+}PROCEDURE Set_DCF_time;{$F-} {* DCF Date and Time -> SYSTEM DATE and TIME*}
PROCEDURE DCF_Error_Termination(Arg:ShortInt); {* Abbruch; naechsten Start vorbereiten *}
PROCEDURE DCF_Trigger;  {* Nchste Auswertung vorbereiten *}
PROCEDURE calc_DCF_SwBack;

IMPLEMENTATION

USES FD_Div,
     FD_Log,
     FD_Timer,
 {$IFDEF SCC}
     fd_scc,
     FD_Tnc,
     FD_Tx
 {$ELSE}
     FD_CRT,
        Dos
 {$ENDIF}
     ;



{$IFDEF SCC}
PROCEDURE DCF_Init;            {* Port 0 Bit 7 = Input *}
BEGIN
{*  SetIO(6,1);        {* zu Debug-Zewcken an DL7GAI's Port-0 LED-MONITOR*}
  IF ((pm0_Read AND $80)=$00) THEN pm0_Write(pm0_Read+$80);
END;

PROCEDURE DCF_Stop;
BEGIN
{*  SetIO(6,0);       {* zu Debug-Zewcken an DL7GAI's Port-0 LED-MONITOR*}
  IF ((pm0_Read AND $80)=$80) THEN pm0_Write(pm0_Read-$80);
END;

FUNCTION  DCF_Puls:BOOLEAN;    {* true wenn logisch 0 an port 0 bit 7 *}
BEGIN
  DCF_Puls := (GetIO(7)=0); {* Puls vom Conrad smd-rx *}
END;

{$ELSE}

CONST DCF_Port= $3fe; {* bei DL7GAI hngt der DCF-RX an COM 1 und *}
                      {* das Interface des RX wird mit RTS        *}
                      {* eingeschaltet, an CTS liegt der DCF-Takt *}

PROCEDURE DCF_Init; (* RTS am com-Port auf positives potential *)
BEGIN
  WriteLn ('- DCF Init');
  IF (Port[DCF_Port-2] AND 2=0) THEN Port[DCF_Port-2]:=Port[DCF_Port-2] + 2;
  {* port bit koennte ja schon gesetzt sein !!! *}
END;

PROCEDURE DCF_Stop;   {* RX ausschalten *}
BEGIN
  (* RTS am aktuellen com-Port negatives potential *)
  IF (Port[DCF_Port-2] AND 2=2) THEN Port[DCF_Port-2]:=Port[DCF_Port-2] - 2;
END;


FUNCTION DCF_Puls:BOOLEAN;  (* CTS auf plus potential=TRUE *)
BEGIN
  DCF_Puls:=Port[DCF_Port] AND $10 =16;
  DCF_Puls := Random(60)<30;
END;
{$ENDIF}


{$R-}PROCEDURE DCF_inc;{$R+}  {* jede sec dcf_count erhoehen *}
BEGIN
  IF (to_do_dcf AND NOT do_dcf) THEN Inc(DCF_Count);
END;

{$R-}PROCEDURE DCF_check;{$R+}{* prfen, ob decodierung angeworfen werden soll *}
BEGIN
  IF DCF_Count>DCF_Sync_Timer-1 THEN DCF_Trigger; {* Schmeis den Riemen auf die ORGEL und hole die Impulse *}
END;

{* achtung wird von interrupt fd_timer.neu_int_08 aufgerufen ***}
{$F+$R-}PROCEDURE DCF_pulse_dedection; {$F-$R+}
BEGIN
  IF NOT DCF_Start THEN
    BEGIN   {* DCF-Start-Lcke suchen *}
    IF ((dcf_start_count>130) AND DCF_Puls) THEN DCF_Start:=TRUE;
    IF (NOT DCF_Puls) THEN Inc(dcf_start_count)
                      ELSE dcf_start_count:=0;
    {*RX is ausgeschaltet !!!! oder dcf-tx ausgefallen? nach 5 sec abbrechen *}
    IF dcf_start_count>500 THEN DCF_Error_Termination(5);
    END;
  IF DCF_Start THEN
    BEGIN
    IF DCF_Code_Count>58 THEN
      BEGIN  {* alle 59 impulse gelesen *}
      DCF_Code_Count:=0;
      DCF_Start:=FALSE;
      do_dcf:=FALSE;
      dcf_ok:=TRUE;
      dcf_start_count:=0;
      END;
    END;
  IF DCF_Start THEN
    BEGIN
    IF DCF_Puls THEN Inc(dcf_time_code[DCF_Code_Count]); {* Impuls-Abtastung *}

    {* wenn dcf ausfllt gibts bei meinem RX-Impulsausgang dauer 1 -> nach ~ 2,5 sec abbrechen !!*}
    IF dcf_time_code[DCF_Code_Count]>250 THEN DCF_Error_Termination(1);

    IF NOT DCF_Puls THEN
      BEGIN
      IF (dcf_time_code[DCF_Code_Count]<19) AND
         (dcf_time_code[DCF_Code_Count]>5)  THEN
           BEGIN
           IF DCF_Code_Count<59 THEN Inc(DCF_Code_Count);
           dcf_time_code[DCF_Code_Count]:=0;
           END;
      END;
    END;
END;

{$F+}
PROCEDURE DCF_compute_time; {$F-} (* decoder fr DCF *)
VAR tm:INTEGER;
    i:ShortInt;
    mi,st,ta,mo,ja:String[2];
    dcf_dummy:String[35];
    csum:ShortInt;

CONST wtag:ARRAY[1..7] OF String[2] = ('Mo','Di','Mi','Do','Fr','Sa','So');

  FUNCTION bcd(cp,co:ShortInt):ShortInt;
  {* berechne BCD-Wert (incl. cp -> co bit's *}
    VAR x,y,wert:ShortInt;
  BEGIN
    y:=1;
    wert:=dcf_time_code[cp];
    FOR x:=1 TO co-1 DO wert:=wert+(dcf_time_code[cp+x]*(y SHL x));
    bcd:=wert;
  END;

  FUNCTION str_and_null(wert:Byte):String;
  VAR inwert:String;
  BEGIN
    inwert:=f_Using(wert,2);
    IF inwert[1]=' ' THEN inwert[1]:='0';
    str_and_null:=inwert;
  END;

BEGIN
  dcf_ok:=FALSE;
  dcf_set:=FALSE;

  tm:=0;
  FOR i:=0 TO 14 DO tm:=tm+dcf_time_code[i];
  tm:=Round(tm/10);

  FOR i:=0 TO 58 DO
    IF dcf_time_code[i]<tm
      THEN dcf_time_code[i]:=0
      ELSE dcf_time_code[i]:=1;

  csum:=0; {* PARITY CHECK  ueber alle 3 Paritaetsbits.. *}
  FOR tm:=21 TO 58 DO csum:=csum+dcf_time_code[tm]; {* Fehler im Code ? *}
  IF System.Odd(csum) THEN BEGIN         {* Ja !! *}
                           DCF_Last_Err:='Parity ERROR at: '+l_Uhrzeit(Systime.hour,Systime.min,Systime.sec);
                           DCF_Error_Termination(2);
                           Exit;
                           END;

  {* Bit 20 muss immer 1 sein ! *}
  IF dcf_time_code[20]=0 THEN BEGIN
                              DCF_Last_Err:='Decode-Error: Bit 20 = 0';
                              DCF_Error_Termination(2);
                              Exit;
                              END;

  dcf_wot:=bcd(42,3);

  {* Test: ob wochentag rangecheck bringen kann ??? *}
  {* Ja kann er !!! 21.06.93 nachts : 4 mal dcf_wot=0 !!!! *}
  {* aba nix passiert hi weil : *}

  IF (dcf_wot<1) OR (dcf_wot>7) THEN
    BEGIN
    DCF_Last_Err:='Range Check, Weekday: '+f_Using(dcf_wot,2);
    DCF_Error_Termination(2);
    Exit;
    END;

  dcf_dummy:=wtag[dcf_wot]+' ';
  dcf_tag:=(10*bcd(40,2))+bcd(36,4);
  ta:=str_and_null(dcf_tag);

  dcf_mon:=(10*dcf_time_code[49])+bcd(45,4);
  mo:=str_and_null(dcf_mon);

  dcf_jah:=(10*bcd(54,4))+bcd(50,4);
  ja:=str_and_null(dcf_jah);

  dcf_dummy:=dcf_dummy+ta+'.'+mo+'.'+ja+' ';

  dcf_std:=10*bcd(33,2)+bcd(29,4);
  st:=str_and_null(dcf_std);

  dcf_min:=10*bcd(25,3)+bcd(21,4);
  mi:=str_and_null(dcf_min);

  dcf_dummy:=dcf_dummy+st+':'+mi+':00 ';

  {* ab und zu trotz allen checks: fehldekodierungn abfangen.. *}
  {* deshlab muss min. 1 mal das datum (jahr) richtig gesetzt werden ! *}
  IF (Systime.Year<>1900+dcf_jah) AND
     (Systime.Year+1<>1900+dcf_jah) THEN BEGIN
                                         DCF_Last_Err:=dcf_dummy;
                                         DCF_Error_Termination(2);
                                         Exit;
                                         END;
  Inc(DCF_Set_Count);

  DCF_Last_Set:=dcf_dummy;

  IF dcf_time_code[17]=0 THEN sZeitZone:='MEZ'
                         ELSE sZeitZone:='MESZ';

  DCF_Last_Set:=DCF_Last_Set+sZeitZone+' ';

  IF dcf_time_code[ 4]=1 THEN DCF_Last_Set:=DCF_Last_Set+'N'; {* Ausfall eines Csium's *}
  IF dcf_time_code[15]=1 THEN DCF_Last_Set:=DCF_Last_Set+'R'; {* Reserve TX/Ant *}
  IF dcf_time_code[16]=1 THEN DCF_Last_Set:=DCF_Last_Set+'W'; {* Ankndigung: Zeitzonenwechsel *}
  IF dcf_time_code[19]=1 THEN DCF_Last_Set:=DCF_Last_Set+'S'; {* Ankndigung: Schaltsekunde *}


  IF (dcf_time_code[ 4]=1) OR
     (dcf_time_code[15]=1) OR
     (dcf_time_code[16]=1) OR
     (dcf_time_code[19]=1) THEN {* nach dem motto:  tnschen please *}
     LogAddEntry(NiL,leDCF,'ATN: '+DCF_Last_Set);

{*  setdate(1900+dcf_jah,dcf_mon,dcf_tag);   fix 7gai 19,8.93 *}

  DCF_Seq_Error:=0;
  dcf_set:=TRUE;
END;

{$F+$R-}PROCEDURE Set_DCF_time;{$F-$R+} {* DCF Date and Time -> SYSTEM DATE and TIME*}
BEGIN
  SetTime(dcf_std,dcf_min,dcf_sec,dcf_sec);
  SetDate(1900+dcf_jah,dcf_mon,dcf_tag);  {* fix 7gai 19,8.93 *}
  Systime.sec:=dcf_sec;
  Systime.min:=dcf_min;
  Systime.hour:=dcf_std;
  dcf_set:=FALSE;
  DCF_Stop;
  DCF_Count:=0;
END;


{^^^^^^achtung wird von interrupt fd_timer.neu_int_08 aufgerufen ***}


PROCEDURE DCF_Error_Termination(Arg:ShortInt); {* Abbruch; naechsten Start vorbereiten *}
VAR svalue:str3;
    log_dummy:str40;
BEGIN
  Inc(DCF_Error);       {* Gesamtzahl der aufgetretenen Fehler *}
  Inc(DCF_Seq_Error);   {* Anzahl der aufeinanderfolgenden Fehler*}
  IF DCF_Seq_Error>=DCF_Sw_Back THEN sZeitZone:='Local';
  FOR DCF_Code_Count:=0 TO 58 DO dcf_time_code[DCF_Code_Count]:=0;
  dcf_start_count:=0;
  DCF_Code_Count:=0;
  do_dcf:=FALSE;
  DCF_Start:=FALSE;
  dcf_ok:=FALSE;
  DCF_Stop;
  CASE Arg OF
   1: BEGIN
      DCF_Last_Err:='Pulse Detection Error';
      log_dummy:=DCF_Last_Err;
      END;
   2: log_dummy:=DCF_Last_Err;
   3: BEGIN
      DCF_Last_Err:='';
      dcf_start_count:=0;
      DCF_Code_Count:=0;
      DCF_Start:=FALSE;
      dcf_ok:=FALSE;
      DCF_Stop;
      DCF_Error:=0;
      DCF_Seq_Error:=0;
      log_dummy:='Decoder-Init';
       END;
   4: BEGIN
      Dec(DCF_Seq_Error);
      Dec(DCF_Error);
      IF to_do_dcf THEN svalue:='ON '
                   ELSE svalue:='OFF';
      log_dummy:='Switched '+svalue+' by SysOp';
      END;
   5: BEGIN
      DCF_Last_Err:='Start-Gap >5 sec. RX-Failure';
      log_dummy:=DCF_Last_Err;
      END;
  END;
  {* weil mir die 70'er hf in den rx drueckt: und arg 1 dann bei mir ueberwiegt: *}
  CASE Arg OF
   2..5 :LogAddEntry(NiL,leDCF,log_dummy);
  END;
END;

PROCEDURE DCF_Trigger; {* Nchste Auswertung vorbereiten *}
BEGIN
  DCF_Count:=0;
  DCF_Code_Count:=0;
  DCF_Init;
  DCF_Start:=FALSE;
  do_dcf:=TRUE;
END;

PROCEDURE calc_DCF_SwBack;
  {* nach soviel fehlerhaften dekodierungen in folge *}
  {* prompt auf Local zurueckschalten *}
BEGIN
  DCF_Sw_Back:=32580 DIV (DCF_Sync_Timer+70);
END;

BEGIN
  Calc_DCF_SwBack;
END.
