UNIT FD_CRT;    {* ersetzt die Units CRT, CRT2. So eine Art Video-BIOS *}
                {* Nur bei Einsatz auf PCs                             *}
                {* Beim SCC: FD_TNC                                    *}

{$IFDEF VER70} {$C FIXED PERMANENT PRELOAD} {$ENDIF}
{$I FD_INCL.PAS}

{$IFDEF SCC}
     ! Wenn SCC an ist, darf diese UNIT nicht eingebunden werden !
         ! Bitte kontolliert die USES IN den anderen Modulen !
{$ENDIF}

{}

INTERFACE

USES  CRT,DOS,fd_def;

{* Gegenstcke zur FALCon Hardware *}
PROCEDURE WatchDog;
PROCEDURE _portena;
PROCEDURE _portdis;
PROCEDURE SwitchStaLed(ifnr:T_Ifnr; mode : t_doLED);

CONST {* Werte fr den PC *}
  TNC_CLOCK      = 8000000;  (* 8 Mhz Takt nur vorerst *)
  IRQ_FINISH_ADR = $20;    (* Adresse fr Ende des Interrupts *)
  IRQ_MASK_ADR   = $21;    (* Adresse des Interrupt-Maskenregisters *)
  TIMER_CLOCK    = 1192700;{* Takt des 8253 *}
  TIMER_0        = $40;    (* Timer 0 Datenport *)
  TIMER_1        = $41;    (* Timer 1 Datenport *)
  TIMER_2        = $42;    (* Timer 2 Datenport *)
  TIMER_CONTROL  = $43;    (* Timer Control Port *)


CONST BLINK = CRT.Blink;

TYPE t_OutCrt = (prim,sek) ;

VAR  WindMin,
     WindMax : Word;
     Con2    : Text;

PROCEDURE SetCrtMoni ( x : t_outCrt );
PROCEDURE RevertMonitor;
PROCEDURE ShowMonitor ( x : T_outCRT);

PROCEDURE SetTextAttr ( X : Byte );
FUNCTION  GetTextAttr : Byte ;

PROCEDURE ClrScr;
PROCEDURE ClrEol;
PROCEDURE GotoXY(X, Y : Byte);
 FUNCTION WhereY: Byte;
 FUNCTION WhereX: Byte;
PROCEDURE Window (X1, Y1, X2, Y2: Byte);
PROCEDURE Sound ( hz : Word );
PROCEDURE NoSound;
PROCEDURE Delay ( ms : WORD);
 FUNCTION ReadKey: Char;
 FUNCTION KeyPressed : BOOLEAN;

{}

IMPLEMENTATION

PROCEDURE WatchDog;
BEGIN
  SWD_Tick := SWD_Init;
END;

{* Nix! *}
PROCEDURE _portena; assembler; asm END;
PROCEDURE _portdis;assembler;  Asm END;

PROCEDURE SwitchStaLed(ifnr:T_Ifnr; mode : t_doLED);
BEGIN {* Ersatzweise was mit Scrolllocklampe machen *}
  Case mode of
    cAUSSCHALTEN : mem[$040:023] := mem[$040:023] AND (NOT 16);
    cANSCHALTEN  : mem[$040:023] := mem[$040:023] OR  16;
    cUMSCHALTEN  : mem[$040:023] := mem[$040:023] XOR 16;
    END;
END;

{}

PROCEDURE AssignCRT2(VAR F: Text); FORWARD;


 VAR x,y       : Byte;
     pVioSeg   : ^Word;  {* Zeigt auf die NICHT-DOS Karte *}
 VAR WindMax2, WindMin2 : Word;
     TextAttr2 : Byte;

CONST outCRT : t_outCrt = PRIM;  {* Variable, wohin eine Std-CRTausgabe+Funktion (clrscr etc) geht *}
      hauptCRT : T_OUTCRT = PRIM;  {* Physikalische Umsetzung zu outCRT *}

{* Es gibt zwei physkalische (Haupt und Neben) Monnitore und zwei logische
   (Primr und sekundr) Schirme. Der NebenMonitor braucht nicht vorhanden zu
   sein.
   outCRT enthlt den Namem des logischen Schirm, auf den die Std-Funktionen
   Write,ClrScr etc. wirken.
   hauptCRT enthlt den Namem des logischen Schirm, der auf dem Hauptmonitor
   z.Zt. dargestellt wird.
   Ist also outCrt=hauptcrt so wird z.B. clrscr auf dem Hauptmonitor
   ausgefhrt.
   Mchte man also CRT Funktionen auf einen bestimmten Schirm ausfhren, muss
   man ihn zunchst mit SetCrtMoni umschalten. Dabei wird NICHT der physikalische
   Schirm umgeschaltet!
   Ausnahme: mit Write(con2, irgendwas ); kann man immer auf dem Logischen
   Sekundr-Monitor schreiben (wegen der NICHT-Perfomance der Umschaltung).
   Wirkliches Umschalten (so dass der eine logische Schirm z.B. vom Neben-
   auf den HauptMonitor wandert) geschieht mit ShowMonitor(Prim) bzw.
   ShowMonitor(Sek). Als Argument wird angegeben welcher logischer Schirm
   auf dem Hauptmonitor erscheinen soll
*}

{}
{* Versorgt den phsikalisch zweiten, nicht CRT gesttzten Monitor           }
{}

PROCEDURE ClrScr2;
BEGIN
  FillChar (Ptr(pVioSeg^,0)^,2*80*25,0);
END;

PROCEDURE ClrEol2;
BEGIN
  FillChar (Ptr(pVioSeg^,2*x+160*y)^,(160-2*x),0);
END;

PROCEDURE Window2 (X1, Y1, X2, Y2: Byte);
BEGIN
  WindMax2 := $100*y2 + x2;
  WindMin2 := $100*y1 + x1;
END;

{}

PROCEDURE RevertMonitor;
  VAR hb : BYTE;
BEGIN
  IF hauptCRT=PRIM
            THEN BEGIN
                 AssignCRT  (con2);   Rewrite (con2);
                 AssignCRT2 (output); Rewrite (output);
                 hauptCRT := sek;
                 END
            ELSE BEGIN
                 AssignCRT (output); Rewrite (output);
                 AssignCRT2 (con2);  Rewrite (con2);
                 hauptCRT := prim;
                 END;
  hb := Crt.TextAttr; Crt.TextAttr := TextAttr2; TextAttr2 := hb;
  CRT.ClrScr;
  ClrScr2;
END;


PROCEDURE SetCrtMoni ( x : t_outCrt );
BEGIN
  outCRT := x;
END;

PROCEDURE ShowMonitor ( x : T_outCRT);
BEGIN
  IF x<>hauptCRT
    THEN RevertMonitor
    ELSE {* steht schon auf dem gewuenschten Monitor *}
         IF hauptCRT=SEK THEN Write (con2, #13#10' ***** SEKUNDRER ***** '#13#10)
                         ELSE Write ( #13#10' ***** PRIMRER ***** '#13#10);
END;


PROCEDURE SetTextAttr ( X : Byte );
BEGIN
  IF outCRT = hauptCRT THEN CRT.TextAttr := x
  		       ELSE TextAttr2 := x;
END;

FUNCTION GetTextAttr : Byte ;
BEGIN
  IF outCRT = hauptCRT THEN GetTextAttr := CRT.TextAttr
		       ELSE GetTextAttr := TextAttr2;
END;

PROCEDURE ClrScr;
BEGIN
  IF outCRT = hauptCRT THEN CRT.ClrScr
    		       ELSE ClrScr2;
END;

PROCEDURE ClrEol;
BEGIN
  IF outCRT = hauptCRT THEN CRT.ClrEol
  		       ELSE ClrEol2;
END;

PROCEDURE GotoXY( x,y : Byte);
BEGIN
  IF outCRT = hauptCRT
    THEN CRT.GotoXY (x,y)
    ELSE BEGIN
         fd_crt.x := x-1;
	 fd_crt.y := y-1;
	 END;
END;

FUNCTION WhereX: Byte;
BEGIN
  IF outCRT = hauptCRT THEN Wherex := CRT.WhereX
	   	       ELSE WhereX := x+1;
END;

FUNCTION WhereY: Byte;
BEGIN
  IF outCRT = hauptCRT THEN WhereY := CRT.WhereY
      		       ELSE WhereY := y+1;
END;

PROCEDURE Window (X1, Y1, X2, Y2: Byte);
BEGIN
  IF outCRT = hauptCRT THEN CRT.Window (X1, Y1, X2, Y2 )
  		       ELSE Window2(X1, Y1, X2, Y2 );
END;

PROCEDURE Sound ( hz : Word );
BEGIN
  CRT.Sound (hz);
END;

PROCEDURE NoSound;
BEGIN
  CRT.NoSound;
END;

PROCEDURE Delay ( ms : WORD);
BEGIN
  CRT.delay (ms);
END;

FUNCTION ReadKey: Char;
BEGIN
  ReadKey := CRT.ReadKey;
END;

FUNCTION KeyPressed : BOOLEAN;
BEGIN
  KeyPressed := CRT.KeyPressed;
END;

{}

FUNCTION CRT2Output(VAR F: TextRec): INTEGER;  FAR;  {* puffer voll *}
  PROCEDURE IncY;
  BEGIN
    IF y < 24 THEN Inc (y)
	      ELSE BEGIN {* Scrollen *}
		   Move (Ptr(pVioSeg^,160)^,Ptr(pVioSeg^,0)^,24*160);
		   FillChar (Ptr(pVioSeg^,24*160)^,2*80,0);
		   END;
  END;
VAR i : Word;
    b : Byte;
BEGIN
  CRT2Output:=0;
  IF f.bufpos < 1 THEN Exit; {* goar nix drin... *}
  FOR i := 0 TO f.bufpos-1 DO
    BEGIN
    b := Byte (f.bufptr^[i]);
    CASE b OF
	7 : Write (#7);
	8 : IF x>0 THEN Dec(x);
       10 : IncY;
       13 : x := 0
       ELSE BEGIN
	    MemW [pVioSeg^:2*x+160*y] := Word ($100 * TextAttr2 ) + b;
	    Inc (x);
	    IF x > 79 THEN BEGIN
			   x := 0;
			   IncY;
			   END;
	    END; {*ELSEcase*}
      END ; {*case*}
    END; {*for*}
  f.bufpos := 0;
END;

FUNCTION CRT2Close (VAR F: TextRec): INTEGER;      FAR;
BEGIN
  CRT2Close:=0;
END;

FUNCTION CRT2Open(VAR F: TextRec): INTEGER;  FAR;
BEGIN
  WITH F DO
    BEGIN
    IF Mode=fmInput
      THEN CRT2Open := 1
      ELSE BEGIN
	   Mode:=fmOutput;
	   InOutFunc:=@CRT2Output;
	   FlushFunc:=@CRT2Output;
	   CloseFunc:=@CRT2Close;
	   Bufpos := 0;
	   bufptr := @Buffer;
	   bufSize := SizeOf(Buffer);
	   CRT2Open:=0;
	   x := 1;
	   y := 1;
	   TextAttr := CRT.TextAttr;
	   END;
    END;
END;

PROCEDURE AssignCRT2(VAR F: Text);
BEGIN
  WITH TextRec(F) DO
    BEGIN
    Handle:=$FFF1;
    Name [0] := #0;
    Mode:=fmClosed;
    OpenFunc:=@CRT2Open;
    END;
END;

{}

PROCEDURE PseudoRemote (Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : Word);INTERRUPT;
BEGIN
{$IFDEF remote_austesten_unter_dos *}
  flags := flags AND NOT FCARRY;  {* kein Fehler *}
  CASE hi(ax) OF
    0 : BEGIN
        ax := 0;
        bx := 0;
        END;
    1 : BEGIN
        ax := $b000;
        END;
    1 : BEGIN
        ax := $0000;
        END;
    ELSE BEGIN
         flags := flags OR FCARRY;  {* Fehler anzeigen *}
         ax := 4;                   {* Fehlercode "ungltige Funktionsnummer" *}
         END;
    END; {case}
{$ELSE}
  flags := flags OR FCARRY;  {* Fehler anzeigen *}
  ax := 4;                   {* Fehlercode "ungltige Funktionsnummer" *}
{$ENDIF}
END;

{}
  VAR ral : Byte;
BEGIN
  ClrScr;
  SetIntVec ($ff, @PseudoRemote );  {* RemoteUpload Interupt des Falcon emulieren *}
{$IFDEF os2}
  AssignNul (Con2);
  Rewrite (Con2);
{$ELSE}
  ASM
    MOV ah,15d    {* Video - Modus abfragen *}
    INT 10h       {* Video BIOS-Interupt *}
    MOV ral,al
  END; {* 7 = Hercules *}
  IF ral=7 THEN pVioSeg := @segB800
	   ELSE pVioSeg := @segB000;

  {* 2. Bildschirm emulieren *}
  WindMax2 := 24*$100+79;  WindMin2 := 0000;
  AssignCRT2 (Con2);
  Rewrite (Con2); ClrScr2;
{$ENDIF}
END.
