{$I FD_INCL.PAS}
UNIT FD_CRC;

INTERFACE

USES fd_Def;

 FUNCTION Calc_CRC16( first : WORD; pBuf : Pointer; n : WORD) : WORD;
{$IFnDEF SCC}
 FUNCTION Calc_CRCFlex( first : WORD; pBuf : Pointer; n : WORD) : WORD;
{$ENDIF}
 FUNCTION Calc_CRCFBB( first:WORD; adr:pointer; size:WORD) : WORD;

 CONST crc_smack_table : ARRAY [0..255] OF WORD = (
    $0000, $c0c1, $c181, $0140, $c301, $03c0, $0280, $c241,
    $c601, $06c0, $0780, $c741, $0500, $c5c1, $c481, $0440,
    $cc01, $0cc0, $0d80, $cd41, $0f00, $cfc1, $ce81, $0e40,
    $0a00, $cac1, $cb81, $0b40, $c901, $09c0, $0880, $c841,
    $d801, $18c0, $1980, $d941, $1b00, $dbc1, $da81, $1a40,
    $1e00, $dec1, $df81, $1f40, $dd01, $1dc0, $1c80, $dc41,
    $1400, $d4c1, $d581, $1540, $d701, $17c0, $1680, $d641,
    $d201, $12c0, $1380, $d341, $1100, $d1c1, $d081, $1040,
    $f001, $30c0, $3180, $f141, $3300, $f3c1, $f281, $3240,
    $3600, $f6c1, $f781, $3740, $f501, $35c0, $3480, $f441,
    $3c00, $fcc1, $fd81, $3d40, $ff01, $3fc0, $3e80, $fe41,
    $fa01, $3ac0, $3b80, $fb41, $3900, $f9c1, $f881, $3840,
    $2800, $e8c1, $e981, $2940, $eb01, $2bc0, $2a80, $ea41,
    $ee01, $2ec0, $2f80, $ef41, $2d00, $edc1, $ec81, $2c40,
    $e401, $24c0, $2580, $e541, $2700, $e7c1, $e681, $2640,
    $2200, $e2c1, $e381, $2340, $e101, $21c0, $2080, $e041,
    $a001, $60c0, $6180, $a141, $6300, $a3c1, $a281, $6240,
    $6600, $a6c1, $a781, $6740, $a501, $65c0, $6480, $a441,
    $6c00, $acc1, $ad81, $6d40, $af01, $6fc0, $6e80, $ae41,
    $aa01, $6ac0, $6b80, $ab41, $6900, $a9c1, $a881, $6840,
    $7800, $b8c1, $b981, $7940, $bb01, $7bc0, $7a80, $ba41,
    $be01, $7ec0, $7f80, $bf41, $7d00, $bdc1, $bc81, $7c40,
    $b401, $74c0, $7580, $b541, $7700, $b7c1, $b681, $7640,
    $7200, $b2c1, $b381, $7340, $b101, $71c0, $7080, $b041,
    $5000, $90c1, $9181, $5140, $9301, $53c0, $5280, $9241,
    $9601, $56c0, $5780, $9741, $5500, $95c1, $9481, $5440,
    $9c01, $5cc0, $5d80, $9d41, $5f00, $9fc1, $9e81, $5e40,
    $5a00, $9ac1, $9b81, $5b40, $9901, $59c0, $5880, $9841,
    $8801, $48c0, $4980, $8941, $4b00, $8bc1, $8a81, $4a40,
    $4e00, $8ec1, $8f81, $4f40, $8d01, $4dc0, $4c80, $8c41,
    $4400, $84c1, $8581, $4540, $8701, $47c0, $4680, $8641,
    $8201, $42c0, $4380, $8341, $4100, $81c1, $8081, $4040
  );
(* CRC-Tabelle FLEXNET *)
VAR  crc_flex : ARRAY[0..255] OF Word; (* wird dynamisch aufgebaut *)


{}

IMPLEMENTATION

USES FD_Timer,
     FD_Mem,
     {$IFDEF SCC} FD_TNC,
     {$ELSE}      FD_CRT,
     {$ENDIF}
     FD_Error,    {* StoreStack *}
     FD_Div
     ;



FUNCTION Calc_CRC16( first : WORD; pBuf : Pointer; n : WORD) : WORD;
{* Berechnet 16 Bit-CRC ueber Buffer pBuf^ der Lnge N.    *}
{* Polynom: x^16+x^15+x+1  Von Jan,DL5UE (original in C)  *}
  VAR crc : WORD;
BEGIN
  crc := crc_smack_table[ first AND $ff];
  WHILE ( n > 0) DO
    BEGIN
    Dec(n);
    crc := ((crc SHR 8) AND $ff) XOR crc_smack_table[ (crc XOR byte(pBuf^)) AND $ff];
    Inc( word(pBuf))
    END;
  calc_crc16 := crc;
END;

{$IFnDEF scc}
FUNCTION Calc_CRCFlex( first : WORD; pBuf : Pointer; n : WORD) : WORD;
  {* Berechnet 16 Bit-CRC ueber Buffer pBuf^ der Lnge N.    *}
{ CONST crc_flex : ARRAY [0..255] OF WORD = (
  $0f87, $1e0e, $2c95, $3d1c, $49a3, $582a, $6ab1, $7b38,
  $83cf, $9246, $a0dd, $b154, $c5eb, $d462, $e6f9, $f770,
  $1f06, $0e8f, $3c14, $2d9d, $5922, $48ab, $7a30, $6bb9,
  $934e, $82c7, $b05c, $a1d5, $d56a, $c4e3, $f678, $e7f1,
  $2e85, $3f0c, $0d97, $1c1e, $68a1, $7928, $4bb3, $5a3a,
  $a2cd, $b344, $81df, $9056, $e4e9, $f560, $c7fb, $d672,
  $3e04, $2f8d, $1d16, $0c9f, $7820, $69a9, $5b32, $4abb,
  $b24c, $a3c5, $915e, $80d7, $f468, $e5e1, $d77a, $c6f3,
  $4d83, $5c0a, $6e91, $7f18, $0ba7, $1a2e, $28b5, $393c,
  $c1cb, $d042, $e2d9, $f350, $87ef, $9666, $a4fd, $b574,
  $5d02, $4c8b, $7e10, $6f99, $1b26, $0aaf, $3834, $29bd,
  $d14a, $c0c3, $f258, $e3d1, $976e, $86e7, $b47c, $a5f5,
  $6c81, $7d08, $4f93, $5e1a, $2aa5, $3b2c, $09b7, $183e,
  $e0c9, $f140, $c3db, $d252, $a6ed, $b764, $85ff, $9476,
  $7c00, $6d89, $5f12, $4e9b, $3a24, $2bad, $1936, $08bf,
  $f048, $e1c1, $d35a, $c2d3, $b66c, $a7e5, $957e, $84f7,
  $8b8f, $9a06, $a89d, $b914, $cdab, $dc22, $eeb9, $ff30,
  $07c7, $164e, $24d5, $355c, $41e3, $506a, $62f1, $7378,
  $9b0e, $8a87, $b81c, $a995, $dd2a, $cca3, $fe38, $efb1,
  $1746, $06cf, $3454, $25dd, $5162, $40eb, $7270, $63f9,
  $aa8d, $bb04, $899f, $9816, $eca9, $fd20, $cfbb, $de32,
  $26c5, $374c, $05d7, $145e, $60e1, $7168, $43f3, $527a,
  $ba0c, $ab85, $991e, $8897, $fc28, $eda1, $df3a, $ceb3,
  $3644, $27cd, $1556, $04df, $7060, $61e9, $5372, $42fb,
  $c98b, $d802, $ea99, $fb10, $8faf, $9e26, $acbd, $bd34,
  $45c3, $544a, $66d1, $7758, $03e7, $126e, $20f5, $317c,
  $d90a, $c883, $fa18, $eb91, $9f2e, $8ea7, $bc3c, $adb5,
  $5542, $44cb, $7650, $67d9, $1366, $02ef, $3074, $21fd,
  $e889, $f900, $cb9b, $da12, $aead, $bf24, $8dbf, $9c36,
  $64c1, $7548, $47d3, $565a, $22e5, $336c, $01f7, $107e,
  $f808, $e981, $db1a, $ca93, $be2c, $afa5, $9d3e, $8cb7,
  $7440, $65c9, $5752, $46db, $3264, $23ed, $1176, $00ff
  ); }
  VAR crc : WORD;
BEGIN
  crc := $ffff;
  crc := (crc SHL 8) XOR crc_flex[ (hi(crc) XOR byte(first) ) ];
  WHILE ( n > 0) DO
    BEGIN
    Dec(n);
    crc := (crc SHL 8) XOR crc_flex[ (hi(crc) XOR byte(pBuf^) ) ];
    Inc( word(pBuf))
    END;
  calc_crcflex := swap(crc);
END;
{$ENDIF}
{}
(*

"
This [Procedure]* is copyrighted by Joachim Schurig, DL8HBS, Berlin. You may use
it freely for your own non-profit products. For further details, refer to
the GNU free software licence and the ALAS licence regulations proposed
by NORD><LINK. Explicitely, you may not use this code or fragments of it
for any kind of commercial products. Please respect these fair licence
conditions. Code using this work has to be published at the same conditions.

Thank you.
"
    ***  [Procedure] Im Original stand da "File". Aber alles in DIESEM File
         ist von DG3DBI+mir ausser eben dem FBB-CRC-Zeug.
         Ich erhebe auf mein CRC-Zeug kein Copyright oder so. Schliesslich
         unterliegt Handwerkszeug wie ein Hammer auch keinem Patent :)
*)

(*
 CRCFBB:
 crc = (crc << 8) ^ crc_table[(crc >> 8) ^ DATA] ;
 CRCTHP
 crc = ((crc << 8) ^ DATA) ^ crc_table[crc >> 8];
*)
CONST ccitt_table : Array[0..255] of Word = (
        $0000,$1021,$2042,$3063,$4084,$50a5,$60c6,$70e7,
        $8108,$9129,$a14a,$b16b,$c18c,$d1ad,$e1ce,$f1ef,
        $1231,$0210,$3273,$2252,$52b5,$4294,$72f7,$62d6,
        $9339,$8318,$b37b,$a35a,$d3bd,$c39c,$f3ff,$e3de,
        $2462,$3443,$0420,$1401,$64e6,$74c7,$44a4,$5485,
        $a56a,$b54b,$8528,$9509,$e5ee,$f5cf,$c5ac,$d58d,
        $3653,$2672,$1611,$0630,$76d7,$66f6,$5695,$46b4,
        $b75b,$a77a,$9719,$8738,$f7df,$e7fe,$d79d,$c7bc,
        $48c4,$58e5,$6886,$78a7,$0840,$1861,$2802,$3823,
        $c9cc,$d9ed,$e98e,$f9af,$8948,$9969,$a90a,$b92b,
        $5af5,$4ad4,$7ab7,$6a96,$1a71,$0a50,$3a33,$2a12,
        $dbfd,$cbdc,$fbbf,$eb9e,$9b79,$8b58,$bb3b,$ab1a,
        $6ca6,$7c87,$4ce4,$5cc5,$2c22,$3c03,$0c60,$1c41,
        $edae,$fd8f,$cdec,$ddcd,$ad2a,$bd0b,$8d68,$9d49,
        $7e97,$6eb6,$5ed5,$4ef4,$3e13,$2e32,$1e51,$0e70,
        $ff9f,$efbe,$dfdd,$cffc,$bf1b,$af3a,$9f59,$8f78,
        $9188,$81a9,$b1ca,$a1eb,$d10c,$c12d,$f14e,$e16f,
        $1080,$00a1,$30c2,$20e3,$5004,$4025,$7046,$6067,
        $83b9,$9398,$a3fb,$b3da,$c33d,$d31c,$e37f,$f35e,
        $02b1,$1290,$22f3,$32d2,$4235,$5214,$6277,$7256,
        $b5ea,$a5cb,$95a8,$8589,$f56e,$e54f,$d52c,$c50d,
        $34e2,$24c3,$14a0,$0481,$7466,$6447,$5424,$4405,
        $a7db,$b7fa,$8799,$97b8,$e75f,$f77e,$c71d,$d73c,
        $26d3,$36f2,$0691,$16b0,$6657,$7676,$4615,$5634,
        $d94c,$c96d,$f90e,$e92f,$99c8,$89e9,$b98a,$a9ab,
        $5844,$4865,$7806,$6827,$18c0,$08e1,$3882,$28a3,
        $cb7d,$db5c,$eb3f,$fb1e,$8bf9,$9bd8,$abbb,$bb9a,
        $4a75,$5a54,$6a37,$7a16,$0af1,$1ad0,$2ab3,$3a92,
        $fd2e,$ed0f,$dd6c,$cd4d,$bdaa,$ad8b,$9de8,$8dc9,
        $7c26,$6c07,$5c64,$4c45,$3ca2,$2c83,$1ce0,$0cc1,
        $ef1f,$ff3e,$cf5d,$df7c,$af9b,$bfba,$8fd9,$9ff8,
        $6e17,$7e36,$4e55,$5e74,$2e93,$3eb2,$0ed1,$1ef0
   );

{* Normalerweise ist first=0  z.B. eben bei  FBB-Mailbox *}
FUNCTION Calc_CRCFBB( first:WORD; adr:pointer; size:WORD) : WORD;
  VAR ct   : WORD;
      p    : ^Byte;
      hcrc :  Word;
BEGIN
  hcrc := first;
  IF size > 0 THEN
    BEGIN
    p := adr;
    FOR ct := 1 TO size DO
      BEGIN
      hcrc := (hcrc SHL 8) XOR ccitt_table[(hcrc SHR 8) XOR p^];
      Inc(word(p));
      END;
    END;
  calc_crcfbb := hcrc;
end;

{ ende dl8hbs stuff }

  VAR index  : Byte;
      j,accu,Data : Word;

{$IFDEF sdfdf}

FUNCTION Calc2_CRCFBB( first:WORD; adr:pointer; size:WORD) : WORD;
  VAR ct   : WORD;
      p    : ^Byte;
      i,
      hcrc : Word;
      data : BYTE;
BEGIN
  hcrc := first;
  IF size > 0 THEN
    BEGIN
    p := adr;
    FOR ct := 1 TO size DO
      BEGIN
      data := p^;
      hcrc := hcrc xor (data SHL 8);
      FOR i := 1 TO 8 DO
        IF (hcrc AND $8000) <> 0
          THEN hcrc := (hcrc SHL 1) XOR $1021
          ELSE hcrc := hcrc SHL 1;
      Inc(word(p));
      END;
    END;
  calc2_crcfbb := hcrc;
end;


PROCEDURE Test;
 const _x2 : ARRAY [1..11] OF Byte = (
   $22,$7f,$bb,$d8,$1e,$00,$a0,$04,
  $00{,$0d,$0a},$0a{,$0d,$0a},$0a{,$1e,$e1}
  );
  const ___x : ARRAY [1..15] OF Byte = (
   $22,$7f,$bb,$d8,$1e,$00,$a0,$04,
  $00,$0d,$0a,$0a,$0d,$0a,$0a{,$1e,$e1}
  );
  const ___x2 : ARRAY [1..13] OF Byte = (
   $22,$7f,$bb,$d8, $1e,$00,$a0,$04,
   $00,$0d,$0a,$0d,$0a{,$1e,$e1}
  );

VAR     k,w : WORD;
BEGIN
 w := Calc_CRCFBB ( $0, @x2[1], sizeof(x2));
 w := Calc2_CRCFBB( $0, @x2[1], sizeof(x2));
END;
{$ENDIF}


BEGIN
  FOR index  := 0 TO 255 DO
    BEGIN (* FlexCRC-Tabelle aufbauen *)
    accu := $FFFF;
    Data := index;
    FOR j := 0 TO 7 DO
      BEGIN
      IF Odd(Data XOR accu) THEN accu := (accu shr 1) XOR $8408
			    ELSE accu := (accu shr 1);
      Data := Data shr 1;
      END;
    WatchDog;
    crc_flex[index] := accu;
    END;  (* Tabelle aufbauen *)
END.
