{$I FD_INCL.PAS}
UNIT FD_Conv;

{$IFnDEF scc} {$O+,F+} {$ENDIF}

INTERFACE

USES FD_Def;


{$DEFINE vernetzt}       {* ConversD - Untersttzung *}
{...$DEFINE Level6666}   {* Spiel und Spass auf dem GGGG-Ganal *}
{$DEFINE ChanStuff}      {* Topics, ch-Operators etc. *}


{$IFnDEF SCC}
  {...$unDEF vernetzt}
  {$unDEF Level6666}
{$ENDIF}

{$IFDEF UserWare}
  {...$unDEF vernetzt}   {.. $TODO  ist noch nicht durchgngig }
  {...$unDEF ChanStuff}
  {$unDEF Level6666}
{$ENDIF}


CONST CONVVERSION = ' '+cPgmKuerzel+'-'+pgmNr;
                  {* ^ Leerzeichen aus Protokoll gruenden! *}

TYPE  T_CVLISTE = ( cKURZ,
 		    cLANG,    {* normales /WHO  *}
		    cPERSONAL {* Nur Kanal,Call, und NAME *}
		  );

TYPE T_why = (WHY_LINK_FAIL,     {* DISCReq oder RetryCount Exceeded *}
              WHY_TYPED_QUIT,    {* Befehl /Q wurde gegeben *}
              WHY_TYPED_DISC,    {* Befehl /Disc wurde gegeben *}
              WHY_DISC_REQ,      {* Disconnect Request traf ein *}
	      WHY_HOST_DOWN,     {* Die Verbindung zum jeweiligen HOST ging runter *}
	      WHY_HOST_MSG,      {* Der Host hat gesagt, dass dieser User wegist *}
              WHY_CB_INVALID,    {* Der AX25-Control-Block wurde gelscht *}
              WHY_LOOP_DETECT    {* ConversLoop entdeckt *}
              );


PROCEDURE OpenConv (pCB : tp_Axcb; StartKanal : longint );
PROCEDURE CloseConv (pDelCv : tp_cv; why : t_why; {$IFDEF ver70} CONST {$ENDIF} sWhy : STRING );
PROCEDURE ListChannels (pCB:tp_axcb; fNurLebende, fMitUser :BOOLEAN);
PROCEDURE ListCvUser ( pCB      : TP_axcb;
		       nr       : T_CvCh;
		       sFilter  : STRING;
		       listMode : T_CVLISTE;
                       fMitTopic:BOOLEAN);
 FUNCTION DoTalk (pCB : TP_axcb; arg : STRING ) : BOOLEAN;
PROCEDURE DoEveryMinuteConvers;

{}

IMPLEMENTATION


USES FD_Info,
     FD_ar,
     FD_axcb,    {* SucheCallimDigi *}
     FD_state,   {* TryToConnect *}
     FD_timer,   {* TiTimeOut *}
     FD_log,     {* LogAddEntry bei Convloops *}
     FD_text,    {* ConvHelp *}
     {$IFDEF SCC}  FD_tnc,
       {$ELSE}     FD_crt,
     {$ENDIF}
     FD_Main,   {* fnMsgDefault }
     FD_Div,
     {$IFDEF display} cc_disp, {$ENDIF}
     FD_Subr,
     FD_TX,
     FD_Mem
{$IFDEF DCF}
    ,FD_DCF
{$ENDIF}
     ;

CONST ANSIColHead= #27'[';
      ANSIColTail= 'm';
      ANSIColReset = #27'[0m';

TYPE t_cvmode = (ALL,         {* An alle User auer dem Absender *}
		 PRIVAT,     {* Nur an einen bestimmten User *}
                 EXCLUDE,     {* An alle ausser einem bestimmtem *}
                 SYSALL);     {* Systemmeldung an alle *}

CONST LIST_ALLE = TRUE;
      LIST_NUR_KANAL = FALSE;
      LIST_LANG = TRUE;
      LIST_KURZ = FALSE;

CONST pRootCv : tp_cv = NiL;   {* Wurzel der Convers-Liste *}

{$F+} PROCEDURE fMainConv  ( pCB : tp_axcb; msg : T_Msg ); forward;

{}

{$IFDEF ChanStuff}
CONST pcRoot : TP_CvChAttr = NiL;

PROCEDURE ListChannels (pCB:tp_axcb; fNurLebende, fMitUser :BOOLEAN);
  VAR pc : TP_CvChAttr;
      s : STRING;
BEGIN
  pc := pcRoot;
  {* berschrift *}
  IF fMitUser
    THEN BEGIN
	 s := '';
         Tx_Info(pCB,SPAETER,EOL);
	 END      {* 121234561234/1234 tt.mm hh:mm-tt.mm hh:mm  #*}
   ELSE  s := EOL + '   chan. User/Loc.    seit        (bis)    Thema';
  WHILE pc <> NiL DO
    BEGIN
    IF (pc^.nuser > 0) OR NOT fNurLebende THEN
      BEGIN
      Tx_Info(pCB,SPAETER,
			f_Using(pc^.chnr,5)
			+ ' *** ' + pc^.topic
			+   EOL);
      IF fMitUser
       THEN BEGIN
	    ListCvUser ( pCB, pc^.chnr , '', cKURZ, FALSE{TOPIC} );
	    END
       ELSE BEGIN
	    IF Length(s) > 170 THEN
	      BEGIN
	      Tx_Info(pCB,SPAETER,s);
	      s := '';
	      END;
	    s := s + EOL
		  + char( ord ( pc^.fPrivate ) + 32 ) + ' '
		  + f_Using(pc^.chnr,6)
		  + f_Using(pc^.nUser,4)
	    + '/' + f_Using(pc^.nUserLoc,4)
	    + ' ' + Time2StrTTMMHHMM ( pc^.tCreated )
	    + '-' + Time2StrTTMMHHMM ( pc^.tLastLogOut )
	    END;
      END;
    pc := pc^.Next;
    END;
  IF NOT fMitUser THEN Tx_Info(pCB,SOFORT, s + EOL);
END;

PROCEDURE RemoveChannels( alter : WORD );
 {* Entfernt alte + leere Kanle *}
  VAR pc,pcz : TP_CvChAttr;
      si     : ShortInt;
BEGIN
  pc := pcRoot; pcZ := NiL;
  WHILE pc <> NiL DO
    BEGIN
    si := shortint(systime.hour)-pc^.tLastLogout.hour;
    IF si<0 THEN Inc(si,24);
    IF (pc^.nUser = 0) AND (si>=alter)
      THEN BEGIN
           IF pcZ = NiL THEN pcRoot    := pc^.Next
                        ELSE pcZ^.Next := pc^.Next;
           MemFree( pointer(pc), sizeof(pc^) );
           pc := pcRoot; {* am einfachsten *}
           END
      ELSE BEGIN
           pcZ := pc;
           pc := pc^.Next;
           END;
    END;
END;

    TYPE T_hcMode = (cADD,cNULL);
FUNCTION HandleChannel( nr : T_CvCh; Modus : T_hcmode ) : TP_CvChAttr;
  LABEL l_EoP;
  VAR pc,pcm,pcv,pcResult : TP_CvChAttr;
BEGIN
  pc := pcRoot;  pcResult := NiL; pcM:= pc; pcv := NiL;
  WHILE pc <> NiL DO
    BEGIN
    IF pc^.chnr = nr
      THEN BEGIN
           pcResult := pc;
           pc := Nil;
           END
      ELSE IF pc^.chnr<nr THEN BEGIN
                               pcv := pc;
                               pc := pc^.Next;
                               pcm := pc;
                               END
                          ELSE pc := NiL;
    END;
  IF (pcResult=NiL) AND (modus=cADD) THEN
    BEGIN
    MemGet( pointer(pcResult), sizeof(pcRoot^) );
    pcResult^.next := pcm;
    IF pcv = NiL THEN pcRoot := pcResult
                 ELSE pcv^.next := pcResult;
    pcResult^.chnr     := nr;
    pcResult^.topic    := '---';
    pcResult^.tltopic  := 0;
    pcResult^.fPrivate := FALSE;
    pcResult^.nUser    := 0;
    pcResult^.nUserLoc := 0;
    pcResult^.nMaxUser := 0;
    pcResult^.tlastLogout := sysTime;
    pcResult^.tcreated    := sysTime;
    IF nr=0 THEN
      BEGIN
      pcResult^.topic    := '*** Willkommen im Convers-Netz ***';
      pcResult^.tltopic  := 900000000; {* Grins *}
      END;
    END;
L_Eop:
  HandleChannel := pcResult;
END;
{$ENDIF}

FUNCTION ChannelPermit (pCV : TP_Cv; chnr : t_cvch ):BOOLEAN;
  VAR pc : TP_CvChAttr;
BEGIN
ChannelPermit := TRUE;
{$IFDEF ChanStuff}
IF pCv^.typ = cvUSER THEN
  BEGIN
  pc := HandleChannel( chnr, cNULL );
  IF pc <> NiL THEN
    BEGIN
    ChannelPermit := NOT pc^.fPrivate;
    END;
  END;
{$ENDIF}
END;

PROCEDURE SetzeKanal ( pCV : TP_Cv; alt,neu : t_cvch );
  VAR pcAlt, pcNeu : TP_CvChAttr;
BEGIN
{$IFDEF ChanStuff}
  IF alt <> -1 THEN
    BEGIN
    pcAlt := HandleChannel( alt, cNULL );
    IF pcAlt=Nil THEN Exit; {* sollte nicht vorkommen *}
    Dec (pcAlt^.nUser);
    IF pCv^.typ=cvUSER THEN Dec(pcAlt^.nUserLoc);
    IF pcAlt^.nUserLoc = 0 THEN pcAlt^.fPrivate := FALSE; {* Remotes knnen ja nicht befreien *}
    pcAlt^.tlastLogout := sysTime;
    END;

  IF neu <> -1 THEN
    BEGIN
    pcNeu := HandleChannel( neu, cADD );
    pCV^.kanal := neu;
    pCV^.fChOp := ( (neu<>0) AND (pcNeu^.nUserLoc = 0) ) OR (pCV^.pCB^.who=sysop);
    Inc (pcNeu^.nUser);
    IF pCv^.typ=cvUSER THEN Inc(pcNeu^.nUserLoc);
    END;
{$ELSE}
    pCV^.kanal := neu;
{$ENDIF}
END;

{}
TYPE T_SCU = (cREMOTE,cALL);
FUNCTION SucheConversUser( sCall     : STRING;
			   mode      : T_SCU;
			   pNachbarCB: TP_AXCB;
			   suchKanal : INTEGER ) : tp_cv;
{* Suche RemoteUser sCALL auf Host pNachbarCB auf Kanal KANAL  *}
{* wenn pNachbarCB = NiL, darf RemoteUser ber beliebigen Nachbarn kommen *}
{* Wenn Kanal = -1, so wird auf allen Kanlen gesucht. *}
  VAR pl : tp_cv;
      sTeilCall : STRING;
BEGIN
  SucheConversUser := NiL;
  pl := pRootCv;  {* Schleife ber alle Leute in allen Konvers Kanlen *}
  Trim(sCall);
  sTeilCall := Copy(sCall,1,sizeof(T_sCvName)-1);
  Lower(sTeilCall);
  WHILE pl <> Nil DO
    BEGIN
    IF ( (pl^.typ = cvREMOTEUSER) OR (mode=cALL       ) ) AND
       ( (pl^.Kanal = suchkanal)  OR (suchKanal = -1  ) ) AND
       ( (pNachbarCB = pl^.pCB)   OR (pNachbarCB = NiL) ) AND
       ( sTeilCall = pl^.name ) THEN
	  BEGIN {* Gefunden *}
	  SucheConversUser := pl;
	  Exit; {* Lies: RETRUN pl *}
	  END;
    pl := pl^.next;
    END;
END;

{$IFDEF vernetzt}
FUNCTION SucheNotRemoteUser( sCall     : STRING;
                          pNotNachbarCB: TP_AXCB;
                          suchKanal : INTEGER ) : tp_cv;
{* Suche RemoteUser sCALL auf Host pNachbarCB auf Kanal KANAL. Wenn *}
{* pNotNachbarCB <> NiL, darf RemoteUser nicht ber diesen NAchbarn *}
{* kommen. Wenn Kanal = -1, so wird auf allen Kanlen gesucht.      *}
  VAR pl : tp_cv;
BEGIN
  SucheNotRemoteUser := NiL;
  Lower(sCall);
  pl := pRootCv;  {* Schleife ueber alle Leute in allen Convers Kanlen *}
  WHILE pl <> Nil DO
    BEGIN
    IF (pl^.typ = cvREMOTEUSER) AND
       ( (pl^.Kanal = suchkanal) OR (suchKanal = -1) ) AND
       ( (pNotNachbarCB <> pl^.pCB)                  ) AND
       ( Copy(sCall,1,sizeof(T_sCvName)-1) = pl^.name ) THEN
          BEGIN {* Gefunden *}
          SucheNotRemoteUser := pl;
          Exit; {* Lies: RETRUN pl *}
          END;
    pl := pl^.next;
    END;
END;


FUNCTION DetermLoop( sHostName : t_sCvHostName;
                     pNachbarCB : TP_AXCB ) : BOOLEAN;
 {* Teste ob sHostName schon mal ber einen anderen Nachbarn als    *}
 {* pNachbarCB angemeldet wurde. Wenn ja (=loop), gebe True zurueck *}
  VAR pl : tp_cv;
      found : BOOLEAN;
BEGIN
  sHostName := F_Lower(sHostName);
  found := FALSE;
  pl := pRootCv;  {* Schleife ueber alle Leute in allen Konvers Kanlen *}
  WHILE (pl <> Nil) AND (NOT found) DO
    BEGIN
    IF (pl^.typ = cvREMOTEUSER) THEN     {* Remoteuser... *}
      IF (pNachbarCB <> pl^.pCB) THEN    {* ...der ber einen anderen Nachbarn kommt... *}
        IF (pl^.HostName=sHostName) THEN {* ...aber trotzdem im selben HOST sitzt, also *}
          found := TRUE;                 {* B U M M ! *}
    pl := pl^.next;
    END;
  DetermLoop := found;
END;
{$ENDIF}

{}

PROCEDURE SetChannelFlags(aktKanal : T_CvCh);
  VAR p : tp_cv;
BEGIN
  p := pRootCv;  {* Schleife ber alle Leute in allen Konvers Kanlen *}
  WHILE p <> Nil DO
    BEGIN  {* Erstmal alle lschen *}
    p^.fTX := FALSE;
    p := p^.next;
    END;
  p := pRootCv;  {* und nochmal von vorne *}
  WHILE p <> Nil DO
    BEGIN
    {* ggf. Flag des zugeh. Hosts setzen *}
    IF (p^.kanal=aktKanal) AND (p^.typ=cvREMOTEUSER) THEN
        p^.pCB^.pCv^.fTx := TRUE; {* ACHTUNG: Genau hingugen: Dies ist nicht ptimierbar! *}
    p := p^.next;
    END;
END;

PROCEDURE TX_ConversD ( pCV : TP_CV; s : STRING);
  {* Gibt Systemmeldung S an User pCV aus *}
BEGIN
  IF pCv^.typ=cvUSER
    THEN TX_Info (pCV^.pCB,SOFORT, '*** '+s )
    ELSE TX_Info (pCV^.pCB,SOFORT, '/'#$FF#$80'UMSG conversd '+pCV^.Name+' '+s );
END;



PROCEDURE SendCv ( pCv : TP_cv; mode : t_cvmode; sZeile : STRING );
{* Hauptsenderoutine. pCv^ hat den Text sZeile geschrieben. Ist MODE =
 * ALL geht er auf alle des gleichen Kanals. Ist ein klassisches
 * Beispiel fr ne ver/ge-wachsene Routine :-(
 *}
 VAR p,pCvRemote       : tp_CV;
     toCall, frCall,
     s,sSpace          : STRING;
     ch                : CHAR;
     sh                : T_ShCall;
     lastSpc, i,
     lfdSpalte, iStart : WORD;
     fromsystem, fAfterNewLineWrap,
     doit, fFromLine   : BOOLEAN;
     pToCB             : TP_AXCB;
 {$IFDEF Level6666}
     fRobStat          : BOOLEAN;
 {$ENDIF}
BEGIN
 IF pCV^.Typ = cvLINKInit THEN Exit;
 RepChar(sSpace,80,' ');
 fromSystem := (mode = SYSALL);
 IF fromSystem THEN Mode := ALL;
 IF mode = ALL
    THEN frCall := '-'+pCv^.Name+'-'
    ELSE BEGIN {* Privat/Exclude *}
	 IF mode = PRIVAT THEN frcall := '*'+pCv^.Name+'*'
			  ELSE frcall := '#'+pCv^.Name+'#';
         i := Pos(' ',sZeile); {* Call isolieren *}
         IF i = 0 THEN BEGIN
                       toCall := sZeile;
                       sZeile:= '';
                       END
                  ELSE BEGIN
                       toCall := f_Lower(Copy (sZeile,1,i-1));
                       AscCall2shift ( f_Upper(toCall), sh );
		       sZeile := Copy (sZeile, i+1,255); {* Text *}
                       END;
	 IF mode = EXCLUDE THEN
           IF SucheConversUser( toCall, cALL, NiL, pCV^.kanal ) = NiL THEN
             BEGIN
	     TX_SysInfo (pCv^.pCB, SOFORT, tocall+' isn''t here'+EOL);
	     Exit;
             END;
         END;

 {$IFDEF Level6666}
 fRobStat := FALSE;
 IF (pCV^.Kanal = 6666) THEN
   BEGIN
   IF( Random (100)=66 ) THEN
       CASE Random(100) OF
        0..66 : fRobStat := TRUE;
       67..80 : RevStr (frCall);
       81..99 : BEGIN
                WHILE DelWord (EOL,sZeile) DO;
		RevStr(sZeile);
                END;
       END;
   END;
 {$ENDIF}

 SetStrLength (frCall,8);
 IF fromSystem THEN sZeile := '*** '+sZeile+' ** '+UhrZeit(sysTime.Hour,SysTime.Min)
               ELSE frCall := frCall + ':';
 IF sZeile [length(sZeile)] = EOL THEN Dec (byte(sZeile[0]));
 WHILE F_Replace (^H,'',sZeile) DO; {*^H entfernen *}
 RTrim (sZeile);
 IF sZeile = '' THEN
   BEGIN
   IF mode = PRIVAT THEN TX_SysInfo (pCv^.pCB, SOFORT, 'no text for "'+tocall+'"'+EOL);
   Exit; {* war wohl was fuer den empty Space *}
   END;

 Inc (pCv^.nByteTx, Length (sZeile)); {* Statistik *}
 IF mode = PRIVAT THEN Inc (pCv^.nBytePrivateTx, Length (sZeile));
 SetStrLength (frCall,9);

 SetChannelFlags(pCV^.kanal);

 p := pRootCv;  {* Schleife ber alle Leute in allen Konvers Kanlen *}
 WHILE p <> Nil DO
   BEGIN
   WatchDog;
   doit := FALSE;
   {* Der Kanal des Absenders muss es sein, es sei denn, es ist privat! *}
   IF (p^.kanal=pCv^.kanal) OR (mode=PRIVAT) THEN
     BEGIN
     IF     (mode=ALL)     THEN doIt:=(p^.pCB <> pCV^.pCB) {* an alle ausser dem Absender schicken *}
     ELSE IF(mode=PRIVAT)  THEN doIt:=MemEq( @p^.pCB^.tocall, @Sh, 6) {* or=sysop :-)? * nur an das ZielCall schicken *}
     ELSE {* mode=EXCLUDE *}    doIt:=NOT MemEq( @p^.pCB^.tocall, @Sh, 6);{* Logik umkehren, falls EXCLUDE angesagt *}
     END;

 {$IFDEF vernetzt}
   {* IF absender ="conversd" then fromcall= ''; Mode = SYS *}
   {* An Nachbarn duerfen keine Privaten Mails geschickt werden *}
   {* /DB0ID aetsch   oder so kommt nicht gut *}

   IF (p^.typ = cvLINK) AND {* Jetzt kommt ein Nachbar...    *}
      (p^.pCB <> pCv^.pCB)  {* ...der nicht der Absender ist *}
     THEN BEGIN
          IF (NOT fromSystem) AND {* Systemmeldungen interessieren die Remotes nicht *}
	     (mode = ALL) AND     {* ffentlich muss es sein *}
             (p^.fTx) THEN        {* und er muss User auf dem Kanal haben (s.o.) *}
            BEGIN {* an Alle *}
            TX_Info (p^.pCB, SOFORT,
            '/'#$FF#$80'CMSG '+pCv^.Name+' '+fStr(pCv^.kanal)+' '+ sZeile + EOL );
	    END;
          END
     ELSE IF p^.typ = cvUSER THEN {* Remoteuser kriegen berhaupt nix - das is ja der Witz...*}
 {$ENDIF}
           BEGIN
           IF doIt THEN
              IF p^.sFilter<>'' THEN
                 IF Pos(f_Upper(pCv^.name)+' ',p^.sFilter) > 0 THEN doIt := false;

           IF doIt THEN
              BEGIN {* So, auf gehts. Text formatieren etc. *}
              iStart := 1; fAfterNewLineWrap := FALSE; lastSpc := 0;
              IF (mode=PRIVAT) THEN p^.pCvLast := Nil; {* Privates immer auf extra Zeile *}
              IF p^.fBayStyle
	        THEN BEGIN
                     IF (pCv <> p^.pCvLast) OR fromSystem
                       THEN BEGIN {* Absender hat gewechselt *}
                            p^.pCvLast := pCV;
                            IF p^.sAnsi <>''
                              THEN s := ANSIColHead + p^.sAnsi + ANSIColTail
                                      + frCall + ANSIColReset
		              ELSE s := frCall;
                            lfdSpalte := length(frCall)+1;
                            IF (length(sZeile)>60) AND (length(sZeile)<78)  THEN
                              BEGIN {* Erste Zeile zu lang. Direkt auf die nchste Zeile schieben *}
                              AddString(s, EOL+' ');
		              lfdSpalte := 2;
                              END;
                            END
                       ELSE BEGIN
                            s := ' ';
                            lfdSpalte := 2;
                            END;
                     END
                ELSE BEGIN {* Normal Convers *}
	             IF p^.sAnsi <> ''
                       THEN s := ANSIColHead + p^.sAnsi + ANSIColTail
                                 + frCall + ANSIColReset
                       ELSE s := frCall;
                     lfdSpalte := length(frCall)+1;
                     END;
              IF p^.fBell THEN AddChar(s, BELL);
              TX_Info ( p^.pCB, SPAETER, s);
              FOR i := 1 TO length (sZeile) DO
                BEGIN
                IF sZeile[i] = ' ' THEN lastSpc := i;
                IF (sZeile[i] = EOL) OR (lfdSpalte > 78) OR (i=Length(sZeile)) THEN
	          BEGIN {* Zeilenumbruch *}
                  s := '';
                  IF p^.fBayStyle
                    THEN BEGIN
                         IF fAfterNewLineWrap THEN s := ' ';
                         lfdSpalte := 2;
                         END
                    ELSE BEGIN
                         IF fAfterNewLineWrap THEN BEGIN
		               sSpace[0] := Char(length(frCall));
                               s := sSpace;
                               END;
                         lfdSpalte := 9;
                         END;
                  IF (sZeile[i] <> EOL)  AND
	             (i<>Length(sZeile)) AND
                     (lastSpc <> 0) THEN i := lastSpc;
                  s := s + Copy (sZeile,iStart,i+1-iStart);
                  IF sZeile[i] <> EOL THEN s := s+EOL;
                  IF s <> '' THEN TX_Info ( p^.pCB, SPAETER, s);
	          iStart := i+1;
                  fAfterNewLineWrap := TRUE;
                  lastSpc := 0;
                  END; {* Zeilenumbruch *}
                Inc (lfdSpalte);
                END;
              IF (mode=PRIVAT) THEN p^.pCvLast := Nil; {* Privates immer auf extra Zeile *}
              {$IFDEF Level6666}
              IF fRobStat THEN TX_Info ( p^.pCB, SPAETER,'**** Gaehn...'+EOL);
              {$ENDIF}
              TX_Trigger (p^.pCB);
              IF Mode=PRIVAT THEN p := NiL; {* Das wars dann *}
              END;
           END;

   IF p <> Nil THEN p := p^.next; {* Nchster bitte *}
   END;

 IF (mode=PRIVAT) AND (NOT doit) THEN
   BEGIN {* nicht im Convers gefunden *}
   SucheCallInDigi ( toCall, scmFreier,pToCB );
   IF pToCB <> Nil {* Gefunden inner InfoBox *}
      THEN TX_Info (pToCB, SOFORT, EOL+frCall+sZeile+EOL)
      ELSE BEGIN {* weder im lokalen Convers, noch inner Infobox *}
	   {$IFnDEF vernetzt}
	   TX_SysInfo (pCv^.pCB, SOFORT, toCall+' not found '+EOL);
	   {$ELSE}
	   pCvRemote := SucheConversUser(toCall,cREMOTE,NiL,-1); {* in allen Kanlen, auf allen HOSTs suchen *}
	   IF pCvRemote <> NIL
	     THEN BEGIN {* Remote issser bekannt. Also Nachricht an den entsprechenden Nachbarn schicken *}
		  TX_Info (pCvRemote^.pCB, SOFORT,'/'#$FF#$80'UMSG '
			   +pCv^.Name+' '+toCall+' '+ sZeile + EOL );
		  END
	     ELSE BEGIN {* Weder Lokal noch Remote bekannt (im Convers) *}
		  TX_ConversD (pCv, toCall+' not found'+ EOL );
		  END
	   {$ENDIF}
	   END; {* nicht lokal *}
   END;
END;

{}


PROCEDURE SendSysLocal ( kanal : T_CvCh;
          {$IFDEF ver70} CONST {$ENDIF} s : STRING );
  {* Gebe "s" an alle User auf Kanal "kanal" aus. Ist     *}
  {* "kanal" = -1 so wird es auf allen Kanlen ausgegeben *}
  VAR p : tp_CV;
BEGIN
  p := pRootCv;
  {* Schleife ueber alle lokalen Leute in allen Konvers Kanlen *}
  WHILE p <> Nil DO
    BEGIN
    IF  (p^.typ = cvUSER) AND
       ((kanal=p^.kanal) OR (kanal=-1)) THEN
	    Tx_SysInfo ( p^.pCB, SOFORT, s+EOL);
    p := p^.next;
    END;
END;


{$IFDEF vernetzt}
PROCEDURE SendHosts( pNotCB:TP_AXCB; s:String  );
 {* Sendet S als CV-Kommando an alle Nachbar-Hosts; ausser an pNotCB *}
  VAR pl : TP_cv;
BEGIN
  pl := pRootCv; {* Schleife ber alle in allen Kanlen *}
  WHILE pl <> Nil DO
    BEGIN
    IF      (pl^.typ = cvLINK) {* Klaro, alles was kein HOST ist, kann nix mit anfangen *}
	AND (pl^.pCB <> pNotCB) THEN {* nicht an sich selber zurck *}
      BEGIN
      TX_Info ( pl^.pCB, SOFORT, '/'#$ff#$80+s+EOL);
      END;
    pl := pl^.next;
    END;
END;
{$ENDIF}

{}

    CONST cLINKSTRING='  CV-LINK: ';
PROCEDURE ListCvUser ( pCB      : TP_axcb;
		       nr       : T_CvCh;
		       sFilter  : STRING;
		       listMode : T_CVLISTE;
                       fMitTopic:BOOLEAN);
 {* Liste der Convers - User. Der am lngsten eingeloggte steht ganz hinten *}
 {* (bedingt durch die verkettete Liste, die neue ganz vorne einhngt)      *}
 {* Ist NR = -1, so werden alle, sonst nur die des entsprechenden Kanals *}
 {* NR ausgegeben                                                        *}
VAR p : tp_cv;
    n : WORD;
    s : STRING;
    ch: Char;
    pc : TP_CvChAttr;
BEGIN
 s := '';
 Upper(sFilter);
 IF listMode=cLANG     THEN s := EOL+' chan.      tx  priv    login at   call'+EOL;
 pc := HandleChannel( nr, cNULL );
 IF listMode=cPersONAL THEN
   BEGIN
   IF pc <> NiL THEN s := '*** current topic: '+pc^.topic;
   s := s+EOL+' chan.    call   QRA'+EOL;
   END;
 IF fMitTopic THEN
   BEGIN
   IF pc <> NiL THEN s := '*** '+pc^.topic+EOL;
   END;
 IF s <> '' THEN TX_Info ( pCB, SPAETER, s);
 p := pRootCv;  n := 0;
 WHILE p <> Nil DO
   BEGIN
   WatchDog;
   IF (nr = -1 ) OR (p^.Kanal=nr) THEN
     BEGIN
     Inc (n);
     s := f_Using(p^.Kanal,5);
     CASE listMode OF
       cKURZ
	  : BEGIN {* kurz *}
	    {* wenn nur die Leute auf einem bestimmten Kanal ausgegeben *}
	    {* werden sollen, so brauchen die nicht noch die Kanalnr... *}
	    IF nr<>-1 THEN s := '';
	    s := s + '   '+ p^.name + ' ';
	    IF      p^.typ  = cvLINK THEN s := s+'host' {* Remote Leute kennzeichnen *}
	    ELSE IF p^.typ <> cvUSER THEN AddChar(s,'@'); {* Remote Leute kennzeichnen *}
	    IF p^.fChop THEN AddChar(s,'*');
	    IF p^.fAway THEN AddChar(s,'-');
	    IF n MOD 6 = 0 THEN s := s + EOL;
	    END;

       cPERSONAL
	  : BEGIN
	    s := '.'+ s + ' - ' + p^.name + ' - ' + p^.sPersData+ '.'; {* Normaler User *}
	    IF p^.fAway THEN s := s + ' (AWAY)';
	    IF p^.fChOp THEN AddChar(s,'*');
	    AddChar (s,EOL);
	    END;

       cLANG
	  : BEGIN {* lang *}
            {* Als erstes ein . Bei Textratereien  la GP wird das sonst fr ne Checkliste gehalten :( *}
            s := '.'+ s + ' -'
                   + f_Using(p^.nByteTx, 6)
                   + f_Using(p^.nBytePrivateTx, 6)
                   + '  '
                   + Time2StrTTMMHHMM(p^.time)
                   ;
	    CASE p^.typ OF
              cvLINKINIT,
              cvLINK
                : BEGIN
                  FillChar (s[1], 20, ' '); {* Kanalnr. + Bytezhler berschreiben *}
                  s := s + cLINKSTRING +p^.hostname + ' ('+p^.name+')';
                  END;
              cvREMOTEUSER
                : BEGIN
                  FillChar (s[8], 12, ' '); {* Bytezhler berschreiben *}
                  s := s +'  '+p^.name;
		  IF length(s) < 49 THEN SetStrLength(s,49);
                  s := s + '@ ' + p^.hostname
			 + ' v. ' + f_lower(f_sh2asc(p^.pCB^.tocall));
                  END;
	     ELSE BEGIN {* Normaler User *}
                  s := s +'  ' + p^.name;
                  SetStrLength(s,43);
		  s := s + p^.sPersData;
                  END;
             END; {* CASE typ *}
	    AddChar (s,'-');
	    IF p^.fAway THEN s := s + ' (AWAY)';
	    IF p^.fChOp THEN AddChar(s,'*');
	    AddChar (s,EOL);
	    END; {*Long*}
       END; {* CASE ListMode *}

     IF (sFilter ='') OR (Pos(sFilter,f_Upper(s))<>0) THEN Tx_TrimInfo( pCB, SPAETER, s );
     END; {if falle}
   p := p^.next;
   END; {while}
 IF      listMODE=cLANG THEN TX_SysInfo ( pCB, SOFORT, EOL)
 ELSE IF listMODE=cKURZ THEN TX_Info ( pCB, SOFORT, EOL);
END;



{}

PROCEDURE EinhaengenRoot ( pNeu : tp_cv );
{* hnge p^ am Anfang in die Conversliste ein - der der zuletzt einloggt *}
{* steht ganz oben *}
BEGIN
  IF pNeu = NiL THEN Exit; {* sollte nicht passieren *}
  pNeu^.next := pRootCv;
  pRootCv := pNeu;
  Exit;
END;


PROCEDURE Switch (pCv : TP_Cv; newCh : T_CvCh);
  Label L_Eop;
  VAR s : STRING;
      oldCh : T_CvCh;
BEGIN
  oldCh := pCv^.Kanal;
  IF (newCh = oldCh) OR (NOT ChannelPermit (pCV, newCh) AND (pCV^.pCB^.who<>sysop)) THEN
    BEGIN
    IF pCV^.typ = cvUSER THEN TX_SysInfo (pCv^.pCB, SOFORT, 'no!'+EOL);
    Exit;
    END;
  SendCv (pCV, SYSALL,'switched to channel '+FStr(newCh));
{$IFDEF vernetzt}
  SendHosts( pCV^.pCB, 'USER '+pCv^.name+' '
                       +pCv^.hostname+' '
                       +fStr(UnixZeitNow)+' '
                       +fStr(oldCh)+' '
                       +fStr(newCh)+' '
		       +pCV^.sPersData);
{$ENDIF}
  SetzeKanal(pCv,oldCh,newCh);
  IF pCV^.typ = cvUSER THEN
    BEGIN
    TX_EolSysInfo (pCv^.pCB, SOFORT, 'now on channel '+FStr(newCh)+EOL);
    ListCvUser (pCv^.pCB, newCh, '', cKURZ, TRUE{TOPIC});
    IF (oldCh=99) AND (pCv^.pCB^.who=SysOp) THEN GOTO L_Eop; {* Ranschleich...*}
    END;
  s := 'LOGON (@ '+pCv^.Hostname+')';
  SendCv(pCV, SYSALL, s);
l_eop:
END;


PROCEDURE Force ( pCB : TP_axcb; sArg : STRING );
  VAR pPartner : TP_AXCB;
BEGIN
  IF pCB^.who<>SysOp THEN Exit;
  SucheCallInDigi ( sArg, scmFREIER, pPartner );
  IF pPartner = NiL THEN Tx_SysInfo (pCB,SOFORT,sArg+' not found'+EOL)
    ELSE BEGIN {* Gefunden *}
	 Tx_SysInfo ( pPartner,SPAETER,EOL+BELL+'sysop forced convers'+EOL);
         IF pPartner^.pCv <> NiL
           THEN Switch( pPartner^.pCv, pCB^.pCv^.Kanal ) {* Partner ist schon im Convers *}
	   ELSE OpenConv( pPartner, pCB^.pCv^.Kanal);
         END
END;

{}

{$F+} PROCEDURE fMsgCvConnectTry ( pCB : tp_axcb; msg:T_MSG ); {$IFNDEF AllFar} {$F-} {$ENDIF}
BEGIN
  CASE msg OF
    msgReconnect,
    msgConnectSuccess
      : BEGIN
        pCB^.state := CONNECTED; {* ? *}
        pCB^.pid := PID_TEXT; {* Nicht so doll *}
        IF (pCB^.pPartnerCB <> NiL) AND (pCB^.pPartnerCB^.pCv <> NiL)
          THEN WITH pCB^.pPartnerCB^ DO {* ist der rufende noch da ? *}
	       BEGIN
	       TX_Info (pCB, SPAETER,'q'+EOL + {* hierdurch werden Digis direkt wieder kalt gestellt *}
				     'b'+EOL + {* und KAM-Knoten *}
                                     'exit'+EOL+ {* und WAMPEn / tUnixe *}
                                     'logout'+EOL+ {* und Linux  kw 23.3.97 *}
                                      BELL+'*** invited by '+f_sh2Asc(pCB^.pPartnerCB^.toCall)
                                       +' to join convers on digi '+axIFace[pCB^.iface].asMyCall+EOL);
	       OpenInfoBox( pCB, FALSE,0,0 {Statistikzeug});
	       OpenConv( pCB, pCB^.pPartnerCB^.pCv^.kanal );
               Tx_SysInfo (pCB^.pPartnerCB, SOFORT,'convers-connect success: '+f_sh2Asc(pCB^.tocall)+EOL);
               END
          ELSE BEGIN
	       Tx_Sysinfo (pCB, SPAETER,BELL+'invited by someone (who had meanwhile disconnect) to join convers on digi '
                                       +axIFace[pCB^.iface].asMyCall+EOL);
	       OpenInfoBox (pCB, FALSE,0,0 {Statistikzeug});
	       OpenConv(pCB, 0 );
	       END;
       IF (pCB^.pPartnerCB <> NiL) THEN pCB^.pPartnerCB^.pPartnerCB := NiL;
       pCB^.pPartnerCB := NiL;
       END;
   msgDiscReq,
   msgRxDM,
   msgCBDel,
   msgRetryCountExceeded :
	 BEGIN
	 pCB^.fMsgHandler := fnMsgDefault;
         IF (pCB^.pPartnerCB <> NiL) AND (pCB^.pPartnerCB^.pCv <> NiL)
	  THEN IF msg = msgRxDM
                 THEN Tx_SysInfo (pCB^.pPartnerCB, SOFORT,
				f_sh2asc(pCB^.tocall)+' busy'+EOL)
	         ELSE Tx_SysInfo (pCB^.pPartnerCB, SOFORT,
           		       'failure with '+f_sh2asc(pCB^.tocall)+EOL);
	 END;
   END; {CASE}
END;

{$IFDEF vernetzt}
{$F+} PROCEDURE fMsgConnectHost (  pCB : tp_axcb; msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
 {* in pCB^.pPartnerCB steht der CB drin, der den /CONHOST befehl gab! *}
BEGIN
  CASE msg OF
    msgReconnect,
    msgConnectSuccess
      : BEGIN
	pCB^.state := CONNECTED;
        pCB^.pid := PID_TEXT;
        TX_Info (pCB, SOFORT,'CONV'+EOL+
                         '/'#$ff#$80'HOST '
                         +axIFace[1].asMyCall+
                         CONVVERSION {* Hier^muss ein Space sein; dies ist am Anfang der Constante vorhanden *}
                         +' amu '    {* Featuers: Away, Mode, UDAT *}
                         +EOL);
	OpenInfoBox (pCB, FALSE,0,0); {* Die Infobox sorgt dafuer, dasser in den Convers rutscht *}
        IF (pCB^.pPartnerCB <> NiL) THEN pCB^.pPartnerCB^.pPartnerCB := NiL;
        pCB^.pPartnerCB := NiL;
        END;
   msgDiscReq,
   msgRxDM,
   msgCBDel,
   msgRetryCountExceeded :
	 pCB^.fMsgHandler := fnMsgDefault;
   END; {CASE}
END;
{$ENDIF}


PROCEDURE CvConnect  ( pCB : TP_axcb; sArg : STRING; fSystem : BOOLEAN ) ;
  VAR t,v : STRING;
      shZ : T_SHCall;
      ifNr : T_IfNr;
      pNewCB : tp_AXCB;
BEGIN
  IF NOT useCvConnect THEN
    BEGIN {* alles aus *}
    Tx_EOLSysInfo (pCB, SPAETER, 'disabled');
    Exit;
    END;

  IF pCB^.pPartnerCB <> NiL THEN
    BEGIN {* Der Aufrufende hat schon irgendwas am laufen - meistens cvconnect *}
    TX_SysInfo (pCB,SOFORT,'not now'+EOL);
    Exit;
    END;

  String2tv ( sArg, t,v);
  IF dnCallCheck OR (sArg='') THEN
    BEGIN
    IF NOT ValidCall(t) THEN
      BEGIN
      TX_SysInfo (pCB,SOFORT,'invalid call'+EOL);
      Exit;
      END;
    IF v <> '' THEN
      IF NOT ValidCall(v) THEN
        BEGIN
        TX_SysInfo (pCB,SOFORT,'invalid via-path'+EOL);
        Exit;
        END;
    END;

  IF v = '' THEN AscCall2shift ( t, shZ )
	    ELSE AscCall2shift ( v, shZ );
  ifNr := 8; {* $TODO: what a hack *}
  IF AR_SearchRoute ( shZ, FALSE, ifnr,  v ) = 0 THEN ;
  {* Wenn kein Weg vorhanden, so den Einstieg  *}
  {* des Auffordernden waehlen, falls moeglich *}
  IF ifNr = 8 THEN {* nix gefunden *}
    IF axIFace[pCB^.iface].art = aUSER THEN ifNr := pCB^.iface
                                       ELSE ifNr := pCB^.aktIfnr;

  {* Nur auf dem Einstieg erlaubt, ausser bei Sysops und Hosts *}
  {* Ist wieder erlaubt - wem das nicht passt, soll   p cvConnect off  machen
   * IF (axIFace[ifnr].art <> aUSER) AND (pCB^.who<>SYSOP) AND (NOT fSystem) THEN
   *   BEGIN
   *   TX_SysInfo (pCB,SOFORT,'connect: nur auf einstiegen moeglich'+EOL);
   *   Exit;
   * END;
   *}

  IF fSystem  {* Linkaufbau? *}
    THEN pNewCB := Try2Connect ( ifnr, axIFace[ifnr].asMyCall+'-'+FStr(SSIDcvConnect), t, v, cINCSSID )
    ELSE pNewCB := Try2Connect ( ifnr, axIFace[ifnr].asMyCall, t, v, cNOINCSSID );

  IF pNewCB = NIL
    THEN BEGIN  {* Entweder out of mem oder QSO exitiert schon *}
	 Tx_SysInfo (pCB,SOFORT, 'sri, can''t connect'+EOL);
	 END
    ELSE BEGIN
         {$IFDEF vernetzt}
	 IF fSystem THEN pNewCB^.fMsgHandler := fMsgConnectHost
                    ELSE
         {$ENDIF}
                        pNewCB^.fMsgHandler := fMsgCvConnectTry;
	 pNewCB^.pPartnerCB := pCB;
	 pCB^.pPartnerCB := pNewCB;
	 sArg := {*** }'connect setup... to '+t;
	 IF v <> '' THEN sArg := sArg + ' via '+ v ;
	 sArg := sArg + '  (Port '+FStr(pCB^.pPartnerCB^.iface)+')'+EOL;
	 Tx_SysInfo (pCB,SOFORT, sArg );
	 END;
END;


{}

{$IFDEF vernetzt}


PROCEDURE HOST_Host (sArg : STRING; pNachbarCB : tp_axcb);
{* analysiert und fhrt "/#$FF#$80HOST <hostname> <soft> <features> " aus *}
  VAR sHostname,sZwisp : STRING;
      pCv : TP_cv;
  VAR pl : tp_cv;
BEGIN
  IF pNachbarCB^.pCv^.typ = cvLINK THEN
    BEGIN  {* Bestehender Link! -> ConversReset *}
    DoDisconnect(pNachbarCB); {*$OPT das kann man geschickter machen: z.B: nur im CONV alles neu init. *}
    Exit;
    END;
  IF pNachbarCB^.pCv^.typ <> cvLINKINIT THEN Exit; {* Es muss ein Berechtigter sein *}
  ScanForText(sArg,sHostName);
  IF sHostName = '' THEN Exit;
  {* $TODO: Suchen, ob es noch einen anderen Host mit           *}
  {* gleichen namen gibtwenn ja abschmeissen (inkl. aller User) *}
  WITH pNachbarCB^.pCv^ DO
    BEGIN {* Antworten auf das Host Kommando *}
    typ := cvLINK;
    hostname := sHostName;
    sPersData := '(Host) '+sArg;
    {  SendeMeinenHostname(pNachbarCB, TRUE); {* Nur die Usernamen senden, sonst gibt es Endlosschleifen *}
    Name := 'HOST:'+f_lower(f_sh2Asc(pCB^.toCall));
    TX_Info( pCB, SOFORT,'/'#$ff#$80'HOST '
                         +axIFace[1].asMyCall+
                         CONVVERSION {* Hier^muss ein Space sein; dies ist am Anfang der Constante vorhanden *}
                         +' amu '    {* Featuers: Away, Mode, UDAT *}
                         +EOL);

    {* ...und das sind meine Userlein: *}
    pl := pRootCv;  {* Schleife ber alle Leute in allen Konvers Kanlen *}
    WHILE pl <> Nil DO
      BEGIN
      IF ( (pl^.typ=cvUSER) OR (pl^.typ=cvREMOTEUSER) ) {* User und RemoteUser werden gemeldet *}
         AND ( pl^.pCB <> pCB ) THEN  {* Der Host, und alle User die darueber kommen, nicht weitergeben *}
	       TX_Info ( pCB, SOFORT, '/'#$ff#$80'USER '
                                      +pl^.name+' '
                                      +pl^.hostname
                                      +' 0 -1 '
				      +fStr(pl^.kanal)
				      +' '+pl^.sPersData
                                      +EOL);
      pl := pl^.next;
      END;
    { $TODO und alle Kanalinfos und Topics und Modi auch noch bertragen }
    END; {With}
END;




PROCEDURE HOST_User (sArg : STRING; pNachbarCB : tp_axcb);
{* analysiert und fhrt                                     *}
{*  /#$FF#$80USER <name> <hostname> 0 <altkanal> <neukanal> *}
{*  /#$FF#$80USER <name> <hostname> <zeit> <altkanal> <neukanal> <Name> *}
{* aus                                                      *}
  VAR p,pl,pSw : tp_cv;
      sName, sHost, sPers : STRING;
      lTime  : T_UnixTime;
      nZwisp,nAlt,nNeu : LongInt;
BEGIN
  ScanForText(sArg,sName);
  ScanForText(sArg,sHost);
  lTime := ScanForVal(sArg); { Unix-Zeit in Sekunden }
  nAlt  := ScanForVal(sArg); {* alter Kanal *}
  nNeu  := ScanForVal(sArg);
  sPers := sArg;
  LTrim(sPers);
  IF (nNeu>32767) OR (nNeu<0)
    THEN BEGIN  {* Remote ausloggen *}
	 pSW := SucheConversUser(sName,cREMOTE,pNachbarCB,nAlt);
	 IF pSW <> NiL THEN CloseConv(pSw, WHY_HOST_MSG, sPers);
	 END
    ELSE IF nAlt <> -1
	   THEN BEGIN {* Kanal wechseln *}
		pSW := SucheConversUser( sName, cREMOTE, pNachbarCB, nAlt );
		IF pSW = NiL THEN Exit; {* nicht gefunden *}
		pSW^.sPersData := sPers;
		IF nAlt=nNeu THEN Exit; {* Nur Namen setzen*}
		Switch (pSW, nNeu);
		END
	   ELSE BEGIN {* neuer User anmelden *}
		{* Loop-Detector nach DL9SAU:
		 * Wenn mir Nachbar2 jemanden auf HostX anmeldet und irgendjemand
		 * auf HostX bereits von Nachbar1 angemeldet worden ist (ungeachtet
		 * des Usernamens oder Kanals), so handelt es sich hier definitiv
		 * um einen loop.
		 * Wir leiten das /..USER Kommando an keinen unserer Nachbarn weiter
		 * und schliessen die converd connection mit Nachbar2, nachdem wir
		 * ihn ueber unsere Beweggruende informiert haben:
		 * /..LOOP <myhostname> <myneighbour> <host>
		 *}
		 IF DetermLoop (sHost, pNachbarCB) THEN
		   BEGIN {* Schleife entdeckt *}
		   {* Nachbar Informieren *}
		   sArg := '/'#$ff#$80'LOOP '
			     +axIFace[1].asMyCall+' '            {* Ich *}
			     +f_sh2Asc(pNachbarCB^.toCall)+' ' {* der Nachbar *}
			     +sHost;                           {* und der Auslser *}
		   TX_Info ( pNachbarCB, SOFORT, sArg  +EOL);
		   LogAddEntry ( pNachbarCB, leCONVERSDLOOP, sArg+' '+sName );   {* zur Auswertung isn Logbuch *}
		   CloseConv ( pNachbarCB^.pCv, WHY_LOOP_DETECT, '' ); {* Der AX25-Control-Block wurde gelscht *}
		   Exit; {* nix wie weg hier *}
		   END;
		{* $TODO erst nach nmlichen User suchen }
		MemGet ( Pointer(p), SizeOf (t_Cv) );
		EinhaengenRoot(p); {* Zeiger einhngen *}

		p^.typ       := cvREMOTEUSER;
	       {???nur wenn p kein Lokaler ist!??? }
		p^.sPersData := sPers;
		p^.Name      := f_Lower(sName);
		p^.HostName  := f_Lower(sHost);
		p^.time      := systime;
		p^.fAway     := FALSE;
		p^.fChOp     := FALSE;
		p^.pCB := pNachbarCB;  {* Zeiger auf Host-QSO *}
		p^.nByteTx := 0;
		p^.nBytePrivateTx := 0;

		p^.Kanal     := -1;
		Switch( p, nNeu );
		END;
END;


PROCEDURE HOST_CMsg (sArg : STRING; pNachbarCB : tp_axcb);
 {* analysiert und fhrt                       *}
 {*  /#$FF#$80CMSG <von-name> <kanalnr> <text> *}
 {* aus (Convers-Messages)                     *}
  VAR sFrom  : STRING;
      nKanal : WORD;
      pCv    : TP_cv;
BEGIN
  ScanForText(sArg,sFrom);
  nKanal := ScanForNum(sArg);
  IF (nKanal<0) OR (nKanal>32767) THEN Exit;
  {* Daten des Remote-Users (Absenders) holen *}
  pCV := SucheConversUser(sFrom,cREMOTE,pNachbarCB,nKanal);
  IF( pCV <> NiL )
   THEN SendCv( pCV, ALL, sArg+EOL)
   ELSE IF sFrom='conversd' THEN SendSysLocal( nKanal, sArg+EOL);
END;


PROCEDURE HOST_UMsg (sArg : STRING; pNachbarCB : tp_axcb);
 {* analysiert und fhrt *}
 {* "/#$FF#$80UMSG <fromname> <toname> <privattext>" *}
 {* aus (UserMessages)                               *}
  VAR sFrom,
      sTo    : STRING;
      nKanal : WORD;
      pCv    : TP_cv;
BEGIN
  ScanForText(sArg,sFrom);
  ScanForText(sArg,sTo);
  {* Absender suchen - er muss auch ber den richtigen Nachbarn kommen *}
  pCV := SucheConversUser( sFrom, cREMOTE, pNachbarCB, -1 );
  {* SendCv sendet den Text ggf. an andere Hosts weiter! *}
  IF( pCV <> NiL )
    THEN SendCv( pCV, PRIVAT, sTo+' '+sArg+EOL)
    ELSE IF sFrom='conversd' THEN
           BEGIN
           pCV := SucheConversUser( sTO, cALL, Nil, -1 );
           IF pCV <> nil THEN
             IF pCV^.typ = cvUSER THEN  TX_Info (pCV^.pCB,SOFORT, '*** '+sArg );
           END;
END;

PROCEDURE HOST_Mode (sArg : STRING; pNachbarCB : tp_axcb);
 {* analysiert und fhrt
  * /#$FF#$80MODE <kanalnr> <options>
  * aus.  +i invisible(no display in list)
  *       +l Local(no forward)
  *       +m moderated(only chops talk)
  *       +p private(need invitation)
  *       +s secret(no number)
  *       +t Topics nur von Chops
  *       +o<call> Wird Chop
  * z.B. MODE 1950 +odg9ep
  *      MODE 99 -sptiml+T
  *}
  VAR sOption,sCall,sZwisp : STRING;
      nKanal : WORD;
      pCv    : TP_cv;
      pc     : TP_CvChAttr;
BEGIN
{$IFDEF sdfsdf}
  nKanal := ScanForNum(sArg);
  IF (nKanal<0) OR (nKanal>32767) THEN Exit;
  pc := HandleChannel( nKanal, cADD );
  IF pc = nil THEN Exit;
  ScanForText(sArg,sOption);
  i := 0;
  WHILE i<length(sOption) DO
    BEGIN
    case upcase(sOption[i]) OF
     '-' : flag := FALSE;
     '+' : flag := TRUE;
     'P' : pc^.fPrivate := flag;
     'O' : IF Flag THEN
             BEGIN
             sZwisp := Copy( sOptions, i+1, 255);
             ScanForText(sZwisp,sCall);
             Inc(i,length(sCall);
             pCV := SucheConversUser(sCall,cALL,pNachbarCB,nKanal);
             END;
     END;
    i := i+1;
    END;
{$ENDIF}
END;


{$IFDEF destkram}
PROCEDURE HOST_Rout (sArg : STRING; pNachbarCB : tp_axcb);
 {* analysiert und fhrt *}
 {* "/#$FF#$80ROUT <dest> <user> <ttl" *}
 {* aus                              *}
  VAR sFrom,
      sTo    : STRING;
      nKanal : WORD;
      pCv    : TP_cv;
BEGIN
  ScanForText(sArg,sDest);
  ScanForText(sArg,sUser);
  ScanForVal(sArg,ttl);
  {* Suche User mit diesem Host. *}
  Wenn gefunden    Tx  UMSG conversd sUser *** Route mycall -> via -> sDest
                   ber den Via Link weitersenden
END;
{$ENDIF}
{$ENDIF}


PROCEDURE PrintInvite (pPartner:TP_AXCB; sFrom : STRING; channel:T_CvCh);
  VAR sWie : STRING [2];
BEGIN
  IF pPartner^.QSOType = qtConvers THEN sWie := '/'
				   ELSE sWie := 'C ';
  Tx_SysInfo ( pPartner, SOFORT, BELL
		      +'Message from '+sFrom
		      +' at '+UhrZeit(sysTime.hour,systime.min)+EOL
		      +'    please join convers channel '+FStr(channel)
		      +' (type "'+sWie+ fStr(channel)+'")'+EOL);
END;


PROCEDURE Invite ( pFromCB : TP_axcb; sTo : STRING);
{* pFromCB will sArg einladen.      *}
{* $OPT mit HOST_INVITE kombinieren *}
 VAR pPartner : TP_AXCB;
     pCV : tp_cv;
     s   : STRING;
BEGIN
 {* erst im Digi nachschauen *}
 SucheCallInDigi ( sTo, scmFREIER, pPartner );
 IF (pPartner <> NiL) AND (pPartner <> pFromCB)
   THEN	BEGIN {* lokal im Digi gefunden *}
        PrintInvite (pPartner, f_sh2asc(pFromCB^.toCall), pFromCB^.pCv^.kanal);
	Tx_SysInfo (pFromCB,SOFORT, 'invitation sent to '+sTo+EOL)  {* @ <host> *}
	END
   ELSE BEGIN
        {$IFDEF vernetzt}
        s := 'INVI ' + f_lower(f_sh2asc(pFromCB^.toCall)) + ' '
                     + sTo + ' '
		     + FStr(pFromCB^.pCv^.kanal)+EOL;
        pCv := SucheConversUser(sTo,cREMOTE,NiL,-1); {* berall suchen *}
        IF pCV <> NiL
	  THEN BEGIN {* nur an pCv^.pCB (remote) schicken *}
	       TX_Info ( pCv^.pCB, SOFORT, '/'#$ff#$80+s );
               END
	  ELSE BEGIN {* an alle HOSTs (Flooding) - irgendein Digi hat ihn vielleicht in der Infobox *}
	       SendHosts(Nil,s);
               END;
        {$ELSE}
        Tx_SysInfo (pFromCB,SOFORT, sTo+' not found'+EOL)
        {$ENDIf}
        END;
END;


{$IFDEF vernetzt}
PROCEDURE HOST_Invi (sArg : STRING; pNachbarCB : tp_axcb);
{* analysiert und fhrt "/#$FF#$80INVI <fromname> <toname> <kanal> aus *}
{* $TODO:  INVITE aufrufen, anstatt alles nochmal zu machen. *}
  VAR sFrom,
      sOrgArg,
      sTo    : STRING;
      nKanal : WORD;
      pCv    : TP_cv;
 VAR pPartner : TP_AXCB;
BEGIN
  sOrgArg := sArg;
  ScanForText(sArg,sFrom);
  ScanForText(sArg,sTo);
  nKanal := ScanForNum (sArg);
  IF nKanal > 32767 THEN Exit;
  SucheCallInDigi ( sTo, scmFREIER, pPartner );
  IF (pPartner <> NiL)
   THEN	BEGIN {* Gefunden *}
	{* Msg. an Einzuladenden *}
	PrintInvite (pPartner, sFrom, nKanal);
	{* Und besttigung zurck an den Orginator *}
	TX_Info (pNachbarCB, SPAETER,'/'#$FF#$80'UMSG conversd '+
		    sFrom+' *** invitation send to '+sTo +' @ '+axIFace[1].asMyCall+EOL);
	END
   ELSE BEGIN {* nicht gefunden: Weiterverteilen an alle Host ausser dem Orginator *}
	{* $TODO: Erstmal in der Remoteliste nachschauen? *}
	SendHosts(pNachbarCB, {* An den wird es NICHT gesendet *}
		  'INVI '+sOrgArg);
	END;
END;

PROCEDURE HOST_Away (sArg : STRING; pNachbarCB : tp_axcb);
{* analysiert und fhrt "/#$FF#$80AWAY <user> <Host> <channel> <time> [Text]" aus *}
{* kein Text ---> der jenige ist wieder da *}
  VAR sOrgArg,
      sHost,
      sUser  : STRING;
      lTime  : T_UnixTime;
      nKanal : WORD;
      pCv    : TP_cv;
BEGIN
  sOrgArg := sArg;
  ScanForText(sArg, sUser);
  ScanForText(sArg, sHost);
  nKanal := ScanForNum (sArg);
  IF nKanal > 32767 THEN Exit;
  lTime := ScanForVal (sArg);
  pCV := SucheConversUser( sUser, cREMOTE, pNachbarCB, nKanal );
  {* Weiterverteilen an alle Host ausser dem Orginator *}
  IF (pCV <> NiL) {and (Time > lastAwayTime) }
   THEN	BEGIN {* Gefunden *}
	pCv^.fAway := sArg='';
	SendHosts(pNachbarCB, {* An den wird es NICHT gesendet *}
		   'AWAY '+sOrgArg);
	END
END;

PROCEDURE HOST_Topi (sArg : STRING; pNachbarCB : tp_axcb);
{* "/#$FF#$80TOPI <user> <Host> <time> <channel> [Text] *}
  VAR sOrgArg,
      sUser,
      sHost  : STRING;
      lTime  : T_UnixTime;
      nKanal : WORD;
      pc     : TP_CvChAttr;
BEGIN
  sOrgArg := sArg;
  ScanForText(sArg,sUser);
  ScanForText(sArg,sHost);
  lTime := ScanForVal (sArg);
  nKanal:= ScanForNum (sArg);

  {* Tpic Lokal setzen *}
  pc := HandleChannel( nkanal, cADD );
  IF pc<> nil THEN {* Kanal existiert *}
   IF (lTime > pc^.tlTopic)
     THEN BEGIN{* das Topic ist wirklich neuer *}
          pc^.Topic := sArg;
          pc^.tlTopic := lTime;
          SendSysLocal ( nkanal, sUser+': topic now: '+sArg );
          {* Weiterverteilen an alle Host ausser dem Orginator *}
          SendHosts(pNachbarCB, {* An den wird es NICHT gesendet *}
	            'TOPI '+sOrgArg);
          END
     ELSE BEGIN
{* "/#$FF#$80TOPI <user> <Host> <time> <channel> [Text] *}
          {* $TODO eigenes Topic an alle senden! *}
{          SendHosts(nil, 'TOPI conversd '+mycall+pc^.tlTopic +pc^.channel + pc^.topic); }
          END;
END;
{$ENDIF}

{}


 CONST  COMMANDS =
{01..10} 'CHANNEL INVITE HILFE HELP ? WHO SEND MSG TALK BYE '+
{11..19} 'EXIT QUIT WRITE USERS CONNECT D FORCE EXCLUDE AWAY ' +
{20..29} 'ME ACTION NAMES USAGE LIST IMSG PERSONAL NICK LINKS TOPIC CHOP '+
         'PRIVATE PUBLIC XCONNECT BAYCOM ANSI BELL CONHOST DISCONNECT '+
         'FILTER ';

PROCEDURE Help ( pCB : tp_axcb );
BEGIN
  IF NOT ReadTxt( pCB, 'CVHELP', rtDEFAULT ) THEN
      TX_EOLSysInfo(pCB, SOFORT,
                    'Availble commands (start with / e.g. /LIST):'+EOL+
                   + COMMANDS + EOL );
  DoPrompt (pCB);
END;


PROCEDURE ConversMain  ( pCB : tp_axcb );
 CONST cmCHANNEL=1;      cmINVITE=2;    cmHILFE=3;     cmHELP=4;
       cmQUESTIONMARK=5; cmWHO=6;       cmSEND=7;      cmMSG=8;
       cmTALK=9;         cmBYE=10;      cmEXIT=11;     cmQUIT=12;
       cmWRITE=13;       cmUSER=14;     cmCONNECT=15;  cmD=16;
       cmFORCE=17;       cmEXCLUDE=18;  cmAWAY=19;     cmME=20;
       cmACTION=21;      cmNAMES=22;    cmUSAGE=23;    cmLIST=24;
       cmIMSG=25;        cmPERSONAL=26; cmNICK=27;     cmLINKS=28;
       cmTOPIC=29;       cmCHOP=30;     cmPRIVATE=31;  cmPUBLIC=32;
       cmXCONNECT=33;    cmBAYCOM=34;   cmANSI=35;     cmBELL=36;
       cmCONHOST=37;     cmDISCONNECT=38;
       cmFILTER=39;
{$IFDEF vernetzt}
 NETCOMMANDS =  {* Hier drfen nur Befehle rein, die ein #$FF am Anfang haben *}
         +#$FF#$80'HOST '    +#$FF#$80'CMSG '     +#$FF#$80'INVI '
         +#$FF#$80'UMSG '    +#$FF#$80'USER '     +#$FF#$80'LOOP '
	 +#$FF#$80'AWAY '    +#$FF#$80'PING '     +#$FF#$80'TOPI '
         +#$FF#$80'MODE '
         ;
         {* Leerzeichen immer am Ende *}

	 cmH_host=1;       cmH_cmsg=2;       cmH_invi=3;
	 cmH_umsg=4;       cmH_user=5;       cmH_loop=6;
	 cmH_AWAY=7;       cmH_PING=8;       cmH_TOPIC=9;
         cmH_MODE=10;
{$ENDIF}

     cmdTab    : ARRAY [1..length(COMMANDS)] OF CHAR=COMMANDS;
     netcmdTab : ARRAY [1..length(netCOMMANDS)] OF CHAR=NEtCOMMANDS;
 VAR info,
     sArg,
     sZwisp,
     sZwisp2   : STRING;
     fehler,
     iZwisp    : INTEGER;
     i         : BYTE;
     befehl    : WORD;
{     fHilf     : BOOLEAN; }
     pCV2,
     pCBpCv    : tp_cv;
     pc        : TP_CvChAttr;
 LABEL l_nextLine; {* Goto is bersichtlicher als ifThenElse orgien *}
BEGIN
  pCBpCv := pCB^.pCv;
  Info := FrameInfo2String_CR (pCB);
  WHILE (info <> '') AND (pCB^.pCv <> NiL) DO
    {* Das "ungleich NIL" ist wichtig, da /QUIT und /SHoot ja einen *}
    {* rauswerfen koenen, und trotzdem wuerde sonst die naechste Zeile *}
    {* geholt, und die schreibt dann in den NIL-Pointer pCV usw *}
    BEGIN
    WatchDog;
    IF info[1]='!'
      THEN BEGIN
	   backup.Last_Cmd := f_sh2ASC(pCB^.toCall)+'-C!:'+ Info;
           sArg := Copy (info,2,255);
           InfoBox_interpreter (pCB, CONV, sArg)
           END
    ELSE IF Info[1] = '/'  {* Convers-Befehl *}
      THEN BEGIN
           backup.Last_Cmd := f_sh2ASC(pCB^.toCall)+'*C:'+Info;
	   RTrim (Info);
           WHILE (Length(Info)>0) AND ( Info [Length(Info)] < #32 ) DO Dec(Byte(Info[0]));
           iZwisp := Pos (' ',Info);
	   IF iZwisp = 0 THEN sArg := ''
			 ELSE sArg := Copy ( Info, iZwisp, 255);
	   WHILE (Length(sArg) > 0) AND (sArg[1]=' ') DO Delete (sArg,1,1);
	   WHILE F_Replace (^H,'',sArg) DO; {*^H entfernen *}
	   {$IFOPT R+} {$DEFINE  rplus} {$R-} {$ENDIF}
	   Val (sArg, iZwisp, Fehler);
	   {$IFDEF rplus} {$R+} {$UNDEF rplus} {$ENDIF}
	   sZwisp := Copy (info, 2,255);
           IF sZwisp[1] = #$FF
	     THEN BEGIN
		  befehl := ScanStr ( sZwisp, @netcmdTab, SizeOf (netcmdTab) );
                  IF (befehl = cmH_HOST)
                    THEN HOST_Host(sArg, pCB)  {* Namen wegspeichern, ggf.antwortrn *}
                    ELSE BEGIN
                         IF pCBpCv^.typ <> cvLINK THEN Goto l_nextLine;
		         CASE befehl OF
		         {$IFDEF vernetzt}
		             cmH_user : HOST_User(sArg, pCB);  {* Anmelden von RemoteUsern *}
		             cmH_cmsg : HOST_CMsg(sArg, pCB);  {* sendcv *}
		             cmH_umsg : HOST_UMsg(sArg, pCB);  {* User-sendcv *}
		             cmH_AWAY : HOST_AWAY(sArg, pCB);
		             cmH_PING : IF pCB^.pCv^.typ=cvLINK THEN {* Wir machen kein PingPong *}
				          TX_Info (pCB^.pCV^.pCB,SOFORT, '/'#$FF#$80'PONG -1'+EOL);
		             cmH_TOPIC: HOST_Topi(sArg, pCB);
                             cmH_MODE : HOST_Mode(sArg, pCB);
		             cmH_INVI : HOST_Invi(sArg, pCB);  {* invite *}
		             cmH_loop : {* Nachbar hat einen Loop entdeckt, ins Log eintragen *}
				        {* Inhalt: Meldener Host,                       *
				         *         Nachbar_Host_der_die_Schleife_baute, *
				         *         Host der ber /..USER gemeldet wurde, woraufhin die Schleife enteckt wurde
				         *}
				        LogAddEntry ( pCB, leCONVERSDLOOP, sArg );
	                {$ENDIF}
		           END {case}
                        END;
		  END
	     ELSE BEGIN
		  befehl := ScanStr ( sZwisp, @cmdTab, SizeOf (cmdTab) );
		  CASE befehl OF
		      cmSEND,
		      cmMSG,
		      cmTALK,
		      cmWRITE
		       : SendCv ( pCBpCv, PRIVAT, sArg );

		      cmWHO,
		      cmUSER,
		      cmUSAGE
		       : BEGIN
			 IF (fehler = 0) {* Das Argument ist eine Nr. *}
			   THEN ListCvUser (pCB, iZwisp, '', cLANG, TRUE{TOPIC})
			   ELSE IF Pos('*',sArg)>0
				  THEN ListChannels (pCB, TRUE{nurlebende}, TRUE {mitUser})
				  ELSE ListCvUser (pCB, -1, sArg, cLANG, FALSE{TOPIC});
			 END;

		      cmNAMES
		       : BEGIN
			 IF (fehler = 0) {* Das Argument ist eine Nr. *}
			  THEN ListCvUser (pCB, iZwisp, '', cPERSONAL,TRUE{TOPIC}) {* Alle auf dem Kanal *}
                          ELSE ListCvUser (pCB, -1, sArg, cPERSONAL,FALSE{TOPIC}); {* Alle, berall *}
			 Tx_SysInfo (pCB, SOFORT, 'Weitere Angaben mit /WHO und /LIST; Namen setzen mit /PERSONAL'+EOL);
			 END;

                      cmCHANNEL
		       : IF (Fehler <> 0) OR (iZwisp > 32767) OR ( iZwisp < 0 ) {* CHANNEL *}
			   THEN TX_SysInfo (pCB, SOFORT, 'you are on channel '+fStr(pCBpCv^.Kanal)+EOL)
			   ELSE Switch (pCBpCv, iZwisp);

                      cmLINKS
                       : ListCvUser (pCB, 0, cLINKSTRING, cLANG,FALSE{TOPIC});

		      cmINVITE
                       : Invite (pCB, sArg );

                      cmHILFE, cmHELP,  cmQUESTIONMARK
		       : Help (pCB);

		      cmXCONNECT, {* wg. SNET *}
                      cmCONNECT
		       : CvConnect (pCB, sArg, FALSE);

		      cmD
		       : BEGIN
			 Tx_SysInfo (pCB, SOFORT, 'Zweideutig! /DISC fr vollstaendiges Disconnecten; /DEST gibt es (noch) nicht'+EOL);
			 END;

                      cmDISCONNECT
		       : CloseConv (pCBpCv, WHY_TYPED_DISC, '');

		      cmFORCE
		       : Force (pCB, sArg);

		      cmIMSG,
		      cmEXCLUDE
		       : SendCv ( pCBpCv, EXCLUDE, sArg );

		      cmBYE, cmEXIT, cmQUIT
		       : CloseConv (pCBpCv,WHY_TYPED_QUIT, '');

		      cmAWAY
		       : BEGIN
			 WHILE F_Replace (^H,'',sArg) DO; {*^H entfernen *}
			 pCBpCv^.fAway := NOT pCBpCv^.fAway;
			 IF pCBpCv^.fAway
			   THEN sZwisp2 := 'has gone away: '+sArg
			   ELSE BEGIN
				sZwisp2 := 'is back again';
				sArg := '';
				END;
			 SendCv(pCBpCv, SYSALL, sZwisp2);
			 TX_SysInfo ( pCB, SOFORT, UhrZeit(sysTime.Hour,SysTime.Min)+' *** '+sZwisp2+EOL);
			 SendHosts( pCB, 'AWAY '
					 +pCBpCv^.name+' '
					 +pCBpCv^.hostname+' '
					 +fStr(pCBpCv^.Kanal)+' '
					 +'0 ' {time!}
					 +sArg);
			 END;

		      cmPERSONAL,
		      cmNICK
		       : BEGIN
			 IF sZwisp = '' THEN sZwisp := '@';
			 pCBpCv^.sPersData := sZwisp;
			 SendCv(pCBpCv, SYSALL, 'set name: '+sZwisp); {* Sysall geht nich auf cvlink raus! *}
			 {$IFDEF vernetzt}
			 SendHosts( NiL, 'USER '+pCBpCV^.name+' '
						+pCBpCv^.hostname+' '
						+' 0'
						+' '+fStr(pCBpCv^.Kanal)
						+' '+fStr(pCBpCv^.Kanal)
						+' '+sZwisp
						);
			 {$ENDIF vernetzt}
			 END;

       {$IFDEF ChanStuff}
		      cmCHOP
		       : IF pCBpCv^.fChOp THEN
			   BEGIN {* Suche den Conversuser im Argument *}
			   pCV2 := SucheConversUser( sZwisp, cALL, NiL, pCBpCV^.Kanal );
			   IF pCV2 <> NiL THEN
			     BEGIN
			     pCV2^.fChOp := TRUE;
			     SendHosts( pCB, 'MODE '+FStr(pCV2^.kanal)+' +o'+pCV2^.name );
			     END;
			   END;

                      cmPRIVATE,
		      cmPUBLIC
		       : IF pCBpCv^.fChOp THEN
			   BEGIN
			   pc := HandleChannel( pCBpCV^.kanal, cADD );
			   pc^.fPrivate := (befehl=cmPRIVATE);
			   END;

		      cmTOPIC
		       : BEGIN
			 IF pCBpCv^.fChOp THEN
			   BEGIN
			   pc := HandleChannel( pCBpCV^.kanal, cADD );
			   pc^.Topic := sArg;
			   pc^.tlTopic := UnixZeitNow;
			   {* <user> <Host> <time> <channel> [Text] *}
			   SendHosts( NiL, 'TOPI ' {* An alle Nachbarn! Denn es wurde Lokal gesetzt *}
					   + pCBpCV^.name + ' '
					   + pCBpCv^.hostname + ' '
					   + fStr(pc^.tlTopic)+' '
                                           + fStr(pCBpCv^.Kanal)+' '
					   + sArg );
			   SendCv(pCBpCv, SYSALL, 'topic now: '+sArg); {Sysall geht nich auf cvlink raus!}
			   END;
			 END;

		      cmLIST
		       : ListChannels (pCB, pos ('*',sARG) = 0, pos ('#',sARG) = 0 );
       {$ENDIF}

		      cmME,
		      cmACTION
		       : BEGIN
			 WHILE F_Replace (^H,'',sArg) DO; {*^H entfernen *}
			 SendSysLocal (pCBpCv^.kanal, pCBpCv^.Name+' '+sArg );
                         {*$TODO: Erst abprfen: ob auch ein Remote auf dem Kanal ist *}
			 SendHosts(pCB, 'CMSG conversd '
					+fStr(pCBpCv^.kanal)
					+' '+pCBpCv^.Name
					+' '+sArg);
			 END;

		      cmBAYCOM
		       : BEGIN
                         pCBpCv^.fBayStyle := NOT pCBpCv^.fBayStyle;
                         TX_SysInfo (pCB, SOFORT, 'alternate layout now '+f_Bool2OnOff(pCBpCv^.fBayStyle)+EOL)
                         END;

                      cmFILTER
                       : BEGIN {*$TODO}
                         sArg := f_Upper(sArg);
			 IF sArg <> '' THEN
                           IF sArg='OFF' THEN pCBpCV^.sFilter := ''
                                         ELSE pCBpCv^.sFilter := sArg+' ';
                                         {* Wg. dem Vergleich muss hinten immer ein ' ' stehen! ' *}
                         IF pCBpCv^.sFilter = '' THEN sArg := 'is off'
                                                 ELSE sArg := pCBpCv^.sFilter;
                         TX_SysInfo (pCB, SOFORT, 'Filter '+sArg+EOL);
                         END;
                      cmANSI
                       : BEGIN {*$TODO}
			 IF sArg = ''
                           THEN TX_SysInfo (pCB, SPAETER, 'z.B. /ANSI 31;46'+EOL)
                           ELSE pCBpCv^.sANSI := sArg;
                         TX_SysInfo (pCB, SOFORT, 'ANSI color string is:'+pCBpCv^.sANSI+EOL);
                         END;
                      cmBELL
                       : BEGIN
			 pCBpCv^.fBELL := NOT pCBpCv^.fBELL;
			 IF pCBpCv^.fBELL THEN sZwisp := 'Wau Wau!'
                                          ELSE sZwisp := 'psssst';
                         TX_SysInfo (pCB, SOFORT, sZwisp+EOL);
			 END;
		      cmCONHOST
                       : CvConnect (pCB, sArg, TRUE);


                 ELSE BEGIN {* Untersuche ob sZwisp eine Zahl enthlt, *}
                            {* wenn ja Kanal wechseln, also /6666 z.B. *}
                      ScanForText (sZwisp,sArg); {* erstes Wort AUS sZwisp nach sArg*}
                      {* wenn nein Test ob Rufzeichen, wenn ja msg schicken *}
                      {$IFOPT R+} {$DEFINE  rplus} {$R-} {$ENDIF}
                      Val (sArg, iZwisp, Fehler);
                      {$IFDEF rplus} {$R+} {$UNDEF rplus} {$ENDIF}
                      IF (Fehler = 0) AND ( iZwisp <= 32767) AND ( iZwisp > 0 ) {* CHANNEL *}
                         THEN Switch (pCBpCv, iZwisp)
                         {* nein: Annehmen das das ein Rufzeichen ist, MSG schicken *}
                         ELSE IF ValidCall( sArg )
				THEN SendCv ( pCBpCv, PRIVAT, sArg + ' ' + sZwisp )
                                ELSE IF pCBpCv^.typ=cvUSER THEN Tx_SysInfo (pCB, SOFORT,
                                      'invalid convers command and no callsign, /HELP for information' + EOL );
                      END;
		   END;
                 END; {* IF netbefehl *}
	   END

      ELSE IF pCBpCv^.fAway THEN Tx_SysInfo (pCB, SOFORT,
                                 'NO! You are still marked as being away' + EOL )
                            ELSE SendCv (pCBpCv, ALL, info);
l_nextLine:
    Info := FrameInfo2String_CR (pCB); {* Nchste Zeile aus Rx-Buffer holen *}
    END; {While}
END;


{$F+}
PROCEDURE fMainConv  ( pCB : tp_axcb; msg : T_Msg );
  VAR pCBpCv    : tp_cv;
BEGIN
  pCBpCv := pCB^.pCv;
  CASE msg OF
    msgRx      : ConversMain(pCB);
    msgRetryCountExceeded
	       : CloseConv (pCBpCv,WHY_LINK_FAIL, '');
    msgDiscReq : CloseConv (pCBpCv,WHY_DISC_REQ, '');  {* ein DisconectRequest traf ein *}
    msgCBDel   : CloseConv (pCBpCv,WHY_CB_INVALID, '');
    msgReconnect
               :
                 SendCv (pCBpCV, SYSALL,' reconnected' );

    ELSE fnMsgDefault( pCB, msg );
    END; {case}
END; {$IFNDEF AllFar} {$F-} {$ENDIF}

{}


PROCEDURE CloseConv (pDelCv : tp_cv;
		     why : t_why;
		     {$IFDEF ver70} CONST {$ENDIF} sWhy : STRING );
 VAR p, pZ, pPrev : tp_cv;
     pCB : TP_AXCB;
     s{sWhyHostDown}: String;
BEGIN
  WatchDog;
  IF pDelCv = NiL THEN Exit;{* "Mrs.Ruthledge wollte mich gar nicht sprechen" *}
			    {* - "Tut mir leid, Sir; ich mache oft Fehler"    *}
  pCB := pDelCv^.pCB;
  IF pCB = Nil THEN Exit;
  CASE why OF
      WHY_LINK_FAIL  : s := 'Link failure' ; {* DISCReq oder RetryCount Exceeded *}
      WHY_TYPED_QUIT : s := '/QUIT';         {* Befehl /q wurde gegeben *}
      WHY_TYPED_DISC : s := '/DISC';         {* Befehl /Disconnect *}
      WHY_DISC_REQ   : s := 'ax.25-DISC received' ;
      WHY_CB_INVALID : s := 'DISC received' ;{'Link has been deleted'}
{$IFDEF vernetzt}
      WHY_HOST_MSG   : s := sWhy; {* Msg. vom Host, dass User sich ausloggte *}
      WHY_HOST_DOWN  : s := 'Host link failure';
      WHY_LOOP_DETECT: s := 'Host Linkloop @ '+pDelCv^.hostname;
{$ENDIF}
      ELSE s := ''
     END;
  SendCv (pDelCv, SYSALL,'LOGOUT (@ '+pDelCv^.hostname+' '+s+')');
  SetzeKanal (pDelCv, pDelCv^.kanal, -1);
{$IFDEF vernetzt}
  SendHosts( pCB, 'USER '+pDelCv^.name+' '
			 +pDelCv^.hostname+' '
			 +'0 '
			 +fStr(pDelCv^.Kanal)
			 +' -1 '+s);
  IF pDelCv^.typ = cvLINK THEN
    BEGIN {* Host down *}
    {sWhyHostDown := myCall}
    p := pRootCv;  {* Schleife ueber alle Leute in allen Konvers Kanlen *}
    WHILE p <> Nil DO
      BEGIN
      {sWhyHostDown := Host-QSO 'myCall'<->'down: sWhy}
      pz := p^.next;
      IF (p^.typ = cvREMOTEUSER) AND (p^.pCB = pCB) THEN
	BEGIN {* Alle zugeh. User sind natrlich auch kaputt *}
	CloseConv( p, WHY_HOST_DOWN, '' { sWhyHostDown } ); {* Hallo Rekursion... *}
        {sWhyHostDown := '(s.o.)'; { braucht nicht mehrfach ausgegeben werden! }
	{* ACHTUNG! Hier kann p^ schon ungltig sein (bzw. p = NiL) *}
	END;
      p := pz;
      END;
    END;
{$ENDIF}
  IF pDelCv^.typ <> cvREMOTEUSER THEN
    BEGIN
    pCB^.QsoType := qtNULLQSO;
    IF pCB^.pCv = Nil THEN Exit;
    END;

  {* Aushngen aus der Konvers-Kette *}
  p := pRootCv;
  pPrev := NiL; {* Nachlaufzeiger *}
  WHILE (p <> NiL) DO
    BEGIN
    IF (p = pDelCv)
      THEN BEGIN
	   IF pPrev = NiL THEN pRootCv := pDelCv^.next
                          ELSE pPrev^.next := pDelCv^.next;
           p := NiL; {* Abbbrechen *}
           END
      ELSE BEGIN
           pPrev := p;
           p := p^.next;
           END;
    END;

  IF pDelCv^.typ <> cvREMOTEUSER THEN
    BEGIN
    pCB^.pCv := NiL;
    pCB^.fMsgHandler := fnMsgDefault;
    END;

  CASE why OF
      WHY_LINK_FAIL  : ; {* RetryCount Exceeded *}
      WHY_TYPED_QUIT : BEGIN  {* Befehl /q wurde gegeben: Rckkehr in Infobox *}
                       pCB^.fMsgHandler := fnMsgInfoBox;
                       pCB^.QSOType := qtInfoBox;
                       DoPrompt (pCB);
                       END;
      WHY_TYPED_DISC,
      WHY_LOOP_DETECT : DoQuit (pCB); {* Disconnect auslsen *}
      ELSE           ; {* Hier ist der Disc. schon vollzogen *}
  END;
  MemFree ( pointer(pDelCv), SizeOf (pDelCv^) );
END;



PROCEDURE OpenConv (pCB : tp_Axcb; StartKanal : longint );
  VAR pNewCv: tp_cv;
BEGIN
  {$IFDEF display}
  cc_disp.clr_disp;     Write(DISP,'Conv: ',f_sh2asc(pCB^.tocall));
  cc_disp.Gotoxy(1,2);  Write(DISP,'at ',CurrentUhrzeit(0));
  {$ENDIF}

  IF pCB^.pCv <> NiL THEN Exit;  {* Zweimal ffnen ist nicht *}
  IF pCB^.pInfoBox <> NiL THEN StopTimer (pCB^.tTimeOut);

  MemGet ( Pointer(pCB^.pCv), SizeOf (pCB^.pCv^) );
  pNewCv := pCB^.pCv;
  {* Zeiger einhngen: *}
  EinhaengenRoot (pNewCv);

  {* s.a. in HOST_User *}
  pNewCv^.nByteTx := 0;
  pNewCv^.nBytePrivateTx := 0;
  pNewCv^.Name := f_lower(f_sh2ascOhneSSID(pCB^.toCall));
  pNewCv^.sPersData := ''; { $TODO ax25-Einstieg angeben ' AX-uplink'+sh2Asc(pcb[ndigi[...]] }
  pNewCv^.time := systime;
  pNewCv^.fBayStyle := FALSE;
  pNewCv^.sANSI := '';
  pNewCv^.sFilter := '';
  pNewCv^.fBell := FALSE;
  pNewCv^.fAway := FALSE;
  pNewCv^.fChOp := FALSE;
  pNewCv^.pCB := pCB;  {* so'ne Art self-Parameter *}
  pCB^.QSOType := qtConvers;
  pCB^.fMsgHandler := fMainConv;

  {$IFDEF vernetzt}
  pNewCv^.typ := cvUSER; {* Bis zum Beweis des Gegentelis *}
  IF (startKanal=32768) OR (Pos(f_sh2asc(pCB^.toCall)+' ',cvLINKCALL) > 0)
    THEN BEGIN {* Goooooooooood morning, Host *}
         pNewCv^.typ := cvLINKINIT; {* Bis zum Beweis des Gegentelis *}
         SetzeKanal(pNewCv,-1,0); {* immer; und ber diese Proc, sonst stimmen die Zhler nich mehr *}
         pNewCv^.sPersData := '(Host in spe...)';
         {* und nun gar nix mehr tuen. Nur warten *}
         {* bis der andere sein /..HOST  schickt *}
	 END
    ELSE
  {$ENDIF}
	BEGIN {* schnder NormalUser *}
	{* Sicherheitshalber "normieren" *}
	IF (startKanal >= 32768) OR (startKanal < 0) THEN StartKanal := 0;
	pNewCv^.HostName := f_lower(axIFace[1].asMyCall);
	IF NOT ChannelPermit(pNewCv,startKanal) THEN StartKanal := 0;
	SetzeKanal(pNewCv,-1,startKanal);
	{* strahle Connect Text aus *}
	TX_Info (pCB, SPAETER, EOL +
	 {$IFDEF vernetzt}
	 'plitsch-platsch convers @ '+axIFace[1].asMyCall+' (DigiWare)'+EOL+
	 {$ELSE}
	 'plain convers (NO conversD)!'+EOL+
	 {$ENDIF}
	 'Welcome to convers channel '+fStr(pNewCv^.Kanal)+'  Type /HELP for help; /QUIT to leave'+EOL);

	IF pNewCv^.kanal = 0 THEN TX_Info (pCB, SPAETER,
		  '            **! This is channel 0: meeting point only!**'+EOL+
		  'Change channel with "/ch <channelno.>" or "/<channelnr>"'+EOL+
                  'Or go direct from the digi-prompt to the channel with "CONV <channelnr>"'+EOL);
	ListCvUser( pCB, pNewCv^.kanal, '', cKURZ, TRUE{TOPIC} );
	Tx_Trigger(pCB);
	SendCv(pCB^.pCv, SYSALL, 'LOGON (local)');
	{$IFDEF vernetzt}
	SendHosts(pCB, 'USER '
		       +pNewCv^.name+' '
		       +pNewCv^.hostname
		       +' 0 -1 '
                       +fStr(pNewCv^.kanal)
                       );
        {$ENDIF}
        END;
END;

{}

FUNCTION DoTalk ( pCB : TP_axcb; arg : STRING ) : BOOLEAN;
 VAR s        : String;
     i        : WORD;
     pPartner : tp_AXCB;
     pCV      : TP_CV;
BEGIN
  DoTalk := FALSE;
  i := Pos (' ',arg);       {* Suche Argumenttrennzeichen *}
  IF i = 0 THEN Exit;       {* Kein Call *}
  s := Copy (arg, i, 255);  {* lse Message heraus *}
  arg := Copy (arg, 1, i);  {* lse Call heraus *}
  WHILE F_Replace (^H,'',Arg) DO; {*^H entfernen *}

  IF arg = '' THEN Exit;    {* Kein Text *}
  s := '*'+f_sh2asc(pCB^.toCall)+'*:'+s;
  SucheCallInDigi ( arg, scmFREIER, pPartner );
  IF pPartner = NiL
    THEN BEGIN
         pCV := SucheConversUser( arg, cREMOTE, NiL {*in allen Hosts*},-1 {*auf allen Kanlen*});
         IF pCV <> NiL THEN
           BEGIN
           DoTalk := TRUE;
           TX_ConversD ( pCV,'InfoBox User at '+axIFace[1].asMyCall+' '+ s+EOL);
           END;
	 END
    ELSE BEGIN
         TX_Info(pPartner,SOFORT,EOL+s+EOL);
         DoTalk := TRUE;
         END;
END;


PROCEDURE DoEveryMinuteConvers;
  VAR s : STRING;
BEGIN
  IF Systime.Min = 0 THEN
    BEGIN {* Jede volle Stunde *}
    s := {*** }'Es ist '+UhrZeit(sysTime.hour,systime.min)
               {$IFDEF DCF} +' '+sZeitZone {$ENDIF}  +' ***';

    IF systime.hour = 0 THEN
      BEGIN {* Mitternacht *}
      IF (systime.day=1) AND (systime.month=1)
	THEN s := s + BELL+BELL+' Prost Neujahr !****** uuuuuiiiiii krach bummm *******'
	ELSE s := s + BELL+BELL+' Guten Morgen ***';
	{* fehlt nur noch Halloween + Walters Burtstag... *}
      END;
    SendSysLocal(-1,s); {* Auf allen Kanlen ausgeben *}
{$IFDEF ChanStuff}
    RemoveChannels(12); {* Alles was lter als 12h ist *}
{$ENDIF}
    END;
  {$IFDEF vernetzt}
  {*$TODO: Test ob ein Conv-Host automatisch connected werden muss *}
  {* Kriterium: Erreichbar ROUTER!, Kein LOOP(?!), Etwas Zeitlicher Abstand zum letzten Connect... *}
  {$ENDIF}
END;


{$IFnDEF vernetzt}
BEGIN
  cvLINKCALL := '';
{$ENDIF}
END.












